List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Tank Model Simulation", "Title"], Cell[CellGroupData[List[Cell["Flat Tank Model (without any components)", "Section"], Cell["function LimitValue\n  input Real pMin;\n  input Real pMax;\n  input Real p;\n  output Real pLim;\nalgorithm\n  pLim := if p>pMax then pMax\n          else if p<pMin then pMin \n          else p;\nend LimitValue;", "ModelicaInput"], Cell["", "Text"], Cell["model FlatTank\n  //tank related variables and parameters\n  Real  act;  // Connector, actuator controlling input flow  \n  parameter Real flowVout =0.02; //[m3/s]\n  parameter Real area =0.5;      //[m2]\n  parameter Real flowGain =10;   //[m2/s]\n  Real h(start=0);    //tank level [m]\n  Real qIn;  // flow through input valve[m3/s]\n  Real qOut; // flow through output valve[m3/s]\n  \n  //controler related variables and parameters\n  parameter Real Ts=0.1;//sampling time[s]\n  parameter Real K=2;//gain\n  parameter Real T=10;//time constant[s]\n  parameter Real minV=0,maxV=0.02;//limits for output\n  Real      ref=0.25;\n  Real error,outCtr;\n  Real  x; //state variable of continuous controller\n\nequation\n  der(h)=(qIn-qOut)/area; //mass balance equation\n  qOut=if time>100 then flowVout else 0; \n  qIn = flowGain*act;\n  \n  error = ref-h;\n  act = LimitValue(minV,maxV,outCtr);\n  der(x) = error/T;\n  outCtr = K*(x+error);\n  \nend FlatTank;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of FlatTank", "Subsection"], Cell["simulate( FlatTank, stopTime=250 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(FlatTank\\) : 2004-2-4 10:46:59.0887428 : \\!\\({0.`, 250.`}\\) : 504 data points : 2 events : 18 variables>\\n\\!\\({\\*TagBox[\\\"act\\\", HoldForm], \\*TagBox[\\\"area\\\", HoldForm], \\*TagBox[\\\"error\\\", HoldForm], \\*TagBox[\\\"flowGain\\\", HoldForm], \\*TagBox[\\\"flowVout\\\", HoldForm], \\*TagBox[\\\"h\\\", HoldForm], \\*TagBox[\\\"K\\\", HoldForm], \\*TagBox[\\\"maxV\\\", HoldForm], \\*TagBox[\\\"minV\\\", HoldForm], \\*TagBox[\\\"outCtr\\\", HoldForm], \\*TagBox[\\\"qIn\\\", HoldForm], \\*TagBox[\\\"qOut\\\", HoldForm], \\*TagBox[\\\"ref\\\", HoldForm], \\*TagBox[\\\"T\\\", HoldForm], \\*TagBox[\\\"Ts\\\", HoldForm], \\*TagBox[\\\"x\\\", HoldForm], \\*TagBox[SuperscriptBox[\\\"h\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\\"x\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( h );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.00380952 0.0147151 2.28405 [\n[.21429 .00222 -6 -9 ]\n[.21429 .00222 6 0 ]\n[.40476 .00222 -9 -9 ]\n[.40476 .00222 9 0 ]\n[.59524 .00222 -9 -9 ]\n[.59524 .00222 9 0 ]\n[.78571 .00222 -9 -9 ]\n[.78571 .00222 9 0 ]\n[.97619 .00222 -9 -9 ]\n[.97619 .00222 9 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .12892 -24 -4.5 ]\n[.01131 .12892 0 4.5 ]\n[.01131 .24312 -18 -4.5 ]\n[.01131 .24312 0 4.5 ]\n[.01131 .35732 -24 -4.5 ]\n[.01131 .35732 0 4.5 ]\n[.01131 .47153 -18 -4.5 ]\n[.01131 .47153 0 4.5 ]\n[.01131 .58573 -24 -4.5 ]\n[.01131 .58573 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .01472 m\n.21429 .02097 L\ns\n[(50)] .21429 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(100)] .40476 .00222 0 1 Mshowa\n.59524 .01472 m\n.59524 .02097 L\ns\n[(150)] .59524 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(200)] .78571 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(250)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.0619 .01472 m\n.0619 .01847 L\ns\n.1 .01472 m\n.1 .01847 L\ns\n.1381 .01472 m\n.1381 .01847 L\ns\n.17619 .01472 m\n.17619 .01847 L\ns\n.25238 .01472 m\n.25238 .01847 L\ns\n.29048 .01472 m\n.29048 .01847 L\ns\n.32857 .01472 m\n.32857 .01847 L\ns\n.36667 .01472 m\n.36667 .01847 L\ns\n.44286 .01472 m\n.44286 .01847 L\ns\n.48095 .01472 m\n.48095 .01847 L\ns\n.51905 .01472 m\n.51905 .01847 L\ns\n.55714 .01472 m\n.55714 .01847 L\ns\n.63333 .01472 m\n.63333 .01847 L\ns\n.67143 .01472 m\n.67143 .01847 L\ns\n.70952 .01472 m\n.70952 .01847 L\ns\n.74762 .01472 m\n.74762 .01847 L\ns\n.82381 .01472 m\n.82381 .01847 L\ns\n.8619 .01472 m\n.8619 .01847 L\ns\n.9 .01472 m\n.9 .01847 L\ns\n.9381 .01472 m\n.9381 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .12892 m\n.03006 .12892 L\ns\n[(0.05)] .01131 .12892 1 0 Mshowa\n.02381 .24312 m\n.03006 .24312 L\ns\n[(0.1)] .01131 .24312 1 0 Mshowa\n.02381 .35732 m\n.03006 .35732 L\ns\n[(0.15)] .01131 .35732 1 0 Mshowa\n.02381 .47153 m\n.03006 .47153 L\ns\n[(0.2)] .01131 .47153 1 0 Mshowa\n.02381 .58573 m\n.03006 .58573 L\ns\n[(0.25)] .01131 .58573 1 0 Mshowa\n.125 Mabswid\n.02381 .03756 m\n.02756 .03756 L\ns\n.02381 .0604 m\n.02756 .0604 L\ns\n.02381 .08324 m\n.02756 .08324 L\ns\n.02381 .10608 m\n.02756 .10608 L\ns\n.02381 .15176 m\n.02756 .15176 L\ns\n.02381 .1746 m\n.02756 .1746 L\ns\n.02381 .19744 m\n.02756 .19744 L\ns\n.02381 .22028 m\n.02756 .22028 L\ns\n.02381 .26596 m\n.02756 .26596 L\ns\n.02381 .2888 m\n.02756 .2888 L\ns\n.02381 .31164 m\n.02756 .31164 L\ns\n.02381 .33448 m\n.02756 .33448 L\ns\n.02381 .38016 m\n.02756 .38016 L\ns\n.02381 .403 m\n.02756 .403 L\ns\n.02381 .42584 m\n.02756 .42584 L\ns\n.02381 .44868 m\n.02756 .44868 L\ns\n.02381 .49437 m\n.02756 .49437 L\ns\n.02381 .51721 m\n.02756 .51721 L\ns\n.02381 .54005 m\n.02756 .54005 L\ns\n.02381 .56289 m\n.02756 .56289 L\ns\n.02381 .60857 m\n.02756 .60857 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .47153 L\n.02762 .60332 L\n.02952 .60332 L\n.03143 .60332 L\n.03333 .60332 L\n.03524 .60332 L\n.03714 .60332 L\n.03905 .60332 L\n.04095 .60332 L\n.04286 .60332 L\n.04476 .60332 L\n.04667 .60332 L\n.04857 .60332 L\n.05048 .60332 L\n.05238 .60332 L\n.05429 .60332 L\n.05619 .60332 L\n.0581 .60332 L\n.06 .60332 L\n.0619 .60332 L\n.06381 .60332 L\n.06571 .60332 L\n.06762 .60332 L\n.06952 .60332 L\n.07143 .60332 L\n.07333 .60332 L\n.07524 .60332 L\n.07714 .60332 L\n.07905 .60332 L\n.08095 .60332 L\n.08286 .60332 L\n.08476 .60332 L\n.08667 .60332 L\n.08857 .60332 L\n.09048 .60332 L\n.09238 .60332 L\n.09429 .60332 L\n.09619 .60332 L\n.0981 .60332 L\n.1 .60332 L\n.1019 .60332 L\n.10381 .60332 L\n.10571 .60332 L\n.10762 .60332 L\n.10952 .60332 L\n.11143 .60332 L\n.11333 .60332 L\n.11524 .60332 L\n.11714 .60332 L\nMistroke\n.11905 .60332 L\n.12095 .60332 L\n.12286 .60332 L\n.12476 .60332 L\n.12667 .60332 L\n.12857 .60332 L\n.13048 .60332 L\n.13238 .60332 L\n.13429 .60332 L\n.13619 .60332 L\n.1381 .60332 L\n.14 .60332 L\n.1419 .60332 L\n.14381 .60332 L\n.14571 .60332 L\n.14762 .60332 L\n.14952 .60332 L\n.15143 .60332 L\n.15333 .60332 L\n.15524 .60332 L\n.15714 .60332 L\n.15905 .60332 L\n.16095 .60332 L\n.16286 .60332 L\n.16476 .60332 L\n.16667 .60332 L\n.16857 .60332 L\n.17048 .60332 L\n.17238 .60332 L\n.17429 .60332 L\n.17619 .60332 L\n.1781 .60332 L\n.18 .60332 L\n.1819 .60332 L\n.18381 .60332 L\n.18571 .60332 L\n.18762 .60332 L\n.18952 .60332 L\n.19143 .60332 L\n.19333 .60332 L\n.19524 .60332 L\n.19714 .60332 L\n.19905 .60332 L\n.20095 .60332 L\n.20286 .60332 L\n.20476 .60332 L\n.20667 .60332 L\n.20857 .60332 L\n.21048 .60332 L\n.21238 .60332 L\nMistroke\n.21429 .60332 L\n.21619 .60332 L\n.2181 .60332 L\n.22 .60332 L\n.2219 .60332 L\n.22381 .60332 L\n.22571 .60332 L\n.22762 .60332 L\n.22952 .60332 L\n.23143 .60332 L\n.23333 .60332 L\n.23524 .60332 L\n.23714 .60332 L\n.23905 .60332 L\n.24095 .60332 L\n.24286 .60332 L\n.24476 .60332 L\n.24667 .60332 L\n.24857 .60332 L\n.25048 .60332 L\n.25238 .60332 L\n.25429 .60332 L\n.25619 .60332 L\n.2581 .60332 L\n.26 .60332 L\n.2619 .60332 L\n.26381 .60332 L\n.26571 .60332 L\n.26762 .60332 L\n.26952 .60332 L\n.27143 .60332 L\n.27333 .60332 L\n.27524 .60332 L\n.27714 .60332 L\n.27905 .60332 L\n.28095 .60332 L\n.28286 .60332 L\n.28476 .60332 L\n.28667 .60332 L\n.28857 .60332 L\n.29048 .60332 L\n.29238 .60332 L\n.29429 .60332 L\n.29619 .60332 L\n.2981 .60332 L\n.3 .60332 L\n.3019 .60332 L\n.30381 .60332 L\n.30571 .60332 L\n.30762 .60332 L\nMistroke\n.30952 .60332 L\n.31143 .60332 L\n.31333 .60332 L\n.31524 .60332 L\n.31714 .60332 L\n.31905 .60332 L\n.32095 .60332 L\n.32286 .60332 L\n.32476 .60332 L\n.32667 .60332 L\n.32857 .60332 L\n.33048 .60332 L\n.33238 .60332 L\n.33429 .60332 L\n.33619 .60332 L\n.3381 .60332 L\n.34 .60332 L\n.3419 .60332 L\n.34381 .60332 L\n.34571 .60332 L\n.34762 .60332 L\n.34952 .60332 L\n.35143 .60332 L\n.35333 .60332 L\n.35524 .60332 L\n.35714 .60332 L\n.35905 .60332 L\n.36095 .60332 L\n.36286 .60332 L\n.36476 .60332 L\n.36667 .60332 L\n.36857 .60332 L\n.37048 .60332 L\n.37238 .60332 L\n.37429 .60332 L\n.37619 .60332 L\n.3781 .60332 L\n.38 .60332 L\n.3819 .60332 L\n.38381 .60332 L\n.38571 .60332 L\n.38762 .60332 L\n.38952 .60332 L\n.39143 .60332 L\n.39333 .60332 L\n.39524 .60332 L\n.39714 .60332 L\n.39905 .60332 L\n.40095 .60332 L\n.40286 .60332 L\nMistroke\n.40476 .60332 L\n.40476 .60332 L\n.40476 .60332 L\n.40667 .55764 L\n.40857 .51196 L\n.41048 .46644 L\n.41238 .44068 L\n.41429 .44771 L\n.41619 .45431 L\n.4181 .46063 L\n.42 .46665 L\n.4219 .47243 L\n.42381 .47796 L\n.42571 .48323 L\n.42762 .48825 L\n.42952 .49303 L\n.43143 .49759 L\n.43333 .50192 L\n.43524 .50604 L\n.43714 .50997 L\n.43905 .51369 L\n.44095 .51724 L\n.44286 .52062 L\n.44476 .52382 L\n.44667 .52688 L\n.44857 .52978 L\n.45048 .53253 L\n.45238 .53514 L\n.45429 .53763 L\n.45619 .53998 L\n.4581 .54222 L\n.46 .54435 L\n.4619 .54636 L\n.46381 .54828 L\n.46571 .5501 L\n.46762 .55183 L\n.46952 .55348 L\n.47143 .55505 L\n.47333 .55654 L\n.47524 .55795 L\n.47714 .55929 L\n.47905 .56057 L\n.48095 .5618 L\n.48286 .56296 L\n.48476 .56406 L\n.48667 .56511 L\n.48857 .56611 L\n.49048 .56706 L\n.49238 .56797 L\n.49429 .56883 L\nMistroke\n.49619 .56964 L\n.4981 .57042 L\n.5 .57116 L\n.5019 .57187 L\n.50381 .57255 L\n.50571 .57318 L\n.50762 .57379 L\n.50952 .57437 L\n.51143 .57492 L\n.51333 .57545 L\n.51524 .57595 L\n.51714 .57642 L\n.51905 .57687 L\n.52095 .5773 L\n.52286 .57771 L\n.52476 .5781 L\n.52667 .57847 L\n.52857 .57883 L\n.53048 .57916 L\n.53238 .57948 L\n.53429 .57979 L\n.53619 .58008 L\n.5381 .58035 L\n.54 .58062 L\n.5419 .58087 L\n.54381 .58111 L\n.54571 .58133 L\n.54762 .58155 L\n.54952 .58175 L\n.55143 .58195 L\n.55333 .58214 L\n.55524 .58232 L\n.55714 .58249 L\n.55905 .58265 L\n.56095 .5828 L\n.56286 .58295 L\n.56476 .58309 L\n.56667 .58323 L\n.56857 .58335 L\n.57048 .58347 L\n.57238 .58359 L\n.57429 .5837 L\n.57619 .5838 L\n.5781 .5839 L\n.58 .584 L\n.5819 .58408 L\n.58381 .58417 L\n.58571 .58424 L\n.58762 .58432 L\n.58952 .58439 L\nMistroke\n.59143 .58445 L\n.59333 .58451 L\n.59524 .58457 L\n.59714 .58463 L\n.59905 .58468 L\n.60095 .58473 L\n.60286 .58477 L\n.60476 .58482 L\n.60667 .58486 L\n.60857 .5849 L\n.61048 .58493 L\n.61238 .58497 L\n.61429 .585 L\n.61619 .58503 L\n.6181 .58506 L\n.62 .58509 L\n.6219 .58511 L\n.62381 .58514 L\n.62571 .58516 L\n.62762 .58518 L\n.62952 .58521 L\n.63143 .58523 L\n.63333 .58525 L\n.63524 .58527 L\n.63714 .58529 L\n.63905 .58531 L\n.64095 .58533 L\n.64286 .58534 L\n.64476 .58536 L\n.64667 .58537 L\n.64857 .58538 L\n.65048 .5854 L\n.65238 .58541 L\n.65429 .58542 L\n.65619 .58544 L\n.6581 .58545 L\n.66 .58546 L\n.6619 .58548 L\n.66381 .58549 L\n.66571 .5855 L\n.66762 .58551 L\n.66952 .58552 L\n.67143 .58553 L\n.67333 .58554 L\n.67524 .58555 L\n.67714 .58556 L\n.67905 .58556 L\n.68095 .58557 L\n.68286 .58558 L\n.68476 .58559 L\nMistroke\n.68667 .5856 L\n.68857 .5856 L\n.69048 .58561 L\n.69238 .58562 L\n.69429 .58562 L\n.69619 .58563 L\n.6981 .58563 L\n.7 .58564 L\n.7019 .58564 L\n.70381 .58565 L\n.70571 .58565 L\n.70762 .58565 L\n.70952 .58566 L\n.71143 .58566 L\n.71333 .58567 L\n.71524 .58567 L\n.71714 .58568 L\n.71905 .58568 L\n.72095 .58568 L\n.72286 .58569 L\n.72476 .58569 L\n.72667 .58569 L\n.72857 .5857 L\n.73048 .5857 L\n.73238 .5857 L\n.73429 .5857 L\n.73619 .58571 L\n.7381 .58571 L\n.74 .58571 L\n.7419 .58571 L\n.74381 .58572 L\n.74571 .58572 L\n.74762 .58572 L\n.74952 .58572 L\n.75143 .58572 L\n.75333 .58572 L\n.75524 .58572 L\n.75714 .58572 L\n.75905 .58573 L\n.76095 .58573 L\n.76286 .58573 L\n.76476 .58573 L\n.76667 .58573 L\n.76857 .58573 L\n.77048 .58573 L\n.77238 .58573 L\n.77429 .58573 L\n.77619 .58574 L\n.7781 .58574 L\n.78 .58574 L\nMistroke\n.7819 .58574 L\n.78381 .58574 L\n.78571 .58574 L\n.78762 .58574 L\n.78952 .58574 L\n.79143 .58574 L\n.79333 .58574 L\n.79524 .58574 L\n.79714 .58574 L\n.79905 .58574 L\n.80095 .58574 L\n.80286 .58574 L\n.80476 .58574 L\n.80667 .58574 L\n.80857 .58574 L\n.81048 .58574 L\n.81238 .58574 L\n.81429 .58574 L\n.81619 .58574 L\n.8181 .58574 L\n.82 .58574 L\n.8219 .58574 L\n.82381 .58574 L\n.82571 .58574 L\n.82762 .58574 L\n.82952 .58574 L\n.83143 .58574 L\n.83333 .58574 L\n.83524 .58574 L\n.83714 .58574 L\n.83905 .58574 L\n.84095 .58574 L\n.84286 .58574 L\n.84476 .58574 L\n.84667 .58574 L\n.84857 .58574 L\n.85048 .58574 L\n.85238 .58574 L\n.85429 .58574 L\n.85619 .58574 L\n.8581 .58574 L\n.86 .58573 L\n.8619 .58573 L\n.86381 .58573 L\n.86571 .58573 L\n.86762 .58573 L\n.86952 .58573 L\n.87143 .58573 L\n.87333 .58573 L\n.87524 .58573 L\nMistroke\n.87714 .58573 L\n.87905 .58573 L\n.88095 .58573 L\n.88286 .58573 L\n.88476 .58573 L\n.88667 .58573 L\n.88857 .58573 L\n.89048 .58573 L\n.89238 .58573 L\n.89429 .58573 L\n.89619 .58573 L\n.8981 .58573 L\n.9 .58573 L\n.9019 .58573 L\n.90381 .58573 L\n.90571 .58573 L\n.90762 .58573 L\n.90952 .58573 L\n.91143 .58573 L\n.91333 .58573 L\n.91524 .58573 L\n.91714 .58573 L\n.91905 .58573 L\n.92095 .58573 L\n.92286 .58573 L\n.92476 .58573 L\n.92667 .58573 L\n.92857 .58573 L\n.93048 .58573 L\n.93238 .58573 L\n.93429 .58573 L\n.93619 .58573 L\n.9381 .58573 L\n.94 .58573 L\n.9419 .58573 L\n.94381 .58573 L\n.94571 .58573 L\n.94762 .58573 L\n.94952 .58573 L\n.95143 .58573 L\n.95333 .58573 L\n.95524 .58573 L\n.95714 .58573 L\n.95905 .58573 L\n.96095 .58573 L\n.96286 .58573 L\n.96476 .58573 L\n.96667 .58573 L\n.96857 .58573 L\n.97048 .58573 L\nMistroke\n.97238 .58573 L\n.97429 .58573 L\n.97619 .58573 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(h) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00BP3IfMT2000000@0fMWI0P00\n000Q0=WIf@D000000P3IfMT2000000@0fMWI0P00000N0=WIf@D000000P3IfMT2000000@0fMWI0P00\n000N0=WIf@@000000`3IfMT2000000@0fMWI0P00000N0=WIf@@000000`3IfMT2000000@0fMWI0P00\n000G0=WIf@00B@3IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI00000280fMWI\n00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WI\nf@3IfMT07@3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00@000000=WIf@3IfMT000000P3I\nfMT00`000000fMWI0=WIf@0K0=WIf@030000003IfMT0fMWI00<0fMWI00@000000=WIf@3IfMT00000\n0P3IfMT010000000fMWI0=WIf@00000M0=WIf@030000003IfMT0fMWI00<0fMWI00@000000=WIf@3I\nfMT000000P3IfMT010000000fMWI0=WIf@00000F0=WIf@00C03IfMT010000000fMWI0=WIf@000002\n0=WIf@030000003IfMT0fMWI0200fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003I\nfMT0fMWI00000080fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@040=WIf@040000\n003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0703IfMT00`000000fMWI0=WIf@020=WIf@04\n0000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000007P3IfMT00`000000fMWI0=WIf@05\n0=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0503IfMT004X0fMWI0P000003\n0=WIf@040000003IfMT0fMWI00000280fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000\n003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@020=WIf@80\n00000`3IfMT010000000fMWI0=WIf@00000O0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT0\n10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT00P3I\nfMT2000000<0fMWI00@000000=WIf@3IfMT000005P3IfMT004X0fMWI00<000000=WIf@3IfMT00P3I\nfMT010000000fMWI0=WIf@00000R0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT010000000\nfMWI0=WIf@0000020=WIf@030000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT00P3IfMT00`00\n0000fMWI0=WIf@020=WIf@040000003IfMT0fMWI000001d0fMWI00@000000=WIf@3IfMT000000P3I\nfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI000001d0fMWI00@000000=WIf@3I\nfMT000000`3IfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0fMWI000001H0fMWI001:0=WI\nf@<000000`3IfMT200000280fMWI0P0000040=WIf@800000103IfMT2000001l0fMWI0P0000040=WI\nf@<000000`3IfMT2000001l0fMWI0P0000040=WIf@800000103IfMT2000001l0fMWI0P0000040=WI\nf@<000000`3IfMT2000001L0fMWI003o0=WIfB40fMWI000Q0=WIf@030000003IfMT0fMWI0?`0fMWI\n000Q0=WIf@030000003IfMT0fMWI0?`0fMWI000Q0=WIf@030000003IfMT0fMWI0>d0fMWI0P00000=\n0=WIf@008@3IfMT00`000000fMWI0=WIf@3/0=WIf@040000003IfMT0fMWI000000`0fMWI000L0=WI\nf@D0000000<0003o000000000000i@0000070=WIf@030000003IfMT0fMWI00d0fMWI000Q0=WIf@03\n0000o`3IfMT0fMWI02X0fMWI00<000000=WIf@3IfMT0:P3IfMT00`000000fMWI0=WIf@0Z0=WIf@03\n0000003IfMT0fMWI02X0fMWI00<000000=WIf@3IfMT0:P3IfMT00`000000fMWI0=WIf@0:0=WIf@D0\n0000303IfMT00240fMWI00<0003o0=WIf@3IfMT0k03IfMT00`000000fMWI0=WIf@0=0=WIf@008@3I\nfMT00`000?l0fMWI0=WIf@3l0=WIf@008@3IfMT00`000?l0fMWI0=WIf@3l0=WIf@008@3IfMT00`00\n0?l000000=WIf@3l0=WIf@008@3IfMT00`000?l0fMWI0=WIf@3l0=WIf@008@3IfMT00`000?l0fMWI\n0=WIf@3l0=WIf@008@3IfMT00`000?l0fMWI0=WIf@3l0=WIf@008@3IfMT00`000?l0fMWI0=WIf@3l\n0=WIf@008@3IfMT00`000?l000000=WIf@3l0=WIf@008@3IfMT00`000?l0fMWI0=WIf@3l0=WIf@00\n8@3IfMT00`000?l0fMWI0=WIf@3l0=WIf@008@3IfMT00`000?l0fMWI0=WIf@3l0=WIf@008@3IfMT0\n0`000?l0fMWI0=WIf@3l0=WIf@008@3IfMT00`000?l0fMWI0=WIf@3l0=WIf@008@3IfMT00`000?l0\n00000=WIf@3l0=WIf@008@3IfMT00`000?l0fMWI0=WIf@3l0=WIf@008@3IfMT00`000?l0fMWI0=WI\nf@3l0=WIf@008@3IfMT00`000?l0fMWI0=WIf@3l0=WIf@008@3IfMT00`000?l0fMWI0=WIf@3l0=WI\nf@008@3IfMT00`000?l000000=WIf@3l0=WIf@008@3IfMT00`000?l0fMWI0=WIf@3l0=WIf@008@3I\nfMT00`000?l0fMWI0=WIf@3l0=WIf@008@3IfMT00`000?l0fMWI0=WIf@3l0=WIf@002@3IfMT20000\n00@0fMWI0P0000040=WIf@800000103IfMT2000000@0fMWI00<0003o0=WIf@3IfMT0o03IfMT000P0\nfMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0\nfMWI000000<0fMWI00<0003o0=WIf@3IfMT0o03IfMT000P0fMWI00@000000=WIf@3IfMT00000203I\nfMT010000000fMWI0=WIf@0000050=WIf@050000003IfMT0fMWI0=WIf@000?l00P00003l0=WIf@00\n203IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000<0fMWI0P0000040=WI\nf@030000o`3IfMT0fMWI0?`0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI\nf@3IfMT000000`3IfMT00`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0?`0fMWI00090=WI\nf@8000002P3IfMT2000000@0fMWI0`0000030=WIf@030000o`3IfMT0fMWI0?`0fMWI000Q0=WIf@03\n0000o`3IfMT0fMWI0?`0fMWI000Q0=WIf@030000o`000000fMWI0?`0fMWI000Q0=WIf@030000o`3I\nfMT0fMWI0?`0fMWI000Q0=WIf@030000o`3IfMT0fMWI0?`0fMWI000Q0=WIf@030000o`3IfMT0fMWI\n0?`0fMWI000Q0=WIf@030000o`3IfMT0fMWI0?`0fMWI000Q0=WIf@030000o`000000fMWI0?`0fMWI\n000Q0=WIf@030000o`3IfMT0fMWI0?`0fMWI000Q0=WIf@030000o`3IfMT0fMWI0?`0fMWI000Q0=WI\nf@030000o`3IfMT0fMWI0?`0fMWI000Q0=WIf@030000o`3IfMT0fMWI0?`0fMWI000Q0=WIf@030000\no`3IfMT0fMWI0?`0fMWI000Q0=WIf@030000o`000000fMWI0?`0fMWI000Q0=WIf@030000o`3IfMT0\nfMWI0?`0fMWI000Q0=WIf@030000o`3IfMT0fMWI0?`0fMWI000Q0=WIf@030000o`3IfMT0fMWI0?`0\nfMWI000Q0=WIf@030000o`3IfMT0fMWI0?`0fMWI000Q0=WIf@030000o`000000fMWI0?`0fMWI000Q\n0=WIf@030000o`3IfMT0fMWI0?`0fMWI000Q0=WIf@030000o`3IfMT0fMWI0?`0fMWI000?0=WIf@80\n0000103IfMT2000000<0fMWI1@0000020=WIf@030000o`3IfMT0fMWI0?`0fMWI000>0=WIf@040000\n003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@3l0=WIf@00\n3P3IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI0080fMWI00<0003o00000000\n0000o03IfMT000h0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@020=WIf@03\n000000000?l0fMWI0?`0fMWI000>0=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3I\nfMT00P3IfMT00`000000003o0=WIf@3l0=WIf@003`3IfMT2000000X0fMWI0P0000040=WIf@030000\n00000?l0fMWI0?`0fMWI000Q0=WIf@03000000000?l0fMWI0?`0fMWI000Q0=WIf@03000000000?l0\nfMWI0?`0fMWI000Q0=WIf@03000000000?l0fMWI0?`0fMWI000Q0=WIf@03000000000?l0fMWI0?`0\nfMWI000Q0=WIf@03000000000?l0fMWI0?`0fMWI000Q0=WIf@03000000000?l0fMWI0?`0fMWI000Q\n0=WIf@03000000000?l0fMWI0?`0fMWI000Q0=WIf@03000000000?l0fMWI0?`0fMWI000Q0=WIf@03\n000000000?l0fMWI0?`0fMWI000Q0=WIf@03000000000?l0fMWI0?`0fMWI000Q0=WIf@0300000000\n0?l0fMWI0?`0fMWI000Q0=WIf@03000000000?l0fMWI0?`0fMWI000Q0=WIf@03000000000?l0fMWI\n0?`0fMWI000Q0=WIf@03000000000?l0fMWI0?`0fMWI000Q0=WIf@03000000000?l0fMWI0?`0fMWI\n000Q0=WIf@03000000000?l0fMWI0?`0fMWI000Q0=WIf@03000000000?l0fMWI0?`0fMWI000Q0=WI\nf@03000000000?l0fMWI0?`0fMWI000Q0=WIf@03000000000?l0fMWI0?`0fMWI000Q0=WIf@030000\n00000?l0fMWI0?`0fMWI000Q0=WIf@03000000000?l0fMWI0?`0fMWI00090=WIf@800000103IfMT2\n000000<0fMWI1@0000020=WIf@800000103IfMT00`000000003o0=WIf@3l0=WIf@00203IfMT01000\n0000fMWI0=WIf@00000:0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT01P000000fMWI0=WI\nf@3IfMT000000000ood0fMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3I\nfMT0103IfMT01`000000fMWI0=WIf@3IfMT000000000o`000000o03IfMT000P0fMWI00@000000=WI\nf@3IfMT000002P3IfMT00`000000fMWI0=WIf@020=WIf@800000103IfMT00`000000003o0=WIf@3l\n0=WIf@00203IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI0080fMWI00<00000\n0=WIf@3IfMT00`3IfMT00`000000003o0=WIf@3l0=WIf@002@3IfMT2000000X0fMWI0P0000040=WI\nf@<000000`3IfMT00`000000003o0=WIf@3l0=WIf@008@3IfMT00`000000003o0=WIf@3l0=WIf@00\n8@3IfMT00`000000003o0=WIf@3l0=WIf@008@3IfMT00`000000003o0=WIf@3l0=WIf@008@3IfMT0\n0`000000003o0=WIf@3l0=WIf@008@3IfMT00`000000003o0=WIf@3l0=WIf@008@3IfMT00`000000\n003o0=WIf@3l0=WIf@008@3IfMT00`000000003o0=WIf@3l0=WIf@008@3IfMT00`000000003o0=WI\nf@3l0=WIf@008@3IfMT00`000000003o0=WIf@3l0=WIf@008@3IfMT00`000000003o0=WIf@3l0=WI\nf@008@3IfMT00`000000003o0=WIf@3l0=WIf@008@3IfMT00`000000003o0=WIf@3l0=WIf@008@3I\nfMT00`000000003o0=WIf@3l0=WIf@008@3IfMT00`000000003o0=WIf@3l0=WIf@008@3IfMT00`00\n0000003o0=WIf@3l0=WIf@008@3IfMT00`000000003o0=WIf@3l0=WIf@008@3IfMT00`000000003o\n0=WIf@1I0=WIf@030000o`3IfMT0fMWI0:00fMWI000Q0=WIf@03000000000?l0fMWI05T0fMWI00<0\n003o0=WIf@3IfMT0X03IfMT00240fMWI00<000000000o`3IfMT0F@3IfMT00`000?l0fMWI0=WIf@2P\n0=WIf@008@3IfMT00`000000003o0=WIf@1I0=WIf@80003oX@3IfMT00240fMWI00<000000000o`3I\nfMT0F@3IfMT20000oj40fMWI000?0=WIf@800000103IfMT2000000<0fMWI100000030=WIf@030000\n00000?l0fMWI05T0fMWI0P000?nQ0=WIf@003P3IfMT010000000fMWI0=WIf@0000080=WIf@030000\n003IfMT0fMWI00@0fMWI00<000000000o`3IfMT0F@3IfMT00`000?l0fMWI0000o`2P0=WIf@003P3I\nfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI00<0fMWI00<000000000o`000000\nF@3IfMT00`000?l0fMWI0000o`2P0=WIf@003P3IfMT010000000fMWI0=WIf@00000:0=WIf@030000\n003IfMT0fMWI0080fMWI00<000000000o`3IfMT0F@3IfMT00`000?l0fMWI0000o`2P0=WIf@003P3I\nfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000<0fMWI00<000000000o`3I\nfMT0F@3IfMT010000?l0fMWI0=WIf@000?nO0=WIf@003`3IfMT2000000X0fMWI0P0000040=WIf@03\n000000000?l0fMWI05T0fMWI00@0003o0=WIf@3IfMT0003oW`3IfMT00240fMWI00<000000000o`3I\nfMT0F@3IfMT01@000?l0fMWI0=WIf@3IfMT0003o09h0fMWI000Q0=WIf@03000000000?l0fMWI05P0\nfMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@2L0=WIf@008@3IfMT00`000000003o\n0=WIf@1H0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0V`3IfMT00240fMWI00<0\n00000000o`3IfMT0F03IfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI09/0fMWI000Q\n0=WIf@03000000000?l0fMWI05P0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@2K\n0=WIf@008@3IfMT00`000000003o0=WIf@1H0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WI\nf@3IfMT0VP3IfMT00240fMWI00<000000000o`3IfMT0F03IfMT00`000?l0fMWI0=WIf@040=WIf@03\n0000o`3IfMT0fMWI09X0fMWI000Q0=WIf@03000000000?l0fMWI05P0fMWI00<0003o0=WIf@3IfMT0\n1@3IfMT00`000?l0fMWI0=WIf@2I0=WIf@008@3IfMT00`000000003o0=WIf@1H0=WIf@030000o`3I\nfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0V@3IfMT00240fMWI00<000000000o`3IfMT0F03IfMT0\n0`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI09P0fMWI000Q0=WIf@03000000000?l0fMWI\n05P0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@2G0=WIf@008@3IfMT00`000000\n003o0=WIf@1H0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0U`3IfMT00240fMWI\n00<000000000o`3IfMT0F03IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI09H0fMWI\n000Q0=WIf@03000000000?l0fMWI05P0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WI\nf@2E0=WIf@008@3IfMT00`000000003o0=WIf@1H0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o\n0=WIf@3IfMT0U03IfMT00240fMWI00<000000000o`3IfMT0F03IfMT00`000?l0fMWI0=WIf@0;0=WI\nf@030000o`3IfMT0fMWI09<0fMWI000Q0=WIf@03000000000?l0fMWI05P0fMWI00<0003o0=WIf@3I\nfMT0303IfMT00`000?l0fMWI0=WIf@2B0=WIf@008@3IfMT00`000000003o0=WIf@1H0=WIf@030000\no`3IfMT0fMWI00d0fMWI0P000?nB0=WIf@008@3IfMT00`000000003o0=WIf@1H0=WIf@030000o`3I\nfMT0fMWI00h0fMWI0`000?n@0=WIf@008@3IfMT00`000000003o0=WIf@1H0=WIf@030000o`3IfMT0\nfMWI0100fMWI0`000?n>0=WIf@008@3IfMT00`000000003o0=WIf@1H0=WIf@030000o`3IfMT0fMWI\n0180fMWI0`000?n<0=WIf@002@3IfMT2000000@0fMWI0P0000030=WIf@@000000`3IfMT2000000@0\nfMWI00<000000000o`3IfMT0F03IfMT00`000?l0fMWI0=WIf@0E0=WIf@D0003oQ`3IfMT000P0fMWI\n00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@030=WIf@040000003IfMT0fMWI0000\n00<0fMWI00<000000000o`3IfMT0E`3IfMT00`000?l0fMWI0=WIf@0J0=WIf@T0003oO`3IfMT000P0\nfMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@070000003IfMT0fMWI\n0=WIf@000000003o0000001G0=WIf@030000o`3IfMT0fMWI02<0fMWIHP000?lM0=WIf@00203IfMT0\n10000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI0080fMWI0P0000040=WIf@0300000000\n0?l0fMWI05L0fMWI00<0003o0=WIf@3IfMT0XP3IfMT000P0fMWI00@000000=WIf@3IfMT00000203I\nfMT010000000fMWI0=WIf@0000030=WIf@030000003IfMT0fMWI00<0fMWI00<000000000o`3IfMT0\nE`3IfMT00`000?l0fMWI0=WIf@2R0=WIf@002@3IfMT2000000X0fMWI0P0000040=WIf@<000000`3I\nfMT00`000000003o0=WIf@1G0=WIf@030000o`3IfMT0fMWI0:80fMWI000Q0=WIf@03000000000?l0\n003o05T0003oX`3IfMT00240fMWI00<000000=WIf@3IfMT0o03IfMT00240fMWI0P00003m0=WIf@00\n8@3IfMT00`000000fMWI0=WIf@3l0=WIf@008@3IfMT00`000000fMWI0=WIf@3l0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00:P3IfMT2000000P0fMWI0P00003Z0=WIf@00:P3IfMT00`000000fMWI0=WIf@080=WIf@03\n0000003IfMT0fMWI0>P0fMWI000Q0=WIf@<0000000<0fMWI0000000000000`3IfMT00`000000fMWI\n0=WIf@020=WIf@800000103IfMT00`000000fMWI0=WIf@3X0=WIf@008P3IfMT010000000fMWI0=WI\nf@0000040=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT01@000000fMWI0=WIf@3IfMT00000\n0>X0fMWI000F0=WIf@P0003o103IfMT010000000fMWI0=WIf@0000040=WIf@050000003IfMT0fMWI\n0=WIf@0000001P3IfMT00`000000fMWI0=WIf@3X0=WIf@008P3IfMT3000000D0fMWI00<000000=WI\nf@3IfMT01@0000030=WIf@030000003IfMT0fMWI0>P0fMWI000R0=WIf@030000003IfMT0fMWI00D0\nfMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0>P0fMWI000Q0=WIf@80\n00001`3IfMT2000000P0fMWI0P00003Z0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-37.8061`, -0.0452072`, 1.11367`, 0.00185746`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell[BoxData[TagBox[RowBox[List[RowBox[List["\[SkeletonIndicator]", "Graphics"]], "\[SkeletonIndicator]"]], False, Rule[Editable, False]]], "Output"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Flat Tank Model second approach(without any components)", "Section"], Cell["function LimitValue\n  input Real pMin;\n  input Real pMax;\n  input Real p;\n  output Real pLim;\nalgorithm\n  pLim := if p>pMax then pMax\n          else if p<pMin then pMin \n          else p;\nend LimitValue;", "ModelicaInput"], Cell["", "Text"], Cell["model FlatTank\n  //tank related variables and parameters\n  parameter Real flowVin =0.02; //[m3/s]\n  parameter Real area =1;      //[m2]\n  parameter Real flowGain =0.05;   //[m2/s]\n  Real h(start=0);    //tank level [m]\n  Real qIn;  // flow through input valve[m3/s]\n  Real qOut; // flow through output valve[m3/s]\n  \n  //controler related variables and parameters\n  parameter Real Ts=0.1;//sampling time[s]\n  parameter Real K=2;//gain\n  parameter Real T=10;//time constant[s]\n  parameter Real minV=0,maxV=0.02;//limits for output\n  Real      ref=0.25;\n  Real error,outCtr;\n  Real  x; //state variable of continuous controller\n\nequation\n  der(h)=(qIn-qOut)/area; //mass balance equation\n  qIn=if time>150 then 3*flowVin else flowVin; \n  qOut=LimitValue(0,10,-flowGain*outCtr);\n  \n  error = ref-h;\n  der(x) = error/T;\n  outCtr = K*(x+error);\n  \nend FlatTank;", "ModelicaInput"], Cell["", "Text"], Cell["simulate( FlatTank, stopTime=250 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(FlatTank\\) : 2004-2-4 10:47:5.3854969 : \\!\\({0.`, 250.`}\\) : 504 data points : 2 events : 17 variables>\\n\\!\\({\\*TagBox[\\\"area\\\", HoldForm], \\*TagBox[\\\"error\\\", HoldForm], \\*TagBox[\\\"flowGain\\\", HoldForm], \\*TagBox[\\\"flowVin\\\", HoldForm], \\*TagBox[\\\"h\\\", HoldForm], \\*TagBox[\\\"K\\\", HoldForm], \\*TagBox[\\\"maxV\\\", HoldForm], \\*TagBox[\\\"minV\\\", HoldForm], \\*TagBox[\\\"outCtr\\\", HoldForm], \\*TagBox[\\\"qIn\\\", HoldForm], \\*TagBox[\\\"qOut\\\", HoldForm], \\*TagBox[\\\"ref\\\", HoldForm], \\*TagBox[\\\"T\\\", HoldForm], \\*TagBox[\\\"Ts\\\", HoldForm], \\*TagBox[\\\"x\\\", HoldForm], \\*TagBox[SuperscriptBox[\\\"h\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\\"x\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( h );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.00380952 0.0147151 1.25617 [\n[.21429 .00222 -6 -9 ]\n[.21429 .00222 6 0 ]\n[.40476 .00222 -9 -9 ]\n[.40476 .00222 9 0 ]\n[.59524 .00222 -9 -9 ]\n[.59524 .00222 9 0 ]\n[.78571 .00222 -9 -9 ]\n[.78571 .00222 9 0 ]\n[.97619 .00222 -9 -9 ]\n[.97619 .00222 9 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .14033 -18 -4.5 ]\n[.01131 .14033 0 4.5 ]\n[.01131 .26595 -18 -4.5 ]\n[.01131 .26595 0 4.5 ]\n[.01131 .39157 -18 -4.5 ]\n[.01131 .39157 0 4.5 ]\n[.01131 .51718 -18 -4.5 ]\n[.01131 .51718 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .01472 m\n.21429 .02097 L\ns\n[(50)] .21429 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(100)] .40476 .00222 0 1 Mshowa\n.59524 .01472 m\n.59524 .02097 L\ns\n[(150)] .59524 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(200)] .78571 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(250)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.0619 .01472 m\n.0619 .01847 L\ns\n.1 .01472 m\n.1 .01847 L\ns\n.1381 .01472 m\n.1381 .01847 L\ns\n.17619 .01472 m\n.17619 .01847 L\ns\n.25238 .01472 m\n.25238 .01847 L\ns\n.29048 .01472 m\n.29048 .01847 L\ns\n.32857 .01472 m\n.32857 .01847 L\ns\n.36667 .01472 m\n.36667 .01847 L\ns\n.44286 .01472 m\n.44286 .01847 L\ns\n.48095 .01472 m\n.48095 .01847 L\ns\n.51905 .01472 m\n.51905 .01847 L\ns\n.55714 .01472 m\n.55714 .01847 L\ns\n.63333 .01472 m\n.63333 .01847 L\ns\n.67143 .01472 m\n.67143 .01847 L\ns\n.70952 .01472 m\n.70952 .01847 L\ns\n.74762 .01472 m\n.74762 .01847 L\ns\n.82381 .01472 m\n.82381 .01847 L\ns\n.8619 .01472 m\n.8619 .01847 L\ns\n.9 .01472 m\n.9 .01847 L\ns\n.9381 .01472 m\n.9381 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .14033 m\n.03006 .14033 L\ns\n[(0.1)] .01131 .14033 1 0 Mshowa\n.02381 .26595 m\n.03006 .26595 L\ns\n[(0.2)] .01131 .26595 1 0 Mshowa\n.02381 .39157 m\n.03006 .39157 L\ns\n[(0.3)] .01131 .39157 1 0 Mshowa\n.02381 .51718 m\n.03006 .51718 L\ns\n[(0.4)] .01131 .51718 1 0 Mshowa\n.125 Mabswid\n.02381 .03984 m\n.02756 .03984 L\ns\n.02381 .06496 m\n.02756 .06496 L\ns\n.02381 .09009 m\n.02756 .09009 L\ns\n.02381 .11521 m\n.02756 .11521 L\ns\n.02381 .16546 m\n.02756 .16546 L\ns\n.02381 .19058 m\n.02756 .19058 L\ns\n.02381 .2157 m\n.02756 .2157 L\ns\n.02381 .24083 m\n.02756 .24083 L\ns\n.02381 .29107 m\n.02756 .29107 L\ns\n.02381 .3162 m\n.02756 .3162 L\ns\n.02381 .34132 m\n.02756 .34132 L\ns\n.02381 .36644 m\n.02756 .36644 L\ns\n.02381 .41669 m\n.02756 .41669 L\ns\n.02381 .44181 m\n.02756 .44181 L\ns\n.02381 .46694 m\n.02756 .46694 L\ns\n.02381 .49206 m\n.02756 .49206 L\ns\n.02381 .54231 m\n.02756 .54231 L\ns\n.02381 .56743 m\n.02756 .56743 L\ns\n.02381 .59255 m\n.02756 .59255 L\ns\n.02381 .61768 m\n.02756 .61768 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .02728 L\n.02762 .03984 L\n.02952 .0524 L\n.03143 .06496 L\n.03333 .07752 L\n.03524 .09009 L\n.03714 .10265 L\n.03905 .11521 L\n.04095 .12777 L\n.04286 .14033 L\n.04476 .15289 L\n.04667 .16546 L\n.04857 .17802 L\n.05048 .19058 L\n.05238 .20314 L\n.05429 .2157 L\n.05619 .22826 L\n.0581 .24083 L\n.06 .25339 L\n.0619 .26595 L\n.06381 .27851 L\n.06571 .29107 L\n.06762 .30363 L\n.06952 .3162 L\n.07143 .32876 L\n.07333 .34132 L\n.07524 .35388 L\n.07714 .36644 L\n.07905 .379 L\n.08095 .39157 L\n.08286 .40413 L\n.08476 .41669 L\n.08667 .42925 L\n.08857 .44181 L\n.09048 .45438 L\n.09238 .46694 L\n.09429 .47937 L\n.09619 .49129 L\n.0981 .50236 L\n.1 .5125 L\n.1019 .5217 L\n.10381 .52998 L\n.10571 .53735 L\n.10762 .54386 L\n.10952 .54952 L\n.11143 .55437 L\n.11333 .55843 L\n.11524 .56174 L\n.11714 .56431 L\nMistroke\n.11905 .56619 L\n.12095 .56739 L\n.12286 .56795 L\n.12476 .56791 L\n.12667 .56728 L\n.12857 .5661 L\n.13048 .56439 L\n.13238 .5622 L\n.13429 .55954 L\n.13619 .55645 L\n.1381 .55295 L\n.14 .54908 L\n.1419 .54486 L\n.14381 .54032 L\n.14571 .53548 L\n.14762 .53038 L\n.14952 .52504 L\n.15143 .51947 L\n.15333 .51372 L\n.15524 .50779 L\n.15714 .50172 L\n.15905 .49552 L\n.16095 .48921 L\n.16286 .48283 L\n.16476 .47638 L\n.16667 .46988 L\n.16857 .46336 L\n.17048 .45683 L\n.17238 .45031 L\n.17429 .4438 L\n.17619 .43734 L\n.1781 .43092 L\n.18 .42457 L\n.1819 .41829 L\n.18381 .41211 L\n.18571 .40602 L\n.18762 .40004 L\n.18952 .39418 L\n.19143 .38844 L\n.19333 .38284 L\n.19524 .37738 L\n.19714 .37207 L\n.19905 .36691 L\n.20095 .36191 L\n.20286 .35707 L\n.20476 .3524 L\n.20667 .3479 L\n.20857 .34357 L\n.21048 .33942 L\n.21238 .33544 L\nMistroke\n.21429 .33164 L\n.21619 .32802 L\n.2181 .32458 L\n.22 .32132 L\n.2219 .31823 L\n.22381 .31532 L\n.22571 .31259 L\n.22762 .31003 L\n.22952 .30763 L\n.23143 .30541 L\n.23333 .30335 L\n.23524 .30146 L\n.23714 .29972 L\n.23905 .29814 L\n.24095 .29671 L\n.24286 .29543 L\n.24476 .29429 L\n.24667 .29329 L\n.24857 .29242 L\n.25048 .29169 L\n.25238 .29108 L\n.25429 .29059 L\n.25619 .29022 L\n.2581 .28995 L\n.26 .2898 L\n.2619 .28975 L\n.26381 .28979 L\n.26571 .28993 L\n.26762 .29015 L\n.26952 .29046 L\n.27143 .29084 L\n.27333 .2913 L\n.27524 .29183 L\n.27714 .29241 L\n.27905 .29306 L\n.28095 .29377 L\n.28286 .29452 L\n.28476 .29532 L\n.28667 .29617 L\n.28857 .29705 L\n.29048 .29796 L\n.29238 .29891 L\n.29429 .29988 L\n.29619 .30087 L\n.2981 .30189 L\n.3 .30292 L\n.3019 .30396 L\n.30381 .30502 L\n.30571 .30608 L\n.30762 .30714 L\nMistroke\n.30952 .3082 L\n.31143 .30926 L\n.31333 .31032 L\n.31524 .31137 L\n.31714 .31241 L\n.31905 .31345 L\n.32095 .31446 L\n.32286 .31547 L\n.32476 .31645 L\n.32667 .31742 L\n.32857 .31837 L\n.33048 .3193 L\n.33238 .32021 L\n.33429 .32109 L\n.33619 .32195 L\n.3381 .32278 L\n.34 .32359 L\n.3419 .32437 L\n.34381 .32512 L\n.34571 .32585 L\n.34762 .32655 L\n.34952 .32721 L\n.35143 .32786 L\n.35333 .32847 L\n.35524 .32905 L\n.35714 .3296 L\n.35905 .33012 L\n.36095 .33062 L\n.36286 .33108 L\n.36476 .33152 L\n.36667 .33193 L\n.36857 .33232 L\n.37048 .33267 L\n.37238 .333 L\n.37429 .3333 L\n.37619 .33358 L\n.3781 .33383 L\n.38 .33406 L\n.3819 .33426 L\n.38381 .33444 L\n.38571 .3346 L\n.38762 .33474 L\n.38952 .33485 L\n.39143 .33494 L\n.39333 .33502 L\n.39524 .33508 L\n.39714 .33511 L\n.39905 .33513 L\n.40095 .33514 L\n.40286 .33513 L\nMistroke\n.40476 .3351 L\n.40667 .33506 L\n.40857 .33501 L\n.41048 .33494 L\n.41238 .33486 L\n.41429 .33477 L\n.41619 .33467 L\n.4181 .33457 L\n.42 .33445 L\n.4219 .33432 L\n.42381 .33419 L\n.42571 .33405 L\n.42762 .3339 L\n.42952 .33375 L\n.43143 .3336 L\n.43333 .33344 L\n.43524 .33327 L\n.43714 .33311 L\n.43905 .33294 L\n.44095 .33276 L\n.44286 .33259 L\n.44476 .33242 L\n.44667 .33224 L\n.44857 .33207 L\n.45048 .3319 L\n.45238 .33172 L\n.45429 .33155 L\n.45619 .33138 L\n.4581 .33121 L\n.46 .33105 L\n.4619 .33089 L\n.46381 .33073 L\n.46571 .33057 L\n.46762 .33041 L\n.46952 .33026 L\n.47143 .33012 L\n.47333 .32997 L\n.47524 .32983 L\n.47714 .3297 L\n.47905 .32957 L\n.48095 .32944 L\n.48286 .32932 L\n.48476 .3292 L\n.48667 .32909 L\n.48857 .32898 L\n.49048 .32888 L\n.49238 .32878 L\n.49429 .32869 L\n.49619 .3286 L\n.4981 .32851 L\nMistroke\n.5 .32843 L\n.5019 .32836 L\n.50381 .32829 L\n.50571 .32822 L\n.50762 .32816 L\n.50952 .3281 L\n.51143 .32805 L\n.51333 .328 L\n.51524 .32796 L\n.51714 .32792 L\n.51905 .32788 L\n.52095 .32785 L\n.52286 .32782 L\n.52476 .3278 L\n.52667 .32777 L\n.52857 .32776 L\n.53048 .32774 L\n.53238 .32773 L\n.53429 .32772 L\n.53619 .32772 L\n.5381 .32771 L\n.54 .32771 L\n.5419 .32771 L\n.54381 .32772 L\n.54571 .32773 L\n.54762 .32773 L\n.54952 .32775 L\n.55143 .32776 L\n.55333 .32777 L\n.55524 .32779 L\n.55714 .32781 L\n.55905 .32783 L\n.56095 .32785 L\n.56286 .32787 L\n.56476 .32789 L\n.56667 .32792 L\n.56857 .32795 L\n.57048 .32797 L\n.57238 .328 L\n.57429 .32803 L\n.57619 .32805 L\n.5781 .32808 L\n.58 .32811 L\n.5819 .32814 L\n.58381 .32817 L\n.58571 .3282 L\n.58762 .32823 L\n.58952 .32826 L\n.59143 .32829 L\n.59333 .32831 L\nMistroke\n.59524 .32834 L\n.59524 .32834 L\n.59524 .32834 L\n.59714 .35286 L\n.59905 .37613 L\n.60095 .39815 L\n.60286 .41893 L\n.60476 .43847 L\n.60667 .4568 L\n.60857 .47392 L\n.61048 .48986 L\n.61238 .50462 L\n.61429 .51823 L\n.61619 .53072 L\n.6181 .5421 L\n.62 .55241 L\n.6219 .56167 L\n.62381 .56992 L\n.62571 .57717 L\n.62762 .58345 L\n.62952 .58882 L\n.63143 .59328 L\n.63333 .59688 L\n.63524 .59965 L\n.63714 .60162 L\n.63905 .60283 L\n.64095 .60332 L\n.64286 .60311 L\n.64476 .60224 L\n.64667 .60075 L\n.64857 .59867 L\n.65048 .59603 L\n.65238 .59287 L\n.65429 .58922 L\n.65619 .58511 L\n.6581 .58058 L\n.66 .57566 L\n.6619 .57037 L\n.66381 .56476 L\n.66571 .55884 L\n.66762 .55265 L\n.66952 .54621 L\n.67143 .53957 L\n.67333 .53273 L\n.67524 .52573 L\n.67714 .51859 L\n.67905 .51133 L\n.68095 .50399 L\n.68286 .49657 L\n.68476 .48911 L\nMistroke\n.68667 .48163 L\n.68857 .47413 L\n.69048 .46665 L\n.69238 .45919 L\n.69429 .45178 L\n.69619 .44444 L\n.6981 .43716 L\n.7 .42998 L\n.7019 .4229 L\n.70381 .41594 L\n.70571 .4091 L\n.70762 .40241 L\n.70952 .39585 L\n.71143 .38946 L\n.71333 .38323 L\n.71524 .37717 L\n.71714 .37129 L\n.71905 .36559 L\n.72095 .36008 L\n.72286 .35476 L\n.72476 .34964 L\n.72667 .34472 L\n.72857 .34 L\n.73048 .33549 L\n.73238 .33118 L\n.73429 .32707 L\n.73619 .32317 L\n.7381 .31947 L\n.74 .31597 L\n.7419 .31267 L\n.74381 .30958 L\n.74571 .30668 L\n.74762 .30398 L\n.74952 .30147 L\n.75143 .29915 L\n.75333 .29701 L\n.75524 .29506 L\n.75714 .29327 L\n.75905 .29167 L\n.76095 .29023 L\n.76286 .28895 L\n.76476 .28783 L\n.76667 .28687 L\n.76857 .28605 L\n.77048 .28538 L\n.77238 .28484 L\n.77429 .28444 L\n.77619 .28416 L\n.7781 .284 L\n.78 .28396 L\nMistroke\n.7819 .28403 L\n.78381 .28421 L\n.78571 .28448 L\n.78762 .28485 L\n.78952 .28531 L\n.79143 .28585 L\n.79333 .28647 L\n.79524 .28716 L\n.79714 .28791 L\n.79905 .28873 L\n.80095 .28961 L\n.80286 .29054 L\n.80476 .29152 L\n.80667 .29254 L\n.80857 .2936 L\n.81048 .29469 L\n.81238 .29582 L\n.81429 .29696 L\n.81619 .29813 L\n.8181 .29932 L\n.82 .30053 L\n.8219 .30174 L\n.82381 .30295 L\n.82571 .30417 L\n.82762 .3054 L\n.82952 .30661 L\n.83143 .30783 L\n.83333 .30903 L\n.83524 .31023 L\n.83714 .31141 L\n.83905 .31258 L\n.84095 .31373 L\n.84286 .31485 L\n.84476 .31596 L\n.84667 .31705 L\n.84857 .31811 L\n.85048 .31914 L\n.85238 .32015 L\n.85429 .32113 L\n.85619 .32208 L\n.8581 .323 L\n.86 .32389 L\n.8619 .32475 L\n.86381 .32557 L\n.86571 .32637 L\n.86762 .32713 L\n.86952 .32786 L\n.87143 .32855 L\n.87333 .32921 L\n.87524 .32984 L\nMistroke\n.87714 .33044 L\n.87905 .331 L\n.88095 .33153 L\n.88286 .33203 L\n.88476 .33249 L\n.88667 .33292 L\n.88857 .33333 L\n.89048 .3337 L\n.89238 .33404 L\n.89429 .33435 L\n.89619 .33464 L\n.8981 .33489 L\n.9 .33512 L\n.9019 .33532 L\n.90381 .3355 L\n.90571 .33565 L\n.90762 .33578 L\n.90952 .33588 L\n.91143 .33596 L\n.91333 .33602 L\n.91524 .33606 L\n.91714 .33608 L\n.91905 .33608 L\n.92095 .33607 L\n.92286 .33603 L\n.92476 .33599 L\n.92667 .33592 L\n.92857 .33584 L\n.93048 .33575 L\n.93238 .33564 L\n.93429 .33553 L\n.93619 .3354 L\n.9381 .33526 L\n.94 .33512 L\n.9419 .33496 L\n.94381 .3348 L\n.94571 .33463 L\n.94762 .33446 L\n.94952 .33428 L\n.95143 .33409 L\n.95333 .3339 L\n.95524 .33371 L\n.95714 .33352 L\n.95905 .33332 L\n.96095 .33312 L\n.96286 .33292 L\n.96476 .33272 L\n.96667 .33252 L\n.96857 .33232 L\n.97048 .33213 L\nMistroke\n.97238 .33193 L\n.97429 .33173 L\n.97619 .33154 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(h) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00AP3IfMT2000000@0fMWI0P00000R0=WIf@D000000P3IfMT2000000@0\nfMWI0P00000O0=WIf@D000000P3IfMT2000000@0fMWI0P00000O0=WIf@@000000`3IfMT2000000@0\nfMWI0P00000O0=WIf@@000000`3IfMT2000000@0fMWI0P00000G0=WIf@00A@3IfMT010000000fMWI\n0=WIf@0000020=WIf@040000003IfMT0fMWI000002<0fMWI00D000000=WIf@3IfMT0fMWI00000002\n0=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT07P3IfMT01@000000fMWI0=WI\nf@3IfMT000000080fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@0L0=WIf@03\n0000003IfMT0fMWI00<0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@00000N\n0=WIf@030000003IfMT0fMWI00<0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WI\nf@00000F0=WIf@00B03IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI0240fMWI\n00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WI\nf@3IfMT07P3IfMT00`000000fMWI0=WIf@040=WIf@040000003IfMT0fMWI00000080fMWI00<00000\n0=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0fMWI00000080fMWI00@0\n00000=WIf@3IfMT000007`3IfMT00`000000fMWI0=WIf@050=WIf@040000003IfMT0fMWI00000080\nfMWI00<000000=WIf@3IfMT0503IfMT004H0fMWI0P0000030=WIf@040000003IfMT0fMWI000002<0\nfMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00<00000\n0=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@020=WIf@8000000`3IfMT010000000fMWI0=WIf@00\n000P0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@03\n0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT00P3IfMT2000000<0fMWI00@000000=WIf@3I\nfMT000005P3IfMT004H0fMWI00<000000=WIf@3IfMT00P3IfMT010000000fMWI0=WIf@00000S0=WI\nf@050000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@030000003I\nfMT0fMWI01h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@020=WIf@040000003I\nfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000020=WI\nf@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000000`3IfMT00`000000fMWI0=WI\nf@020=WIf@040000003IfMT0fMWI000001H0fMWI00160=WIf@<000000`3IfMT2000002<0fMWI0P00\n00040=WIf@800000103IfMT200000200fMWI0P0000040=WIf@<000000`3IfMT200000200fMWI0P00\n00040=WIf@800000103IfMT200000200fMWI0P0000040=WIf@<000000`3IfMT2000001L0fMWI003o\n0=WIfB40fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3b0=WIf@8000003@3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0l@3IfMT010000000fMWI0=WIf@00000<0=WIf@005P3IfMT6000000030000o`00\n000000000>T00000203IfMT00`000000fMWI0=WIf@0=0=WIf@00703IfMT00`000?l0fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@07\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@07\n0=WIf@030000003IfMT0fMWI00X0fMWI1@00000<0=WIf@00703IfMT00`000?l0fMWI0=WIf@3a0=WI\nf@030000003IfMT0fMWI00d0fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI\n00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WI\nf@00703IfMT00`000000003o0=WIf@3o0=WIf@80fMWI000L0=WIf@03000000000?l0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<000000000o`3IfMT0o`3IfMT20=WIf@00703IfMT00`000000003o0=WIf@3o\n0=WIf@80fMWI000L0=WIf@03000000000?l0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000000o`3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0000o`3o0=WIf@80fMWI000L0=WIf@030000003I\nfMT0003o0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@000?l0o`3IfMT20=WIf@00703IfMT00`00\n0000fMWI0000o`3o0=WIf@80fMWI000L0=WIf@030000003IfMT0003o0?l0fMWI0P3IfMT001`0fMWI\n00<000000=WIf@000?l0o`3IfMT20=WIf@00703IfMT010000000fMWI0=WIf@000?oo0=WIf@40fMWI\n000L0=WIf@040000003IfMT0fMWI0000ool0fMWI0@3IfMT001`0fMWI00@000000=WIf@3IfMT0003o\no`3IfMT10=WIf@00703IfMT010000000fMWI0=WIf@000?oo0=WIf@40fMWI000L0=WIf@040000003I\nfMT0fMWI0000ool0fMWI0@3IfMT001`0fMWI00@000000=WIf@3IfMT0003oo`3IfMT10=WIf@00703I\nfMT01@000000fMWI0=WIf@3IfMT0003o0?l0fMWI000L0=WIf@050000003IfMT0fMWI0=WIf@000?l0\no`3IfMT000T0fMWI0P0000040=WIf@8000000`3IfMT5000000<0fMWI00D000000=WIf@3IfMT0fMWI\n0000o`3o0=WIf@00203IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI00<0fMWI\n00D000000=WIf@3IfMT0fMWI0000o`3o0=WIf@00203IfMT010000000fMWI0=WIf@00000:0=WIf@03\n0000003IfMT0fMWI00<0fMWI0P0000020=WIf@030000o`3IfMT0fMWI0?d0fMWI00080=WIf@040000\n003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT0003o\n0?l0fMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00`3IfMT00`00\n0000fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI0?`0fMWI00090=WIf@8000002P3IfMT2000000D0\nfMWI00<000000=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@3l0=WIf@00703IfMT00`000000fMWI\n0=WIf@020=WIf@030000o`3IfMT0fMWI0?`0fMWI000L0=WIf@030000003IfMT0fMWI0080fMWI00<0\n003o0=WIf@3IfMT0o03IfMT001`0fMWI00<000000=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@3l\n0=WIf@00703IfMT00`000000fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI0?`0fMWI000L0=WIf@03\n0000003IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0n`3IfMT001`0fMWI00<000000=WIf@3IfMT0\n0`3IfMT00`000?l0fMWI0=WIf@3k0=WIf@00703IfMT00`000000fMWI0=WIf@030=WIf@030000o`3I\nfMT0fMWI0?/0fMWI000L0=WIf@030000003IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0n`3IfMT0\n01`0fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@3k0=WIf@00703IfMT00`000000\nfMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0?/0fMWI000L0=WIf@030000003IfMT0fMWI00<0fMWI\n00<0003o0=WIf@3IfMT0n`3IfMT001`0fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WI\nf@3k0=WIf@00703IfMT00`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0?/0fMWI000L0=WI\nf@030000003IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT0nP3IfMT001`0fMWI00<000000=WIf@3I\nfMT0103IfMT00`000?l0fMWI0=WIf@3j0=WIf@00703IfMT00`000000fMWI0=WIf@040=WIf@030000\no`3IfMT0fMWI0?X0fMWI000L0=WIf@030000003IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT0nP3I\nfMT001`0fMWI00<000000=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@3j0=WIf@00703IfMT00`00\n0000fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0?X0fMWI000L0=WIf@030000003IfMT0fMWI00D0\nfMWI00<0003o0=WIf@3IfMT0n@3IfMT001`0fMWI00<000000=WIf@3IfMT01@3IfMT00`000?l0fMWI\n0=WIf@3i0=WIf@00703IfMT00`000000fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0?T0fMWI000L\n0=WIf@030000003IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0n@3IfMT001`0fMWI00<000000=WI\nf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@3i0=WIf@00703IfMT00`000000fMWI0=WIf@050=WIf@03\n0000o`3IfMT0fMWI0?T0fMWI00090=WIf@800000103IfMT2000000<0fMWI100000040=WIf@030000\n003IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0n@3IfMT000P0fMWI00@000000=WIf@3IfMT00000\n203IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0\nn03IfMT000P0fMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@040=WIf@800000\n1`3IfMT00`000?l0fMWI0=WIf@3h0=WIf@00203IfMT010000000fMWI0=WIf@00000:0=WIf@030000\n003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@3h0=WIf@00203I\nfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3I\nfMT01P3IfMT00`000?l0fMWI0=WIf@3h0=WIf@002@3IfMT2000000X0fMWI0P0000050=WIf@030000\n003IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0n03IfMT001`0fMWI00<000000=WIf@3IfMT01P3I\nfMT00`000?l0fMWI0=WIf@2W0=WIf@L0003oBP3IfMT001`0fMWI00<000000=WIf@3IfMT01`3IfMT0\n0`000?l0fMWI0=WIf@0Z0=WIf@D0003oMP3IfMT20000o`D0fMWI10000?m70=WIf@00703IfMT00`00\n0000fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI02P0fMWI0`000?l30=WIf@@0003oLP3IfMT00`00\n0?l0fMWI0=WIf@080=WIf@<0003oA@3IfMT001`0fMWI00<000000=WIf@3IfMT01`3IfMT00`000?l0\nfMWI0=WIf@0W0=WIf@030000o`3IfMT0fMWI00P0fMWI0P000?m_0=WIf@030000o`3IfMT0fMWI00/0\nfMWI0P000?m40=WIf@00703IfMT00`000000fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI02H0fMWI\n00<0003o0=WIf@3IfMT02P3IfMT30000of`0fMWI00<0003o0=WIf@3IfMT03@3IfMT30000od80fMWI\n000L0=WIf@030000003IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT09@3IfMT00`000?l0fMWI0=WI\nf@0>0=WIf@80003oJ@3IfMT00`000?l0fMWI0=WIf@0@0=WIf@80003o@@3IfMT001`0fMWI00<00000\n0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0T0=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o\n0=WIf@3IfMT0I@3IfMT00`000?l0fMWI0=WIf@0C0=WIf@80003o?`3IfMT001`0fMWI00<000000=WI\nf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0R0=WIf@030000o`3IfMT0fMWI01<0fMWI0P000?mU0=WI\nf@030000o`3IfMT0fMWI01@0fMWI0P000?ln0=WIf@00703IfMT00`000000fMWI0=WIf@080=WIf@03\n0000o`3IfMT0fMWI0240fMWI00<0003o0=WIf@3IfMT05P3IfMT30000of40fMWI0P000?lH0=WIf@80\n003o?03IfMT001`0fMWI00<000000=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0Q0=WIf@030000\no`3IfMT0fMWI01P0fMWI0`000?mO0=WIf@030000o`3IfMT0fMWI01T0fMWI0P000?lj0=WIf@00703I\nfMT00`000000fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI0200fMWI00<0003o0=WIf@3IfMT06`3I\nfMT30000obT0fMWI2P000?l80=WIf@030000o`3IfMT0fMWI01h0fMWI00<0003o0=WIf@3IfMT0703I\nfMT20000ocP0fMWI000L0=WIf@030000003IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0803IfMT0\n0`000?l0fMWI0=WIf@0N0=WIf@@0003o503IfMTA0000o`X0fMWI2@000?lP0=WIf@030000o`3IfMT0\nfMWI01h0fMWI10000?lE0=WIf@80003o7@3IfMT001`0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0?l0fMWI0=WIf@0O0=WIf@030000o`3IfMT0fMWI02<0fMWI50000?lS0=WIf@030000o`3IfMT0fMWI\n01d0fMWI00<0003o0=WIf@3IfMT08P3IfMTF0000oal0fMWI000L0=WIf@030000003IfMT0fMWI00P0\nfMWI00<0003o0=WIf@3IfMT07`3IfMT00`000?l0fMWI0=WIf@1J0=WIf@030000o`3IfMT0fMWI01d0\nfMWI00<0003o0=WIf@3IfMT0E`3IfMT001`0fMWI00<000000=WIf@3IfMT0203IfMT00`000?l0fMWI\n0=WIf@0N0=WIf@030000o`3IfMT0fMWI05/0fMWI00<0003o0=WIf@3IfMT0703IfMT00`000?l0fMWI\n0=WIf@1H0=WIf@00703IfMT00`000000fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI01h0fMWI00<0\n003o0=WIf@3IfMT0F`3IfMT00`000?l0fMWI0=WIf@0L0=WIf@030000o`3IfMT0fMWI05P0fMWI000L\n0=WIf@030000003IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0703IfMT00`000?l0fMWI0=WIf@1L\n0=WIf@030000o`3IfMT0fMWI01`0fMWI00<0003o0=WIf@3IfMT0F03IfMT001`0fMWI00<000000=WI\nf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0L0=WIf@030000o`3IfMT0fMWI05`0fMWI00<0003o0=WI\nf@3IfMT06`3IfMT00`000?l0fMWI0=WIf@1I0=WIf@00703IfMT00`000000fMWI0=WIf@090=WIf@03\n0000o`3IfMT0fMWI01`0fMWI00<0003o0=WIf@3IfMT0G03IfMT00`000?l0fMWI0=WIf@0K0=WIf@03\n0000o`3IfMT0fMWI05T0fMWI000L0=WIf@030000003IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0\n6`3IfMT00`000?l0fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI01/0fMWI00<0003o0=WIf@3IfMT0\nF@3IfMT001`0fMWI00<000000=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0K0=WIf@030000o`3I\nfMT0fMWI05h0fMWI00<0003o0=WIf@3IfMT06P3IfMT00`000?l0fMWI0=WIf@1I0=WIf@00703IfMT0\n0`000000fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI01X0fMWI00<0003o0=WIf@3IfMT0G`3IfMT0\n0`000?l0fMWI0=WIf@0I0=WIf@030000o`3IfMT0fMWI05X0fMWI000L0=WIf@030000003IfMT0fMWI\n00X0fMWI00<0003o0=WIf@3IfMT06@3IfMT00`000?l0fMWI0=WIf@1O0=WIf@030000o`3IfMT0fMWI\n01T0fMWI00<0003o0=WIf@3IfMT0FP3IfMT001`0fMWI00<000000=WIf@3IfMT02P3IfMT00`000?l0\nfMWI0=WIf@0H0=WIf@030000o`3IfMT0fMWI0600fMWI00<0003o0=WIf@3IfMT0603IfMT00`000?l0\nfMWI0=WIf@1K0=WIf@002@3IfMT2000000@0fMWI0P0000040=WIf@8000001@3IfMT00`000000fMWI\n0=WIf@0:0=WIf@030000o`3IfMT0fMWI01P0fMWI00<0003o0=WIf@3IfMT0H03IfMT00`000?l0fMWI\n0=WIf@0H0=WIf@030000o`3IfMT0fMWI05/0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI\n00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI01P0\nfMWI00<0003o0=WIf@3IfMT0H03IfMT00`000?l0fMWI0=WIf@0H0=WIf@030000o`3IfMT0fMWI05/0\nfMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00`3IfMT2000000/0\nfMWI00<0003o0=WIf@3IfMT0603IfMT00`000?l0fMWI0=WIf@1P0=WIf@030000o`3IfMT0fMWI01L0\nfMWI00<0003o0=WIf@3IfMT0G03IfMT000P0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000\nfMWI0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0603IfMT00`000?l0\nfMWI0=WIf@1P0=WIf@030000o`3IfMT0fMWI01L0fMWI00<0003o0=WIf@3IfMT0G03IfMT000P0fMWI\n00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI\n00/0fMWI00<0003o0=WIf@3IfMT05P3IfMT00`000?l0fMWI0=WIf@1Q0=WIf@030000o`3IfMT0fMWI\n01L0fMWI00<0003o0=WIf@3IfMT0G03IfMT000T0fMWI0P00000:0=WIf@8000001@3IfMT00`000000\nfMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI01H0fMWI00<0003o0=WIf@3IfMT0H@3IfMT00`000?l0\nfMWI0=WIf@0G0=WIf@030000o`3IfMT0fMWI05`0fMWI000L0=WIf@030000003IfMT0fMWI00/0fMWI\n00<0003o0=WIf@3IfMT05@3IfMT00`000?l0fMWI0=WIf@1R0=WIf@030000o`3IfMT0fMWI01H0fMWI\n00<0003o0=WIf@3IfMT0G@3IfMT001`0fMWI00<000000=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WI\nf@0E0=WIf@030000o`3IfMT0fMWI0680fMWI00<0003o0=WIf@3IfMT05P3IfMT00`000?l0fMWI0=WI\nf@1M0=WIf@00703IfMT00`000000fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI01D0fMWI00<0003o\n0=WIf@3IfMT0HP3IfMT00`000?l0fMWI0=WIf@0F0=WIf@030000o`3IfMT0fMWI05d0fMWI000L0=WI\nf@030000003IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@1S0=WI\nf@030000o`3IfMT0fMWI01D0fMWI00<0003o0=WIf@3IfMT0GP3IfMT001`0fMWI00<000000=WIf@3I\nfMT0303IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI06<0fMWI00<0003o0=WIf@3I\nfMT05@3IfMT00`000?l0fMWI0=WIf@1N0=WIf@00703IfMT00`000000fMWI0=WIf@0<0=WIf@030000\no`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0H`3IfMT00`000?l0fMWI0=WIf@0E0=WIf@030000\no`3IfMT0fMWI05h0fMWI000L0=WIf@030000003IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT04P3I\nfMT00`000?l0fMWI0=WIf@1U0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0G`3I\nfMT001`0fMWI00<000000=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0\nfMWI06D0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@1O0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0I@3IfMT00`00\n0?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI05l0fMWI000L0=WIf@030000003IfMT0fMWI00`0\nfMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@1U0=WIf@030000o`3IfMT0fMWI01<0\nfMWI00<0003o0=WIf@3IfMT0G`3IfMT001`0fMWI00<000000=WIf@3IfMT03@3IfMT00`000?l0fMWI\n0=WIf@0@0=WIf@030000o`3IfMT0fMWI06H0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI\n0=WIf@1O0=WIf@00703IfMT00`000000fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI0100fMWI00<0\n003o0=WIf@3IfMT0IP3IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI0600fMWI000L\n0=WIf@030000003IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@1V\n0=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0H03IfMT001`0fMWI00<000000=WI\nf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI06H0fMWI00<0003o0=WI\nf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@1P0=WIf@00703IfMT00`000000fMWI0=WIf@0=0=WIf@03\n0000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT0I`3IfMT00`000?l0fMWI0=WIf@0B0=WIf@03\n0000o`3IfMT0fMWI0600fMWI000L0=WIf@030000003IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0\n3`3IfMT00`000?l0fMWI0=WIf@1X0=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT0\nH@3IfMT001`0fMWI00<000000=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3I\nfMT0fMWI06P0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@1Q0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0J@3IfMT0\n0`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI0640fMWI000L0=WIf@030000003IfMT0fMWI\n00h0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@1Y0=WIf@030000o`3IfMT0fMWI\n0100fMWI00<0003o0=WIf@3IfMT0H@3IfMT001`0fMWI00<000000=WIf@3IfMT03P3IfMT00`000?l0\nfMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI06T0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0\nfMWI0=WIf@1R0=WIf@00703IfMT00`000000fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00`0fMWI\n00<0003o0=WIf@3IfMT0JP3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI0680fMWI\n000L0=WIf@030000003IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WI\nf@1Z0=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT0HP3IfMT001`0fMWI00<00000\n0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI06/0fMWI00<0003o\n0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@1S0=WIf@00703IfMT00`000000fMWI0=WIf@0>0=WI\nf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT0J`3IfMT00`000?l0fMWI0=WIf@0=0=WI\nf@030000o`3IfMT0fMWI06<0fMWI00090=WIf@800000103IfMT2000000D0fMWI0`0000030=WIf@03\n0000003IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@1/0=WIf@03\n0000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0H`3IfMT000P0fMWI00@000000=WIf@3IfMT0\n00002`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI00<0003o0=WIf@3I\nfMT02P3IfMT00`000?l0fMWI0=WIf@1/0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3I\nfMT0H`3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT5000000<0fMWI0P00000@0=WIf@03\n0000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0K@3IfMT00`000?l0fMWI0=WIf@0<0=WIf@03\n0000o`3IfMT0fMWI06@0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3I\nfMT00000103IfMT00`000000fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WI\nf@3IfMT0K@3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI06@0fMWI00080=WIf@04\n0000003IfMT0fMWI000000T0fMWI00<000000=WIf@000000103IfMT00`000000fMWI0=WIf@0?0=WI\nf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0K@3IfMT00`000?l0fMWI0=WIf@0<0=WI\nf@030000o`3IfMT0fMWI06@0fMWI00090=WIf@8000002`3IfMT2000000@0fMWI00<000000=WIf@3I\nfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI06l0fMWI00<0003o0=WIf@3I\nfMT02P3IfMT00`000?l0fMWI0=WIf@1U0=WIf@00703IfMT00`000000fMWI0=WIf@0@0=WIf@030000\no`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0K`3IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000\no`3IfMT0fMWI06D0fMWI000L0=WIf@030000003IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01`3I\nfMT00`000?l0fMWI0=WIf@1_0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0I@3I\nfMT001`0fMWI00<000000=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0\nfMWI06l0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@1U0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0L03IfMT00`00\n0?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI06D0fMWI000L0=WIf@030000003IfMT0fMWI0140\nfMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@1a0=WIf@030000o`3IfMT0fMWI00P0\nfMWI00<0003o0=WIf@3IfMT0IP3IfMT001`0fMWI00<000000=WIf@3IfMT04P3IfMT00`000?l0fMWI\n0=WIf@030=WIf@030000o`3IfMT0fMWI0780fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI\n0=WIf@1V0=WIf@00703IfMT00`000000fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI0080fMWI0P00\n0?md0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0IP3IfMT001`0fMWI00<00000\n0=WIf@3IfMT04`3IfMT01@000?l0fMWI0=WIf@3IfMT0003o07D0fMWI00<0003o0=WIf@3IfMT01`3I\nfMT00`000?l0fMWI0=WIf@1W0=WIf@00703IfMT00`000000fMWI0=WIf@0C0=WIf@@0003oMP3IfMT0\n0`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI06L0fMWI000L0=WIf@030000003IfMT0fMWI\n01@0fMWI0P000?mg0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0I`3IfMT001`0\nfMWI00<000000=WIf@3IfMT0S@3IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI06P0\nfMWI000L0=WIf@030000003IfMT0fMWI08h0fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI\n0=WIf@1X0=WIf@00703IfMT00`000000fMWI0=WIf@2>0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0\n003o0=WIf@3IfMT0J03IfMT001`0fMWI00<000000=WIf@3IfMT0SP3IfMT00`000?l0fMWI0=WIf@04\n0=WIf@030000o`3IfMT0fMWI06T0fMWI000L0=WIf@030000003IfMT0fMWI08l0fMWI00<0003o0=WI\nf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@1Y0=WIf@00703IfMT00`000000fMWI0=WIf@2?0=WIf@03\n0000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0JP3IfMT001`0fMWI00<000000=WIf@3IfMT0\nT03IfMT010000?l0fMWI0=WIf@000?m]0=WIf@00703IfMT00`000000fMWI0=WIf@2A0=WIf@<0003o\nK@3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o\n0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0o`3IfMT20=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00:P3IfMT2000000P0fMWI0P00003Z0=WIf@00:P3IfMT00`000000fMWI0=WIf@080=WIf@030000\n003IfMT0fMWI0>P0fMWI000Q0=WIf@<0000000<0fMWI0000000000000`3IfMT00`000000fMWI0=WI\nf@020=WIf@800000103IfMT00`000000fMWI0=WIf@3X0=WIf@008P3IfMT010000000fMWI0=WIf@00\n00040=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT01@000000fMWI0=WIf@3IfMT000000>X0\nfMWI000F0=WIf@P0003o103IfMT010000000fMWI0=WIf@0000040=WIf@050000003IfMT0fMWI0=WI\nf@0000001P3IfMT00`000000fMWI0=WIf@3X0=WIf@008P3IfMT3000000D0fMWI00<000000=WIf@3I\nfMT01@0000030=WIf@030000003IfMT0fMWI0>P0fMWI000R0=WIf@030000003IfMT0fMWI00D0fMWI\n00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0>P0fMWI000Q0=WIf@800000\n1`3IfMT2000000P0fMWI0P00003Z0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-30.4421`, -0.0744245`, 1.08639`, 0.00329462`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell[BoxData[TagBox[RowBox[List[RowBox[List["\[SkeletonIndicator]", "Graphics"]], "\[SkeletonIndicator]"]], False, Rule[Editable, False]]], "Output"]], Open]], Cell[CellGroupData[List[Cell["Tank Model Componets", "Section"], Cell[CellGroupData[List[Cell["Connectors", "Subsection"], Cell["connector ReadSignal\n  Real val;\nend ReadSignal;", "ModelicaInput"], Cell["", "Text"], Cell["connector ActSignal\n  Real act;\nend ActSignal;", "ModelicaInput"], Cell["", "Text"], Cell["connector LiquidFlow\n  Real lflow;\nend FlowIn;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Functions", "Subsection"], Cell["function LimitValue\n  input Real pMin;\n  input Real pMax;\n  input Real p;\n  output Real pLim;\nalgorithm\n  pLim := if p>pMax then pMax\n          else if p<pMin then pMin \n          else p;\nend LimitValue;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Components", "Subsection"], Cell[CellGroupData[List[Cell["PI Controlers", "Subsubsection"], Cell["partial model PIcontroller\n  parameter Real Ts=0.1;//sampling time[s]\n  parameter Real K=2;//gain\n  parameter Real T=10;//time constant[s]\n  parameter Real minV=0,maxV=1;//limits for output\n  Real      ref,error,outCtr;\n  ReadSignal cInp;\n  ActSignal  cOut;\nequation\n  error = ref-cInp.val;\n  cOut.act = LimitValue(minV,maxV,outCtr);\nend PIcontroller;", "ModelicaInput"], Cell["", "Text"], Cell["model PIcontinuousController\n  extends PIcontroller(K=2,T=10,maxV=0.02);\n  Real  x; //state variable of continuous controller\nequation\n  der(x) = error/T;\n  outCtr = K*(x+error);\nend PIcontinuousController;\n", "ModelicaInput"], Cell["", "Text"], Cell["model PIdiscreteController\n  extends PIcontroller(K=2,T=10,maxV=0.02);\n  discrete Real x; //state variable of discrete controller\nequation\n  when sample(0,Ts) then\n    x = pre(x)+error*Ts/T;\n    outCtr = K*(x+error);\n  end when;\nend PIdiscreteController;\n", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["PID Controlers", "Subsubsection"], Cell["partial model PIDcontroller\n  parameter Real Ts=0.1;//sampling time[s]\n  parameter Real K=2;//gain\n  parameter Real T=10;//time constant[s]\n  parameter Real minV=0,maxV=1;//limits for output\n  Real      ref,error,outCtr;\n  ReadSignal cInp;\n  ActSignal  cOut;\nequation\n  error = ref-cInp.val;\n  cOut.act = LimitValue(minV,maxV,outCtr);\nend PIDcontroller;", "ModelicaInput"], Cell["", "Text"], Cell["model PIDcontinuousController\n  extends PIDcontroller(K=2,T=10,maxV=0.02);\n  Real  x; //state variable of continuous controller\n  Real  y; //state variable of continuous controller\nequation\n  der(x) = error/T;\n  y=T*der(error);\n  outCtr = K*(x+error+y);\nend PIDcontinuousController;\n", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Tank", "Subsubsection"], Cell["model Tank\n  ReadSignal tOut;  // Connector, reading tank level\n  ActSignal  tInp;  // Connector, actuator controlling input flow\n  parameter Real flowVout =0.01; //[m3/s]\n  parameter Real area =0.5;      //[m2]\n  parameter Real flowGain =10;   //[m2/s]\n  Real h(start=0);    //tank level [m]\n  Real qIn;  // flow through input valve[m3/s]\n  Real qOut; // flow through output valve[m3/s]\nequation\n  der(h)=(qIn-qOut)/area; //mass balance equation\n  qOut=if time>100 then flowVout else 0; // interface between discrete and \n                                         // continuous part\n  qIn = flowGain*tInp.act;\n  tOut.val = h;\nend Tank;\n", "ModelicaInput"], Cell["", "Text"], Cell["model TankL\n  ReadSignal tOut;  // Connector, reading tank level\n  ActSignal  tInp;  // Connector, actuator controlling input flow\n  LiquidFlow qIn;  // flow through input valve[m3/s]\n  LiquidFlow qOut; // flow through output valve[m3/s]\n  \n  \n  parameter Real flowVout =0.01; //[m3/s]\n  parameter Real area =0.5;      //[m2]\n  parameter Real flowGain=10;   //[m2/s]\n  Real h(start=0);    //tank level [m]\n  \nequation\n  der(h)=(qIn.lflow-qOut.lflow)/area; //mass balance equation\n  qIn.lflow = flowGain*tInp.act;\n  tOut.val = h;\nend TankL;", "ModelicaInput"], Cell["", "Text"], Cell["model FlowOut\n  LiquidFlow qOut;\n  parameter Real flowVOut = 0.01;\nequation\n  qOut.lflow=if time>100 then flowVOut else 0;\nend FlowOut;", "ModelicaInput"]], Open]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Tank Model with PI discrete controler", "Section"], Cell[CellGroupData[List[Cell["Old Tank Model", "Subsection"], Cell["model TankApplicationDiscretePI\n  PIdiscreteController piDiscrete;\n  Tank  tank(area=1,flowVout=0.02);\nequation\n  connect(tank.tInp,piDiscrete.cOut);\n  connect(tank.tOut,piDiscrete.cInp);\n  piDiscrete.ref=0.5;\nend TankApplicationDiscretePI;", "ModelicaInput"], Cell["", "Text"], Cell["simulate( TankApplicationDiscretePI, stopTime=200 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(TankApplicationDiscretePI\\) : 2004-2-4 10:47:27.1194546 : \\!\\({0.`, 200.`}\\) : 4003 data points : 1 events : 20 variables>\\n\\!\\({\\*TagBox[\\(piDiscrete . cInp . val\\), HoldForm], \\*TagBox[\\(piDiscrete . cOut . act\\), HoldForm], \\*TagBox[\\(piDiscrete . error\\), HoldForm], \\*TagBox[\\(piDiscrete . K\\), HoldForm], \\*TagBox[\\(piDiscrete . maxV\\), HoldForm], \\*TagBox[\\(piDiscrete . minV\\), HoldForm], \\*TagBox[\\(piDiscrete . outCtr\\), HoldForm], \\*TagBox[\\(piDiscrete . ref\\), HoldForm], \\*TagBox[\\(piDiscrete . T\\), HoldForm], \\*TagBox[\\(piDiscrete . Ts\\), HoldForm], \\*TagBox[\\(piDiscrete . x\\), HoldForm], \\*TagBox[\\(tank . area\\), HoldForm], \\*TagBox[\\(tank . flowGain\\), HoldForm], \\*TagBox[\\(tank . flowVout\\), HoldForm], \\*TagBox[\\(tank . h\\), HoldForm], \\*TagBox[\\(tank . qIn\\), HoldForm], \\*TagBox[\\(tank . qOut\\), HoldForm], \\*TagBox[\\(tank . tInp . act\\), HoldForm], \\*TagBox[\\(tank . tOut . val\\), HoldForm], \\*TagBox[SuperscriptBox[\\((tank . h)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( tank.h );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.0047619 0.0147151 1.037 [\n[.2619 .00222 -6 -9 ]\n[.2619 .00222 6 0 ]\n[.5 .00222 -9 -9 ]\n[.5 .00222 9 0 ]\n[.7381 .00222 -9 -9 ]\n[.7381 .00222 9 0 ]\n[.97619 .00222 -9 -9 ]\n[.97619 .00222 9 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .11842 -18 -4.5 ]\n[.01131 .11842 0 4.5 ]\n[.01131 .22212 -18 -4.5 ]\n[.01131 .22212 0 4.5 ]\n[.01131 .32582 -18 -4.5 ]\n[.01131 .32582 0 4.5 ]\n[.01131 .42952 -18 -4.5 ]\n[.01131 .42952 0 4.5 ]\n[.01131 .53322 -18 -4.5 ]\n[.01131 .53322 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.2619 .01472 m\n.2619 .02097 L\ns\n[(50)] .2619 .00222 0 1 Mshowa\n.5 .01472 m\n.5 .02097 L\ns\n[(100)] .5 .00222 0 1 Mshowa\n.7381 .01472 m\n.7381 .02097 L\ns\n[(150)] .7381 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(200)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.07143 .01472 m\n.07143 .01847 L\ns\n.11905 .01472 m\n.11905 .01847 L\ns\n.16667 .01472 m\n.16667 .01847 L\ns\n.21429 .01472 m\n.21429 .01847 L\ns\n.30952 .01472 m\n.30952 .01847 L\ns\n.35714 .01472 m\n.35714 .01847 L\ns\n.40476 .01472 m\n.40476 .01847 L\ns\n.45238 .01472 m\n.45238 .01847 L\ns\n.54762 .01472 m\n.54762 .01847 L\ns\n.59524 .01472 m\n.59524 .01847 L\ns\n.64286 .01472 m\n.64286 .01847 L\ns\n.69048 .01472 m\n.69048 .01847 L\ns\n.78571 .01472 m\n.78571 .01847 L\ns\n.83333 .01472 m\n.83333 .01847 L\ns\n.88095 .01472 m\n.88095 .01847 L\ns\n.92857 .01472 m\n.92857 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .11842 m\n.03006 .11842 L\ns\n[(0.1)] .01131 .11842 1 0 Mshowa\n.02381 .22212 m\n.03006 .22212 L\ns\n[(0.2)] .01131 .22212 1 0 Mshowa\n.02381 .32582 m\n.03006 .32582 L\ns\n[(0.3)] .01131 .32582 1 0 Mshowa\n.02381 .42952 m\n.03006 .42952 L\ns\n[(0.4)] .01131 .42952 1 0 Mshowa\n.02381 .53322 m\n.03006 .53322 L\ns\n[(0.5)] .01131 .53322 1 0 Mshowa\n.125 Mabswid\n.02381 .03546 m\n.02756 .03546 L\ns\n.02381 .0562 m\n.02756 .0562 L\ns\n.02381 .07694 m\n.02756 .07694 L\ns\n.02381 .09768 m\n.02756 .09768 L\ns\n.02381 .13916 m\n.02756 .13916 L\ns\n.02381 .1599 m\n.02756 .1599 L\ns\n.02381 .18064 m\n.02756 .18064 L\ns\n.02381 .20138 m\n.02756 .20138 L\ns\n.02381 .24286 m\n.02756 .24286 L\ns\n.02381 .2636 m\n.02756 .2636 L\ns\n.02381 .28434 m\n.02756 .28434 L\ns\n.02381 .30508 m\n.02756 .30508 L\ns\n.02381 .34656 m\n.02756 .34656 L\ns\n.02381 .3673 m\n.02756 .3673 L\ns\n.02381 .38804 m\n.02756 .38804 L\ns\n.02381 .40878 m\n.02756 .40878 L\ns\n.02381 .45026 m\n.02756 .45026 L\ns\n.02381 .471 m\n.02756 .471 L\ns\n.02381 .49174 m\n.02756 .49174 L\ns\n.02381 .51248 m\n.02756 .51248 L\ns\n.02381 .55396 m\n.02756 .55396 L\ns\n.02381 .5747 m\n.02756 .5747 L\ns\n.02381 .59544 m\n.02756 .59544 L\ns\n.02381 .61618 m\n.02756 .61618 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02429 .03546 L\n.02429 .03546 L\n.02476 .0562 L\n.02476 .0562 L\n.02524 .07694 L\n.02524 .07694 L\n.02571 .09768 L\n.02571 .09768 L\n.02619 .11842 L\n.02619 .11842 L\n.02667 .13916 L\n.02667 .13916 L\n.02714 .1599 L\n.02714 .1599 L\n.02762 .18064 L\n.02762 .18064 L\n.0281 .20138 L\n.0281 .20138 L\n.02857 .22212 L\n.02857 .22212 L\n.02905 .24286 L\n.02905 .24286 L\n.02952 .2636 L\n.02952 .2636 L\n.03 .28434 L\n.03 .28434 L\n.03048 .30508 L\n.03048 .30508 L\n.03095 .32582 L\n.03095 .32582 L\n.03143 .34656 L\n.03143 .34656 L\n.0319 .3673 L\n.0319 .3673 L\n.03238 .38804 L\n.03238 .38804 L\n.03286 .40878 L\n.03286 .40878 L\n.03333 .42952 L\n.03333 .42952 L\n.03381 .45026 L\n.03381 .45026 L\n.03429 .471 L\n.03429 .471 L\n.03476 .49174 L\n.03476 .49174 L\n.03524 .51248 L\n.03524 .51248 L\n.03571 .53322 L\nMistroke\n.03571 .53322 L\n.03619 .55396 L\n.03619 .55396 L\n.03667 .5747 L\n.03667 .5747 L\n.03714 .59544 L\n.03714 .59544 L\n.03762 .60332 L\n.03762 .60332 L\n.0381 .60332 L\n.0381 .60332 L\n.03857 .60332 L\n.03857 .60332 L\n.03905 .60332 L\n.03905 .60332 L\n.03952 .60332 L\n.03952 .60332 L\n.04 .60332 L\n.04 .60332 L\n.04048 .60332 L\n.04048 .60332 L\n.04095 .60332 L\n.04095 .60332 L\n.04143 .60332 L\n.04143 .60332 L\n.0419 .60332 L\n.0419 .60332 L\n.04238 .60332 L\n.04238 .60332 L\n.04286 .60332 L\n.04286 .60332 L\n.04333 .60332 L\n.04333 .60332 L\n.04381 .60332 L\n.04381 .60332 L\n.04429 .60332 L\n.04429 .60332 L\n.04476 .60332 L\n.04476 .60332 L\n.04524 .60332 L\n.04524 .60332 L\n.04571 .60332 L\n.04571 .60332 L\n.04619 .60332 L\n.04619 .60332 L\n.04667 .60332 L\n.04667 .60332 L\n.04714 .60332 L\n.04714 .60332 L\n.04762 .60332 L\nMistroke\n.04762 .60332 L\n.0481 .60332 L\n.0481 .60332 L\n.04857 .60332 L\n.04857 .60332 L\n.04905 .60332 L\n.04905 .60332 L\n.04952 .60332 L\n.04952 .60332 L\n.05 .60332 L\n.05 .60332 L\n.05048 .60332 L\n.05048 .60332 L\n.05095 .60332 L\n.05095 .60332 L\n.05143 .60332 L\n.05143 .60332 L\n.0519 .60332 L\n.0519 .60332 L\n.05238 .60332 L\n.05238 .60332 L\n.05286 .60332 L\n.05286 .60332 L\n.05333 .60332 L\n.05333 .60332 L\n.05381 .60332 L\n.05381 .60332 L\n.05429 .60332 L\n.05429 .60332 L\n.05476 .60332 L\n.05476 .60332 L\n.05524 .60332 L\n.05524 .60332 L\n.05571 .60332 L\n.05571 .60332 L\n.05619 .60332 L\n.05619 .60332 L\n.05667 .60332 L\n.05667 .60332 L\n.05714 .60332 L\n.05714 .60332 L\n.05762 .60332 L\n.05762 .60332 L\n.0581 .60332 L\n.0581 .60332 L\n.05857 .60332 L\n.05857 .60332 L\n.05905 .60332 L\n.05905 .60332 L\n.05952 .60332 L\nMistroke\n.05952 .60332 L\n.06 .60332 L\n.06 .60332 L\n.06048 .60332 L\n.06048 .60332 L\n.06095 .60332 L\n.06095 .60332 L\n.06143 .60332 L\n.06143 .60332 L\n.0619 .60332 L\n.0619 .60332 L\n.06238 .60332 L\n.06238 .60332 L\n.06286 .60332 L\n.06286 .60332 L\n.06333 .60332 L\n.06333 .60332 L\n.06381 .60332 L\n.06381 .60332 L\n.06429 .60332 L\n.06429 .60332 L\n.06476 .60332 L\n.06476 .60332 L\n.06524 .60332 L\n.06524 .60332 L\n.06571 .60332 L\n.06571 .60332 L\n.06619 .60332 L\n.06619 .60332 L\n.06667 .60332 L\n.06667 .60332 L\n.06714 .60332 L\n.06714 .60332 L\n.06762 .60332 L\n.06762 .60332 L\n.0681 .60332 L\n.0681 .60332 L\n.06857 .60332 L\n.06857 .60332 L\n.06905 .60332 L\n.06905 .60332 L\n.06952 .60332 L\n.06952 .60332 L\n.07 .60332 L\n.07 .60332 L\n.07048 .60332 L\n.07048 .60332 L\n.07095 .60332 L\n.07095 .60332 L\n.07143 .60332 L\nMistroke\n.07143 .60332 L\n.0719 .60332 L\n.0719 .60332 L\n.07238 .60332 L\n.07238 .60332 L\n.07286 .60332 L\n.07286 .60332 L\n.07333 .60332 L\n.07333 .60332 L\n.07381 .60332 L\n.07381 .60332 L\n.07429 .60332 L\n.07429 .60332 L\n.07476 .60332 L\n.07476 .60332 L\n.07524 .60332 L\n.07524 .60332 L\n.07571 .60332 L\n.07571 .60332 L\n.07619 .60332 L\n.07619 .60332 L\n.07667 .60332 L\n.07667 .60332 L\n.07714 .60332 L\n.07714 .60332 L\n.07762 .60332 L\n.07762 .60332 L\n.0781 .60332 L\n.0781 .60332 L\n.07857 .60332 L\n.07857 .60332 L\n.07905 .60332 L\n.07905 .60332 L\n.07952 .60332 L\n.07952 .60332 L\n.08 .60332 L\n.08 .60332 L\n.08048 .60332 L\n.08048 .60332 L\n.08095 .60332 L\n.08095 .60332 L\n.08143 .60332 L\n.08143 .60332 L\n.0819 .60332 L\n.0819 .60332 L\n.08238 .60332 L\n.08238 .60332 L\n.08286 .60332 L\n.08286 .60332 L\n.08333 .60332 L\nMistroke\n.08333 .60332 L\n.08381 .60332 L\n.08381 .60332 L\n.08429 .60332 L\n.08429 .60332 L\n.08476 .60332 L\n.08476 .60332 L\n.08524 .60332 L\n.08524 .60332 L\n.08571 .60332 L\n.08571 .60332 L\n.08619 .60332 L\n.08619 .60332 L\n.08667 .60332 L\n.08667 .60332 L\n.08714 .60332 L\n.08714 .60332 L\n.08762 .60332 L\n.08762 .60332 L\n.0881 .60332 L\n.0881 .60332 L\n.08857 .60332 L\n.08857 .60332 L\n.08905 .60332 L\n.08905 .60332 L\n.08952 .60332 L\n.08952 .60332 L\n.09 .60332 L\n.09 .60332 L\n.09048 .60332 L\n.09048 .60332 L\n.09095 .60332 L\n.09095 .60332 L\n.09143 .60332 L\n.09143 .60332 L\n.0919 .60332 L\n.0919 .60332 L\n.09238 .60332 L\n.09238 .60332 L\n.09286 .60332 L\n.09286 .60332 L\n.09333 .60332 L\n.09333 .60332 L\n.09381 .60332 L\n.09381 .60332 L\n.09429 .60332 L\n.09429 .60332 L\n.09476 .60332 L\n.09476 .60332 L\n.09524 .60332 L\nMistroke\n.09524 .60332 L\n.09571 .60332 L\n.09571 .60332 L\n.09619 .60332 L\n.09619 .60332 L\n.09667 .60332 L\n.09667 .60332 L\n.09714 .60332 L\n.09714 .60332 L\n.09762 .60332 L\n.09762 .60332 L\n.0981 .60332 L\n.0981 .60332 L\n.09857 .60332 L\n.09857 .60332 L\n.09905 .60332 L\n.09905 .60332 L\n.09952 .60332 L\n.09952 .60332 L\n.1 .60332 L\n.1 .60332 L\n.10048 .60332 L\n.10048 .60332 L\n.10095 .60332 L\n.10095 .60332 L\n.10143 .60332 L\n.10143 .60332 L\n.1019 .60332 L\n.1019 .60332 L\n.10238 .60332 L\n.10238 .60332 L\n.10286 .60332 L\n.10286 .60332 L\n.10333 .60332 L\n.10333 .60332 L\n.10381 .60332 L\n.10381 .60332 L\n.10429 .60332 L\n.10429 .60332 L\n.10476 .60332 L\n.10476 .60332 L\n.10524 .60332 L\n.10524 .60332 L\n.10571 .60332 L\n.10571 .60332 L\n.10619 .60332 L\n.10619 .60332 L\n.10667 .60332 L\n.10667 .60332 L\n.10714 .60332 L\nMistroke\n.10714 .60332 L\n.10762 .60332 L\n.10762 .60332 L\n.1081 .60332 L\n.1081 .60332 L\n.10857 .60332 L\n.10857 .60332 L\n.10905 .60332 L\n.10905 .60332 L\n.10952 .60332 L\n.10952 .60332 L\n.11 .60332 L\n.11 .60332 L\n.11048 .60332 L\n.11048 .60332 L\n.11095 .60332 L\n.11095 .60332 L\n.11143 .60332 L\n.11143 .60332 L\n.1119 .60332 L\n.1119 .60332 L\n.11238 .60332 L\n.11238 .60332 L\n.11286 .60332 L\n.11286 .60332 L\n.11333 .60332 L\n.11333 .60332 L\n.11381 .60332 L\n.11381 .60332 L\n.11429 .60332 L\n.11429 .60332 L\n.11476 .60332 L\n.11476 .60332 L\n.11524 .60332 L\n.11524 .60332 L\n.11571 .60332 L\n.11571 .60332 L\n.11619 .60332 L\n.11619 .60332 L\n.11667 .60332 L\n.11667 .60332 L\n.11714 .60332 L\n.11714 .60332 L\n.11762 .60332 L\n.11762 .60332 L\n.1181 .60332 L\n.1181 .60332 L\n.11857 .60332 L\n.11857 .60332 L\n.11905 .60332 L\nMistroke\n.11905 .60332 L\n.11952 .60332 L\n.11952 .60332 L\n.12 .60332 L\n.12 .60332 L\n.12048 .60332 L\n.12048 .60332 L\n.12095 .60332 L\n.12095 .60332 L\n.12143 .60332 L\n.12143 .60332 L\n.1219 .60332 L\n.1219 .60332 L\n.12238 .60332 L\n.12238 .60332 L\n.12286 .60332 L\n.12286 .60332 L\n.12333 .60332 L\n.12333 .60332 L\n.12381 .60332 L\n.12381 .60332 L\n.12429 .60332 L\n.12429 .60332 L\n.12476 .60332 L\n.12476 .60332 L\n.12524 .60332 L\n.12524 .60332 L\n.12571 .60332 L\n.12571 .60332 L\n.12619 .60332 L\n.12619 .60332 L\n.12667 .60332 L\n.12667 .60332 L\n.12714 .60332 L\n.12714 .60332 L\n.12762 .60332 L\n.12762 .60332 L\n.1281 .60332 L\n.1281 .60332 L\n.12857 .60332 L\n.12857 .60332 L\n.12905 .60332 L\n.12905 .60332 L\n.12952 .60332 L\n.12952 .60332 L\n.13 .60332 L\n.13 .60332 L\n.13048 .60332 L\n.13048 .60332 L\n.13095 .60332 L\nMistroke\n.13095 .60332 L\n.13143 .60332 L\n.13143 .60332 L\n.1319 .60332 L\n.1319 .60332 L\n.13238 .60332 L\n.13238 .60332 L\n.13286 .60332 L\n.13286 .60332 L\n.13333 .60332 L\n.13333 .60332 L\n.13381 .60332 L\n.13381 .60332 L\n.13429 .60332 L\n.13429 .60332 L\n.13476 .60332 L\n.13476 .60332 L\n.13524 .60332 L\n.13524 .60332 L\n.13571 .60332 L\n.13571 .60332 L\n.13619 .60332 L\n.13619 .60332 L\n.13667 .60332 L\n.13667 .60332 L\n.13714 .60332 L\n.13714 .60332 L\n.13762 .60332 L\n.13762 .60332 L\n.1381 .60332 L\n.1381 .60332 L\n.13857 .60332 L\n.13857 .60332 L\n.13905 .60332 L\n.13905 .60332 L\n.13952 .60332 L\n.13952 .60332 L\n.14 .60332 L\n.14 .60332 L\n.14048 .60332 L\n.14048 .60332 L\n.14095 .60332 L\n.14095 .60332 L\n.14143 .60332 L\n.14143 .60332 L\n.1419 .60332 L\n.1419 .60332 L\n.14238 .60332 L\n.14238 .60332 L\n.14286 .60332 L\nMistroke\n.14286 .60332 L\n.14333 .60332 L\n.14333 .60332 L\n.14381 .60332 L\n.14381 .60332 L\n.14429 .60332 L\n.14429 .60332 L\n.14476 .60332 L\n.14476 .60332 L\n.14524 .60332 L\n.14524 .60332 L\n.14571 .60332 L\n.14571 .60332 L\n.14619 .60332 L\n.14619 .60332 L\n.14667 .60332 L\n.14667 .60332 L\n.14714 .60332 L\n.14714 .60332 L\n.14762 .60332 L\n.14762 .60332 L\n.1481 .60332 L\n.1481 .60332 L\n.14857 .60332 L\n.14857 .60332 L\n.14905 .60332 L\n.14905 .60332 L\n.14952 .60332 L\n.14952 .60332 L\n.15 .60332 L\n.15 .60332 L\n.15048 .60332 L\n.15048 .60332 L\n.15095 .60332 L\n.15095 .60332 L\n.15143 .60332 L\n.15143 .60332 L\n.1519 .60332 L\n.1519 .60332 L\n.15238 .60332 L\n.15238 .60332 L\n.15286 .60332 L\n.15286 .60332 L\n.15333 .60332 L\n.15333 .60332 L\n.15381 .60332 L\n.15381 .60332 L\n.15429 .60332 L\n.15429 .60332 L\n.15476 .60332 L\nMistroke\n.15476 .60332 L\n.15524 .60332 L\n.15524 .60332 L\n.15571 .60332 L\n.15571 .60332 L\n.15619 .60332 L\n.15619 .60332 L\n.15667 .60332 L\n.15667 .60332 L\n.15714 .60332 L\n.15714 .60332 L\n.15762 .60332 L\n.15762 .60332 L\n.1581 .60332 L\n.1581 .60332 L\n.15857 .60332 L\n.15857 .60332 L\n.15905 .60332 L\n.15905 .60332 L\n.15952 .60332 L\n.15952 .60332 L\n.16 .60332 L\n.16 .60332 L\n.16048 .60332 L\n.16048 .60332 L\n.16095 .60332 L\n.16095 .60332 L\n.16143 .60332 L\n.16143 .60332 L\n.1619 .60332 L\n.1619 .60332 L\n.16238 .60332 L\n.16238 .60332 L\n.16286 .60332 L\n.16286 .60332 L\n.16333 .60332 L\n.16333 .60332 L\n.16381 .60332 L\n.16381 .60332 L\n.16429 .60332 L\n.16429 .60332 L\n.16476 .60332 L\n.16476 .60332 L\n.16524 .60332 L\n.16524 .60332 L\n.16571 .60332 L\n.16571 .60332 L\n.16619 .60332 L\n.16619 .60332 L\n.16667 .60332 L\nMistroke\n.16667 .60332 L\n.16714 .60332 L\n.16714 .60332 L\n.16762 .60332 L\n.16762 .60332 L\n.1681 .60332 L\n.1681 .60332 L\n.16857 .60332 L\n.16857 .60332 L\n.16905 .60332 L\n.16905 .60332 L\n.16952 .60332 L\n.16952 .60332 L\n.17 .60332 L\n.17 .60332 L\n.17048 .60332 L\n.17048 .60332 L\n.17095 .60332 L\n.17095 .60332 L\n.17143 .60332 L\n.17143 .60332 L\n.1719 .60332 L\n.1719 .60332 L\n.17238 .60332 L\n.17238 .60332 L\n.17286 .60332 L\n.17286 .60332 L\n.17333 .60332 L\n.17333 .60332 L\n.17381 .60332 L\n.17381 .60332 L\n.17429 .60332 L\n.17429 .60332 L\n.17476 .60332 L\n.17476 .60332 L\n.17524 .60332 L\n.17524 .60332 L\n.17571 .60332 L\n.17571 .60332 L\n.17619 .60332 L\n.17619 .60332 L\n.17667 .60332 L\n.17667 .60332 L\n.17714 .60332 L\n.17714 .60332 L\n.17762 .60332 L\n.17762 .60332 L\n.1781 .60332 L\n.1781 .60332 L\n.17857 .60332 L\nMistroke\n.17857 .60332 L\n.17905 .60332 L\n.17905 .60332 L\n.17952 .60332 L\n.17952 .60332 L\n.18 .60332 L\n.18 .60332 L\n.18048 .60332 L\n.18048 .60332 L\n.18095 .60332 L\n.18095 .60332 L\n.18143 .60332 L\n.18143 .60332 L\n.1819 .60332 L\n.1819 .60332 L\n.18238 .60332 L\n.18238 .60332 L\n.18286 .60332 L\n.18286 .60332 L\n.18333 .60332 L\n.18333 .60332 L\n.18381 .60332 L\n.18381 .60332 L\n.18429 .60332 L\n.18429 .60332 L\n.18476 .60332 L\n.18476 .60332 L\n.18524 .60332 L\n.18524 .60332 L\n.18571 .60332 L\n.18571 .60332 L\n.18619 .60332 L\n.18619 .60332 L\n.18667 .60332 L\n.18667 .60332 L\n.18714 .60332 L\n.18714 .60332 L\n.18762 .60332 L\n.18762 .60332 L\n.1881 .60332 L\n.1881 .60332 L\n.18857 .60332 L\n.18857 .60332 L\n.18905 .60332 L\n.18905 .60332 L\n.18952 .60332 L\n.18952 .60332 L\n.19 .60332 L\n.19 .60332 L\n.19048 .60332 L\nMistroke\n.19048 .60332 L\n.19095 .60332 L\n.19095 .60332 L\n.19143 .60332 L\n.19143 .60332 L\n.1919 .60332 L\n.1919 .60332 L\n.19238 .60332 L\n.19238 .60332 L\n.19286 .60332 L\n.19286 .60332 L\n.19333 .60332 L\n.19333 .60332 L\n.19381 .60332 L\n.19381 .60332 L\n.19429 .60332 L\n.19429 .60332 L\n.19476 .60332 L\n.19476 .60332 L\n.19524 .60332 L\n.19524 .60332 L\n.19571 .60332 L\n.19571 .60332 L\n.19619 .60332 L\n.19619 .60332 L\n.19667 .60332 L\n.19667 .60332 L\n.19714 .60332 L\n.19714 .60332 L\n.19762 .60332 L\n.19762 .60332 L\n.1981 .60332 L\n.1981 .60332 L\n.19857 .60332 L\n.19857 .60332 L\n.19905 .60332 L\n.19905 .60332 L\n.19952 .60332 L\n.19952 .60332 L\n.2 .60332 L\n.2 .60332 L\n.20048 .60332 L\n.20048 .60332 L\n.20095 .60332 L\n.20095 .60332 L\n.20143 .60332 L\n.20143 .60332 L\n.2019 .60332 L\n.2019 .60332 L\n.20238 .60332 L\nMistroke\n.20238 .60332 L\n.20286 .60332 L\n.20286 .60332 L\n.20333 .60332 L\n.20333 .60332 L\n.20381 .60332 L\n.20381 .60332 L\n.20429 .60332 L\n.20429 .60332 L\n.20476 .60332 L\n.20476 .60332 L\n.20524 .60332 L\n.20524 .60332 L\n.20571 .60332 L\n.20571 .60332 L\n.20619 .60332 L\n.20619 .60332 L\n.20667 .60332 L\n.20667 .60332 L\n.20714 .60332 L\n.20714 .60332 L\n.20762 .60332 L\n.20762 .60332 L\n.2081 .60332 L\n.2081 .60332 L\n.20857 .60332 L\n.20857 .60332 L\n.20905 .60332 L\n.20905 .60332 L\n.20952 .60332 L\n.20952 .60332 L\n.21 .60332 L\n.21 .60332 L\n.21048 .60332 L\n.21048 .60332 L\n.21095 .60332 L\n.21095 .60332 L\n.21143 .60332 L\n.21143 .60332 L\n.2119 .60332 L\n.2119 .60332 L\n.21238 .60332 L\n.21238 .60332 L\n.21286 .60332 L\n.21286 .60332 L\n.21333 .60332 L\n.21333 .60332 L\n.21381 .60332 L\n.21381 .60332 L\n.21429 .60332 L\nMistroke\n.21429 .60332 L\n.21476 .60332 L\n.21476 .60332 L\n.21524 .60332 L\n.21524 .60332 L\n.21571 .60332 L\n.21571 .60332 L\n.21619 .60332 L\n.21619 .60332 L\n.21667 .60332 L\n.21667 .60332 L\n.21714 .60332 L\n.21714 .60332 L\n.21762 .60332 L\n.21762 .60332 L\n.2181 .60332 L\n.2181 .60332 L\n.21857 .60332 L\n.21857 .60332 L\n.21905 .60332 L\n.21905 .60332 L\n.21952 .60332 L\n.21952 .60332 L\n.22 .60332 L\n.22 .60332 L\n.22048 .60332 L\n.22048 .60332 L\n.22095 .60332 L\n.22095 .60332 L\n.22143 .60332 L\n.22143 .60332 L\n.2219 .60332 L\n.2219 .60332 L\n.22238 .60332 L\n.22238 .60332 L\n.22286 .60332 L\n.22286 .60332 L\n.22333 .60332 L\n.22333 .60332 L\n.22381 .60332 L\n.22381 .60332 L\n.22429 .60332 L\n.22429 .60332 L\n.22476 .60332 L\n.22476 .60332 L\n.22524 .60332 L\n.22524 .60332 L\n.22571 .60332 L\n.22571 .60332 L\n.22619 .60332 L\nMistroke\n.22619 .60332 L\n.22667 .60332 L\n.22667 .60332 L\n.22714 .60332 L\n.22714 .60332 L\n.22762 .60332 L\n.22762 .60332 L\n.2281 .60332 L\n.2281 .60332 L\n.22857 .60332 L\n.22857 .60332 L\n.22905 .60332 L\n.22905 .60332 L\n.22952 .60332 L\n.22952 .60332 L\n.23 .60332 L\n.23 .60332 L\n.23048 .60332 L\n.23048 .60332 L\n.23095 .60332 L\n.23095 .60332 L\n.23143 .60332 L\n.23143 .60332 L\n.2319 .60332 L\n.2319 .60332 L\n.23238 .60332 L\n.23238 .60332 L\n.23286 .60332 L\n.23286 .60332 L\n.23333 .60332 L\n.23333 .60332 L\n.23381 .60332 L\n.23381 .60332 L\n.23429 .60332 L\n.23429 .60332 L\n.23476 .60332 L\n.23476 .60332 L\n.23524 .60332 L\n.23524 .60332 L\n.23571 .60332 L\n.23571 .60332 L\n.23619 .60332 L\n.23619 .60332 L\n.23667 .60332 L\n.23667 .60332 L\n.23714 .60332 L\n.23714 .60332 L\n.23762 .60332 L\n.23762 .60332 L\n.2381 .60332 L\nMistroke\n.2381 .60332 L\n.23857 .60332 L\n.23857 .60332 L\n.23905 .60332 L\n.23905 .60332 L\n.23952 .60332 L\n.23952 .60332 L\n.24 .60332 L\n.24 .60332 L\n.24048 .60332 L\n.24048 .60332 L\n.24095 .60332 L\n.24095 .60332 L\n.24143 .60332 L\n.24143 .60332 L\n.2419 .60332 L\n.2419 .60332 L\n.24238 .60332 L\n.24238 .60332 L\n.24286 .60332 L\n.24286 .60332 L\n.24333 .60332 L\n.24333 .60332 L\n.24381 .60332 L\n.24381 .60332 L\n.24429 .60332 L\n.24429 .60332 L\n.24476 .60332 L\n.24476 .60332 L\n.24524 .60332 L\n.24524 .60332 L\n.24571 .60332 L\n.24571 .60332 L\n.24619 .60332 L\n.24619 .60332 L\n.24667 .60332 L\n.24667 .60332 L\n.24714 .60332 L\n.24714 .60332 L\n.24762 .60332 L\n.24762 .60332 L\n.2481 .60332 L\n.2481 .60332 L\n.24857 .60332 L\n.24857 .60332 L\n.24905 .60332 L\n.24905 .60332 L\n.24952 .60332 L\n.24952 .60332 L\n.25 .60332 L\nMistroke\n.25 .60332 L\n.25048 .60332 L\n.25048 .60332 L\n.25095 .60332 L\n.25095 .60332 L\n.25143 .60332 L\n.25143 .60332 L\n.2519 .60332 L\n.2519 .60332 L\n.25238 .60332 L\n.25238 .60332 L\n.25286 .60332 L\n.25286 .60332 L\n.25333 .60332 L\n.25333 .60332 L\n.25381 .60332 L\n.25381 .60332 L\n.25429 .60332 L\n.25429 .60332 L\n.25476 .60332 L\n.25476 .60332 L\n.25524 .60332 L\n.25524 .60332 L\n.25571 .60332 L\n.25571 .60332 L\n.25619 .60332 L\n.25619 .60332 L\n.25667 .60332 L\n.25667 .60332 L\n.25714 .60332 L\n.25714 .60332 L\n.25762 .60332 L\n.25762 .60332 L\n.2581 .60332 L\n.2581 .60332 L\n.25857 .60332 L\n.25857 .60332 L\n.25905 .60332 L\n.25905 .60332 L\n.25952 .60332 L\n.25952 .60332 L\n.26 .60332 L\n.26 .60332 L\n.26048 .60332 L\n.26048 .60332 L\n.26095 .60332 L\n.26095 .60332 L\n.26143 .60332 L\n.26143 .60332 L\n.2619 .60332 L\nMistroke\n.2619 .60332 L\n.26238 .60332 L\n.26238 .60332 L\n.26286 .60332 L\n.26286 .60332 L\n.26333 .60332 L\n.26333 .60332 L\n.26381 .60332 L\n.26381 .60332 L\n.26429 .60332 L\n.26429 .60332 L\n.26476 .60332 L\n.26476 .60332 L\n.26524 .60332 L\n.26524 .60332 L\n.26571 .60332 L\n.26571 .60332 L\n.26619 .60332 L\n.26619 .60332 L\n.26667 .60332 L\n.26667 .60332 L\n.26714 .60332 L\n.26714 .60332 L\n.26762 .60332 L\n.26762 .60332 L\n.2681 .60332 L\n.2681 .60332 L\n.26857 .60332 L\n.26857 .60332 L\n.26905 .60332 L\n.26905 .60332 L\n.26952 .60332 L\n.26952 .60332 L\n.27 .60332 L\n.27 .60332 L\n.27048 .60332 L\n.27048 .60332 L\n.27095 .60332 L\n.27095 .60332 L\n.27143 .60332 L\n.27143 .60332 L\n.2719 .60332 L\n.2719 .60332 L\n.27238 .60332 L\n.27238 .60332 L\n.27286 .60332 L\n.27286 .60332 L\n.27333 .60332 L\n.27333 .60332 L\n.27381 .60332 L\nMistroke\n.27381 .60332 L\n.27429 .60332 L\n.27429 .60332 L\n.27476 .60332 L\n.27476 .60332 L\n.27524 .60332 L\n.27524 .60332 L\n.27571 .60332 L\n.27571 .60332 L\n.27619 .60332 L\n.27619 .60332 L\n.27667 .60332 L\n.27667 .60332 L\n.27714 .60332 L\n.27714 .60332 L\n.27762 .60332 L\n.27762 .60332 L\n.2781 .60332 L\n.2781 .60332 L\n.27857 .60332 L\n.27857 .60332 L\n.27905 .60332 L\n.27905 .60332 L\n.27952 .60332 L\n.27952 .60332 L\n.28 .60332 L\n.28 .60332 L\n.28048 .60332 L\n.28048 .60332 L\n.28095 .60332 L\n.28095 .60332 L\n.28143 .60332 L\n.28143 .60332 L\n.2819 .60332 L\n.2819 .60332 L\n.28238 .60332 L\n.28238 .60332 L\n.28286 .60332 L\n.28286 .60332 L\n.28333 .60332 L\n.28333 .60332 L\n.28381 .60332 L\n.28381 .60332 L\n.28429 .60332 L\n.28429 .60332 L\n.28476 .60332 L\n.28476 .60332 L\n.28524 .60332 L\n.28524 .60332 L\n.28571 .60332 L\nMistroke\n.28571 .60332 L\n.28619 .60332 L\n.28619 .60332 L\n.28667 .60332 L\n.28667 .60332 L\n.28714 .60332 L\n.28714 .60332 L\n.28762 .60332 L\n.28762 .60332 L\n.2881 .60332 L\n.2881 .60332 L\n.28857 .60332 L\n.28857 .60332 L\n.28905 .60332 L\n.28905 .60332 L\n.28952 .60332 L\n.28952 .60332 L\n.29 .60332 L\n.29 .60332 L\n.29048 .60332 L\n.29048 .60332 L\n.29095 .60332 L\n.29095 .60332 L\n.29143 .60332 L\n.29143 .60332 L\n.2919 .60332 L\n.2919 .60332 L\n.29238 .60332 L\n.29238 .60332 L\n.29286 .60332 L\n.29286 .60332 L\n.29333 .60332 L\n.29333 .60332 L\n.29381 .60332 L\n.29381 .60332 L\n.29429 .60332 L\n.29429 .60332 L\n.29476 .60332 L\n.29476 .60332 L\n.29524 .60332 L\n.29524 .60332 L\n.29571 .60332 L\n.29571 .60332 L\n.29619 .60332 L\n.29619 .60332 L\n.29667 .60332 L\n.29667 .60332 L\n.29714 .60332 L\n.29714 .60332 L\n.29762 .60332 L\nMistroke\n.29762 .60332 L\n.2981 .60332 L\n.2981 .60332 L\n.29857 .60332 L\n.29857 .60332 L\n.29905 .60332 L\n.29905 .60332 L\n.29952 .60332 L\n.29952 .60332 L\n.3 .60332 L\n.3 .60332 L\n.30048 .60332 L\n.30048 .60332 L\n.30095 .60332 L\n.30095 .60332 L\n.30143 .60332 L\n.30143 .60332 L\n.3019 .60332 L\n.3019 .60332 L\n.30238 .60332 L\n.30238 .60332 L\n.30286 .60332 L\n.30286 .60332 L\n.30333 .60332 L\n.30333 .60332 L\n.30381 .60332 L\n.30381 .60332 L\n.30429 .60332 L\n.30429 .60332 L\n.30476 .60332 L\n.30476 .60332 L\n.30524 .60332 L\n.30524 .60332 L\n.30571 .60332 L\n.30571 .60332 L\n.30619 .60332 L\n.30619 .60332 L\n.30667 .60332 L\n.30667 .60332 L\n.30714 .60332 L\n.30714 .60332 L\n.30762 .60332 L\n.30762 .60332 L\n.3081 .60332 L\n.3081 .60332 L\n.30857 .60332 L\n.30857 .60332 L\n.30905 .60332 L\n.30905 .60332 L\n.30952 .60332 L\nMistroke\n.30952 .60332 L\n.31 .60332 L\n.31 .60332 L\n.31048 .60332 L\n.31048 .60332 L\n.31095 .60332 L\n.31095 .60332 L\n.31143 .60332 L\n.31143 .60332 L\n.3119 .60332 L\n.3119 .60332 L\n.31238 .60332 L\n.31238 .60332 L\n.31286 .60332 L\n.31286 .60332 L\n.31333 .60332 L\n.31333 .60332 L\n.31381 .60332 L\n.31381 .60332 L\n.31429 .60332 L\n.31429 .60332 L\n.31476 .60332 L\n.31476 .60332 L\n.31524 .60332 L\n.31524 .60332 L\n.31571 .60332 L\n.31571 .60332 L\n.31619 .60332 L\n.31619 .60332 L\n.31667 .60332 L\n.31667 .60332 L\n.31714 .60332 L\n.31714 .60332 L\n.31762 .60332 L\n.31762 .60332 L\n.3181 .60332 L\n.3181 .60332 L\n.31857 .60332 L\n.31857 .60332 L\n.31905 .60332 L\n.31905 .60332 L\n.31952 .60332 L\n.31952 .60332 L\n.32 .60332 L\n.32 .60332 L\n.32048 .60332 L\n.32048 .60332 L\n.32095 .60332 L\n.32095 .60332 L\n.32143 .60332 L\nMistroke\n.32143 .60332 L\n.3219 .60332 L\n.3219 .60332 L\n.32238 .60332 L\n.32238 .60332 L\n.32286 .60332 L\n.32286 .60332 L\n.32333 .60332 L\n.32333 .60332 L\n.32381 .60332 L\n.32381 .60332 L\n.32429 .60332 L\n.32429 .60332 L\n.32476 .60332 L\n.32476 .60332 L\n.32524 .60332 L\n.32524 .60332 L\n.32571 .60332 L\n.32571 .60332 L\n.32619 .60332 L\n.32619 .60332 L\n.32667 .60332 L\n.32667 .60332 L\n.32714 .60332 L\n.32714 .60332 L\n.32762 .60332 L\n.32762 .60332 L\n.3281 .60332 L\n.3281 .60332 L\n.32857 .60332 L\n.32857 .60332 L\n.32905 .60332 L\n.32905 .60332 L\n.32952 .60332 L\n.32952 .60332 L\n.33 .60332 L\n.33 .60332 L\n.33048 .60332 L\n.33048 .60332 L\n.33095 .60332 L\n.33095 .60332 L\n.33143 .60332 L\n.33143 .60332 L\n.3319 .60332 L\n.3319 .60332 L\n.33238 .60332 L\n.33238 .60332 L\n.33286 .60332 L\n.33286 .60332 L\n.33333 .60332 L\nMistroke\n.33333 .60332 L\n.33381 .60332 L\n.33381 .60332 L\n.33429 .60332 L\n.33429 .60332 L\n.33476 .60332 L\n.33476 .60332 L\n.33524 .60332 L\n.33524 .60332 L\n.33571 .60332 L\n.33571 .60332 L\n.33619 .60332 L\n.33619 .60332 L\n.33667 .60332 L\n.33667 .60332 L\n.33714 .60332 L\n.33714 .60332 L\n.33762 .60332 L\n.33762 .60332 L\n.3381 .60332 L\n.3381 .60332 L\n.33857 .60332 L\n.33857 .60332 L\n.33905 .60332 L\n.33905 .60332 L\n.33952 .60332 L\n.33952 .60332 L\n.34 .60332 L\n.34 .60332 L\n.34048 .60332 L\n.34048 .60332 L\n.34095 .60332 L\n.34095 .60332 L\n.34143 .60332 L\n.34143 .60332 L\n.3419 .60332 L\n.3419 .60332 L\n.34238 .60332 L\n.34238 .60332 L\n.34286 .60332 L\n.34286 .60332 L\n.34333 .60332 L\n.34333 .60332 L\n.34381 .60332 L\n.34381 .60332 L\n.34429 .60332 L\n.34429 .60332 L\n.34476 .60332 L\n.34476 .60332 L\n.34524 .60332 L\nMistroke\n.34524 .60332 L\n.34571 .60332 L\n.34571 .60332 L\n.34619 .60332 L\n.34619 .60332 L\n.34667 .60332 L\n.34667 .60332 L\n.34714 .60332 L\n.34714 .60332 L\n.34762 .60332 L\n.34762 .60332 L\n.3481 .60332 L\n.3481 .60332 L\n.34857 .60332 L\n.34857 .60332 L\n.34905 .60332 L\n.34905 .60332 L\n.34952 .60332 L\n.34952 .60332 L\n.35 .60332 L\n.35 .60332 L\n.35048 .60332 L\n.35048 .60332 L\n.35095 .60332 L\n.35095 .60332 L\n.35143 .60332 L\n.35143 .60332 L\n.3519 .60332 L\n.3519 .60332 L\n.35238 .60332 L\n.35238 .60332 L\n.35286 .60332 L\n.35286 .60332 L\n.35333 .60332 L\n.35333 .60332 L\n.35381 .60332 L\n.35381 .60332 L\n.35429 .60332 L\n.35429 .60332 L\n.35476 .60332 L\n.35476 .60332 L\n.35524 .60332 L\n.35524 .60332 L\n.35571 .60332 L\n.35571 .60332 L\n.35619 .60332 L\n.35619 .60332 L\n.35667 .60332 L\n.35667 .60332 L\n.35714 .60332 L\nMistroke\n.35714 .60332 L\n.35762 .60332 L\n.35762 .60332 L\n.3581 .60332 L\n.3581 .60332 L\n.35857 .60332 L\n.35857 .60332 L\n.35905 .60332 L\n.35905 .60332 L\n.35952 .60332 L\n.35952 .60332 L\n.36 .60332 L\n.36 .60332 L\n.36048 .60332 L\n.36048 .60332 L\n.36095 .60332 L\n.36095 .60332 L\n.36143 .60332 L\n.36143 .60332 L\n.3619 .60332 L\n.3619 .60332 L\n.36238 .60332 L\n.36238 .60332 L\n.36286 .60332 L\n.36286 .60332 L\n.36333 .60332 L\n.36333 .60332 L\n.36381 .60332 L\n.36381 .60332 L\n.36429 .60332 L\n.36429 .60332 L\n.36476 .60332 L\n.36476 .60332 L\n.36524 .60332 L\n.36524 .60332 L\n.36571 .60332 L\n.36571 .60332 L\n.36619 .60332 L\n.36619 .60332 L\n.36667 .60332 L\n.36667 .60332 L\n.36714 .60332 L\n.36714 .60332 L\n.36762 .60332 L\n.36762 .60332 L\n.3681 .60332 L\n.3681 .60332 L\n.36857 .60332 L\n.36857 .60332 L\n.36905 .60332 L\nMistroke\n.36905 .60332 L\n.36952 .60332 L\n.36952 .60332 L\n.37 .60332 L\n.37 .60332 L\n.37048 .60332 L\n.37048 .60332 L\n.37095 .60332 L\n.37095 .60332 L\n.37143 .60332 L\n.37143 .60332 L\n.3719 .60332 L\n.3719 .60332 L\n.37238 .60332 L\n.37238 .60332 L\n.37286 .60332 L\n.37286 .60332 L\n.37333 .60332 L\n.37333 .60332 L\n.37381 .60332 L\n.37381 .60332 L\n.37429 .60332 L\n.37429 .60332 L\n.37476 .60332 L\n.37476 .60332 L\n.37524 .60332 L\n.37524 .60332 L\n.37571 .60332 L\n.37571 .60332 L\n.37619 .60332 L\n.37619 .60332 L\n.37667 .60332 L\n.37667 .60332 L\n.37714 .60332 L\n.37714 .60332 L\n.37762 .60332 L\n.37762 .60332 L\n.3781 .60332 L\n.3781 .60332 L\n.37857 .60332 L\n.37857 .60332 L\n.37905 .60332 L\n.37905 .60332 L\n.37952 .60332 L\n.37952 .60332 L\n.38 .60332 L\n.38 .60332 L\n.38048 .60332 L\n.38048 .60332 L\n.38095 .60332 L\nMistroke\n.38095 .60332 L\n.38143 .60332 L\n.38143 .60332 L\n.3819 .60332 L\n.3819 .60332 L\n.38238 .60332 L\n.38238 .60332 L\n.38286 .60332 L\n.38286 .60332 L\n.38333 .60332 L\n.38333 .60332 L\n.38381 .60332 L\n.38381 .60332 L\n.38429 .60332 L\n.38429 .60332 L\n.38476 .60332 L\n.38476 .60332 L\n.38524 .60332 L\n.38524 .60332 L\n.38571 .60332 L\n.38571 .60332 L\n.38619 .60332 L\n.38619 .60332 L\n.38667 .60332 L\n.38667 .60332 L\n.38714 .60332 L\n.38714 .60332 L\n.38762 .60332 L\n.38762 .60332 L\n.3881 .60332 L\n.3881 .60332 L\n.38857 .60332 L\n.38857 .60332 L\n.38905 .60332 L\n.38905 .60332 L\n.38952 .60332 L\n.38952 .60332 L\n.39 .60332 L\n.39 .60332 L\n.39048 .60332 L\n.39048 .60332 L\n.39095 .60332 L\n.39095 .60332 L\n.39143 .60332 L\n.39143 .60332 L\n.3919 .60332 L\n.3919 .60332 L\n.39238 .60332 L\n.39238 .60332 L\n.39286 .60332 L\nMistroke\n.39286 .60332 L\n.39333 .60332 L\n.39333 .60332 L\n.39381 .60332 L\n.39381 .60332 L\n.39429 .60332 L\n.39429 .60332 L\n.39476 .60332 L\n.39476 .60332 L\n.39524 .60332 L\n.39524 .60332 L\n.39571 .60332 L\n.39571 .60332 L\n.39619 .60332 L\n.39619 .60332 L\n.39667 .60332 L\n.39667 .60332 L\n.39714 .60332 L\n.39714 .60332 L\n.39762 .60332 L\n.39762 .60332 L\n.3981 .60332 L\n.3981 .60332 L\n.39857 .60332 L\n.39857 .60332 L\n.39905 .60332 L\n.39905 .60332 L\n.39952 .60332 L\n.39952 .60332 L\n.4 .60332 L\n.4 .60332 L\n.40048 .60332 L\n.40048 .60332 L\n.40095 .60332 L\n.40095 .60332 L\n.40143 .60332 L\n.40143 .60332 L\n.4019 .60332 L\n.4019 .60332 L\n.40238 .60332 L\n.40238 .60332 L\n.40286 .60332 L\n.40286 .60332 L\n.40333 .60332 L\n.40333 .60332 L\n.40381 .60332 L\n.40381 .60332 L\n.40429 .60332 L\n.40429 .60332 L\n.40476 .60332 L\nMistroke\n.40476 .60332 L\n.40524 .60332 L\n.40524 .60332 L\n.40571 .60332 L\n.40571 .60332 L\n.40619 .60332 L\n.40619 .60332 L\n.40667 .60332 L\n.40667 .60332 L\n.40714 .60332 L\n.40714 .60332 L\n.40762 .60332 L\n.40762 .60332 L\n.4081 .60332 L\n.4081 .60332 L\n.40857 .60332 L\n.40857 .60332 L\n.40905 .60332 L\n.40905 .60332 L\n.40952 .60332 L\n.40952 .60332 L\n.41 .60332 L\n.41 .60332 L\n.41048 .60332 L\n.41048 .60332 L\n.41095 .60332 L\n.41095 .60332 L\n.41143 .60332 L\n.41143 .60332 L\n.4119 .60332 L\n.4119 .60332 L\n.41238 .60332 L\n.41238 .60332 L\n.41286 .60332 L\n.41286 .60332 L\n.41333 .60332 L\n.41333 .60332 L\n.41381 .60332 L\n.41381 .60332 L\n.41429 .60332 L\n.41429 .60332 L\n.41476 .60332 L\n.41476 .60332 L\n.41524 .60332 L\n.41524 .60332 L\n.41571 .60332 L\n.41571 .60332 L\n.41619 .60332 L\n.41619 .60332 L\n.41667 .60332 L\nMistroke\n.41667 .60332 L\n.41714 .60332 L\n.41714 .60332 L\n.41762 .60332 L\n.41762 .60332 L\n.4181 .60332 L\n.4181 .60332 L\n.41857 .60332 L\n.41857 .60332 L\n.41905 .60332 L\n.41905 .60332 L\n.41952 .60332 L\n.41952 .60332 L\n.42 .60332 L\n.42 .60332 L\n.42048 .60332 L\n.42048 .60332 L\n.42095 .60332 L\n.42095 .60332 L\n.42143 .60332 L\n.42143 .60332 L\n.4219 .60332 L\n.4219 .60332 L\n.42238 .60332 L\n.42238 .60332 L\n.42286 .60332 L\n.42286 .60332 L\n.42333 .60332 L\n.42333 .60332 L\n.42381 .60332 L\n.42381 .60332 L\n.42429 .60332 L\n.42429 .60332 L\n.42476 .60332 L\n.42476 .60332 L\n.42524 .60332 L\n.42524 .60332 L\n.42571 .60332 L\n.42571 .60332 L\n.42619 .60332 L\n.42619 .60332 L\n.42667 .60332 L\n.42667 .60332 L\n.42714 .60332 L\n.42714 .60332 L\n.42762 .60332 L\n.42762 .60332 L\n.4281 .60332 L\n.4281 .60332 L\n.42857 .60332 L\nMistroke\n.42857 .60332 L\n.42905 .60332 L\n.42905 .60332 L\n.42952 .60332 L\n.42952 .60332 L\n.43 .60332 L\n.43 .60332 L\n.43048 .60332 L\n.43048 .60332 L\n.43095 .60332 L\n.43095 .60332 L\n.43143 .60332 L\n.43143 .60332 L\n.4319 .60332 L\n.4319 .60332 L\n.43238 .60332 L\n.43238 .60332 L\n.43286 .60332 L\n.43286 .60332 L\n.43333 .60332 L\n.43333 .60332 L\n.43381 .60332 L\n.43381 .60332 L\n.43429 .60332 L\n.43429 .60332 L\n.43476 .60332 L\n.43476 .60332 L\n.43524 .60332 L\n.43524 .60332 L\n.43571 .60332 L\n.43571 .60332 L\n.43619 .60332 L\n.43619 .60332 L\n.43667 .60332 L\n.43667 .60332 L\n.43714 .60332 L\n.43714 .60332 L\n.43762 .60332 L\n.43762 .60332 L\n.4381 .60332 L\n.4381 .60332 L\n.43857 .60332 L\n.43857 .60332 L\n.43905 .60332 L\n.43905 .60332 L\n.43952 .60332 L\n.43952 .60332 L\n.44 .60332 L\n.44 .60332 L\n.44048 .60332 L\nMistroke\n.44048 .60332 L\n.44095 .60332 L\n.44095 .60332 L\n.44143 .60332 L\n.44143 .60332 L\n.4419 .60332 L\n.4419 .60332 L\n.44238 .60332 L\n.44238 .60332 L\n.44286 .60332 L\n.44286 .60332 L\n.44333 .60332 L\n.44333 .60332 L\n.44381 .60332 L\n.44381 .60332 L\n.44429 .60332 L\n.44429 .60332 L\n.44476 .60332 L\n.44476 .60332 L\n.44524 .60332 L\n.44524 .60332 L\n.44571 .60332 L\n.44571 .60332 L\n.44619 .60332 L\n.44619 .60332 L\n.44667 .60332 L\n.44667 .60332 L\n.44714 .60332 L\n.44714 .60332 L\n.44762 .60332 L\n.44762 .60332 L\n.4481 .60332 L\n.4481 .60332 L\n.44857 .60332 L\n.44857 .60332 L\n.44905 .60332 L\n.44905 .60332 L\n.44952 .60332 L\n.44952 .60332 L\n.45 .60332 L\n.45 .60332 L\n.45048 .60332 L\n.45048 .60332 L\n.45095 .60332 L\n.45095 .60332 L\n.45143 .60332 L\n.45143 .60332 L\n.4519 .60332 L\n.4519 .60332 L\n.45238 .60332 L\nMistroke\n.45238 .60332 L\n.45286 .60332 L\n.45286 .60332 L\n.45333 .60332 L\n.45333 .60332 L\n.45381 .60332 L\n.45381 .60332 L\n.45429 .60332 L\n.45429 .60332 L\n.45476 .60332 L\n.45476 .60332 L\n.45524 .60332 L\n.45524 .60332 L\n.45571 .60332 L\n.45571 .60332 L\n.45619 .60332 L\n.45619 .60332 L\n.45667 .60332 L\n.45667 .60332 L\n.45714 .60332 L\n.45714 .60332 L\n.45762 .60332 L\n.45762 .60332 L\n.4581 .60332 L\n.4581 .60332 L\n.45857 .60332 L\n.45857 .60332 L\n.45905 .60332 L\n.45905 .60332 L\n.45952 .60332 L\n.45952 .60332 L\n.46 .60332 L\n.46 .60332 L\n.46048 .60332 L\n.46048 .60332 L\n.46095 .60332 L\n.46095 .60332 L\n.46143 .60332 L\n.46143 .60332 L\n.4619 .60332 L\n.4619 .60332 L\n.46238 .60332 L\n.46238 .60332 L\n.46286 .60332 L\n.46286 .60332 L\n.46333 .60332 L\n.46333 .60332 L\n.46381 .60332 L\n.46381 .60332 L\n.46429 .60332 L\nMistroke\n.46429 .60332 L\n.46476 .60332 L\n.46476 .60332 L\n.46524 .60332 L\n.46524 .60332 L\n.46571 .60332 L\n.46571 .60332 L\n.46619 .60332 L\n.46619 .60332 L\n.46667 .60332 L\n.46667 .60332 L\n.46714 .60332 L\n.46714 .60332 L\n.46762 .60332 L\n.46762 .60332 L\n.4681 .60332 L\n.4681 .60332 L\n.46857 .60332 L\n.46857 .60332 L\n.46905 .60332 L\n.46905 .60332 L\n.46952 .60332 L\n.46952 .60332 L\n.47 .60332 L\n.47 .60332 L\n.47048 .60332 L\n.47048 .60332 L\n.47095 .60332 L\n.47095 .60332 L\n.47143 .60332 L\n.47143 .60332 L\n.4719 .60332 L\n.4719 .60332 L\n.47238 .60332 L\n.47238 .60332 L\n.47286 .60332 L\n.47286 .60332 L\n.47333 .60332 L\n.47333 .60332 L\n.47381 .60332 L\n.47381 .60332 L\n.47429 .60332 L\n.47429 .60332 L\n.47476 .60332 L\n.47476 .60332 L\n.47524 .60332 L\n.47524 .60332 L\n.47571 .60332 L\n.47571 .60332 L\n.47619 .60332 L\nMistroke\n.47619 .60332 L\n.47667 .60332 L\n.47667 .60332 L\n.47714 .60332 L\n.47714 .60332 L\n.47762 .60332 L\n.47762 .60332 L\n.4781 .60332 L\n.4781 .60332 L\n.47857 .60332 L\n.47857 .60332 L\n.47905 .60332 L\n.47905 .60332 L\n.47952 .60332 L\n.47952 .60332 L\n.48 .60332 L\n.48 .60332 L\n.48048 .60332 L\n.48048 .60332 L\n.48095 .60332 L\n.48095 .60332 L\n.48143 .60332 L\n.48143 .60332 L\n.4819 .60332 L\n.4819 .60332 L\n.48238 .60332 L\n.48238 .60332 L\n.48286 .60332 L\n.48286 .60332 L\n.48333 .60332 L\n.48333 .60332 L\n.48381 .60332 L\n.48381 .60332 L\n.48429 .60332 L\n.48429 .60332 L\n.48476 .60332 L\n.48476 .60332 L\n.48524 .60332 L\n.48524 .60332 L\n.48571 .60332 L\n.48571 .60332 L\n.48619 .60332 L\n.48619 .60332 L\n.48667 .60332 L\n.48667 .60332 L\n.48714 .60332 L\n.48714 .60332 L\n.48762 .60332 L\n.48762 .60332 L\n.4881 .60332 L\nMistroke\n.4881 .60332 L\n.48857 .60332 L\n.48857 .60332 L\n.48905 .60332 L\n.48905 .60332 L\n.48952 .60332 L\n.48952 .60332 L\n.49 .60332 L\n.49 .60332 L\n.49048 .60332 L\n.49048 .60332 L\n.49095 .60332 L\n.49095 .60332 L\n.49143 .60332 L\n.49143 .60332 L\n.4919 .60332 L\n.4919 .60332 L\n.49238 .60332 L\n.49238 .60332 L\n.49286 .60332 L\n.49286 .60332 L\n.49333 .60332 L\n.49333 .60332 L\n.49381 .60332 L\n.49381 .60332 L\n.49429 .60332 L\n.49429 .60332 L\n.49476 .60332 L\n.49476 .60332 L\n.49524 .60332 L\n.49524 .60332 L\n.49571 .60332 L\n.49571 .60332 L\n.49619 .60332 L\n.49619 .60332 L\n.49667 .60332 L\n.49667 .60332 L\n.49714 .60332 L\n.49714 .60332 L\n.49762 .60332 L\n.49762 .60332 L\n.4981 .60332 L\n.4981 .60332 L\n.49857 .60332 L\n.49857 .60332 L\n.49905 .60332 L\n.49905 .60332 L\n.49952 .60332 L\n.49952 .60332 L\n.5 .60332 L\nMistroke\n.5 .60332 L\n.5 .60332 L\n.5 .60332 L\n.50048 .60124 L\n.50048 .60124 L\n.50095 .59917 L\n.50095 .59917 L\n.50143 .5971 L\n.50143 .5971 L\n.5019 .59502 L\n.5019 .59502 L\n.50238 .59295 L\n.50238 .59295 L\n.50286 .59087 L\n.50286 .59087 L\n.50333 .5888 L\n.50333 .5888 L\n.50381 .58673 L\n.50381 .58673 L\n.50429 .58465 L\n.50429 .58465 L\n.50476 .58258 L\n.50476 .58258 L\n.50524 .5805 L\n.50524 .5805 L\n.50571 .57843 L\n.50571 .57843 L\n.50619 .57636 L\n.50619 .57636 L\n.50667 .57428 L\n.50667 .57428 L\n.50714 .57221 L\n.50714 .57221 L\n.50762 .57013 L\n.50762 .57013 L\n.5081 .56806 L\n.5081 .56806 L\n.50857 .56599 L\n.50857 .56599 L\n.50905 .56391 L\n.50905 .56391 L\n.50952 .56184 L\n.50952 .56184 L\n.51 .55976 L\n.51 .55976 L\n.51048 .55769 L\n.51048 .55769 L\n.51095 .55562 L\n.51095 .55562 L\n.51143 .55354 L\nMistroke\n.51143 .55354 L\n.5119 .55147 L\n.5119 .55147 L\n.51238 .54939 L\n.51238 .54939 L\n.51286 .54732 L\n.51286 .54732 L\n.51333 .54525 L\n.51333 .54525 L\n.51381 .54317 L\n.51381 .54317 L\n.51429 .5411 L\n.51429 .5411 L\n.51476 .53902 L\n.51476 .53902 L\n.51524 .53695 L\n.51524 .53695 L\n.51571 .53488 L\n.51571 .53488 L\n.51619 .5328 L\n.51619 .5328 L\n.51667 .53073 L\n.51667 .53073 L\n.51714 .52865 L\n.51714 .52865 L\n.51762 .52658 L\n.51762 .52658 L\n.5181 .52451 L\n.5181 .52451 L\n.51857 .52243 L\n.51857 .52243 L\n.51905 .52036 L\n.51905 .52036 L\n.51952 .51828 L\n.51952 .51828 L\n.52 .51621 L\n.52 .51621 L\n.52048 .51414 L\n.52048 .51414 L\n.52095 .51206 L\n.52095 .51206 L\n.52143 .50999 L\n.52143 .50999 L\n.5219 .50791 L\n.5219 .50791 L\n.52238 .50584 L\n.52238 .50584 L\n.52286 .50377 L\n.52286 .50377 L\n.52333 .50169 L\nMistroke\n.52333 .50169 L\n.52381 .49962 L\n.52381 .49962 L\n.52429 .49754 L\n.52429 .49754 L\n.52476 .49547 L\n.52476 .49547 L\n.52524 .4934 L\n.52524 .4934 L\n.52571 .49132 L\n.52571 .49132 L\n.52619 .48925 L\n.52619 .48925 L\n.52667 .48717 L\n.52667 .48717 L\n.52714 .4851 L\n.52714 .4851 L\n.52762 .48303 L\n.52762 .48303 L\n.5281 .48095 L\n.5281 .48095 L\n.52857 .47888 L\n.52857 .47888 L\n.52905 .4768 L\n.52905 .4768 L\n.52952 .47473 L\n.52952 .47473 L\n.53 .47266 L\n.53 .47266 L\n.53048 .47058 L\n.53048 .47058 L\n.53095 .46851 L\n.53095 .46851 L\n.53143 .46643 L\n.53143 .46643 L\n.5319 .46436 L\n.5319 .46436 L\n.53238 .46229 L\n.53238 .46229 L\n.53286 .46021 L\n.53286 .46021 L\n.53333 .45814 L\n.53333 .45814 L\n.53381 .45606 L\n.53381 .45606 L\n.53429 .45399 L\n.53429 .45399 L\n.53476 .45192 L\n.53476 .45192 L\n.53524 .44984 L\nMistroke\n.53524 .44984 L\n.53571 .44777 L\n.53571 .44777 L\n.53619 .44569 L\n.53619 .44569 L\n.53667 .44362 L\n.53667 .44362 L\n.53714 .44155 L\n.53714 .44155 L\n.53762 .43947 L\n.53762 .43947 L\n.5381 .4374 L\n.5381 .4374 L\n.53857 .43532 L\n.53857 .43532 L\n.53905 .43325 L\n.53905 .43325 L\n.53952 .43118 L\n.53952 .43118 L\n.54 .4291 L\n.54 .4291 L\n.54048 .42703 L\n.54048 .42703 L\n.54095 .42495 L\n.54095 .42495 L\n.54143 .42288 L\n.54143 .42288 L\n.5419 .42081 L\n.5419 .42081 L\n.54238 .41873 L\n.54238 .41873 L\n.54286 .41666 L\n.54286 .41666 L\n.54333 .41458 L\n.54333 .41458 L\n.54381 .41251 L\n.54381 .41251 L\n.54429 .41044 L\n.54429 .41044 L\n.54476 .40836 L\n.54476 .40836 L\n.54524 .40629 L\n.54524 .40629 L\n.54571 .40421 L\n.54571 .40421 L\n.54619 .40214 L\n.54619 .40214 L\n.54667 .40007 L\n.54667 .40007 L\n.54714 .39799 L\nMistroke\n.54714 .39799 L\n.54762 .39592 L\n.54762 .39592 L\n.5481 .39384 L\n.5481 .39384 L\n.54857 .39177 L\n.54857 .39177 L\n.54905 .3897 L\n.54905 .3897 L\n.54952 .38762 L\n.54952 .38762 L\n.55 .38555 L\n.55 .38555 L\n.55048 .38347 L\n.55048 .38347 L\n.55095 .3814 L\n.55095 .3814 L\n.55143 .37933 L\n.55143 .37933 L\n.5519 .37725 L\n.5519 .37725 L\n.55238 .37518 L\n.55238 .37518 L\n.55286 .3731 L\n.55286 .3731 L\n.55333 .37103 L\n.55333 .37103 L\n.55381 .36896 L\n.55381 .36896 L\n.55429 .36688 L\n.55429 .36688 L\n.55476 .36481 L\n.55476 .36481 L\n.55524 .36273 L\n.55524 .36273 L\n.55571 .36066 L\n.55571 .36066 L\n.55619 .35859 L\n.55619 .35859 L\n.55667 .35651 L\n.55667 .35651 L\n.55714 .35444 L\n.55714 .35444 L\n.55762 .35236 L\n.55762 .35236 L\n.5581 .35029 L\n.5581 .35029 L\n.55857 .34822 L\n.55857 .34822 L\n.55905 .34614 L\nMistroke\n.55905 .34614 L\n.55952 .34407 L\n.55952 .34407 L\n.56 .34199 L\n.56 .34199 L\n.56048 .33992 L\n.56048 .33992 L\n.56095 .33785 L\n.56095 .33785 L\n.56143 .33577 L\n.56143 .33577 L\n.5619 .3337 L\n.5619 .3337 L\n.56238 .33162 L\n.56238 .33162 L\n.56286 .32955 L\n.56286 .32955 L\n.56333 .32748 L\n.56333 .32748 L\n.56381 .3254 L\n.56381 .3254 L\n.56429 .32333 L\n.56429 .32333 L\n.56476 .32125 L\n.56476 .32125 L\n.56524 .31918 L\n.56524 .31918 L\n.56571 .31711 L\n.56571 .31711 L\n.56619 .31503 L\n.56619 .31503 L\n.56667 .31296 L\n.56667 .31296 L\n.56714 .31088 L\n.56714 .31088 L\n.56762 .30881 L\n.56762 .30881 L\n.5681 .30674 L\n.5681 .30674 L\n.56857 .30466 L\n.56857 .30466 L\n.56905 .30259 L\n.56905 .30259 L\n.56952 .30051 L\n.56952 .30051 L\n.57 .29844 L\n.57 .29844 L\n.57048 .29637 L\n.57048 .29637 L\n.57095 .29429 L\nMistroke\n.57095 .29429 L\n.57143 .29222 L\n.57143 .29222 L\n.5719 .29014 L\n.5719 .29014 L\n.57238 .28807 L\n.57238 .28807 L\n.57286 .286 L\n.57286 .286 L\n.57333 .28392 L\n.57333 .28392 L\n.57381 .28185 L\n.57381 .28185 L\n.57429 .27977 L\n.57429 .27977 L\n.57476 .2777 L\n.57476 .2777 L\n.57524 .27563 L\n.57524 .27563 L\n.57571 .27355 L\n.57571 .27355 L\n.57619 .27148 L\n.57619 .27148 L\n.57667 .2694 L\n.57667 .2694 L\n.57714 .26733 L\n.57714 .26733 L\n.57762 .26526 L\n.57762 .26526 L\n.5781 .26318 L\n.5781 .26318 L\n.57857 .26111 L\n.57857 .26111 L\n.57905 .25903 L\n.57905 .25903 L\n.57952 .25696 L\n.57952 .25696 L\n.58 .25489 L\n.58 .25489 L\n.58048 .25281 L\n.58048 .25281 L\n.58095 .25074 L\n.58095 .25074 L\n.58143 .24866 L\n.58143 .24866 L\n.5819 .24659 L\n.5819 .24659 L\n.58238 .24452 L\n.58238 .24452 L\n.58286 .24244 L\nMistroke\n.58286 .24244 L\n.58333 .24037 L\n.58333 .24037 L\n.58381 .23829 L\n.58381 .23829 L\n.58429 .23622 L\n.58429 .23622 L\n.58476 .23415 L\n.58476 .23415 L\n.58524 .23207 L\n.58524 .23207 L\n.58571 .23 L\n.58571 .23 L\n.58619 .22792 L\n.58619 .22792 L\n.58667 .22585 L\n.58667 .22585 L\n.58714 .22378 L\n.58714 .22378 L\n.58762 .2217 L\n.58762 .2217 L\n.5881 .21963 L\n.5881 .21963 L\n.58857 .21755 L\n.58857 .21755 L\n.58905 .21548 L\n.58905 .21548 L\n.58952 .21341 L\n.58952 .21341 L\n.59 .21133 L\n.59 .21133 L\n.59048 .20926 L\n.59048 .20926 L\n.59095 .20718 L\n.59095 .20718 L\n.59143 .20511 L\n.59143 .20511 L\n.5919 .20304 L\n.5919 .20304 L\n.59238 .20096 L\n.59238 .20096 L\n.59286 .19889 L\n.59286 .19889 L\n.59333 .19681 L\n.59333 .19681 L\n.59381 .19474 L\n.59381 .19474 L\n.59429 .19267 L\n.59429 .19267 L\n.59476 .19059 L\nMistroke\n.59476 .19059 L\n.59524 .18977 L\n.59524 .18977 L\n.59571 .19746 L\n.59571 .19746 L\n.59619 .19648 L\n.59619 .19648 L\n.59667 .20419 L\n.59667 .20419 L\n.59714 .20307 L\n.59714 .20307 L\n.59762 .2108 L\n.59762 .2108 L\n.5981 .20951 L\n.5981 .20951 L\n.59857 .21727 L\n.59857 .21727 L\n.59905 .21583 L\n.59905 .21583 L\n.59952 .22362 L\n.59952 .22362 L\n.6 .22202 L\n.6 .22202 L\n.60048 .22984 L\n.60048 .22984 L\n.60095 .22809 L\n.60095 .22809 L\n.60143 .23595 L\n.60143 .23595 L\n.6019 .23404 L\n.6019 .23404 L\n.60238 .24193 L\n.60238 .24193 L\n.60286 .23986 L\n.60286 .23986 L\n.60333 .2478 L\n.60333 .2478 L\n.60381 .24572 L\n.60381 .24572 L\n.60429 .2534 L\n.60429 .2534 L\n.60476 .25132 L\n.60476 .25132 L\n.60524 .25903 L\n.60524 .25903 L\n.60571 .25696 L\n.60571 .25696 L\n.60619 .2644 L\n.60619 .2644 L\n.60667 .26233 L\nMistroke\n.60667 .26233 L\n.60714 .26982 L\n.60714 .26982 L\n.60762 .26775 L\n.60762 .26775 L\n.6081 .27498 L\n.6081 .27498 L\n.60857 .27291 L\n.60857 .27291 L\n.60905 .28019 L\n.60905 .28019 L\n.60952 .27812 L\n.60952 .27812 L\n.61 .28515 L\n.61 .28515 L\n.61048 .28308 L\n.61048 .28308 L\n.61095 .29015 L\n.61095 .29015 L\n.61143 .28808 L\n.61143 .28808 L\n.6119 .29492 L\n.6119 .29492 L\n.61238 .29284 L\n.61238 .29284 L\n.61286 .29972 L\n.61286 .29972 L\n.61333 .29765 L\n.61333 .29765 L\n.61381 .3043 L\n.61381 .3043 L\n.61429 .30223 L\n.61429 .30223 L\n.61476 .30892 L\n.61476 .30892 L\n.61524 .30685 L\n.61524 .30685 L\n.61571 .31332 L\n.61571 .31332 L\n.61619 .31124 L\n.61619 .31124 L\n.61667 .31775 L\n.61667 .31775 L\n.61714 .31568 L\n.61714 .31568 L\n.61762 .32198 L\n.61762 .32198 L\n.6181 .31991 L\n.6181 .31991 L\n.61857 .32624 L\nMistroke\n.61857 .32624 L\n.61905 .32417 L\n.61905 .32417 L\n.61952 .3303 L\n.61952 .3303 L\n.62 .32823 L\n.62 .32823 L\n.62048 .3344 L\n.62048 .3344 L\n.62095 .33233 L\n.62095 .33233 L\n.62143 .3383 L\n.62143 .3383 L\n.6219 .33622 L\n.6219 .33622 L\n.62238 .34224 L\n.62238 .34224 L\n.62286 .34016 L\n.62286 .34016 L\n.62333 .34598 L\n.62333 .34598 L\n.62381 .34391 L\n.62381 .34391 L\n.62429 .34977 L\n.62429 .34977 L\n.62476 .34769 L\n.62476 .34769 L\n.62524 .35336 L\n.62524 .35336 L\n.62571 .35129 L\n.62571 .35129 L\n.62619 .357 L\n.62619 .357 L\n.62667 .35492 L\n.62667 .35492 L\n.62714 .36045 L\n.62714 .36045 L\n.62762 .35838 L\n.62762 .35838 L\n.6281 .36395 L\n.6281 .36395 L\n.62857 .36188 L\n.62857 .36188 L\n.62905 .36727 L\n.62905 .36727 L\n.62952 .36519 L\n.62952 .36519 L\n.63 .37063 L\n.63 .37063 L\n.63048 .36855 L\nMistroke\n.63048 .36855 L\n.63095 .37381 L\n.63095 .37381 L\n.63143 .37174 L\n.63143 .37174 L\n.6319 .37704 L\n.6319 .37704 L\n.63238 .37497 L\n.63238 .37497 L\n.63286 .3801 L\n.63286 .3801 L\n.63333 .37803 L\n.63333 .37803 L\n.63381 .38321 L\n.63381 .38321 L\n.63429 .38113 L\n.63429 .38113 L\n.63476 .38615 L\n.63476 .38615 L\n.63524 .38407 L\n.63524 .38407 L\n.63571 .38913 L\n.63571 .38913 L\n.63619 .38706 L\n.63619 .38706 L\n.63667 .39195 L\n.63667 .39195 L\n.63714 .38988 L\n.63714 .38988 L\n.63762 .39482 L\n.63762 .39482 L\n.6381 .39275 L\n.6381 .39275 L\n.63857 .39753 L\n.63857 .39753 L\n.63905 .39546 L\n.63905 .39546 L\n.63952 .40029 L\n.63952 .40029 L\n.64 .39821 L\n.64 .39821 L\n.64048 .40289 L\n.64048 .40289 L\n.64095 .40082 L\n.64095 .40082 L\n.64143 .40554 L\n.64143 .40554 L\n.6419 .40347 L\n.6419 .40347 L\n.64238 .40804 L\nMistroke\n.64238 .40804 L\n.64286 .40597 L\n.64286 .40597 L\n.64333 .41059 L\n.64333 .41059 L\n.64381 .40851 L\n.64381 .40851 L\n.64429 .41299 L\n.64429 .41299 L\n.64476 .41092 L\n.64476 .41092 L\n.64524 .41544 L\n.64524 .41544 L\n.64571 .41336 L\n.64571 .41336 L\n.64619 .41774 L\n.64619 .41774 L\n.64667 .41567 L\n.64667 .41567 L\n.64714 .4201 L\n.64714 .4201 L\n.64762 .41802 L\n.64762 .41802 L\n.6481 .42231 L\n.6481 .42231 L\n.64857 .42024 L\n.64857 .42024 L\n.64905 .42457 L\n.64905 .42457 L\n.64952 .4225 L\n.64952 .4225 L\n.65 .4267 L\n.65 .4267 L\n.65048 .42463 L\n.65048 .42463 L\n.65095 .42887 L\n.65095 .42887 L\n.65143 .4268 L\n.65143 .4268 L\n.6519 .43092 L\n.6519 .43092 L\n.65238 .42884 L\n.65238 .42884 L\n.65286 .43301 L\n.65286 .43301 L\n.65333 .43093 L\n.65333 .43093 L\n.65381 .43497 L\n.65381 .43497 L\n.65429 .4329 L\nMistroke\n.65429 .4329 L\n.65476 .43698 L\n.65476 .43698 L\n.65524 .4349 L\n.65524 .4349 L\n.65571 .43886 L\n.65571 .43886 L\n.65619 .43679 L\n.65619 .43679 L\n.65667 .44079 L\n.65667 .44079 L\n.65714 .43872 L\n.65714 .43872 L\n.65762 .4426 L\n.65762 .4426 L\n.6581 .44053 L\n.6581 .44053 L\n.65857 .44445 L\n.65857 .44445 L\n.65905 .44238 L\n.65905 .44238 L\n.65952 .44619 L\n.65952 .44619 L\n.66 .44412 L\n.66 .44412 L\n.66048 .44798 L\n.66048 .44798 L\n.66095 .4459 L\n.66095 .4459 L\n.66143 .44965 L\n.66143 .44965 L\n.6619 .44757 L\n.6619 .44757 L\n.66238 .45136 L\n.66238 .45136 L\n.66286 .44929 L\n.66286 .44929 L\n.66333 .45296 L\n.66333 .45296 L\n.66381 .45089 L\n.66381 .45089 L\n.66429 .45461 L\n.66429 .45461 L\n.66476 .45254 L\n.66476 .45254 L\n.66524 .45615 L\n.66524 .45615 L\n.66571 .45408 L\n.66571 .45408 L\n.66619 .45773 L\nMistroke\n.66619 .45773 L\n.66667 .45566 L\n.66667 .45566 L\n.66714 .45921 L\n.66714 .45921 L\n.66762 .45714 L\n.66762 .45714 L\n.6681 .46073 L\n.6681 .46073 L\n.66857 .45866 L\n.66857 .45866 L\n.66905 .46215 L\n.66905 .46215 L\n.66952 .46008 L\n.66952 .46008 L\n.67 .46362 L\n.67 .46362 L\n.67048 .46154 L\n.67048 .46154 L\n.67095 .46498 L\n.67095 .46498 L\n.67143 .46291 L\n.67143 .46291 L\n.6719 .46639 L\n.6719 .46639 L\n.67238 .46431 L\n.67238 .46431 L\n.67286 .4677 L\n.67286 .4677 L\n.67333 .46562 L\n.67333 .46562 L\n.67381 .46905 L\n.67381 .46905 L\n.67429 .46697 L\n.67429 .46697 L\n.67476 .47031 L\n.67476 .47031 L\n.67524 .46823 L\n.67524 .46823 L\n.67571 .4716 L\n.67571 .4716 L\n.67619 .46953 L\n.67619 .46953 L\n.67667 .47281 L\n.67667 .47281 L\n.67714 .47074 L\n.67714 .47074 L\n.67762 .47406 L\n.67762 .47406 L\n.6781 .47199 L\nMistroke\n.6781 .47199 L\n.67857 .47522 L\n.67857 .47522 L\n.67905 .47315 L\n.67905 .47315 L\n.67952 .47642 L\n.67952 .47642 L\n.68 .47435 L\n.68 .47435 L\n.68048 .47753 L\n.68048 .47753 L\n.68095 .47546 L\n.68095 .47546 L\n.68143 .47869 L\n.68143 .47869 L\n.6819 .47662 L\n.6819 .47662 L\n.68238 .47976 L\n.68238 .47976 L\n.68286 .47769 L\n.68286 .47769 L\n.68333 .48087 L\n.68333 .48087 L\n.68381 .4788 L\n.68381 .4788 L\n.68429 .48189 L\n.68429 .48189 L\n.68476 .47982 L\n.68476 .47982 L\n.68524 .48296 L\n.68524 .48296 L\n.68571 .48089 L\n.68571 .48089 L\n.68619 .48395 L\n.68619 .48395 L\n.68667 .48187 L\n.68667 .48187 L\n.68714 .48497 L\n.68714 .48497 L\n.68762 .4829 L\n.68762 .4829 L\n.6881 .48592 L\n.6881 .48592 L\n.68857 .48385 L\n.68857 .48385 L\n.68905 .48691 L\n.68905 .48691 L\n.68952 .48483 L\n.68952 .48483 L\n.69 .48781 L\nMistroke\n.69 .48781 L\n.69048 .48574 L\n.69048 .48574 L\n.69095 .48876 L\n.69095 .48876 L\n.69143 .48669 L\n.69143 .48669 L\n.6919 .48963 L\n.6919 .48963 L\n.69238 .48756 L\n.69238 .48756 L\n.69286 .49055 L\n.69286 .49055 L\n.69333 .48847 L\n.69333 .48847 L\n.69381 .49138 L\n.69381 .49138 L\n.69429 .48931 L\n.69429 .48931 L\n.69476 .49226 L\n.69476 .49226 L\n.69524 .49019 L\n.69524 .49019 L\n.69571 .49306 L\n.69571 .49306 L\n.69619 .49099 L\n.69619 .49099 L\n.69667 .49391 L\n.69667 .49391 L\n.69714 .49183 L\n.69714 .49183 L\n.69762 .49468 L\n.69762 .49468 L\n.6981 .49261 L\n.6981 .49261 L\n.69857 .49549 L\n.69857 .49549 L\n.69905 .49342 L\n.69905 .49342 L\n.69952 .49623 L\n.69952 .49623 L\n.7 .49416 L\n.7 .49416 L\n.70048 .49701 L\n.70048 .49701 L\n.70095 .49494 L\n.70095 .49494 L\n.70143 .49772 L\n.70143 .49772 L\n.7019 .49565 L\nMistroke\n.7019 .49565 L\n.70238 .49847 L\n.70238 .49847 L\n.70286 .4964 L\n.70286 .4964 L\n.70333 .49915 L\n.70333 .49915 L\n.70381 .49708 L\n.70381 .49708 L\n.70429 .49987 L\n.70429 .49987 L\n.70476 .4978 L\n.70476 .4978 L\n.70524 .50053 L\n.70524 .50053 L\n.70571 .49845 L\n.70571 .49845 L\n.70619 .50122 L\n.70619 .50122 L\n.70667 .49915 L\n.70667 .49915 L\n.70714 .50185 L\n.70714 .50185 L\n.70762 .49978 L\n.70762 .49978 L\n.7081 .50252 L\n.7081 .50252 L\n.70857 .50044 L\n.70857 .50044 L\n.70905 .50312 L\n.70905 .50312 L\n.70952 .50105 L\n.70952 .50105 L\n.71 .50376 L\n.71 .50376 L\n.71048 .50169 L\n.71048 .50169 L\n.71095 .50434 L\n.71095 .50434 L\n.71143 .50227 L\n.71143 .50227 L\n.7119 .50496 L\n.7119 .50496 L\n.71238 .50289 L\n.71238 .50289 L\n.71286 .50551 L\n.71286 .50551 L\n.71333 .50344 L\n.71333 .50344 L\n.71381 .50611 L\nMistroke\n.71381 .50611 L\n.71429 .50403 L\n.71429 .50403 L\n.71476 .50664 L\n.71476 .50664 L\n.71524 .50457 L\n.71524 .50457 L\n.71571 .50721 L\n.71571 .50721 L\n.71619 .50514 L\n.71619 .50514 L\n.71667 .50772 L\n.71667 .50772 L\n.71714 .50565 L\n.71714 .50565 L\n.71762 .50827 L\n.71762 .50827 L\n.7181 .5062 L\n.7181 .5062 L\n.71857 .50876 L\n.71857 .50876 L\n.71905 .50669 L\n.71905 .50669 L\n.71952 .50929 L\n.71952 .50929 L\n.72 .50722 L\n.72 .50722 L\n.72048 .50976 L\n.72048 .50976 L\n.72095 .50769 L\n.72095 .50769 L\n.72143 .51027 L\n.72143 .51027 L\n.7219 .5082 L\n.7219 .5082 L\n.72238 .51072 L\n.72238 .51072 L\n.72286 .50865 L\n.72286 .50865 L\n.72333 .51121 L\n.72333 .51121 L\n.72381 .50914 L\n.72381 .50914 L\n.72429 .51164 L\n.72429 .51164 L\n.72476 .50957 L\n.72476 .50957 L\n.72524 .51212 L\n.72524 .51212 L\n.72571 .51004 L\nMistroke\n.72571 .51004 L\n.72619 .51253 L\n.72619 .51253 L\n.72667 .51046 L\n.72667 .51046 L\n.72714 .51298 L\n.72714 .51298 L\n.72762 .51091 L\n.72762 .51091 L\n.7281 .51338 L\n.7281 .51338 L\n.72857 .51131 L\n.72857 .51131 L\n.72905 .51382 L\n.72905 .51382 L\n.72952 .51174 L\n.72952 .51174 L\n.73 .5142 L\n.73 .5142 L\n.73048 .51213 L\n.73048 .51213 L\n.73095 .51462 L\n.73095 .51462 L\n.73143 .51255 L\n.73143 .51255 L\n.7319 .51498 L\n.7319 .51498 L\n.73238 .51291 L\n.73238 .51291 L\n.73286 .51539 L\n.73286 .51539 L\n.73333 .51332 L\n.73333 .51332 L\n.73381 .51574 L\n.73381 .51574 L\n.73429 .51367 L\n.73429 .51367 L\n.73476 .51613 L\n.73476 .51613 L\n.73524 .51406 L\n.73524 .51406 L\n.73571 .51647 L\n.73571 .51647 L\n.73619 .51439 L\n.73619 .51439 L\n.73667 .51684 L\n.73667 .51684 L\n.73714 .51477 L\n.73714 .51477 L\n.73762 .51716 L\nMistroke\n.73762 .51716 L\n.7381 .51509 L\n.7381 .51509 L\n.73857 .51752 L\n.73857 .51752 L\n.73905 .51545 L\n.73905 .51545 L\n.73952 .51783 L\n.73952 .51783 L\n.74 .51576 L\n.74 .51576 L\n.74048 .51818 L\n.74048 .51818 L\n.74095 .51611 L\n.74095 .51611 L\n.74143 .51848 L\n.74143 .51848 L\n.7419 .5164 L\n.7419 .5164 L\n.74238 .51881 L\n.74238 .51881 L\n.74286 .51674 L\n.74286 .51674 L\n.74333 .51909 L\n.74333 .51909 L\n.74381 .51702 L\n.74381 .51702 L\n.74429 .51942 L\n.74429 .51942 L\n.74476 .51734 L\n.74476 .51734 L\n.74524 .51969 L\n.74524 .51969 L\n.74571 .51761 L\n.74571 .51761 L\n.74619 .52 L\n.74619 .52 L\n.74667 .51793 L\n.74667 .51793 L\n.74714 .52026 L\n.74714 .52026 L\n.74762 .51818 L\n.74762 .51818 L\n.7481 .52056 L\n.7481 .52056 L\n.74857 .51848 L\n.74857 .51848 L\n.74905 .52081 L\n.74905 .52081 L\n.74952 .51873 L\nMistroke\n.74952 .51873 L\n.75 .5211 L\n.75 .5211 L\n.75048 .51902 L\n.75048 .51902 L\n.75095 .52133 L\n.75095 .52133 L\n.75143 .51926 L\n.75143 .51926 L\n.7519 .52161 L\n.7519 .52161 L\n.75238 .51954 L\n.75238 .51954 L\n.75286 .52184 L\n.75286 .52184 L\n.75333 .51977 L\n.75333 .51977 L\n.75381 .52211 L\n.75381 .52211 L\n.75429 .52003 L\n.75429 .52003 L\n.75476 .52233 L\n.75476 .52233 L\n.75524 .52025 L\n.75524 .52025 L\n.75571 .52259 L\n.75571 .52259 L\n.75619 .52051 L\n.75619 .52051 L\n.75667 .52279 L\n.75667 .52279 L\n.75714 .52072 L\n.75714 .52072 L\n.75762 .52304 L\n.75762 .52304 L\n.7581 .52097 L\n.7581 .52097 L\n.75857 .52324 L\n.75857 .52324 L\n.75905 .52117 L\n.75905 .52117 L\n.75952 .52348 L\n.75952 .52348 L\n.76 .52141 L\n.76 .52141 L\n.76048 .52367 L\n.76048 .52367 L\n.76095 .5216 L\n.76095 .5216 L\n.76143 .52391 L\nMistroke\n.76143 .52391 L\n.7619 .52183 L\n.7619 .52183 L\n.76238 .52409 L\n.76238 .52409 L\n.76286 .52201 L\n.76286 .52201 L\n.76333 .52431 L\n.76333 .52431 L\n.76381 .52224 L\n.76381 .52224 L\n.76429 .52449 L\n.76429 .52449 L\n.76476 .52241 L\n.76476 .52241 L\n.76524 .5247 L\n.76524 .5247 L\n.76571 .52263 L\n.76571 .52263 L\n.76619 .52487 L\n.76619 .52487 L\n.76667 .5228 L\n.76667 .5228 L\n.76714 .52508 L\n.76714 .52508 L\n.76762 .523 L\n.76762 .523 L\n.7681 .52524 L\n.7681 .52524 L\n.76857 .52316 L\n.76857 .52316 L\n.76905 .52544 L\n.76905 .52544 L\n.76952 .52336 L\n.76952 .52336 L\n.77 .52559 L\n.77 .52559 L\n.77048 .52352 L\n.77048 .52352 L\n.77095 .52578 L\n.77095 .52578 L\n.77143 .52371 L\n.77143 .52371 L\n.7719 .52593 L\n.7719 .52593 L\n.77238 .52386 L\n.77238 .52386 L\n.77286 .52612 L\n.77286 .52612 L\n.77333 .52404 L\nMistroke\n.77333 .52404 L\n.77381 .52626 L\n.77381 .52626 L\n.77429 .52418 L\n.77429 .52418 L\n.77476 .52644 L\n.77476 .52644 L\n.77524 .52436 L\n.77524 .52436 L\n.77571 .52657 L\n.77571 .52657 L\n.77619 .52449 L\n.77619 .52449 L\n.77667 .52674 L\n.77667 .52674 L\n.77714 .52467 L\n.77714 .52467 L\n.77762 .52687 L\n.77762 .52687 L\n.7781 .5248 L\n.7781 .5248 L\n.77857 .52704 L\n.77857 .52704 L\n.77905 .52496 L\n.77905 .52496 L\n.77952 .52716 L\n.77952 .52716 L\n.78 .52508 L\n.78 .52508 L\n.78048 .52732 L\n.78048 .52732 L\n.78095 .52525 L\n.78095 .52525 L\n.78143 .52744 L\n.78143 .52744 L\n.7819 .52536 L\n.7819 .52536 L\n.78238 .52759 L\n.78238 .52759 L\n.78286 .52552 L\n.78286 .52552 L\n.78333 .5277 L\n.78333 .5277 L\n.78381 .52563 L\n.78381 .52563 L\n.78429 .52785 L\n.78429 .52785 L\n.78476 .52578 L\n.78476 .52578 L\n.78524 .52796 L\nMistroke\n.78524 .52796 L\n.78571 .52589 L\n.78571 .52589 L\n.78619 .52811 L\n.78619 .52811 L\n.78667 .52603 L\n.78667 .52603 L\n.78714 .52821 L\n.78714 .52821 L\n.78762 .52613 L\n.78762 .52613 L\n.7881 .52835 L\n.7881 .52835 L\n.78857 .52627 L\n.78857 .52627 L\n.78905 .52844 L\n.78905 .52844 L\n.78952 .52637 L\n.78952 .52637 L\n.79 .52858 L\n.79 .52858 L\n.79048 .52651 L\n.79048 .52651 L\n.79095 .52867 L\n.79095 .52867 L\n.79143 .5266 L\n.79143 .5266 L\n.7919 .5288 L\n.7919 .5288 L\n.79238 .52673 L\n.79238 .52673 L\n.79286 .52889 L\n.79286 .52889 L\n.79333 .52681 L\n.79333 .52681 L\n.79381 .52902 L\n.79381 .52902 L\n.79429 .52694 L\n.79429 .52694 L\n.79476 .5291 L\n.79476 .5291 L\n.79524 .52703 L\n.79524 .52703 L\n.79571 .52922 L\n.79571 .52922 L\n.79619 .52715 L\n.79619 .52715 L\n.79667 .5293 L\n.79667 .5293 L\n.79714 .52723 L\nMistroke\n.79714 .52723 L\n.79762 .52942 L\n.79762 .52942 L\n.7981 .52735 L\n.7981 .52735 L\n.79857 .52949 L\n.79857 .52949 L\n.79905 .52742 L\n.79905 .52742 L\n.79952 .52961 L\n.79952 .52961 L\n.8 .52754 L\n.8 .52754 L\n.80048 .52968 L\n.80048 .52968 L\n.80095 .52761 L\n.80095 .52761 L\n.80143 .52979 L\n.80143 .52979 L\n.8019 .52772 L\n.8019 .52772 L\n.80238 .52986 L\n.80238 .52986 L\n.80286 .52779 L\n.80286 .52779 L\n.80333 .52997 L\n.80333 .52997 L\n.80381 .52789 L\n.80381 .52789 L\n.80429 .53003 L\n.80429 .53003 L\n.80476 .52796 L\n.80476 .52796 L\n.80524 .53014 L\n.80524 .53014 L\n.80571 .52806 L\n.80571 .52806 L\n.80619 .5302 L\n.80619 .5302 L\n.80667 .52812 L\n.80667 .52812 L\n.80714 .5303 L\n.80714 .5303 L\n.80762 .52822 L\n.80762 .52822 L\n.8081 .53036 L\n.8081 .53036 L\n.80857 .52828 L\n.80857 .52828 L\n.80905 .53045 L\nMistroke\n.80905 .53045 L\n.80952 .52838 L\n.80952 .52838 L\n.81 .53051 L\n.81 .53051 L\n.81048 .52843 L\n.81048 .52843 L\n.81095 .5306 L\n.81095 .5306 L\n.81143 .52853 L\n.81143 .52853 L\n.8119 .53065 L\n.8119 .53065 L\n.81238 .52858 L\n.81238 .52858 L\n.81286 .53075 L\n.81286 .53075 L\n.81333 .52867 L\n.81333 .52867 L\n.81381 .53079 L\n.81381 .53079 L\n.81429 .52872 L\n.81429 .52872 L\n.81476 .53088 L\n.81476 .53088 L\n.81524 .52881 L\n.81524 .52881 L\n.81571 .53093 L\n.81571 .53093 L\n.81619 .52886 L\n.81619 .52886 L\n.81667 .53102 L\n.81667 .53102 L\n.81714 .52894 L\n.81714 .52894 L\n.81762 .53106 L\n.81762 .53106 L\n.8181 .52899 L\n.8181 .52899 L\n.81857 .53114 L\n.81857 .53114 L\n.81905 .52907 L\n.81905 .52907 L\n.81952 .53118 L\n.81952 .53118 L\n.82 .52911 L\n.82 .52911 L\n.82048 .53127 L\n.82048 .53127 L\n.82095 .52919 L\nMistroke\n.82095 .52919 L\n.82143 .5313 L\n.82143 .5313 L\n.8219 .52923 L\n.8219 .52923 L\n.82238 .53138 L\n.82238 .53138 L\n.82286 .52931 L\n.82286 .52931 L\n.82333 .53142 L\n.82333 .53142 L\n.82381 .52935 L\n.82381 .52935 L\n.82429 .5315 L\n.82429 .5315 L\n.82476 .52942 L\n.82476 .52942 L\n.82524 .53153 L\n.82524 .53153 L\n.82571 .52946 L\n.82571 .52946 L\n.82619 .53161 L\n.82619 .53161 L\n.82667 .52953 L\n.82667 .52953 L\n.82714 .53164 L\n.82714 .53164 L\n.82762 .52956 L\n.82762 .52956 L\n.8281 .53171 L\n.8281 .53171 L\n.82857 .52964 L\n.82857 .52964 L\n.82905 .53174 L\n.82905 .53174 L\n.82952 .52967 L\n.82952 .52967 L\n.83 .53181 L\n.83 .53181 L\n.83048 .52974 L\n.83048 .52974 L\n.83095 .53184 L\n.83095 .53184 L\n.83143 .52976 L\n.83143 .52976 L\n.8319 .53191 L\n.8319 .53191 L\n.83238 .52983 L\n.83238 .52983 L\n.83286 .53193 L\nMistroke\n.83286 .53193 L\n.83333 .52986 L\n.83333 .52986 L\n.83381 .532 L\n.83381 .532 L\n.83429 .52992 L\n.83429 .52992 L\n.83476 .53202 L\n.83476 .53202 L\n.83524 .52995 L\n.83524 .52995 L\n.83571 .53209 L\n.83571 .53209 L\n.83619 .53001 L\n.83619 .53001 L\n.83667 .53211 L\n.83667 .53211 L\n.83714 .53004 L\n.83714 .53004 L\n.83762 .53217 L\n.83762 .53217 L\n.8381 .5301 L\n.8381 .5301 L\n.83857 .53219 L\n.83857 .53219 L\n.83905 .53012 L\n.83905 .53012 L\n.83952 .53226 L\n.83952 .53226 L\n.84 .53018 L\n.84 .53018 L\n.84048 .53227 L\n.84048 .53227 L\n.84095 .5302 L\n.84095 .5302 L\n.84143 .53233 L\n.84143 .53233 L\n.8419 .53026 L\n.8419 .53026 L\n.84238 .53235 L\n.84238 .53235 L\n.84286 .53028 L\n.84286 .53028 L\n.84333 .53241 L\n.84333 .53241 L\n.84381 .53034 L\n.84381 .53034 L\n.84429 .53242 L\n.84429 .53242 L\n.84476 .53035 L\nMistroke\n.84476 .53035 L\n.84524 .53248 L\n.84524 .53248 L\n.84571 .53041 L\n.84571 .53041 L\n.84619 .5325 L\n.84619 .5325 L\n.84667 .53042 L\n.84667 .53042 L\n.84714 .53255 L\n.84714 .53255 L\n.84762 .53048 L\n.84762 .53048 L\n.8481 .53256 L\n.8481 .53256 L\n.84857 .53049 L\n.84857 .53049 L\n.84905 .53262 L\n.84905 .53262 L\n.84952 .53055 L\n.84952 .53055 L\n.85 .53263 L\n.85 .53263 L\n.85048 .53056 L\n.85048 .53056 L\n.85095 .53268 L\n.85095 .53268 L\n.85143 .53061 L\n.85143 .53061 L\n.8519 .53269 L\n.8519 .53269 L\n.85238 .53062 L\n.85238 .53062 L\n.85286 .53275 L\n.85286 .53275 L\n.85333 .53067 L\n.85333 .53067 L\n.85381 .53275 L\n.85381 .53275 L\n.85429 .53068 L\n.85429 .53068 L\n.85476 .53281 L\n.85476 .53281 L\n.85524 .53073 L\n.85524 .53073 L\n.85571 .53281 L\n.85571 .53281 L\n.85619 .53074 L\n.85619 .53074 L\n.85667 .53286 L\nMistroke\n.85667 .53286 L\n.85714 .53079 L\n.85714 .53079 L\n.85762 .53287 L\n.85762 .53287 L\n.8581 .5308 L\n.8581 .5308 L\n.85857 .53292 L\n.85857 .53292 L\n.85905 .53084 L\n.85905 .53084 L\n.85952 .53292 L\n.85952 .53292 L\n.86 .53085 L\n.86 .53085 L\n.86048 .53297 L\n.86048 .53297 L\n.86095 .5309 L\n.86095 .5309 L\n.86143 .53298 L\n.86143 .53298 L\n.8619 .5309 L\n.8619 .5309 L\n.86238 .53302 L\n.86238 .53302 L\n.86286 .53095 L\n.86286 .53095 L\n.86333 .53302 L\n.86333 .53302 L\n.86381 .53095 L\n.86381 .53095 L\n.86429 .53307 L\n.86429 .53307 L\n.86476 .531 L\n.86476 .531 L\n.86524 .53307 L\n.86524 .53307 L\n.86571 .531 L\n.86571 .531 L\n.86619 .53312 L\n.86619 .53312 L\n.86667 .53104 L\n.86667 .53104 L\n.86714 .53312 L\n.86714 .53312 L\n.86762 .53104 L\n.86762 .53104 L\n.8681 .53316 L\n.8681 .53316 L\n.86857 .53109 L\nMistroke\n.86857 .53109 L\n.86905 .53316 L\n.86905 .53316 L\n.86952 .53109 L\n.86952 .53109 L\n.87 .53321 L\n.87 .53321 L\n.87048 .53113 L\n.87048 .53113 L\n.87095 .5332 L\n.87095 .5332 L\n.87143 .53113 L\n.87143 .53113 L\n.8719 .53325 L\n.8719 .53325 L\n.87238 .53117 L\n.87238 .53117 L\n.87286 .53325 L\n.87286 .53325 L\n.87333 .53117 L\n.87333 .53117 L\n.87381 .53329 L\n.87381 .53329 L\n.87429 .53121 L\n.87429 .53121 L\n.87476 .53328 L\n.87476 .53328 L\n.87524 .53121 L\n.87524 .53121 L\n.87571 .53332 L\n.87571 .53332 L\n.87619 .53125 L\n.87619 .53125 L\n.87667 .53332 L\n.87667 .53332 L\n.87714 .53125 L\n.87714 .53125 L\n.87762 .53336 L\n.87762 .53336 L\n.8781 .53129 L\n.8781 .53129 L\n.87857 .53336 L\n.87857 .53336 L\n.87905 .53129 L\n.87905 .53129 L\n.87952 .5334 L\n.87952 .5334 L\n.88 .53132 L\n.88 .53132 L\n.88048 .53339 L\nMistroke\n.88048 .53339 L\n.88095 .53132 L\n.88095 .53132 L\n.88143 .53343 L\n.88143 .53343 L\n.8819 .53136 L\n.8819 .53136 L\n.88238 .53343 L\n.88238 .53343 L\n.88286 .53135 L\n.88286 .53135 L\n.88333 .53346 L\n.88333 .53346 L\n.88381 .53139 L\n.88381 .53139 L\n.88429 .53346 L\n.88429 .53346 L\n.88476 .53138 L\n.88476 .53138 L\n.88524 .5335 L\n.88524 .5335 L\n.88571 .53142 L\n.88571 .53142 L\n.88619 .53349 L\n.88619 .53349 L\n.88667 .53142 L\n.88667 .53142 L\n.88714 .53353 L\n.88714 .53353 L\n.88762 .53145 L\n.88762 .53145 L\n.8881 .53352 L\n.8881 .53352 L\n.88857 .53145 L\n.88857 .53145 L\n.88905 .53355 L\n.88905 .53355 L\n.88952 .53148 L\n.88952 .53148 L\n.89 .53355 L\n.89 .53355 L\n.89048 .53147 L\n.89048 .53147 L\n.89095 .53358 L\n.89095 .53358 L\n.89143 .53151 L\n.89143 .53151 L\n.8919 .53357 L\n.8919 .53357 L\n.89238 .5315 L\nMistroke\n.89238 .5315 L\n.89286 .53361 L\n.89286 .53361 L\n.89333 .53154 L\n.89333 .53154 L\n.89381 .5336 L\n.89381 .5336 L\n.89429 .53153 L\n.89429 .53153 L\n.89476 .53363 L\n.89476 .53363 L\n.89524 .53156 L\n.89524 .53156 L\n.89571 .53363 L\n.89571 .53363 L\n.89619 .53155 L\n.89619 .53155 L\n.89667 .53366 L\n.89667 .53366 L\n.89714 .53159 L\n.89714 .53159 L\n.89762 .53365 L\n.89762 .53365 L\n.8981 .53158 L\n.8981 .53158 L\n.89857 .53368 L\n.89857 .53368 L\n.89905 .53161 L\n.89905 .53161 L\n.89952 .53367 L\n.89952 .53367 L\n.9 .5316 L\n.9 .5316 L\n.90048 .53371 L\n.90048 .53371 L\n.90095 .53163 L\n.90095 .53163 L\n.90143 .5337 L\n.90143 .5337 L\n.9019 .53162 L\n.9019 .53162 L\n.90238 .53373 L\n.90238 .53373 L\n.90286 .53165 L\n.90286 .53165 L\n.90333 .53372 L\n.90333 .53372 L\n.90381 .53164 L\n.90381 .53164 L\n.90429 .53375 L\nMistroke\n.90429 .53375 L\n.90476 .53168 L\n.90476 .53168 L\n.90524 .53374 L\n.90524 .53374 L\n.90571 .53166 L\n.90571 .53166 L\n.90619 .53377 L\n.90619 .53377 L\n.90667 .53169 L\n.90667 .53169 L\n.90714 .53376 L\n.90714 .53376 L\n.90762 .53168 L\n.90762 .53168 L\n.9081 .53379 L\n.9081 .53379 L\n.90857 .53171 L\n.90857 .53171 L\n.90905 .53378 L\n.90905 .53378 L\n.90952 .5317 L\n.90952 .5317 L\n.91 .53381 L\n.91 .53381 L\n.91048 .53173 L\n.91048 .53173 L\n.91095 .5338 L\n.91095 .5338 L\n.91143 .53172 L\n.91143 .53172 L\n.9119 .53383 L\n.9119 .53383 L\n.91238 .53175 L\n.91238 .53175 L\n.91286 .53381 L\n.91286 .53381 L\n.91333 .53174 L\n.91333 .53174 L\n.91381 .53384 L\n.91381 .53384 L\n.91429 .53177 L\n.91429 .53177 L\n.91476 .53383 L\n.91476 .53383 L\n.91524 .53176 L\n.91524 .53176 L\n.91571 .53386 L\n.91571 .53386 L\n.91619 .53179 L\nMistroke\n.91619 .53179 L\n.91667 .53385 L\n.91667 .53385 L\n.91714 .53177 L\n.91714 .53177 L\n.91762 .53387 L\n.91762 .53387 L\n.9181 .5318 L\n.9181 .5318 L\n.91857 .53386 L\n.91857 .53386 L\n.91905 .53179 L\n.91905 .53179 L\n.91952 .53389 L\n.91952 .53389 L\n.92 .53182 L\n.92 .53182 L\n.92048 .53388 L\n.92048 .53388 L\n.92095 .5318 L\n.92095 .5318 L\n.92143 .5339 L\n.92143 .5339 L\n.9219 .53183 L\n.9219 .53183 L\n.92238 .53389 L\n.92238 .53389 L\n.92286 .53182 L\n.92286 .53182 L\n.92333 .53392 L\n.92333 .53392 L\n.92381 .53185 L\n.92381 .53185 L\n.92429 .5339 L\n.92429 .5339 L\n.92476 .53183 L\n.92476 .53183 L\n.92524 .53393 L\n.92524 .53393 L\n.92571 .53186 L\n.92571 .53186 L\n.92619 .53392 L\n.92619 .53392 L\n.92667 .53184 L\n.92667 .53184 L\n.92714 .53395 L\n.92714 .53395 L\n.92762 .53187 L\n.92762 .53187 L\n.9281 .53393 L\nMistroke\n.9281 .53393 L\n.92857 .53186 L\n.92857 .53186 L\n.92905 .53396 L\n.92905 .53396 L\n.92952 .53188 L\n.92952 .53188 L\n.93 .53394 L\n.93 .53394 L\n.93048 .53187 L\n.93048 .53187 L\n.93095 .53397 L\n.93095 .53397 L\n.93143 .5319 L\n.93143 .5319 L\n.9319 .53395 L\n.9319 .53395 L\n.93238 .53188 L\n.93238 .53188 L\n.93286 .53398 L\n.93286 .53398 L\n.93333 .53191 L\n.93333 .53191 L\n.93381 .53397 L\n.93381 .53397 L\n.93429 .53189 L\n.93429 .53189 L\n.93476 .53399 L\n.93476 .53399 L\n.93524 .53192 L\n.93524 .53192 L\n.93571 .53398 L\n.93571 .53398 L\n.93619 .5319 L\n.93619 .5319 L\n.93667 .534 L\n.93667 .534 L\n.93714 .53193 L\n.93714 .53193 L\n.93762 .53399 L\n.93762 .53399 L\n.9381 .53191 L\n.9381 .53191 L\n.93857 .53401 L\n.93857 .53401 L\n.93905 .53194 L\n.93905 .53194 L\n.93952 .534 L\n.93952 .534 L\n.94 .53192 L\nMistroke\n.94 .53192 L\n.94048 .53402 L\n.94048 .53402 L\n.94095 .53195 L\n.94095 .53195 L\n.94143 .53401 L\n.94143 .53401 L\n.9419 .53193 L\n.9419 .53193 L\n.94238 .53403 L\n.94238 .53403 L\n.94286 .53196 L\n.94286 .53196 L\n.94333 .53402 L\n.94333 .53402 L\n.94381 .53194 L\n.94381 .53194 L\n.94429 .53404 L\n.94429 .53404 L\n.94476 .53197 L\n.94476 .53197 L\n.94524 .53403 L\n.94524 .53403 L\n.94571 .53195 L\n.94571 .53195 L\n.94619 .53405 L\n.94619 .53405 L\n.94667 .53198 L\n.94667 .53198 L\n.94714 .53403 L\n.94714 .53403 L\n.94762 .53196 L\n.94762 .53196 L\n.9481 .53406 L\n.9481 .53406 L\n.94857 .53198 L\n.94857 .53198 L\n.94905 .53404 L\n.94905 .53404 L\n.94952 .53197 L\n.94952 .53197 L\n.95 .53407 L\n.95 .53407 L\n.95048 .53199 L\n.95048 .53199 L\n.95095 .53405 L\n.95095 .53405 L\n.95143 .53198 L\n.95143 .53198 L\n.9519 .53407 L\nMistroke\n.9519 .53407 L\n.95238 .532 L\n.95238 .532 L\n.95286 .53406 L\n.95286 .53406 L\n.95333 .53198 L\n.95333 .53198 L\n.95381 .53408 L\n.95381 .53408 L\n.95429 .53201 L\n.95429 .53201 L\n.95476 .53406 L\n.95476 .53406 L\n.95524 .53199 L\n.95524 .53199 L\n.95571 .53409 L\n.95571 .53409 L\n.95619 .53202 L\n.95619 .53202 L\n.95667 .53407 L\n.95667 .53407 L\n.95714 .532 L\n.95714 .532 L\n.95762 .5341 L\n.95762 .5341 L\n.9581 .53202 L\n.9581 .53202 L\n.95857 .53408 L\n.95857 .53408 L\n.95905 .53201 L\n.95905 .53201 L\n.95952 .5341 L\n.95952 .5341 L\n.96 .53203 L\n.96 .53203 L\n.96048 .53409 L\n.96048 .53409 L\n.96095 .53201 L\n.96095 .53201 L\n.96143 .53411 L\n.96143 .53411 L\n.9619 .53204 L\n.9619 .53204 L\n.96238 .53409 L\n.96238 .53409 L\n.96286 .53202 L\n.96286 .53202 L\n.96333 .53412 L\n.96333 .53412 L\n.96381 .53204 L\nMistroke\n.96381 .53204 L\n.96429 .5341 L\n.96429 .5341 L\n.96476 .53202 L\n.96476 .53202 L\n.96524 .53412 L\n.96524 .53412 L\n.96571 .53205 L\n.96571 .53205 L\n.96619 .5341 L\n.96619 .5341 L\n.96667 .53203 L\n.96667 .53203 L\n.96714 .53413 L\n.96714 .53413 L\n.96762 .53205 L\n.96762 .53205 L\n.9681 .53411 L\n.9681 .53411 L\n.96857 .53203 L\n.96857 .53203 L\n.96905 .53413 L\n.96905 .53413 L\n.96952 .53206 L\n.96952 .53206 L\n.97 .53411 L\n.97 .53411 L\n.97048 .53204 L\n.97048 .53204 L\n.97095 .53414 L\n.97095 .53414 L\n.97143 .53206 L\n.97143 .53206 L\n.9719 .53412 L\n.9719 .53412 L\n.97238 .53205 L\n.97238 .53205 L\n.97286 .53414 L\n.97286 .53414 L\n.97333 .53207 L\n.97333 .53207 L\n.97381 .53412 L\n.97381 .53412 L\n.97429 .53205 L\n.97429 .53205 L\n.97476 .53415 L\n.97476 .53415 L\n.97524 .53207 L\n.97524 .53207 L\n.97571 .53413 L\nMistroke\n.97571 .53413 L\n.97619 .53205 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(tank) show\n93.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n99.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(h) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n105.000 12.813 moveto\n(L) show\n111.000 12.813 moveto\n(@) show\n117.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n123.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00D@3IfMT2000000@0fMWI0P00000^0=WIf@D000000P3IfMT2000000@0\nfMWI0P00000Z0=WIf@D000000P3IfMT2000000@0fMWI0P00000[0=WIf@@000000`3IfMT2000000@0\nfMWI0P00000G0=WIf@00D03IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI0000\n02l0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00<0\n00000=WIf@3IfMT0:@3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00@000000=WIf@3IfMT0\n00000P3IfMT00`000000fMWI0=WIf@0X0=WIf@030000003IfMT0fMWI00<0fMWI00@000000=WIf@3I\nfMT000000P3IfMT010000000fMWI0=WIf@00000F0=WIf@00D`3IfMT010000000fMWI0=WIf@000002\n0=WIf@030000003IfMT0fMWI02d0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003I\nfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0:@3IfMT00`000000fMWI0=WIf@040=WIf@040000\n003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0:@3IfMT00`000000fMWI0=WIf@020=WIf@04\n0000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000005P3IfMT00540fMWI0P0000030=WI\nf@040000003IfMT0fMWI000002l0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003I\nfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0:@3IfMT00`000000fMWI0=WIf@020=WIf@800000\n0`3IfMT010000000fMWI0=WIf@00000/0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT01000\n0000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI01@0fMWI001A0=WIf@030000003IfMT0fMWI\n0080fMWI00@000000=WIf@3IfMT00000;`3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00@0\n00000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@0Y0=WIf@030000003IfMT0fMWI0080fMWI\n00<000000=WIf@3IfMT00P3IfMT010000000fMWI0=WIf@00000Z0=WIf@040000003IfMT0fMWI0000\n0080fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@00000F0=WIf@00D@3IfMT3\n000000<0fMWI0P00000_0=WIf@800000103IfMT2000000@0fMWI0P00000[0=WIf@800000103IfMT3\n000000<0fMWI0P00000/0=WIf@800000103IfMT2000000@0fMWI0P00000G0=WIf@00o`3IfMTQ0=WI\nf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<000000=WIf@3IfMT0lP3IfMT2000000d0fMWI000L0=WIf@030000003IfMT0\nfMWI0?40fMWI00@000000=WIf@3IfMT00000303IfMT001H0fMWI1P0000000`000?l000000000003Y\n000000P0fMWI00<000000=WIf@3IfMT03@3IfMT001`0fMWI00<0003o0=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00X0fMWI1@00000<0=WIf@00703IfMT00`000?l0\nfMWI0=WIf@3a0=WIf@030000003IfMT0fMWI00d0fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o\n0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000o`3I\nfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`00\n0?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI\n00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WI\nf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o\n0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3I\nfMT0o`3IfMT20=WIf@002@3IfMT2000000@0fMWI0P0000030=WIf@D000000`3IfMT00`000?l0fMWI\n0=WIf@3o0=WIf@80fMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT0\n0`3IfMT20000ool0fMWI0`3IfMT000P0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI\n0=WIf@030=WIf@030000o`000000fMWI0?l0fMWI0P3IfMT000P0fMWI00@000000=WIf@3IfMT00000\n2P3IfMT00`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT000P0fMWI00@0\n00000=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0?l0fMWI\n0P3IfMT000T0fMWI0P00000:0=WIf@8000001@3IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@80003oo`3IfMT30=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@03\n0000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703I\nfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@80003oo`3IfMT30=WIf@00703IfMT00`00\n0?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI\n00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@80003oo`3IfMT30=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@03\n0000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0QP3IfMT20000ogT0fMWI\n000L0=WIf@03000000000?l0fMWI08H0fMWI0P000?mi0=WIf@00703IfMT00`000000003o0=WIf@26\n0=WIf@80003oN@3IfMT001`0fMWI00<000000000o`3IfMT0QP3IfMT20000ogT0fMWI000L0=WIf@03\n000000000?l0fMWI08H0fMWI0`000?mh0=WIf@00703IfMT00`000000003o0=WIf@250=WIf@@0003o\nN03IfMT000T0fMWI0P0000040=WIf@8000000`3IfMT4000000@0fMWI00<000000000o`3IfMT0Q@3I\nfMT40000ogP0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01@3I\nfMT00`000000003o0=WIf@250=WIf@040000o`3IfMT0003o0000ogP0fMWI00080=WIf@040000003I\nfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT0103IfMT00`000000003o0=WIf@250=WIf@040000\no`3IfMT0fMWI0000ogP0fMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3I\nfMT00`3IfMT00`000000003o0=WIf@240=WIf@80003o0P3IfMT00`000?l0fMWI0=WIf@1f0=WIf@00\n203IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0fMWI00<000000000\no`3IfMT0Q03IfMT20000o`80fMWI0P000?mg0=WIf@002@3IfMT2000000X0fMWI0P0000050=WIf@03\n000000000?l0fMWI08@0fMWI00@0003o0=WIf@3IfMT0fMWI0P000?mg0=WIf@00703IfMT00`000000\n003o0=WIf@240=WIf@040000o`3IfMT0fMWI0=WIf@80003oM`3IfMT001`0fMWI00<000000000o`3I\nfMT0P`3IfMT20000o`<0fMWI0P000?mg0=WIf@00703IfMT00`000000003o0=WIf@230=WIf@80003o\n103IfMT00`000?l0fMWI0=WIf@1e0=WIf@00703IfMT00`000000003o0=WIf@230=WIf@030000o`3I\nfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0M@3IfMT001`0fMWI00<000000000o`3IfMT0P`3IfMT0\n0`000?l0fMWI0=WIf@030=WIf@80003oMP3IfMT001`0fMWI00<000000000o`3IfMT0P`3IfMT00`00\n0?l0fMWI0=WIf@030=WIf@80003oMP3IfMT001`0fMWI00<000000000o`3IfMT0PP3IfMT20000o`D0\nfMWI0P000?mf0=WIf@00703IfMT00`000000003o0=WIf@220=WIf@80003o1@3IfMT20000ogH0fMWI\n000L0=WIf@03000000000?l0fMWI0880fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WI\nf@1d0=WIf@00703IfMT00`000000003o0=WIf@220=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o\n0=WIf@3IfMT0M03IfMT001`0fMWI00<000000000o`3IfMT0P@3IfMT20000o`L0fMWI0P000?me0=WI\nf@00703IfMT00`000000003o0=WIf@210=WIf@80003o1`3IfMT20000ogD0fMWI000L0=WIf@030000\n00000?l0fMWI0840fMWI00<0003o0=WIf@3IfMT01P3IfMT20000ogD0fMWI000L0=WIf@0300000000\n0?l0fMWI0840fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@1c0=WIf@00703IfMT0\n0`000000003o0=WIf@200=WIf@80003o2@3IfMT00`000?l0fMWI0=WIf@1c0=WIf@00703IfMT00`00\n0000003o0=WIf@200=WIf@80003o2@3IfMT20000og@0fMWI000L0=WIf@03000000000?l0003o0800\nfMWI00<0003o0=WIf@3IfMT0203IfMT20000og@0fMWI000L0=WIf@03000000000?l0fMWI0800fMWI\n00<0003o0=WIf@3IfMT0203IfMT20000og@0fMWI000L0=WIf@03000000000?l0fMWI0800fMWI00<0\n003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@1b0=WIf@002@3IfMT2000000@0fMWI0P000004\n0=WIf@8000001@3IfMT00`000000003o0=WIf@1o0=WIf@80003o2`3IfMT20000og<0fMWI00080=WI\nf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000003o0=WI\nf@1o0=WIf@80003o2`3IfMT20000og<0fMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI00<0\n00000=WIf@3IfMT00`3IfMT00`000000003o0000o`1o0=WIf@030000o`3IfMT0fMWI00X0fMWI0P00\n0?mc0=WIf@00203IfMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI0080fMWI00<0\n00000000o`3IfMT0O`3IfMT00`000?l0fMWI0=WIf@0:0=WIf@80003oL`3IfMT000P0fMWI00@00000\n0=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@03000000000?l0fMWI07h0fMWI\n0P000?l=0=WIf@030000o`3IfMT0fMWI0740fMWI00090=WIf@8000002P3IfMT2000000D0fMWI00<0\n00000000o`3IfMT0OP3IfMT20000o`d0fMWI0P000?mb0=WIf@00703IfMT00`000000003o0=WIf@1n\n0=WIf@030000o`3IfMT0fMWI00`0fMWI0P000?mb0=WIf@00703IfMT00`000000003o0000o`1n0=WI\nf@030000o`3IfMT0fMWI00`0fMWI0P000?mb0=WIf@00703IfMT00`000000003o0=WIf@1n0=WIf@03\n0000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0L03IfMT001`0fMWI00<000000000o`3IfMT0\nO@3IfMT20000o`l0fMWI0P000?ma0=WIf@00703IfMT00`000000003o0=WIf@1m0=WIf@030000o`3I\nfMT0fMWI00h0fMWI0P000?ma0=WIf@00703IfMT00`000000003o0=WIf@1m0=WIf@030000o`3IfMT0\nfMWI00l0fMWI00<0003o0=WIf@3IfMT0K`3IfMT001`0fMWI00<000000000o`000?l0O@3IfMT00`00\n0?l0fMWI0=WIf@0?0=WIf@80003oL03IfMT001`0fMWI00<000000000o`3IfMT0O03IfMT20000oa40\nfMWI0P000?m`0=WIf@00703IfMT00`000000003o0=WIf@1l0=WIf@80003o4@3IfMT20000og00fMWI\n000L0=WIf@030000003IfMT0003o07`0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WI\nf@1^0=WIf@00703IfMT00`000000fMWI0000o`1l0=WIf@030000o`3IfMT0fMWI0140fMWI0P000?m_\n0=WIf@00703IfMT00`000000fMWI0000o`1k0=WIf@80003o4`3IfMT20000ofl0fMWI000L0=WIf@03\n0000003IfMT0003o07/0fMWI0P000?lD0=WIf@80003oKP3IfMT001`0fMWI00<000000=WIf@000?l0\nN`3IfMT20000oa@0fMWI0P000?m^0=WIf@00703IfMT00`000000fMWI0000o`1k0=WIf@030000o`3I\nfMT0fMWI01<0fMWI0P000?m^0=WIf@00703IfMT00`000000fMWI0000o`1k0=WIf@030000o`3IfMT0\nfMWI01@0fMWI0P000?m]0=WIf@00703IfMT00`000000fMWI0000o`1j0=WIf@80003o5P3IfMT20000\nofd0fMWI000L0=WIf@030000003IfMT0003o07X0fMWI0P000?lF0=WIf@80003oK@3IfMT001`0fMWI\n00<000000=WIf@000?l0NP3IfMT00`000?l0fMWI0=WIf@0F0=WIf@80003oK03IfMT000T0fMWI0P00\n00040=WIf@8000001@3IfMT3000000<0fMWI00<000000=WIf@000?l0NP3IfMT00`000?l0fMWI0=WI\nf@0F0=WIf@80003oK03IfMT000P0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WI\nf@020=WIf@030000003IfMT0003o07T0fMWI0P000?lI0=WIf@80003oJ`3IfMT000P0fMWI00@00000\n0=WIf@3IfMT00000203IfMT5000000<0fMWI0P0000000`000?l0fMWI0=WIf@1g0=WIf@80003o6@3I\nfMT20000of/0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000\n103IfMT00`000000fMWI0000o`1i0=WIf@030000o`3IfMT0fMWI01T0fMWI0P000?mZ0=WIf@00203I\nfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0000000@0fMWI00<000000=WIf@000?l0\nN@3IfMT00`000?l0fMWI0=WIf@0I0=WIf@80003oJP3IfMT000T0fMWI0P00000;0=WIf@800000103I\nfMT00`000000fMWI0000o`1h0=WIf@80003o6`3IfMT30000ofT0fMWI000L0=WIf@030000003IfMT0\n003o07P0fMWI0P000?lL0=WIf@80003oJ@3IfMT001`0fMWI00<000000=WIf@000?l0N03IfMT20000\noa`0fMWI0`000?mX0=WIf@00703IfMT00`000000fMWI0000o`1h0=WIf@030000o`3IfMT0fMWI01`0\nfMWI0`000?mW0=WIf@00703IfMT00`000000fMWI0000o`1h0=WIf@030000o`3IfMT0fMWI01d0fMWI\n0P000?mW0=WIf@00703IfMT00`000000fMWI0000o`1g0=WIf@80003o7`3IfMT30000ofH0fMWI000L\n0=WIf@030000003IfMT0003o07L0fMWI0P000?lP0=WIf@<0003oI@3IfMT001`0fMWI00<000000=WI\nf@000?l0M`3IfMT00`000?l0fMWI0=WIf@0P0=WIf@<0003oI03IfMT001`0fMWI00<000000=WIf@00\n0?l0M`3IfMT00`000?l0fMWI0=WIf@0P0=WIf@<0003oI03IfMT001`0fMWI00<000000=WIf@000?l0\nMP3IfMT20000ob<0fMWI0`000?mS0=WIf@00703IfMT00`000000fMWI0000o`1f0=WIf@80003o903I\nfMT30000of80fMWI000L0=WIf@030000003IfMT0003o07H0fMWI00<0003o0=WIf@3IfMT0903IfMT3\n0000of40fMWI000L0=WIf@040000003IfMT0003o0000ogD0fMWI00<0003o0=WIf@3IfMT09@3IfMT4\n0000oel0fMWI000L0=WIf@030000003IfMT0003o07H0fMWI00<0003o0=WIf@3IfMT09P3IfMT40000\noeh0fMWI000L0=WIf@030000003IfMT0003o07D0fMWI0P000?lY0=WIf@D0003oG03IfMT001`0fMWI\n00<000000=WIf@000?l0M@3IfMT20000ob/0fMWI10000?mK0=WIf@00703IfMT00`000000fMWI0000\no`1e0=WIf@030000o`3IfMT0fMWI02/0fMWI1@000?mI0=WIf@00703IfMT010000000fMWI0000o`00\n0?md0=WIf@030000o`3IfMT0fMWI02d0fMWI1P000?mF0=WIf@00703IfMT00`000000fMWI0000o`1d\n0=WIf@80003o<@3IfMT70000oe<0fMWI000L0=WIf@030000003IfMT0003o07@0fMWI0P000?ld0=WI\nf@T0003oCP3IfMT000T0fMWI0P0000040=WIf@800000103IfMT2000000D0fMWI00<000000=WIf@00\n0?l0M03IfMT00`000?l0fMWI0=WIf@0f0=WIf@l0003oA@3IfMT000P0fMWI00@000000=WIf@3IfMT0\n0000203IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0003o07@0fMWI00<0003o0=WI\nf@3IfMT0>`3IfMTb0000oad0fMWI00080=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WI\nf@3IfMT00P3IfMT200000080003oLP3IfMT20000odH0fMWI:@000?lM0=WIf@00203IfMT010000000\nfMWI0=WIf@0000090=WIf@8000001@3IfMT00`000000fMWI0000o`1c0=WIf@80003oS03IfMT000P0\nfMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0003o\n07<0fMWI00<0003o0=WIf@3IfMT0R`3IfMT000T0fMWI0P00000:0=WIf@<00000103IfMT010000000\nfMWI0=WIf@000?mb0=WIf@030000o`3IfMT0fMWI08/0fMWI000L0=WIf@040000003IfMT0fMWI0000\nog80fMWI00<0003o0=WIf@3IfMT0R`3IfMT001`0fMWI00@000000=WIf@3IfMT0003oL@3IfMT20000\nohd0fMWI000L0=WIf@040000003IfMT0fMWI0000og40fMWI0P000?n=0=WIf@00703IfMT010000000\nfMWI0=WIf@000?ma0=WIf@030000o`3IfMT0fMWI08`0fMWI000L0=WIf@040000003IfMT0fMWI0000\nog40fMWI00<0003o0=WIf@3IfMT0S03IfMT001`0fMWI00@000000=WIf@3IfMT0003oL03IfMT20000\nohh0fMWI000L0=WIf@040000003IfMT0fMWI0000og00fMWI0P000?n>0=WIf@00703IfMT010000000\nfMWI0=WIf@000?m`0=WIf@030000o`3IfMT0fMWI08d0fMWI000L0=WIf@040000003IfMT0fMWI0000\nog00fMWI00<0003o0=WIf@3IfMT0S@3IfMT001`0fMWI00@000000=WIf@3IfMT0003oL03IfMT00`00\n0?l0fMWI0=WIf@2=0=WIf@00703IfMT010000000fMWI0=WIf@000?m_0=WIf@80003oS`3IfMT001`0\nfMWI00@000000=WIf@3IfMT0003oK`3IfMT00`000?l0fMWI0=WIf@2>0=WIf@00703IfMT010000000\nfMWI0=WIf@000?m_0=WIf@030000o`3IfMT0fMWI08h0fMWI000L0=WIf@030000003IfMT0fMWI0740\n003oT03IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WI\nf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WI\nf@3IfMT0o`3IfMT20=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@009@3IfMT00`000000fMWI0=WIf@0T0=WIf@030000003IfMT0fMWI00D0fMWI0P0000080=WI\nf@800000`03IfMT002@0fMWI00<000000=WIf@3IfMT09P3IfMT00`000000fMWI0=WIf@040=WIf@03\n0000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0_P3IfMT002<0fMWI00<000000=WIf@3IfMT0\n0`3IfMT2000000<0fMWI1`0000020=WIf@@0000000<0fMWI0000000000000`3IfMT200000080fMWI\n0`0000000`3IfMT00000000000030=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0\n0P3IfMT2000000@0fMWI00<000000=WIf@3IfMT0_P3IfMT002<0fMWI00<000000=WIf@3IfMT00P3I\nfMT010000000fMWI0=WIf@0000020=WIf@@000000P3IfMT010000000fMWI0=WIf@0000020=WIf@03\n0000003IfMT0000000T0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@030=WI\nf@050000003IfMT0fMWI0=WIf@0000000P3IfMT01@000000fMWI0=WIf@3IfMT000000<00fMWI000F\n0=WIf@P0003o1@3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00H0fMWI00@00000\n0=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@03000000T0fMWI00@000000=WIf@3IfMT00000\n103IfMT00`000000fMWI0=WIf@030=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000\nfMWI0=WIf@2n0=WIf@008`3IfMT010000000fMWI0=WIf@3IfMT5000000<0fMWI0`0000000`3IfMT0\n000000000002000000<0fMWI00@000000=WIf@0000000000203IfMT3000000D0fMWI00<000000=WI\nf@3IfMT00`3IfMT00`000000fMWI0=WIf@05000000<0fMWI00<000000=WIf@3IfMT0_P3IfMT002@0\nfMWI00D000000=WIf@3IfMT0fMWI0000000A0=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WI\nf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT0\n0`000000fMWI0=WIf@2n0=WIf@009@3IfMT00`000000fMWI0=WIf@0A0=WIf@8000002P3IfMT20000\n00D0fMWI00<000000=WIf@3IfMT01@3IfMT2000000P0fMWI0P0000300=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-24.3537`, -0.0901542`, 0.869108`, 0.00399094`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell[BoxData[TagBox[RowBox[List[RowBox[List["\[SkeletonIndicator]", "Graphics"]], "\[SkeletonIndicator]"]], False, Rule[Editable, False]]], "Output"]], Open]], Cell[CellGroupData[List[Cell["New Tank Model", "Subsection"], Cell["model TankApplicationDiscretePInew\n  PIdiscreteController piDiscrete;\n  TankL  tankn(area=1,flowVout=0.02);\n  FlowOut outFlow;\nequation\n  connect(tankn.qOut,outFlow.qOut);\n  connect(tankn.tInp,piDiscrete.cOut);\n  connect(tankn.tOut,piDiscrete.cInp);\n  piDiscrete.ref=0.5;\nend TankApplicationDiscretePInew;", "ModelicaInput"], Cell["", "Text"], Cell["simulate( TankApplicationDiscretePInew, stopTime=200 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(TankApplicationDiscretePInew\\) : 2004-2-4 10:47:33.4162087 : \\!\\({0.`, 200.`}\\) : 4003 data points : 1 events : 22 variables>\\n\\!\\({\\*TagBox[\\(outFlow . flowVOut\\), HoldForm], \\*TagBox[\\(outFlow . qOut . lflow\\), HoldForm], \\*TagBox[\\(piDiscrete . cInp . val\\), HoldForm], \\*TagBox[\\(piDiscrete . cOut . act\\), HoldForm], \\*TagBox[\\(piDiscrete . error\\), HoldForm], \\*TagBox[\\(piDiscrete . K\\), HoldForm], \\*TagBox[\\(piDiscrete . maxV\\), HoldForm], \\*TagBox[\\(piDiscrete . minV\\), HoldForm], \\*TagBox[\\(piDiscrete . outCtr\\), HoldForm], \\*TagBox[\\(piDiscrete . ref\\), HoldForm], \\*TagBox[\\(piDiscrete . T\\), HoldForm], \\*TagBox[\\(piDiscrete . Ts\\), HoldForm], \\*TagBox[\\(piDiscrete . x\\), HoldForm], \\*TagBox[\\(tankn . area\\), HoldForm], \\*TagBox[\\(tankn . flowGain\\), HoldForm], \\*TagBox[\\(tankn . flowVout\\), HoldForm], \\*TagBox[\\(tankn . h\\), HoldForm], \\*TagBox[\\(tankn . qIn . lflow\\), HoldForm], \\*TagBox[\\(tankn . qOut . lflow\\), HoldForm], \\*TagBox[\\(tankn . tInp . act\\), HoldForm], \\*TagBox[\\(tankn . tOut . val\\), HoldForm], \\*TagBox[SuperscriptBox[\\((tankn . h)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( tankn.h );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.0047619 0.0147151 1.037 [\n[.2619 .00222 -6 -9 ]\n[.2619 .00222 6 0 ]\n[.5 .00222 -9 -9 ]\n[.5 .00222 9 0 ]\n[.7381 .00222 -9 -9 ]\n[.7381 .00222 9 0 ]\n[.97619 .00222 -9 -9 ]\n[.97619 .00222 9 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .11842 -18 -4.5 ]\n[.01131 .11842 0 4.5 ]\n[.01131 .22212 -18 -4.5 ]\n[.01131 .22212 0 4.5 ]\n[.01131 .32582 -18 -4.5 ]\n[.01131 .32582 0 4.5 ]\n[.01131 .42952 -18 -4.5 ]\n[.01131 .42952 0 4.5 ]\n[.01131 .53322 -18 -4.5 ]\n[.01131 .53322 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.2619 .01472 m\n.2619 .02097 L\ns\n[(50)] .2619 .00222 0 1 Mshowa\n.5 .01472 m\n.5 .02097 L\ns\n[(100)] .5 .00222 0 1 Mshowa\n.7381 .01472 m\n.7381 .02097 L\ns\n[(150)] .7381 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(200)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.07143 .01472 m\n.07143 .01847 L\ns\n.11905 .01472 m\n.11905 .01847 L\ns\n.16667 .01472 m\n.16667 .01847 L\ns\n.21429 .01472 m\n.21429 .01847 L\ns\n.30952 .01472 m\n.30952 .01847 L\ns\n.35714 .01472 m\n.35714 .01847 L\ns\n.40476 .01472 m\n.40476 .01847 L\ns\n.45238 .01472 m\n.45238 .01847 L\ns\n.54762 .01472 m\n.54762 .01847 L\ns\n.59524 .01472 m\n.59524 .01847 L\ns\n.64286 .01472 m\n.64286 .01847 L\ns\n.69048 .01472 m\n.69048 .01847 L\ns\n.78571 .01472 m\n.78571 .01847 L\ns\n.83333 .01472 m\n.83333 .01847 L\ns\n.88095 .01472 m\n.88095 .01847 L\ns\n.92857 .01472 m\n.92857 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .11842 m\n.03006 .11842 L\ns\n[(0.1)] .01131 .11842 1 0 Mshowa\n.02381 .22212 m\n.03006 .22212 L\ns\n[(0.2)] .01131 .22212 1 0 Mshowa\n.02381 .32582 m\n.03006 .32582 L\ns\n[(0.3)] .01131 .32582 1 0 Mshowa\n.02381 .42952 m\n.03006 .42952 L\ns\n[(0.4)] .01131 .42952 1 0 Mshowa\n.02381 .53322 m\n.03006 .53322 L\ns\n[(0.5)] .01131 .53322 1 0 Mshowa\n.125 Mabswid\n.02381 .03546 m\n.02756 .03546 L\ns\n.02381 .0562 m\n.02756 .0562 L\ns\n.02381 .07694 m\n.02756 .07694 L\ns\n.02381 .09768 m\n.02756 .09768 L\ns\n.02381 .13916 m\n.02756 .13916 L\ns\n.02381 .1599 m\n.02756 .1599 L\ns\n.02381 .18064 m\n.02756 .18064 L\ns\n.02381 .20138 m\n.02756 .20138 L\ns\n.02381 .24286 m\n.02756 .24286 L\ns\n.02381 .2636 m\n.02756 .2636 L\ns\n.02381 .28434 m\n.02756 .28434 L\ns\n.02381 .30508 m\n.02756 .30508 L\ns\n.02381 .34656 m\n.02756 .34656 L\ns\n.02381 .3673 m\n.02756 .3673 L\ns\n.02381 .38804 m\n.02756 .38804 L\ns\n.02381 .40878 m\n.02756 .40878 L\ns\n.02381 .45026 m\n.02756 .45026 L\ns\n.02381 .471 m\n.02756 .471 L\ns\n.02381 .49174 m\n.02756 .49174 L\ns\n.02381 .51248 m\n.02756 .51248 L\ns\n.02381 .55396 m\n.02756 .55396 L\ns\n.02381 .5747 m\n.02756 .5747 L\ns\n.02381 .59544 m\n.02756 .59544 L\ns\n.02381 .61618 m\n.02756 .61618 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02429 .03546 L\n.02429 .03546 L\n.02476 .0562 L\n.02476 .0562 L\n.02524 .07694 L\n.02524 .07694 L\n.02571 .09768 L\n.02571 .09768 L\n.02619 .11842 L\n.02619 .11842 L\n.02667 .13916 L\n.02667 .13916 L\n.02714 .1599 L\n.02714 .1599 L\n.02762 .18064 L\n.02762 .18064 L\n.0281 .20138 L\n.0281 .20138 L\n.02857 .22212 L\n.02857 .22212 L\n.02905 .24286 L\n.02905 .24286 L\n.02952 .2636 L\n.02952 .2636 L\n.03 .28434 L\n.03 .28434 L\n.03048 .30508 L\n.03048 .30508 L\n.03095 .32582 L\n.03095 .32582 L\n.03143 .34656 L\n.03143 .34656 L\n.0319 .3673 L\n.0319 .3673 L\n.03238 .38804 L\n.03238 .38804 L\n.03286 .40878 L\n.03286 .40878 L\n.03333 .42952 L\n.03333 .42952 L\n.03381 .45026 L\n.03381 .45026 L\n.03429 .471 L\n.03429 .471 L\n.03476 .49174 L\n.03476 .49174 L\n.03524 .51248 L\n.03524 .51248 L\n.03571 .53322 L\nMistroke\n.03571 .53322 L\n.03619 .55396 L\n.03619 .55396 L\n.03667 .5747 L\n.03667 .5747 L\n.03714 .59544 L\n.03714 .59544 L\n.03762 .60332 L\n.03762 .60332 L\n.0381 .60332 L\n.0381 .60332 L\n.03857 .60332 L\n.03857 .60332 L\n.03905 .60332 L\n.03905 .60332 L\n.03952 .60332 L\n.03952 .60332 L\n.04 .60332 L\n.04 .60332 L\n.04048 .60332 L\n.04048 .60332 L\n.04095 .60332 L\n.04095 .60332 L\n.04143 .60332 L\n.04143 .60332 L\n.0419 .60332 L\n.0419 .60332 L\n.04238 .60332 L\n.04238 .60332 L\n.04286 .60332 L\n.04286 .60332 L\n.04333 .60332 L\n.04333 .60332 L\n.04381 .60332 L\n.04381 .60332 L\n.04429 .60332 L\n.04429 .60332 L\n.04476 .60332 L\n.04476 .60332 L\n.04524 .60332 L\n.04524 .60332 L\n.04571 .60332 L\n.04571 .60332 L\n.04619 .60332 L\n.04619 .60332 L\n.04667 .60332 L\n.04667 .60332 L\n.04714 .60332 L\n.04714 .60332 L\n.04762 .60332 L\nMistroke\n.04762 .60332 L\n.0481 .60332 L\n.0481 .60332 L\n.04857 .60332 L\n.04857 .60332 L\n.04905 .60332 L\n.04905 .60332 L\n.04952 .60332 L\n.04952 .60332 L\n.05 .60332 L\n.05 .60332 L\n.05048 .60332 L\n.05048 .60332 L\n.05095 .60332 L\n.05095 .60332 L\n.05143 .60332 L\n.05143 .60332 L\n.0519 .60332 L\n.0519 .60332 L\n.05238 .60332 L\n.05238 .60332 L\n.05286 .60332 L\n.05286 .60332 L\n.05333 .60332 L\n.05333 .60332 L\n.05381 .60332 L\n.05381 .60332 L\n.05429 .60332 L\n.05429 .60332 L\n.05476 .60332 L\n.05476 .60332 L\n.05524 .60332 L\n.05524 .60332 L\n.05571 .60332 L\n.05571 .60332 L\n.05619 .60332 L\n.05619 .60332 L\n.05667 .60332 L\n.05667 .60332 L\n.05714 .60332 L\n.05714 .60332 L\n.05762 .60332 L\n.05762 .60332 L\n.0581 .60332 L\n.0581 .60332 L\n.05857 .60332 L\n.05857 .60332 L\n.05905 .60332 L\n.05905 .60332 L\n.05952 .60332 L\nMistroke\n.05952 .60332 L\n.06 .60332 L\n.06 .60332 L\n.06048 .60332 L\n.06048 .60332 L\n.06095 .60332 L\n.06095 .60332 L\n.06143 .60332 L\n.06143 .60332 L\n.0619 .60332 L\n.0619 .60332 L\n.06238 .60332 L\n.06238 .60332 L\n.06286 .60332 L\n.06286 .60332 L\n.06333 .60332 L\n.06333 .60332 L\n.06381 .60332 L\n.06381 .60332 L\n.06429 .60332 L\n.06429 .60332 L\n.06476 .60332 L\n.06476 .60332 L\n.06524 .60332 L\n.06524 .60332 L\n.06571 .60332 L\n.06571 .60332 L\n.06619 .60332 L\n.06619 .60332 L\n.06667 .60332 L\n.06667 .60332 L\n.06714 .60332 L\n.06714 .60332 L\n.06762 .60332 L\n.06762 .60332 L\n.0681 .60332 L\n.0681 .60332 L\n.06857 .60332 L\n.06857 .60332 L\n.06905 .60332 L\n.06905 .60332 L\n.06952 .60332 L\n.06952 .60332 L\n.07 .60332 L\n.07 .60332 L\n.07048 .60332 L\n.07048 .60332 L\n.07095 .60332 L\n.07095 .60332 L\n.07143 .60332 L\nMistroke\n.07143 .60332 L\n.0719 .60332 L\n.0719 .60332 L\n.07238 .60332 L\n.07238 .60332 L\n.07286 .60332 L\n.07286 .60332 L\n.07333 .60332 L\n.07333 .60332 L\n.07381 .60332 L\n.07381 .60332 L\n.07429 .60332 L\n.07429 .60332 L\n.07476 .60332 L\n.07476 .60332 L\n.07524 .60332 L\n.07524 .60332 L\n.07571 .60332 L\n.07571 .60332 L\n.07619 .60332 L\n.07619 .60332 L\n.07667 .60332 L\n.07667 .60332 L\n.07714 .60332 L\n.07714 .60332 L\n.07762 .60332 L\n.07762 .60332 L\n.0781 .60332 L\n.0781 .60332 L\n.07857 .60332 L\n.07857 .60332 L\n.07905 .60332 L\n.07905 .60332 L\n.07952 .60332 L\n.07952 .60332 L\n.08 .60332 L\n.08 .60332 L\n.08048 .60332 L\n.08048 .60332 L\n.08095 .60332 L\n.08095 .60332 L\n.08143 .60332 L\n.08143 .60332 L\n.0819 .60332 L\n.0819 .60332 L\n.08238 .60332 L\n.08238 .60332 L\n.08286 .60332 L\n.08286 .60332 L\n.08333 .60332 L\nMistroke\n.08333 .60332 L\n.08381 .60332 L\n.08381 .60332 L\n.08429 .60332 L\n.08429 .60332 L\n.08476 .60332 L\n.08476 .60332 L\n.08524 .60332 L\n.08524 .60332 L\n.08571 .60332 L\n.08571 .60332 L\n.08619 .60332 L\n.08619 .60332 L\n.08667 .60332 L\n.08667 .60332 L\n.08714 .60332 L\n.08714 .60332 L\n.08762 .60332 L\n.08762 .60332 L\n.0881 .60332 L\n.0881 .60332 L\n.08857 .60332 L\n.08857 .60332 L\n.08905 .60332 L\n.08905 .60332 L\n.08952 .60332 L\n.08952 .60332 L\n.09 .60332 L\n.09 .60332 L\n.09048 .60332 L\n.09048 .60332 L\n.09095 .60332 L\n.09095 .60332 L\n.09143 .60332 L\n.09143 .60332 L\n.0919 .60332 L\n.0919 .60332 L\n.09238 .60332 L\n.09238 .60332 L\n.09286 .60332 L\n.09286 .60332 L\n.09333 .60332 L\n.09333 .60332 L\n.09381 .60332 L\n.09381 .60332 L\n.09429 .60332 L\n.09429 .60332 L\n.09476 .60332 L\n.09476 .60332 L\n.09524 .60332 L\nMistroke\n.09524 .60332 L\n.09571 .60332 L\n.09571 .60332 L\n.09619 .60332 L\n.09619 .60332 L\n.09667 .60332 L\n.09667 .60332 L\n.09714 .60332 L\n.09714 .60332 L\n.09762 .60332 L\n.09762 .60332 L\n.0981 .60332 L\n.0981 .60332 L\n.09857 .60332 L\n.09857 .60332 L\n.09905 .60332 L\n.09905 .60332 L\n.09952 .60332 L\n.09952 .60332 L\n.1 .60332 L\n.1 .60332 L\n.10048 .60332 L\n.10048 .60332 L\n.10095 .60332 L\n.10095 .60332 L\n.10143 .60332 L\n.10143 .60332 L\n.1019 .60332 L\n.1019 .60332 L\n.10238 .60332 L\n.10238 .60332 L\n.10286 .60332 L\n.10286 .60332 L\n.10333 .60332 L\n.10333 .60332 L\n.10381 .60332 L\n.10381 .60332 L\n.10429 .60332 L\n.10429 .60332 L\n.10476 .60332 L\n.10476 .60332 L\n.10524 .60332 L\n.10524 .60332 L\n.10571 .60332 L\n.10571 .60332 L\n.10619 .60332 L\n.10619 .60332 L\n.10667 .60332 L\n.10667 .60332 L\n.10714 .60332 L\nMistroke\n.10714 .60332 L\n.10762 .60332 L\n.10762 .60332 L\n.1081 .60332 L\n.1081 .60332 L\n.10857 .60332 L\n.10857 .60332 L\n.10905 .60332 L\n.10905 .60332 L\n.10952 .60332 L\n.10952 .60332 L\n.11 .60332 L\n.11 .60332 L\n.11048 .60332 L\n.11048 .60332 L\n.11095 .60332 L\n.11095 .60332 L\n.11143 .60332 L\n.11143 .60332 L\n.1119 .60332 L\n.1119 .60332 L\n.11238 .60332 L\n.11238 .60332 L\n.11286 .60332 L\n.11286 .60332 L\n.11333 .60332 L\n.11333 .60332 L\n.11381 .60332 L\n.11381 .60332 L\n.11429 .60332 L\n.11429 .60332 L\n.11476 .60332 L\n.11476 .60332 L\n.11524 .60332 L\n.11524 .60332 L\n.11571 .60332 L\n.11571 .60332 L\n.11619 .60332 L\n.11619 .60332 L\n.11667 .60332 L\n.11667 .60332 L\n.11714 .60332 L\n.11714 .60332 L\n.11762 .60332 L\n.11762 .60332 L\n.1181 .60332 L\n.1181 .60332 L\n.11857 .60332 L\n.11857 .60332 L\n.11905 .60332 L\nMistroke\n.11905 .60332 L\n.11952 .60332 L\n.11952 .60332 L\n.12 .60332 L\n.12 .60332 L\n.12048 .60332 L\n.12048 .60332 L\n.12095 .60332 L\n.12095 .60332 L\n.12143 .60332 L\n.12143 .60332 L\n.1219 .60332 L\n.1219 .60332 L\n.12238 .60332 L\n.12238 .60332 L\n.12286 .60332 L\n.12286 .60332 L\n.12333 .60332 L\n.12333 .60332 L\n.12381 .60332 L\n.12381 .60332 L\n.12429 .60332 L\n.12429 .60332 L\n.12476 .60332 L\n.12476 .60332 L\n.12524 .60332 L\n.12524 .60332 L\n.12571 .60332 L\n.12571 .60332 L\n.12619 .60332 L\n.12619 .60332 L\n.12667 .60332 L\n.12667 .60332 L\n.12714 .60332 L\n.12714 .60332 L\n.12762 .60332 L\n.12762 .60332 L\n.1281 .60332 L\n.1281 .60332 L\n.12857 .60332 L\n.12857 .60332 L\n.12905 .60332 L\n.12905 .60332 L\n.12952 .60332 L\n.12952 .60332 L\n.13 .60332 L\n.13 .60332 L\n.13048 .60332 L\n.13048 .60332 L\n.13095 .60332 L\nMistroke\n.13095 .60332 L\n.13143 .60332 L\n.13143 .60332 L\n.1319 .60332 L\n.1319 .60332 L\n.13238 .60332 L\n.13238 .60332 L\n.13286 .60332 L\n.13286 .60332 L\n.13333 .60332 L\n.13333 .60332 L\n.13381 .60332 L\n.13381 .60332 L\n.13429 .60332 L\n.13429 .60332 L\n.13476 .60332 L\n.13476 .60332 L\n.13524 .60332 L\n.13524 .60332 L\n.13571 .60332 L\n.13571 .60332 L\n.13619 .60332 L\n.13619 .60332 L\n.13667 .60332 L\n.13667 .60332 L\n.13714 .60332 L\n.13714 .60332 L\n.13762 .60332 L\n.13762 .60332 L\n.1381 .60332 L\n.1381 .60332 L\n.13857 .60332 L\n.13857 .60332 L\n.13905 .60332 L\n.13905 .60332 L\n.13952 .60332 L\n.13952 .60332 L\n.14 .60332 L\n.14 .60332 L\n.14048 .60332 L\n.14048 .60332 L\n.14095 .60332 L\n.14095 .60332 L\n.14143 .60332 L\n.14143 .60332 L\n.1419 .60332 L\n.1419 .60332 L\n.14238 .60332 L\n.14238 .60332 L\n.14286 .60332 L\nMistroke\n.14286 .60332 L\n.14333 .60332 L\n.14333 .60332 L\n.14381 .60332 L\n.14381 .60332 L\n.14429 .60332 L\n.14429 .60332 L\n.14476 .60332 L\n.14476 .60332 L\n.14524 .60332 L\n.14524 .60332 L\n.14571 .60332 L\n.14571 .60332 L\n.14619 .60332 L\n.14619 .60332 L\n.14667 .60332 L\n.14667 .60332 L\n.14714 .60332 L\n.14714 .60332 L\n.14762 .60332 L\n.14762 .60332 L\n.1481 .60332 L\n.1481 .60332 L\n.14857 .60332 L\n.14857 .60332 L\n.14905 .60332 L\n.14905 .60332 L\n.14952 .60332 L\n.14952 .60332 L\n.15 .60332 L\n.15 .60332 L\n.15048 .60332 L\n.15048 .60332 L\n.15095 .60332 L\n.15095 .60332 L\n.15143 .60332 L\n.15143 .60332 L\n.1519 .60332 L\n.1519 .60332 L\n.15238 .60332 L\n.15238 .60332 L\n.15286 .60332 L\n.15286 .60332 L\n.15333 .60332 L\n.15333 .60332 L\n.15381 .60332 L\n.15381 .60332 L\n.15429 .60332 L\n.15429 .60332 L\n.15476 .60332 L\nMistroke\n.15476 .60332 L\n.15524 .60332 L\n.15524 .60332 L\n.15571 .60332 L\n.15571 .60332 L\n.15619 .60332 L\n.15619 .60332 L\n.15667 .60332 L\n.15667 .60332 L\n.15714 .60332 L\n.15714 .60332 L\n.15762 .60332 L\n.15762 .60332 L\n.1581 .60332 L\n.1581 .60332 L\n.15857 .60332 L\n.15857 .60332 L\n.15905 .60332 L\n.15905 .60332 L\n.15952 .60332 L\n.15952 .60332 L\n.16 .60332 L\n.16 .60332 L\n.16048 .60332 L\n.16048 .60332 L\n.16095 .60332 L\n.16095 .60332 L\n.16143 .60332 L\n.16143 .60332 L\n.1619 .60332 L\n.1619 .60332 L\n.16238 .60332 L\n.16238 .60332 L\n.16286 .60332 L\n.16286 .60332 L\n.16333 .60332 L\n.16333 .60332 L\n.16381 .60332 L\n.16381 .60332 L\n.16429 .60332 L\n.16429 .60332 L\n.16476 .60332 L\n.16476 .60332 L\n.16524 .60332 L\n.16524 .60332 L\n.16571 .60332 L\n.16571 .60332 L\n.16619 .60332 L\n.16619 .60332 L\n.16667 .60332 L\nMistroke\n.16667 .60332 L\n.16714 .60332 L\n.16714 .60332 L\n.16762 .60332 L\n.16762 .60332 L\n.1681 .60332 L\n.1681 .60332 L\n.16857 .60332 L\n.16857 .60332 L\n.16905 .60332 L\n.16905 .60332 L\n.16952 .60332 L\n.16952 .60332 L\n.17 .60332 L\n.17 .60332 L\n.17048 .60332 L\n.17048 .60332 L\n.17095 .60332 L\n.17095 .60332 L\n.17143 .60332 L\n.17143 .60332 L\n.1719 .60332 L\n.1719 .60332 L\n.17238 .60332 L\n.17238 .60332 L\n.17286 .60332 L\n.17286 .60332 L\n.17333 .60332 L\n.17333 .60332 L\n.17381 .60332 L\n.17381 .60332 L\n.17429 .60332 L\n.17429 .60332 L\n.17476 .60332 L\n.17476 .60332 L\n.17524 .60332 L\n.17524 .60332 L\n.17571 .60332 L\n.17571 .60332 L\n.17619 .60332 L\n.17619 .60332 L\n.17667 .60332 L\n.17667 .60332 L\n.17714 .60332 L\n.17714 .60332 L\n.17762 .60332 L\n.17762 .60332 L\n.1781 .60332 L\n.1781 .60332 L\n.17857 .60332 L\nMistroke\n.17857 .60332 L\n.17905 .60332 L\n.17905 .60332 L\n.17952 .60332 L\n.17952 .60332 L\n.18 .60332 L\n.18 .60332 L\n.18048 .60332 L\n.18048 .60332 L\n.18095 .60332 L\n.18095 .60332 L\n.18143 .60332 L\n.18143 .60332 L\n.1819 .60332 L\n.1819 .60332 L\n.18238 .60332 L\n.18238 .60332 L\n.18286 .60332 L\n.18286 .60332 L\n.18333 .60332 L\n.18333 .60332 L\n.18381 .60332 L\n.18381 .60332 L\n.18429 .60332 L\n.18429 .60332 L\n.18476 .60332 L\n.18476 .60332 L\n.18524 .60332 L\n.18524 .60332 L\n.18571 .60332 L\n.18571 .60332 L\n.18619 .60332 L\n.18619 .60332 L\n.18667 .60332 L\n.18667 .60332 L\n.18714 .60332 L\n.18714 .60332 L\n.18762 .60332 L\n.18762 .60332 L\n.1881 .60332 L\n.1881 .60332 L\n.18857 .60332 L\n.18857 .60332 L\n.18905 .60332 L\n.18905 .60332 L\n.18952 .60332 L\n.18952 .60332 L\n.19 .60332 L\n.19 .60332 L\n.19048 .60332 L\nMistroke\n.19048 .60332 L\n.19095 .60332 L\n.19095 .60332 L\n.19143 .60332 L\n.19143 .60332 L\n.1919 .60332 L\n.1919 .60332 L\n.19238 .60332 L\n.19238 .60332 L\n.19286 .60332 L\n.19286 .60332 L\n.19333 .60332 L\n.19333 .60332 L\n.19381 .60332 L\n.19381 .60332 L\n.19429 .60332 L\n.19429 .60332 L\n.19476 .60332 L\n.19476 .60332 L\n.19524 .60332 L\n.19524 .60332 L\n.19571 .60332 L\n.19571 .60332 L\n.19619 .60332 L\n.19619 .60332 L\n.19667 .60332 L\n.19667 .60332 L\n.19714 .60332 L\n.19714 .60332 L\n.19762 .60332 L\n.19762 .60332 L\n.1981 .60332 L\n.1981 .60332 L\n.19857 .60332 L\n.19857 .60332 L\n.19905 .60332 L\n.19905 .60332 L\n.19952 .60332 L\n.19952 .60332 L\n.2 .60332 L\n.2 .60332 L\n.20048 .60332 L\n.20048 .60332 L\n.20095 .60332 L\n.20095 .60332 L\n.20143 .60332 L\n.20143 .60332 L\n.2019 .60332 L\n.2019 .60332 L\n.20238 .60332 L\nMistroke\n.20238 .60332 L\n.20286 .60332 L\n.20286 .60332 L\n.20333 .60332 L\n.20333 .60332 L\n.20381 .60332 L\n.20381 .60332 L\n.20429 .60332 L\n.20429 .60332 L\n.20476 .60332 L\n.20476 .60332 L\n.20524 .60332 L\n.20524 .60332 L\n.20571 .60332 L\n.20571 .60332 L\n.20619 .60332 L\n.20619 .60332 L\n.20667 .60332 L\n.20667 .60332 L\n.20714 .60332 L\n.20714 .60332 L\n.20762 .60332 L\n.20762 .60332 L\n.2081 .60332 L\n.2081 .60332 L\n.20857 .60332 L\n.20857 .60332 L\n.20905 .60332 L\n.20905 .60332 L\n.20952 .60332 L\n.20952 .60332 L\n.21 .60332 L\n.21 .60332 L\n.21048 .60332 L\n.21048 .60332 L\n.21095 .60332 L\n.21095 .60332 L\n.21143 .60332 L\n.21143 .60332 L\n.2119 .60332 L\n.2119 .60332 L\n.21238 .60332 L\n.21238 .60332 L\n.21286 .60332 L\n.21286 .60332 L\n.21333 .60332 L\n.21333 .60332 L\n.21381 .60332 L\n.21381 .60332 L\n.21429 .60332 L\nMistroke\n.21429 .60332 L\n.21476 .60332 L\n.21476 .60332 L\n.21524 .60332 L\n.21524 .60332 L\n.21571 .60332 L\n.21571 .60332 L\n.21619 .60332 L\n.21619 .60332 L\n.21667 .60332 L\n.21667 .60332 L\n.21714 .60332 L\n.21714 .60332 L\n.21762 .60332 L\n.21762 .60332 L\n.2181 .60332 L\n.2181 .60332 L\n.21857 .60332 L\n.21857 .60332 L\n.21905 .60332 L\n.21905 .60332 L\n.21952 .60332 L\n.21952 .60332 L\n.22 .60332 L\n.22 .60332 L\n.22048 .60332 L\n.22048 .60332 L\n.22095 .60332 L\n.22095 .60332 L\n.22143 .60332 L\n.22143 .60332 L\n.2219 .60332 L\n.2219 .60332 L\n.22238 .60332 L\n.22238 .60332 L\n.22286 .60332 L\n.22286 .60332 L\n.22333 .60332 L\n.22333 .60332 L\n.22381 .60332 L\n.22381 .60332 L\n.22429 .60332 L\n.22429 .60332 L\n.22476 .60332 L\n.22476 .60332 L\n.22524 .60332 L\n.22524 .60332 L\n.22571 .60332 L\n.22571 .60332 L\n.22619 .60332 L\nMistroke\n.22619 .60332 L\n.22667 .60332 L\n.22667 .60332 L\n.22714 .60332 L\n.22714 .60332 L\n.22762 .60332 L\n.22762 .60332 L\n.2281 .60332 L\n.2281 .60332 L\n.22857 .60332 L\n.22857 .60332 L\n.22905 .60332 L\n.22905 .60332 L\n.22952 .60332 L\n.22952 .60332 L\n.23 .60332 L\n.23 .60332 L\n.23048 .60332 L\n.23048 .60332 L\n.23095 .60332 L\n.23095 .60332 L\n.23143 .60332 L\n.23143 .60332 L\n.2319 .60332 L\n.2319 .60332 L\n.23238 .60332 L\n.23238 .60332 L\n.23286 .60332 L\n.23286 .60332 L\n.23333 .60332 L\n.23333 .60332 L\n.23381 .60332 L\n.23381 .60332 L\n.23429 .60332 L\n.23429 .60332 L\n.23476 .60332 L\n.23476 .60332 L\n.23524 .60332 L\n.23524 .60332 L\n.23571 .60332 L\n.23571 .60332 L\n.23619 .60332 L\n.23619 .60332 L\n.23667 .60332 L\n.23667 .60332 L\n.23714 .60332 L\n.23714 .60332 L\n.23762 .60332 L\n.23762 .60332 L\n.2381 .60332 L\nMistroke\n.2381 .60332 L\n.23857 .60332 L\n.23857 .60332 L\n.23905 .60332 L\n.23905 .60332 L\n.23952 .60332 L\n.23952 .60332 L\n.24 .60332 L\n.24 .60332 L\n.24048 .60332 L\n.24048 .60332 L\n.24095 .60332 L\n.24095 .60332 L\n.24143 .60332 L\n.24143 .60332 L\n.2419 .60332 L\n.2419 .60332 L\n.24238 .60332 L\n.24238 .60332 L\n.24286 .60332 L\n.24286 .60332 L\n.24333 .60332 L\n.24333 .60332 L\n.24381 .60332 L\n.24381 .60332 L\n.24429 .60332 L\n.24429 .60332 L\n.24476 .60332 L\n.24476 .60332 L\n.24524 .60332 L\n.24524 .60332 L\n.24571 .60332 L\n.24571 .60332 L\n.24619 .60332 L\n.24619 .60332 L\n.24667 .60332 L\n.24667 .60332 L\n.24714 .60332 L\n.24714 .60332 L\n.24762 .60332 L\n.24762 .60332 L\n.2481 .60332 L\n.2481 .60332 L\n.24857 .60332 L\n.24857 .60332 L\n.24905 .60332 L\n.24905 .60332 L\n.24952 .60332 L\n.24952 .60332 L\n.25 .60332 L\nMistroke\n.25 .60332 L\n.25048 .60332 L\n.25048 .60332 L\n.25095 .60332 L\n.25095 .60332 L\n.25143 .60332 L\n.25143 .60332 L\n.2519 .60332 L\n.2519 .60332 L\n.25238 .60332 L\n.25238 .60332 L\n.25286 .60332 L\n.25286 .60332 L\n.25333 .60332 L\n.25333 .60332 L\n.25381 .60332 L\n.25381 .60332 L\n.25429 .60332 L\n.25429 .60332 L\n.25476 .60332 L\n.25476 .60332 L\n.25524 .60332 L\n.25524 .60332 L\n.25571 .60332 L\n.25571 .60332 L\n.25619 .60332 L\n.25619 .60332 L\n.25667 .60332 L\n.25667 .60332 L\n.25714 .60332 L\n.25714 .60332 L\n.25762 .60332 L\n.25762 .60332 L\n.2581 .60332 L\n.2581 .60332 L\n.25857 .60332 L\n.25857 .60332 L\n.25905 .60332 L\n.25905 .60332 L\n.25952 .60332 L\n.25952 .60332 L\n.26 .60332 L\n.26 .60332 L\n.26048 .60332 L\n.26048 .60332 L\n.26095 .60332 L\n.26095 .60332 L\n.26143 .60332 L\n.26143 .60332 L\n.2619 .60332 L\nMistroke\n.2619 .60332 L\n.26238 .60332 L\n.26238 .60332 L\n.26286 .60332 L\n.26286 .60332 L\n.26333 .60332 L\n.26333 .60332 L\n.26381 .60332 L\n.26381 .60332 L\n.26429 .60332 L\n.26429 .60332 L\n.26476 .60332 L\n.26476 .60332 L\n.26524 .60332 L\n.26524 .60332 L\n.26571 .60332 L\n.26571 .60332 L\n.26619 .60332 L\n.26619 .60332 L\n.26667 .60332 L\n.26667 .60332 L\n.26714 .60332 L\n.26714 .60332 L\n.26762 .60332 L\n.26762 .60332 L\n.2681 .60332 L\n.2681 .60332 L\n.26857 .60332 L\n.26857 .60332 L\n.26905 .60332 L\n.26905 .60332 L\n.26952 .60332 L\n.26952 .60332 L\n.27 .60332 L\n.27 .60332 L\n.27048 .60332 L\n.27048 .60332 L\n.27095 .60332 L\n.27095 .60332 L\n.27143 .60332 L\n.27143 .60332 L\n.2719 .60332 L\n.2719 .60332 L\n.27238 .60332 L\n.27238 .60332 L\n.27286 .60332 L\n.27286 .60332 L\n.27333 .60332 L\n.27333 .60332 L\n.27381 .60332 L\nMistroke\n.27381 .60332 L\n.27429 .60332 L\n.27429 .60332 L\n.27476 .60332 L\n.27476 .60332 L\n.27524 .60332 L\n.27524 .60332 L\n.27571 .60332 L\n.27571 .60332 L\n.27619 .60332 L\n.27619 .60332 L\n.27667 .60332 L\n.27667 .60332 L\n.27714 .60332 L\n.27714 .60332 L\n.27762 .60332 L\n.27762 .60332 L\n.2781 .60332 L\n.2781 .60332 L\n.27857 .60332 L\n.27857 .60332 L\n.27905 .60332 L\n.27905 .60332 L\n.27952 .60332 L\n.27952 .60332 L\n.28 .60332 L\n.28 .60332 L\n.28048 .60332 L\n.28048 .60332 L\n.28095 .60332 L\n.28095 .60332 L\n.28143 .60332 L\n.28143 .60332 L\n.2819 .60332 L\n.2819 .60332 L\n.28238 .60332 L\n.28238 .60332 L\n.28286 .60332 L\n.28286 .60332 L\n.28333 .60332 L\n.28333 .60332 L\n.28381 .60332 L\n.28381 .60332 L\n.28429 .60332 L\n.28429 .60332 L\n.28476 .60332 L\n.28476 .60332 L\n.28524 .60332 L\n.28524 .60332 L\n.28571 .60332 L\nMistroke\n.28571 .60332 L\n.28619 .60332 L\n.28619 .60332 L\n.28667 .60332 L\n.28667 .60332 L\n.28714 .60332 L\n.28714 .60332 L\n.28762 .60332 L\n.28762 .60332 L\n.2881 .60332 L\n.2881 .60332 L\n.28857 .60332 L\n.28857 .60332 L\n.28905 .60332 L\n.28905 .60332 L\n.28952 .60332 L\n.28952 .60332 L\n.29 .60332 L\n.29 .60332 L\n.29048 .60332 L\n.29048 .60332 L\n.29095 .60332 L\n.29095 .60332 L\n.29143 .60332 L\n.29143 .60332 L\n.2919 .60332 L\n.2919 .60332 L\n.29238 .60332 L\n.29238 .60332 L\n.29286 .60332 L\n.29286 .60332 L\n.29333 .60332 L\n.29333 .60332 L\n.29381 .60332 L\n.29381 .60332 L\n.29429 .60332 L\n.29429 .60332 L\n.29476 .60332 L\n.29476 .60332 L\n.29524 .60332 L\n.29524 .60332 L\n.29571 .60332 L\n.29571 .60332 L\n.29619 .60332 L\n.29619 .60332 L\n.29667 .60332 L\n.29667 .60332 L\n.29714 .60332 L\n.29714 .60332 L\n.29762 .60332 L\nMistroke\n.29762 .60332 L\n.2981 .60332 L\n.2981 .60332 L\n.29857 .60332 L\n.29857 .60332 L\n.29905 .60332 L\n.29905 .60332 L\n.29952 .60332 L\n.29952 .60332 L\n.3 .60332 L\n.3 .60332 L\n.30048 .60332 L\n.30048 .60332 L\n.30095 .60332 L\n.30095 .60332 L\n.30143 .60332 L\n.30143 .60332 L\n.3019 .60332 L\n.3019 .60332 L\n.30238 .60332 L\n.30238 .60332 L\n.30286 .60332 L\n.30286 .60332 L\n.30333 .60332 L\n.30333 .60332 L\n.30381 .60332 L\n.30381 .60332 L\n.30429 .60332 L\n.30429 .60332 L\n.30476 .60332 L\n.30476 .60332 L\n.30524 .60332 L\n.30524 .60332 L\n.30571 .60332 L\n.30571 .60332 L\n.30619 .60332 L\n.30619 .60332 L\n.30667 .60332 L\n.30667 .60332 L\n.30714 .60332 L\n.30714 .60332 L\n.30762 .60332 L\n.30762 .60332 L\n.3081 .60332 L\n.3081 .60332 L\n.30857 .60332 L\n.30857 .60332 L\n.30905 .60332 L\n.30905 .60332 L\n.30952 .60332 L\nMistroke\n.30952 .60332 L\n.31 .60332 L\n.31 .60332 L\n.31048 .60332 L\n.31048 .60332 L\n.31095 .60332 L\n.31095 .60332 L\n.31143 .60332 L\n.31143 .60332 L\n.3119 .60332 L\n.3119 .60332 L\n.31238 .60332 L\n.31238 .60332 L\n.31286 .60332 L\n.31286 .60332 L\n.31333 .60332 L\n.31333 .60332 L\n.31381 .60332 L\n.31381 .60332 L\n.31429 .60332 L\n.31429 .60332 L\n.31476 .60332 L\n.31476 .60332 L\n.31524 .60332 L\n.31524 .60332 L\n.31571 .60332 L\n.31571 .60332 L\n.31619 .60332 L\n.31619 .60332 L\n.31667 .60332 L\n.31667 .60332 L\n.31714 .60332 L\n.31714 .60332 L\n.31762 .60332 L\n.31762 .60332 L\n.3181 .60332 L\n.3181 .60332 L\n.31857 .60332 L\n.31857 .60332 L\n.31905 .60332 L\n.31905 .60332 L\n.31952 .60332 L\n.31952 .60332 L\n.32 .60332 L\n.32 .60332 L\n.32048 .60332 L\n.32048 .60332 L\n.32095 .60332 L\n.32095 .60332 L\n.32143 .60332 L\nMistroke\n.32143 .60332 L\n.3219 .60332 L\n.3219 .60332 L\n.32238 .60332 L\n.32238 .60332 L\n.32286 .60332 L\n.32286 .60332 L\n.32333 .60332 L\n.32333 .60332 L\n.32381 .60332 L\n.32381 .60332 L\n.32429 .60332 L\n.32429 .60332 L\n.32476 .60332 L\n.32476 .60332 L\n.32524 .60332 L\n.32524 .60332 L\n.32571 .60332 L\n.32571 .60332 L\n.32619 .60332 L\n.32619 .60332 L\n.32667 .60332 L\n.32667 .60332 L\n.32714 .60332 L\n.32714 .60332 L\n.32762 .60332 L\n.32762 .60332 L\n.3281 .60332 L\n.3281 .60332 L\n.32857 .60332 L\n.32857 .60332 L\n.32905 .60332 L\n.32905 .60332 L\n.32952 .60332 L\n.32952 .60332 L\n.33 .60332 L\n.33 .60332 L\n.33048 .60332 L\n.33048 .60332 L\n.33095 .60332 L\n.33095 .60332 L\n.33143 .60332 L\n.33143 .60332 L\n.3319 .60332 L\n.3319 .60332 L\n.33238 .60332 L\n.33238 .60332 L\n.33286 .60332 L\n.33286 .60332 L\n.33333 .60332 L\nMistroke\n.33333 .60332 L\n.33381 .60332 L\n.33381 .60332 L\n.33429 .60332 L\n.33429 .60332 L\n.33476 .60332 L\n.33476 .60332 L\n.33524 .60332 L\n.33524 .60332 L\n.33571 .60332 L\n.33571 .60332 L\n.33619 .60332 L\n.33619 .60332 L\n.33667 .60332 L\n.33667 .60332 L\n.33714 .60332 L\n.33714 .60332 L\n.33762 .60332 L\n.33762 .60332 L\n.3381 .60332 L\n.3381 .60332 L\n.33857 .60332 L\n.33857 .60332 L\n.33905 .60332 L\n.33905 .60332 L\n.33952 .60332 L\n.33952 .60332 L\n.34 .60332 L\n.34 .60332 L\n.34048 .60332 L\n.34048 .60332 L\n.34095 .60332 L\n.34095 .60332 L\n.34143 .60332 L\n.34143 .60332 L\n.3419 .60332 L\n.3419 .60332 L\n.34238 .60332 L\n.34238 .60332 L\n.34286 .60332 L\n.34286 .60332 L\n.34333 .60332 L\n.34333 .60332 L\n.34381 .60332 L\n.34381 .60332 L\n.34429 .60332 L\n.34429 .60332 L\n.34476 .60332 L\n.34476 .60332 L\n.34524 .60332 L\nMistroke\n.34524 .60332 L\n.34571 .60332 L\n.34571 .60332 L\n.34619 .60332 L\n.34619 .60332 L\n.34667 .60332 L\n.34667 .60332 L\n.34714 .60332 L\n.34714 .60332 L\n.34762 .60332 L\n.34762 .60332 L\n.3481 .60332 L\n.3481 .60332 L\n.34857 .60332 L\n.34857 .60332 L\n.34905 .60332 L\n.34905 .60332 L\n.34952 .60332 L\n.34952 .60332 L\n.35 .60332 L\n.35 .60332 L\n.35048 .60332 L\n.35048 .60332 L\n.35095 .60332 L\n.35095 .60332 L\n.35143 .60332 L\n.35143 .60332 L\n.3519 .60332 L\n.3519 .60332 L\n.35238 .60332 L\n.35238 .60332 L\n.35286 .60332 L\n.35286 .60332 L\n.35333 .60332 L\n.35333 .60332 L\n.35381 .60332 L\n.35381 .60332 L\n.35429 .60332 L\n.35429 .60332 L\n.35476 .60332 L\n.35476 .60332 L\n.35524 .60332 L\n.35524 .60332 L\n.35571 .60332 L\n.35571 .60332 L\n.35619 .60332 L\n.35619 .60332 L\n.35667 .60332 L\n.35667 .60332 L\n.35714 .60332 L\nMistroke\n.35714 .60332 L\n.35762 .60332 L\n.35762 .60332 L\n.3581 .60332 L\n.3581 .60332 L\n.35857 .60332 L\n.35857 .60332 L\n.35905 .60332 L\n.35905 .60332 L\n.35952 .60332 L\n.35952 .60332 L\n.36 .60332 L\n.36 .60332 L\n.36048 .60332 L\n.36048 .60332 L\n.36095 .60332 L\n.36095 .60332 L\n.36143 .60332 L\n.36143 .60332 L\n.3619 .60332 L\n.3619 .60332 L\n.36238 .60332 L\n.36238 .60332 L\n.36286 .60332 L\n.36286 .60332 L\n.36333 .60332 L\n.36333 .60332 L\n.36381 .60332 L\n.36381 .60332 L\n.36429 .60332 L\n.36429 .60332 L\n.36476 .60332 L\n.36476 .60332 L\n.36524 .60332 L\n.36524 .60332 L\n.36571 .60332 L\n.36571 .60332 L\n.36619 .60332 L\n.36619 .60332 L\n.36667 .60332 L\n.36667 .60332 L\n.36714 .60332 L\n.36714 .60332 L\n.36762 .60332 L\n.36762 .60332 L\n.3681 .60332 L\n.3681 .60332 L\n.36857 .60332 L\n.36857 .60332 L\n.36905 .60332 L\nMistroke\n.36905 .60332 L\n.36952 .60332 L\n.36952 .60332 L\n.37 .60332 L\n.37 .60332 L\n.37048 .60332 L\n.37048 .60332 L\n.37095 .60332 L\n.37095 .60332 L\n.37143 .60332 L\n.37143 .60332 L\n.3719 .60332 L\n.3719 .60332 L\n.37238 .60332 L\n.37238 .60332 L\n.37286 .60332 L\n.37286 .60332 L\n.37333 .60332 L\n.37333 .60332 L\n.37381 .60332 L\n.37381 .60332 L\n.37429 .60332 L\n.37429 .60332 L\n.37476 .60332 L\n.37476 .60332 L\n.37524 .60332 L\n.37524 .60332 L\n.37571 .60332 L\n.37571 .60332 L\n.37619 .60332 L\n.37619 .60332 L\n.37667 .60332 L\n.37667 .60332 L\n.37714 .60332 L\n.37714 .60332 L\n.37762 .60332 L\n.37762 .60332 L\n.3781 .60332 L\n.3781 .60332 L\n.37857 .60332 L\n.37857 .60332 L\n.37905 .60332 L\n.37905 .60332 L\n.37952 .60332 L\n.37952 .60332 L\n.38 .60332 L\n.38 .60332 L\n.38048 .60332 L\n.38048 .60332 L\n.38095 .60332 L\nMistroke\n.38095 .60332 L\n.38143 .60332 L\n.38143 .60332 L\n.3819 .60332 L\n.3819 .60332 L\n.38238 .60332 L\n.38238 .60332 L\n.38286 .60332 L\n.38286 .60332 L\n.38333 .60332 L\n.38333 .60332 L\n.38381 .60332 L\n.38381 .60332 L\n.38429 .60332 L\n.38429 .60332 L\n.38476 .60332 L\n.38476 .60332 L\n.38524 .60332 L\n.38524 .60332 L\n.38571 .60332 L\n.38571 .60332 L\n.38619 .60332 L\n.38619 .60332 L\n.38667 .60332 L\n.38667 .60332 L\n.38714 .60332 L\n.38714 .60332 L\n.38762 .60332 L\n.38762 .60332 L\n.3881 .60332 L\n.3881 .60332 L\n.38857 .60332 L\n.38857 .60332 L\n.38905 .60332 L\n.38905 .60332 L\n.38952 .60332 L\n.38952 .60332 L\n.39 .60332 L\n.39 .60332 L\n.39048 .60332 L\n.39048 .60332 L\n.39095 .60332 L\n.39095 .60332 L\n.39143 .60332 L\n.39143 .60332 L\n.3919 .60332 L\n.3919 .60332 L\n.39238 .60332 L\n.39238 .60332 L\n.39286 .60332 L\nMistroke\n.39286 .60332 L\n.39333 .60332 L\n.39333 .60332 L\n.39381 .60332 L\n.39381 .60332 L\n.39429 .60332 L\n.39429 .60332 L\n.39476 .60332 L\n.39476 .60332 L\n.39524 .60332 L\n.39524 .60332 L\n.39571 .60332 L\n.39571 .60332 L\n.39619 .60332 L\n.39619 .60332 L\n.39667 .60332 L\n.39667 .60332 L\n.39714 .60332 L\n.39714 .60332 L\n.39762 .60332 L\n.39762 .60332 L\n.3981 .60332 L\n.3981 .60332 L\n.39857 .60332 L\n.39857 .60332 L\n.39905 .60332 L\n.39905 .60332 L\n.39952 .60332 L\n.39952 .60332 L\n.4 .60332 L\n.4 .60332 L\n.40048 .60332 L\n.40048 .60332 L\n.40095 .60332 L\n.40095 .60332 L\n.40143 .60332 L\n.40143 .60332 L\n.4019 .60332 L\n.4019 .60332 L\n.40238 .60332 L\n.40238 .60332 L\n.40286 .60332 L\n.40286 .60332 L\n.40333 .60332 L\n.40333 .60332 L\n.40381 .60332 L\n.40381 .60332 L\n.40429 .60332 L\n.40429 .60332 L\n.40476 .60332 L\nMistroke\n.40476 .60332 L\n.40524 .60332 L\n.40524 .60332 L\n.40571 .60332 L\n.40571 .60332 L\n.40619 .60332 L\n.40619 .60332 L\n.40667 .60332 L\n.40667 .60332 L\n.40714 .60332 L\n.40714 .60332 L\n.40762 .60332 L\n.40762 .60332 L\n.4081 .60332 L\n.4081 .60332 L\n.40857 .60332 L\n.40857 .60332 L\n.40905 .60332 L\n.40905 .60332 L\n.40952 .60332 L\n.40952 .60332 L\n.41 .60332 L\n.41 .60332 L\n.41048 .60332 L\n.41048 .60332 L\n.41095 .60332 L\n.41095 .60332 L\n.41143 .60332 L\n.41143 .60332 L\n.4119 .60332 L\n.4119 .60332 L\n.41238 .60332 L\n.41238 .60332 L\n.41286 .60332 L\n.41286 .60332 L\n.41333 .60332 L\n.41333 .60332 L\n.41381 .60332 L\n.41381 .60332 L\n.41429 .60332 L\n.41429 .60332 L\n.41476 .60332 L\n.41476 .60332 L\n.41524 .60332 L\n.41524 .60332 L\n.41571 .60332 L\n.41571 .60332 L\n.41619 .60332 L\n.41619 .60332 L\n.41667 .60332 L\nMistroke\n.41667 .60332 L\n.41714 .60332 L\n.41714 .60332 L\n.41762 .60332 L\n.41762 .60332 L\n.4181 .60332 L\n.4181 .60332 L\n.41857 .60332 L\n.41857 .60332 L\n.41905 .60332 L\n.41905 .60332 L\n.41952 .60332 L\n.41952 .60332 L\n.42 .60332 L\n.42 .60332 L\n.42048 .60332 L\n.42048 .60332 L\n.42095 .60332 L\n.42095 .60332 L\n.42143 .60332 L\n.42143 .60332 L\n.4219 .60332 L\n.4219 .60332 L\n.42238 .60332 L\n.42238 .60332 L\n.42286 .60332 L\n.42286 .60332 L\n.42333 .60332 L\n.42333 .60332 L\n.42381 .60332 L\n.42381 .60332 L\n.42429 .60332 L\n.42429 .60332 L\n.42476 .60332 L\n.42476 .60332 L\n.42524 .60332 L\n.42524 .60332 L\n.42571 .60332 L\n.42571 .60332 L\n.42619 .60332 L\n.42619 .60332 L\n.42667 .60332 L\n.42667 .60332 L\n.42714 .60332 L\n.42714 .60332 L\n.42762 .60332 L\n.42762 .60332 L\n.4281 .60332 L\n.4281 .60332 L\n.42857 .60332 L\nMistroke\n.42857 .60332 L\n.42905 .60332 L\n.42905 .60332 L\n.42952 .60332 L\n.42952 .60332 L\n.43 .60332 L\n.43 .60332 L\n.43048 .60332 L\n.43048 .60332 L\n.43095 .60332 L\n.43095 .60332 L\n.43143 .60332 L\n.43143 .60332 L\n.4319 .60332 L\n.4319 .60332 L\n.43238 .60332 L\n.43238 .60332 L\n.43286 .60332 L\n.43286 .60332 L\n.43333 .60332 L\n.43333 .60332 L\n.43381 .60332 L\n.43381 .60332 L\n.43429 .60332 L\n.43429 .60332 L\n.43476 .60332 L\n.43476 .60332 L\n.43524 .60332 L\n.43524 .60332 L\n.43571 .60332 L\n.43571 .60332 L\n.43619 .60332 L\n.43619 .60332 L\n.43667 .60332 L\n.43667 .60332 L\n.43714 .60332 L\n.43714 .60332 L\n.43762 .60332 L\n.43762 .60332 L\n.4381 .60332 L\n.4381 .60332 L\n.43857 .60332 L\n.43857 .60332 L\n.43905 .60332 L\n.43905 .60332 L\n.43952 .60332 L\n.43952 .60332 L\n.44 .60332 L\n.44 .60332 L\n.44048 .60332 L\nMistroke\n.44048 .60332 L\n.44095 .60332 L\n.44095 .60332 L\n.44143 .60332 L\n.44143 .60332 L\n.4419 .60332 L\n.4419 .60332 L\n.44238 .60332 L\n.44238 .60332 L\n.44286 .60332 L\n.44286 .60332 L\n.44333 .60332 L\n.44333 .60332 L\n.44381 .60332 L\n.44381 .60332 L\n.44429 .60332 L\n.44429 .60332 L\n.44476 .60332 L\n.44476 .60332 L\n.44524 .60332 L\n.44524 .60332 L\n.44571 .60332 L\n.44571 .60332 L\n.44619 .60332 L\n.44619 .60332 L\n.44667 .60332 L\n.44667 .60332 L\n.44714 .60332 L\n.44714 .60332 L\n.44762 .60332 L\n.44762 .60332 L\n.4481 .60332 L\n.4481 .60332 L\n.44857 .60332 L\n.44857 .60332 L\n.44905 .60332 L\n.44905 .60332 L\n.44952 .60332 L\n.44952 .60332 L\n.45 .60332 L\n.45 .60332 L\n.45048 .60332 L\n.45048 .60332 L\n.45095 .60332 L\n.45095 .60332 L\n.45143 .60332 L\n.45143 .60332 L\n.4519 .60332 L\n.4519 .60332 L\n.45238 .60332 L\nMistroke\n.45238 .60332 L\n.45286 .60332 L\n.45286 .60332 L\n.45333 .60332 L\n.45333 .60332 L\n.45381 .60332 L\n.45381 .60332 L\n.45429 .60332 L\n.45429 .60332 L\n.45476 .60332 L\n.45476 .60332 L\n.45524 .60332 L\n.45524 .60332 L\n.45571 .60332 L\n.45571 .60332 L\n.45619 .60332 L\n.45619 .60332 L\n.45667 .60332 L\n.45667 .60332 L\n.45714 .60332 L\n.45714 .60332 L\n.45762 .60332 L\n.45762 .60332 L\n.4581 .60332 L\n.4581 .60332 L\n.45857 .60332 L\n.45857 .60332 L\n.45905 .60332 L\n.45905 .60332 L\n.45952 .60332 L\n.45952 .60332 L\n.46 .60332 L\n.46 .60332 L\n.46048 .60332 L\n.46048 .60332 L\n.46095 .60332 L\n.46095 .60332 L\n.46143 .60332 L\n.46143 .60332 L\n.4619 .60332 L\n.4619 .60332 L\n.46238 .60332 L\n.46238 .60332 L\n.46286 .60332 L\n.46286 .60332 L\n.46333 .60332 L\n.46333 .60332 L\n.46381 .60332 L\n.46381 .60332 L\n.46429 .60332 L\nMistroke\n.46429 .60332 L\n.46476 .60332 L\n.46476 .60332 L\n.46524 .60332 L\n.46524 .60332 L\n.46571 .60332 L\n.46571 .60332 L\n.46619 .60332 L\n.46619 .60332 L\n.46667 .60332 L\n.46667 .60332 L\n.46714 .60332 L\n.46714 .60332 L\n.46762 .60332 L\n.46762 .60332 L\n.4681 .60332 L\n.4681 .60332 L\n.46857 .60332 L\n.46857 .60332 L\n.46905 .60332 L\n.46905 .60332 L\n.46952 .60332 L\n.46952 .60332 L\n.47 .60332 L\n.47 .60332 L\n.47048 .60332 L\n.47048 .60332 L\n.47095 .60332 L\n.47095 .60332 L\n.47143 .60332 L\n.47143 .60332 L\n.4719 .60332 L\n.4719 .60332 L\n.47238 .60332 L\n.47238 .60332 L\n.47286 .60332 L\n.47286 .60332 L\n.47333 .60332 L\n.47333 .60332 L\n.47381 .60332 L\n.47381 .60332 L\n.47429 .60332 L\n.47429 .60332 L\n.47476 .60332 L\n.47476 .60332 L\n.47524 .60332 L\n.47524 .60332 L\n.47571 .60332 L\n.47571 .60332 L\n.47619 .60332 L\nMistroke\n.47619 .60332 L\n.47667 .60332 L\n.47667 .60332 L\n.47714 .60332 L\n.47714 .60332 L\n.47762 .60332 L\n.47762 .60332 L\n.4781 .60332 L\n.4781 .60332 L\n.47857 .60332 L\n.47857 .60332 L\n.47905 .60332 L\n.47905 .60332 L\n.47952 .60332 L\n.47952 .60332 L\n.48 .60332 L\n.48 .60332 L\n.48048 .60332 L\n.48048 .60332 L\n.48095 .60332 L\n.48095 .60332 L\n.48143 .60332 L\n.48143 .60332 L\n.4819 .60332 L\n.4819 .60332 L\n.48238 .60332 L\n.48238 .60332 L\n.48286 .60332 L\n.48286 .60332 L\n.48333 .60332 L\n.48333 .60332 L\n.48381 .60332 L\n.48381 .60332 L\n.48429 .60332 L\n.48429 .60332 L\n.48476 .60332 L\n.48476 .60332 L\n.48524 .60332 L\n.48524 .60332 L\n.48571 .60332 L\n.48571 .60332 L\n.48619 .60332 L\n.48619 .60332 L\n.48667 .60332 L\n.48667 .60332 L\n.48714 .60332 L\n.48714 .60332 L\n.48762 .60332 L\n.48762 .60332 L\n.4881 .60332 L\nMistroke\n.4881 .60332 L\n.48857 .60332 L\n.48857 .60332 L\n.48905 .60332 L\n.48905 .60332 L\n.48952 .60332 L\n.48952 .60332 L\n.49 .60332 L\n.49 .60332 L\n.49048 .60332 L\n.49048 .60332 L\n.49095 .60332 L\n.49095 .60332 L\n.49143 .60332 L\n.49143 .60332 L\n.4919 .60332 L\n.4919 .60332 L\n.49238 .60332 L\n.49238 .60332 L\n.49286 .60332 L\n.49286 .60332 L\n.49333 .60332 L\n.49333 .60332 L\n.49381 .60332 L\n.49381 .60332 L\n.49429 .60332 L\n.49429 .60332 L\n.49476 .60332 L\n.49476 .60332 L\n.49524 .60332 L\n.49524 .60332 L\n.49571 .60332 L\n.49571 .60332 L\n.49619 .60332 L\n.49619 .60332 L\n.49667 .60332 L\n.49667 .60332 L\n.49714 .60332 L\n.49714 .60332 L\n.49762 .60332 L\n.49762 .60332 L\n.4981 .60332 L\n.4981 .60332 L\n.49857 .60332 L\n.49857 .60332 L\n.49905 .60332 L\n.49905 .60332 L\n.49952 .60332 L\n.49952 .60332 L\n.5 .60332 L\nMistroke\n.5 .60332 L\n.5 .60332 L\n.5 .60332 L\n.50048 .60228 L\n.50048 .60228 L\n.50095 .60124 L\n.50095 .60124 L\n.50143 .60021 L\n.50143 .60021 L\n.5019 .59917 L\n.5019 .59917 L\n.50238 .59813 L\n.50238 .59813 L\n.50286 .5971 L\n.50286 .5971 L\n.50333 .59606 L\n.50333 .59606 L\n.50381 .59502 L\n.50381 .59502 L\n.50429 .59399 L\n.50429 .59399 L\n.50476 .59295 L\n.50476 .59295 L\n.50524 .59191 L\n.50524 .59191 L\n.50571 .59087 L\n.50571 .59087 L\n.50619 .58984 L\n.50619 .58984 L\n.50667 .5888 L\n.50667 .5888 L\n.50714 .58776 L\n.50714 .58776 L\n.50762 .58673 L\n.50762 .58673 L\n.5081 .58569 L\n.5081 .58569 L\n.50857 .58465 L\n.50857 .58465 L\n.50905 .58362 L\n.50905 .58362 L\n.50952 .58258 L\n.50952 .58258 L\n.51 .58154 L\n.51 .58154 L\n.51048 .5805 L\n.51048 .5805 L\n.51095 .57947 L\n.51095 .57947 L\n.51143 .57843 L\nMistroke\n.51143 .57843 L\n.5119 .57739 L\n.5119 .57739 L\n.51238 .57636 L\n.51238 .57636 L\n.51286 .57532 L\n.51286 .57532 L\n.51333 .57428 L\n.51333 .57428 L\n.51381 .57325 L\n.51381 .57325 L\n.51429 .57221 L\n.51429 .57221 L\n.51476 .57117 L\n.51476 .57117 L\n.51524 .57013 L\n.51524 .57013 L\n.51571 .5691 L\n.51571 .5691 L\n.51619 .56806 L\n.51619 .56806 L\n.51667 .56702 L\n.51667 .56702 L\n.51714 .56599 L\n.51714 .56599 L\n.51762 .56495 L\n.51762 .56495 L\n.5181 .56391 L\n.5181 .56391 L\n.51857 .56288 L\n.51857 .56288 L\n.51905 .56184 L\n.51905 .56184 L\n.51952 .5608 L\n.51952 .5608 L\n.52 .55976 L\n.52 .55976 L\n.52048 .55873 L\n.52048 .55873 L\n.52095 .55769 L\n.52095 .55769 L\n.52143 .55665 L\n.52143 .55665 L\n.5219 .55562 L\n.5219 .55562 L\n.52238 .55458 L\n.52238 .55458 L\n.52286 .55354 L\n.52286 .55354 L\n.52333 .55251 L\nMistroke\n.52333 .55251 L\n.52381 .55147 L\n.52381 .55147 L\n.52429 .55043 L\n.52429 .55043 L\n.52476 .54939 L\n.52476 .54939 L\n.52524 .54836 L\n.52524 .54836 L\n.52571 .54732 L\n.52571 .54732 L\n.52619 .54628 L\n.52619 .54628 L\n.52667 .54525 L\n.52667 .54525 L\n.52714 .54421 L\n.52714 .54421 L\n.52762 .54317 L\n.52762 .54317 L\n.5281 .54214 L\n.5281 .54214 L\n.52857 .5411 L\n.52857 .5411 L\n.52905 .54006 L\n.52905 .54006 L\n.52952 .53902 L\n.52952 .53902 L\n.53 .53799 L\n.53 .53799 L\n.53048 .53695 L\n.53048 .53695 L\n.53095 .53591 L\n.53095 .53591 L\n.53143 .53488 L\n.53143 .53488 L\n.5319 .53384 L\n.5319 .53384 L\n.53238 .5328 L\n.53238 .5328 L\n.53286 .53177 L\n.53286 .53177 L\n.53333 .53073 L\n.53333 .53073 L\n.53381 .52969 L\n.53381 .52969 L\n.53429 .52865 L\n.53429 .52865 L\n.53476 .52762 L\n.53476 .52762 L\n.53524 .52658 L\nMistroke\n.53524 .52658 L\n.53571 .52554 L\n.53571 .52554 L\n.53619 .52451 L\n.53619 .52451 L\n.53667 .52347 L\n.53667 .52347 L\n.53714 .52243 L\n.53714 .52243 L\n.53762 .5214 L\n.53762 .5214 L\n.5381 .52036 L\n.5381 .52036 L\n.53857 .51932 L\n.53857 .51932 L\n.53905 .51828 L\n.53905 .51828 L\n.53952 .51725 L\n.53952 .51725 L\n.54 .51621 L\n.54 .51621 L\n.54048 .51517 L\n.54048 .51517 L\n.54095 .51414 L\n.54095 .51414 L\n.54143 .5131 L\n.54143 .5131 L\n.5419 .51206 L\n.5419 .51206 L\n.54238 .51103 L\n.54238 .51103 L\n.54286 .50999 L\n.54286 .50999 L\n.54333 .50895 L\n.54333 .50895 L\n.54381 .50791 L\n.54381 .50791 L\n.54429 .50688 L\n.54429 .50688 L\n.54476 .50584 L\n.54476 .50584 L\n.54524 .5048 L\n.54524 .5048 L\n.54571 .50377 L\n.54571 .50377 L\n.54619 .50273 L\n.54619 .50273 L\n.54667 .50169 L\n.54667 .50169 L\n.54714 .50066 L\nMistroke\n.54714 .50066 L\n.54762 .49962 L\n.54762 .49962 L\n.5481 .49858 L\n.5481 .49858 L\n.54857 .49754 L\n.54857 .49754 L\n.54905 .49651 L\n.54905 .49651 L\n.54952 .49547 L\n.54952 .49547 L\n.55 .49443 L\n.55 .49443 L\n.55048 .4934 L\n.55048 .4934 L\n.55095 .49236 L\n.55095 .49236 L\n.55143 .49132 L\n.55143 .49132 L\n.5519 .49029 L\n.5519 .49029 L\n.55238 .48925 L\n.55238 .48925 L\n.55286 .48821 L\n.55286 .48821 L\n.55333 .48717 L\n.55333 .48717 L\n.55381 .48614 L\n.55381 .48614 L\n.55429 .4851 L\n.55429 .4851 L\n.55476 .48406 L\n.55476 .48406 L\n.55524 .48303 L\n.55524 .48303 L\n.55571 .48199 L\n.55571 .48199 L\n.55619 .48095 L\n.55619 .48095 L\n.55667 .47992 L\n.55667 .47992 L\n.55714 .47888 L\n.55714 .47888 L\n.55762 .47784 L\n.55762 .47784 L\n.5581 .4768 L\n.5581 .4768 L\n.55857 .47577 L\n.55857 .47577 L\n.55905 .47473 L\nMistroke\n.55905 .47473 L\n.55952 .47369 L\n.55952 .47369 L\n.56 .47266 L\n.56 .47266 L\n.56048 .47162 L\n.56048 .47162 L\n.56095 .47058 L\n.56095 .47058 L\n.56143 .46955 L\n.56143 .46955 L\n.5619 .46851 L\n.5619 .46851 L\n.56238 .46747 L\n.56238 .46747 L\n.56286 .46643 L\n.56286 .46643 L\n.56333 .4654 L\n.56333 .4654 L\n.56381 .46436 L\n.56381 .46436 L\n.56429 .46332 L\n.56429 .46332 L\n.56476 .46229 L\n.56476 .46229 L\n.56524 .46125 L\n.56524 .46125 L\n.56571 .46021 L\n.56571 .46021 L\n.56619 .45918 L\n.56619 .45918 L\n.56667 .45814 L\n.56667 .45814 L\n.56714 .4571 L\n.56714 .4571 L\n.56762 .45606 L\n.56762 .45606 L\n.5681 .45503 L\n.5681 .45503 L\n.56857 .45399 L\n.56857 .45399 L\n.56905 .45295 L\n.56905 .45295 L\n.56952 .45192 L\n.56952 .45192 L\n.57 .45088 L\n.57 .45088 L\n.57048 .44984 L\n.57048 .44984 L\n.57095 .44881 L\nMistroke\n.57095 .44881 L\n.57143 .44777 L\n.57143 .44777 L\n.5719 .44673 L\n.5719 .44673 L\n.57238 .44569 L\n.57238 .44569 L\n.57286 .44466 L\n.57286 .44466 L\n.57333 .44362 L\n.57333 .44362 L\n.57381 .44258 L\n.57381 .44258 L\n.57429 .44155 L\n.57429 .44155 L\n.57476 .44051 L\n.57476 .44051 L\n.57524 .43947 L\n.57524 .43947 L\n.57571 .43844 L\n.57571 .43844 L\n.57619 .4374 L\n.57619 .4374 L\n.57667 .43636 L\n.57667 .43636 L\n.57714 .43532 L\n.57714 .43532 L\n.57762 .43429 L\n.57762 .43429 L\n.5781 .43325 L\n.5781 .43325 L\n.57857 .43221 L\n.57857 .43221 L\n.57905 .43118 L\n.57905 .43118 L\n.57952 .43014 L\n.57952 .43014 L\n.58 .4291 L\n.58 .4291 L\n.58048 .42807 L\n.58048 .42807 L\n.58095 .42703 L\n.58095 .42703 L\n.58143 .42599 L\n.58143 .42599 L\n.5819 .42495 L\n.5819 .42495 L\n.58238 .42392 L\n.58238 .42392 L\n.58286 .42288 L\nMistroke\n.58286 .42288 L\n.58333 .42184 L\n.58333 .42184 L\n.58381 .42081 L\n.58381 .42081 L\n.58429 .41977 L\n.58429 .41977 L\n.58476 .41873 L\n.58476 .41873 L\n.58524 .4177 L\n.58524 .4177 L\n.58571 .41666 L\n.58571 .41666 L\n.58619 .41562 L\n.58619 .41562 L\n.58667 .41458 L\n.58667 .41458 L\n.58714 .41355 L\n.58714 .41355 L\n.58762 .41251 L\n.58762 .41251 L\n.5881 .41147 L\n.5881 .41147 L\n.58857 .41044 L\n.58857 .41044 L\n.58905 .4094 L\n.58905 .4094 L\n.58952 .40836 L\n.58952 .40836 L\n.59 .40733 L\n.59 .40733 L\n.59048 .40629 L\n.59048 .40629 L\n.59095 .40525 L\n.59095 .40525 L\n.59143 .40421 L\n.59143 .40421 L\n.5919 .40318 L\n.5919 .40318 L\n.59238 .40214 L\n.59238 .40214 L\n.59286 .4011 L\n.59286 .4011 L\n.59333 .40007 L\n.59333 .40007 L\n.59381 .39903 L\n.59381 .39903 L\n.59429 .39799 L\n.59429 .39799 L\n.59476 .39695 L\nMistroke\n.59476 .39695 L\n.59524 .39592 L\n.59524 .39592 L\n.59571 .39488 L\n.59571 .39488 L\n.59619 .39384 L\n.59619 .39384 L\n.59667 .39281 L\n.59667 .39281 L\n.59714 .39177 L\n.59714 .39177 L\n.59762 .39073 L\n.59762 .39073 L\n.5981 .3897 L\n.5981 .3897 L\n.59857 .38866 L\n.59857 .38866 L\n.59905 .38762 L\n.59905 .38762 L\n.59952 .38658 L\n.59952 .38658 L\n.6 .38555 L\n.6 .38555 L\n.60048 .38451 L\n.60048 .38451 L\n.60095 .38347 L\n.60095 .38347 L\n.60143 .38244 L\n.60143 .38244 L\n.6019 .3814 L\n.6019 .3814 L\n.60238 .38036 L\n.60238 .38036 L\n.60286 .37933 L\n.60286 .37933 L\n.60333 .37829 L\n.60333 .37829 L\n.60381 .37725 L\n.60381 .37725 L\n.60429 .37621 L\n.60429 .37621 L\n.60476 .37518 L\n.60476 .37518 L\n.60524 .37414 L\n.60524 .37414 L\n.60571 .3731 L\n.60571 .3731 L\n.60619 .37207 L\n.60619 .37207 L\n.60667 .37103 L\nMistroke\n.60667 .37103 L\n.60714 .36999 L\n.60714 .36999 L\n.60762 .36896 L\n.60762 .36896 L\n.6081 .36792 L\n.6081 .36792 L\n.60857 .36688 L\n.60857 .36688 L\n.60905 .36584 L\n.60905 .36584 L\n.60952 .36481 L\n.60952 .36481 L\n.61 .36377 L\n.61 .36377 L\n.61048 .36273 L\n.61048 .36273 L\n.61095 .3617 L\n.61095 .3617 L\n.61143 .36066 L\n.61143 .36066 L\n.6119 .35962 L\n.6119 .35962 L\n.61238 .35859 L\n.61238 .35859 L\n.61286 .35755 L\n.61286 .35755 L\n.61333 .35651 L\n.61333 .35651 L\n.61381 .35547 L\n.61381 .35547 L\n.61429 .35444 L\n.61429 .35444 L\n.61476 .3534 L\n.61476 .3534 L\n.61524 .35236 L\n.61524 .35236 L\n.61571 .35133 L\n.61571 .35133 L\n.61619 .35029 L\n.61619 .35029 L\n.61667 .34925 L\n.61667 .34925 L\n.61714 .34822 L\n.61714 .34822 L\n.61762 .34718 L\n.61762 .34718 L\n.6181 .34614 L\n.6181 .34614 L\n.61857 .3451 L\nMistroke\n.61857 .3451 L\n.61905 .34407 L\n.61905 .34407 L\n.61952 .34303 L\n.61952 .34303 L\n.62 .34199 L\n.62 .34199 L\n.62048 .34096 L\n.62048 .34096 L\n.62095 .33992 L\n.62095 .33992 L\n.62143 .33888 L\n.62143 .33888 L\n.6219 .33785 L\n.6219 .33785 L\n.62238 .33681 L\n.62238 .33681 L\n.62286 .33577 L\n.62286 .33577 L\n.62333 .33473 L\n.62333 .33473 L\n.62381 .3337 L\n.62381 .3337 L\n.62429 .33266 L\n.62429 .33266 L\n.62476 .33162 L\n.62476 .33162 L\n.62524 .33059 L\n.62524 .33059 L\n.62571 .32955 L\n.62571 .32955 L\n.62619 .32851 L\n.62619 .32851 L\n.62667 .32748 L\n.62667 .32748 L\n.62714 .32644 L\n.62714 .32644 L\n.62762 .3254 L\n.62762 .3254 L\n.6281 .32436 L\n.6281 .32436 L\n.62857 .32333 L\n.62857 .32333 L\n.62905 .32229 L\n.62905 .32229 L\n.62952 .32125 L\n.62952 .32125 L\n.63 .32022 L\n.63 .32022 L\n.63048 .31918 L\nMistroke\n.63048 .31918 L\n.63095 .31814 L\n.63095 .31814 L\n.63143 .31711 L\n.63143 .31711 L\n.6319 .31607 L\n.6319 .31607 L\n.63238 .31503 L\n.63238 .31503 L\n.63286 .31399 L\n.63286 .31399 L\n.63333 .31296 L\n.63333 .31296 L\n.63381 .31192 L\n.63381 .31192 L\n.63429 .31088 L\n.63429 .31088 L\n.63476 .30985 L\n.63476 .30985 L\n.63524 .30881 L\n.63524 .30881 L\n.63571 .30777 L\n.63571 .30777 L\n.63619 .30674 L\n.63619 .30674 L\n.63667 .3057 L\n.63667 .3057 L\n.63714 .30466 L\n.63714 .30466 L\n.63762 .30362 L\n.63762 .30362 L\n.6381 .30259 L\n.6381 .30259 L\n.63857 .30155 L\n.63857 .30155 L\n.63905 .30051 L\n.63905 .30051 L\n.63952 .29948 L\n.63952 .29948 L\n.64 .29844 L\n.64 .29844 L\n.64048 .2974 L\n.64048 .2974 L\n.64095 .29637 L\n.64095 .29637 L\n.64143 .29533 L\n.64143 .29533 L\n.6419 .29429 L\n.6419 .29429 L\n.64238 .29325 L\nMistroke\n.64238 .29325 L\n.64286 .29222 L\n.64286 .29222 L\n.64333 .29118 L\n.64333 .29118 L\n.64381 .29014 L\n.64381 .29014 L\n.64429 .28911 L\n.64429 .28911 L\n.64476 .28807 L\n.64476 .28807 L\n.64524 .28703 L\n.64524 .28703 L\n.64571 .286 L\n.64571 .286 L\n.64619 .28496 L\n.64619 .28496 L\n.64667 .28392 L\n.64667 .28392 L\n.64714 .28288 L\n.64714 .28288 L\n.64762 .28185 L\n.64762 .28185 L\n.6481 .28081 L\n.6481 .28081 L\n.64857 .27977 L\n.64857 .27977 L\n.64905 .27874 L\n.64905 .27874 L\n.64952 .2777 L\n.64952 .2777 L\n.65 .27666 L\n.65 .27666 L\n.65048 .27563 L\n.65048 .27563 L\n.65095 .27459 L\n.65095 .27459 L\n.65143 .27355 L\n.65143 .27355 L\n.6519 .27251 L\n.6519 .27251 L\n.65238 .27148 L\n.65238 .27148 L\n.65286 .27044 L\n.65286 .27044 L\n.65333 .2694 L\n.65333 .2694 L\n.65381 .26837 L\n.65381 .26837 L\n.65429 .26733 L\nMistroke\n.65429 .26733 L\n.65476 .26629 L\n.65476 .26629 L\n.65524 .26526 L\n.65524 .26526 L\n.65571 .26422 L\n.65571 .26422 L\n.65619 .26318 L\n.65619 .26318 L\n.65667 .26214 L\n.65667 .26214 L\n.65714 .26111 L\n.65714 .26111 L\n.65762 .26007 L\n.65762 .26007 L\n.6581 .25903 L\n.6581 .25903 L\n.65857 .258 L\n.65857 .258 L\n.65905 .26345 L\n.65905 .26345 L\n.65952 .26339 L\n.65952 .26339 L\n.66 .26885 L\n.66 .26885 L\n.66048 .26868 L\n.66048 .26868 L\n.66095 .27414 L\n.66095 .27414 L\n.66143 .27386 L\n.66143 .27386 L\n.6619 .27933 L\n.6619 .27933 L\n.66238 .27894 L\n.66238 .27894 L\n.66286 .28441 L\n.66286 .28441 L\n.66333 .28391 L\n.66333 .28391 L\n.66381 .2894 L\n.66381 .2894 L\n.66429 .28879 L\n.66429 .28879 L\n.66476 .29429 L\n.66476 .29429 L\n.66524 .29357 L\n.66524 .29357 L\n.66571 .29908 L\n.66571 .29908 L\n.66619 .29825 L\nMistroke\n.66619 .29825 L\n.66667 .30378 L\n.66667 .30378 L\n.66714 .30284 L\n.66714 .30284 L\n.66762 .30839 L\n.66762 .30839 L\n.6681 .30735 L\n.6681 .30735 L\n.66857 .31289 L\n.66857 .31289 L\n.66905 .31186 L\n.66905 .31186 L\n.66952 .31722 L\n.66952 .31722 L\n.67 .31618 L\n.67 .31618 L\n.67048 .32155 L\n.67048 .32155 L\n.67095 .32052 L\n.67095 .32052 L\n.67143 .32571 L\n.67143 .32571 L\n.6719 .32467 L\n.6719 .32467 L\n.67238 .32987 L\n.67238 .32987 L\n.67286 .32884 L\n.67286 .32884 L\n.67333 .33386 L\n.67333 .33386 L\n.67381 .33282 L\n.67381 .33282 L\n.67429 .33787 L\n.67429 .33787 L\n.67476 .33683 L\n.67476 .33683 L\n.67524 .3417 L\n.67524 .3417 L\n.67571 .34066 L\n.67571 .34066 L\n.67619 .34555 L\n.67619 .34555 L\n.67667 .34451 L\n.67667 .34451 L\n.67714 .34923 L\n.67714 .34923 L\n.67762 .34819 L\n.67762 .34819 L\n.6781 .35293 L\nMistroke\n.6781 .35293 L\n.67857 .35189 L\n.67857 .35189 L\n.67905 .35646 L\n.67905 .35646 L\n.67952 .35543 L\n.67952 .35543 L\n.68 .36002 L\n.68 .36002 L\n.68048 .35898 L\n.68048 .35898 L\n.68095 .36341 L\n.68095 .36341 L\n.68143 .36237 L\n.68143 .36237 L\n.6819 .36683 L\n.6819 .36683 L\n.68238 .36579 L\n.68238 .36579 L\n.68286 .37009 L\n.68286 .37009 L\n.68333 .36905 L\n.68333 .36905 L\n.68381 .37337 L\n.68381 .37337 L\n.68429 .37233 L\n.68429 .37233 L\n.68476 .37651 L\n.68476 .37651 L\n.68524 .37547 L\n.68524 .37547 L\n.68571 .37966 L\n.68571 .37966 L\n.68619 .37862 L\n.68619 .37862 L\n.68667 .38267 L\n.68667 .38267 L\n.68714 .38163 L\n.68714 .38163 L\n.68762 .3857 L\n.68762 .3857 L\n.6881 .38466 L\n.6881 .38466 L\n.68857 .38859 L\n.68857 .38859 L\n.68905 .38756 L\n.68905 .38756 L\n.68952 .39151 L\n.68952 .39151 L\n.69 .39047 L\nMistroke\n.69 .39047 L\n.69048 .39428 L\n.69048 .39428 L\n.69095 .39325 L\n.69095 .39325 L\n.69143 .39708 L\n.69143 .39708 L\n.6919 .39604 L\n.6919 .39604 L\n.69238 .39975 L\n.69238 .39975 L\n.69286 .39871 L\n.69286 .39871 L\n.69333 .40244 L\n.69333 .40244 L\n.69381 .4014 L\n.69381 .4014 L\n.69429 .405 L\n.69429 .405 L\n.69476 .40397 L\n.69476 .40397 L\n.69524 .40759 L\n.69524 .40759 L\n.69571 .40655 L\n.69571 .40655 L\n.69619 .41005 L\n.69619 .41005 L\n.69667 .40901 L\n.69667 .40901 L\n.69714 .41253 L\n.69714 .41253 L\n.69762 .4115 L\n.69762 .4115 L\n.6981 .4149 L\n.6981 .4149 L\n.69857 .41386 L\n.69857 .41386 L\n.69905 .41729 L\n.69905 .41729 L\n.69952 .41625 L\n.69952 .41625 L\n.7 .41956 L\n.7 .41956 L\n.70048 .41852 L\n.70048 .41852 L\n.70095 .42185 L\n.70095 .42185 L\n.70143 .42082 L\n.70143 .42082 L\n.7019 .42403 L\nMistroke\n.7019 .42403 L\n.70238 .423 L\n.70238 .423 L\n.70286 .42624 L\n.70286 .42624 L\n.70333 .4252 L\n.70333 .4252 L\n.70381 .42834 L\n.70381 .42834 L\n.70429 .4273 L\n.70429 .4273 L\n.70476 .43045 L\n.70476 .43045 L\n.70524 .42942 L\n.70524 .42942 L\n.70571 .43247 L\n.70571 .43247 L\n.70619 .43143 L\n.70619 .43143 L\n.70667 .4345 L\n.70667 .4345 L\n.70714 .43347 L\n.70714 .43347 L\n.70762 .43644 L\n.70762 .43644 L\n.7081 .4354 L\n.7081 .4354 L\n.70857 .4384 L\n.70857 .4384 L\n.70905 .43736 L\n.70905 .43736 L\n.70952 .44025 L\n.70952 .44025 L\n.71 .43922 L\n.71 .43922 L\n.71048 .44213 L\n.71048 .44213 L\n.71095 .4411 L\n.71095 .4411 L\n.71143 .44392 L\n.71143 .44392 L\n.7119 .44288 L\n.7119 .44288 L\n.71238 .44573 L\n.71238 .44573 L\n.71286 .44469 L\n.71286 .44469 L\n.71333 .44744 L\n.71333 .44744 L\n.71381 .4464 L\nMistroke\n.71381 .4464 L\n.71429 .44918 L\n.71429 .44918 L\n.71476 .44814 L\n.71476 .44814 L\n.71524 .45082 L\n.71524 .45082 L\n.71571 .44979 L\n.71571 .44979 L\n.71619 .45249 L\n.71619 .45249 L\n.71667 .45145 L\n.71667 .45145 L\n.71714 .45407 L\n.71714 .45407 L\n.71762 .45304 L\n.71762 .45304 L\n.7181 .45568 L\n.7181 .45568 L\n.71857 .45464 L\n.71857 .45464 L\n.71905 .4572 L\n.71905 .4572 L\n.71952 .45616 L\n.71952 .45616 L\n.72 .45874 L\n.72 .45874 L\n.72048 .4577 L\n.72048 .4577 L\n.72095 .4602 L\n.72095 .4602 L\n.72143 .45916 L\n.72143 .45916 L\n.7219 .46168 L\n.7219 .46168 L\n.72238 .46064 L\n.72238 .46064 L\n.72286 .46308 L\n.72286 .46308 L\n.72333 .46204 L\n.72333 .46204 L\n.72381 .4645 L\n.72381 .4645 L\n.72429 .46347 L\n.72429 .46347 L\n.72476 .46585 L\n.72476 .46585 L\n.72524 .46481 L\n.72524 .46481 L\n.72571 .46722 L\nMistroke\n.72571 .46722 L\n.72619 .46618 L\n.72619 .46618 L\n.72667 .46851 L\n.72667 .46851 L\n.72714 .46748 L\n.72714 .46748 L\n.72762 .46983 L\n.72762 .46983 L\n.7281 .46879 L\n.7281 .46879 L\n.72857 .47107 L\n.72857 .47107 L\n.72905 .47003 L\n.72905 .47003 L\n.72952 .47233 L\n.72952 .47233 L\n.73 .4713 L\n.73 .4713 L\n.73048 .47353 L\n.73048 .47353 L\n.73095 .47249 L\n.73095 .47249 L\n.73143 .47474 L\n.73143 .47474 L\n.7319 .4737 L\n.7319 .4737 L\n.73238 .47589 L\n.73238 .47589 L\n.73286 .47485 L\n.73286 .47485 L\n.73333 .47705 L\n.73333 .47705 L\n.73381 .47602 L\n.73381 .47602 L\n.73429 .47815 L\n.73429 .47815 L\n.73476 .47712 L\n.73476 .47712 L\n.73524 .47928 L\n.73524 .47928 L\n.73571 .47824 L\n.73571 .47824 L\n.73619 .48033 L\n.73619 .48033 L\n.73667 .4793 L\n.73667 .4793 L\n.73714 .48141 L\n.73714 .48141 L\n.73762 .48037 L\nMistroke\n.73762 .48037 L\n.7381 .48243 L\n.7381 .48243 L\n.73857 .48139 L\n.73857 .48139 L\n.73905 .48346 L\n.73905 .48346 L\n.73952 .48243 L\n.73952 .48243 L\n.74 .48444 L\n.74 .48444 L\n.74048 .4834 L\n.74048 .4834 L\n.74095 .48543 L\n.74095 .48543 L\n.74143 .4844 L\n.74143 .4844 L\n.7419 .48637 L\n.7419 .48637 L\n.74238 .48533 L\n.74238 .48533 L\n.74286 .48733 L\n.74286 .48733 L\n.74333 .48629 L\n.74333 .48629 L\n.74381 .48823 L\n.74381 .48823 L\n.74429 .48719 L\n.74429 .48719 L\n.74476 .48915 L\n.74476 .48915 L\n.74524 .48811 L\n.74524 .48811 L\n.74571 .49001 L\n.74571 .49001 L\n.74619 .48898 L\n.74619 .48898 L\n.74667 .4909 L\n.74667 .4909 L\n.74714 .48986 L\n.74714 .48986 L\n.74762 .49173 L\n.74762 .49173 L\n.7481 .49069 L\n.7481 .49069 L\n.74857 .49258 L\n.74857 .49258 L\n.74905 .49154 L\n.74905 .49154 L\n.74952 .49337 L\nMistroke\n.74952 .49337 L\n.75 .49234 L\n.75 .49234 L\n.75048 .49419 L\n.75048 .49419 L\n.75095 .49315 L\n.75095 .49315 L\n.75143 .49496 L\n.75143 .49496 L\n.7519 .49392 L\n.7519 .49392 L\n.75238 .49574 L\n.75238 .49574 L\n.75286 .4947 L\n.75286 .4947 L\n.75333 .49648 L\n.75333 .49648 L\n.75381 .49544 L\n.75381 .49544 L\n.75429 .49723 L\n.75429 .49723 L\n.75476 .49619 L\n.75476 .49619 L\n.75524 .49794 L\n.75524 .49794 L\n.75571 .4969 L\n.75571 .4969 L\n.75619 .49866 L\n.75619 .49866 L\n.75667 .49763 L\n.75667 .49763 L\n.75714 .49934 L\n.75714 .49934 L\n.75762 .4983 L\n.75762 .4983 L\n.7581 .50004 L\n.7581 .50004 L\n.75857 .499 L\n.75857 .499 L\n.75905 .50069 L\n.75905 .50069 L\n.75952 .49965 L\n.75952 .49965 L\n.76 .50136 L\n.76 .50136 L\n.76048 .50032 L\n.76048 .50032 L\n.76095 .50198 L\n.76095 .50198 L\n.76143 .50095 L\nMistroke\n.76143 .50095 L\n.7619 .50263 L\n.7619 .50263 L\n.76238 .50159 L\n.76238 .50159 L\n.76286 .50323 L\n.76286 .50323 L\n.76333 .50219 L\n.76333 .50219 L\n.76381 .50385 L\n.76381 .50385 L\n.76429 .50281 L\n.76429 .50281 L\n.76476 .50442 L\n.76476 .50442 L\n.76524 .50339 L\n.76524 .50339 L\n.76571 .50502 L\n.76571 .50502 L\n.76619 .50398 L\n.76619 .50398 L\n.76667 .50557 L\n.76667 .50557 L\n.76714 .50454 L\n.76714 .50454 L\n.76762 .50615 L\n.76762 .50615 L\n.7681 .50511 L\n.7681 .50511 L\n.76857 .50668 L\n.76857 .50668 L\n.76905 .50564 L\n.76905 .50564 L\n.76952 .50723 L\n.76952 .50723 L\n.77 .50619 L\n.77 .50619 L\n.77048 .50774 L\n.77048 .50774 L\n.77095 .5067 L\n.77095 .5067 L\n.77143 .50827 L\n.77143 .50827 L\n.7719 .50723 L\n.7719 .50723 L\n.77238 .50876 L\n.77238 .50876 L\n.77286 .50772 L\n.77286 .50772 L\n.77333 .50927 L\nMistroke\n.77333 .50927 L\n.77381 .50823 L\n.77381 .50823 L\n.77429 .50974 L\n.77429 .50974 L\n.77476 .5087 L\n.77476 .5087 L\n.77524 .51023 L\n.77524 .51023 L\n.77571 .50919 L\n.77571 .50919 L\n.77619 .51068 L\n.77619 .51068 L\n.77667 .50964 L\n.77667 .50964 L\n.77714 .51115 L\n.77714 .51115 L\n.77762 .51011 L\n.77762 .51011 L\n.7781 .51158 L\n.7781 .51158 L\n.77857 .51054 L\n.77857 .51054 L\n.77905 .51203 L\n.77905 .51203 L\n.77952 .511 L\n.77952 .511 L\n.78 .51245 L\n.78 .51245 L\n.78048 .51141 L\n.78048 .51141 L\n.78095 .51289 L\n.78095 .51289 L\n.78143 .51185 L\n.78143 .51185 L\n.7819 .51328 L\n.7819 .51328 L\n.78238 .51225 L\n.78238 .51225 L\n.78286 .5137 L\n.78286 .5137 L\n.78333 .51267 L\n.78333 .51267 L\n.78381 .51409 L\n.78381 .51409 L\n.78429 .51305 L\n.78429 .51305 L\n.78476 .51449 L\n.78476 .51449 L\n.78524 .51345 L\nMistroke\n.78524 .51345 L\n.78571 .51486 L\n.78571 .51486 L\n.78619 .51382 L\n.78619 .51382 L\n.78667 .51524 L\n.78667 .51524 L\n.78714 .51421 L\n.78714 .51421 L\n.78762 .5156 L\n.78762 .5156 L\n.7881 .51456 L\n.7881 .51456 L\n.78857 .51597 L\n.78857 .51597 L\n.78905 .51493 L\n.78905 .51493 L\n.78952 .51631 L\n.78952 .51631 L\n.79 .51527 L\n.79 .51527 L\n.79048 .51667 L\n.79048 .51667 L\n.79095 .51563 L\n.79095 .51563 L\n.79143 .51699 L\n.79143 .51699 L\n.7919 .51595 L\n.7919 .51595 L\n.79238 .51734 L\n.79238 .51734 L\n.79286 .5163 L\n.79286 .5163 L\n.79333 .51765 L\n.79333 .51765 L\n.79381 .51661 L\n.79381 .51661 L\n.79429 .51798 L\n.79429 .51798 L\n.79476 .51694 L\n.79476 .51694 L\n.79524 .51828 L\n.79524 .51828 L\n.79571 .51724 L\n.79571 .51724 L\n.79619 .5186 L\n.79619 .5186 L\n.79667 .51756 L\n.79667 .51756 L\n.79714 .51888 L\nMistroke\n.79714 .51888 L\n.79762 .51785 L\n.79762 .51785 L\n.7981 .51919 L\n.7981 .51919 L\n.79857 .51815 L\n.79857 .51815 L\n.79905 .51947 L\n.79905 .51947 L\n.79952 .51843 L\n.79952 .51843 L\n.8 .51976 L\n.8 .51976 L\n.80048 .51872 L\n.80048 .51872 L\n.80095 .52002 L\n.80095 .52002 L\n.80143 .51899 L\n.80143 .51899 L\n.8019 .52031 L\n.8019 .52031 L\n.80238 .51927 L\n.80238 .51927 L\n.80286 .52056 L\n.80286 .52056 L\n.80333 .51952 L\n.80333 .51952 L\n.80381 .52084 L\n.80381 .52084 L\n.80429 .5198 L\n.80429 .5198 L\n.80476 .52108 L\n.80476 .52108 L\n.80524 .52004 L\n.80524 .52004 L\n.80571 .52134 L\n.80571 .52134 L\n.80619 .5203 L\n.80619 .5203 L\n.80667 .52157 L\n.80667 .52157 L\n.80714 .52054 L\n.80714 .52054 L\n.80762 .52183 L\n.80762 .52183 L\n.8081 .52079 L\n.8081 .52079 L\n.80857 .52205 L\n.80857 .52205 L\n.80905 .52101 L\nMistroke\n.80905 .52101 L\n.80952 .52229 L\n.80952 .52229 L\n.81 .52126 L\n.81 .52126 L\n.81048 .52251 L\n.81048 .52251 L\n.81095 .52147 L\n.81095 .52147 L\n.81143 .52274 L\n.81143 .52274 L\n.8119 .52171 L\n.8119 .52171 L\n.81238 .52295 L\n.81238 .52295 L\n.81286 .52191 L\n.81286 .52191 L\n.81333 .52317 L\n.81333 .52317 L\n.81381 .52214 L\n.81381 .52214 L\n.81429 .52337 L\n.81429 .52337 L\n.81476 .52233 L\n.81476 .52233 L\n.81524 .52359 L\n.81524 .52359 L\n.81571 .52255 L\n.81571 .52255 L\n.81619 .52378 L\n.81619 .52378 L\n.81667 .52274 L\n.81667 .52274 L\n.81714 .52399 L\n.81714 .52399 L\n.81762 .52295 L\n.81762 .52295 L\n.8181 .52417 L\n.8181 .52417 L\n.81857 .52313 L\n.81857 .52313 L\n.81905 .52437 L\n.81905 .52437 L\n.81952 .52333 L\n.81952 .52333 L\n.82 .52454 L\n.82 .52454 L\n.82048 .52351 L\n.82048 .52351 L\n.82095 .52474 L\nMistroke\n.82095 .52474 L\n.82143 .5237 L\n.82143 .5237 L\n.8219 .5249 L\n.8219 .5249 L\n.82238 .52387 L\n.82238 .52387 L\n.82286 .52509 L\n.82286 .52509 L\n.82333 .52405 L\n.82333 .52405 L\n.82381 .52525 L\n.82381 .52525 L\n.82429 .52421 L\n.82429 .52421 L\n.82476 .52543 L\n.82476 .52543 L\n.82524 .52439 L\n.82524 .52439 L\n.82571 .52558 L\n.82571 .52558 L\n.82619 .52454 L\n.82619 .52454 L\n.82667 .52576 L\n.82667 .52576 L\n.82714 .52472 L\n.82714 .52472 L\n.82762 .5259 L\n.82762 .5259 L\n.8281 .52486 L\n.8281 .52486 L\n.82857 .52607 L\n.82857 .52607 L\n.82905 .52503 L\n.82905 .52503 L\n.82952 .52621 L\n.82952 .52621 L\n.83 .52517 L\n.83 .52517 L\n.83048 .52637 L\n.83048 .52637 L\n.83095 .52533 L\n.83095 .52533 L\n.83143 .5265 L\n.83143 .5265 L\n.8319 .52547 L\n.8319 .52547 L\n.83238 .52666 L\n.83238 .52666 L\n.83286 .52562 L\nMistroke\n.83286 .52562 L\n.83333 .52679 L\n.83333 .52679 L\n.83381 .52575 L\n.83381 .52575 L\n.83429 .52694 L\n.83429 .52694 L\n.83476 .5259 L\n.83476 .5259 L\n.83524 .52706 L\n.83524 .52706 L\n.83571 .52602 L\n.83571 .52602 L\n.83619 .5272 L\n.83619 .5272 L\n.83667 .52617 L\n.83667 .52617 L\n.83714 .52732 L\n.83714 .52732 L\n.83762 .52628 L\n.83762 .52628 L\n.8381 .52746 L\n.8381 .52746 L\n.83857 .52642 L\n.83857 .52642 L\n.83905 .52757 L\n.83905 .52757 L\n.83952 .52654 L\n.83952 .52654 L\n.84 .52771 L\n.84 .52771 L\n.84048 .52667 L\n.84048 .52667 L\n.84095 .52781 L\n.84095 .52781 L\n.84143 .52678 L\n.84143 .52678 L\n.8419 .52794 L\n.8419 .52794 L\n.84238 .52691 L\n.84238 .52691 L\n.84286 .52805 L\n.84286 .52805 L\n.84333 .52701 L\n.84333 .52701 L\n.84381 .52817 L\n.84381 .52817 L\n.84429 .52713 L\n.84429 .52713 L\n.84476 .52827 L\nMistroke\n.84476 .52827 L\n.84524 .52723 L\n.84524 .52723 L\n.84571 .52839 L\n.84571 .52839 L\n.84619 .52735 L\n.84619 .52735 L\n.84667 .52848 L\n.84667 .52848 L\n.84714 .52745 L\n.84714 .52745 L\n.84762 .5286 L\n.84762 .5286 L\n.8481 .52756 L\n.8481 .52756 L\n.84857 .52869 L\n.84857 .52869 L\n.84905 .52765 L\n.84905 .52765 L\n.84952 .5288 L\n.84952 .5288 L\n.85 .52776 L\n.85 .52776 L\n.85048 .52889 L\n.85048 .52889 L\n.85095 .52785 L\n.85095 .52785 L\n.85143 .52899 L\n.85143 .52899 L\n.8519 .52796 L\n.8519 .52796 L\n.85238 .52908 L\n.85238 .52908 L\n.85286 .52804 L\n.85286 .52804 L\n.85333 .52918 L\n.85333 .52918 L\n.85381 .52814 L\n.85381 .52814 L\n.85429 .52926 L\n.85429 .52926 L\n.85476 .52822 L\n.85476 .52822 L\n.85524 .52936 L\n.85524 .52936 L\n.85571 .52832 L\n.85571 .52832 L\n.85619 .52943 L\n.85619 .52943 L\n.85667 .5284 L\nMistroke\n.85667 .5284 L\n.85714 .52953 L\n.85714 .52953 L\n.85762 .52849 L\n.85762 .52849 L\n.8581 .5296 L\n.8581 .5296 L\n.85857 .52857 L\n.85857 .52857 L\n.85905 .52969 L\n.85905 .52969 L\n.85952 .52866 L\n.85952 .52866 L\n.86 .52976 L\n.86 .52976 L\n.86048 .52873 L\n.86048 .52873 L\n.86095 .52985 L\n.86095 .52985 L\n.86143 .52882 L\n.86143 .52882 L\n.8619 .52992 L\n.8619 .52992 L\n.86238 .52888 L\n.86238 .52888 L\n.86286 .53001 L\n.86286 .53001 L\n.86333 .52897 L\n.86333 .52897 L\n.86381 .53007 L\n.86381 .53007 L\n.86429 .52903 L\n.86429 .52903 L\n.86476 .53015 L\n.86476 .53015 L\n.86524 .52912 L\n.86524 .52912 L\n.86571 .53021 L\n.86571 .53021 L\n.86619 .52918 L\n.86619 .52918 L\n.86667 .53029 L\n.86667 .53029 L\n.86714 .52926 L\n.86714 .52926 L\n.86762 .53035 L\n.86762 .53035 L\n.8681 .52931 L\n.8681 .52931 L\n.86857 .53043 L\nMistroke\n.86857 .53043 L\n.86905 .52939 L\n.86905 .52939 L\n.86952 .53048 L\n.86952 .53048 L\n.87 .52945 L\n.87 .52945 L\n.87048 .53056 L\n.87048 .53056 L\n.87095 .52952 L\n.87095 .52952 L\n.87143 .53061 L\n.87143 .53061 L\n.8719 .52957 L\n.8719 .52957 L\n.87238 .53068 L\n.87238 .53068 L\n.87286 .52965 L\n.87286 .52965 L\n.87333 .53073 L\n.87333 .53073 L\n.87381 .5297 L\n.87381 .5297 L\n.87429 .5308 L\n.87429 .5308 L\n.87476 .52977 L\n.87476 .52977 L\n.87524 .53085 L\n.87524 .53085 L\n.87571 .52981 L\n.87571 .52981 L\n.87619 .53092 L\n.87619 .53092 L\n.87667 .52988 L\n.87667 .52988 L\n.87714 .53096 L\n.87714 .53096 L\n.87762 .52993 L\n.87762 .52993 L\n.8781 .53103 L\n.8781 .53103 L\n.87857 .52999 L\n.87857 .52999 L\n.87905 .53107 L\n.87905 .53107 L\n.87952 .53003 L\n.87952 .53003 L\n.88 .53114 L\n.88 .53114 L\n.88048 .5301 L\nMistroke\n.88048 .5301 L\n.88095 .53118 L\n.88095 .53118 L\n.88143 .53014 L\n.88143 .53014 L\n.8819 .53124 L\n.8819 .53124 L\n.88238 .5302 L\n.88238 .5302 L\n.88286 .53128 L\n.88286 .53128 L\n.88333 .53024 L\n.88333 .53024 L\n.88381 .53134 L\n.88381 .53134 L\n.88429 .5303 L\n.88429 .5303 L\n.88476 .53137 L\n.88476 .53137 L\n.88524 .53034 L\n.88524 .53034 L\n.88571 .53143 L\n.88571 .53143 L\n.88619 .53039 L\n.88619 .53039 L\n.88667 .53146 L\n.88667 .53146 L\n.88714 .53043 L\n.88714 .53043 L\n.88762 .53152 L\n.88762 .53152 L\n.8881 .53048 L\n.8881 .53048 L\n.88857 .53155 L\n.88857 .53155 L\n.88905 .53052 L\n.88905 .53052 L\n.88952 .53161 L\n.88952 .53161 L\n.89 .53057 L\n.89 .53057 L\n.89048 .53164 L\n.89048 .53164 L\n.89095 .5306 L\n.89095 .5306 L\n.89143 .53169 L\n.89143 .53169 L\n.8919 .53065 L\n.8919 .53065 L\n.89238 .53172 L\nMistroke\n.89238 .53172 L\n.89286 .53068 L\n.89286 .53068 L\n.89333 .53177 L\n.89333 .53177 L\n.89381 .53073 L\n.89381 .53073 L\n.89429 .5318 L\n.89429 .5318 L\n.89476 .53076 L\n.89476 .53076 L\n.89524 .53185 L\n.89524 .53185 L\n.89571 .53081 L\n.89571 .53081 L\n.89619 .53188 L\n.89619 .53188 L\n.89667 .53084 L\n.89667 .53084 L\n.89714 .53192 L\n.89714 .53192 L\n.89762 .53089 L\n.89762 .53089 L\n.8981 .53195 L\n.8981 .53195 L\n.89857 .53091 L\n.89857 .53091 L\n.89905 .53199 L\n.89905 .53199 L\n.89952 .53096 L\n.89952 .53096 L\n.9 .53202 L\n.9 .53202 L\n.90048 .53098 L\n.90048 .53098 L\n.90095 .53206 L\n.90095 .53206 L\n.90143 .53103 L\n.90143 .53103 L\n.9019 .53209 L\n.9019 .53209 L\n.90238 .53105 L\n.90238 .53105 L\n.90286 .53213 L\n.90286 .53213 L\n.90333 .53109 L\n.90333 .53109 L\n.90381 .53215 L\n.90381 .53215 L\n.90429 .53111 L\nMistroke\n.90429 .53111 L\n.90476 .53219 L\n.90476 .53219 L\n.90524 .53115 L\n.90524 .53115 L\n.90571 .53221 L\n.90571 .53221 L\n.90619 .53117 L\n.90619 .53117 L\n.90667 .53225 L\n.90667 .53225 L\n.90714 .53122 L\n.90714 .53122 L\n.90762 .53227 L\n.90762 .53227 L\n.9081 .53123 L\n.9081 .53123 L\n.90857 .53231 L\n.90857 .53231 L\n.90905 .53127 L\n.90905 .53127 L\n.90952 .53233 L\n.90952 .53233 L\n.91 .53129 L\n.91 .53129 L\n.91048 .53237 L\n.91048 .53237 L\n.91095 .53133 L\n.91095 .53133 L\n.91143 .53238 L\n.91143 .53238 L\n.9119 .53135 L\n.9119 .53135 L\n.91238 .53242 L\n.91238 .53242 L\n.91286 .53138 L\n.91286 .53138 L\n.91333 .53244 L\n.91333 .53244 L\n.91381 .5314 L\n.91381 .5314 L\n.91429 .53247 L\n.91429 .53247 L\n.91476 .53144 L\n.91476 .53144 L\n.91524 .53249 L\n.91524 .53249 L\n.91571 .53145 L\n.91571 .53145 L\n.91619 .53252 L\nMistroke\n.91619 .53252 L\n.91667 .53149 L\n.91667 .53149 L\n.91714 .53254 L\n.91714 .53254 L\n.91762 .5315 L\n.91762 .5315 L\n.9181 .53257 L\n.9181 .53257 L\n.91857 .53153 L\n.91857 .53153 L\n.91905 .53258 L\n.91905 .53258 L\n.91952 .53155 L\n.91952 .53155 L\n.92 .53262 L\n.92 .53262 L\n.92048 .53158 L\n.92048 .53158 L\n.92095 .53263 L\n.92095 .53263 L\n.92143 .53159 L\n.92143 .53159 L\n.9219 .53266 L\n.9219 .53266 L\n.92238 .53162 L\n.92238 .53162 L\n.92286 .53267 L\n.92286 .53267 L\n.92333 .53163 L\n.92333 .53163 L\n.92381 .5327 L\n.92381 .5327 L\n.92429 .53167 L\n.92429 .53167 L\n.92476 .53271 L\n.92476 .53271 L\n.92524 .53168 L\n.92524 .53168 L\n.92571 .53274 L\n.92571 .53274 L\n.92619 .53171 L\n.92619 .53171 L\n.92667 .53275 L\n.92667 .53275 L\n.92714 .53172 L\n.92714 .53172 L\n.92762 .53278 L\n.92762 .53278 L\n.9281 .53175 L\nMistroke\n.9281 .53175 L\n.92857 .53279 L\n.92857 .53279 L\n.92905 .53175 L\n.92905 .53175 L\n.92952 .53282 L\n.92952 .53282 L\n.93 .53178 L\n.93 .53178 L\n.93048 .53283 L\n.93048 .53283 L\n.93095 .53179 L\n.93095 .53179 L\n.93143 .53286 L\n.93143 .53286 L\n.9319 .53182 L\n.9319 .53182 L\n.93238 .53286 L\n.93238 .53286 L\n.93286 .53183 L\n.93286 .53183 L\n.93333 .53289 L\n.93333 .53289 L\n.93381 .53185 L\n.93381 .53185 L\n.93429 .5329 L\n.93429 .5329 L\n.93476 .53186 L\n.93476 .53186 L\n.93524 .53292 L\n.93524 .53292 L\n.93571 .53189 L\n.93571 .53189 L\n.93619 .53293 L\n.93619 .53293 L\n.93667 .53189 L\n.93667 .53189 L\n.93714 .53296 L\n.93714 .53296 L\n.93762 .53192 L\n.93762 .53192 L\n.9381 .53296 L\n.9381 .53296 L\n.93857 .53192 L\n.93857 .53192 L\n.93905 .53299 L\n.93905 .53299 L\n.93952 .53195 L\n.93952 .53195 L\n.94 .53299 L\nMistroke\n.94 .53299 L\n.94048 .53195 L\n.94048 .53195 L\n.94095 .53302 L\n.94095 .53302 L\n.94143 .53198 L\n.94143 .53198 L\n.9419 .53302 L\n.9419 .53302 L\n.94238 .53198 L\n.94238 .53198 L\n.94286 .53304 L\n.94286 .53304 L\n.94333 .53201 L\n.94333 .53201 L\n.94381 .53305 L\n.94381 .53305 L\n.94429 .53201 L\n.94429 .53201 L\n.94476 .53307 L\n.94476 .53307 L\n.94524 .53204 L\n.94524 .53204 L\n.94571 .53307 L\n.94571 .53307 L\n.94619 .53204 L\n.94619 .53204 L\n.94667 .5331 L\n.94667 .5331 L\n.94714 .53206 L\n.94714 .53206 L\n.94762 .5331 L\n.94762 .5331 L\n.9481 .53206 L\n.9481 .53206 L\n.94857 .53312 L\n.94857 .53312 L\n.94905 .53209 L\n.94905 .53209 L\n.94952 .53313 L\n.94952 .53313 L\n.95 .53209 L\n.95 .53209 L\n.95048 .53315 L\n.95048 .53315 L\n.95095 .53211 L\n.95095 .53211 L\n.95143 .53315 L\n.95143 .53315 L\n.9519 .53211 L\nMistroke\n.9519 .53211 L\n.95238 .53317 L\n.95238 .53317 L\n.95286 .53213 L\n.95286 .53213 L\n.95333 .53317 L\n.95333 .53317 L\n.95381 .53214 L\n.95381 .53214 L\n.95429 .53319 L\n.95429 .53319 L\n.95476 .53216 L\n.95476 .53216 L\n.95524 .53319 L\n.95524 .53319 L\n.95571 .53216 L\n.95571 .53216 L\n.95619 .53321 L\n.95619 .53321 L\n.95667 .53218 L\n.95667 .53218 L\n.95714 .53321 L\n.95714 .53321 L\n.95762 .53218 L\n.95762 .53218 L\n.9581 .53324 L\n.9581 .53324 L\n.95857 .5322 L\n.95857 .5322 L\n.95905 .53324 L\n.95905 .53324 L\n.95952 .5322 L\n.95952 .5322 L\n.96 .53326 L\n.96 .53326 L\n.96048 .53222 L\n.96048 .53222 L\n.96095 .53325 L\n.96095 .53325 L\n.96143 .53222 L\n.96143 .53222 L\n.9619 .53327 L\n.9619 .53327 L\n.96238 .53224 L\n.96238 .53224 L\n.96286 .53327 L\n.96286 .53327 L\n.96333 .53224 L\n.96333 .53224 L\n.96381 .53329 L\nMistroke\n.96381 .53329 L\n.96429 .53226 L\n.96429 .53226 L\n.96476 .53329 L\n.96476 .53329 L\n.96524 .53225 L\n.96524 .53225 L\n.96571 .53331 L\n.96571 .53331 L\n.96619 .53227 L\n.96619 .53227 L\n.96667 .53331 L\n.96667 .53331 L\n.96714 .53227 L\n.96714 .53227 L\n.96762 .53333 L\n.96762 .53333 L\n.9681 .53229 L\n.9681 .53229 L\n.96857 .53332 L\n.96857 .53332 L\n.96905 .53229 L\n.96905 .53229 L\n.96952 .53334 L\n.96952 .53334 L\n.97 .53231 L\n.97 .53231 L\n.97048 .53334 L\n.97048 .53334 L\n.97095 .5323 L\n.97095 .5323 L\n.97143 .53336 L\n.97143 .53336 L\n.9719 .53232 L\n.9719 .53232 L\n.97238 .53336 L\n.97238 .53336 L\n.97286 .53232 L\n.97286 .53232 L\n.97333 .53337 L\n.97333 .53337 L\n.97381 .53234 L\n.97381 .53234 L\n.97429 .53337 L\n.97429 .53337 L\n.97476 .53233 L\n.97476 .53233 L\n.97524 .53339 L\n.97524 .53339 L\n.97571 .53235 L\nMistroke\n.97571 .53235 L\n.97619 .53338 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(tankn) show\n99.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(h) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(L) show\n117.000 12.813 moveto\n(@) show\n123.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n129.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00D@3IfMT2000000@0fMWI0P00000^0=WIf@D000000P3IfMT2000000@0\nfMWI0P00000Z0=WIf@D000000P3IfMT2000000@0fMWI0P00000[0=WIf@@000000`3IfMT2000000@0\nfMWI0P00000G0=WIf@00D03IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI0000\n02l0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00<0\n00000=WIf@3IfMT0:@3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00@000000=WIf@3IfMT0\n00000P3IfMT00`000000fMWI0=WIf@0X0=WIf@030000003IfMT0fMWI00<0fMWI00@000000=WIf@3I\nfMT000000P3IfMT010000000fMWI0=WIf@00000F0=WIf@00D`3IfMT010000000fMWI0=WIf@000002\n0=WIf@030000003IfMT0fMWI02d0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003I\nfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0:@3IfMT00`000000fMWI0=WIf@040=WIf@040000\n003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0:@3IfMT00`000000fMWI0=WIf@020=WIf@04\n0000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000005P3IfMT00540fMWI0P0000030=WI\nf@040000003IfMT0fMWI000002l0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003I\nfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0:@3IfMT00`000000fMWI0=WIf@020=WIf@800000\n0`3IfMT010000000fMWI0=WIf@00000/0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT01000\n0000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI01@0fMWI001A0=WIf@030000003IfMT0fMWI\n0080fMWI00@000000=WIf@3IfMT00000;`3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00@0\n00000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@0Y0=WIf@030000003IfMT0fMWI0080fMWI\n00<000000=WIf@3IfMT00P3IfMT010000000fMWI0=WIf@00000Z0=WIf@040000003IfMT0fMWI0000\n0080fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@00000F0=WIf@00D@3IfMT3\n000000<0fMWI0P00000_0=WIf@800000103IfMT2000000@0fMWI0P00000[0=WIf@800000103IfMT3\n000000<0fMWI0P00000/0=WIf@800000103IfMT2000000@0fMWI0P00000G0=WIf@00o`3IfMTQ0=WI\nf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<000000=WIf@3IfMT0lP3IfMT2000000d0fMWI000L0=WIf@030000003IfMT0\nfMWI0?40fMWI00@000000=WIf@3IfMT00000303IfMT001H0fMWI1P0000000`000?l000000000003Y\n000000P0fMWI00<000000=WIf@3IfMT03@3IfMT001`0fMWI00<0003o0=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00X0fMWI1@00000<0=WIf@00703IfMT00`000?l0\nfMWI0=WIf@3a0=WIf@030000003IfMT0fMWI00d0fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o\n0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000o`3I\nfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`00\n0?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI\n00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WI\nf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o\n0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3I\nfMT0o`3IfMT20=WIf@002@3IfMT2000000@0fMWI0P0000030=WIf@D000000`3IfMT00`000?l0fMWI\n0=WIf@3o0=WIf@80fMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT0\n0`3IfMT20000ool0fMWI0`3IfMT000P0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI\n0=WIf@030=WIf@030000o`000000fMWI0?l0fMWI0P3IfMT000P0fMWI00@000000=WIf@3IfMT00000\n2P3IfMT00`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT000P0fMWI00@0\n00000=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0?l0fMWI\n0P3IfMT000T0fMWI0P00000:0=WIf@8000001@3IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@80003oo`3IfMT30=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@03\n0000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703I\nfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@80003oo`3IfMT30=WIf@00703IfMT00`00\n0?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI\n00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@80003oo`3IfMT30=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@03\n0000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703I\nfMT00`000000003o0=WIf@3o0=WIf@80fMWI000L0=WIf@03000000000?l0fMWI0?l0fMWI0P3IfMT0\n01`0fMWI00<000000000o`3IfMT0o`3IfMT20=WIf@00703IfMT00`000000003o0=WIf@3o0=WIf@80\nfMWI000L0=WIf@03000000000?l0fMWI0?l0fMWI0P3IfMT000T0fMWI0P0000040=WIf@8000000`3I\nfMT4000000@0fMWI00<000000000o`3IfMT0o`3IfMT20=WIf@00203IfMT010000000fMWI0=WIf@00\n00080=WIf@030000003IfMT0fMWI00D0fMWI00<000000000o`3IfMT0o`3IfMT20=WIf@00203IfMT0\n10000000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI00@0fMWI00<000000000o`3IfMT0o`3I\nfMT20=WIf@00203IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI00<0fMWI00<0\n00000000o`3IfMT0o`3IfMT20=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003I\nfMT0fMWI000000@0fMWI00<000000000o`3IfMT0o`3IfMT20=WIf@002@3IfMT2000000X0fMWI0P00\n00050=WIf@03000000000?l0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000000o`3IfMT0o`3IfMT2\n0=WIf@00703IfMT00`000000003o0=WIf@3o0=WIf@80fMWI000L0=WIf@03000000000?l0fMWI0?l0\nfMWI0P3IfMT001`0fMWI00<000000000o`3IfMT0o`3IfMT20=WIf@00703IfMT00`000000003o0=WI\nf@2F0=WIf@030000o`3IfMT0fMWI06P0fMWI000L0=WIf@03000000000?l0fMWI09H0fMWI0P000?mY\n0=WIf@00703IfMT00`000000003o0=WIf@2E0=WIf@80003oJP3IfMT001`0fMWI00<000000000o`3I\nfMT0U@3IfMT30000ofT0fMWI000L0=WIf@03000000000?l0fMWI09@0fMWI10000?mY0=WIf@00703I\nfMT00`000000003o0=WIf@2D0=WIf@040000o`3IfMT0003o0000ofT0fMWI000L0=WIf@0300000000\n0?l0fMWI09<0fMWI0P000?l20=WIf@030000o`3IfMT0fMWI06L0fMWI000L0=WIf@03000000000?l0\nfMWI09<0fMWI00D0003o0=WIf@3IfMT0fMWI0000o`1Y0=WIf@00703IfMT00`000000003o0=WIf@2B\n0=WIf@80003o0`3IfMT20000ofP0fMWI000L0=WIf@03000000000?l0fMWI0980fMWI00<0003o0=WI\nf@3IfMT00P3IfMT20000ofP0fMWI000L0=WIf@03000000000?l0fMWI0940fMWI0P000?l50=WIf@03\n0000o`3IfMT0fMWI06H0fMWI000L0=WIf@03000000000?l0fMWI0940fMWI0P000?l50=WIf@030000\no`3IfMT0fMWI06H0fMWI000L0=WIf@03000000000?l0003o0900fMWI0P000?l60=WIf@80003oI`3I\nfMT001`0fMWI00<000000000o`3IfMT0T03IfMT20000o`H0fMWI0P000?mW0=WIf@00703IfMT00`00\n0000003o0=WIf@2@0=WIf@030000o`3IfMT0fMWI00D0fMWI0P000?mW0=WIf@002@3IfMT2000000@0\nfMWI0P0000040=WIf@8000001@3IfMT00`000000003o0=WIf@2?0=WIf@80003o203IfMT00`000?l0\nfMWI0=WIf@1U0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI0000\n00@0fMWI00<000000000o`3IfMT0S`3IfMT00`000?l0fMWI0=WIf@070=WIf@80003oIP3IfMT000P0\nfMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@030=WIf@03000000000?l0003o\n08h0fMWI0P000?l90=WIf@80003oIP3IfMT000P0fMWI00@000000=WIf@3IfMT000002`3IfMT00`00\n0000fMWI0=WIf@020=WIf@03000000000?l0fMWI08h0fMWI00<0003o0=WIf@3IfMT0203IfMT20000\nofH0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000103IfMT0\n0`000000003o0=WIf@2=0=WIf@80003o2P3IfMT20000ofH0fMWI00090=WIf@8000002P3IfMT20000\n00D0fMWI00<000000000o`3IfMT0S@3IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI\n06@0fMWI000L0=WIf@03000000000?l0fMWI08`0fMWI0P000?l<0=WIf@80003oI@3IfMT001`0fMWI\n00<000000000o`000?l0S03IfMT00`000?l0fMWI0=WIf@0;0=WIf@80003oI@3IfMT001`0fMWI00<0\n00000000o`3IfMT0R`3IfMT20000o`d0fMWI0P000?mU0=WIf@00703IfMT00`000000003o0=WIf@2;\n0=WIf@80003o3P3IfMT00`000?l0fMWI0=WIf@1S0=WIf@00703IfMT00`000000003o0=WIf@2;0=WI\nf@030000o`3IfMT0fMWI00d0fMWI0P000?mT0=WIf@00703IfMT00`000000003o0=WIf@2:0=WIf@80\n003o3`3IfMT20000of@0fMWI000L0=WIf@03000000000?l0003o08X0fMWI00<0003o0=WIf@3IfMT0\n3`3IfMT00`000?l0fMWI0=WIf@1R0=WIf@00703IfMT00`000000003o0=WIf@290=WIf@80003o4@3I\nfMT20000of<0fMWI000L0=WIf@03000000000?l0fMWI08T0fMWI00<0003o0=WIf@3IfMT0403IfMT2\n0000of<0fMWI000L0=WIf@030000003IfMT0003o08P0fMWI0P000?lB0=WIf@80003oH`3IfMT001`0\nfMWI00<000000=WIf@000?l0R03IfMT00`000?l0fMWI0=WIf@0B0=WIf@80003oHP3IfMT001`0fMWI\n00<000000=WIf@000?l0Q`3IfMT20000oa@0fMWI0P000?mR0=WIf@00703IfMT00`000000fMWI0000\no`270=WIf@030000o`3IfMT0fMWI01<0fMWI0P000?mR0=WIf@00703IfMT00`000000fMWI0000o`26\n0=WIf@80003o5P3IfMT20000of40fMWI000L0=WIf@030000003IfMT0003o08H0fMWI0P000?lF0=WI\nf@80003oH@3IfMT001`0fMWI00<000000=WIf@000?l0Q@3IfMT20000oaL0fMWI0P000?mQ0=WIf@00\n703IfMT00`000000fMWI0000o`250=WIf@80003o603IfMT20000of00fMWI000L0=WIf@030000003I\nfMT0003o08D0fMWI00<0003o0=WIf@3IfMT05`3IfMT20000of00fMWI000L0=WIf@030000003IfMT0\n003o08@0fMWI0P000?lI0=WIf@80003oH03IfMT000T0fMWI0P0000040=WIf@8000001@3IfMT30000\n00<0fMWI00<000000=WIf@000?l0Q03IfMT00`000?l0fMWI0=WIf@0I0=WIf@80003oG`3IfMT000P0\nfMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0003o\n08<0fMWI0P000?lK0=WIf@80003oG`3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT50000\n00<0fMWI0P0000000`000?l0fMWI0=WIf@210=WIf@030000o`3IfMT0fMWI01/0fMWI0P000?mN0=WI\nf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0fMWI00<00000\n0=WIf@000?l0PP3IfMT20000oad0fMWI0P000?mN0=WIf@00203IfMT010000000fMWI0=WIf@000009\n0=WIf@030000003IfMT0000000@0fMWI00<000000=WIf@000?l0PP3IfMT00`000?l0fMWI0=WIf@0M\n0=WIf@80003oG@3IfMT000T0fMWI0P00000;0=WIf@800000103IfMT00`000000fMWI0000o`210=WI\nf@80003o7`3IfMT20000oed0fMWI000L0=WIf@030000003IfMT0003o0840fMWI0P000?lP0=WIf@80\n003oG03IfMT001`0fMWI00<000000=WIf@000?l0P03IfMT20000ob40fMWI0`000?mK0=WIf@00703I\nfMT00`000000fMWI0000o`200=WIf@80003o8P3IfMT20000oe/0fMWI000L0=WIf@030000003IfMT0\n003o07l0fMWI0P000?lT0=WIf@80003oFP3IfMT001`0fMWI00<000000=WIf@000?l0O`3IfMT20000\nob@0fMWI0`000?mI0=WIf@00703IfMT00`000000fMWI0000o`1o0=WIf@030000o`3IfMT0fMWI02@0\nfMWI0P000?mI0=WIf@00703IfMT00`000000fMWI0000o`1n0=WIf@80003o9`3IfMT20000oeP0fMWI\n000L0=WIf@030000003IfMT0003o07h0fMWI00<0003o0=WIf@3IfMT09P3IfMT30000oeL0fMWI000L\n0=WIf@030000003IfMT0003o07d0fMWI0P000?lY0=WIf@<0003oEP3IfMT001`0fMWI00<000000=WI\nf@000?l0O@3IfMT00`000?l0fMWI0=WIf@0Y0=WIf@<0003oE@3IfMT001`0fMWI00<000000=WIf@00\n0?l0O03IfMT20000ob`0fMWI0`000?mD0=WIf@00703IfMT010000000fMWI0000o`000?mk0=WIf@03\n0000o`3IfMT0fMWI02`0fMWI0`000?mC0=WIf@00703IfMT00`000000fMWI0000o`1k0=WIf@80003o\n;`3IfMT30000oe80fMWI000L0=WIf@030000003IfMT0003o07/0fMWI0P000?l`0=WIf@@0003oD03I\nfMT001`0fMWI00<000000=WIf@000?l0N`3IfMT00`000?l0fMWI0=WIf@0a0=WIf@@0003oCP3IfMT0\n01`0fMWI00<000000=WIf@000?l0NP3IfMT20000oc@0fMWI1@000?m<0=WIf@00703IfMT010000000\nfMWI0000o`000?mi0=WIf@030000o`3IfMT0fMWI03D0fMWI1@000?m:0=WIf@00703IfMT00`000000\nfMWI0000o`1i0=WIf@80003o>@3IfMT70000odH0fMWI000L0=WIf@030000003IfMT0003o07T0fMWI\n00<0003o0=WIf@3IfMT0>`3IfMT80000od80fMWI00090=WIf@800000103IfMT2000000@0fMWI0P00\n00050=WIf@030000003IfMT0003o07P0fMWI0P000?m10=WIf@`0003o>P3IfMT000P0fMWI00@00000\n0=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0003o07P0fMWI\n00<0003o0=WIf@3IfMT0A@3IfMTT0000oad0fMWI00080=WIf@040000003IfMT0fMWI000000/0fMWI\n00<000000=WIf@3IfMT00P3IfMT200000080003oMP3IfMT20000oe40fMWI6P000?lM0=WIf@00203I\nfMT010000000fMWI0=WIf@0000090=WIf@8000001@3IfMT00`000000fMWI0000o`1g0=WIf@030000\no`3IfMT0fMWI08L0fMWI00080=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT0\n103IfMT00`000000fMWI0000o`1f0=WIf@80003oR@3IfMT000T0fMWI0P00000:0=WIf@<00000103I\nfMT010000000fMWI0=WIf@000?me0=WIf@030000o`3IfMT0fMWI08P0fMWI000L0=WIf@040000003I\nfMT0fMWI0000og@0fMWI0P000?n:0=WIf@00703IfMT010000000fMWI0=WIf@000?md0=WIf@80003o\nRP3IfMT001`0fMWI00@000000=WIf@3IfMT0003oM03IfMT00`000?l0fMWI0=WIf@290=WIf@00703I\nfMT010000000fMWI0=WIf@000?mc0=WIf@80003oR`3IfMT001`0fMWI00@000000=WIf@3IfMT0003o\nL`3IfMT00`000?l0fMWI0=WIf@2:0=WIf@00703IfMT010000000fMWI0=WIf@000?mb0=WIf@80003o\nS03IfMT001`0fMWI00@000000=WIf@3IfMT0003oLP3IfMT00`000?l0fMWI0=WIf@2;0=WIf@00703I\nfMT010000000fMWI0=WIf@000?ma0=WIf@80003oS@3IfMT001`0fMWI00@000000=WIf@3IfMT0003o\nL@3IfMT00`000?l0fMWI0=WIf@2<0=WIf@00703IfMT010000000fMWI0=WIf@000?m`0=WIf@80003o\nSP3IfMT001`0fMWI00@000000=WIf@3IfMT0003oL03IfMT00`000?l0fMWI0=WIf@2=0=WIf@00703I\nfMT010000000fMWI0=WIf@000?m_0=WIf@80003oS`3IfMT001`0fMWI00@000000=WIf@3IfMT0003o\nK`3IfMT00`000?l0fMWI0=WIf@2>0=WIf@00703IfMT00`000000fMWI0=WIf@1a0000oi00fMWI000L\n0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WI\nf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI\n0P3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT002D0fMWI\n00<000000=WIf@3IfMT0:P3IfMT00`000000fMWI0=WIf@050=WIf@800000203IfMT200000;X0fMWI\n000T0=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WI\nf@080=WIf@030000003IfMT0fMWI0;P0fMWI000S0=WIf@030000003IfMT0fMWI00<0fMWI0P000003\n0=WIf@L000000P3IfMT4000000040=WIf@00000000000=WIf@8000000P3IfMT200000080fMWI0P00\n00020=WIf@<0000000<0fMWI0000000000000`3IfMT00`000000fMWI0=WIf@030=WIf@030000003I\nfMT0fMWI0080fMWI0P0000040=WIf@030000003IfMT0fMWI0;P0fMWI000S0=WIf@030000003IfMT0\nfMWI0080fMWI00@000000=WIf@3IfMT000000P3IfMT400000080fMWI00@000000=WIf@3IfMT00000\n0P3IfMT00`000000fMWI000000030=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3I\nfMT00000103IfMT00`000000fMWI0=WIf@030=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT0\n1@000000fMWI0=WIf@3IfMT000000;X0fMWI000F0=WIf@P0003o1@3IfMT00`000000fMWI0=WIf@02\n0=WIf@030000003IfMT0fMWI00H0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WI\nf@03000000<0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@03\n0000003IfMT0fMWI00<0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI\n0;P0fMWI000S0=WIf@040000003IfMT0fMWI0=WIf@D000000`3IfMT3000000030=WIf@0000000000\n008000000`3IfMT01@000000fMWI000000000000fMWI00@000002@3IfMT3000000D0fMWI00<00000\n0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@05000000<0fMWI00<000000=WIf@3IfMT0^03IfMT0\n02@0fMWI00D000000=WIf@3IfMT0fMWI0000000A0=WIf@030000003IfMT0fMWI00l0fMWI00<00000\n0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@050000003IfMT0fMWI0=WIf@0000001P3I\nfMT00`000000fMWI0=WIf@2h0=WIf@009@3IfMT00`000000fMWI0=WIf@0A0=WIf@800000403IfMT2\n000000D0fMWI00<000000=WIf@3IfMT01@3IfMT2000000P0fMWI0P00002j0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-24.3537`, -0.0901542`, 0.869108`, 0.00399094`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell[BoxData[TagBox[RowBox[List[RowBox[List["\[SkeletonIndicator]", "Graphics"]], "\[SkeletonIndicator]"]], False, Rule[Editable, False]]], "Output"]], Open]]], Closed]], Cell[CellGroupData[List[Cell["Tank Model with PI continuous controler", "Section"], Cell[CellGroupData[List[Cell["Old Tank Model", "Subsection"], Cell["model TankApplicationContinuousPI\n  PIcontinuousController piContinuous;\n  Tank  tank(area=1,flowVout=0.02);\nequation\n  connect(tank.tInp,piContinuous.cOut);\n  connect(tank.tOut,piContinuous.cInp);\n  piContinuous.ref=0.5;\nend TankApplicationContinuousPI;", "ModelicaInput"], Cell["", "Text"], Cell["simulate( TankApplicationContinuousPI, stopTime=200 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(TankApplicationContinuousPI\\) : 2004-2-4 10:47:40.7285683 : \\!\\({0.`, 200.`}\\) : 504 data points : 2 events : 21 variables>\\n\\!\\({\\*TagBox[\\(piContinuous . cInp . val\\), HoldForm], \\*TagBox[\\(piContinuous . cOut . act\\), HoldForm], \\*TagBox[\\(piContinuous . error\\), HoldForm], \\*TagBox[\\(piContinuous . K\\), HoldForm], \\*TagBox[\\(piContinuous . maxV\\), HoldForm], \\*TagBox[\\(piContinuous . minV\\), HoldForm], \\*TagBox[\\(piContinuous . outCtr\\), HoldForm], \\*TagBox[\\(piContinuous . ref\\), HoldForm], \\*TagBox[\\(piContinuous . T\\), HoldForm], \\*TagBox[\\(piContinuous . Ts\\), HoldForm], \\*TagBox[\\(piContinuous . x\\), HoldForm], \\*TagBox[\\(tank . area\\), HoldForm], \\*TagBox[\\(tank . flowGain\\), HoldForm], \\*TagBox[\\(tank . flowVout\\), HoldForm], \\*TagBox[\\(tank . h\\), HoldForm], \\*TagBox[\\(tank . qIn\\), HoldForm], \\*TagBox[\\(tank . qOut\\), HoldForm], \\*TagBox[\\(tank . tInp . act\\), HoldForm], \\*TagBox[\\(tank . tOut . val\\), HoldForm], \\*TagBox[SuperscriptBox[\\((piContinuous . x)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\((tank . h)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( tank.h );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.0047619 0.0147151 1.04972 [\n[.2619 .00222 -6 -9 ]\n[.2619 .00222 6 0 ]\n[.5 .00222 -9 -9 ]\n[.5 .00222 9 0 ]\n[.7381 .00222 -9 -9 ]\n[.7381 .00222 9 0 ]\n[.97619 .00222 -9 -9 ]\n[.97619 .00222 9 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .11969 -18 -4.5 ]\n[.01131 .11969 0 4.5 ]\n[.01131 .22466 -18 -4.5 ]\n[.01131 .22466 0 4.5 ]\n[.01131 .32963 -18 -4.5 ]\n[.01131 .32963 0 4.5 ]\n[.01131 .4346 -18 -4.5 ]\n[.01131 .4346 0 4.5 ]\n[.01131 .53958 -18 -4.5 ]\n[.01131 .53958 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.2619 .01472 m\n.2619 .02097 L\ns\n[(50)] .2619 .00222 0 1 Mshowa\n.5 .01472 m\n.5 .02097 L\ns\n[(100)] .5 .00222 0 1 Mshowa\n.7381 .01472 m\n.7381 .02097 L\ns\n[(150)] .7381 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(200)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.07143 .01472 m\n.07143 .01847 L\ns\n.11905 .01472 m\n.11905 .01847 L\ns\n.16667 .01472 m\n.16667 .01847 L\ns\n.21429 .01472 m\n.21429 .01847 L\ns\n.30952 .01472 m\n.30952 .01847 L\ns\n.35714 .01472 m\n.35714 .01847 L\ns\n.40476 .01472 m\n.40476 .01847 L\ns\n.45238 .01472 m\n.45238 .01847 L\ns\n.54762 .01472 m\n.54762 .01847 L\ns\n.59524 .01472 m\n.59524 .01847 L\ns\n.64286 .01472 m\n.64286 .01847 L\ns\n.69048 .01472 m\n.69048 .01847 L\ns\n.78571 .01472 m\n.78571 .01847 L\ns\n.83333 .01472 m\n.83333 .01847 L\ns\n.88095 .01472 m\n.88095 .01847 L\ns\n.92857 .01472 m\n.92857 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .11969 m\n.03006 .11969 L\ns\n[(0.1)] .01131 .11969 1 0 Mshowa\n.02381 .22466 m\n.03006 .22466 L\ns\n[(0.2)] .01131 .22466 1 0 Mshowa\n.02381 .32963 m\n.03006 .32963 L\ns\n[(0.3)] .01131 .32963 1 0 Mshowa\n.02381 .4346 m\n.03006 .4346 L\ns\n[(0.4)] .01131 .4346 1 0 Mshowa\n.02381 .53958 m\n.03006 .53958 L\ns\n[(0.5)] .01131 .53958 1 0 Mshowa\n.125 Mabswid\n.02381 .03571 m\n.02756 .03571 L\ns\n.02381 .0567 m\n.02756 .0567 L\ns\n.02381 .0777 m\n.02756 .0777 L\ns\n.02381 .09869 m\n.02756 .09869 L\ns\n.02381 .14068 m\n.02756 .14068 L\ns\n.02381 .16168 m\n.02756 .16168 L\ns\n.02381 .18267 m\n.02756 .18267 L\ns\n.02381 .20367 m\n.02756 .20367 L\ns\n.02381 .24565 m\n.02756 .24565 L\ns\n.02381 .26665 m\n.02756 .26665 L\ns\n.02381 .28764 m\n.02756 .28764 L\ns\n.02381 .30864 m\n.02756 .30864 L\ns\n.02381 .35063 m\n.02756 .35063 L\ns\n.02381 .37162 m\n.02756 .37162 L\ns\n.02381 .39262 m\n.02756 .39262 L\ns\n.02381 .41361 m\n.02756 .41361 L\ns\n.02381 .4556 m\n.02756 .4556 L\ns\n.02381 .47659 m\n.02756 .47659 L\ns\n.02381 .49759 m\n.02756 .49759 L\ns\n.02381 .51858 m\n.02756 .51858 L\ns\n.02381 .56057 m\n.02756 .56057 L\ns\n.02381 .58157 m\n.02756 .58157 L\ns\n.02381 .60256 m\n.02756 .60256 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .09869 L\n.02762 .18267 L\n.02952 .26665 L\n.03143 .35063 L\n.03333 .4346 L\n.03524 .51858 L\n.03714 .5996 L\n.03905 .60332 L\n.04095 .60332 L\n.04286 .60332 L\n.04476 .60332 L\n.04667 .60332 L\n.04857 .60332 L\n.05048 .60332 L\n.05238 .60332 L\n.05429 .60332 L\n.05619 .60332 L\n.0581 .60332 L\n.06 .60332 L\n.0619 .60332 L\n.06381 .60332 L\n.06571 .60332 L\n.06762 .60332 L\n.06952 .60332 L\n.07143 .60332 L\n.07333 .60332 L\n.07524 .60332 L\n.07714 .60332 L\n.07905 .60332 L\n.08095 .60332 L\n.08286 .60332 L\n.08476 .60332 L\n.08667 .60332 L\n.08857 .60332 L\n.09048 .60332 L\n.09238 .60332 L\n.09429 .60332 L\n.09619 .60332 L\n.0981 .60332 L\n.1 .60332 L\n.1019 .60332 L\n.10381 .60332 L\n.10571 .60332 L\n.10762 .60332 L\n.10952 .60332 L\n.11143 .60332 L\n.11333 .60332 L\n.11524 .60332 L\n.11714 .60332 L\nMistroke\n.11905 .60332 L\n.12095 .60332 L\n.12286 .60332 L\n.12476 .60332 L\n.12667 .60332 L\n.12857 .60332 L\n.13048 .60332 L\n.13238 .60332 L\n.13429 .60332 L\n.13619 .60332 L\n.1381 .60332 L\n.14 .60332 L\n.1419 .60332 L\n.14381 .60332 L\n.14571 .60332 L\n.14762 .60332 L\n.14952 .60332 L\n.15143 .60332 L\n.15333 .60332 L\n.15524 .60332 L\n.15714 .60332 L\n.15905 .60332 L\n.16095 .60332 L\n.16286 .60332 L\n.16476 .60332 L\n.16667 .60332 L\n.16857 .60332 L\n.17048 .60332 L\n.17238 .60332 L\n.17429 .60332 L\n.17619 .60332 L\n.1781 .60332 L\n.18 .60332 L\n.1819 .60332 L\n.18381 .60332 L\n.18571 .60332 L\n.18762 .60332 L\n.18952 .60332 L\n.19143 .60332 L\n.19333 .60332 L\n.19524 .60332 L\n.19714 .60332 L\n.19905 .60332 L\n.20095 .60332 L\n.20286 .60332 L\n.20476 .60332 L\n.20667 .60332 L\n.20857 .60332 L\n.21048 .60332 L\n.21238 .60332 L\nMistroke\n.21429 .60332 L\n.21619 .60332 L\n.2181 .60332 L\n.22 .60332 L\n.2219 .60332 L\n.22381 .60332 L\n.22571 .60332 L\n.22762 .60332 L\n.22952 .60332 L\n.23143 .60332 L\n.23333 .60332 L\n.23524 .60332 L\n.23714 .60332 L\n.23905 .60332 L\n.24095 .60332 L\n.24286 .60332 L\n.24476 .60332 L\n.24667 .60332 L\n.24857 .60332 L\n.25048 .60332 L\n.25238 .60332 L\n.25429 .60332 L\n.25619 .60332 L\n.2581 .60332 L\n.26 .60332 L\n.2619 .60332 L\n.26381 .60332 L\n.26571 .60332 L\n.26762 .60332 L\n.26952 .60332 L\n.27143 .60332 L\n.27333 .60332 L\n.27524 .60332 L\n.27714 .60332 L\n.27905 .60332 L\n.28095 .60332 L\n.28286 .60332 L\n.28476 .60332 L\n.28667 .60332 L\n.28857 .60332 L\n.29048 .60332 L\n.29238 .60332 L\n.29429 .60332 L\n.29619 .60332 L\n.2981 .60332 L\n.3 .60332 L\n.3019 .60332 L\n.30381 .60332 L\n.30571 .60332 L\n.30762 .60332 L\nMistroke\n.30952 .60332 L\n.31143 .60332 L\n.31333 .60332 L\n.31524 .60332 L\n.31714 .60332 L\n.31905 .60332 L\n.32095 .60332 L\n.32286 .60332 L\n.32476 .60332 L\n.32667 .60332 L\n.32857 .60332 L\n.33048 .60332 L\n.33238 .60332 L\n.33429 .60332 L\n.33619 .60332 L\n.3381 .60332 L\n.34 .60332 L\n.3419 .60332 L\n.34381 .60332 L\n.34571 .60332 L\n.34762 .60332 L\n.34952 .60332 L\n.35143 .60332 L\n.35333 .60332 L\n.35524 .60332 L\n.35714 .60332 L\n.35905 .60332 L\n.36095 .60332 L\n.36286 .60332 L\n.36476 .60332 L\n.36667 .60332 L\n.36857 .60332 L\n.37048 .60332 L\n.37238 .60332 L\n.37429 .60332 L\n.37619 .60332 L\n.3781 .60332 L\n.38 .60332 L\n.3819 .60332 L\n.38381 .60332 L\n.38571 .60332 L\n.38762 .60332 L\n.38952 .60332 L\n.39143 .60332 L\n.39333 .60332 L\n.39524 .60332 L\n.39714 .60332 L\n.39905 .60332 L\n.40095 .60332 L\n.40286 .60332 L\nMistroke\n.40476 .60332 L\n.40667 .60332 L\n.40857 .60332 L\n.41048 .60332 L\n.41238 .60332 L\n.41429 .60332 L\n.41619 .60332 L\n.4181 .60332 L\n.42 .60332 L\n.4219 .60332 L\n.42381 .60332 L\n.42571 .60332 L\n.42762 .60332 L\n.42952 .60332 L\n.43143 .60332 L\n.43333 .60332 L\n.43524 .60332 L\n.43714 .60332 L\n.43905 .60332 L\n.44095 .60332 L\n.44286 .60332 L\n.44476 .60332 L\n.44667 .60332 L\n.44857 .60332 L\n.45048 .60332 L\n.45238 .60332 L\n.45429 .60332 L\n.45619 .60332 L\n.4581 .60332 L\n.46 .60332 L\n.4619 .60332 L\n.46381 .60332 L\n.46571 .60332 L\n.46762 .60332 L\n.46952 .60332 L\n.47143 .60332 L\n.47333 .60332 L\n.47524 .60332 L\n.47714 .60332 L\n.47905 .60332 L\n.48095 .60332 L\n.48286 .60332 L\n.48476 .60332 L\n.48667 .60332 L\n.48857 .60332 L\n.49048 .60332 L\n.49238 .60332 L\n.49429 .60332 L\n.49619 .60332 L\n.4981 .60332 L\nMistroke\n.5 .60332 L\n.5 .60332 L\n.5 .60332 L\n.5019 .59492 L\n.50381 .58652 L\n.50571 .57813 L\n.50762 .56973 L\n.50952 .56133 L\n.51143 .55293 L\n.51333 .54453 L\n.51524 .53614 L\n.51714 .52774 L\n.51905 .51934 L\n.52095 .51094 L\n.52286 .50255 L\n.52476 .49415 L\n.52667 .48575 L\n.52857 .47735 L\n.53048 .46895 L\n.53238 .46056 L\n.53429 .45216 L\n.53619 .44376 L\n.5381 .43536 L\n.54 .42697 L\n.5419 .41857 L\n.54381 .41017 L\n.54571 .40177 L\n.54762 .39337 L\n.54952 .38498 L\n.55143 .37658 L\n.55333 .36818 L\n.55524 .35978 L\n.55714 .35139 L\n.55905 .34299 L\n.56095 .33459 L\n.56286 .32619 L\n.56476 .31779 L\n.56667 .3094 L\n.56857 .301 L\n.57048 .2926 L\n.57238 .2842 L\n.57429 .27581 L\n.57619 .26741 L\n.5781 .25901 L\n.58 .25061 L\n.5819 .24221 L\n.58381 .23382 L\n.58571 .22542 L\n.58762 .22053 L\n.58952 .23266 L\nMistroke\n.59143 .24474 L\n.59333 .25636 L\n.59524 .26753 L\n.59714 .27826 L\n.59905 .28858 L\n.60095 .29849 L\n.60286 .30801 L\n.60476 .31715 L\n.60667 .32594 L\n.60857 .33436 L\n.61048 .34246 L\n.61238 .35024 L\n.61429 .3577 L\n.61619 .36486 L\n.6181 .37174 L\n.62 .37835 L\n.6219 .3847 L\n.62381 .3908 L\n.62571 .39665 L\n.62762 .40228 L\n.62952 .40769 L\n.63143 .41288 L\n.63333 .41787 L\n.63524 .42266 L\n.63714 .42726 L\n.63905 .43169 L\n.64095 .43593 L\n.64286 .44001 L\n.64476 .44394 L\n.64667 .44771 L\n.64857 .45132 L\n.65048 .4548 L\n.65238 .45814 L\n.65429 .46135 L\n.65619 .46443 L\n.6581 .46739 L\n.66 .47024 L\n.6619 .47297 L\n.66381 .4756 L\n.66571 .47812 L\n.66762 .48055 L\n.66952 .48288 L\n.67143 .48512 L\n.67333 .48727 L\n.67524 .48933 L\n.67714 .49132 L\n.67905 .49323 L\n.68095 .49506 L\n.68286 .49682 L\n.68476 .4985 L\nMistroke\n.68667 .50012 L\n.68857 .50168 L\n.69048 .50318 L\n.69238 .50462 L\n.69429 .506 L\n.69619 .50733 L\n.6981 .5086 L\n.7 .50982 L\n.7019 .511 L\n.70381 .51212 L\n.70571 .51321 L\n.70762 .51425 L\n.70952 .51525 L\n.71143 .51621 L\n.71333 .51713 L\n.71524 .51802 L\n.71714 .51887 L\n.71905 .51968 L\n.72095 .52047 L\n.72286 .52122 L\n.72476 .52195 L\n.72667 .52264 L\n.72857 .52331 L\n.73048 .52395 L\n.73238 .52457 L\n.73429 .52516 L\n.73619 .52573 L\n.7381 .52628 L\n.74 .5268 L\n.7419 .52731 L\n.74381 .52779 L\n.74571 .52826 L\n.74762 .5287 L\n.74952 .52913 L\n.75143 .52955 L\n.75333 .52994 L\n.75524 .53032 L\n.75714 .53069 L\n.75905 .53104 L\n.76095 .53137 L\n.76286 .5317 L\n.76476 .53201 L\n.76667 .5323 L\n.76857 .53259 L\n.77048 .53287 L\n.77238 .53313 L\n.77429 .53338 L\n.77619 .53362 L\n.7781 .53386 L\n.78 .53408 L\nMistroke\n.7819 .53429 L\n.78381 .5345 L\n.78571 .5347 L\n.78762 .53489 L\n.78952 .53507 L\n.79143 .53524 L\n.79333 .53541 L\n.79524 .53557 L\n.79714 .53573 L\n.79905 .53588 L\n.80095 .53602 L\n.80286 .53616 L\n.80476 .53629 L\n.80667 .53642 L\n.80857 .53654 L\n.81048 .53666 L\n.81238 .53677 L\n.81429 .53688 L\n.81619 .53698 L\n.8181 .53708 L\n.82 .53718 L\n.8219 .53727 L\n.82381 .53736 L\n.82571 .53745 L\n.82762 .53753 L\n.82952 .53761 L\n.83143 .53769 L\n.83333 .53776 L\n.83524 .53783 L\n.83714 .5379 L\n.83905 .53797 L\n.84095 .53803 L\n.84286 .53809 L\n.84476 .53815 L\n.84667 .53821 L\n.84857 .53826 L\n.85048 .53831 L\n.85238 .53836 L\n.85429 .53841 L\n.85619 .53846 L\n.8581 .5385 L\n.86 .53854 L\n.8619 .53858 L\n.86381 .53862 L\n.86571 .53866 L\n.86762 .5387 L\n.86952 .53873 L\n.87143 .53877 L\n.87333 .5388 L\n.87524 .53883 L\nMistroke\n.87714 .53886 L\n.87905 .53889 L\n.88095 .53891 L\n.88286 .53894 L\n.88476 .53896 L\n.88667 .53899 L\n.88857 .53901 L\n.89048 .53903 L\n.89238 .53905 L\n.89429 .53907 L\n.89619 .53909 L\n.8981 .53911 L\n.9 .53913 L\n.9019 .53915 L\n.90381 .53916 L\n.90571 .53918 L\n.90762 .53919 L\n.90952 .53921 L\n.91143 .53922 L\n.91333 .53924 L\n.91524 .53925 L\n.91714 .53926 L\n.91905 .53927 L\n.92095 .53929 L\n.92286 .5393 L\n.92476 .53931 L\n.92667 .53932 L\n.92857 .53933 L\n.93048 .53934 L\n.93238 .53935 L\n.93429 .53936 L\n.93619 .53936 L\n.9381 .53937 L\n.94 .53938 L\n.9419 .53939 L\n.94381 .5394 L\n.94571 .5394 L\n.94762 .53941 L\n.94952 .53942 L\n.95143 .53942 L\n.95333 .53943 L\n.95524 .53944 L\n.95714 .53944 L\n.95905 .53945 L\n.96095 .53945 L\n.96286 .53946 L\n.96476 .53946 L\n.96667 .53947 L\n.96857 .53947 L\n.97048 .53948 L\nMistroke\n.97238 .53948 L\n.97429 .53949 L\n.97619 .53949 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(tank) show\n93.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n99.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(h) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n105.000 12.813 moveto\n(L) show\n111.000 12.813 moveto\n(@) show\n117.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n123.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00D@3IfMT2000000@0fMWI0P00000^0=WIf@D000000P3IfMT2000000@0\nfMWI0P00000Z0=WIf@D000000P3IfMT2000000@0fMWI0P00000[0=WIf@@000000`3IfMT2000000@0\nfMWI0P00000G0=WIf@00D03IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI0000\n02l0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00<0\n00000=WIf@3IfMT0:@3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00@000000=WIf@3IfMT0\n00000P3IfMT00`000000fMWI0=WIf@0X0=WIf@030000003IfMT0fMWI00<0fMWI00@000000=WIf@3I\nfMT000000P3IfMT010000000fMWI0=WIf@00000F0=WIf@00D`3IfMT010000000fMWI0=WIf@000002\n0=WIf@030000003IfMT0fMWI02d0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003I\nfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0:@3IfMT00`000000fMWI0=WIf@040=WIf@040000\n003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0:@3IfMT00`000000fMWI0=WIf@020=WIf@04\n0000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000005P3IfMT00540fMWI0P0000030=WI\nf@040000003IfMT0fMWI000002l0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003I\nfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0:@3IfMT00`000000fMWI0=WIf@020=WIf@800000\n0`3IfMT010000000fMWI0=WIf@00000/0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT01000\n0000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI01@0fMWI001A0=WIf@030000003IfMT0fMWI\n0080fMWI00@000000=WIf@3IfMT00000;`3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00@0\n00000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@0Y0=WIf@030000003IfMT0fMWI0080fMWI\n00<000000=WIf@3IfMT00P3IfMT010000000fMWI0=WIf@00000Z0=WIf@040000003IfMT0fMWI0000\n0080fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@00000F0=WIf@00D@3IfMT3\n000000<0fMWI0P00000_0=WIf@800000103IfMT2000000@0fMWI0P00000[0=WIf@800000103IfMT3\n000000<0fMWI0P00000/0=WIf@800000103IfMT2000000@0fMWI0P00000G0=WIf@00o`3IfMTQ0=WI\nf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<000000=WIf@3IfMT0lP3IfMT2000000d0fMWI000L0=WIf@030000003IfMT0\nfMWI0?40fMWI00@000000=WIf@3IfMT00000303IfMT001H0fMWI1P0000000`000?l000000000003Y\n000000P0fMWI00<000000=WIf@3IfMT03@3IfMT001`0fMWI00<0003o0=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00X0fMWI1@00000<0=WIf@00703IfMT00`000?l0\nfMWI0=WIf@3a0=WIf@030000003IfMT0fMWI00d0fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o\n0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000o`3I\nfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`00\n0?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI\n00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WI\nf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o\n0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3I\nfMT0o`3IfMT20=WIf@002@3IfMT2000000@0fMWI0P0000030=WIf@D000000`3IfMT00`000?l0fMWI\n0=WIf@3o0=WIf@80fMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT0\n0`3IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI\n00<000000=WIf@3IfMT00`3IfMT00`000?l000000=WIf@3o0=WIf@80fMWI00080=WIf@040000003I\nfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI\n00080=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI\n0=WIf@3o0=WIf@80fMWI00090=WIf@8000002P3IfMT2000000D0fMWI00<0003o0=WIf@3IfMT0o`3I\nfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI\n0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI\n0=WIf@3o0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o\n0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@03\n0000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703I\nfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT0\n01`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80\nfMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3I\nfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI\n0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI\n0=WIf@3o0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT000T0fMWI0P000004\n0=WIf@8000000`3IfMT4000000@0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00203IfMT01000\n0000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0Q@3IfMT0\n0`000?l0fMWI0=WIf@1i0=WIf@00203IfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0\nfMWI00@0fMWI00<000000000o`3IfMT0Q03IfMT20000og/0fMWI00080=WIf@040000003IfMT0fMWI\n000000X0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000003o0=WIf@240=WIf@80003oN`3IfMT0\n00P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@0300000000\n0?l0fMWI08@0fMWI0P000?mk0=WIf@002@3IfMT2000000X0fMWI0P0000050=WIf@03000000000?l0\nfMWI08<0fMWI00@0003o0=WIf@3IfMT0003oNP3IfMT001`0fMWI00<000000000o`3IfMT0P`3IfMT0\n10000?l0fMWI0=WIf@000?mj0=WIf@00703IfMT00`000000003o0=WIf@230=WIf@040000o`3IfMT0\nfMWI0000ogX0fMWI000L0=WIf@03000000000?l0fMWI08<0fMWI00@0003o0=WIf@3IfMT0003oNP3I\nfMT001`0fMWI00<000000000o`3IfMT0PP3IfMT01@000?l0fMWI0=WIf@3IfMT0003o07X0fMWI000L\n0=WIf@03000000000?l0fMWI0880fMWI00D0003o0=WIf@3IfMT0fMWI0000o`1j0=WIf@00703IfMT0\n0`000000003o0=WIf@220=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0M`3IfMT0\n01`0fMWI00<000000000o`3IfMT0PP3IfMT00`000?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI\n07L0fMWI000L0=WIf@03000000000?l0fMWI0880fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0\nfMWI0=WIf@1g0=WIf@00703IfMT00`000000003o0=WIf@220=WIf@030000o`3IfMT0fMWI0080fMWI\n00<0003o0=WIf@3IfMT0M`3IfMT001`0fMWI00<000000000o`3IfMT0P@3IfMT00`000?l0fMWI0=WI\nf@030=WIf@030000o`3IfMT0fMWI07L0fMWI000L0=WIf@03000000000?l0fMWI0840fMWI00<0003o\n0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@1g0=WIf@00703IfMT00`000000003o0=WIf@210=WI\nf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT0MP3IfMT001`0fMWI00<000000000o`3I\nfMT0P@3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI07H0fMWI000L0=WIf@030000\n00000?l0fMWI0800fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@1f0=WIf@00703I\nfMT00`000000003o0=WIf@200=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0MP3I\nfMT001`0fMWI00<000000000o`3IfMT0P03IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0\nfMWI07H0fMWI000L0=WIf@03000000000?l0fMWI0800fMWI00<0003o0=WIf@3IfMT01@3IfMT00`00\n0?l0fMWI0=WIf@1f0=WIf@00703IfMT00`000000003o0=WIf@1o0=WIf@030000o`3IfMT0fMWI00H0\nfMWI00<0003o0=WIf@3IfMT0MP3IfMT001`0fMWI00<000000000o`3IfMT0O`3IfMT00`000?l0fMWI\n0=WIf@070=WIf@030000o`3IfMT0fMWI07D0fMWI00090=WIf@800000103IfMT2000000@0fMWI0P00\n00050=WIf@03000000000?l0fMWI07l0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WI\nf@1e0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0fMWI\n00<000000000o`3IfMT0O`3IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI07D0fMWI\n00080=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000003o\n0=WIf@1n0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0M@3IfMT000P0fMWI00@0\n00000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@020=WIf@03000000000?l0fMWI07h0fMWI\n00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@1d0=WIf@00203IfMT010000000fMWI0=WI\nf@0000080=WIf@040000003IfMT0fMWI000000@0fMWI00<000000000o`3IfMT0OP3IfMT00`000?l0\nfMWI0=WIf@090=WIf@030000o`3IfMT0fMWI07@0fMWI00090=WIf@8000002P3IfMT2000000D0fMWI\n00<000000000o`3IfMT0OP3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI07@0fMWI\n000L0=WIf@03000000000?l0fMWI07d0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WI\nf@1d0=WIf@00703IfMT00`000000003o0=WIf@1m0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o\n0=WIf@3IfMT0L`3IfMT001`0fMWI00<000000000o`3IfMT0O@3IfMT00`000?l0fMWI0=WIf@0;0=WI\nf@030000o`3IfMT0fMWI07<0fMWI000L0=WIf@03000000000?l0fMWI07d0fMWI00<0003o0=WIf@3I\nfMT02`3IfMT00`000?l0fMWI0=WIf@1c0=WIf@00703IfMT00`000000003o0=WIf@1l0=WIf@030000\no`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0LP3IfMT001`0fMWI00<000000000o`3IfMT0O03I\nfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI0780fMWI000L0=WIf@03000000000?l0\nfMWI07`0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@1b0=WIf@00703IfMT00`00\n0000003o0=WIf@1l0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0LP3IfMT001`0\nfMWI00<000000000o`3IfMT0O03IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI0740\nfMWI000L0=WIf@03000000000?l0fMWI07`0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI\n0=WIf@1a0=WIf@00703IfMT00`000000003o0=WIf@1k0=WIf@030000o`3IfMT0fMWI00l0fMWI00<0\n003o0=WIf@3IfMT0L@3IfMT001`0fMWI00<000000000o`3IfMT0N`3IfMT00`000?l0fMWI0=WIf@0?\n0=WIf@030000o`3IfMT0fMWI0740fMWI000L0=WIf@030000003IfMT0003o07/0fMWI00<0003o0=WI\nf@3IfMT0403IfMT00`000?l0fMWI0=WIf@1`0=WIf@00703IfMT00`000000fMWI0000o`1k0=WIf@03\n0000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT0L03IfMT001`0fMWI00<000000=WIf@000?l0\nNP3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI0700fMWI000L0=WIf@030000003I\nfMT0003o07X0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@1_0=WIf@00703IfMT0\n0`000000fMWI0000o`1j0=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0K`3IfMT0\n01`0fMWI00<000000=WIf@000?l0NP3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI\n06h0fMWI000L0=WIf@030000003IfMT0003o07T0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0\nfMWI0=WIf@1^0=WIf@002@3IfMT2000000@0fMWI0P0000050=WIf@<000000`3IfMT00`000000fMWI\n0000o`1i0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT0KP3IfMT000P0fMWI00@0\n00000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0003o07T0fMWI\n00<0003o0=WIf@3IfMT05@3IfMT00`000?l0fMWI0=WIf@1]0=WIf@00203IfMT010000000fMWI0=WI\nf@0000080=WIf@D000000`3IfMT2000000030000o`3IfMT0fMWI07L0fMWI00<0003o0=WIf@3IfMT0\n5@3IfMT00`000?l0fMWI0=WIf@1]0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000\n003IfMT0fMWI000000@0fMWI00<000000=WIf@000?l0N@3IfMT00`000?l0fMWI0=WIf@0F0=WIf@03\n0000o`3IfMT0fMWI06`0fMWI00080=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@00\n0000103IfMT00`000000fMWI0000o`1h0=WIf@030000o`3IfMT0fMWI01L0fMWI00<0003o0=WIf@3I\nfMT0K03IfMT000T0fMWI0P00000;0=WIf@800000103IfMT00`000000fMWI0000o`1h0=WIf@030000\no`3IfMT0fMWI01P0fMWI00<0003o0=WIf@3IfMT0J`3IfMT001`0fMWI00<000000=WIf@000?l0N03I\nfMT00`000?l0fMWI0=WIf@0H0=WIf@030000o`3IfMT0fMWI06/0fMWI000L0=WIf@030000003IfMT0\n003o07P0fMWI00<0003o0=WIf@3IfMT06@3IfMT00`000?l0fMWI0=WIf@1Z0=WIf@00703IfMT00`00\n0000fMWI0000o`1g0=WIf@030000o`3IfMT0fMWI01X0fMWI00<0003o0=WIf@3IfMT0JP3IfMT001`0\nfMWI00<000000=WIf@000?l0M`3IfMT00`000?l0fMWI0=WIf@0K0=WIf@030000o`3IfMT0fMWI06T0\nfMWI000L0=WIf@030000003IfMT0003o07L0fMWI00<0003o0=WIf@3IfMT06`3IfMT20000ofX0fMWI\n000L0=WIf@030000003IfMT0003o07L0fMWI00<0003o0=WIf@3IfMT0703IfMT00`000?l0fMWI0=WI\nf@1X0=WIf@00703IfMT00`000000fMWI0000o`1f0=WIf@030000o`3IfMT0fMWI01h0fMWI00<0003o\n0=WIf@3IfMT0I`3IfMT001`0fMWI00<000000=WIf@000?l0MP3IfMT00`000?l0fMWI0=WIf@0O0=WI\nf@030000o`3IfMT0fMWI06H0fMWI000L0=WIf@030000003IfMT0003o07H0fMWI00<0003o0=WIf@3I\nfMT0803IfMT00`000?l0fMWI0=WIf@1U0=WIf@00703IfMT00`000000fMWI0000o`1f0=WIf@030000\no`3IfMT0fMWI0200fMWI00<0003o0=WIf@3IfMT0I@3IfMT001`0fMWI00<000000=WIf@000?l0MP3I\nfMT00`000?l0fMWI0=WIf@0Q0=WIf@80003oI@3IfMT001`0fMWI00<000000=WIf@000?l0MP3IfMT0\n0`000?l0fMWI0=WIf@0R0=WIf@80003oI03IfMT001`0fMWI00<000000=WIf@000?l0M@3IfMT00`00\n0?l0fMWI0=WIf@0T0=WIf@80003oH`3IfMT001`0fMWI00<000000=WIf@000?l0M@3IfMT00`000?l0\nfMWI0=WIf@0U0=WIf@80003oHP3IfMT001`0fMWI00<000000=WIf@000?l0M@3IfMT00`000?l0fMWI\n0=WIf@0W0=WIf@80003oH03IfMT001`0fMWI00<000000=WIf@000?l0M@3IfMT00`000?l0fMWI0=WI\nf@0X0=WIf@80003oG`3IfMT001`0fMWI00<000000=WIf@000?l0M03IfMT00`000?l0fMWI0=WIf@0[\n0=WIf@<0003oG03IfMT001`0fMWI00<000000=WIf@000?l0M03IfMT00`000?l0fMWI0=WIf@0]0=WI\nf@<0003oFP3IfMT001`0fMWI00<000000=WIf@000?l0M03IfMT00`000?l0fMWI0=WIf@0_0=WIf@@0\n003oE`3IfMT001`0fMWI00<000000=WIf@000?l0M03IfMT00`000?l0fMWI0=WIf@0c0=WIf@@0003o\nD`3IfMT000T0fMWI0P0000040=WIf@800000103IfMT2000000D0fMWI00<000000=WIf@000?l0L`3I\nfMT00`000?l0fMWI0=WIf@0h0=WIf@P0003oB`3IfMT000P0fMWI00@000000=WIf@3IfMT00000203I\nfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0003o07<0fMWI00<0003o0=WIf@3IfMT0\n?`3IfMTH0000oc@0fMWI00080=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT0\n0P3IfMT2000000030000o`3IfMT0fMWI0740fMWI00<0003o0=WIf@3IfMT0EP3IfMTH0000oad0fMWI\n00080=WIf@040000003IfMT0fMWI000000T0fMWI0P0000050=WIf@030000003IfMT0003o07<0fMWI\n00<0003o0=WIf@3IfMT0R`3IfMT000P0fMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI\n0=WIf@040=WIf@030000003IfMT0003o0780fMWI00<0003o0=WIf@3IfMT0S03IfMT000T0fMWI0P00\n000:0=WIf@<00000103IfMT00`000000fMWI0000o`1b0=WIf@030000o`3IfMT0fMWI08`0fMWI000L\n0=WIf@030000003IfMT0003o0780fMWI00<0003o0=WIf@3IfMT0S03IfMT001`0fMWI00@000000=WI\nf@3IfMT0003oL@3IfMT00`000?l0fMWI0=WIf@2<0=WIf@00703IfMT010000000fMWI0=WIf@000?m`\n0=WIf@030000o`3IfMT0fMWI08d0fMWI000L0=WIf@040000003IfMT0fMWI0000og00fMWI00<0003o\n0=WIf@3IfMT0S@3IfMT001`0fMWI00@000000=WIf@3IfMT0003oL03IfMT00`000?l0fMWI0=WIf@2=\n0=WIf@00703IfMT010000000fMWI0=WIf@000?m`0=WIf@030000o`3IfMT0fMWI08d0fMWI000L0=WI\nf@040000003IfMT0fMWI0000og00fMWI00<0003o0=WIf@3IfMT0S@3IfMT001`0fMWI00@000000=WI\nf@3IfMT0003oL03IfMT00`000?l0fMWI0=WIf@2=0=WIf@00703IfMT010000000fMWI0=WIf@000?m_\n0=WIf@030000o`3IfMT0fMWI08h0fMWI000L0=WIf@040000003IfMT0fMWI0000ofl0fMWI00<0003o\n0=WIf@3IfMT0SP3IfMT001`0fMWI00@000000=WIf@3IfMT0003oK`3IfMT00`000?l0fMWI0=WIf@2>\n0=WIf@00703IfMT00`000000fMWI0=WIf@1a0000oi00fMWI000L0=WIf@030000003IfMT0fMWI0?l0\nfMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WI\nf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT002D0fMWI00<000000=WIf@3IfMT0903IfMT0\n0`000000fMWI0=WIf@050=WIf@800000203IfMT200000<00fMWI000T0=WIf@030000003IfMT0fMWI\n02H0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI\n0;h0fMWI000S0=WIf@030000003IfMT0fMWI00<0fMWI0P0000030=WIf@L000000P3IfMT400000003\n0=WIf@000000000000<0fMWI0P0000020=WIf@<0000000<0fMWI0000000000000`3IfMT00`000000\nfMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI0P0000040=WIf@030000003IfMT0fMWI0;h0\nfMWI000S0=WIf@030000003IfMT0fMWI0080fMWI00@000000=WIf@3IfMT000000P3IfMT400000080\nfMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI000000090=WIf@040000003IfMT0fMWI\n000000@0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00D0\n00000=WIf@3IfMT0fMWI000000300=WIf@005P3IfMT80000o`D0fMWI00<000000=WIf@3IfMT00P3I\nfMT00`000000fMWI0=WIf@060=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0\n0`0000090=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000\nfMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0_P3IfMT002<0fMWI00@000000=WIf@3I\nfMT0fMWI1@0000030=WIf@<0000000<0fMWI0000000000000P0000030=WIf@040000003IfMT00000\n000000P0fMWI0`0000050=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT01@000003\n0=WIf@030000003IfMT0fMWI0;h0fMWI000T0=WIf@050000003IfMT0fMWI0=WIf@0000004@3IfMT0\n0`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT0\n1@000000fMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0_P3IfMT002D0fMWI00<00000\n0=WIf@3IfMT04@3IfMT2000000X0fMWI0P0000050=WIf@030000003IfMT0fMWI00D0fMWI0P000008\n0=WIf@800000`03IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3I\nfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3I\nfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3I\nfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3I\nfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00001"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-24.3537`, -0.0890617`, 0.869108`, 0.00394258`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell[BoxData[TagBox[RowBox[List[RowBox[List["\[SkeletonIndicator]", "Graphics"]], "\[SkeletonIndicator]"]], False, Rule[Editable, False]]], "Output"], Cell["plot( tank.qIn );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.0047619 0.0147151 2.94302 [\n[.2619 .00222 -6 -9 ]\n[.2619 .00222 6 0 ]\n[.5 .00222 -9 -9 ]\n[.5 .00222 9 0 ]\n[.7381 .00222 -9 -9 ]\n[.7381 .00222 9 0 ]\n[.97619 .00222 -9 -9 ]\n[.97619 .00222 9 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .16187 -24 -4.5 ]\n[.01131 .16187 0 4.5 ]\n[.01131 .30902 -18 -4.5 ]\n[.01131 .30902 0 4.5 ]\n[.01131 .45617 -24 -4.5 ]\n[.01131 .45617 0 4.5 ]\n[.01131 .60332 -18 -4.5 ]\n[.01131 .60332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.2619 .01472 m\n.2619 .02097 L\ns\n[(50)] .2619 .00222 0 1 Mshowa\n.5 .01472 m\n.5 .02097 L\ns\n[(100)] .5 .00222 0 1 Mshowa\n.7381 .01472 m\n.7381 .02097 L\ns\n[(150)] .7381 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(200)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.07143 .01472 m\n.07143 .01847 L\ns\n.11905 .01472 m\n.11905 .01847 L\ns\n.16667 .01472 m\n.16667 .01847 L\ns\n.21429 .01472 m\n.21429 .01847 L\ns\n.30952 .01472 m\n.30952 .01847 L\ns\n.35714 .01472 m\n.35714 .01847 L\ns\n.40476 .01472 m\n.40476 .01847 L\ns\n.45238 .01472 m\n.45238 .01847 L\ns\n.54762 .01472 m\n.54762 .01847 L\ns\n.59524 .01472 m\n.59524 .01847 L\ns\n.64286 .01472 m\n.64286 .01847 L\ns\n.69048 .01472 m\n.69048 .01847 L\ns\n.78571 .01472 m\n.78571 .01847 L\ns\n.83333 .01472 m\n.83333 .01847 L\ns\n.88095 .01472 m\n.88095 .01847 L\ns\n.92857 .01472 m\n.92857 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .16187 m\n.03006 .16187 L\ns\n[(0.05)] .01131 .16187 1 0 Mshowa\n.02381 .30902 m\n.03006 .30902 L\ns\n[(0.1)] .01131 .30902 1 0 Mshowa\n.02381 .45617 m\n.03006 .45617 L\ns\n[(0.15)] .01131 .45617 1 0 Mshowa\n.02381 .60332 m\n.03006 .60332 L\ns\n[(0.2)] .01131 .60332 1 0 Mshowa\n.125 Mabswid\n.02381 .04415 m\n.02756 .04415 L\ns\n.02381 .07358 m\n.02756 .07358 L\ns\n.02381 .10301 m\n.02756 .10301 L\ns\n.02381 .13244 m\n.02756 .13244 L\ns\n.02381 .1913 m\n.02756 .1913 L\ns\n.02381 .22073 m\n.02756 .22073 L\ns\n.02381 .25016 m\n.02756 .25016 L\ns\n.02381 .27959 m\n.02756 .27959 L\ns\n.02381 .33845 m\n.02756 .33845 L\ns\n.02381 .36788 m\n.02756 .36788 L\ns\n.02381 .39731 m\n.02756 .39731 L\ns\n.02381 .42674 m\n.02756 .42674 L\ns\n.02381 .4856 m\n.02756 .4856 L\ns\n.02381 .51503 m\n.02756 .51503 L\ns\n.02381 .54446 m\n.02756 .54446 L\ns\n.02381 .57389 m\n.02756 .57389 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .60332 m\n.02571 .60332 L\n.02762 .60332 L\n.02952 .60332 L\n.03143 .60332 L\n.03333 .60332 L\n.03524 .60332 L\n.03714 .27545 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01472 L\n.0981 .01472 L\n.1 .01472 L\n.1019 .01472 L\n.10381 .01472 L\n.10571 .01472 L\n.10762 .01472 L\n.10952 .01472 L\n.11143 .01472 L\n.11333 .01472 L\n.11524 .01472 L\n.11714 .01472 L\nMistroke\n.11905 .01472 L\n.12095 .01472 L\n.12286 .01472 L\n.12476 .01472 L\n.12667 .01472 L\n.12857 .01472 L\n.13048 .01472 L\n.13238 .01472 L\n.13429 .01472 L\n.13619 .01472 L\n.1381 .01472 L\n.14 .01472 L\n.1419 .01472 L\n.14381 .01472 L\n.14571 .01472 L\n.14762 .01472 L\n.14952 .01472 L\n.15143 .01472 L\n.15333 .01472 L\n.15524 .01472 L\n.15714 .01472 L\n.15905 .01472 L\n.16095 .01472 L\n.16286 .01472 L\n.16476 .01472 L\n.16667 .01472 L\n.16857 .01472 L\n.17048 .01472 L\n.17238 .01472 L\n.17429 .01472 L\n.17619 .01472 L\n.1781 .01472 L\n.18 .01472 L\n.1819 .01472 L\n.18381 .01472 L\n.18571 .01472 L\n.18762 .01472 L\n.18952 .01472 L\n.19143 .01472 L\n.19333 .01472 L\n.19524 .01472 L\n.19714 .01472 L\n.19905 .01472 L\n.20095 .01472 L\n.20286 .01472 L\n.20476 .01472 L\n.20667 .01472 L\n.20857 .01472 L\n.21048 .01472 L\n.21238 .01472 L\nMistroke\n.21429 .01472 L\n.21619 .01472 L\n.2181 .01472 L\n.22 .01472 L\n.2219 .01472 L\n.22381 .01472 L\n.22571 .01472 L\n.22762 .01472 L\n.22952 .01472 L\n.23143 .01472 L\n.23333 .01472 L\n.23524 .01472 L\n.23714 .01472 L\n.23905 .01472 L\n.24095 .01472 L\n.24286 .01472 L\n.24476 .01472 L\n.24667 .01472 L\n.24857 .01472 L\n.25048 .01472 L\n.25238 .01472 L\n.25429 .01472 L\n.25619 .01472 L\n.2581 .01472 L\n.26 .01472 L\n.2619 .01472 L\n.26381 .01472 L\n.26571 .01472 L\n.26762 .01472 L\n.26952 .01472 L\n.27143 .01472 L\n.27333 .01472 L\n.27524 .01472 L\n.27714 .01472 L\n.27905 .01472 L\n.28095 .01472 L\n.28286 .01472 L\n.28476 .01472 L\n.28667 .01472 L\n.28857 .01472 L\n.29048 .01472 L\n.29238 .01472 L\n.29429 .01472 L\n.29619 .01472 L\n.2981 .01472 L\n.3 .01472 L\n.3019 .01472 L\n.30381 .01472 L\n.30571 .01472 L\n.30762 .01472 L\nMistroke\n.30952 .01472 L\n.31143 .01472 L\n.31333 .01472 L\n.31524 .01472 L\n.31714 .01472 L\n.31905 .01472 L\n.32095 .01472 L\n.32286 .01472 L\n.32476 .01472 L\n.32667 .01472 L\n.32857 .01472 L\n.33048 .01472 L\n.33238 .01472 L\n.33429 .01472 L\n.33619 .01472 L\n.3381 .01472 L\n.34 .01472 L\n.3419 .01472 L\n.34381 .01472 L\n.34571 .01472 L\n.34762 .01472 L\n.34952 .01472 L\n.35143 .01472 L\n.35333 .01472 L\n.35524 .01472 L\n.35714 .01472 L\n.35905 .01472 L\n.36095 .01472 L\n.36286 .01472 L\n.36476 .01472 L\n.36667 .01472 L\n.36857 .01472 L\n.37048 .01472 L\n.37238 .01472 L\n.37429 .01472 L\n.37619 .01472 L\n.3781 .01472 L\n.38 .01472 L\n.3819 .01472 L\n.38381 .01472 L\n.38571 .01472 L\n.38762 .01472 L\n.38952 .01472 L\n.39143 .01472 L\n.39333 .01472 L\n.39524 .01472 L\n.39714 .01472 L\n.39905 .01472 L\n.40095 .01472 L\n.40286 .01472 L\nMistroke\n.40476 .01472 L\n.40667 .01472 L\n.40857 .01472 L\n.41048 .01472 L\n.41238 .01472 L\n.41429 .01472 L\n.41619 .01472 L\n.4181 .01472 L\n.42 .01472 L\n.4219 .01472 L\n.42381 .01472 L\n.42571 .01472 L\n.42762 .01472 L\n.42952 .01472 L\n.43143 .01472 L\n.43333 .01472 L\n.43524 .01472 L\n.43714 .01472 L\n.43905 .01472 L\n.44095 .01472 L\n.44286 .01472 L\n.44476 .01472 L\n.44667 .01472 L\n.44857 .01472 L\n.45048 .01472 L\n.45238 .01472 L\n.45429 .01472 L\n.45619 .01472 L\n.4581 .01472 L\n.46 .01472 L\n.4619 .01472 L\n.46381 .01472 L\n.46571 .01472 L\n.46762 .01472 L\n.46952 .01472 L\n.47143 .01472 L\n.47333 .01472 L\n.47524 .01472 L\n.47714 .01472 L\n.47905 .01472 L\n.48095 .01472 L\n.48286 .01472 L\n.48476 .01472 L\n.48667 .01472 L\n.48857 .01472 L\n.49048 .01472 L\n.49238 .01472 L\n.49429 .01472 L\n.49619 .01472 L\n.4981 .01472 L\nMistroke\n.5 .01472 L\n.5 .01472 L\n.5 .01472 L\n.5019 .01472 L\n.50381 .01472 L\n.50571 .01472 L\n.50762 .01472 L\n.50952 .01472 L\n.51143 .01472 L\n.51333 .01472 L\n.51524 .01472 L\n.51714 .01472 L\n.51905 .01472 L\n.52095 .01472 L\n.52286 .01472 L\n.52476 .01472 L\n.52667 .01472 L\n.52857 .01472 L\n.53048 .01472 L\n.53238 .01472 L\n.53429 .01472 L\n.53619 .01472 L\n.5381 .01472 L\n.54 .01472 L\n.5419 .01472 L\n.54381 .01472 L\n.54571 .01472 L\n.54762 .01472 L\n.54952 .01472 L\n.55143 .01472 L\n.55333 .01472 L\n.55524 .01472 L\n.55714 .01472 L\n.55905 .01472 L\n.56095 .01472 L\n.56286 .01472 L\n.56476 .01472 L\n.56667 .01472 L\n.56857 .01472 L\n.57048 .01472 L\n.57238 .01472 L\n.57429 .01472 L\n.57619 .01472 L\n.5781 .01472 L\n.58 .01472 L\n.5819 .01472 L\n.58381 .01472 L\n.58571 .01472 L\n.58762 .1405 L\n.58952 .16019 L\nMistroke\n.59143 .15663 L\n.59333 .15337 L\n.59524 .15023 L\n.59714 .14721 L\n.59905 .1443 L\n.60095 .14151 L\n.60286 .13883 L\n.60476 .13625 L\n.60667 .13377 L\n.60857 .1314 L\n.61048 .12912 L\n.61238 .12693 L\n.61429 .12482 L\n.61619 .12281 L\n.6181 .12087 L\n.62 .11901 L\n.6219 .11722 L\n.62381 .1155 L\n.62571 .11385 L\n.62762 .11226 L\n.62952 .11074 L\n.63143 .10928 L\n.63333 .10787 L\n.63524 .10652 L\n.63714 .10522 L\n.63905 .10398 L\n.64095 .10278 L\n.64286 .10163 L\n.64476 .10052 L\n.64667 .09946 L\n.64857 .09844 L\n.65048 .09746 L\n.65238 .09652 L\n.65429 .09562 L\n.65619 .09475 L\n.6581 .09391 L\n.66 .09311 L\n.6619 .09234 L\n.66381 .0916 L\n.66571 .09089 L\n.66762 .09021 L\n.66952 .08955 L\n.67143 .08892 L\n.67333 .08832 L\n.67524 .08773 L\n.67714 .08717 L\n.67905 .08664 L\n.68095 .08612 L\n.68286 .08562 L\n.68476 .08515 L\nMistroke\n.68667 .08469 L\n.68857 .08425 L\n.69048 .08383 L\n.69238 .08343 L\n.69429 .08304 L\n.69619 .08266 L\n.6981 .0823 L\n.7 .08196 L\n.7019 .08163 L\n.70381 .08131 L\n.70571 .08101 L\n.70762 .08071 L\n.70952 .08043 L\n.71143 .08016 L\n.71333 .0799 L\n.71524 .07965 L\n.71714 .07941 L\n.71905 .07918 L\n.72095 .07896 L\n.72286 .07875 L\n.72476 .07854 L\n.72667 .07835 L\n.72857 .07816 L\n.73048 .07798 L\n.73238 .0778 L\n.73429 .07764 L\n.73619 .07748 L\n.7381 .07732 L\n.74 .07718 L\n.7419 .07703 L\n.74381 .0769 L\n.74571 .07677 L\n.74762 .07664 L\n.74952 .07652 L\n.75143 .0764 L\n.75333 .07629 L\n.75524 .07618 L\n.75714 .07608 L\n.75905 .07598 L\n.76095 .07589 L\n.76286 .0758 L\n.76476 .07571 L\n.76667 .07562 L\n.76857 .07554 L\n.77048 .07547 L\n.77238 .07539 L\n.77429 .07532 L\n.77619 .07525 L\n.7781 .07519 L\n.78 .07512 L\nMistroke\n.7819 .07506 L\n.78381 .07501 L\n.78571 .07495 L\n.78762 .0749 L\n.78952 .07485 L\n.79143 .0748 L\n.79333 .07475 L\n.79524 .0747 L\n.79714 .07466 L\n.79905 .07462 L\n.80095 .07458 L\n.80286 .07454 L\n.80476 .0745 L\n.80667 .07447 L\n.80857 .07443 L\n.81048 .0744 L\n.81238 .07437 L\n.81429 .07434 L\n.81619 .07431 L\n.8181 .07428 L\n.82 .07425 L\n.8219 .07422 L\n.82381 .0742 L\n.82571 .07417 L\n.82762 .07415 L\n.82952 .07413 L\n.83143 .07411 L\n.83333 .07409 L\n.83524 .07407 L\n.83714 .07405 L\n.83905 .07403 L\n.84095 .07401 L\n.84286 .07399 L\n.84476 .07398 L\n.84667 .07396 L\n.84857 .07395 L\n.85048 .07393 L\n.85238 .07392 L\n.85429 .0739 L\n.85619 .07389 L\n.8581 .07388 L\n.86 .07387 L\n.8619 .07386 L\n.86381 .07384 L\n.86571 .07383 L\n.86762 .07382 L\n.86952 .07381 L\n.87143 .0738 L\n.87333 .07379 L\n.87524 .07379 L\nMistroke\n.87714 .07378 L\n.87905 .07377 L\n.88095 .07376 L\n.88286 .07376 L\n.88476 .07375 L\n.88667 .07374 L\n.88857 .07374 L\n.89048 .07373 L\n.89238 .07372 L\n.89429 .07372 L\n.89619 .07371 L\n.8981 .07371 L\n.9 .0737 L\n.9019 .0737 L\n.90381 .07369 L\n.90571 .07369 L\n.90762 .07368 L\n.90952 .07368 L\n.91143 .07368 L\n.91333 .07367 L\n.91524 .07367 L\n.91714 .07366 L\n.91905 .07366 L\n.92095 .07366 L\n.92286 .07365 L\n.92476 .07365 L\n.92667 .07365 L\n.92857 .07365 L\n.93048 .07364 L\n.93238 .07364 L\n.93429 .07364 L\n.93619 .07364 L\n.9381 .07363 L\n.94 .07363 L\n.9419 .07363 L\n.94381 .07363 L\n.94571 .07362 L\n.94762 .07362 L\n.94952 .07362 L\n.95143 .07362 L\n.95333 .07362 L\n.95524 .07362 L\n.95714 .07361 L\n.95905 .07361 L\n.96095 .07361 L\n.96286 .07361 L\n.96476 .07361 L\n.96667 .07361 L\n.96857 .0736 L\n.97048 .0736 L\nMistroke\n.97238 .0736 L\n.97429 .0736 L\n.97619 .0736 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(tank) show\n93.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n99.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(qIn) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n117.000 12.813 moveto\n(L) show\n123.000 12.813 moveto\n(@) show\n129.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n135.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00EP3IfMT2000000@0fMWI0P00000/0=WIf@D00000\n0P3IfMT2000000@0fMWI0P00000Y0=WIf@D000000P3IfMT2000000@0fMWI0P00000Y0=WIf@@00000\n0`3IfMT2000000@0fMWI0P00000G0=WIf@00E@3IfMT010000000fMWI0=WIf@0000020=WIf@040000\n003IfMT0fMWI000002d0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI\n00000080fMWI00<000000=WIf@3IfMT0:03IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00@0\n00000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@0V0=WIf@030000003IfMT0fMWI00<0fMWI\n00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@00000F0=WIf@00F03IfMT010000000\nfMWI0=WIf@0000020=WIf@030000003IfMT0fMWI02/0fMWI00D000000=WIf@3IfMT0fMWI00000002\n0=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0:03IfMT00`000000fMWI0=WI\nf@040=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT09`3IfMT00`000000fMWI\n0=WIf@020=WIf@040000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000005P3IfMT005H0\nfMWI0P0000030=WIf@040000003IfMT0fMWI000002d0fMWI00D000000=WIf@3IfMT0fMWI00000002\n0=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0:03IfMT00`000000fMWI0=WI\nf@020=WIf@8000000`3IfMT010000000fMWI0=WIf@00000Z0=WIf@050000003IfMT0fMWI0=WIf@00\n00000P3IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI01@0fMWI001F0=WIf@03\n0000003IfMT0fMWI0080fMWI00@000000=WIf@3IfMT00000;@3IfMT01@000000fMWI0=WIf@3IfMT0\n00000080fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@0X0=WIf@030000003I\nfMT0fMWI0080fMWI00<000000=WIf@3IfMT00P3IfMT010000000fMWI0=WIf@00000X0=WIf@040000\n003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@00000F\n0=WIf@00EP3IfMT3000000<0fMWI0P00000]0=WIf@800000103IfMT2000000@0fMWI0P00000Z0=WI\nf@800000103IfMT3000000<0fMWI0P00000Z0=WIf@800000103IfMT2000000@0fMWI0P00000G0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@008@3IfMT00`000000fMWI0=WIf@3l0=WIf@008@3IfMT0\n0`000000fMWI0=WIf@3l0=WIf@008@3IfMT00`000000fMWI0=WIf@3]0=WIf@8000003@3IfMT001`0\nfMWI2@0000220000of8000001`3IfMT010000000fMWI0=WIf@00000<0=WIf@008@3IfMT01@000000\nfMWI0=WIf@3IfMT0003o00L0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WI\nf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WI\nf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WI\nf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@060=WI\nf@030000o`3IfMT0000000X0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WI\nf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WI\nf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@0;0=WI\nf@030000003IfMT0fMWI00d0fMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l0=03IfMT00`00\n0000fMWI0=WIf@0e0=WIf@030000003IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT08@3IfMT00`00\n0000fMWI0=WIf@0e0=WIf@030000003IfMT0fMWI00X0fMWI1@00000<0=WIf@008@3IfMT01@000000\nfMWI0=WIf@3IfMT0003o0800fMWI00<0003o0=WIf@3IfMT0I`3IfMT00`000000fMWI0=WIf@0=0=WI\nf@008@3IfMT01@000000fMWI0=WIf@3IfMT0003o0800fMWI00<0003o0=WIf@3IfMT0M`3IfMT00240\nfMWI00D000000=WIf@3IfMT0fMWI0000o`200=WIf@030000o`3IfMT0fMWI07L0fMWI000Q0=WIf@05\n0000003IfMT0fMWI0=WIf@000?l0P03IfMT00`000?l0fMWI0=WIf@1g0=WIf@008@3IfMT200000080\nfMWI00<0003o0=WIf@3IfMT0OP3IfMT00`000?l0fMWI0=WIf@1g0=WIf@008@3IfMT01@000000fMWI\n0=WIf@3IfMT0003o0800fMWI00<0003o0=WIf@3IfMT0M`3IfMT00240fMWI00D000000=WIf@3IfMT0\nfMWI0000o`200=WIf@030000o`3IfMT0fMWI07L0fMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@00\n0?l0P03IfMT00`000?l0fMWI0=WIf@1g0=WIf@008@3IfMT01@000000fMWI0=WIf@3IfMT0003o0800\nfMWI00<0003o0=WIf@3IfMT0M`3IfMT00240fMWI00D000000=WIf@3IfMT0fMWI0000o`200=WIf@03\n0000o`3IfMT0fMWI07L0fMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l0P03IfMT00`000?l0\nfMWI0=WIf@1g0=WIf@008@3IfMT200000080fMWI00<0003o0=WIf@3IfMT0OP3IfMT00`000?l0fMWI\n0=WIf@0V0=WIfC@0003o7@3IfMT00240fMWI00D000000=WIf@3IfMT0fMWI0000o`200=WIf@030000\no`3IfMT0fMWI01/0fMWI30000?m@0=WIf@008@3IfMT01@000000fMWI0=WIf@3IfMT0003o0800fMWI\n00<0003o0=WIf@3IfMT05@3IfMT60000oe`0fMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l0\nP03IfMT00`000?l0fMWI0=WIf@0B0=WIf@@0003oH@3IfMT00240fMWI00D000000=WIf@3IfMT0fMWI\n0000o`200=WIf@030000o`3IfMT0fMWI00l0fMWI0`000?mU0=WIf@008@3IfMT01@000000fMWI0=WI\nf@3IfMT0003o0800fMWI00<0003o0=WIf@3IfMT03@3IfMT20000ofP0fMWI000Q0=WIf@050000003I\nfMT0fMWI0=WIf@000?l0P03IfMT00`000?l0fMWI0=WIf@0;0=WIf@80003oJP3IfMT00240fMWI0P00\n00020=WIf@030000o`3IfMT0fMWI07h0fMWI00<0003o0=WIf@3IfMT02@3IfMT20000of`0fMWI000Q\n0=WIf@050000003IfMT0fMWI0=WIf@000?l0P03IfMT00`000?l0fMWI0=WIf@080=WIf@80003oK@3I\nfMT00240fMWI00D000000=WIf@3IfMT0fMWI0000o`200=WIf@030000o`3IfMT0fMWI00H0fMWI0P00\n0?m_0=WIf@008@3IfMT01@000000fMWI0=WIf@3IfMT0003o0800fMWI00<0003o0=WIf@3IfMT01@3I\nfMT20000og00fMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l0P03IfMT00`000?l0fMWI0=WI\nf@050=WIf@030000o`3IfMT0fMWI06l0fMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l0P03I\nfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0700fMWI000Q0=WIf@050000003IfMT0\nfMWI0=WIf@000?l0P03IfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0740fMWI000Q\n0=WIf@8000000P3IfMT00`000?l0fMWI0=WIf@1n0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o\n0=WIf@3IfMT0LP3IfMT00240fMWI00D000000=WIf@3IfMT0fMWI0000o`200=WIf@050000o`3IfMT0\nfMWI0=WIf@000?l0M@3IfMT00240fMWI00D000000=WIf@3IfMT0fMWI0000o`200=WIf@040000o`3I\nfMT0fMWI0000ogH0fMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l0P03IfMT010000?l0fMWI\n0=WIf@000?mf0=WIf@008@3IfMT01@000000fMWI0=WIf@3IfMT0003o0800fMWI00<0003o0=WIf@00\n0?l0M`3IfMT000T0fMWI0P0000040=WIf@800000103IfMT2000000@0fMWI0P0000040=WIf@050000\n003IfMT0fMWI0=WIf@000?l0P@3IfMT20000ogL0fMWI00080=WIf@040000003IfMT0fMWI000000P0\nfMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000030=WIf@050000003IfMT0\nfMWI0=WIf@000?l0P@3IfMT00`000?l0fMWI0=WIf@1f0=WIf@00203IfMT010000000fMWI0=WIf@00\n00080=WIf@040000003IfMT0fMWI000000D0fMWI00@000000=WIf@3IfMT0fMWI0`0000000`3IfMT0\n003o0=WIf@3i0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI0000\n00<0fMWI0P0000040=WIf@050000003IfMT0fMWI0=WIf@000?l0nP3IfMT000P0fMWI00@000000=WI\nf@3IfMT00000203IfMT010000000fMWI0=WIf@0000030=WIf@030000003IfMT0fMWI00<0fMWI00D0\n00000=WIf@3IfMT0fMWI0000o`3j0=WIf@002@3IfMT2000000X0fMWI0P0000040=WIf@<000000`3I\nfMT01@000000fMWI0=WIf@3IfMT0003o0?X0fMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l0\nnP3IfMT00240fMWI00D000000=WIf@3IfMT0fMWI0000o`3j0=WIf@008@3IfMT01@000000fMWI0=WI\nf@3IfMT0003o0?X0fMWI000Q0=WIf@8000000P3IfMT00`000?l0fMWI0=WIf@3h0=WIf@008@3IfMT0\n1@000000fMWI0=WIf@3IfMT0003o0?X0fMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l0nP3I\nfMT00240fMWI00D000000=WIf@3IfMT0fMWI0000o`3j0=WIf@008@3IfMT01@000000fMWI0=WIf@3I\nfMT0003o0?X0fMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l0nP3IfMT00240fMWI00D00000\n0=WIf@3IfMT0fMWI0000o`3j0=WIf@008@3IfMT200000080fMWI00<0003o0=WIf@3IfMT0n03IfMT0\n0240fMWI00D000000=WIf@3IfMT0fMWI0000o`3j0=WIf@008@3IfMT01@000000fMWI0=WIf@3IfMT0\n003o0?X0fMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l0nP3IfMT00240fMWI00D000000=WI\nf@3IfMT0fMWI0000o`3j0=WIf@008@3IfMT01@000000fMWI0=WIf@3IfMT0003o0?X0fMWI000Q0=WI\nf@050000003IfMT0fMWI0=WIf@000?l0nP3IfMT00240fMWI0P0000020=WIf@030000o`3IfMT0fMWI\n0?P0fMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l0nP3IfMT00240fMWI00D000000=WIf@3I\nfMT0fMWI0000o`3j0=WIf@008@3IfMT01@000000fMWI0=WIf@3IfMT0003o0?X0fMWI000Q0=WIf@05\n0000003IfMT0fMWI0=WIf@000?l0nP3IfMT00240fMWI00D000000=WIf@3IfMT0fMWI0000o`3j0=WI\nf@008@3IfMT01@000000fMWI0=WIf@3IfMT0003o0?X0fMWI000Q0=WIf@8000000P3IfMT00`000?l0\nfMWI0=WIf@3h0=WIf@008@3IfMT01@000000fMWI0=WIf@3IfMT0003o0?X0fMWI000Q0=WIf@050000\n003IfMT0fMWI0=WIf@000?l0nP3IfMT00240fMWI00D000000=WIf@3IfMT0fMWI0000o`3j0=WIf@00\n3`3IfMT2000000@0fMWI0P0000030=WIf@D000000P3IfMT01@000000fMWI0=WIf@3IfMT0003o0?X0\nfMWI000>0=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00P3IfMT01@000000\nfMWI0=WIf@3IfMT0003o0?X0fMWI000>0=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WI\nf@3IfMT00P3IfMT3000000030=WIf@000?l0fMWI0?T0fMWI000>0=WIf@040000003IfMT0fMWI0000\n00X0fMWI00<000000=WIf@3IfMT00P3IfMT01@000000fMWI0=WIf@3IfMT0003o0?X0fMWI000>0=WI\nf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00P3IfMT01@000000fMWI0=WIf@3I\nfMT0003o0?X0fMWI000?0=WIf@8000002P3IfMT2000000@0fMWI00D000000=WIf@3IfMT0fMWI0000\no`3j0=WIf@008@3IfMT01@000000fMWI0=WIf@3IfMT0003o0?X0fMWI000Q0=WIf@050000003IfMT0\nfMWI0=WIf@000?l0nP3IfMT00240fMWI00D000000=WIf@3IfMT0fMWI0000o`3j0=WIf@008@3IfMT2\n00000080fMWI00<0003o0=WIf@3IfMT0n03IfMT00240fMWI00D000000=WIf@3IfMT0fMWI0000o`3j\n0=WIf@008@3IfMT01@000000fMWI0=WIf@3IfMT0003o0?X0fMWI000Q0=WIf@050000003IfMT0fMWI\n0=WIf@000?l0nP3IfMT00240fMWI00D000000=WIf@3IfMT0fMWI0000o`3j0=WIf@008@3IfMT01@00\n0000fMWI0=WIf@3IfMT0003o0?X0fMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l0nP3IfMT0\n0240fMWI0P0000020=WIf@030000o`3IfMT0fMWI0?P0fMWI000Q0=WIf@050000003IfMT0fMWI0=WI\nf@000?l0nP3IfMT00240fMWI00D000000=WIf@3IfMT0fMWI0000o`3j0=WIf@008@3IfMT01@000000\nfMWI0=WIf@3IfMT0003o0?X0fMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l0nP3IfMT00240\nfMWI00D000000=WIf@3IfMT0fMWI0000o`3j0=WIf@008@3IfMT01@000000fMWI0=WIf@3IfMT0003o\n0?X0fMWI000Q0=WIf@8000000P3IfMT00`000?l0fMWI0=WIf@3h0=WIf@008@3IfMT01@000000fMWI\n0=WIf@3IfMT0003o0?X0fMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l0nP3IfMT00240fMWI\n00D000000=WIf@3IfMT0fMWI0000o`3j0=WIf@008@3IfMT01@000000fMWI0=WIf@3IfMT0003o0?X0\nfMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l0nP3IfMT00240fMWI00D000000=WIf@3IfMT0\nfMWI0000o`3j0=WIf@008@3IfMT200000080fMWI00<0003o0=WIf@3IfMT0n03IfMT00240fMWI00D0\n00000=WIf@3IfMT0fMWI0000o`3j0=WIf@008@3IfMT01@000000fMWI0=WIf@3IfMT0003o0?X0fMWI\n000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l0nP3IfMT00240fMWI00@000000=WIf@3IfMT0003o\nn`3IfMT000T0fMWI0P0000040=WIf@8000000`3IfMT500000080fMWI0P0000040=WIf@040000003I\nfMT0fMWI0000oo/0fMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI00D000000=WIf@3IfMT0\nfMWI000000020=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT00`000?l0fMWI0=WIf@3i0=WI\nf@00203IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI00@0fMWI00@000000=WI\nf@3IfMT0fMWI0`0000000`000?l0fMWI0=WIf@3i0=WIf@00203IfMT010000000fMWI0=WIf@00000:\n0=WIf@030000003IfMT0fMWI0080fMWI0P0000040=WIf@040000003IfMT0fMWI0000oo/0fMWI0008\n0=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WI\nf@030=WIf@040000003IfMT0fMWI0000oo/0fMWI00090=WIf@8000002P3IfMT2000000@0fMWI0`00\n00030=WIf@040000003IfMT0fMWI0000oo/0fMWI000Q0=WIf@040000003IfMT0fMWI0000oo/0fMWI\n000Q0=WIf@040000003IfMT0fMWI0000oo/0fMWI000Q0=WIf@040000003IfMT0fMWI0000oo/0fMWI\n000Q0=WIf@80000000<0fMWI0000o`3IfMT0nP3IfMT00240fMWI00@000000=WIf@3IfMT0003on`3I\nfMT00240fMWI00@000000=WIf@3IfMT0003on`3IfMT00240fMWI00@000000=WIf@3IfMT0003on`3I\nfMT00240fMWI00@000000=WIf@3IfMT0003on`3IfMT00240fMWI00@000000=WIf@3IfMT0003on`3I\nfMT00240fMWI00@000000=WIf@3IfMT0003on`3IfMT00240fMWI0P0000000`3IfMT0003o0=WIf@3j\n0=WIf@008@3IfMT010000000fMWI0=WIf@000?ok0=WIf@008@3IfMT010000000fMWI0=WIf@000?ok\n0=WIf@008@3IfMT010000000fMWI0=WIf@000?ok0=WIf@008@3IfMT010000000fMWI0=WIf@000?ok\n0=WIf@008@3IfMT010000000fMWI0=WIf@000?ok0=WIf@008@3IfMT010000000fMWI0=WIf@000?ok\n0=WIf@008@3IfMT2000000030=WIf@000?l0fMWI0?X0fMWI000Q0=WIf@040000003IfMT0fMWI0000\noo/0fMWI000Q0=WIf@040000003IfMT0fMWI0000oo/0fMWI000Q0=WIf@040000003IfMT0fMWI0000\noo/0fMWI000Q0=WIf@040000003IfMT0fMWI0000oo/0fMWI000Q0=WIf@040000003IfMT0fMWI0000\noo/0fMWI000Q0=WIf@040000003IfMT0fMWI0000oo/0fMWI000Q0=WIf@80000000<0fMWI0000o`3I\nfMT0nP3IfMT00240fMWI00@000000=WIf@3IfMT0003on`3IfMT00240fMWI00@000000=WIf@3IfMT0\n003on`3IfMT00240fMWI00@000000=WIf@3IfMT0003on`3IfMT00240fMWI00@000000=WIf@3IfMT0\n003on`3IfMT000l0fMWI0P0000040=WIf@8000000`3IfMT4000000<0fMWI00@000000=WIf@3IfMT0\n003on`3IfMT000h0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@040=WIf@04\n0000003IfMT0fMWI0000oo/0fMWI000>0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WI\nf@3IfMT00`3IfMT40000oo/0fMWI000>0=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WI\nf@3IfMT00P3IfMT00`000000fMWI0=WIf@3l0=WIf@003P3IfMT010000000fMWI0=WIf@0000080=WI\nf@040000003IfMT0fMWI000000<0fMWI00<000000=WIf@3IfMT0o03IfMT000l0fMWI0P00000:0=WI\nf@800000103IfMT00`000000fMWI0=WIf@3l0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@009@3I\nfMT00`000000fMWI0=WIf@0P0=WIf@<000003@3IfMT00`000000fMWI0=WIf@050=WIf@800000203I\nfMT200000;@0fMWI000T0=WIf@030000003IfMT0fMWI0280fMWI00<000000=WIf@3IfMT03@3IfMT0\n0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0/P3IfMT0\n02<0fMWI00<000000=WIf@3IfMT00`3IfMT2000000<0fMWI1`0000020=WIf@@0000000<0fMWI0000\n000000000`3IfMT2000000@0fMWI0`0000030=WIf@<0000000<0fMWI0000000000000P3IfMT20000\n00<0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@800000103IfMT00`00\n0000fMWI0=WIf@2b0=WIf@008`3IfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0fMWI0000\n0080fMWI100000020=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@0000002@3IfMT0\n10000000fMWI0=WIf@0000040=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI\n0=WIf@020=WIf@030000003IfMT0fMWI00<0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@05\n0000003IfMT0fMWI0=WIf@000000]03IfMT001H0fMWI20000?l50=WIf@030000003IfMT0fMWI0080\nfMWI00<000000=WIf@3IfMT01P3IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI\n00<000002@3IfMT010000000fMWI0=WIf@0000040=WIf@050000003IfMT0fMWI0=WIf@0000000P3I\nfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00<0fMWI00D000000=WIf@3IfMT0fMWI\n000000060=WIf@030000003IfMT0fMWI0;80fMWI000S0=WIf@040000003IfMT0fMWI0=WIf@D00000\n0`3IfMT3000000030=WIf@0000000000008000000`3IfMT010000000fMWI0000000000090=WIf@@0\n00000`3IfMT00`000000fMWI0=WIf@04000000D0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000\nfMWI0=WIf@05000000<0fMWI00<000000=WIf@3IfMT0/P3IfMT002@0fMWI00D000000=WIf@3IfMT0\nfMWI0000000A0=WIf@030000003IfMT0fMWI0140fMWI00<000000=WIf@3IfMT0203IfMT00`000000\nfMWI0=WIf@040=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@2b0=WI\nf@009@3IfMT00`000000fMWI0=WIf@0A0=WIf@8000004P3IfMT3000000P0fMWI00<000000=WIf@3I\nfMT01@3IfMT2000000P0fMWI0P00002d0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-30.2449`, -0.0343405`, 0.890933`, 0.00144156`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell[BoxData[TagBox[RowBox[List[RowBox[List["\[SkeletonIndicator]", "Graphics"]], "\[SkeletonIndicator]"]], False, Rule[Editable, False]]], "Output"]], Open]], Cell[CellGroupData[List[Cell["New Tank Model", "Subsection"], Cell["model TankApplicationContinuousPInew\n  PIdiscreteController piDiscrete;\n  TankL  tankn(area=1,flowVout=0.02);\n  FlowOut outFlow;\nequation\n  connect(tankn.qOut,outFlow.qOut);\n  connect(tankn.tInp,piDiscrete.cOut);\n  connect(tankn.tOut,piDiscrete.cInp);\n  piDiscrete.ref=0.5;\nend TankApplicationContinuousPInew;", "ModelicaInput"], Cell["", "Text"], Cell["simulate( TankApplicationContinuousPInew, stopTime=200 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(TankApplicationContinuousPInew\\) : 2004-2-4 10:47:47.6346857 : \\!\\({0.`, 200.`}\\) : 4003 data points : 1 events : 22 variables>\\n\\!\\({\\*TagBox[\\(outFlow . flowVOut\\), HoldForm], \\*TagBox[\\(outFlow . qOut . lflow\\), HoldForm], \\*TagBox[\\(piDiscrete . cInp . val\\), HoldForm], \\*TagBox[\\(piDiscrete . cOut . act\\), HoldForm], \\*TagBox[\\(piDiscrete . error\\), HoldForm], \\*TagBox[\\(piDiscrete . K\\), HoldForm], \\*TagBox[\\(piDiscrete . maxV\\), HoldForm], \\*TagBox[\\(piDiscrete . minV\\), HoldForm], \\*TagBox[\\(piDiscrete . outCtr\\), HoldForm], \\*TagBox[\\(piDiscrete . ref\\), HoldForm], \\*TagBox[\\(piDiscrete . T\\), HoldForm], \\*TagBox[\\(piDiscrete . Ts\\), HoldForm], \\*TagBox[\\(piDiscrete . x\\), HoldForm], \\*TagBox[\\(tankn . area\\), HoldForm], \\*TagBox[\\(tankn . flowGain\\), HoldForm], \\*TagBox[\\(tankn . flowVout\\), HoldForm], \\*TagBox[\\(tankn . h\\), HoldForm], \\*TagBox[\\(tankn . qIn . lflow\\), HoldForm], \\*TagBox[\\(tankn . qOut . lflow\\), HoldForm], \\*TagBox[\\(tankn . tInp . act\\), HoldForm], \\*TagBox[\\(tankn . tOut . val\\), HoldForm], \\*TagBox[SuperscriptBox[\\((tankn . h)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( tankn.h );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.0047619 0.0147151 1.037 [\n[.2619 .00222 -6 -9 ]\n[.2619 .00222 6 0 ]\n[.5 .00222 -9 -9 ]\n[.5 .00222 9 0 ]\n[.7381 .00222 -9 -9 ]\n[.7381 .00222 9 0 ]\n[.97619 .00222 -9 -9 ]\n[.97619 .00222 9 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .11842 -18 -4.5 ]\n[.01131 .11842 0 4.5 ]\n[.01131 .22212 -18 -4.5 ]\n[.01131 .22212 0 4.5 ]\n[.01131 .32582 -18 -4.5 ]\n[.01131 .32582 0 4.5 ]\n[.01131 .42952 -18 -4.5 ]\n[.01131 .42952 0 4.5 ]\n[.01131 .53322 -18 -4.5 ]\n[.01131 .53322 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.2619 .01472 m\n.2619 .02097 L\ns\n[(50)] .2619 .00222 0 1 Mshowa\n.5 .01472 m\n.5 .02097 L\ns\n[(100)] .5 .00222 0 1 Mshowa\n.7381 .01472 m\n.7381 .02097 L\ns\n[(150)] .7381 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(200)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.07143 .01472 m\n.07143 .01847 L\ns\n.11905 .01472 m\n.11905 .01847 L\ns\n.16667 .01472 m\n.16667 .01847 L\ns\n.21429 .01472 m\n.21429 .01847 L\ns\n.30952 .01472 m\n.30952 .01847 L\ns\n.35714 .01472 m\n.35714 .01847 L\ns\n.40476 .01472 m\n.40476 .01847 L\ns\n.45238 .01472 m\n.45238 .01847 L\ns\n.54762 .01472 m\n.54762 .01847 L\ns\n.59524 .01472 m\n.59524 .01847 L\ns\n.64286 .01472 m\n.64286 .01847 L\ns\n.69048 .01472 m\n.69048 .01847 L\ns\n.78571 .01472 m\n.78571 .01847 L\ns\n.83333 .01472 m\n.83333 .01847 L\ns\n.88095 .01472 m\n.88095 .01847 L\ns\n.92857 .01472 m\n.92857 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .11842 m\n.03006 .11842 L\ns\n[(0.1)] .01131 .11842 1 0 Mshowa\n.02381 .22212 m\n.03006 .22212 L\ns\n[(0.2)] .01131 .22212 1 0 Mshowa\n.02381 .32582 m\n.03006 .32582 L\ns\n[(0.3)] .01131 .32582 1 0 Mshowa\n.02381 .42952 m\n.03006 .42952 L\ns\n[(0.4)] .01131 .42952 1 0 Mshowa\n.02381 .53322 m\n.03006 .53322 L\ns\n[(0.5)] .01131 .53322 1 0 Mshowa\n.125 Mabswid\n.02381 .03546 m\n.02756 .03546 L\ns\n.02381 .0562 m\n.02756 .0562 L\ns\n.02381 .07694 m\n.02756 .07694 L\ns\n.02381 .09768 m\n.02756 .09768 L\ns\n.02381 .13916 m\n.02756 .13916 L\ns\n.02381 .1599 m\n.02756 .1599 L\ns\n.02381 .18064 m\n.02756 .18064 L\ns\n.02381 .20138 m\n.02756 .20138 L\ns\n.02381 .24286 m\n.02756 .24286 L\ns\n.02381 .2636 m\n.02756 .2636 L\ns\n.02381 .28434 m\n.02756 .28434 L\ns\n.02381 .30508 m\n.02756 .30508 L\ns\n.02381 .34656 m\n.02756 .34656 L\ns\n.02381 .3673 m\n.02756 .3673 L\ns\n.02381 .38804 m\n.02756 .38804 L\ns\n.02381 .40878 m\n.02756 .40878 L\ns\n.02381 .45026 m\n.02756 .45026 L\ns\n.02381 .471 m\n.02756 .471 L\ns\n.02381 .49174 m\n.02756 .49174 L\ns\n.02381 .51248 m\n.02756 .51248 L\ns\n.02381 .55396 m\n.02756 .55396 L\ns\n.02381 .5747 m\n.02756 .5747 L\ns\n.02381 .59544 m\n.02756 .59544 L\ns\n.02381 .61618 m\n.02756 .61618 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02429 .03546 L\n.02429 .03546 L\n.02476 .0562 L\n.02476 .0562 L\n.02524 .07694 L\n.02524 .07694 L\n.02571 .09768 L\n.02571 .09768 L\n.02619 .11842 L\n.02619 .11842 L\n.02667 .13916 L\n.02667 .13916 L\n.02714 .1599 L\n.02714 .1599 L\n.02762 .18064 L\n.02762 .18064 L\n.0281 .20138 L\n.0281 .20138 L\n.02857 .22212 L\n.02857 .22212 L\n.02905 .24286 L\n.02905 .24286 L\n.02952 .2636 L\n.02952 .2636 L\n.03 .28434 L\n.03 .28434 L\n.03048 .30508 L\n.03048 .30508 L\n.03095 .32582 L\n.03095 .32582 L\n.03143 .34656 L\n.03143 .34656 L\n.0319 .3673 L\n.0319 .3673 L\n.03238 .38804 L\n.03238 .38804 L\n.03286 .40878 L\n.03286 .40878 L\n.03333 .42952 L\n.03333 .42952 L\n.03381 .45026 L\n.03381 .45026 L\n.03429 .471 L\n.03429 .471 L\n.03476 .49174 L\n.03476 .49174 L\n.03524 .51248 L\n.03524 .51248 L\n.03571 .53322 L\nMistroke\n.03571 .53322 L\n.03619 .55396 L\n.03619 .55396 L\n.03667 .5747 L\n.03667 .5747 L\n.03714 .59544 L\n.03714 .59544 L\n.03762 .60332 L\n.03762 .60332 L\n.0381 .60332 L\n.0381 .60332 L\n.03857 .60332 L\n.03857 .60332 L\n.03905 .60332 L\n.03905 .60332 L\n.03952 .60332 L\n.03952 .60332 L\n.04 .60332 L\n.04 .60332 L\n.04048 .60332 L\n.04048 .60332 L\n.04095 .60332 L\n.04095 .60332 L\n.04143 .60332 L\n.04143 .60332 L\n.0419 .60332 L\n.0419 .60332 L\n.04238 .60332 L\n.04238 .60332 L\n.04286 .60332 L\n.04286 .60332 L\n.04333 .60332 L\n.04333 .60332 L\n.04381 .60332 L\n.04381 .60332 L\n.04429 .60332 L\n.04429 .60332 L\n.04476 .60332 L\n.04476 .60332 L\n.04524 .60332 L\n.04524 .60332 L\n.04571 .60332 L\n.04571 .60332 L\n.04619 .60332 L\n.04619 .60332 L\n.04667 .60332 L\n.04667 .60332 L\n.04714 .60332 L\n.04714 .60332 L\n.04762 .60332 L\nMistroke\n.04762 .60332 L\n.0481 .60332 L\n.0481 .60332 L\n.04857 .60332 L\n.04857 .60332 L\n.04905 .60332 L\n.04905 .60332 L\n.04952 .60332 L\n.04952 .60332 L\n.05 .60332 L\n.05 .60332 L\n.05048 .60332 L\n.05048 .60332 L\n.05095 .60332 L\n.05095 .60332 L\n.05143 .60332 L\n.05143 .60332 L\n.0519 .60332 L\n.0519 .60332 L\n.05238 .60332 L\n.05238 .60332 L\n.05286 .60332 L\n.05286 .60332 L\n.05333 .60332 L\n.05333 .60332 L\n.05381 .60332 L\n.05381 .60332 L\n.05429 .60332 L\n.05429 .60332 L\n.05476 .60332 L\n.05476 .60332 L\n.05524 .60332 L\n.05524 .60332 L\n.05571 .60332 L\n.05571 .60332 L\n.05619 .60332 L\n.05619 .60332 L\n.05667 .60332 L\n.05667 .60332 L\n.05714 .60332 L\n.05714 .60332 L\n.05762 .60332 L\n.05762 .60332 L\n.0581 .60332 L\n.0581 .60332 L\n.05857 .60332 L\n.05857 .60332 L\n.05905 .60332 L\n.05905 .60332 L\n.05952 .60332 L\nMistroke\n.05952 .60332 L\n.06 .60332 L\n.06 .60332 L\n.06048 .60332 L\n.06048 .60332 L\n.06095 .60332 L\n.06095 .60332 L\n.06143 .60332 L\n.06143 .60332 L\n.0619 .60332 L\n.0619 .60332 L\n.06238 .60332 L\n.06238 .60332 L\n.06286 .60332 L\n.06286 .60332 L\n.06333 .60332 L\n.06333 .60332 L\n.06381 .60332 L\n.06381 .60332 L\n.06429 .60332 L\n.06429 .60332 L\n.06476 .60332 L\n.06476 .60332 L\n.06524 .60332 L\n.06524 .60332 L\n.06571 .60332 L\n.06571 .60332 L\n.06619 .60332 L\n.06619 .60332 L\n.06667 .60332 L\n.06667 .60332 L\n.06714 .60332 L\n.06714 .60332 L\n.06762 .60332 L\n.06762 .60332 L\n.0681 .60332 L\n.0681 .60332 L\n.06857 .60332 L\n.06857 .60332 L\n.06905 .60332 L\n.06905 .60332 L\n.06952 .60332 L\n.06952 .60332 L\n.07 .60332 L\n.07 .60332 L\n.07048 .60332 L\n.07048 .60332 L\n.07095 .60332 L\n.07095 .60332 L\n.07143 .60332 L\nMistroke\n.07143 .60332 L\n.0719 .60332 L\n.0719 .60332 L\n.07238 .60332 L\n.07238 .60332 L\n.07286 .60332 L\n.07286 .60332 L\n.07333 .60332 L\n.07333 .60332 L\n.07381 .60332 L\n.07381 .60332 L\n.07429 .60332 L\n.07429 .60332 L\n.07476 .60332 L\n.07476 .60332 L\n.07524 .60332 L\n.07524 .60332 L\n.07571 .60332 L\n.07571 .60332 L\n.07619 .60332 L\n.07619 .60332 L\n.07667 .60332 L\n.07667 .60332 L\n.07714 .60332 L\n.07714 .60332 L\n.07762 .60332 L\n.07762 .60332 L\n.0781 .60332 L\n.0781 .60332 L\n.07857 .60332 L\n.07857 .60332 L\n.07905 .60332 L\n.07905 .60332 L\n.07952 .60332 L\n.07952 .60332 L\n.08 .60332 L\n.08 .60332 L\n.08048 .60332 L\n.08048 .60332 L\n.08095 .60332 L\n.08095 .60332 L\n.08143 .60332 L\n.08143 .60332 L\n.0819 .60332 L\n.0819 .60332 L\n.08238 .60332 L\n.08238 .60332 L\n.08286 .60332 L\n.08286 .60332 L\n.08333 .60332 L\nMistroke\n.08333 .60332 L\n.08381 .60332 L\n.08381 .60332 L\n.08429 .60332 L\n.08429 .60332 L\n.08476 .60332 L\n.08476 .60332 L\n.08524 .60332 L\n.08524 .60332 L\n.08571 .60332 L\n.08571 .60332 L\n.08619 .60332 L\n.08619 .60332 L\n.08667 .60332 L\n.08667 .60332 L\n.08714 .60332 L\n.08714 .60332 L\n.08762 .60332 L\n.08762 .60332 L\n.0881 .60332 L\n.0881 .60332 L\n.08857 .60332 L\n.08857 .60332 L\n.08905 .60332 L\n.08905 .60332 L\n.08952 .60332 L\n.08952 .60332 L\n.09 .60332 L\n.09 .60332 L\n.09048 .60332 L\n.09048 .60332 L\n.09095 .60332 L\n.09095 .60332 L\n.09143 .60332 L\n.09143 .60332 L\n.0919 .60332 L\n.0919 .60332 L\n.09238 .60332 L\n.09238 .60332 L\n.09286 .60332 L\n.09286 .60332 L\n.09333 .60332 L\n.09333 .60332 L\n.09381 .60332 L\n.09381 .60332 L\n.09429 .60332 L\n.09429 .60332 L\n.09476 .60332 L\n.09476 .60332 L\n.09524 .60332 L\nMistroke\n.09524 .60332 L\n.09571 .60332 L\n.09571 .60332 L\n.09619 .60332 L\n.09619 .60332 L\n.09667 .60332 L\n.09667 .60332 L\n.09714 .60332 L\n.09714 .60332 L\n.09762 .60332 L\n.09762 .60332 L\n.0981 .60332 L\n.0981 .60332 L\n.09857 .60332 L\n.09857 .60332 L\n.09905 .60332 L\n.09905 .60332 L\n.09952 .60332 L\n.09952 .60332 L\n.1 .60332 L\n.1 .60332 L\n.10048 .60332 L\n.10048 .60332 L\n.10095 .60332 L\n.10095 .60332 L\n.10143 .60332 L\n.10143 .60332 L\n.1019 .60332 L\n.1019 .60332 L\n.10238 .60332 L\n.10238 .60332 L\n.10286 .60332 L\n.10286 .60332 L\n.10333 .60332 L\n.10333 .60332 L\n.10381 .60332 L\n.10381 .60332 L\n.10429 .60332 L\n.10429 .60332 L\n.10476 .60332 L\n.10476 .60332 L\n.10524 .60332 L\n.10524 .60332 L\n.10571 .60332 L\n.10571 .60332 L\n.10619 .60332 L\n.10619 .60332 L\n.10667 .60332 L\n.10667 .60332 L\n.10714 .60332 L\nMistroke\n.10714 .60332 L\n.10762 .60332 L\n.10762 .60332 L\n.1081 .60332 L\n.1081 .60332 L\n.10857 .60332 L\n.10857 .60332 L\n.10905 .60332 L\n.10905 .60332 L\n.10952 .60332 L\n.10952 .60332 L\n.11 .60332 L\n.11 .60332 L\n.11048 .60332 L\n.11048 .60332 L\n.11095 .60332 L\n.11095 .60332 L\n.11143 .60332 L\n.11143 .60332 L\n.1119 .60332 L\n.1119 .60332 L\n.11238 .60332 L\n.11238 .60332 L\n.11286 .60332 L\n.11286 .60332 L\n.11333 .60332 L\n.11333 .60332 L\n.11381 .60332 L\n.11381 .60332 L\n.11429 .60332 L\n.11429 .60332 L\n.11476 .60332 L\n.11476 .60332 L\n.11524 .60332 L\n.11524 .60332 L\n.11571 .60332 L\n.11571 .60332 L\n.11619 .60332 L\n.11619 .60332 L\n.11667 .60332 L\n.11667 .60332 L\n.11714 .60332 L\n.11714 .60332 L\n.11762 .60332 L\n.11762 .60332 L\n.1181 .60332 L\n.1181 .60332 L\n.11857 .60332 L\n.11857 .60332 L\n.11905 .60332 L\nMistroke\n.11905 .60332 L\n.11952 .60332 L\n.11952 .60332 L\n.12 .60332 L\n.12 .60332 L\n.12048 .60332 L\n.12048 .60332 L\n.12095 .60332 L\n.12095 .60332 L\n.12143 .60332 L\n.12143 .60332 L\n.1219 .60332 L\n.1219 .60332 L\n.12238 .60332 L\n.12238 .60332 L\n.12286 .60332 L\n.12286 .60332 L\n.12333 .60332 L\n.12333 .60332 L\n.12381 .60332 L\n.12381 .60332 L\n.12429 .60332 L\n.12429 .60332 L\n.12476 .60332 L\n.12476 .60332 L\n.12524 .60332 L\n.12524 .60332 L\n.12571 .60332 L\n.12571 .60332 L\n.12619 .60332 L\n.12619 .60332 L\n.12667 .60332 L\n.12667 .60332 L\n.12714 .60332 L\n.12714 .60332 L\n.12762 .60332 L\n.12762 .60332 L\n.1281 .60332 L\n.1281 .60332 L\n.12857 .60332 L\n.12857 .60332 L\n.12905 .60332 L\n.12905 .60332 L\n.12952 .60332 L\n.12952 .60332 L\n.13 .60332 L\n.13 .60332 L\n.13048 .60332 L\n.13048 .60332 L\n.13095 .60332 L\nMistroke\n.13095 .60332 L\n.13143 .60332 L\n.13143 .60332 L\n.1319 .60332 L\n.1319 .60332 L\n.13238 .60332 L\n.13238 .60332 L\n.13286 .60332 L\n.13286 .60332 L\n.13333 .60332 L\n.13333 .60332 L\n.13381 .60332 L\n.13381 .60332 L\n.13429 .60332 L\n.13429 .60332 L\n.13476 .60332 L\n.13476 .60332 L\n.13524 .60332 L\n.13524 .60332 L\n.13571 .60332 L\n.13571 .60332 L\n.13619 .60332 L\n.13619 .60332 L\n.13667 .60332 L\n.13667 .60332 L\n.13714 .60332 L\n.13714 .60332 L\n.13762 .60332 L\n.13762 .60332 L\n.1381 .60332 L\n.1381 .60332 L\n.13857 .60332 L\n.13857 .60332 L\n.13905 .60332 L\n.13905 .60332 L\n.13952 .60332 L\n.13952 .60332 L\n.14 .60332 L\n.14 .60332 L\n.14048 .60332 L\n.14048 .60332 L\n.14095 .60332 L\n.14095 .60332 L\n.14143 .60332 L\n.14143 .60332 L\n.1419 .60332 L\n.1419 .60332 L\n.14238 .60332 L\n.14238 .60332 L\n.14286 .60332 L\nMistroke\n.14286 .60332 L\n.14333 .60332 L\n.14333 .60332 L\n.14381 .60332 L\n.14381 .60332 L\n.14429 .60332 L\n.14429 .60332 L\n.14476 .60332 L\n.14476 .60332 L\n.14524 .60332 L\n.14524 .60332 L\n.14571 .60332 L\n.14571 .60332 L\n.14619 .60332 L\n.14619 .60332 L\n.14667 .60332 L\n.14667 .60332 L\n.14714 .60332 L\n.14714 .60332 L\n.14762 .60332 L\n.14762 .60332 L\n.1481 .60332 L\n.1481 .60332 L\n.14857 .60332 L\n.14857 .60332 L\n.14905 .60332 L\n.14905 .60332 L\n.14952 .60332 L\n.14952 .60332 L\n.15 .60332 L\n.15 .60332 L\n.15048 .60332 L\n.15048 .60332 L\n.15095 .60332 L\n.15095 .60332 L\n.15143 .60332 L\n.15143 .60332 L\n.1519 .60332 L\n.1519 .60332 L\n.15238 .60332 L\n.15238 .60332 L\n.15286 .60332 L\n.15286 .60332 L\n.15333 .60332 L\n.15333 .60332 L\n.15381 .60332 L\n.15381 .60332 L\n.15429 .60332 L\n.15429 .60332 L\n.15476 .60332 L\nMistroke\n.15476 .60332 L\n.15524 .60332 L\n.15524 .60332 L\n.15571 .60332 L\n.15571 .60332 L\n.15619 .60332 L\n.15619 .60332 L\n.15667 .60332 L\n.15667 .60332 L\n.15714 .60332 L\n.15714 .60332 L\n.15762 .60332 L\n.15762 .60332 L\n.1581 .60332 L\n.1581 .60332 L\n.15857 .60332 L\n.15857 .60332 L\n.15905 .60332 L\n.15905 .60332 L\n.15952 .60332 L\n.15952 .60332 L\n.16 .60332 L\n.16 .60332 L\n.16048 .60332 L\n.16048 .60332 L\n.16095 .60332 L\n.16095 .60332 L\n.16143 .60332 L\n.16143 .60332 L\n.1619 .60332 L\n.1619 .60332 L\n.16238 .60332 L\n.16238 .60332 L\n.16286 .60332 L\n.16286 .60332 L\n.16333 .60332 L\n.16333 .60332 L\n.16381 .60332 L\n.16381 .60332 L\n.16429 .60332 L\n.16429 .60332 L\n.16476 .60332 L\n.16476 .60332 L\n.16524 .60332 L\n.16524 .60332 L\n.16571 .60332 L\n.16571 .60332 L\n.16619 .60332 L\n.16619 .60332 L\n.16667 .60332 L\nMistroke\n.16667 .60332 L\n.16714 .60332 L\n.16714 .60332 L\n.16762 .60332 L\n.16762 .60332 L\n.1681 .60332 L\n.1681 .60332 L\n.16857 .60332 L\n.16857 .60332 L\n.16905 .60332 L\n.16905 .60332 L\n.16952 .60332 L\n.16952 .60332 L\n.17 .60332 L\n.17 .60332 L\n.17048 .60332 L\n.17048 .60332 L\n.17095 .60332 L\n.17095 .60332 L\n.17143 .60332 L\n.17143 .60332 L\n.1719 .60332 L\n.1719 .60332 L\n.17238 .60332 L\n.17238 .60332 L\n.17286 .60332 L\n.17286 .60332 L\n.17333 .60332 L\n.17333 .60332 L\n.17381 .60332 L\n.17381 .60332 L\n.17429 .60332 L\n.17429 .60332 L\n.17476 .60332 L\n.17476 .60332 L\n.17524 .60332 L\n.17524 .60332 L\n.17571 .60332 L\n.17571 .60332 L\n.17619 .60332 L\n.17619 .60332 L\n.17667 .60332 L\n.17667 .60332 L\n.17714 .60332 L\n.17714 .60332 L\n.17762 .60332 L\n.17762 .60332 L\n.1781 .60332 L\n.1781 .60332 L\n.17857 .60332 L\nMistroke\n.17857 .60332 L\n.17905 .60332 L\n.17905 .60332 L\n.17952 .60332 L\n.17952 .60332 L\n.18 .60332 L\n.18 .60332 L\n.18048 .60332 L\n.18048 .60332 L\n.18095 .60332 L\n.18095 .60332 L\n.18143 .60332 L\n.18143 .60332 L\n.1819 .60332 L\n.1819 .60332 L\n.18238 .60332 L\n.18238 .60332 L\n.18286 .60332 L\n.18286 .60332 L\n.18333 .60332 L\n.18333 .60332 L\n.18381 .60332 L\n.18381 .60332 L\n.18429 .60332 L\n.18429 .60332 L\n.18476 .60332 L\n.18476 .60332 L\n.18524 .60332 L\n.18524 .60332 L\n.18571 .60332 L\n.18571 .60332 L\n.18619 .60332 L\n.18619 .60332 L\n.18667 .60332 L\n.18667 .60332 L\n.18714 .60332 L\n.18714 .60332 L\n.18762 .60332 L\n.18762 .60332 L\n.1881 .60332 L\n.1881 .60332 L\n.18857 .60332 L\n.18857 .60332 L\n.18905 .60332 L\n.18905 .60332 L\n.18952 .60332 L\n.18952 .60332 L\n.19 .60332 L\n.19 .60332 L\n.19048 .60332 L\nMistroke\n.19048 .60332 L\n.19095 .60332 L\n.19095 .60332 L\n.19143 .60332 L\n.19143 .60332 L\n.1919 .60332 L\n.1919 .60332 L\n.19238 .60332 L\n.19238 .60332 L\n.19286 .60332 L\n.19286 .60332 L\n.19333 .60332 L\n.19333 .60332 L\n.19381 .60332 L\n.19381 .60332 L\n.19429 .60332 L\n.19429 .60332 L\n.19476 .60332 L\n.19476 .60332 L\n.19524 .60332 L\n.19524 .60332 L\n.19571 .60332 L\n.19571 .60332 L\n.19619 .60332 L\n.19619 .60332 L\n.19667 .60332 L\n.19667 .60332 L\n.19714 .60332 L\n.19714 .60332 L\n.19762 .60332 L\n.19762 .60332 L\n.1981 .60332 L\n.1981 .60332 L\n.19857 .60332 L\n.19857 .60332 L\n.19905 .60332 L\n.19905 .60332 L\n.19952 .60332 L\n.19952 .60332 L\n.2 .60332 L\n.2 .60332 L\n.20048 .60332 L\n.20048 .60332 L\n.20095 .60332 L\n.20095 .60332 L\n.20143 .60332 L\n.20143 .60332 L\n.2019 .60332 L\n.2019 .60332 L\n.20238 .60332 L\nMistroke\n.20238 .60332 L\n.20286 .60332 L\n.20286 .60332 L\n.20333 .60332 L\n.20333 .60332 L\n.20381 .60332 L\n.20381 .60332 L\n.20429 .60332 L\n.20429 .60332 L\n.20476 .60332 L\n.20476 .60332 L\n.20524 .60332 L\n.20524 .60332 L\n.20571 .60332 L\n.20571 .60332 L\n.20619 .60332 L\n.20619 .60332 L\n.20667 .60332 L\n.20667 .60332 L\n.20714 .60332 L\n.20714 .60332 L\n.20762 .60332 L\n.20762 .60332 L\n.2081 .60332 L\n.2081 .60332 L\n.20857 .60332 L\n.20857 .60332 L\n.20905 .60332 L\n.20905 .60332 L\n.20952 .60332 L\n.20952 .60332 L\n.21 .60332 L\n.21 .60332 L\n.21048 .60332 L\n.21048 .60332 L\n.21095 .60332 L\n.21095 .60332 L\n.21143 .60332 L\n.21143 .60332 L\n.2119 .60332 L\n.2119 .60332 L\n.21238 .60332 L\n.21238 .60332 L\n.21286 .60332 L\n.21286 .60332 L\n.21333 .60332 L\n.21333 .60332 L\n.21381 .60332 L\n.21381 .60332 L\n.21429 .60332 L\nMistroke\n.21429 .60332 L\n.21476 .60332 L\n.21476 .60332 L\n.21524 .60332 L\n.21524 .60332 L\n.21571 .60332 L\n.21571 .60332 L\n.21619 .60332 L\n.21619 .60332 L\n.21667 .60332 L\n.21667 .60332 L\n.21714 .60332 L\n.21714 .60332 L\n.21762 .60332 L\n.21762 .60332 L\n.2181 .60332 L\n.2181 .60332 L\n.21857 .60332 L\n.21857 .60332 L\n.21905 .60332 L\n.21905 .60332 L\n.21952 .60332 L\n.21952 .60332 L\n.22 .60332 L\n.22 .60332 L\n.22048 .60332 L\n.22048 .60332 L\n.22095 .60332 L\n.22095 .60332 L\n.22143 .60332 L\n.22143 .60332 L\n.2219 .60332 L\n.2219 .60332 L\n.22238 .60332 L\n.22238 .60332 L\n.22286 .60332 L\n.22286 .60332 L\n.22333 .60332 L\n.22333 .60332 L\n.22381 .60332 L\n.22381 .60332 L\n.22429 .60332 L\n.22429 .60332 L\n.22476 .60332 L\n.22476 .60332 L\n.22524 .60332 L\n.22524 .60332 L\n.22571 .60332 L\n.22571 .60332 L\n.22619 .60332 L\nMistroke\n.22619 .60332 L\n.22667 .60332 L\n.22667 .60332 L\n.22714 .60332 L\n.22714 .60332 L\n.22762 .60332 L\n.22762 .60332 L\n.2281 .60332 L\n.2281 .60332 L\n.22857 .60332 L\n.22857 .60332 L\n.22905 .60332 L\n.22905 .60332 L\n.22952 .60332 L\n.22952 .60332 L\n.23 .60332 L\n.23 .60332 L\n.23048 .60332 L\n.23048 .60332 L\n.23095 .60332 L\n.23095 .60332 L\n.23143 .60332 L\n.23143 .60332 L\n.2319 .60332 L\n.2319 .60332 L\n.23238 .60332 L\n.23238 .60332 L\n.23286 .60332 L\n.23286 .60332 L\n.23333 .60332 L\n.23333 .60332 L\n.23381 .60332 L\n.23381 .60332 L\n.23429 .60332 L\n.23429 .60332 L\n.23476 .60332 L\n.23476 .60332 L\n.23524 .60332 L\n.23524 .60332 L\n.23571 .60332 L\n.23571 .60332 L\n.23619 .60332 L\n.23619 .60332 L\n.23667 .60332 L\n.23667 .60332 L\n.23714 .60332 L\n.23714 .60332 L\n.23762 .60332 L\n.23762 .60332 L\n.2381 .60332 L\nMistroke\n.2381 .60332 L\n.23857 .60332 L\n.23857 .60332 L\n.23905 .60332 L\n.23905 .60332 L\n.23952 .60332 L\n.23952 .60332 L\n.24 .60332 L\n.24 .60332 L\n.24048 .60332 L\n.24048 .60332 L\n.24095 .60332 L\n.24095 .60332 L\n.24143 .60332 L\n.24143 .60332 L\n.2419 .60332 L\n.2419 .60332 L\n.24238 .60332 L\n.24238 .60332 L\n.24286 .60332 L\n.24286 .60332 L\n.24333 .60332 L\n.24333 .60332 L\n.24381 .60332 L\n.24381 .60332 L\n.24429 .60332 L\n.24429 .60332 L\n.24476 .60332 L\n.24476 .60332 L\n.24524 .60332 L\n.24524 .60332 L\n.24571 .60332 L\n.24571 .60332 L\n.24619 .60332 L\n.24619 .60332 L\n.24667 .60332 L\n.24667 .60332 L\n.24714 .60332 L\n.24714 .60332 L\n.24762 .60332 L\n.24762 .60332 L\n.2481 .60332 L\n.2481 .60332 L\n.24857 .60332 L\n.24857 .60332 L\n.24905 .60332 L\n.24905 .60332 L\n.24952 .60332 L\n.24952 .60332 L\n.25 .60332 L\nMistroke\n.25 .60332 L\n.25048 .60332 L\n.25048 .60332 L\n.25095 .60332 L\n.25095 .60332 L\n.25143 .60332 L\n.25143 .60332 L\n.2519 .60332 L\n.2519 .60332 L\n.25238 .60332 L\n.25238 .60332 L\n.25286 .60332 L\n.25286 .60332 L\n.25333 .60332 L\n.25333 .60332 L\n.25381 .60332 L\n.25381 .60332 L\n.25429 .60332 L\n.25429 .60332 L\n.25476 .60332 L\n.25476 .60332 L\n.25524 .60332 L\n.25524 .60332 L\n.25571 .60332 L\n.25571 .60332 L\n.25619 .60332 L\n.25619 .60332 L\n.25667 .60332 L\n.25667 .60332 L\n.25714 .60332 L\n.25714 .60332 L\n.25762 .60332 L\n.25762 .60332 L\n.2581 .60332 L\n.2581 .60332 L\n.25857 .60332 L\n.25857 .60332 L\n.25905 .60332 L\n.25905 .60332 L\n.25952 .60332 L\n.25952 .60332 L\n.26 .60332 L\n.26 .60332 L\n.26048 .60332 L\n.26048 .60332 L\n.26095 .60332 L\n.26095 .60332 L\n.26143 .60332 L\n.26143 .60332 L\n.2619 .60332 L\nMistroke\n.2619 .60332 L\n.26238 .60332 L\n.26238 .60332 L\n.26286 .60332 L\n.26286 .60332 L\n.26333 .60332 L\n.26333 .60332 L\n.26381 .60332 L\n.26381 .60332 L\n.26429 .60332 L\n.26429 .60332 L\n.26476 .60332 L\n.26476 .60332 L\n.26524 .60332 L\n.26524 .60332 L\n.26571 .60332 L\n.26571 .60332 L\n.26619 .60332 L\n.26619 .60332 L\n.26667 .60332 L\n.26667 .60332 L\n.26714 .60332 L\n.26714 .60332 L\n.26762 .60332 L\n.26762 .60332 L\n.2681 .60332 L\n.2681 .60332 L\n.26857 .60332 L\n.26857 .60332 L\n.26905 .60332 L\n.26905 .60332 L\n.26952 .60332 L\n.26952 .60332 L\n.27 .60332 L\n.27 .60332 L\n.27048 .60332 L\n.27048 .60332 L\n.27095 .60332 L\n.27095 .60332 L\n.27143 .60332 L\n.27143 .60332 L\n.2719 .60332 L\n.2719 .60332 L\n.27238 .60332 L\n.27238 .60332 L\n.27286 .60332 L\n.27286 .60332 L\n.27333 .60332 L\n.27333 .60332 L\n.27381 .60332 L\nMistroke\n.27381 .60332 L\n.27429 .60332 L\n.27429 .60332 L\n.27476 .60332 L\n.27476 .60332 L\n.27524 .60332 L\n.27524 .60332 L\n.27571 .60332 L\n.27571 .60332 L\n.27619 .60332 L\n.27619 .60332 L\n.27667 .60332 L\n.27667 .60332 L\n.27714 .60332 L\n.27714 .60332 L\n.27762 .60332 L\n.27762 .60332 L\n.2781 .60332 L\n.2781 .60332 L\n.27857 .60332 L\n.27857 .60332 L\n.27905 .60332 L\n.27905 .60332 L\n.27952 .60332 L\n.27952 .60332 L\n.28 .60332 L\n.28 .60332 L\n.28048 .60332 L\n.28048 .60332 L\n.28095 .60332 L\n.28095 .60332 L\n.28143 .60332 L\n.28143 .60332 L\n.2819 .60332 L\n.2819 .60332 L\n.28238 .60332 L\n.28238 .60332 L\n.28286 .60332 L\n.28286 .60332 L\n.28333 .60332 L\n.28333 .60332 L\n.28381 .60332 L\n.28381 .60332 L\n.28429 .60332 L\n.28429 .60332 L\n.28476 .60332 L\n.28476 .60332 L\n.28524 .60332 L\n.28524 .60332 L\n.28571 .60332 L\nMistroke\n.28571 .60332 L\n.28619 .60332 L\n.28619 .60332 L\n.28667 .60332 L\n.28667 .60332 L\n.28714 .60332 L\n.28714 .60332 L\n.28762 .60332 L\n.28762 .60332 L\n.2881 .60332 L\n.2881 .60332 L\n.28857 .60332 L\n.28857 .60332 L\n.28905 .60332 L\n.28905 .60332 L\n.28952 .60332 L\n.28952 .60332 L\n.29 .60332 L\n.29 .60332 L\n.29048 .60332 L\n.29048 .60332 L\n.29095 .60332 L\n.29095 .60332 L\n.29143 .60332 L\n.29143 .60332 L\n.2919 .60332 L\n.2919 .60332 L\n.29238 .60332 L\n.29238 .60332 L\n.29286 .60332 L\n.29286 .60332 L\n.29333 .60332 L\n.29333 .60332 L\n.29381 .60332 L\n.29381 .60332 L\n.29429 .60332 L\n.29429 .60332 L\n.29476 .60332 L\n.29476 .60332 L\n.29524 .60332 L\n.29524 .60332 L\n.29571 .60332 L\n.29571 .60332 L\n.29619 .60332 L\n.29619 .60332 L\n.29667 .60332 L\n.29667 .60332 L\n.29714 .60332 L\n.29714 .60332 L\n.29762 .60332 L\nMistroke\n.29762 .60332 L\n.2981 .60332 L\n.2981 .60332 L\n.29857 .60332 L\n.29857 .60332 L\n.29905 .60332 L\n.29905 .60332 L\n.29952 .60332 L\n.29952 .60332 L\n.3 .60332 L\n.3 .60332 L\n.30048 .60332 L\n.30048 .60332 L\n.30095 .60332 L\n.30095 .60332 L\n.30143 .60332 L\n.30143 .60332 L\n.3019 .60332 L\n.3019 .60332 L\n.30238 .60332 L\n.30238 .60332 L\n.30286 .60332 L\n.30286 .60332 L\n.30333 .60332 L\n.30333 .60332 L\n.30381 .60332 L\n.30381 .60332 L\n.30429 .60332 L\n.30429 .60332 L\n.30476 .60332 L\n.30476 .60332 L\n.30524 .60332 L\n.30524 .60332 L\n.30571 .60332 L\n.30571 .60332 L\n.30619 .60332 L\n.30619 .60332 L\n.30667 .60332 L\n.30667 .60332 L\n.30714 .60332 L\n.30714 .60332 L\n.30762 .60332 L\n.30762 .60332 L\n.3081 .60332 L\n.3081 .60332 L\n.30857 .60332 L\n.30857 .60332 L\n.30905 .60332 L\n.30905 .60332 L\n.30952 .60332 L\nMistroke\n.30952 .60332 L\n.31 .60332 L\n.31 .60332 L\n.31048 .60332 L\n.31048 .60332 L\n.31095 .60332 L\n.31095 .60332 L\n.31143 .60332 L\n.31143 .60332 L\n.3119 .60332 L\n.3119 .60332 L\n.31238 .60332 L\n.31238 .60332 L\n.31286 .60332 L\n.31286 .60332 L\n.31333 .60332 L\n.31333 .60332 L\n.31381 .60332 L\n.31381 .60332 L\n.31429 .60332 L\n.31429 .60332 L\n.31476 .60332 L\n.31476 .60332 L\n.31524 .60332 L\n.31524 .60332 L\n.31571 .60332 L\n.31571 .60332 L\n.31619 .60332 L\n.31619 .60332 L\n.31667 .60332 L\n.31667 .60332 L\n.31714 .60332 L\n.31714 .60332 L\n.31762 .60332 L\n.31762 .60332 L\n.3181 .60332 L\n.3181 .60332 L\n.31857 .60332 L\n.31857 .60332 L\n.31905 .60332 L\n.31905 .60332 L\n.31952 .60332 L\n.31952 .60332 L\n.32 .60332 L\n.32 .60332 L\n.32048 .60332 L\n.32048 .60332 L\n.32095 .60332 L\n.32095 .60332 L\n.32143 .60332 L\nMistroke\n.32143 .60332 L\n.3219 .60332 L\n.3219 .60332 L\n.32238 .60332 L\n.32238 .60332 L\n.32286 .60332 L\n.32286 .60332 L\n.32333 .60332 L\n.32333 .60332 L\n.32381 .60332 L\n.32381 .60332 L\n.32429 .60332 L\n.32429 .60332 L\n.32476 .60332 L\n.32476 .60332 L\n.32524 .60332 L\n.32524 .60332 L\n.32571 .60332 L\n.32571 .60332 L\n.32619 .60332 L\n.32619 .60332 L\n.32667 .60332 L\n.32667 .60332 L\n.32714 .60332 L\n.32714 .60332 L\n.32762 .60332 L\n.32762 .60332 L\n.3281 .60332 L\n.3281 .60332 L\n.32857 .60332 L\n.32857 .60332 L\n.32905 .60332 L\n.32905 .60332 L\n.32952 .60332 L\n.32952 .60332 L\n.33 .60332 L\n.33 .60332 L\n.33048 .60332 L\n.33048 .60332 L\n.33095 .60332 L\n.33095 .60332 L\n.33143 .60332 L\n.33143 .60332 L\n.3319 .60332 L\n.3319 .60332 L\n.33238 .60332 L\n.33238 .60332 L\n.33286 .60332 L\n.33286 .60332 L\n.33333 .60332 L\nMistroke\n.33333 .60332 L\n.33381 .60332 L\n.33381 .60332 L\n.33429 .60332 L\n.33429 .60332 L\n.33476 .60332 L\n.33476 .60332 L\n.33524 .60332 L\n.33524 .60332 L\n.33571 .60332 L\n.33571 .60332 L\n.33619 .60332 L\n.33619 .60332 L\n.33667 .60332 L\n.33667 .60332 L\n.33714 .60332 L\n.33714 .60332 L\n.33762 .60332 L\n.33762 .60332 L\n.3381 .60332 L\n.3381 .60332 L\n.33857 .60332 L\n.33857 .60332 L\n.33905 .60332 L\n.33905 .60332 L\n.33952 .60332 L\n.33952 .60332 L\n.34 .60332 L\n.34 .60332 L\n.34048 .60332 L\n.34048 .60332 L\n.34095 .60332 L\n.34095 .60332 L\n.34143 .60332 L\n.34143 .60332 L\n.3419 .60332 L\n.3419 .60332 L\n.34238 .60332 L\n.34238 .60332 L\n.34286 .60332 L\n.34286 .60332 L\n.34333 .60332 L\n.34333 .60332 L\n.34381 .60332 L\n.34381 .60332 L\n.34429 .60332 L\n.34429 .60332 L\n.34476 .60332 L\n.34476 .60332 L\n.34524 .60332 L\nMistroke\n.34524 .60332 L\n.34571 .60332 L\n.34571 .60332 L\n.34619 .60332 L\n.34619 .60332 L\n.34667 .60332 L\n.34667 .60332 L\n.34714 .60332 L\n.34714 .60332 L\n.34762 .60332 L\n.34762 .60332 L\n.3481 .60332 L\n.3481 .60332 L\n.34857 .60332 L\n.34857 .60332 L\n.34905 .60332 L\n.34905 .60332 L\n.34952 .60332 L\n.34952 .60332 L\n.35 .60332 L\n.35 .60332 L\n.35048 .60332 L\n.35048 .60332 L\n.35095 .60332 L\n.35095 .60332 L\n.35143 .60332 L\n.35143 .60332 L\n.3519 .60332 L\n.3519 .60332 L\n.35238 .60332 L\n.35238 .60332 L\n.35286 .60332 L\n.35286 .60332 L\n.35333 .60332 L\n.35333 .60332 L\n.35381 .60332 L\n.35381 .60332 L\n.35429 .60332 L\n.35429 .60332 L\n.35476 .60332 L\n.35476 .60332 L\n.35524 .60332 L\n.35524 .60332 L\n.35571 .60332 L\n.35571 .60332 L\n.35619 .60332 L\n.35619 .60332 L\n.35667 .60332 L\n.35667 .60332 L\n.35714 .60332 L\nMistroke\n.35714 .60332 L\n.35762 .60332 L\n.35762 .60332 L\n.3581 .60332 L\n.3581 .60332 L\n.35857 .60332 L\n.35857 .60332 L\n.35905 .60332 L\n.35905 .60332 L\n.35952 .60332 L\n.35952 .60332 L\n.36 .60332 L\n.36 .60332 L\n.36048 .60332 L\n.36048 .60332 L\n.36095 .60332 L\n.36095 .60332 L\n.36143 .60332 L\n.36143 .60332 L\n.3619 .60332 L\n.3619 .60332 L\n.36238 .60332 L\n.36238 .60332 L\n.36286 .60332 L\n.36286 .60332 L\n.36333 .60332 L\n.36333 .60332 L\n.36381 .60332 L\n.36381 .60332 L\n.36429 .60332 L\n.36429 .60332 L\n.36476 .60332 L\n.36476 .60332 L\n.36524 .60332 L\n.36524 .60332 L\n.36571 .60332 L\n.36571 .60332 L\n.36619 .60332 L\n.36619 .60332 L\n.36667 .60332 L\n.36667 .60332 L\n.36714 .60332 L\n.36714 .60332 L\n.36762 .60332 L\n.36762 .60332 L\n.3681 .60332 L\n.3681 .60332 L\n.36857 .60332 L\n.36857 .60332 L\n.36905 .60332 L\nMistroke\n.36905 .60332 L\n.36952 .60332 L\n.36952 .60332 L\n.37 .60332 L\n.37 .60332 L\n.37048 .60332 L\n.37048 .60332 L\n.37095 .60332 L\n.37095 .60332 L\n.37143 .60332 L\n.37143 .60332 L\n.3719 .60332 L\n.3719 .60332 L\n.37238 .60332 L\n.37238 .60332 L\n.37286 .60332 L\n.37286 .60332 L\n.37333 .60332 L\n.37333 .60332 L\n.37381 .60332 L\n.37381 .60332 L\n.37429 .60332 L\n.37429 .60332 L\n.37476 .60332 L\n.37476 .60332 L\n.37524 .60332 L\n.37524 .60332 L\n.37571 .60332 L\n.37571 .60332 L\n.37619 .60332 L\n.37619 .60332 L\n.37667 .60332 L\n.37667 .60332 L\n.37714 .60332 L\n.37714 .60332 L\n.37762 .60332 L\n.37762 .60332 L\n.3781 .60332 L\n.3781 .60332 L\n.37857 .60332 L\n.37857 .60332 L\n.37905 .60332 L\n.37905 .60332 L\n.37952 .60332 L\n.37952 .60332 L\n.38 .60332 L\n.38 .60332 L\n.38048 .60332 L\n.38048 .60332 L\n.38095 .60332 L\nMistroke\n.38095 .60332 L\n.38143 .60332 L\n.38143 .60332 L\n.3819 .60332 L\n.3819 .60332 L\n.38238 .60332 L\n.38238 .60332 L\n.38286 .60332 L\n.38286 .60332 L\n.38333 .60332 L\n.38333 .60332 L\n.38381 .60332 L\n.38381 .60332 L\n.38429 .60332 L\n.38429 .60332 L\n.38476 .60332 L\n.38476 .60332 L\n.38524 .60332 L\n.38524 .60332 L\n.38571 .60332 L\n.38571 .60332 L\n.38619 .60332 L\n.38619 .60332 L\n.38667 .60332 L\n.38667 .60332 L\n.38714 .60332 L\n.38714 .60332 L\n.38762 .60332 L\n.38762 .60332 L\n.3881 .60332 L\n.3881 .60332 L\n.38857 .60332 L\n.38857 .60332 L\n.38905 .60332 L\n.38905 .60332 L\n.38952 .60332 L\n.38952 .60332 L\n.39 .60332 L\n.39 .60332 L\n.39048 .60332 L\n.39048 .60332 L\n.39095 .60332 L\n.39095 .60332 L\n.39143 .60332 L\n.39143 .60332 L\n.3919 .60332 L\n.3919 .60332 L\n.39238 .60332 L\n.39238 .60332 L\n.39286 .60332 L\nMistroke\n.39286 .60332 L\n.39333 .60332 L\n.39333 .60332 L\n.39381 .60332 L\n.39381 .60332 L\n.39429 .60332 L\n.39429 .60332 L\n.39476 .60332 L\n.39476 .60332 L\n.39524 .60332 L\n.39524 .60332 L\n.39571 .60332 L\n.39571 .60332 L\n.39619 .60332 L\n.39619 .60332 L\n.39667 .60332 L\n.39667 .60332 L\n.39714 .60332 L\n.39714 .60332 L\n.39762 .60332 L\n.39762 .60332 L\n.3981 .60332 L\n.3981 .60332 L\n.39857 .60332 L\n.39857 .60332 L\n.39905 .60332 L\n.39905 .60332 L\n.39952 .60332 L\n.39952 .60332 L\n.4 .60332 L\n.4 .60332 L\n.40048 .60332 L\n.40048 .60332 L\n.40095 .60332 L\n.40095 .60332 L\n.40143 .60332 L\n.40143 .60332 L\n.4019 .60332 L\n.4019 .60332 L\n.40238 .60332 L\n.40238 .60332 L\n.40286 .60332 L\n.40286 .60332 L\n.40333 .60332 L\n.40333 .60332 L\n.40381 .60332 L\n.40381 .60332 L\n.40429 .60332 L\n.40429 .60332 L\n.40476 .60332 L\nMistroke\n.40476 .60332 L\n.40524 .60332 L\n.40524 .60332 L\n.40571 .60332 L\n.40571 .60332 L\n.40619 .60332 L\n.40619 .60332 L\n.40667 .60332 L\n.40667 .60332 L\n.40714 .60332 L\n.40714 .60332 L\n.40762 .60332 L\n.40762 .60332 L\n.4081 .60332 L\n.4081 .60332 L\n.40857 .60332 L\n.40857 .60332 L\n.40905 .60332 L\n.40905 .60332 L\n.40952 .60332 L\n.40952 .60332 L\n.41 .60332 L\n.41 .60332 L\n.41048 .60332 L\n.41048 .60332 L\n.41095 .60332 L\n.41095 .60332 L\n.41143 .60332 L\n.41143 .60332 L\n.4119 .60332 L\n.4119 .60332 L\n.41238 .60332 L\n.41238 .60332 L\n.41286 .60332 L\n.41286 .60332 L\n.41333 .60332 L\n.41333 .60332 L\n.41381 .60332 L\n.41381 .60332 L\n.41429 .60332 L\n.41429 .60332 L\n.41476 .60332 L\n.41476 .60332 L\n.41524 .60332 L\n.41524 .60332 L\n.41571 .60332 L\n.41571 .60332 L\n.41619 .60332 L\n.41619 .60332 L\n.41667 .60332 L\nMistroke\n.41667 .60332 L\n.41714 .60332 L\n.41714 .60332 L\n.41762 .60332 L\n.41762 .60332 L\n.4181 .60332 L\n.4181 .60332 L\n.41857 .60332 L\n.41857 .60332 L\n.41905 .60332 L\n.41905 .60332 L\n.41952 .60332 L\n.41952 .60332 L\n.42 .60332 L\n.42 .60332 L\n.42048 .60332 L\n.42048 .60332 L\n.42095 .60332 L\n.42095 .60332 L\n.42143 .60332 L\n.42143 .60332 L\n.4219 .60332 L\n.4219 .60332 L\n.42238 .60332 L\n.42238 .60332 L\n.42286 .60332 L\n.42286 .60332 L\n.42333 .60332 L\n.42333 .60332 L\n.42381 .60332 L\n.42381 .60332 L\n.42429 .60332 L\n.42429 .60332 L\n.42476 .60332 L\n.42476 .60332 L\n.42524 .60332 L\n.42524 .60332 L\n.42571 .60332 L\n.42571 .60332 L\n.42619 .60332 L\n.42619 .60332 L\n.42667 .60332 L\n.42667 .60332 L\n.42714 .60332 L\n.42714 .60332 L\n.42762 .60332 L\n.42762 .60332 L\n.4281 .60332 L\n.4281 .60332 L\n.42857 .60332 L\nMistroke\n.42857 .60332 L\n.42905 .60332 L\n.42905 .60332 L\n.42952 .60332 L\n.42952 .60332 L\n.43 .60332 L\n.43 .60332 L\n.43048 .60332 L\n.43048 .60332 L\n.43095 .60332 L\n.43095 .60332 L\n.43143 .60332 L\n.43143 .60332 L\n.4319 .60332 L\n.4319 .60332 L\n.43238 .60332 L\n.43238 .60332 L\n.43286 .60332 L\n.43286 .60332 L\n.43333 .60332 L\n.43333 .60332 L\n.43381 .60332 L\n.43381 .60332 L\n.43429 .60332 L\n.43429 .60332 L\n.43476 .60332 L\n.43476 .60332 L\n.43524 .60332 L\n.43524 .60332 L\n.43571 .60332 L\n.43571 .60332 L\n.43619 .60332 L\n.43619 .60332 L\n.43667 .60332 L\n.43667 .60332 L\n.43714 .60332 L\n.43714 .60332 L\n.43762 .60332 L\n.43762 .60332 L\n.4381 .60332 L\n.4381 .60332 L\n.43857 .60332 L\n.43857 .60332 L\n.43905 .60332 L\n.43905 .60332 L\n.43952 .60332 L\n.43952 .60332 L\n.44 .60332 L\n.44 .60332 L\n.44048 .60332 L\nMistroke\n.44048 .60332 L\n.44095 .60332 L\n.44095 .60332 L\n.44143 .60332 L\n.44143 .60332 L\n.4419 .60332 L\n.4419 .60332 L\n.44238 .60332 L\n.44238 .60332 L\n.44286 .60332 L\n.44286 .60332 L\n.44333 .60332 L\n.44333 .60332 L\n.44381 .60332 L\n.44381 .60332 L\n.44429 .60332 L\n.44429 .60332 L\n.44476 .60332 L\n.44476 .60332 L\n.44524 .60332 L\n.44524 .60332 L\n.44571 .60332 L\n.44571 .60332 L\n.44619 .60332 L\n.44619 .60332 L\n.44667 .60332 L\n.44667 .60332 L\n.44714 .60332 L\n.44714 .60332 L\n.44762 .60332 L\n.44762 .60332 L\n.4481 .60332 L\n.4481 .60332 L\n.44857 .60332 L\n.44857 .60332 L\n.44905 .60332 L\n.44905 .60332 L\n.44952 .60332 L\n.44952 .60332 L\n.45 .60332 L\n.45 .60332 L\n.45048 .60332 L\n.45048 .60332 L\n.45095 .60332 L\n.45095 .60332 L\n.45143 .60332 L\n.45143 .60332 L\n.4519 .60332 L\n.4519 .60332 L\n.45238 .60332 L\nMistroke\n.45238 .60332 L\n.45286 .60332 L\n.45286 .60332 L\n.45333 .60332 L\n.45333 .60332 L\n.45381 .60332 L\n.45381 .60332 L\n.45429 .60332 L\n.45429 .60332 L\n.45476 .60332 L\n.45476 .60332 L\n.45524 .60332 L\n.45524 .60332 L\n.45571 .60332 L\n.45571 .60332 L\n.45619 .60332 L\n.45619 .60332 L\n.45667 .60332 L\n.45667 .60332 L\n.45714 .60332 L\n.45714 .60332 L\n.45762 .60332 L\n.45762 .60332 L\n.4581 .60332 L\n.4581 .60332 L\n.45857 .60332 L\n.45857 .60332 L\n.45905 .60332 L\n.45905 .60332 L\n.45952 .60332 L\n.45952 .60332 L\n.46 .60332 L\n.46 .60332 L\n.46048 .60332 L\n.46048 .60332 L\n.46095 .60332 L\n.46095 .60332 L\n.46143 .60332 L\n.46143 .60332 L\n.4619 .60332 L\n.4619 .60332 L\n.46238 .60332 L\n.46238 .60332 L\n.46286 .60332 L\n.46286 .60332 L\n.46333 .60332 L\n.46333 .60332 L\n.46381 .60332 L\n.46381 .60332 L\n.46429 .60332 L\nMistroke\n.46429 .60332 L\n.46476 .60332 L\n.46476 .60332 L\n.46524 .60332 L\n.46524 .60332 L\n.46571 .60332 L\n.46571 .60332 L\n.46619 .60332 L\n.46619 .60332 L\n.46667 .60332 L\n.46667 .60332 L\n.46714 .60332 L\n.46714 .60332 L\n.46762 .60332 L\n.46762 .60332 L\n.4681 .60332 L\n.4681 .60332 L\n.46857 .60332 L\n.46857 .60332 L\n.46905 .60332 L\n.46905 .60332 L\n.46952 .60332 L\n.46952 .60332 L\n.47 .60332 L\n.47 .60332 L\n.47048 .60332 L\n.47048 .60332 L\n.47095 .60332 L\n.47095 .60332 L\n.47143 .60332 L\n.47143 .60332 L\n.4719 .60332 L\n.4719 .60332 L\n.47238 .60332 L\n.47238 .60332 L\n.47286 .60332 L\n.47286 .60332 L\n.47333 .60332 L\n.47333 .60332 L\n.47381 .60332 L\n.47381 .60332 L\n.47429 .60332 L\n.47429 .60332 L\n.47476 .60332 L\n.47476 .60332 L\n.47524 .60332 L\n.47524 .60332 L\n.47571 .60332 L\n.47571 .60332 L\n.47619 .60332 L\nMistroke\n.47619 .60332 L\n.47667 .60332 L\n.47667 .60332 L\n.47714 .60332 L\n.47714 .60332 L\n.47762 .60332 L\n.47762 .60332 L\n.4781 .60332 L\n.4781 .60332 L\n.47857 .60332 L\n.47857 .60332 L\n.47905 .60332 L\n.47905 .60332 L\n.47952 .60332 L\n.47952 .60332 L\n.48 .60332 L\n.48 .60332 L\n.48048 .60332 L\n.48048 .60332 L\n.48095 .60332 L\n.48095 .60332 L\n.48143 .60332 L\n.48143 .60332 L\n.4819 .60332 L\n.4819 .60332 L\n.48238 .60332 L\n.48238 .60332 L\n.48286 .60332 L\n.48286 .60332 L\n.48333 .60332 L\n.48333 .60332 L\n.48381 .60332 L\n.48381 .60332 L\n.48429 .60332 L\n.48429 .60332 L\n.48476 .60332 L\n.48476 .60332 L\n.48524 .60332 L\n.48524 .60332 L\n.48571 .60332 L\n.48571 .60332 L\n.48619 .60332 L\n.48619 .60332 L\n.48667 .60332 L\n.48667 .60332 L\n.48714 .60332 L\n.48714 .60332 L\n.48762 .60332 L\n.48762 .60332 L\n.4881 .60332 L\nMistroke\n.4881 .60332 L\n.48857 .60332 L\n.48857 .60332 L\n.48905 .60332 L\n.48905 .60332 L\n.48952 .60332 L\n.48952 .60332 L\n.49 .60332 L\n.49 .60332 L\n.49048 .60332 L\n.49048 .60332 L\n.49095 .60332 L\n.49095 .60332 L\n.49143 .60332 L\n.49143 .60332 L\n.4919 .60332 L\n.4919 .60332 L\n.49238 .60332 L\n.49238 .60332 L\n.49286 .60332 L\n.49286 .60332 L\n.49333 .60332 L\n.49333 .60332 L\n.49381 .60332 L\n.49381 .60332 L\n.49429 .60332 L\n.49429 .60332 L\n.49476 .60332 L\n.49476 .60332 L\n.49524 .60332 L\n.49524 .60332 L\n.49571 .60332 L\n.49571 .60332 L\n.49619 .60332 L\n.49619 .60332 L\n.49667 .60332 L\n.49667 .60332 L\n.49714 .60332 L\n.49714 .60332 L\n.49762 .60332 L\n.49762 .60332 L\n.4981 .60332 L\n.4981 .60332 L\n.49857 .60332 L\n.49857 .60332 L\n.49905 .60332 L\n.49905 .60332 L\n.49952 .60332 L\n.49952 .60332 L\n.5 .60332 L\nMistroke\n.5 .60332 L\n.5 .60332 L\n.5 .60332 L\n.50048 .60228 L\n.50048 .60228 L\n.50095 .60124 L\n.50095 .60124 L\n.50143 .60021 L\n.50143 .60021 L\n.5019 .59917 L\n.5019 .59917 L\n.50238 .59813 L\n.50238 .59813 L\n.50286 .5971 L\n.50286 .5971 L\n.50333 .59606 L\n.50333 .59606 L\n.50381 .59502 L\n.50381 .59502 L\n.50429 .59399 L\n.50429 .59399 L\n.50476 .59295 L\n.50476 .59295 L\n.50524 .59191 L\n.50524 .59191 L\n.50571 .59087 L\n.50571 .59087 L\n.50619 .58984 L\n.50619 .58984 L\n.50667 .5888 L\n.50667 .5888 L\n.50714 .58776 L\n.50714 .58776 L\n.50762 .58673 L\n.50762 .58673 L\n.5081 .58569 L\n.5081 .58569 L\n.50857 .58465 L\n.50857 .58465 L\n.50905 .58362 L\n.50905 .58362 L\n.50952 .58258 L\n.50952 .58258 L\n.51 .58154 L\n.51 .58154 L\n.51048 .5805 L\n.51048 .5805 L\n.51095 .57947 L\n.51095 .57947 L\n.51143 .57843 L\nMistroke\n.51143 .57843 L\n.5119 .57739 L\n.5119 .57739 L\n.51238 .57636 L\n.51238 .57636 L\n.51286 .57532 L\n.51286 .57532 L\n.51333 .57428 L\n.51333 .57428 L\n.51381 .57325 L\n.51381 .57325 L\n.51429 .57221 L\n.51429 .57221 L\n.51476 .57117 L\n.51476 .57117 L\n.51524 .57013 L\n.51524 .57013 L\n.51571 .5691 L\n.51571 .5691 L\n.51619 .56806 L\n.51619 .56806 L\n.51667 .56702 L\n.51667 .56702 L\n.51714 .56599 L\n.51714 .56599 L\n.51762 .56495 L\n.51762 .56495 L\n.5181 .56391 L\n.5181 .56391 L\n.51857 .56288 L\n.51857 .56288 L\n.51905 .56184 L\n.51905 .56184 L\n.51952 .5608 L\n.51952 .5608 L\n.52 .55976 L\n.52 .55976 L\n.52048 .55873 L\n.52048 .55873 L\n.52095 .55769 L\n.52095 .55769 L\n.52143 .55665 L\n.52143 .55665 L\n.5219 .55562 L\n.5219 .55562 L\n.52238 .55458 L\n.52238 .55458 L\n.52286 .55354 L\n.52286 .55354 L\n.52333 .55251 L\nMistroke\n.52333 .55251 L\n.52381 .55147 L\n.52381 .55147 L\n.52429 .55043 L\n.52429 .55043 L\n.52476 .54939 L\n.52476 .54939 L\n.52524 .54836 L\n.52524 .54836 L\n.52571 .54732 L\n.52571 .54732 L\n.52619 .54628 L\n.52619 .54628 L\n.52667 .54525 L\n.52667 .54525 L\n.52714 .54421 L\n.52714 .54421 L\n.52762 .54317 L\n.52762 .54317 L\n.5281 .54214 L\n.5281 .54214 L\n.52857 .5411 L\n.52857 .5411 L\n.52905 .54006 L\n.52905 .54006 L\n.52952 .53902 L\n.52952 .53902 L\n.53 .53799 L\n.53 .53799 L\n.53048 .53695 L\n.53048 .53695 L\n.53095 .53591 L\n.53095 .53591 L\n.53143 .53488 L\n.53143 .53488 L\n.5319 .53384 L\n.5319 .53384 L\n.53238 .5328 L\n.53238 .5328 L\n.53286 .53177 L\n.53286 .53177 L\n.53333 .53073 L\n.53333 .53073 L\n.53381 .52969 L\n.53381 .52969 L\n.53429 .52865 L\n.53429 .52865 L\n.53476 .52762 L\n.53476 .52762 L\n.53524 .52658 L\nMistroke\n.53524 .52658 L\n.53571 .52554 L\n.53571 .52554 L\n.53619 .52451 L\n.53619 .52451 L\n.53667 .52347 L\n.53667 .52347 L\n.53714 .52243 L\n.53714 .52243 L\n.53762 .5214 L\n.53762 .5214 L\n.5381 .52036 L\n.5381 .52036 L\n.53857 .51932 L\n.53857 .51932 L\n.53905 .51828 L\n.53905 .51828 L\n.53952 .51725 L\n.53952 .51725 L\n.54 .51621 L\n.54 .51621 L\n.54048 .51517 L\n.54048 .51517 L\n.54095 .51414 L\n.54095 .51414 L\n.54143 .5131 L\n.54143 .5131 L\n.5419 .51206 L\n.5419 .51206 L\n.54238 .51103 L\n.54238 .51103 L\n.54286 .50999 L\n.54286 .50999 L\n.54333 .50895 L\n.54333 .50895 L\n.54381 .50791 L\n.54381 .50791 L\n.54429 .50688 L\n.54429 .50688 L\n.54476 .50584 L\n.54476 .50584 L\n.54524 .5048 L\n.54524 .5048 L\n.54571 .50377 L\n.54571 .50377 L\n.54619 .50273 L\n.54619 .50273 L\n.54667 .50169 L\n.54667 .50169 L\n.54714 .50066 L\nMistroke\n.54714 .50066 L\n.54762 .49962 L\n.54762 .49962 L\n.5481 .49858 L\n.5481 .49858 L\n.54857 .49754 L\n.54857 .49754 L\n.54905 .49651 L\n.54905 .49651 L\n.54952 .49547 L\n.54952 .49547 L\n.55 .49443 L\n.55 .49443 L\n.55048 .4934 L\n.55048 .4934 L\n.55095 .49236 L\n.55095 .49236 L\n.55143 .49132 L\n.55143 .49132 L\n.5519 .49029 L\n.5519 .49029 L\n.55238 .48925 L\n.55238 .48925 L\n.55286 .48821 L\n.55286 .48821 L\n.55333 .48717 L\n.55333 .48717 L\n.55381 .48614 L\n.55381 .48614 L\n.55429 .4851 L\n.55429 .4851 L\n.55476 .48406 L\n.55476 .48406 L\n.55524 .48303 L\n.55524 .48303 L\n.55571 .48199 L\n.55571 .48199 L\n.55619 .48095 L\n.55619 .48095 L\n.55667 .47992 L\n.55667 .47992 L\n.55714 .47888 L\n.55714 .47888 L\n.55762 .47784 L\n.55762 .47784 L\n.5581 .4768 L\n.5581 .4768 L\n.55857 .47577 L\n.55857 .47577 L\n.55905 .47473 L\nMistroke\n.55905 .47473 L\n.55952 .47369 L\n.55952 .47369 L\n.56 .47266 L\n.56 .47266 L\n.56048 .47162 L\n.56048 .47162 L\n.56095 .47058 L\n.56095 .47058 L\n.56143 .46955 L\n.56143 .46955 L\n.5619 .46851 L\n.5619 .46851 L\n.56238 .46747 L\n.56238 .46747 L\n.56286 .46643 L\n.56286 .46643 L\n.56333 .4654 L\n.56333 .4654 L\n.56381 .46436 L\n.56381 .46436 L\n.56429 .46332 L\n.56429 .46332 L\n.56476 .46229 L\n.56476 .46229 L\n.56524 .46125 L\n.56524 .46125 L\n.56571 .46021 L\n.56571 .46021 L\n.56619 .45918 L\n.56619 .45918 L\n.56667 .45814 L\n.56667 .45814 L\n.56714 .4571 L\n.56714 .4571 L\n.56762 .45606 L\n.56762 .45606 L\n.5681 .45503 L\n.5681 .45503 L\n.56857 .45399 L\n.56857 .45399 L\n.56905 .45295 L\n.56905 .45295 L\n.56952 .45192 L\n.56952 .45192 L\n.57 .45088 L\n.57 .45088 L\n.57048 .44984 L\n.57048 .44984 L\n.57095 .44881 L\nMistroke\n.57095 .44881 L\n.57143 .44777 L\n.57143 .44777 L\n.5719 .44673 L\n.5719 .44673 L\n.57238 .44569 L\n.57238 .44569 L\n.57286 .44466 L\n.57286 .44466 L\n.57333 .44362 L\n.57333 .44362 L\n.57381 .44258 L\n.57381 .44258 L\n.57429 .44155 L\n.57429 .44155 L\n.57476 .44051 L\n.57476 .44051 L\n.57524 .43947 L\n.57524 .43947 L\n.57571 .43844 L\n.57571 .43844 L\n.57619 .4374 L\n.57619 .4374 L\n.57667 .43636 L\n.57667 .43636 L\n.57714 .43532 L\n.57714 .43532 L\n.57762 .43429 L\n.57762 .43429 L\n.5781 .43325 L\n.5781 .43325 L\n.57857 .43221 L\n.57857 .43221 L\n.57905 .43118 L\n.57905 .43118 L\n.57952 .43014 L\n.57952 .43014 L\n.58 .4291 L\n.58 .4291 L\n.58048 .42807 L\n.58048 .42807 L\n.58095 .42703 L\n.58095 .42703 L\n.58143 .42599 L\n.58143 .42599 L\n.5819 .42495 L\n.5819 .42495 L\n.58238 .42392 L\n.58238 .42392 L\n.58286 .42288 L\nMistroke\n.58286 .42288 L\n.58333 .42184 L\n.58333 .42184 L\n.58381 .42081 L\n.58381 .42081 L\n.58429 .41977 L\n.58429 .41977 L\n.58476 .41873 L\n.58476 .41873 L\n.58524 .4177 L\n.58524 .4177 L\n.58571 .41666 L\n.58571 .41666 L\n.58619 .41562 L\n.58619 .41562 L\n.58667 .41458 L\n.58667 .41458 L\n.58714 .41355 L\n.58714 .41355 L\n.58762 .41251 L\n.58762 .41251 L\n.5881 .41147 L\n.5881 .41147 L\n.58857 .41044 L\n.58857 .41044 L\n.58905 .4094 L\n.58905 .4094 L\n.58952 .40836 L\n.58952 .40836 L\n.59 .40733 L\n.59 .40733 L\n.59048 .40629 L\n.59048 .40629 L\n.59095 .40525 L\n.59095 .40525 L\n.59143 .40421 L\n.59143 .40421 L\n.5919 .40318 L\n.5919 .40318 L\n.59238 .40214 L\n.59238 .40214 L\n.59286 .4011 L\n.59286 .4011 L\n.59333 .40007 L\n.59333 .40007 L\n.59381 .39903 L\n.59381 .39903 L\n.59429 .39799 L\n.59429 .39799 L\n.59476 .39695 L\nMistroke\n.59476 .39695 L\n.59524 .39592 L\n.59524 .39592 L\n.59571 .39488 L\n.59571 .39488 L\n.59619 .39384 L\n.59619 .39384 L\n.59667 .39281 L\n.59667 .39281 L\n.59714 .39177 L\n.59714 .39177 L\n.59762 .39073 L\n.59762 .39073 L\n.5981 .3897 L\n.5981 .3897 L\n.59857 .38866 L\n.59857 .38866 L\n.59905 .38762 L\n.59905 .38762 L\n.59952 .38658 L\n.59952 .38658 L\n.6 .38555 L\n.6 .38555 L\n.60048 .38451 L\n.60048 .38451 L\n.60095 .38347 L\n.60095 .38347 L\n.60143 .38244 L\n.60143 .38244 L\n.6019 .3814 L\n.6019 .3814 L\n.60238 .38036 L\n.60238 .38036 L\n.60286 .37933 L\n.60286 .37933 L\n.60333 .37829 L\n.60333 .37829 L\n.60381 .37725 L\n.60381 .37725 L\n.60429 .37621 L\n.60429 .37621 L\n.60476 .37518 L\n.60476 .37518 L\n.60524 .37414 L\n.60524 .37414 L\n.60571 .3731 L\n.60571 .3731 L\n.60619 .37207 L\n.60619 .37207 L\n.60667 .37103 L\nMistroke\n.60667 .37103 L\n.60714 .36999 L\n.60714 .36999 L\n.60762 .36896 L\n.60762 .36896 L\n.6081 .36792 L\n.6081 .36792 L\n.60857 .36688 L\n.60857 .36688 L\n.60905 .36584 L\n.60905 .36584 L\n.60952 .36481 L\n.60952 .36481 L\n.61 .36377 L\n.61 .36377 L\n.61048 .36273 L\n.61048 .36273 L\n.61095 .3617 L\n.61095 .3617 L\n.61143 .36066 L\n.61143 .36066 L\n.6119 .35962 L\n.6119 .35962 L\n.61238 .35859 L\n.61238 .35859 L\n.61286 .35755 L\n.61286 .35755 L\n.61333 .35651 L\n.61333 .35651 L\n.61381 .35547 L\n.61381 .35547 L\n.61429 .35444 L\n.61429 .35444 L\n.61476 .3534 L\n.61476 .3534 L\n.61524 .35236 L\n.61524 .35236 L\n.61571 .35133 L\n.61571 .35133 L\n.61619 .35029 L\n.61619 .35029 L\n.61667 .34925 L\n.61667 .34925 L\n.61714 .34822 L\n.61714 .34822 L\n.61762 .34718 L\n.61762 .34718 L\n.6181 .34614 L\n.6181 .34614 L\n.61857 .3451 L\nMistroke\n.61857 .3451 L\n.61905 .34407 L\n.61905 .34407 L\n.61952 .34303 L\n.61952 .34303 L\n.62 .34199 L\n.62 .34199 L\n.62048 .34096 L\n.62048 .34096 L\n.62095 .33992 L\n.62095 .33992 L\n.62143 .33888 L\n.62143 .33888 L\n.6219 .33785 L\n.6219 .33785 L\n.62238 .33681 L\n.62238 .33681 L\n.62286 .33577 L\n.62286 .33577 L\n.62333 .33473 L\n.62333 .33473 L\n.62381 .3337 L\n.62381 .3337 L\n.62429 .33266 L\n.62429 .33266 L\n.62476 .33162 L\n.62476 .33162 L\n.62524 .33059 L\n.62524 .33059 L\n.62571 .32955 L\n.62571 .32955 L\n.62619 .32851 L\n.62619 .32851 L\n.62667 .32748 L\n.62667 .32748 L\n.62714 .32644 L\n.62714 .32644 L\n.62762 .3254 L\n.62762 .3254 L\n.6281 .32436 L\n.6281 .32436 L\n.62857 .32333 L\n.62857 .32333 L\n.62905 .32229 L\n.62905 .32229 L\n.62952 .32125 L\n.62952 .32125 L\n.63 .32022 L\n.63 .32022 L\n.63048 .31918 L\nMistroke\n.63048 .31918 L\n.63095 .31814 L\n.63095 .31814 L\n.63143 .31711 L\n.63143 .31711 L\n.6319 .31607 L\n.6319 .31607 L\n.63238 .31503 L\n.63238 .31503 L\n.63286 .31399 L\n.63286 .31399 L\n.63333 .31296 L\n.63333 .31296 L\n.63381 .31192 L\n.63381 .31192 L\n.63429 .31088 L\n.63429 .31088 L\n.63476 .30985 L\n.63476 .30985 L\n.63524 .30881 L\n.63524 .30881 L\n.63571 .30777 L\n.63571 .30777 L\n.63619 .30674 L\n.63619 .30674 L\n.63667 .3057 L\n.63667 .3057 L\n.63714 .30466 L\n.63714 .30466 L\n.63762 .30362 L\n.63762 .30362 L\n.6381 .30259 L\n.6381 .30259 L\n.63857 .30155 L\n.63857 .30155 L\n.63905 .30051 L\n.63905 .30051 L\n.63952 .29948 L\n.63952 .29948 L\n.64 .29844 L\n.64 .29844 L\n.64048 .2974 L\n.64048 .2974 L\n.64095 .29637 L\n.64095 .29637 L\n.64143 .29533 L\n.64143 .29533 L\n.6419 .29429 L\n.6419 .29429 L\n.64238 .29325 L\nMistroke\n.64238 .29325 L\n.64286 .29222 L\n.64286 .29222 L\n.64333 .29118 L\n.64333 .29118 L\n.64381 .29014 L\n.64381 .29014 L\n.64429 .28911 L\n.64429 .28911 L\n.64476 .28807 L\n.64476 .28807 L\n.64524 .28703 L\n.64524 .28703 L\n.64571 .286 L\n.64571 .286 L\n.64619 .28496 L\n.64619 .28496 L\n.64667 .28392 L\n.64667 .28392 L\n.64714 .28288 L\n.64714 .28288 L\n.64762 .28185 L\n.64762 .28185 L\n.6481 .28081 L\n.6481 .28081 L\n.64857 .27977 L\n.64857 .27977 L\n.64905 .27874 L\n.64905 .27874 L\n.64952 .2777 L\n.64952 .2777 L\n.65 .27666 L\n.65 .27666 L\n.65048 .27563 L\n.65048 .27563 L\n.65095 .27459 L\n.65095 .27459 L\n.65143 .27355 L\n.65143 .27355 L\n.6519 .27251 L\n.6519 .27251 L\n.65238 .27148 L\n.65238 .27148 L\n.65286 .27044 L\n.65286 .27044 L\n.65333 .2694 L\n.65333 .2694 L\n.65381 .26837 L\n.65381 .26837 L\n.65429 .26733 L\nMistroke\n.65429 .26733 L\n.65476 .26629 L\n.65476 .26629 L\n.65524 .26526 L\n.65524 .26526 L\n.65571 .26422 L\n.65571 .26422 L\n.65619 .26318 L\n.65619 .26318 L\n.65667 .26214 L\n.65667 .26214 L\n.65714 .26111 L\n.65714 .26111 L\n.65762 .26007 L\n.65762 .26007 L\n.6581 .25903 L\n.6581 .25903 L\n.65857 .258 L\n.65857 .258 L\n.65905 .26345 L\n.65905 .26345 L\n.65952 .26339 L\n.65952 .26339 L\n.66 .26885 L\n.66 .26885 L\n.66048 .26868 L\n.66048 .26868 L\n.66095 .27414 L\n.66095 .27414 L\n.66143 .27386 L\n.66143 .27386 L\n.6619 .27933 L\n.6619 .27933 L\n.66238 .27894 L\n.66238 .27894 L\n.66286 .28441 L\n.66286 .28441 L\n.66333 .28391 L\n.66333 .28391 L\n.66381 .2894 L\n.66381 .2894 L\n.66429 .28879 L\n.66429 .28879 L\n.66476 .29429 L\n.66476 .29429 L\n.66524 .29357 L\n.66524 .29357 L\n.66571 .29908 L\n.66571 .29908 L\n.66619 .29825 L\nMistroke\n.66619 .29825 L\n.66667 .30378 L\n.66667 .30378 L\n.66714 .30284 L\n.66714 .30284 L\n.66762 .30839 L\n.66762 .30839 L\n.6681 .30735 L\n.6681 .30735 L\n.66857 .31289 L\n.66857 .31289 L\n.66905 .31186 L\n.66905 .31186 L\n.66952 .31722 L\n.66952 .31722 L\n.67 .31618 L\n.67 .31618 L\n.67048 .32155 L\n.67048 .32155 L\n.67095 .32052 L\n.67095 .32052 L\n.67143 .32571 L\n.67143 .32571 L\n.6719 .32467 L\n.6719 .32467 L\n.67238 .32987 L\n.67238 .32987 L\n.67286 .32884 L\n.67286 .32884 L\n.67333 .33386 L\n.67333 .33386 L\n.67381 .33282 L\n.67381 .33282 L\n.67429 .33787 L\n.67429 .33787 L\n.67476 .33683 L\n.67476 .33683 L\n.67524 .3417 L\n.67524 .3417 L\n.67571 .34066 L\n.67571 .34066 L\n.67619 .34555 L\n.67619 .34555 L\n.67667 .34451 L\n.67667 .34451 L\n.67714 .34923 L\n.67714 .34923 L\n.67762 .34819 L\n.67762 .34819 L\n.6781 .35293 L\nMistroke\n.6781 .35293 L\n.67857 .35189 L\n.67857 .35189 L\n.67905 .35646 L\n.67905 .35646 L\n.67952 .35543 L\n.67952 .35543 L\n.68 .36002 L\n.68 .36002 L\n.68048 .35898 L\n.68048 .35898 L\n.68095 .36341 L\n.68095 .36341 L\n.68143 .36237 L\n.68143 .36237 L\n.6819 .36683 L\n.6819 .36683 L\n.68238 .36579 L\n.68238 .36579 L\n.68286 .37009 L\n.68286 .37009 L\n.68333 .36905 L\n.68333 .36905 L\n.68381 .37337 L\n.68381 .37337 L\n.68429 .37233 L\n.68429 .37233 L\n.68476 .37651 L\n.68476 .37651 L\n.68524 .37547 L\n.68524 .37547 L\n.68571 .37966 L\n.68571 .37966 L\n.68619 .37862 L\n.68619 .37862 L\n.68667 .38267 L\n.68667 .38267 L\n.68714 .38163 L\n.68714 .38163 L\n.68762 .3857 L\n.68762 .3857 L\n.6881 .38466 L\n.6881 .38466 L\n.68857 .38859 L\n.68857 .38859 L\n.68905 .38756 L\n.68905 .38756 L\n.68952 .39151 L\n.68952 .39151 L\n.69 .39047 L\nMistroke\n.69 .39047 L\n.69048 .39428 L\n.69048 .39428 L\n.69095 .39325 L\n.69095 .39325 L\n.69143 .39708 L\n.69143 .39708 L\n.6919 .39604 L\n.6919 .39604 L\n.69238 .39975 L\n.69238 .39975 L\n.69286 .39871 L\n.69286 .39871 L\n.69333 .40244 L\n.69333 .40244 L\n.69381 .4014 L\n.69381 .4014 L\n.69429 .405 L\n.69429 .405 L\n.69476 .40397 L\n.69476 .40397 L\n.69524 .40759 L\n.69524 .40759 L\n.69571 .40655 L\n.69571 .40655 L\n.69619 .41005 L\n.69619 .41005 L\n.69667 .40901 L\n.69667 .40901 L\n.69714 .41253 L\n.69714 .41253 L\n.69762 .4115 L\n.69762 .4115 L\n.6981 .4149 L\n.6981 .4149 L\n.69857 .41386 L\n.69857 .41386 L\n.69905 .41729 L\n.69905 .41729 L\n.69952 .41625 L\n.69952 .41625 L\n.7 .41956 L\n.7 .41956 L\n.70048 .41852 L\n.70048 .41852 L\n.70095 .42185 L\n.70095 .42185 L\n.70143 .42082 L\n.70143 .42082 L\n.7019 .42403 L\nMistroke\n.7019 .42403 L\n.70238 .423 L\n.70238 .423 L\n.70286 .42624 L\n.70286 .42624 L\n.70333 .4252 L\n.70333 .4252 L\n.70381 .42834 L\n.70381 .42834 L\n.70429 .4273 L\n.70429 .4273 L\n.70476 .43045 L\n.70476 .43045 L\n.70524 .42942 L\n.70524 .42942 L\n.70571 .43247 L\n.70571 .43247 L\n.70619 .43143 L\n.70619 .43143 L\n.70667 .4345 L\n.70667 .4345 L\n.70714 .43347 L\n.70714 .43347 L\n.70762 .43644 L\n.70762 .43644 L\n.7081 .4354 L\n.7081 .4354 L\n.70857 .4384 L\n.70857 .4384 L\n.70905 .43736 L\n.70905 .43736 L\n.70952 .44025 L\n.70952 .44025 L\n.71 .43922 L\n.71 .43922 L\n.71048 .44213 L\n.71048 .44213 L\n.71095 .4411 L\n.71095 .4411 L\n.71143 .44392 L\n.71143 .44392 L\n.7119 .44288 L\n.7119 .44288 L\n.71238 .44573 L\n.71238 .44573 L\n.71286 .44469 L\n.71286 .44469 L\n.71333 .44744 L\n.71333 .44744 L\n.71381 .4464 L\nMistroke\n.71381 .4464 L\n.71429 .44918 L\n.71429 .44918 L\n.71476 .44814 L\n.71476 .44814 L\n.71524 .45082 L\n.71524 .45082 L\n.71571 .44979 L\n.71571 .44979 L\n.71619 .45249 L\n.71619 .45249 L\n.71667 .45145 L\n.71667 .45145 L\n.71714 .45407 L\n.71714 .45407 L\n.71762 .45304 L\n.71762 .45304 L\n.7181 .45568 L\n.7181 .45568 L\n.71857 .45464 L\n.71857 .45464 L\n.71905 .4572 L\n.71905 .4572 L\n.71952 .45616 L\n.71952 .45616 L\n.72 .45874 L\n.72 .45874 L\n.72048 .4577 L\n.72048 .4577 L\n.72095 .4602 L\n.72095 .4602 L\n.72143 .45916 L\n.72143 .45916 L\n.7219 .46168 L\n.7219 .46168 L\n.72238 .46064 L\n.72238 .46064 L\n.72286 .46308 L\n.72286 .46308 L\n.72333 .46204 L\n.72333 .46204 L\n.72381 .4645 L\n.72381 .4645 L\n.72429 .46347 L\n.72429 .46347 L\n.72476 .46585 L\n.72476 .46585 L\n.72524 .46481 L\n.72524 .46481 L\n.72571 .46722 L\nMistroke\n.72571 .46722 L\n.72619 .46618 L\n.72619 .46618 L\n.72667 .46851 L\n.72667 .46851 L\n.72714 .46748 L\n.72714 .46748 L\n.72762 .46983 L\n.72762 .46983 L\n.7281 .46879 L\n.7281 .46879 L\n.72857 .47107 L\n.72857 .47107 L\n.72905 .47003 L\n.72905 .47003 L\n.72952 .47233 L\n.72952 .47233 L\n.73 .4713 L\n.73 .4713 L\n.73048 .47353 L\n.73048 .47353 L\n.73095 .47249 L\n.73095 .47249 L\n.73143 .47474 L\n.73143 .47474 L\n.7319 .4737 L\n.7319 .4737 L\n.73238 .47589 L\n.73238 .47589 L\n.73286 .47485 L\n.73286 .47485 L\n.73333 .47705 L\n.73333 .47705 L\n.73381 .47602 L\n.73381 .47602 L\n.73429 .47815 L\n.73429 .47815 L\n.73476 .47712 L\n.73476 .47712 L\n.73524 .47928 L\n.73524 .47928 L\n.73571 .47824 L\n.73571 .47824 L\n.73619 .48033 L\n.73619 .48033 L\n.73667 .4793 L\n.73667 .4793 L\n.73714 .48141 L\n.73714 .48141 L\n.73762 .48037 L\nMistroke\n.73762 .48037 L\n.7381 .48243 L\n.7381 .48243 L\n.73857 .48139 L\n.73857 .48139 L\n.73905 .48346 L\n.73905 .48346 L\n.73952 .48243 L\n.73952 .48243 L\n.74 .48444 L\n.74 .48444 L\n.74048 .4834 L\n.74048 .4834 L\n.74095 .48543 L\n.74095 .48543 L\n.74143 .4844 L\n.74143 .4844 L\n.7419 .48637 L\n.7419 .48637 L\n.74238 .48533 L\n.74238 .48533 L\n.74286 .48733 L\n.74286 .48733 L\n.74333 .48629 L\n.74333 .48629 L\n.74381 .48823 L\n.74381 .48823 L\n.74429 .48719 L\n.74429 .48719 L\n.74476 .48915 L\n.74476 .48915 L\n.74524 .48811 L\n.74524 .48811 L\n.74571 .49001 L\n.74571 .49001 L\n.74619 .48898 L\n.74619 .48898 L\n.74667 .4909 L\n.74667 .4909 L\n.74714 .48986 L\n.74714 .48986 L\n.74762 .49173 L\n.74762 .49173 L\n.7481 .49069 L\n.7481 .49069 L\n.74857 .49258 L\n.74857 .49258 L\n.74905 .49154 L\n.74905 .49154 L\n.74952 .49337 L\nMistroke\n.74952 .49337 L\n.75 .49234 L\n.75 .49234 L\n.75048 .49419 L\n.75048 .49419 L\n.75095 .49315 L\n.75095 .49315 L\n.75143 .49496 L\n.75143 .49496 L\n.7519 .49392 L\n.7519 .49392 L\n.75238 .49574 L\n.75238 .49574 L\n.75286 .4947 L\n.75286 .4947 L\n.75333 .49648 L\n.75333 .49648 L\n.75381 .49544 L\n.75381 .49544 L\n.75429 .49723 L\n.75429 .49723 L\n.75476 .49619 L\n.75476 .49619 L\n.75524 .49794 L\n.75524 .49794 L\n.75571 .4969 L\n.75571 .4969 L\n.75619 .49866 L\n.75619 .49866 L\n.75667 .49763 L\n.75667 .49763 L\n.75714 .49934 L\n.75714 .49934 L\n.75762 .4983 L\n.75762 .4983 L\n.7581 .50004 L\n.7581 .50004 L\n.75857 .499 L\n.75857 .499 L\n.75905 .50069 L\n.75905 .50069 L\n.75952 .49965 L\n.75952 .49965 L\n.76 .50136 L\n.76 .50136 L\n.76048 .50032 L\n.76048 .50032 L\n.76095 .50198 L\n.76095 .50198 L\n.76143 .50095 L\nMistroke\n.76143 .50095 L\n.7619 .50263 L\n.7619 .50263 L\n.76238 .50159 L\n.76238 .50159 L\n.76286 .50323 L\n.76286 .50323 L\n.76333 .50219 L\n.76333 .50219 L\n.76381 .50385 L\n.76381 .50385 L\n.76429 .50281 L\n.76429 .50281 L\n.76476 .50442 L\n.76476 .50442 L\n.76524 .50339 L\n.76524 .50339 L\n.76571 .50502 L\n.76571 .50502 L\n.76619 .50398 L\n.76619 .50398 L\n.76667 .50557 L\n.76667 .50557 L\n.76714 .50454 L\n.76714 .50454 L\n.76762 .50615 L\n.76762 .50615 L\n.7681 .50511 L\n.7681 .50511 L\n.76857 .50668 L\n.76857 .50668 L\n.76905 .50564 L\n.76905 .50564 L\n.76952 .50723 L\n.76952 .50723 L\n.77 .50619 L\n.77 .50619 L\n.77048 .50774 L\n.77048 .50774 L\n.77095 .5067 L\n.77095 .5067 L\n.77143 .50827 L\n.77143 .50827 L\n.7719 .50723 L\n.7719 .50723 L\n.77238 .50876 L\n.77238 .50876 L\n.77286 .50772 L\n.77286 .50772 L\n.77333 .50927 L\nMistroke\n.77333 .50927 L\n.77381 .50823 L\n.77381 .50823 L\n.77429 .50974 L\n.77429 .50974 L\n.77476 .5087 L\n.77476 .5087 L\n.77524 .51023 L\n.77524 .51023 L\n.77571 .50919 L\n.77571 .50919 L\n.77619 .51068 L\n.77619 .51068 L\n.77667 .50964 L\n.77667 .50964 L\n.77714 .51115 L\n.77714 .51115 L\n.77762 .51011 L\n.77762 .51011 L\n.7781 .51158 L\n.7781 .51158 L\n.77857 .51054 L\n.77857 .51054 L\n.77905 .51203 L\n.77905 .51203 L\n.77952 .511 L\n.77952 .511 L\n.78 .51245 L\n.78 .51245 L\n.78048 .51141 L\n.78048 .51141 L\n.78095 .51289 L\n.78095 .51289 L\n.78143 .51185 L\n.78143 .51185 L\n.7819 .51328 L\n.7819 .51328 L\n.78238 .51225 L\n.78238 .51225 L\n.78286 .5137 L\n.78286 .5137 L\n.78333 .51267 L\n.78333 .51267 L\n.78381 .51409 L\n.78381 .51409 L\n.78429 .51305 L\n.78429 .51305 L\n.78476 .51449 L\n.78476 .51449 L\n.78524 .51345 L\nMistroke\n.78524 .51345 L\n.78571 .51486 L\n.78571 .51486 L\n.78619 .51382 L\n.78619 .51382 L\n.78667 .51524 L\n.78667 .51524 L\n.78714 .51421 L\n.78714 .51421 L\n.78762 .5156 L\n.78762 .5156 L\n.7881 .51456 L\n.7881 .51456 L\n.78857 .51597 L\n.78857 .51597 L\n.78905 .51493 L\n.78905 .51493 L\n.78952 .51631 L\n.78952 .51631 L\n.79 .51527 L\n.79 .51527 L\n.79048 .51667 L\n.79048 .51667 L\n.79095 .51563 L\n.79095 .51563 L\n.79143 .51699 L\n.79143 .51699 L\n.7919 .51595 L\n.7919 .51595 L\n.79238 .51734 L\n.79238 .51734 L\n.79286 .5163 L\n.79286 .5163 L\n.79333 .51765 L\n.79333 .51765 L\n.79381 .51661 L\n.79381 .51661 L\n.79429 .51798 L\n.79429 .51798 L\n.79476 .51694 L\n.79476 .51694 L\n.79524 .51828 L\n.79524 .51828 L\n.79571 .51724 L\n.79571 .51724 L\n.79619 .5186 L\n.79619 .5186 L\n.79667 .51756 L\n.79667 .51756 L\n.79714 .51888 L\nMistroke\n.79714 .51888 L\n.79762 .51785 L\n.79762 .51785 L\n.7981 .51919 L\n.7981 .51919 L\n.79857 .51815 L\n.79857 .51815 L\n.79905 .51947 L\n.79905 .51947 L\n.79952 .51843 L\n.79952 .51843 L\n.8 .51976 L\n.8 .51976 L\n.80048 .51872 L\n.80048 .51872 L\n.80095 .52002 L\n.80095 .52002 L\n.80143 .51899 L\n.80143 .51899 L\n.8019 .52031 L\n.8019 .52031 L\n.80238 .51927 L\n.80238 .51927 L\n.80286 .52056 L\n.80286 .52056 L\n.80333 .51952 L\n.80333 .51952 L\n.80381 .52084 L\n.80381 .52084 L\n.80429 .5198 L\n.80429 .5198 L\n.80476 .52108 L\n.80476 .52108 L\n.80524 .52004 L\n.80524 .52004 L\n.80571 .52134 L\n.80571 .52134 L\n.80619 .5203 L\n.80619 .5203 L\n.80667 .52157 L\n.80667 .52157 L\n.80714 .52054 L\n.80714 .52054 L\n.80762 .52183 L\n.80762 .52183 L\n.8081 .52079 L\n.8081 .52079 L\n.80857 .52205 L\n.80857 .52205 L\n.80905 .52101 L\nMistroke\n.80905 .52101 L\n.80952 .52229 L\n.80952 .52229 L\n.81 .52126 L\n.81 .52126 L\n.81048 .52251 L\n.81048 .52251 L\n.81095 .52147 L\n.81095 .52147 L\n.81143 .52274 L\n.81143 .52274 L\n.8119 .52171 L\n.8119 .52171 L\n.81238 .52295 L\n.81238 .52295 L\n.81286 .52191 L\n.81286 .52191 L\n.81333 .52317 L\n.81333 .52317 L\n.81381 .52214 L\n.81381 .52214 L\n.81429 .52337 L\n.81429 .52337 L\n.81476 .52233 L\n.81476 .52233 L\n.81524 .52359 L\n.81524 .52359 L\n.81571 .52255 L\n.81571 .52255 L\n.81619 .52378 L\n.81619 .52378 L\n.81667 .52274 L\n.81667 .52274 L\n.81714 .52399 L\n.81714 .52399 L\n.81762 .52295 L\n.81762 .52295 L\n.8181 .52417 L\n.8181 .52417 L\n.81857 .52313 L\n.81857 .52313 L\n.81905 .52437 L\n.81905 .52437 L\n.81952 .52333 L\n.81952 .52333 L\n.82 .52454 L\n.82 .52454 L\n.82048 .52351 L\n.82048 .52351 L\n.82095 .52474 L\nMistroke\n.82095 .52474 L\n.82143 .5237 L\n.82143 .5237 L\n.8219 .5249 L\n.8219 .5249 L\n.82238 .52387 L\n.82238 .52387 L\n.82286 .52509 L\n.82286 .52509 L\n.82333 .52405 L\n.82333 .52405 L\n.82381 .52525 L\n.82381 .52525 L\n.82429 .52421 L\n.82429 .52421 L\n.82476 .52543 L\n.82476 .52543 L\n.82524 .52439 L\n.82524 .52439 L\n.82571 .52558 L\n.82571 .52558 L\n.82619 .52454 L\n.82619 .52454 L\n.82667 .52576 L\n.82667 .52576 L\n.82714 .52472 L\n.82714 .52472 L\n.82762 .5259 L\n.82762 .5259 L\n.8281 .52486 L\n.8281 .52486 L\n.82857 .52607 L\n.82857 .52607 L\n.82905 .52503 L\n.82905 .52503 L\n.82952 .52621 L\n.82952 .52621 L\n.83 .52517 L\n.83 .52517 L\n.83048 .52637 L\n.83048 .52637 L\n.83095 .52533 L\n.83095 .52533 L\n.83143 .5265 L\n.83143 .5265 L\n.8319 .52547 L\n.8319 .52547 L\n.83238 .52666 L\n.83238 .52666 L\n.83286 .52562 L\nMistroke\n.83286 .52562 L\n.83333 .52679 L\n.83333 .52679 L\n.83381 .52575 L\n.83381 .52575 L\n.83429 .52694 L\n.83429 .52694 L\n.83476 .5259 L\n.83476 .5259 L\n.83524 .52706 L\n.83524 .52706 L\n.83571 .52602 L\n.83571 .52602 L\n.83619 .5272 L\n.83619 .5272 L\n.83667 .52617 L\n.83667 .52617 L\n.83714 .52732 L\n.83714 .52732 L\n.83762 .52628 L\n.83762 .52628 L\n.8381 .52746 L\n.8381 .52746 L\n.83857 .52642 L\n.83857 .52642 L\n.83905 .52757 L\n.83905 .52757 L\n.83952 .52654 L\n.83952 .52654 L\n.84 .52771 L\n.84 .52771 L\n.84048 .52667 L\n.84048 .52667 L\n.84095 .52781 L\n.84095 .52781 L\n.84143 .52678 L\n.84143 .52678 L\n.8419 .52794 L\n.8419 .52794 L\n.84238 .52691 L\n.84238 .52691 L\n.84286 .52805 L\n.84286 .52805 L\n.84333 .52701 L\n.84333 .52701 L\n.84381 .52817 L\n.84381 .52817 L\n.84429 .52713 L\n.84429 .52713 L\n.84476 .52827 L\nMistroke\n.84476 .52827 L\n.84524 .52723 L\n.84524 .52723 L\n.84571 .52839 L\n.84571 .52839 L\n.84619 .52735 L\n.84619 .52735 L\n.84667 .52848 L\n.84667 .52848 L\n.84714 .52745 L\n.84714 .52745 L\n.84762 .5286 L\n.84762 .5286 L\n.8481 .52756 L\n.8481 .52756 L\n.84857 .52869 L\n.84857 .52869 L\n.84905 .52765 L\n.84905 .52765 L\n.84952 .5288 L\n.84952 .5288 L\n.85 .52776 L\n.85 .52776 L\n.85048 .52889 L\n.85048 .52889 L\n.85095 .52785 L\n.85095 .52785 L\n.85143 .52899 L\n.85143 .52899 L\n.8519 .52796 L\n.8519 .52796 L\n.85238 .52908 L\n.85238 .52908 L\n.85286 .52804 L\n.85286 .52804 L\n.85333 .52918 L\n.85333 .52918 L\n.85381 .52814 L\n.85381 .52814 L\n.85429 .52926 L\n.85429 .52926 L\n.85476 .52822 L\n.85476 .52822 L\n.85524 .52936 L\n.85524 .52936 L\n.85571 .52832 L\n.85571 .52832 L\n.85619 .52943 L\n.85619 .52943 L\n.85667 .5284 L\nMistroke\n.85667 .5284 L\n.85714 .52953 L\n.85714 .52953 L\n.85762 .52849 L\n.85762 .52849 L\n.8581 .5296 L\n.8581 .5296 L\n.85857 .52857 L\n.85857 .52857 L\n.85905 .52969 L\n.85905 .52969 L\n.85952 .52866 L\n.85952 .52866 L\n.86 .52976 L\n.86 .52976 L\n.86048 .52873 L\n.86048 .52873 L\n.86095 .52985 L\n.86095 .52985 L\n.86143 .52882 L\n.86143 .52882 L\n.8619 .52992 L\n.8619 .52992 L\n.86238 .52888 L\n.86238 .52888 L\n.86286 .53001 L\n.86286 .53001 L\n.86333 .52897 L\n.86333 .52897 L\n.86381 .53007 L\n.86381 .53007 L\n.86429 .52903 L\n.86429 .52903 L\n.86476 .53015 L\n.86476 .53015 L\n.86524 .52912 L\n.86524 .52912 L\n.86571 .53021 L\n.86571 .53021 L\n.86619 .52918 L\n.86619 .52918 L\n.86667 .53029 L\n.86667 .53029 L\n.86714 .52926 L\n.86714 .52926 L\n.86762 .53035 L\n.86762 .53035 L\n.8681 .52931 L\n.8681 .52931 L\n.86857 .53043 L\nMistroke\n.86857 .53043 L\n.86905 .52939 L\n.86905 .52939 L\n.86952 .53048 L\n.86952 .53048 L\n.87 .52945 L\n.87 .52945 L\n.87048 .53056 L\n.87048 .53056 L\n.87095 .52952 L\n.87095 .52952 L\n.87143 .53061 L\n.87143 .53061 L\n.8719 .52957 L\n.8719 .52957 L\n.87238 .53068 L\n.87238 .53068 L\n.87286 .52965 L\n.87286 .52965 L\n.87333 .53073 L\n.87333 .53073 L\n.87381 .5297 L\n.87381 .5297 L\n.87429 .5308 L\n.87429 .5308 L\n.87476 .52977 L\n.87476 .52977 L\n.87524 .53085 L\n.87524 .53085 L\n.87571 .52981 L\n.87571 .52981 L\n.87619 .53092 L\n.87619 .53092 L\n.87667 .52988 L\n.87667 .52988 L\n.87714 .53096 L\n.87714 .53096 L\n.87762 .52993 L\n.87762 .52993 L\n.8781 .53103 L\n.8781 .53103 L\n.87857 .52999 L\n.87857 .52999 L\n.87905 .53107 L\n.87905 .53107 L\n.87952 .53003 L\n.87952 .53003 L\n.88 .53114 L\n.88 .53114 L\n.88048 .5301 L\nMistroke\n.88048 .5301 L\n.88095 .53118 L\n.88095 .53118 L\n.88143 .53014 L\n.88143 .53014 L\n.8819 .53124 L\n.8819 .53124 L\n.88238 .5302 L\n.88238 .5302 L\n.88286 .53128 L\n.88286 .53128 L\n.88333 .53024 L\n.88333 .53024 L\n.88381 .53134 L\n.88381 .53134 L\n.88429 .5303 L\n.88429 .5303 L\n.88476 .53137 L\n.88476 .53137 L\n.88524 .53034 L\n.88524 .53034 L\n.88571 .53143 L\n.88571 .53143 L\n.88619 .53039 L\n.88619 .53039 L\n.88667 .53146 L\n.88667 .53146 L\n.88714 .53043 L\n.88714 .53043 L\n.88762 .53152 L\n.88762 .53152 L\n.8881 .53048 L\n.8881 .53048 L\n.88857 .53155 L\n.88857 .53155 L\n.88905 .53052 L\n.88905 .53052 L\n.88952 .53161 L\n.88952 .53161 L\n.89 .53057 L\n.89 .53057 L\n.89048 .53164 L\n.89048 .53164 L\n.89095 .5306 L\n.89095 .5306 L\n.89143 .53169 L\n.89143 .53169 L\n.8919 .53065 L\n.8919 .53065 L\n.89238 .53172 L\nMistroke\n.89238 .53172 L\n.89286 .53068 L\n.89286 .53068 L\n.89333 .53177 L\n.89333 .53177 L\n.89381 .53073 L\n.89381 .53073 L\n.89429 .5318 L\n.89429 .5318 L\n.89476 .53076 L\n.89476 .53076 L\n.89524 .53185 L\n.89524 .53185 L\n.89571 .53081 L\n.89571 .53081 L\n.89619 .53188 L\n.89619 .53188 L\n.89667 .53084 L\n.89667 .53084 L\n.89714 .53192 L\n.89714 .53192 L\n.89762 .53089 L\n.89762 .53089 L\n.8981 .53195 L\n.8981 .53195 L\n.89857 .53091 L\n.89857 .53091 L\n.89905 .53199 L\n.89905 .53199 L\n.89952 .53096 L\n.89952 .53096 L\n.9 .53202 L\n.9 .53202 L\n.90048 .53098 L\n.90048 .53098 L\n.90095 .53206 L\n.90095 .53206 L\n.90143 .53103 L\n.90143 .53103 L\n.9019 .53209 L\n.9019 .53209 L\n.90238 .53105 L\n.90238 .53105 L\n.90286 .53213 L\n.90286 .53213 L\n.90333 .53109 L\n.90333 .53109 L\n.90381 .53215 L\n.90381 .53215 L\n.90429 .53111 L\nMistroke\n.90429 .53111 L\n.90476 .53219 L\n.90476 .53219 L\n.90524 .53115 L\n.90524 .53115 L\n.90571 .53221 L\n.90571 .53221 L\n.90619 .53117 L\n.90619 .53117 L\n.90667 .53225 L\n.90667 .53225 L\n.90714 .53122 L\n.90714 .53122 L\n.90762 .53227 L\n.90762 .53227 L\n.9081 .53123 L\n.9081 .53123 L\n.90857 .53231 L\n.90857 .53231 L\n.90905 .53127 L\n.90905 .53127 L\n.90952 .53233 L\n.90952 .53233 L\n.91 .53129 L\n.91 .53129 L\n.91048 .53237 L\n.91048 .53237 L\n.91095 .53133 L\n.91095 .53133 L\n.91143 .53238 L\n.91143 .53238 L\n.9119 .53135 L\n.9119 .53135 L\n.91238 .53242 L\n.91238 .53242 L\n.91286 .53138 L\n.91286 .53138 L\n.91333 .53244 L\n.91333 .53244 L\n.91381 .5314 L\n.91381 .5314 L\n.91429 .53247 L\n.91429 .53247 L\n.91476 .53144 L\n.91476 .53144 L\n.91524 .53249 L\n.91524 .53249 L\n.91571 .53145 L\n.91571 .53145 L\n.91619 .53252 L\nMistroke\n.91619 .53252 L\n.91667 .53149 L\n.91667 .53149 L\n.91714 .53254 L\n.91714 .53254 L\n.91762 .5315 L\n.91762 .5315 L\n.9181 .53257 L\n.9181 .53257 L\n.91857 .53153 L\n.91857 .53153 L\n.91905 .53258 L\n.91905 .53258 L\n.91952 .53155 L\n.91952 .53155 L\n.92 .53262 L\n.92 .53262 L\n.92048 .53158 L\n.92048 .53158 L\n.92095 .53263 L\n.92095 .53263 L\n.92143 .53159 L\n.92143 .53159 L\n.9219 .53266 L\n.9219 .53266 L\n.92238 .53162 L\n.92238 .53162 L\n.92286 .53267 L\n.92286 .53267 L\n.92333 .53163 L\n.92333 .53163 L\n.92381 .5327 L\n.92381 .5327 L\n.92429 .53167 L\n.92429 .53167 L\n.92476 .53271 L\n.92476 .53271 L\n.92524 .53168 L\n.92524 .53168 L\n.92571 .53274 L\n.92571 .53274 L\n.92619 .53171 L\n.92619 .53171 L\n.92667 .53275 L\n.92667 .53275 L\n.92714 .53172 L\n.92714 .53172 L\n.92762 .53278 L\n.92762 .53278 L\n.9281 .53175 L\nMistroke\n.9281 .53175 L\n.92857 .53279 L\n.92857 .53279 L\n.92905 .53175 L\n.92905 .53175 L\n.92952 .53282 L\n.92952 .53282 L\n.93 .53178 L\n.93 .53178 L\n.93048 .53283 L\n.93048 .53283 L\n.93095 .53179 L\n.93095 .53179 L\n.93143 .53286 L\n.93143 .53286 L\n.9319 .53182 L\n.9319 .53182 L\n.93238 .53286 L\n.93238 .53286 L\n.93286 .53183 L\n.93286 .53183 L\n.93333 .53289 L\n.93333 .53289 L\n.93381 .53185 L\n.93381 .53185 L\n.93429 .5329 L\n.93429 .5329 L\n.93476 .53186 L\n.93476 .53186 L\n.93524 .53292 L\n.93524 .53292 L\n.93571 .53189 L\n.93571 .53189 L\n.93619 .53293 L\n.93619 .53293 L\n.93667 .53189 L\n.93667 .53189 L\n.93714 .53296 L\n.93714 .53296 L\n.93762 .53192 L\n.93762 .53192 L\n.9381 .53296 L\n.9381 .53296 L\n.93857 .53192 L\n.93857 .53192 L\n.93905 .53299 L\n.93905 .53299 L\n.93952 .53195 L\n.93952 .53195 L\n.94 .53299 L\nMistroke\n.94 .53299 L\n.94048 .53195 L\n.94048 .53195 L\n.94095 .53302 L\n.94095 .53302 L\n.94143 .53198 L\n.94143 .53198 L\n.9419 .53302 L\n.9419 .53302 L\n.94238 .53198 L\n.94238 .53198 L\n.94286 .53304 L\n.94286 .53304 L\n.94333 .53201 L\n.94333 .53201 L\n.94381 .53305 L\n.94381 .53305 L\n.94429 .53201 L\n.94429 .53201 L\n.94476 .53307 L\n.94476 .53307 L\n.94524 .53204 L\n.94524 .53204 L\n.94571 .53307 L\n.94571 .53307 L\n.94619 .53204 L\n.94619 .53204 L\n.94667 .5331 L\n.94667 .5331 L\n.94714 .53206 L\n.94714 .53206 L\n.94762 .5331 L\n.94762 .5331 L\n.9481 .53206 L\n.9481 .53206 L\n.94857 .53312 L\n.94857 .53312 L\n.94905 .53209 L\n.94905 .53209 L\n.94952 .53313 L\n.94952 .53313 L\n.95 .53209 L\n.95 .53209 L\n.95048 .53315 L\n.95048 .53315 L\n.95095 .53211 L\n.95095 .53211 L\n.95143 .53315 L\n.95143 .53315 L\n.9519 .53211 L\nMistroke\n.9519 .53211 L\n.95238 .53317 L\n.95238 .53317 L\n.95286 .53213 L\n.95286 .53213 L\n.95333 .53317 L\n.95333 .53317 L\n.95381 .53214 L\n.95381 .53214 L\n.95429 .53319 L\n.95429 .53319 L\n.95476 .53216 L\n.95476 .53216 L\n.95524 .53319 L\n.95524 .53319 L\n.95571 .53216 L\n.95571 .53216 L\n.95619 .53321 L\n.95619 .53321 L\n.95667 .53218 L\n.95667 .53218 L\n.95714 .53321 L\n.95714 .53321 L\n.95762 .53218 L\n.95762 .53218 L\n.9581 .53324 L\n.9581 .53324 L\n.95857 .5322 L\n.95857 .5322 L\n.95905 .53324 L\n.95905 .53324 L\n.95952 .5322 L\n.95952 .5322 L\n.96 .53326 L\n.96 .53326 L\n.96048 .53222 L\n.96048 .53222 L\n.96095 .53325 L\n.96095 .53325 L\n.96143 .53222 L\n.96143 .53222 L\n.9619 .53327 L\n.9619 .53327 L\n.96238 .53224 L\n.96238 .53224 L\n.96286 .53327 L\n.96286 .53327 L\n.96333 .53224 L\n.96333 .53224 L\n.96381 .53329 L\nMistroke\n.96381 .53329 L\n.96429 .53226 L\n.96429 .53226 L\n.96476 .53329 L\n.96476 .53329 L\n.96524 .53225 L\n.96524 .53225 L\n.96571 .53331 L\n.96571 .53331 L\n.96619 .53227 L\n.96619 .53227 L\n.96667 .53331 L\n.96667 .53331 L\n.96714 .53227 L\n.96714 .53227 L\n.96762 .53333 L\n.96762 .53333 L\n.9681 .53229 L\n.9681 .53229 L\n.96857 .53332 L\n.96857 .53332 L\n.96905 .53229 L\n.96905 .53229 L\n.96952 .53334 L\n.96952 .53334 L\n.97 .53231 L\n.97 .53231 L\n.97048 .53334 L\n.97048 .53334 L\n.97095 .5323 L\n.97095 .5323 L\n.97143 .53336 L\n.97143 .53336 L\n.9719 .53232 L\n.9719 .53232 L\n.97238 .53336 L\n.97238 .53336 L\n.97286 .53232 L\n.97286 .53232 L\n.97333 .53337 L\n.97333 .53337 L\n.97381 .53234 L\n.97381 .53234 L\n.97429 .53337 L\n.97429 .53337 L\n.97476 .53233 L\n.97476 .53233 L\n.97524 .53339 L\n.97524 .53339 L\n.97571 .53235 L\nMistroke\n.97571 .53235 L\n.97619 .53338 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(tankn) show\n99.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(h) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(L) show\n117.000 12.813 moveto\n(@) show\n123.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n129.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00D@3IfMT2000000@0fMWI0P00000^0=WIf@D000000P3IfMT2000000@0\nfMWI0P00000Z0=WIf@D000000P3IfMT2000000@0fMWI0P00000[0=WIf@@000000`3IfMT2000000@0\nfMWI0P00000G0=WIf@00D03IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI0000\n02l0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00<0\n00000=WIf@3IfMT0:@3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00@000000=WIf@3IfMT0\n00000P3IfMT00`000000fMWI0=WIf@0X0=WIf@030000003IfMT0fMWI00<0fMWI00@000000=WIf@3I\nfMT000000P3IfMT010000000fMWI0=WIf@00000F0=WIf@00D`3IfMT010000000fMWI0=WIf@000002\n0=WIf@030000003IfMT0fMWI02d0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003I\nfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0:@3IfMT00`000000fMWI0=WIf@040=WIf@040000\n003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0:@3IfMT00`000000fMWI0=WIf@020=WIf@04\n0000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000005P3IfMT00540fMWI0P0000030=WI\nf@040000003IfMT0fMWI000002l0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003I\nfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0:@3IfMT00`000000fMWI0=WIf@020=WIf@800000\n0`3IfMT010000000fMWI0=WIf@00000/0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT01000\n0000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI01@0fMWI001A0=WIf@030000003IfMT0fMWI\n0080fMWI00@000000=WIf@3IfMT00000;`3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00@0\n00000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@0Y0=WIf@030000003IfMT0fMWI0080fMWI\n00<000000=WIf@3IfMT00P3IfMT010000000fMWI0=WIf@00000Z0=WIf@040000003IfMT0fMWI0000\n0080fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@00000F0=WIf@00D@3IfMT3\n000000<0fMWI0P00000_0=WIf@800000103IfMT2000000@0fMWI0P00000[0=WIf@800000103IfMT3\n000000<0fMWI0P00000/0=WIf@800000103IfMT2000000@0fMWI0P00000G0=WIf@00o`3IfMTQ0=WI\nf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<000000=WIf@3IfMT0lP3IfMT2000000d0fMWI000L0=WIf@030000003IfMT0\nfMWI0?40fMWI00@000000=WIf@3IfMT00000303IfMT001H0fMWI1P0000000`000?l000000000003Y\n000000P0fMWI00<000000=WIf@3IfMT03@3IfMT001`0fMWI00<0003o0=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00X0fMWI1@00000<0=WIf@00703IfMT00`000?l0\nfMWI0=WIf@3a0=WIf@030000003IfMT0fMWI00d0fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o\n0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000o`3I\nfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`00\n0?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI\n00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WI\nf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o\n0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3I\nfMT0o`3IfMT20=WIf@002@3IfMT2000000@0fMWI0P0000030=WIf@D000000`3IfMT00`000?l0fMWI\n0=WIf@3o0=WIf@80fMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT0\n0`3IfMT20000ool0fMWI0`3IfMT000P0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI\n0=WIf@030=WIf@030000o`000000fMWI0?l0fMWI0P3IfMT000P0fMWI00@000000=WIf@3IfMT00000\n2P3IfMT00`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT000P0fMWI00@0\n00000=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0?l0fMWI\n0P3IfMT000T0fMWI0P00000:0=WIf@8000001@3IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@80003oo`3IfMT30=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@03\n0000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703I\nfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@80003oo`3IfMT30=WIf@00703IfMT00`00\n0?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI\n00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@80003oo`3IfMT30=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@03\n0000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703I\nfMT00`000000003o0=WIf@3o0=WIf@80fMWI000L0=WIf@03000000000?l0fMWI0?l0fMWI0P3IfMT0\n01`0fMWI00<000000000o`3IfMT0o`3IfMT20=WIf@00703IfMT00`000000003o0=WIf@3o0=WIf@80\nfMWI000L0=WIf@03000000000?l0fMWI0?l0fMWI0P3IfMT000T0fMWI0P0000040=WIf@8000000`3I\nfMT4000000@0fMWI00<000000000o`3IfMT0o`3IfMT20=WIf@00203IfMT010000000fMWI0=WIf@00\n00080=WIf@030000003IfMT0fMWI00D0fMWI00<000000000o`3IfMT0o`3IfMT20=WIf@00203IfMT0\n10000000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI00@0fMWI00<000000000o`3IfMT0o`3I\nfMT20=WIf@00203IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI00<0fMWI00<0\n00000000o`3IfMT0o`3IfMT20=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003I\nfMT0fMWI000000@0fMWI00<000000000o`3IfMT0o`3IfMT20=WIf@002@3IfMT2000000X0fMWI0P00\n00050=WIf@03000000000?l0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000000o`3IfMT0o`3IfMT2\n0=WIf@00703IfMT00`000000003o0=WIf@3o0=WIf@80fMWI000L0=WIf@03000000000?l0fMWI0?l0\nfMWI0P3IfMT001`0fMWI00<000000000o`3IfMT0o`3IfMT20=WIf@00703IfMT00`000000003o0=WI\nf@2F0=WIf@030000o`3IfMT0fMWI06P0fMWI000L0=WIf@03000000000?l0fMWI09H0fMWI0P000?mY\n0=WIf@00703IfMT00`000000003o0=WIf@2E0=WIf@80003oJP3IfMT001`0fMWI00<000000000o`3I\nfMT0U@3IfMT30000ofT0fMWI000L0=WIf@03000000000?l0fMWI09@0fMWI10000?mY0=WIf@00703I\nfMT00`000000003o0=WIf@2D0=WIf@040000o`3IfMT0003o0000ofT0fMWI000L0=WIf@0300000000\n0?l0fMWI09<0fMWI0P000?l20=WIf@030000o`3IfMT0fMWI06L0fMWI000L0=WIf@03000000000?l0\nfMWI09<0fMWI00D0003o0=WIf@3IfMT0fMWI0000o`1Y0=WIf@00703IfMT00`000000003o0=WIf@2B\n0=WIf@80003o0`3IfMT20000ofP0fMWI000L0=WIf@03000000000?l0fMWI0980fMWI00<0003o0=WI\nf@3IfMT00P3IfMT20000ofP0fMWI000L0=WIf@03000000000?l0fMWI0940fMWI0P000?l50=WIf@03\n0000o`3IfMT0fMWI06H0fMWI000L0=WIf@03000000000?l0fMWI0940fMWI0P000?l50=WIf@030000\no`3IfMT0fMWI06H0fMWI000L0=WIf@03000000000?l0003o0900fMWI0P000?l60=WIf@80003oI`3I\nfMT001`0fMWI00<000000000o`3IfMT0T03IfMT20000o`H0fMWI0P000?mW0=WIf@00703IfMT00`00\n0000003o0=WIf@2@0=WIf@030000o`3IfMT0fMWI00D0fMWI0P000?mW0=WIf@002@3IfMT2000000@0\nfMWI0P0000040=WIf@8000001@3IfMT00`000000003o0=WIf@2?0=WIf@80003o203IfMT00`000?l0\nfMWI0=WIf@1U0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI0000\n00@0fMWI00<000000000o`3IfMT0S`3IfMT00`000?l0fMWI0=WIf@070=WIf@80003oIP3IfMT000P0\nfMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@030=WIf@03000000000?l0003o\n08h0fMWI0P000?l90=WIf@80003oIP3IfMT000P0fMWI00@000000=WIf@3IfMT000002`3IfMT00`00\n0000fMWI0=WIf@020=WIf@03000000000?l0fMWI08h0fMWI00<0003o0=WIf@3IfMT0203IfMT20000\nofH0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000103IfMT0\n0`000000003o0=WIf@2=0=WIf@80003o2P3IfMT20000ofH0fMWI00090=WIf@8000002P3IfMT20000\n00D0fMWI00<000000000o`3IfMT0S@3IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI\n06@0fMWI000L0=WIf@03000000000?l0fMWI08`0fMWI0P000?l<0=WIf@80003oI@3IfMT001`0fMWI\n00<000000000o`000?l0S03IfMT00`000?l0fMWI0=WIf@0;0=WIf@80003oI@3IfMT001`0fMWI00<0\n00000000o`3IfMT0R`3IfMT20000o`d0fMWI0P000?mU0=WIf@00703IfMT00`000000003o0=WIf@2;\n0=WIf@80003o3P3IfMT00`000?l0fMWI0=WIf@1S0=WIf@00703IfMT00`000000003o0=WIf@2;0=WI\nf@030000o`3IfMT0fMWI00d0fMWI0P000?mT0=WIf@00703IfMT00`000000003o0=WIf@2:0=WIf@80\n003o3`3IfMT20000of@0fMWI000L0=WIf@03000000000?l0003o08X0fMWI00<0003o0=WIf@3IfMT0\n3`3IfMT00`000?l0fMWI0=WIf@1R0=WIf@00703IfMT00`000000003o0=WIf@290=WIf@80003o4@3I\nfMT20000of<0fMWI000L0=WIf@03000000000?l0fMWI08T0fMWI00<0003o0=WIf@3IfMT0403IfMT2\n0000of<0fMWI000L0=WIf@030000003IfMT0003o08P0fMWI0P000?lB0=WIf@80003oH`3IfMT001`0\nfMWI00<000000=WIf@000?l0R03IfMT00`000?l0fMWI0=WIf@0B0=WIf@80003oHP3IfMT001`0fMWI\n00<000000=WIf@000?l0Q`3IfMT20000oa@0fMWI0P000?mR0=WIf@00703IfMT00`000000fMWI0000\no`270=WIf@030000o`3IfMT0fMWI01<0fMWI0P000?mR0=WIf@00703IfMT00`000000fMWI0000o`26\n0=WIf@80003o5P3IfMT20000of40fMWI000L0=WIf@030000003IfMT0003o08H0fMWI0P000?lF0=WI\nf@80003oH@3IfMT001`0fMWI00<000000=WIf@000?l0Q@3IfMT20000oaL0fMWI0P000?mQ0=WIf@00\n703IfMT00`000000fMWI0000o`250=WIf@80003o603IfMT20000of00fMWI000L0=WIf@030000003I\nfMT0003o08D0fMWI00<0003o0=WIf@3IfMT05`3IfMT20000of00fMWI000L0=WIf@030000003IfMT0\n003o08@0fMWI0P000?lI0=WIf@80003oH03IfMT000T0fMWI0P0000040=WIf@8000001@3IfMT30000\n00<0fMWI00<000000=WIf@000?l0Q03IfMT00`000?l0fMWI0=WIf@0I0=WIf@80003oG`3IfMT000P0\nfMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0003o\n08<0fMWI0P000?lK0=WIf@80003oG`3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT50000\n00<0fMWI0P0000000`000?l0fMWI0=WIf@210=WIf@030000o`3IfMT0fMWI01/0fMWI0P000?mN0=WI\nf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0fMWI00<00000\n0=WIf@000?l0PP3IfMT20000oad0fMWI0P000?mN0=WIf@00203IfMT010000000fMWI0=WIf@000009\n0=WIf@030000003IfMT0000000@0fMWI00<000000=WIf@000?l0PP3IfMT00`000?l0fMWI0=WIf@0M\n0=WIf@80003oG@3IfMT000T0fMWI0P00000;0=WIf@800000103IfMT00`000000fMWI0000o`210=WI\nf@80003o7`3IfMT20000oed0fMWI000L0=WIf@030000003IfMT0003o0840fMWI0P000?lP0=WIf@80\n003oG03IfMT001`0fMWI00<000000=WIf@000?l0P03IfMT20000ob40fMWI0`000?mK0=WIf@00703I\nfMT00`000000fMWI0000o`200=WIf@80003o8P3IfMT20000oe/0fMWI000L0=WIf@030000003IfMT0\n003o07l0fMWI0P000?lT0=WIf@80003oFP3IfMT001`0fMWI00<000000=WIf@000?l0O`3IfMT20000\nob@0fMWI0`000?mI0=WIf@00703IfMT00`000000fMWI0000o`1o0=WIf@030000o`3IfMT0fMWI02@0\nfMWI0P000?mI0=WIf@00703IfMT00`000000fMWI0000o`1n0=WIf@80003o9`3IfMT20000oeP0fMWI\n000L0=WIf@030000003IfMT0003o07h0fMWI00<0003o0=WIf@3IfMT09P3IfMT30000oeL0fMWI000L\n0=WIf@030000003IfMT0003o07d0fMWI0P000?lY0=WIf@<0003oEP3IfMT001`0fMWI00<000000=WI\nf@000?l0O@3IfMT00`000?l0fMWI0=WIf@0Y0=WIf@<0003oE@3IfMT001`0fMWI00<000000=WIf@00\n0?l0O03IfMT20000ob`0fMWI0`000?mD0=WIf@00703IfMT010000000fMWI0000o`000?mk0=WIf@03\n0000o`3IfMT0fMWI02`0fMWI0`000?mC0=WIf@00703IfMT00`000000fMWI0000o`1k0=WIf@80003o\n;`3IfMT30000oe80fMWI000L0=WIf@030000003IfMT0003o07/0fMWI0P000?l`0=WIf@@0003oD03I\nfMT001`0fMWI00<000000=WIf@000?l0N`3IfMT00`000?l0fMWI0=WIf@0a0=WIf@@0003oCP3IfMT0\n01`0fMWI00<000000=WIf@000?l0NP3IfMT20000oc@0fMWI1@000?m<0=WIf@00703IfMT010000000\nfMWI0000o`000?mi0=WIf@030000o`3IfMT0fMWI03D0fMWI1@000?m:0=WIf@00703IfMT00`000000\nfMWI0000o`1i0=WIf@80003o>@3IfMT70000odH0fMWI000L0=WIf@030000003IfMT0003o07T0fMWI\n00<0003o0=WIf@3IfMT0>`3IfMT80000od80fMWI00090=WIf@800000103IfMT2000000@0fMWI0P00\n00050=WIf@030000003IfMT0003o07P0fMWI0P000?m10=WIf@`0003o>P3IfMT000P0fMWI00@00000\n0=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0003o07P0fMWI\n00<0003o0=WIf@3IfMT0A@3IfMTT0000oad0fMWI00080=WIf@040000003IfMT0fMWI000000/0fMWI\n00<000000=WIf@3IfMT00P3IfMT200000080003oMP3IfMT20000oe40fMWI6P000?lM0=WIf@00203I\nfMT010000000fMWI0=WIf@0000090=WIf@8000001@3IfMT00`000000fMWI0000o`1g0=WIf@030000\no`3IfMT0fMWI08L0fMWI00080=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT0\n103IfMT00`000000fMWI0000o`1f0=WIf@80003oR@3IfMT000T0fMWI0P00000:0=WIf@<00000103I\nfMT010000000fMWI0=WIf@000?me0=WIf@030000o`3IfMT0fMWI08P0fMWI000L0=WIf@040000003I\nfMT0fMWI0000og@0fMWI0P000?n:0=WIf@00703IfMT010000000fMWI0=WIf@000?md0=WIf@80003o\nRP3IfMT001`0fMWI00@000000=WIf@3IfMT0003oM03IfMT00`000?l0fMWI0=WIf@290=WIf@00703I\nfMT010000000fMWI0=WIf@000?mc0=WIf@80003oR`3IfMT001`0fMWI00@000000=WIf@3IfMT0003o\nL`3IfMT00`000?l0fMWI0=WIf@2:0=WIf@00703IfMT010000000fMWI0=WIf@000?mb0=WIf@80003o\nS03IfMT001`0fMWI00@000000=WIf@3IfMT0003oLP3IfMT00`000?l0fMWI0=WIf@2;0=WIf@00703I\nfMT010000000fMWI0=WIf@000?ma0=WIf@80003oS@3IfMT001`0fMWI00@000000=WIf@3IfMT0003o\nL@3IfMT00`000?l0fMWI0=WIf@2<0=WIf@00703IfMT010000000fMWI0=WIf@000?m`0=WIf@80003o\nSP3IfMT001`0fMWI00@000000=WIf@3IfMT0003oL03IfMT00`000?l0fMWI0=WIf@2=0=WIf@00703I\nfMT010000000fMWI0=WIf@000?m_0=WIf@80003oS`3IfMT001`0fMWI00@000000=WIf@3IfMT0003o\nK`3IfMT00`000?l0fMWI0=WIf@2>0=WIf@00703IfMT00`000000fMWI0=WIf@1a0000oi00fMWI000L\n0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WI\nf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI\n0P3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT002D0fMWI\n00<000000=WIf@3IfMT0:P3IfMT00`000000fMWI0=WIf@050=WIf@800000203IfMT200000;X0fMWI\n000T0=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WI\nf@080=WIf@030000003IfMT0fMWI0;P0fMWI000S0=WIf@030000003IfMT0fMWI00<0fMWI0P000003\n0=WIf@L000000P3IfMT4000000040=WIf@00000000000=WIf@8000000P3IfMT200000080fMWI0P00\n00020=WIf@<0000000<0fMWI0000000000000`3IfMT00`000000fMWI0=WIf@030=WIf@030000003I\nfMT0fMWI0080fMWI0P0000040=WIf@030000003IfMT0fMWI0;P0fMWI000S0=WIf@030000003IfMT0\nfMWI0080fMWI00@000000=WIf@3IfMT000000P3IfMT400000080fMWI00@000000=WIf@3IfMT00000\n0P3IfMT00`000000fMWI000000030=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3I\nfMT00000103IfMT00`000000fMWI0=WIf@030=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT0\n1@000000fMWI0=WIf@3IfMT000000;X0fMWI000F0=WIf@P0003o1@3IfMT00`000000fMWI0=WIf@02\n0=WIf@030000003IfMT0fMWI00H0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WI\nf@03000000<0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@03\n0000003IfMT0fMWI00<0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI\n0;P0fMWI000S0=WIf@040000003IfMT0fMWI0=WIf@D000000`3IfMT3000000030=WIf@0000000000\n008000000`3IfMT01@000000fMWI000000000000fMWI00@000002@3IfMT3000000D0fMWI00<00000\n0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@05000000<0fMWI00<000000=WIf@3IfMT0^03IfMT0\n02@0fMWI00D000000=WIf@3IfMT0fMWI0000000A0=WIf@030000003IfMT0fMWI00l0fMWI00<00000\n0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@050000003IfMT0fMWI0=WIf@0000001P3I\nfMT00`000000fMWI0=WIf@2h0=WIf@009@3IfMT00`000000fMWI0=WIf@0A0=WIf@800000403IfMT2\n000000D0fMWI00<000000=WIf@3IfMT01@3IfMT2000000P0fMWI0P00002j0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-24.3537`, -0.0901542`, 0.869108`, 0.00399094`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell[BoxData[TagBox[RowBox[List[RowBox[List["\[SkeletonIndicator]", "Graphics"]], "\[SkeletonIndicator]"]], False, Rule[Editable, False]]], "Output"]], Closed]]], Closed]], Cell["Tank Model with PID continuous controler", "Section"], Cell[CellGroupData[List[Cell["Renewed Tank Model", "Section"], Cell["The imput flow in that case is constant and the output flow is regulated by the PI controller", "Text"], Cell["partial model PIcontroller\n  parameter Real Ts=0.1;//sampling time[s]\n  parameter Real K=2;//gain\n  parameter Real T=10;//time constant[s]\n  parameter Real minV=-10,maxV=10;//limits for output\n  Real      ref,error,outCtr;\n  ReadSignal cInp;\n  ActSignal  cOut;\nequation\n  error = ref-cInp.val;\n  cOut.act = LimitValue(minV,maxV,outCtr);\nend PIcontroller;", "ModelicaInput"], Cell["", "Text"], Cell["model PIcontinuousController\n  extends PIcontroller(K=2,T=10);\n  Real  x; //state variable of continuous controller\nequation\n  der(x) = error/T;\n  outCtr = K*(x+error);\nend PIcontinuousController;\n", "ModelicaInput"], Cell["", "Text"], Cell["model TankModified\n  ReadSignal tOut;  // Connector, reading tank level\n  ActSignal  tInp;  // Connector, actuator controlling input flow\n  parameter Real flowVin =0.005; //[m3/s]\n  parameter Real area =0.5;      //[m2]\n  parameter Real flowGain =0.05;   //[m2/s]\n  Real h(start=0.0);    //tank level [m]\n  Real qIn;  // flow through input valve[m3/s]\n  Real qOut; // flow through output valve[m3/s]\nequation\n  der(h)=(qIn-qOut)/area; //mass balance equation\n  qIn=if time>150 then 3*flowVin else flowVin ;\n  qOut=LimitValue(0,10,-flowGain*tInp.act);\n  //qOut=0;\n  \n  tOut.val = h;\nend TankModified;", "ModelicaInput"], Cell["", "Text"], Cell["model TankApplicationModified\n  PIcontinuousController piContinuous;\n  TankModified  tankm(area=1,flowVin=0.02);\nequation\n  connect(tankm.tInp,piContinuous.cOut);\n  connect(tankm.tOut,piContinuous.cInp);\n  piContinuous.ref=0.25;\nend TankApplicationModified;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of TankApplicationModified", "Subsection"], Cell["simulate( TankApplicationModified, stopTime=250 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(TankApplicationModified\\) : 2004-2-4 10:47:54.1345609 : \\!\\({0.`, 250.`}\\) : 504 data points : 2 events : 21 variables>\\n\\!\\({\\*TagBox[\\(piContinuous . cInp . val\\), HoldForm], \\*TagBox[\\(piContinuous . cOut . act\\), HoldForm], \\*TagBox[\\(piContinuous . error\\), HoldForm], \\*TagBox[\\(piContinuous . K\\), HoldForm], \\*TagBox[\\(piContinuous . maxV\\), HoldForm], \\*TagBox[\\(piContinuous . minV\\), HoldForm], \\*TagBox[\\(piContinuous . outCtr\\), HoldForm], \\*TagBox[\\(piContinuous . ref\\), HoldForm], \\*TagBox[\\(piContinuous . T\\), HoldForm], \\*TagBox[\\(piContinuous . Ts\\), HoldForm], \\*TagBox[\\(piContinuous . x\\), HoldForm], \\*TagBox[\\(tankm . area\\), HoldForm], \\*TagBox[\\(tankm . flowGain\\), HoldForm], \\*TagBox[\\(tankm . flowVin\\), HoldForm], \\*TagBox[\\(tankm . h\\), HoldForm], \\*TagBox[\\(tankm . qIn\\), HoldForm], \\*TagBox[\\(tankm . qOut\\), HoldForm], \\*TagBox[\\(tankm . tInp . act\\), HoldForm], \\*TagBox[\\(tankm . tOut . val\\), HoldForm], \\*TagBox[SuperscriptBox[\\((piContinuous . x)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\((tankm . h)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( tankm.h );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.00380952 0.0147151 1.25617 [\n[.21429 .00222 -6 -9 ]\n[.21429 .00222 6 0 ]\n[.40476 .00222 -9 -9 ]\n[.40476 .00222 9 0 ]\n[.59524 .00222 -9 -9 ]\n[.59524 .00222 9 0 ]\n[.78571 .00222 -9 -9 ]\n[.78571 .00222 9 0 ]\n[.97619 .00222 -9 -9 ]\n[.97619 .00222 9 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .14033 -18 -4.5 ]\n[.01131 .14033 0 4.5 ]\n[.01131 .26595 -18 -4.5 ]\n[.01131 .26595 0 4.5 ]\n[.01131 .39157 -18 -4.5 ]\n[.01131 .39157 0 4.5 ]\n[.01131 .51718 -18 -4.5 ]\n[.01131 .51718 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .01472 m\n.21429 .02097 L\ns\n[(50)] .21429 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(100)] .40476 .00222 0 1 Mshowa\n.59524 .01472 m\n.59524 .02097 L\ns\n[(150)] .59524 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(200)] .78571 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(250)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.0619 .01472 m\n.0619 .01847 L\ns\n.1 .01472 m\n.1 .01847 L\ns\n.1381 .01472 m\n.1381 .01847 L\ns\n.17619 .01472 m\n.17619 .01847 L\ns\n.25238 .01472 m\n.25238 .01847 L\ns\n.29048 .01472 m\n.29048 .01847 L\ns\n.32857 .01472 m\n.32857 .01847 L\ns\n.36667 .01472 m\n.36667 .01847 L\ns\n.44286 .01472 m\n.44286 .01847 L\ns\n.48095 .01472 m\n.48095 .01847 L\ns\n.51905 .01472 m\n.51905 .01847 L\ns\n.55714 .01472 m\n.55714 .01847 L\ns\n.63333 .01472 m\n.63333 .01847 L\ns\n.67143 .01472 m\n.67143 .01847 L\ns\n.70952 .01472 m\n.70952 .01847 L\ns\n.74762 .01472 m\n.74762 .01847 L\ns\n.82381 .01472 m\n.82381 .01847 L\ns\n.8619 .01472 m\n.8619 .01847 L\ns\n.9 .01472 m\n.9 .01847 L\ns\n.9381 .01472 m\n.9381 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .14033 m\n.03006 .14033 L\ns\n[(0.1)] .01131 .14033 1 0 Mshowa\n.02381 .26595 m\n.03006 .26595 L\ns\n[(0.2)] .01131 .26595 1 0 Mshowa\n.02381 .39157 m\n.03006 .39157 L\ns\n[(0.3)] .01131 .39157 1 0 Mshowa\n.02381 .51718 m\n.03006 .51718 L\ns\n[(0.4)] .01131 .51718 1 0 Mshowa\n.125 Mabswid\n.02381 .03984 m\n.02756 .03984 L\ns\n.02381 .06496 m\n.02756 .06496 L\ns\n.02381 .09009 m\n.02756 .09009 L\ns\n.02381 .11521 m\n.02756 .11521 L\ns\n.02381 .16546 m\n.02756 .16546 L\ns\n.02381 .19058 m\n.02756 .19058 L\ns\n.02381 .2157 m\n.02756 .2157 L\ns\n.02381 .24083 m\n.02756 .24083 L\ns\n.02381 .29107 m\n.02756 .29107 L\ns\n.02381 .3162 m\n.02756 .3162 L\ns\n.02381 .34132 m\n.02756 .34132 L\ns\n.02381 .36644 m\n.02756 .36644 L\ns\n.02381 .41669 m\n.02756 .41669 L\ns\n.02381 .44181 m\n.02756 .44181 L\ns\n.02381 .46694 m\n.02756 .46694 L\ns\n.02381 .49206 m\n.02756 .49206 L\ns\n.02381 .54231 m\n.02756 .54231 L\ns\n.02381 .56743 m\n.02756 .56743 L\ns\n.02381 .59255 m\n.02756 .59255 L\ns\n.02381 .61768 m\n.02756 .61768 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .02728 L\n.02762 .03984 L\n.02952 .0524 L\n.03143 .06496 L\n.03333 .07752 L\n.03524 .09009 L\n.03714 .10265 L\n.03905 .11521 L\n.04095 .12777 L\n.04286 .14033 L\n.04476 .15289 L\n.04667 .16546 L\n.04857 .17802 L\n.05048 .19058 L\n.05238 .20314 L\n.05429 .2157 L\n.05619 .22826 L\n.0581 .24083 L\n.06 .25339 L\n.0619 .26595 L\n.06381 .27851 L\n.06571 .29107 L\n.06762 .30363 L\n.06952 .3162 L\n.07143 .32876 L\n.07333 .34132 L\n.07524 .35388 L\n.07714 .36644 L\n.07905 .379 L\n.08095 .39157 L\n.08286 .40413 L\n.08476 .41669 L\n.08667 .42925 L\n.08857 .44181 L\n.09048 .45438 L\n.09238 .46694 L\n.09429 .47937 L\n.09619 .49129 L\n.0981 .50236 L\n.1 .5125 L\n.1019 .5217 L\n.10381 .52998 L\n.10571 .53735 L\n.10762 .54386 L\n.10952 .54952 L\n.11143 .55437 L\n.11333 .55843 L\n.11524 .56174 L\n.11714 .56431 L\nMistroke\n.11905 .56619 L\n.12095 .56739 L\n.12286 .56795 L\n.12476 .56791 L\n.12667 .56728 L\n.12857 .5661 L\n.13048 .56439 L\n.13238 .5622 L\n.13429 .55954 L\n.13619 .55645 L\n.1381 .55295 L\n.14 .54908 L\n.1419 .54486 L\n.14381 .54032 L\n.14571 .53548 L\n.14762 .53038 L\n.14952 .52504 L\n.15143 .51947 L\n.15333 .51372 L\n.15524 .50779 L\n.15714 .50172 L\n.15905 .49552 L\n.16095 .48921 L\n.16286 .48283 L\n.16476 .47638 L\n.16667 .46988 L\n.16857 .46336 L\n.17048 .45683 L\n.17238 .45031 L\n.17429 .4438 L\n.17619 .43734 L\n.1781 .43092 L\n.18 .42457 L\n.1819 .41829 L\n.18381 .41211 L\n.18571 .40602 L\n.18762 .40004 L\n.18952 .39418 L\n.19143 .38844 L\n.19333 .38284 L\n.19524 .37738 L\n.19714 .37207 L\n.19905 .36691 L\n.20095 .36191 L\n.20286 .35707 L\n.20476 .3524 L\n.20667 .3479 L\n.20857 .34357 L\n.21048 .33942 L\n.21238 .33544 L\nMistroke\n.21429 .33164 L\n.21619 .32802 L\n.2181 .32458 L\n.22 .32132 L\n.2219 .31823 L\n.22381 .31532 L\n.22571 .31259 L\n.22762 .31003 L\n.22952 .30763 L\n.23143 .30541 L\n.23333 .30335 L\n.23524 .30146 L\n.23714 .29972 L\n.23905 .29814 L\n.24095 .29671 L\n.24286 .29543 L\n.24476 .29429 L\n.24667 .29329 L\n.24857 .29242 L\n.25048 .29169 L\n.25238 .29108 L\n.25429 .29059 L\n.25619 .29022 L\n.2581 .28995 L\n.26 .2898 L\n.2619 .28975 L\n.26381 .28979 L\n.26571 .28993 L\n.26762 .29015 L\n.26952 .29046 L\n.27143 .29084 L\n.27333 .2913 L\n.27524 .29183 L\n.27714 .29241 L\n.27905 .29306 L\n.28095 .29377 L\n.28286 .29452 L\n.28476 .29532 L\n.28667 .29617 L\n.28857 .29705 L\n.29048 .29796 L\n.29238 .29891 L\n.29429 .29988 L\n.29619 .30087 L\n.2981 .30189 L\n.3 .30292 L\n.3019 .30396 L\n.30381 .30502 L\n.30571 .30608 L\n.30762 .30714 L\nMistroke\n.30952 .3082 L\n.31143 .30926 L\n.31333 .31032 L\n.31524 .31137 L\n.31714 .31241 L\n.31905 .31345 L\n.32095 .31446 L\n.32286 .31547 L\n.32476 .31645 L\n.32667 .31742 L\n.32857 .31837 L\n.33048 .3193 L\n.33238 .32021 L\n.33429 .32109 L\n.33619 .32195 L\n.3381 .32278 L\n.34 .32359 L\n.3419 .32437 L\n.34381 .32512 L\n.34571 .32585 L\n.34762 .32655 L\n.34952 .32721 L\n.35143 .32786 L\n.35333 .32847 L\n.35524 .32905 L\n.35714 .3296 L\n.35905 .33012 L\n.36095 .33062 L\n.36286 .33108 L\n.36476 .33152 L\n.36667 .33193 L\n.36857 .33232 L\n.37048 .33267 L\n.37238 .333 L\n.37429 .3333 L\n.37619 .33358 L\n.3781 .33383 L\n.38 .33406 L\n.3819 .33426 L\n.38381 .33444 L\n.38571 .3346 L\n.38762 .33474 L\n.38952 .33485 L\n.39143 .33494 L\n.39333 .33502 L\n.39524 .33508 L\n.39714 .33511 L\n.39905 .33513 L\n.40095 .33514 L\n.40286 .33513 L\nMistroke\n.40476 .3351 L\n.40667 .33506 L\n.40857 .33501 L\n.41048 .33494 L\n.41238 .33486 L\n.41429 .33477 L\n.41619 .33467 L\n.4181 .33457 L\n.42 .33445 L\n.4219 .33432 L\n.42381 .33419 L\n.42571 .33405 L\n.42762 .3339 L\n.42952 .33375 L\n.43143 .3336 L\n.43333 .33344 L\n.43524 .33327 L\n.43714 .33311 L\n.43905 .33294 L\n.44095 .33276 L\n.44286 .33259 L\n.44476 .33242 L\n.44667 .33224 L\n.44857 .33207 L\n.45048 .3319 L\n.45238 .33172 L\n.45429 .33155 L\n.45619 .33138 L\n.4581 .33121 L\n.46 .33105 L\n.4619 .33089 L\n.46381 .33073 L\n.46571 .33057 L\n.46762 .33041 L\n.46952 .33026 L\n.47143 .33012 L\n.47333 .32997 L\n.47524 .32983 L\n.47714 .3297 L\n.47905 .32957 L\n.48095 .32944 L\n.48286 .32932 L\n.48476 .3292 L\n.48667 .32909 L\n.48857 .32898 L\n.49048 .32888 L\n.49238 .32878 L\n.49429 .32869 L\n.49619 .3286 L\n.4981 .32851 L\nMistroke\n.5 .32843 L\n.5019 .32836 L\n.50381 .32829 L\n.50571 .32822 L\n.50762 .32816 L\n.50952 .3281 L\n.51143 .32805 L\n.51333 .328 L\n.51524 .32796 L\n.51714 .32792 L\n.51905 .32788 L\n.52095 .32785 L\n.52286 .32782 L\n.52476 .3278 L\n.52667 .32777 L\n.52857 .32776 L\n.53048 .32774 L\n.53238 .32773 L\n.53429 .32772 L\n.53619 .32772 L\n.5381 .32771 L\n.54 .32771 L\n.5419 .32771 L\n.54381 .32772 L\n.54571 .32773 L\n.54762 .32773 L\n.54952 .32775 L\n.55143 .32776 L\n.55333 .32777 L\n.55524 .32779 L\n.55714 .32781 L\n.55905 .32783 L\n.56095 .32785 L\n.56286 .32787 L\n.56476 .32789 L\n.56667 .32792 L\n.56857 .32795 L\n.57048 .32797 L\n.57238 .328 L\n.57429 .32803 L\n.57619 .32805 L\n.5781 .32808 L\n.58 .32811 L\n.5819 .32814 L\n.58381 .32817 L\n.58571 .3282 L\n.58762 .32823 L\n.58952 .32826 L\n.59143 .32829 L\n.59333 .32831 L\nMistroke\n.59524 .32834 L\n.59524 .32834 L\n.59524 .32834 L\n.59714 .35286 L\n.59905 .37613 L\n.60095 .39815 L\n.60286 .41893 L\n.60476 .43847 L\n.60667 .4568 L\n.60857 .47392 L\n.61048 .48986 L\n.61238 .50462 L\n.61429 .51823 L\n.61619 .53072 L\n.6181 .5421 L\n.62 .55241 L\n.6219 .56167 L\n.62381 .56992 L\n.62571 .57717 L\n.62762 .58345 L\n.62952 .58882 L\n.63143 .59328 L\n.63333 .59688 L\n.63524 .59965 L\n.63714 .60162 L\n.63905 .60283 L\n.64095 .60332 L\n.64286 .60311 L\n.64476 .60224 L\n.64667 .60075 L\n.64857 .59867 L\n.65048 .59603 L\n.65238 .59287 L\n.65429 .58922 L\n.65619 .58511 L\n.6581 .58058 L\n.66 .57566 L\n.6619 .57037 L\n.66381 .56476 L\n.66571 .55884 L\n.66762 .55265 L\n.66952 .54621 L\n.67143 .53957 L\n.67333 .53273 L\n.67524 .52573 L\n.67714 .51859 L\n.67905 .51133 L\n.68095 .50399 L\n.68286 .49657 L\n.68476 .48911 L\nMistroke\n.68667 .48163 L\n.68857 .47413 L\n.69048 .46665 L\n.69238 .45919 L\n.69429 .45178 L\n.69619 .44444 L\n.6981 .43716 L\n.7 .42998 L\n.7019 .4229 L\n.70381 .41594 L\n.70571 .4091 L\n.70762 .40241 L\n.70952 .39585 L\n.71143 .38946 L\n.71333 .38323 L\n.71524 .37717 L\n.71714 .37129 L\n.71905 .36559 L\n.72095 .36008 L\n.72286 .35476 L\n.72476 .34964 L\n.72667 .34472 L\n.72857 .34 L\n.73048 .33549 L\n.73238 .33118 L\n.73429 .32707 L\n.73619 .32317 L\n.7381 .31947 L\n.74 .31597 L\n.7419 .31267 L\n.74381 .30958 L\n.74571 .30668 L\n.74762 .30398 L\n.74952 .30147 L\n.75143 .29915 L\n.75333 .29701 L\n.75524 .29506 L\n.75714 .29327 L\n.75905 .29167 L\n.76095 .29023 L\n.76286 .28895 L\n.76476 .28783 L\n.76667 .28687 L\n.76857 .28605 L\n.77048 .28538 L\n.77238 .28484 L\n.77429 .28444 L\n.77619 .28416 L\n.7781 .284 L\n.78 .28396 L\nMistroke\n.7819 .28403 L\n.78381 .28421 L\n.78571 .28448 L\n.78762 .28485 L\n.78952 .28531 L\n.79143 .28585 L\n.79333 .28647 L\n.79524 .28716 L\n.79714 .28791 L\n.79905 .28873 L\n.80095 .28961 L\n.80286 .29054 L\n.80476 .29152 L\n.80667 .29254 L\n.80857 .2936 L\n.81048 .29469 L\n.81238 .29582 L\n.81429 .29696 L\n.81619 .29813 L\n.8181 .29932 L\n.82 .30053 L\n.8219 .30174 L\n.82381 .30295 L\n.82571 .30417 L\n.82762 .3054 L\n.82952 .30661 L\n.83143 .30783 L\n.83333 .30903 L\n.83524 .31023 L\n.83714 .31141 L\n.83905 .31258 L\n.84095 .31373 L\n.84286 .31485 L\n.84476 .31596 L\n.84667 .31705 L\n.84857 .31811 L\n.85048 .31914 L\n.85238 .32015 L\n.85429 .32113 L\n.85619 .32208 L\n.8581 .323 L\n.86 .32389 L\n.8619 .32475 L\n.86381 .32557 L\n.86571 .32637 L\n.86762 .32713 L\n.86952 .32786 L\n.87143 .32855 L\n.87333 .32921 L\n.87524 .32984 L\nMistroke\n.87714 .33044 L\n.87905 .331 L\n.88095 .33153 L\n.88286 .33203 L\n.88476 .33249 L\n.88667 .33292 L\n.88857 .33333 L\n.89048 .3337 L\n.89238 .33404 L\n.89429 .33435 L\n.89619 .33464 L\n.8981 .33489 L\n.9 .33512 L\n.9019 .33532 L\n.90381 .3355 L\n.90571 .33565 L\n.90762 .33578 L\n.90952 .33588 L\n.91143 .33596 L\n.91333 .33602 L\n.91524 .33606 L\n.91714 .33608 L\n.91905 .33608 L\n.92095 .33607 L\n.92286 .33603 L\n.92476 .33599 L\n.92667 .33592 L\n.92857 .33584 L\n.93048 .33575 L\n.93238 .33564 L\n.93429 .33553 L\n.93619 .3354 L\n.9381 .33526 L\n.94 .33512 L\n.9419 .33496 L\n.94381 .3348 L\n.94571 .33463 L\n.94762 .33446 L\n.94952 .33428 L\n.95143 .33409 L\n.95333 .3339 L\n.95524 .33371 L\n.95714 .33352 L\n.95905 .33332 L\n.96095 .33312 L\n.96286 .33292 L\n.96476 .33272 L\n.96667 .33252 L\n.96857 .33232 L\n.97048 .33213 L\nMistroke\n.97238 .33193 L\n.97429 .33173 L\n.97619 .33154 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(tankm) show\n99.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(h) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(L) show\n117.000 12.813 moveto\n(@) show\n123.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n129.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00AP3IfMT2000000@0fMWI0P00000R0=WIf@D000000P3IfMT2000000@0\nfMWI0P00000O0=WIf@D000000P3IfMT2000000@0fMWI0P00000O0=WIf@@000000`3IfMT2000000@0\nfMWI0P00000O0=WIf@@000000`3IfMT2000000@0fMWI0P00000G0=WIf@00A@3IfMT010000000fMWI\n0=WIf@0000020=WIf@040000003IfMT0fMWI000002<0fMWI00D000000=WIf@3IfMT0fMWI00000002\n0=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT07P3IfMT01@000000fMWI0=WI\nf@3IfMT000000080fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@0L0=WIf@03\n0000003IfMT0fMWI00<0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@00000N\n0=WIf@030000003IfMT0fMWI00<0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WI\nf@00000F0=WIf@00B03IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI0240fMWI\n00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WI\nf@3IfMT07P3IfMT00`000000fMWI0=WIf@040=WIf@040000003IfMT0fMWI00000080fMWI00<00000\n0=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0fMWI00000080fMWI00@0\n00000=WIf@3IfMT000007`3IfMT00`000000fMWI0=WIf@050=WIf@040000003IfMT0fMWI00000080\nfMWI00<000000=WIf@3IfMT0503IfMT004H0fMWI0P0000030=WIf@040000003IfMT0fMWI000002<0\nfMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00<00000\n0=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@020=WIf@8000000`3IfMT010000000fMWI0=WIf@00\n000P0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@03\n0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT00P3IfMT2000000<0fMWI00@000000=WIf@3I\nfMT000005P3IfMT004H0fMWI00<000000=WIf@3IfMT00P3IfMT010000000fMWI0=WIf@00000S0=WI\nf@050000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@030000003I\nfMT0fMWI01h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@020=WIf@040000003I\nfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000020=WI\nf@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000000`3IfMT00`000000fMWI0=WI\nf@020=WIf@040000003IfMT0fMWI000001H0fMWI00160=WIf@<000000`3IfMT2000002<0fMWI0P00\n00040=WIf@800000103IfMT200000200fMWI0P0000040=WIf@<000000`3IfMT200000200fMWI0P00\n00040=WIf@800000103IfMT200000200fMWI0P0000040=WIf@<000000`3IfMT2000001L0fMWI003o\n0=WIfB40fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3b0=WIf@8000003@3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0l@3IfMT010000000fMWI0=WIf@00000<0=WIf@005P3IfMT6000000030000o`00\n000000000>T00000203IfMT00`000000fMWI0=WIf@0=0=WIf@00703IfMT00`000?l0fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@07\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@07\n0=WIf@030000003IfMT0fMWI00X0fMWI1@00000<0=WIf@00703IfMT00`000?l0fMWI0=WIf@3a0=WI\nf@030000003IfMT0fMWI00d0fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI\n00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WI\nf@00703IfMT00`000000003o0=WIf@3o0=WIf@80fMWI000L0=WIf@03000000000?l0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<000000000o`3IfMT0o`3IfMT20=WIf@00703IfMT00`000000003o0=WIf@3o\n0=WIf@80fMWI000L0=WIf@03000000000?l0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000000o`3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0000o`3o0=WIf@80fMWI000L0=WIf@030000003I\nfMT0003o0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@000?l0o`3IfMT20=WIf@00703IfMT00`00\n0000fMWI0000o`3o0=WIf@80fMWI000L0=WIf@030000003IfMT0003o0?l0fMWI0P3IfMT001`0fMWI\n00<000000=WIf@000?l0o`3IfMT20=WIf@00703IfMT010000000fMWI0=WIf@000?oo0=WIf@40fMWI\n000L0=WIf@040000003IfMT0fMWI0000ool0fMWI0@3IfMT001`0fMWI00@000000=WIf@3IfMT0003o\no`3IfMT10=WIf@00703IfMT010000000fMWI0=WIf@000?oo0=WIf@40fMWI000L0=WIf@040000003I\nfMT0fMWI0000ool0fMWI0@3IfMT001`0fMWI00@000000=WIf@3IfMT0003oo`3IfMT10=WIf@00703I\nfMT01@000000fMWI0=WIf@3IfMT0003o0?l0fMWI000L0=WIf@050000003IfMT0fMWI0=WIf@000?l0\no`3IfMT000T0fMWI0P0000040=WIf@8000000`3IfMT5000000<0fMWI00D000000=WIf@3IfMT0fMWI\n0000o`3o0=WIf@00203IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI00<0fMWI\n00D000000=WIf@3IfMT0fMWI0000o`3o0=WIf@00203IfMT010000000fMWI0=WIf@00000:0=WIf@03\n0000003IfMT0fMWI00<0fMWI0P0000020=WIf@030000o`3IfMT0fMWI0?d0fMWI00080=WIf@040000\n003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT0003o\n0?l0fMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00`3IfMT00`00\n0000fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI0?`0fMWI00090=WIf@8000002P3IfMT2000000D0\nfMWI00<000000=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@3l0=WIf@00703IfMT00`000000fMWI\n0=WIf@020=WIf@030000o`3IfMT0fMWI0?`0fMWI000L0=WIf@030000003IfMT0fMWI0080fMWI00<0\n003o0=WIf@3IfMT0o03IfMT001`0fMWI00<000000=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@3l\n0=WIf@00703IfMT00`000000fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI0?`0fMWI000L0=WIf@03\n0000003IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0n`3IfMT001`0fMWI00<000000=WIf@3IfMT0\n0`3IfMT00`000?l0fMWI0=WIf@3k0=WIf@00703IfMT00`000000fMWI0=WIf@030=WIf@030000o`3I\nfMT0fMWI0?/0fMWI000L0=WIf@030000003IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0n`3IfMT0\n01`0fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@3k0=WIf@00703IfMT00`000000\nfMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0?/0fMWI000L0=WIf@030000003IfMT0fMWI00<0fMWI\n00<0003o0=WIf@3IfMT0n`3IfMT001`0fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WI\nf@3k0=WIf@00703IfMT00`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0?/0fMWI000L0=WI\nf@030000003IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT0nP3IfMT001`0fMWI00<000000=WIf@3I\nfMT0103IfMT00`000?l0fMWI0=WIf@3j0=WIf@00703IfMT00`000000fMWI0=WIf@040=WIf@030000\no`3IfMT0fMWI0?X0fMWI000L0=WIf@030000003IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT0nP3I\nfMT001`0fMWI00<000000=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@3j0=WIf@00703IfMT00`00\n0000fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0?X0fMWI000L0=WIf@030000003IfMT0fMWI00D0\nfMWI00<0003o0=WIf@3IfMT0n@3IfMT001`0fMWI00<000000=WIf@3IfMT01@3IfMT00`000?l0fMWI\n0=WIf@3i0=WIf@00703IfMT00`000000fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0?T0fMWI000L\n0=WIf@030000003IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0n@3IfMT001`0fMWI00<000000=WI\nf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@3i0=WIf@00703IfMT00`000000fMWI0=WIf@050=WIf@03\n0000o`3IfMT0fMWI0?T0fMWI00090=WIf@800000103IfMT2000000<0fMWI100000040=WIf@030000\n003IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0n@3IfMT000P0fMWI00@000000=WIf@3IfMT00000\n203IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0\nn03IfMT000P0fMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@040=WIf@800000\n1`3IfMT00`000?l0fMWI0=WIf@3h0=WIf@00203IfMT010000000fMWI0=WIf@00000:0=WIf@030000\n003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@3h0=WIf@00203I\nfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3I\nfMT01P3IfMT00`000?l0fMWI0=WIf@3h0=WIf@002@3IfMT2000000X0fMWI0P0000050=WIf@030000\n003IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0n03IfMT001`0fMWI00<000000=WIf@3IfMT01P3I\nfMT00`000?l0fMWI0=WIf@2W0=WIf@L0003oBP3IfMT001`0fMWI00<000000=WIf@3IfMT01`3IfMT0\n0`000?l0fMWI0=WIf@0Z0=WIf@D0003oMP3IfMT20000o`D0fMWI10000?m70=WIf@00703IfMT00`00\n0000fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI02P0fMWI0`000?l30=WIf@@0003oLP3IfMT00`00\n0?l0fMWI0=WIf@080=WIf@<0003oA@3IfMT001`0fMWI00<000000=WIf@3IfMT01`3IfMT00`000?l0\nfMWI0=WIf@0W0=WIf@030000o`3IfMT0fMWI00P0fMWI0P000?m_0=WIf@030000o`3IfMT0fMWI00/0\nfMWI0P000?m40=WIf@00703IfMT00`000000fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI02H0fMWI\n00<0003o0=WIf@3IfMT02P3IfMT30000of`0fMWI00<0003o0=WIf@3IfMT03@3IfMT30000od80fMWI\n000L0=WIf@030000003IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT09@3IfMT00`000?l0fMWI0=WI\nf@0>0=WIf@80003oJ@3IfMT00`000?l0fMWI0=WIf@0@0=WIf@80003o@@3IfMT001`0fMWI00<00000\n0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0T0=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o\n0=WIf@3IfMT0I@3IfMT00`000?l0fMWI0=WIf@0C0=WIf@80003o?`3IfMT001`0fMWI00<000000=WI\nf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0R0=WIf@030000o`3IfMT0fMWI01<0fMWI0P000?mU0=WI\nf@030000o`3IfMT0fMWI01@0fMWI0P000?ln0=WIf@00703IfMT00`000000fMWI0=WIf@080=WIf@03\n0000o`3IfMT0fMWI0240fMWI00<0003o0=WIf@3IfMT05P3IfMT30000of40fMWI0P000?lH0=WIf@80\n003o?03IfMT001`0fMWI00<000000=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0Q0=WIf@030000\no`3IfMT0fMWI01P0fMWI0`000?mO0=WIf@030000o`3IfMT0fMWI01T0fMWI0P000?lj0=WIf@00703I\nfMT00`000000fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI0200fMWI00<0003o0=WIf@3IfMT06`3I\nfMT30000obT0fMWI2P000?l80=WIf@030000o`3IfMT0fMWI01h0fMWI00<0003o0=WIf@3IfMT0703I\nfMT20000ocP0fMWI000L0=WIf@030000003IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0803IfMT0\n0`000?l0fMWI0=WIf@0N0=WIf@@0003o503IfMTA0000o`X0fMWI2@000?lP0=WIf@030000o`3IfMT0\nfMWI01h0fMWI10000?lE0=WIf@80003o7@3IfMT001`0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0?l0fMWI0=WIf@0O0=WIf@030000o`3IfMT0fMWI02<0fMWI50000?lS0=WIf@030000o`3IfMT0fMWI\n01d0fMWI00<0003o0=WIf@3IfMT08P3IfMTF0000oal0fMWI000L0=WIf@030000003IfMT0fMWI00P0\nfMWI00<0003o0=WIf@3IfMT07`3IfMT00`000?l0fMWI0=WIf@1J0=WIf@030000o`3IfMT0fMWI01d0\nfMWI00<0003o0=WIf@3IfMT0E`3IfMT001`0fMWI00<000000=WIf@3IfMT0203IfMT00`000?l0fMWI\n0=WIf@0N0=WIf@030000o`3IfMT0fMWI05/0fMWI00<0003o0=WIf@3IfMT0703IfMT00`000?l0fMWI\n0=WIf@1H0=WIf@00703IfMT00`000000fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI01h0fMWI00<0\n003o0=WIf@3IfMT0F`3IfMT00`000?l0fMWI0=WIf@0L0=WIf@030000o`3IfMT0fMWI05P0fMWI000L\n0=WIf@030000003IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0703IfMT00`000?l0fMWI0=WIf@1L\n0=WIf@030000o`3IfMT0fMWI01`0fMWI00<0003o0=WIf@3IfMT0F03IfMT001`0fMWI00<000000=WI\nf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0L0=WIf@030000o`3IfMT0fMWI05`0fMWI00<0003o0=WI\nf@3IfMT06`3IfMT00`000?l0fMWI0=WIf@1I0=WIf@00703IfMT00`000000fMWI0=WIf@090=WIf@03\n0000o`3IfMT0fMWI01`0fMWI00<0003o0=WIf@3IfMT0G03IfMT00`000?l0fMWI0=WIf@0K0=WIf@03\n0000o`3IfMT0fMWI05T0fMWI000L0=WIf@030000003IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0\n6`3IfMT00`000?l0fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI01/0fMWI00<0003o0=WIf@3IfMT0\nF@3IfMT001`0fMWI00<000000=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0K0=WIf@030000o`3I\nfMT0fMWI05h0fMWI00<0003o0=WIf@3IfMT06P3IfMT00`000?l0fMWI0=WIf@1I0=WIf@00703IfMT0\n0`000000fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI01X0fMWI00<0003o0=WIf@3IfMT0G`3IfMT0\n0`000?l0fMWI0=WIf@0I0=WIf@030000o`3IfMT0fMWI05X0fMWI000L0=WIf@030000003IfMT0fMWI\n00X0fMWI00<0003o0=WIf@3IfMT06@3IfMT00`000?l0fMWI0=WIf@1O0=WIf@030000o`3IfMT0fMWI\n01T0fMWI00<0003o0=WIf@3IfMT0FP3IfMT001`0fMWI00<000000=WIf@3IfMT02P3IfMT00`000?l0\nfMWI0=WIf@0H0=WIf@030000o`3IfMT0fMWI0600fMWI00<0003o0=WIf@3IfMT0603IfMT00`000?l0\nfMWI0=WIf@1K0=WIf@002@3IfMT2000000@0fMWI0P0000040=WIf@8000001@3IfMT00`000000fMWI\n0=WIf@0:0=WIf@030000o`3IfMT0fMWI01P0fMWI00<0003o0=WIf@3IfMT0H03IfMT00`000?l0fMWI\n0=WIf@0H0=WIf@030000o`3IfMT0fMWI05/0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI\n00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI01P0\nfMWI00<0003o0=WIf@3IfMT0H03IfMT00`000?l0fMWI0=WIf@0H0=WIf@030000o`3IfMT0fMWI05/0\nfMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00`3IfMT2000000/0\nfMWI00<0003o0=WIf@3IfMT0603IfMT00`000?l0fMWI0=WIf@1P0=WIf@030000o`3IfMT0fMWI01L0\nfMWI00<0003o0=WIf@3IfMT0G03IfMT000P0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000\nfMWI0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0603IfMT00`000?l0\nfMWI0=WIf@1P0=WIf@030000o`3IfMT0fMWI01L0fMWI00<0003o0=WIf@3IfMT0G03IfMT000P0fMWI\n00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI\n00/0fMWI00<0003o0=WIf@3IfMT05P3IfMT00`000?l0fMWI0=WIf@1Q0=WIf@030000o`3IfMT0fMWI\n01L0fMWI00<0003o0=WIf@3IfMT0G03IfMT000T0fMWI0P00000:0=WIf@8000001@3IfMT00`000000\nfMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI01H0fMWI00<0003o0=WIf@3IfMT0H@3IfMT00`000?l0\nfMWI0=WIf@0G0=WIf@030000o`3IfMT0fMWI05`0fMWI000L0=WIf@030000003IfMT0fMWI00/0fMWI\n00<0003o0=WIf@3IfMT05@3IfMT00`000?l0fMWI0=WIf@1R0=WIf@030000o`3IfMT0fMWI01H0fMWI\n00<0003o0=WIf@3IfMT0G@3IfMT001`0fMWI00<000000=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WI\nf@0E0=WIf@030000o`3IfMT0fMWI0680fMWI00<0003o0=WIf@3IfMT05P3IfMT00`000?l0fMWI0=WI\nf@1M0=WIf@00703IfMT00`000000fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI01D0fMWI00<0003o\n0=WIf@3IfMT0HP3IfMT00`000?l0fMWI0=WIf@0F0=WIf@030000o`3IfMT0fMWI05d0fMWI000L0=WI\nf@030000003IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@1S0=WI\nf@030000o`3IfMT0fMWI01D0fMWI00<0003o0=WIf@3IfMT0GP3IfMT001`0fMWI00<000000=WIf@3I\nfMT0303IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI06<0fMWI00<0003o0=WIf@3I\nfMT05@3IfMT00`000?l0fMWI0=WIf@1N0=WIf@00703IfMT00`000000fMWI0=WIf@0<0=WIf@030000\no`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0H`3IfMT00`000?l0fMWI0=WIf@0E0=WIf@030000\no`3IfMT0fMWI05h0fMWI000L0=WIf@030000003IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT04P3I\nfMT00`000?l0fMWI0=WIf@1U0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0G`3I\nfMT001`0fMWI00<000000=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0\nfMWI06D0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@1O0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0I@3IfMT00`00\n0?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI05l0fMWI000L0=WIf@030000003IfMT0fMWI00`0\nfMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@1U0=WIf@030000o`3IfMT0fMWI01<0\nfMWI00<0003o0=WIf@3IfMT0G`3IfMT001`0fMWI00<000000=WIf@3IfMT03@3IfMT00`000?l0fMWI\n0=WIf@0@0=WIf@030000o`3IfMT0fMWI06H0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI\n0=WIf@1O0=WIf@00703IfMT00`000000fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI0100fMWI00<0\n003o0=WIf@3IfMT0IP3IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI0600fMWI000L\n0=WIf@030000003IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@1V\n0=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0H03IfMT001`0fMWI00<000000=WI\nf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI06H0fMWI00<0003o0=WI\nf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@1P0=WIf@00703IfMT00`000000fMWI0=WIf@0=0=WIf@03\n0000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT0I`3IfMT00`000?l0fMWI0=WIf@0B0=WIf@03\n0000o`3IfMT0fMWI0600fMWI000L0=WIf@030000003IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0\n3`3IfMT00`000?l0fMWI0=WIf@1X0=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT0\nH@3IfMT001`0fMWI00<000000=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3I\nfMT0fMWI06P0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@1Q0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0J@3IfMT0\n0`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI0640fMWI000L0=WIf@030000003IfMT0fMWI\n00h0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@1Y0=WIf@030000o`3IfMT0fMWI\n0100fMWI00<0003o0=WIf@3IfMT0H@3IfMT001`0fMWI00<000000=WIf@3IfMT03P3IfMT00`000?l0\nfMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI06T0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0\nfMWI0=WIf@1R0=WIf@00703IfMT00`000000fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00`0fMWI\n00<0003o0=WIf@3IfMT0JP3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI0680fMWI\n000L0=WIf@030000003IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WI\nf@1Z0=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT0HP3IfMT001`0fMWI00<00000\n0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI06/0fMWI00<0003o\n0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@1S0=WIf@00703IfMT00`000000fMWI0=WIf@0>0=WI\nf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT0J`3IfMT00`000?l0fMWI0=WIf@0=0=WI\nf@030000o`3IfMT0fMWI06<0fMWI00090=WIf@800000103IfMT2000000D0fMWI0`0000030=WIf@03\n0000003IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@1/0=WIf@03\n0000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0H`3IfMT000P0fMWI00@000000=WIf@3IfMT0\n00002`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI00<0003o0=WIf@3I\nfMT02P3IfMT00`000?l0fMWI0=WIf@1/0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3I\nfMT0H`3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT5000000<0fMWI0P00000@0=WIf@03\n0000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0K@3IfMT00`000?l0fMWI0=WIf@0<0=WIf@03\n0000o`3IfMT0fMWI06@0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3I\nfMT00000103IfMT00`000000fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WI\nf@3IfMT0K@3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI06@0fMWI00080=WIf@04\n0000003IfMT0fMWI000000T0fMWI00<000000=WIf@000000103IfMT00`000000fMWI0=WIf@0?0=WI\nf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0K@3IfMT00`000?l0fMWI0=WIf@0<0=WI\nf@030000o`3IfMT0fMWI06@0fMWI00090=WIf@8000002`3IfMT2000000@0fMWI00<000000=WIf@3I\nfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI06l0fMWI00<0003o0=WIf@3I\nfMT02P3IfMT00`000?l0fMWI0=WIf@1U0=WIf@00703IfMT00`000000fMWI0=WIf@0@0=WIf@030000\no`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0K`3IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000\no`3IfMT0fMWI06D0fMWI000L0=WIf@030000003IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01`3I\nfMT00`000?l0fMWI0=WIf@1_0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0I@3I\nfMT001`0fMWI00<000000=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0\nfMWI06l0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@1U0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0L03IfMT00`00\n0?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI06D0fMWI000L0=WIf@030000003IfMT0fMWI0140\nfMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@1a0=WIf@030000o`3IfMT0fMWI00P0\nfMWI00<0003o0=WIf@3IfMT0IP3IfMT001`0fMWI00<000000=WIf@3IfMT04P3IfMT00`000?l0fMWI\n0=WIf@030=WIf@030000o`3IfMT0fMWI0780fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI\n0=WIf@1V0=WIf@00703IfMT00`000000fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI0080fMWI0P00\n0?md0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0IP3IfMT001`0fMWI00<00000\n0=WIf@3IfMT04`3IfMT01@000?l0fMWI0=WIf@3IfMT0003o07D0fMWI00<0003o0=WIf@3IfMT01`3I\nfMT00`000?l0fMWI0=WIf@1W0=WIf@00703IfMT00`000000fMWI0=WIf@0C0=WIf@@0003oMP3IfMT0\n0`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI06L0fMWI000L0=WIf@030000003IfMT0fMWI\n01@0fMWI0P000?mg0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0I`3IfMT001`0\nfMWI00<000000=WIf@3IfMT0S@3IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI06P0\nfMWI000L0=WIf@030000003IfMT0fMWI08h0fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI\n0=WIf@1X0=WIf@00703IfMT00`000000fMWI0=WIf@2>0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0\n003o0=WIf@3IfMT0J03IfMT001`0fMWI00<000000=WIf@3IfMT0SP3IfMT00`000?l0fMWI0=WIf@04\n0=WIf@030000o`3IfMT0fMWI06T0fMWI000L0=WIf@030000003IfMT0fMWI08l0fMWI00<0003o0=WI\nf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@1Y0=WIf@00703IfMT00`000000fMWI0=WIf@2?0=WIf@03\n0000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0JP3IfMT001`0fMWI00<000000=WIf@3IfMT0\nT03IfMT010000?l0fMWI0=WIf@000?m]0=WIf@00703IfMT00`000000fMWI0=WIf@2A0=WIf@<0003o\nK@3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o\n0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0o`3IfMT20=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@009@3IfMT00`000000fMWI0=WIf@0Z0=WIf@030000003IfMT0fMWI00D0fMWI0P0000080=WIf@80\n0000^P3IfMT002@0fMWI00<000000=WIf@3IfMT0;03IfMT00`000000fMWI0=WIf@040=WIf@030000\n003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0^03IfMT002<0fMWI00<000000=WIf@3IfMT00`3I\nfMT2000000<0fMWI1`0000020=WIf@@0000000@0fMWI000000000000fMWI0P000000103IfMT00000\n0=WIf@0000020=WIf@8000000P3IfMT3000000030=WIf@000000000000<0fMWI00<000000=WIf@3I\nfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@800000103IfMT00`000000fMWI0=WIf@2h0=WIf@00\n8`3IfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0fMWI00000080fMWI100000020=WIf@04\n0000003IfMT0fMWI00000080fMWI00<000000=WIf@0000000`3IfMT01@000000fMWI0000003IfMT0\n000000L0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@030=WIf@050000003I\nfMT0fMWI0=WIf@0000000P3IfMT01@000000fMWI0=WIf@3IfMT000000;X0fMWI000F0=WIf@P0003o\n1@3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00H0fMWI00@000000=WIf@3IfMT0\n00000P3IfMT00`000000fMWI0=WIf@03000000<0fMWI00D000000=WIf@000000fMWI000000070=WI\nf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3I\nfMT0000000H0fMWI00<000000=WIf@3IfMT0^03IfMT002<0fMWI00@000000=WIf@3IfMT0fMWI1@00\n00030=WIf@<0000000<0fMWI0000000000000P0000030=WIf@050000003IfMT000000000003IfMT0\n0`0000000`3IfMT000000=WIf@070=WIf@<000001@3IfMT00`000000fMWI0=WIf@030=WIf@030000\n003IfMT0fMWI00D000000`3IfMT00`000000fMWI0=WIf@2h0=WIf@00903IfMT01@000000fMWI0=WI\nf@3IfMT000000140fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@040=WIf@030000\n003IfMT0fMWI00@0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0;P0\nfMWI000U0=WIf@030000003IfMT0fMWI0140fMWI0P00000@0=WIf@8000001@3IfMT00`000000fMWI\n0=WIf@050=WIf@800000203IfMT200000;X0fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI0000"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-30.4421`, -0.0744245`, 1.08639`, 0.00329462`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell[BoxData[TagBox[RowBox[List[RowBox[List["\[SkeletonIndicator]", "Graphics"]], "\[SkeletonIndicator]"]], False, Rule[Editable, False]]], "Output"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Renewed Tank Model with connector for input and output flow", "Section"], Cell["The imput flow in that case is constant and the output flow is regulated by the PI controller", "Text"], Cell[CellGroupData[List[Cell["Connectors", "Subsection"], Cell["connector ReadSignal\n  Real val;\nend ReadSignal;", "ModelicaInput"], Cell["", "Text"], Cell["connector ActSignal\n  Real act;\nend ActSignal;", "ModelicaInput"], Cell["", "Text"], Cell["connector LiquidFlow\n  Real lflow;\nend FlowIn;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Functions", "Subsection"], Cell["function LimitValue\n  input Real pMin;\n  input Real pMax;\n  input Real p;\n  output Real pLim;\nalgorithm\n  pLim := if p>pMax then pMax\n          else if p<pMin then pMin \n          else p;\nend LimitValue;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Components", "Subsection"], Cell["partial model Controller\n  parameter Real Ts=0.1;//sampling time[s]\n  parameter Real K=2;//gain\n  parameter Real T=10;//time constant[s]\n  parameter Real minV=-10,maxV=10;//limits for output\n  Real      ref,error,outCtr;\n  ReadSignal cInp;\n  ActSignal  cOut;\nequation\n  error = ref-cInp.val;\n  cOut.act = LimitValue(minV,maxV,outCtr);\nend Controller;", "ModelicaInput"], Cell["", "Text"], Cell["model PIcontinuousController\n  extends Controller(K=2,T=10);\n  Real  x; //state variable of continuous controller\nequation\n  der(x) = error/T;\n  outCtr = K*(x+error);\nend PIcontinuousController;\n", "ModelicaInput"], Cell["", "Text"], Cell["model PIDcontinuousController\n  extends Controller(K=2,T=10,maxV=0.02);\n  Real  x; //state variable of continuous controller\n  Real  y; //state variable of continuous controller\nequation\n  der(x) = error/T;\n  y=T*der(error);\n  outCtr = K*(x+error+y);\nend PIDcontinuousController;\n", "ModelicaInput"], Cell["", "Text"], Cell["model TankModified2\n  ReadSignal tOut;  // Connector, reading tank level\n  ActSignal  tInp;  // Connector, actuator controlling input flow\n  parameter Real area =0.5;      //[m2]\n  parameter Real flowGain =0.05;   //[m2/s]\n  Real h(start=0.0);    //tank level [m]\n  Real q;\n  LiquidFlow qIn;  // flow through input valve[m3/s]\n  LiquidFlow qOut; // flow through output valve[m3/s]\nequation\n  der(h)=(q-qOut.lflow)/area; //mass balance equation\n  q=if time>150 then 3*qIn.lflow else qIn.lflow ;\n  qOut.lflow=LimitValue(0,10,-flowGain*tInp.act);\n  tOut.val = h;\nend TankModified2;", "ModelicaInput"], Cell["", "Text"], Cell["model TankApplicationModifiedPIController\n  PIcontinuousController piContinuous;\n  TankModified2  tankm(area=1);\nequation\n  connect(tankm.tInp,piContinuous.cOut);\n  connect(tankm.tOut,piContinuous.cInp);\n  piContinuous.ref=0.25;\n  tankm.qIn.lflow=0.02;\nend TankApplicationModifiedPIController;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of TankApplicationModifiedPIController", "Subsection"], Cell["simulate( TankApplicationModifiedPIController, stopTime=250 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(TankApplicationModifiedPIController\\) : 2004-2-4 10:48:0.8375572 : \\!\\({0.`, 250.`}\\) : 504 data points : 2 events : 21 variables>\\n\\!\\({\\*TagBox[\\(piContinuous . cInp . val\\), HoldForm], \\*TagBox[\\(piContinuous . cOut . act\\), HoldForm], \\*TagBox[\\(piContinuous . error\\), HoldForm], \\*TagBox[\\(piContinuous . K\\), HoldForm], \\*TagBox[\\(piContinuous . maxV\\), HoldForm], \\*TagBox[\\(piContinuous . minV\\), HoldForm], \\*TagBox[\\(piContinuous . outCtr\\), HoldForm], \\*TagBox[\\(piContinuous . ref\\), HoldForm], \\*TagBox[\\(piContinuous . T\\), HoldForm], \\*TagBox[\\(piContinuous . Ts\\), HoldForm], \\*TagBox[\\(piContinuous . x\\), HoldForm], \\*TagBox[\\(tankm . area\\), HoldForm], \\*TagBox[\\(tankm . flowGain\\), HoldForm], \\*TagBox[\\(tankm . h\\), HoldForm], \\*TagBox[\\(tankm . q\\), HoldForm], \\*TagBox[\\(tankm . qIn . lflow\\), HoldForm], \\*TagBox[\\(tankm . qOut . lflow\\), HoldForm], \\*TagBox[\\(tankm . tInp . act\\), HoldForm], \\*TagBox[\\(tankm . tOut . val\\), HoldForm], \\*TagBox[SuperscriptBox[\\((piContinuous . x)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\((tankm . h)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( tankm.h );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.00380952 0.0147151 1.25617 [\n[.21429 .00222 -6 -9 ]\n[.21429 .00222 6 0 ]\n[.40476 .00222 -9 -9 ]\n[.40476 .00222 9 0 ]\n[.59524 .00222 -9 -9 ]\n[.59524 .00222 9 0 ]\n[.78571 .00222 -9 -9 ]\n[.78571 .00222 9 0 ]\n[.97619 .00222 -9 -9 ]\n[.97619 .00222 9 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .14033 -18 -4.5 ]\n[.01131 .14033 0 4.5 ]\n[.01131 .26595 -18 -4.5 ]\n[.01131 .26595 0 4.5 ]\n[.01131 .39157 -18 -4.5 ]\n[.01131 .39157 0 4.5 ]\n[.01131 .51718 -18 -4.5 ]\n[.01131 .51718 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .01472 m\n.21429 .02097 L\ns\n[(50)] .21429 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(100)] .40476 .00222 0 1 Mshowa\n.59524 .01472 m\n.59524 .02097 L\ns\n[(150)] .59524 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(200)] .78571 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(250)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.0619 .01472 m\n.0619 .01847 L\ns\n.1 .01472 m\n.1 .01847 L\ns\n.1381 .01472 m\n.1381 .01847 L\ns\n.17619 .01472 m\n.17619 .01847 L\ns\n.25238 .01472 m\n.25238 .01847 L\ns\n.29048 .01472 m\n.29048 .01847 L\ns\n.32857 .01472 m\n.32857 .01847 L\ns\n.36667 .01472 m\n.36667 .01847 L\ns\n.44286 .01472 m\n.44286 .01847 L\ns\n.48095 .01472 m\n.48095 .01847 L\ns\n.51905 .01472 m\n.51905 .01847 L\ns\n.55714 .01472 m\n.55714 .01847 L\ns\n.63333 .01472 m\n.63333 .01847 L\ns\n.67143 .01472 m\n.67143 .01847 L\ns\n.70952 .01472 m\n.70952 .01847 L\ns\n.74762 .01472 m\n.74762 .01847 L\ns\n.82381 .01472 m\n.82381 .01847 L\ns\n.8619 .01472 m\n.8619 .01847 L\ns\n.9 .01472 m\n.9 .01847 L\ns\n.9381 .01472 m\n.9381 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .14033 m\n.03006 .14033 L\ns\n[(0.1)] .01131 .14033 1 0 Mshowa\n.02381 .26595 m\n.03006 .26595 L\ns\n[(0.2)] .01131 .26595 1 0 Mshowa\n.02381 .39157 m\n.03006 .39157 L\ns\n[(0.3)] .01131 .39157 1 0 Mshowa\n.02381 .51718 m\n.03006 .51718 L\ns\n[(0.4)] .01131 .51718 1 0 Mshowa\n.125 Mabswid\n.02381 .03984 m\n.02756 .03984 L\ns\n.02381 .06496 m\n.02756 .06496 L\ns\n.02381 .09009 m\n.02756 .09009 L\ns\n.02381 .11521 m\n.02756 .11521 L\ns\n.02381 .16546 m\n.02756 .16546 L\ns\n.02381 .19058 m\n.02756 .19058 L\ns\n.02381 .2157 m\n.02756 .2157 L\ns\n.02381 .24083 m\n.02756 .24083 L\ns\n.02381 .29107 m\n.02756 .29107 L\ns\n.02381 .3162 m\n.02756 .3162 L\ns\n.02381 .34132 m\n.02756 .34132 L\ns\n.02381 .36644 m\n.02756 .36644 L\ns\n.02381 .41669 m\n.02756 .41669 L\ns\n.02381 .44181 m\n.02756 .44181 L\ns\n.02381 .46694 m\n.02756 .46694 L\ns\n.02381 .49206 m\n.02756 .49206 L\ns\n.02381 .54231 m\n.02756 .54231 L\ns\n.02381 .56743 m\n.02756 .56743 L\ns\n.02381 .59255 m\n.02756 .59255 L\ns\n.02381 .61768 m\n.02756 .61768 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .02728 L\n.02762 .03984 L\n.02952 .0524 L\n.03143 .06496 L\n.03333 .07752 L\n.03524 .09009 L\n.03714 .10265 L\n.03905 .11521 L\n.04095 .12777 L\n.04286 .14033 L\n.04476 .15289 L\n.04667 .16546 L\n.04857 .17802 L\n.05048 .19058 L\n.05238 .20314 L\n.05429 .2157 L\n.05619 .22826 L\n.0581 .24083 L\n.06 .25339 L\n.0619 .26595 L\n.06381 .27851 L\n.06571 .29107 L\n.06762 .30363 L\n.06952 .3162 L\n.07143 .32876 L\n.07333 .34132 L\n.07524 .35388 L\n.07714 .36644 L\n.07905 .379 L\n.08095 .39157 L\n.08286 .40413 L\n.08476 .41669 L\n.08667 .42925 L\n.08857 .44181 L\n.09048 .45438 L\n.09238 .46694 L\n.09429 .47937 L\n.09619 .49129 L\n.0981 .50236 L\n.1 .5125 L\n.1019 .5217 L\n.10381 .52998 L\n.10571 .53735 L\n.10762 .54386 L\n.10952 .54952 L\n.11143 .55437 L\n.11333 .55843 L\n.11524 .56174 L\n.11714 .56431 L\nMistroke\n.11905 .56619 L\n.12095 .56739 L\n.12286 .56795 L\n.12476 .56791 L\n.12667 .56728 L\n.12857 .5661 L\n.13048 .56439 L\n.13238 .5622 L\n.13429 .55954 L\n.13619 .55645 L\n.1381 .55295 L\n.14 .54908 L\n.1419 .54486 L\n.14381 .54032 L\n.14571 .53548 L\n.14762 .53038 L\n.14952 .52504 L\n.15143 .51947 L\n.15333 .51372 L\n.15524 .50779 L\n.15714 .50172 L\n.15905 .49552 L\n.16095 .48921 L\n.16286 .48283 L\n.16476 .47638 L\n.16667 .46988 L\n.16857 .46336 L\n.17048 .45683 L\n.17238 .45031 L\n.17429 .4438 L\n.17619 .43734 L\n.1781 .43092 L\n.18 .42457 L\n.1819 .41829 L\n.18381 .41211 L\n.18571 .40602 L\n.18762 .40004 L\n.18952 .39418 L\n.19143 .38844 L\n.19333 .38284 L\n.19524 .37738 L\n.19714 .37207 L\n.19905 .36691 L\n.20095 .36191 L\n.20286 .35707 L\n.20476 .3524 L\n.20667 .3479 L\n.20857 .34357 L\n.21048 .33942 L\n.21238 .33544 L\nMistroke\n.21429 .33164 L\n.21619 .32802 L\n.2181 .32458 L\n.22 .32132 L\n.2219 .31823 L\n.22381 .31532 L\n.22571 .31259 L\n.22762 .31003 L\n.22952 .30763 L\n.23143 .30541 L\n.23333 .30335 L\n.23524 .30146 L\n.23714 .29972 L\n.23905 .29814 L\n.24095 .29671 L\n.24286 .29543 L\n.24476 .29429 L\n.24667 .29329 L\n.24857 .29242 L\n.25048 .29169 L\n.25238 .29108 L\n.25429 .29059 L\n.25619 .29022 L\n.2581 .28995 L\n.26 .2898 L\n.2619 .28975 L\n.26381 .28979 L\n.26571 .28993 L\n.26762 .29015 L\n.26952 .29046 L\n.27143 .29084 L\n.27333 .2913 L\n.27524 .29183 L\n.27714 .29241 L\n.27905 .29306 L\n.28095 .29377 L\n.28286 .29452 L\n.28476 .29532 L\n.28667 .29617 L\n.28857 .29705 L\n.29048 .29796 L\n.29238 .29891 L\n.29429 .29988 L\n.29619 .30087 L\n.2981 .30189 L\n.3 .30292 L\n.3019 .30396 L\n.30381 .30502 L\n.30571 .30608 L\n.30762 .30714 L\nMistroke\n.30952 .3082 L\n.31143 .30926 L\n.31333 .31032 L\n.31524 .31137 L\n.31714 .31241 L\n.31905 .31345 L\n.32095 .31446 L\n.32286 .31547 L\n.32476 .31645 L\n.32667 .31742 L\n.32857 .31837 L\n.33048 .3193 L\n.33238 .32021 L\n.33429 .32109 L\n.33619 .32195 L\n.3381 .32278 L\n.34 .32359 L\n.3419 .32437 L\n.34381 .32512 L\n.34571 .32585 L\n.34762 .32655 L\n.34952 .32721 L\n.35143 .32786 L\n.35333 .32847 L\n.35524 .32905 L\n.35714 .3296 L\n.35905 .33012 L\n.36095 .33062 L\n.36286 .33108 L\n.36476 .33152 L\n.36667 .33193 L\n.36857 .33232 L\n.37048 .33267 L\n.37238 .333 L\n.37429 .3333 L\n.37619 .33358 L\n.3781 .33383 L\n.38 .33406 L\n.3819 .33426 L\n.38381 .33444 L\n.38571 .3346 L\n.38762 .33474 L\n.38952 .33485 L\n.39143 .33494 L\n.39333 .33502 L\n.39524 .33508 L\n.39714 .33511 L\n.39905 .33513 L\n.40095 .33514 L\n.40286 .33513 L\nMistroke\n.40476 .3351 L\n.40667 .33506 L\n.40857 .33501 L\n.41048 .33494 L\n.41238 .33486 L\n.41429 .33477 L\n.41619 .33467 L\n.4181 .33457 L\n.42 .33445 L\n.4219 .33432 L\n.42381 .33419 L\n.42571 .33405 L\n.42762 .3339 L\n.42952 .33375 L\n.43143 .3336 L\n.43333 .33344 L\n.43524 .33327 L\n.43714 .33311 L\n.43905 .33294 L\n.44095 .33276 L\n.44286 .33259 L\n.44476 .33242 L\n.44667 .33224 L\n.44857 .33207 L\n.45048 .3319 L\n.45238 .33172 L\n.45429 .33155 L\n.45619 .33138 L\n.4581 .33121 L\n.46 .33105 L\n.4619 .33089 L\n.46381 .33073 L\n.46571 .33057 L\n.46762 .33041 L\n.46952 .33026 L\n.47143 .33012 L\n.47333 .32997 L\n.47524 .32983 L\n.47714 .3297 L\n.47905 .32957 L\n.48095 .32944 L\n.48286 .32932 L\n.48476 .3292 L\n.48667 .32909 L\n.48857 .32898 L\n.49048 .32888 L\n.49238 .32878 L\n.49429 .32869 L\n.49619 .3286 L\n.4981 .32851 L\nMistroke\n.5 .32843 L\n.5019 .32836 L\n.50381 .32829 L\n.50571 .32822 L\n.50762 .32816 L\n.50952 .3281 L\n.51143 .32805 L\n.51333 .328 L\n.51524 .32796 L\n.51714 .32792 L\n.51905 .32788 L\n.52095 .32785 L\n.52286 .32782 L\n.52476 .3278 L\n.52667 .32777 L\n.52857 .32776 L\n.53048 .32774 L\n.53238 .32773 L\n.53429 .32772 L\n.53619 .32772 L\n.5381 .32771 L\n.54 .32771 L\n.5419 .32771 L\n.54381 .32772 L\n.54571 .32773 L\n.54762 .32773 L\n.54952 .32775 L\n.55143 .32776 L\n.55333 .32777 L\n.55524 .32779 L\n.55714 .32781 L\n.55905 .32783 L\n.56095 .32785 L\n.56286 .32787 L\n.56476 .32789 L\n.56667 .32792 L\n.56857 .32795 L\n.57048 .32797 L\n.57238 .328 L\n.57429 .32803 L\n.57619 .32805 L\n.5781 .32808 L\n.58 .32811 L\n.5819 .32814 L\n.58381 .32817 L\n.58571 .3282 L\n.58762 .32823 L\n.58952 .32826 L\n.59143 .32829 L\n.59333 .32831 L\nMistroke\n.59524 .32834 L\n.59524 .32834 L\n.59524 .32834 L\n.59714 .35286 L\n.59905 .37613 L\n.60095 .39815 L\n.60286 .41893 L\n.60476 .43847 L\n.60667 .4568 L\n.60857 .47392 L\n.61048 .48986 L\n.61238 .50462 L\n.61429 .51823 L\n.61619 .53072 L\n.6181 .5421 L\n.62 .55241 L\n.6219 .56167 L\n.62381 .56992 L\n.62571 .57717 L\n.62762 .58345 L\n.62952 .58882 L\n.63143 .59328 L\n.63333 .59688 L\n.63524 .59965 L\n.63714 .60162 L\n.63905 .60283 L\n.64095 .60332 L\n.64286 .60311 L\n.64476 .60224 L\n.64667 .60075 L\n.64857 .59867 L\n.65048 .59603 L\n.65238 .59287 L\n.65429 .58922 L\n.65619 .58511 L\n.6581 .58058 L\n.66 .57566 L\n.6619 .57037 L\n.66381 .56476 L\n.66571 .55884 L\n.66762 .55265 L\n.66952 .54621 L\n.67143 .53957 L\n.67333 .53273 L\n.67524 .52573 L\n.67714 .51859 L\n.67905 .51133 L\n.68095 .50399 L\n.68286 .49657 L\n.68476 .48911 L\nMistroke\n.68667 .48163 L\n.68857 .47413 L\n.69048 .46665 L\n.69238 .45919 L\n.69429 .45178 L\n.69619 .44444 L\n.6981 .43716 L\n.7 .42998 L\n.7019 .4229 L\n.70381 .41594 L\n.70571 .4091 L\n.70762 .40241 L\n.70952 .39585 L\n.71143 .38946 L\n.71333 .38323 L\n.71524 .37717 L\n.71714 .37129 L\n.71905 .36559 L\n.72095 .36008 L\n.72286 .35476 L\n.72476 .34964 L\n.72667 .34472 L\n.72857 .34 L\n.73048 .33549 L\n.73238 .33118 L\n.73429 .32707 L\n.73619 .32317 L\n.7381 .31947 L\n.74 .31597 L\n.7419 .31267 L\n.74381 .30958 L\n.74571 .30668 L\n.74762 .30398 L\n.74952 .30147 L\n.75143 .29915 L\n.75333 .29701 L\n.75524 .29506 L\n.75714 .29327 L\n.75905 .29167 L\n.76095 .29023 L\n.76286 .28895 L\n.76476 .28783 L\n.76667 .28687 L\n.76857 .28605 L\n.77048 .28538 L\n.77238 .28484 L\n.77429 .28444 L\n.77619 .28416 L\n.7781 .284 L\n.78 .28396 L\nMistroke\n.7819 .28403 L\n.78381 .28421 L\n.78571 .28448 L\n.78762 .28485 L\n.78952 .28531 L\n.79143 .28585 L\n.79333 .28647 L\n.79524 .28716 L\n.79714 .28791 L\n.79905 .28873 L\n.80095 .28961 L\n.80286 .29054 L\n.80476 .29152 L\n.80667 .29254 L\n.80857 .2936 L\n.81048 .29469 L\n.81238 .29582 L\n.81429 .29696 L\n.81619 .29813 L\n.8181 .29932 L\n.82 .30053 L\n.8219 .30174 L\n.82381 .30295 L\n.82571 .30417 L\n.82762 .3054 L\n.82952 .30661 L\n.83143 .30783 L\n.83333 .30903 L\n.83524 .31023 L\n.83714 .31141 L\n.83905 .31258 L\n.84095 .31373 L\n.84286 .31485 L\n.84476 .31596 L\n.84667 .31705 L\n.84857 .31811 L\n.85048 .31914 L\n.85238 .32015 L\n.85429 .32113 L\n.85619 .32208 L\n.8581 .323 L\n.86 .32389 L\n.8619 .32475 L\n.86381 .32557 L\n.86571 .32637 L\n.86762 .32713 L\n.86952 .32786 L\n.87143 .32855 L\n.87333 .32921 L\n.87524 .32984 L\nMistroke\n.87714 .33044 L\n.87905 .331 L\n.88095 .33153 L\n.88286 .33203 L\n.88476 .33249 L\n.88667 .33292 L\n.88857 .33333 L\n.89048 .3337 L\n.89238 .33404 L\n.89429 .33435 L\n.89619 .33464 L\n.8981 .33489 L\n.9 .33512 L\n.9019 .33532 L\n.90381 .3355 L\n.90571 .33565 L\n.90762 .33578 L\n.90952 .33588 L\n.91143 .33596 L\n.91333 .33602 L\n.91524 .33606 L\n.91714 .33608 L\n.91905 .33608 L\n.92095 .33607 L\n.92286 .33603 L\n.92476 .33599 L\n.92667 .33592 L\n.92857 .33584 L\n.93048 .33575 L\n.93238 .33564 L\n.93429 .33553 L\n.93619 .3354 L\n.9381 .33526 L\n.94 .33512 L\n.9419 .33496 L\n.94381 .3348 L\n.94571 .33463 L\n.94762 .33446 L\n.94952 .33428 L\n.95143 .33409 L\n.95333 .3339 L\n.95524 .33371 L\n.95714 .33352 L\n.95905 .33332 L\n.96095 .33312 L\n.96286 .33292 L\n.96476 .33272 L\n.96667 .33252 L\n.96857 .33232 L\n.97048 .33213 L\nMistroke\n.97238 .33193 L\n.97429 .33173 L\n.97619 .33154 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(tankm) show\n99.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(h) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(L) show\n117.000 12.813 moveto\n(@) show\n123.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n129.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00AP3IfMT2000000@0fMWI0P00000R0=WIf@D000000P3IfMT2000000@0\nfMWI0P00000O0=WIf@D000000P3IfMT2000000@0fMWI0P00000O0=WIf@@000000`3IfMT2000000@0\nfMWI0P00000O0=WIf@@000000`3IfMT2000000@0fMWI0P00000G0=WIf@00A@3IfMT010000000fMWI\n0=WIf@0000020=WIf@040000003IfMT0fMWI000002<0fMWI00D000000=WIf@3IfMT0fMWI00000002\n0=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT07P3IfMT01@000000fMWI0=WI\nf@3IfMT000000080fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@0L0=WIf@03\n0000003IfMT0fMWI00<0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@00000N\n0=WIf@030000003IfMT0fMWI00<0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WI\nf@00000F0=WIf@00B03IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI0240fMWI\n00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WI\nf@3IfMT07P3IfMT00`000000fMWI0=WIf@040=WIf@040000003IfMT0fMWI00000080fMWI00<00000\n0=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0fMWI00000080fMWI00@0\n00000=WIf@3IfMT000007`3IfMT00`000000fMWI0=WIf@050=WIf@040000003IfMT0fMWI00000080\nfMWI00<000000=WIf@3IfMT0503IfMT004H0fMWI0P0000030=WIf@040000003IfMT0fMWI000002<0\nfMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00<00000\n0=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@020=WIf@8000000`3IfMT010000000fMWI0=WIf@00\n000P0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@03\n0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT00P3IfMT2000000<0fMWI00@000000=WIf@3I\nfMT000005P3IfMT004H0fMWI00<000000=WIf@3IfMT00P3IfMT010000000fMWI0=WIf@00000S0=WI\nf@050000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@030000003I\nfMT0fMWI01h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@020=WIf@040000003I\nfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000020=WI\nf@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000000`3IfMT00`000000fMWI0=WI\nf@020=WIf@040000003IfMT0fMWI000001H0fMWI00160=WIf@<000000`3IfMT2000002<0fMWI0P00\n00040=WIf@800000103IfMT200000200fMWI0P0000040=WIf@<000000`3IfMT200000200fMWI0P00\n00040=WIf@800000103IfMT200000200fMWI0P0000040=WIf@<000000`3IfMT2000001L0fMWI003o\n0=WIfB40fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3b0=WIf@8000003@3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0l@3IfMT010000000fMWI0=WIf@00000<0=WIf@005P3IfMT6000000030000o`00\n000000000>T00000203IfMT00`000000fMWI0=WIf@0=0=WIf@00703IfMT00`000?l0fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@07\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@07\n0=WIf@030000003IfMT0fMWI00X0fMWI1@00000<0=WIf@00703IfMT00`000?l0fMWI0=WIf@3a0=WI\nf@030000003IfMT0fMWI00d0fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI\n00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WI\nf@00703IfMT00`000000003o0=WIf@3o0=WIf@80fMWI000L0=WIf@03000000000?l0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<000000000o`3IfMT0o`3IfMT20=WIf@00703IfMT00`000000003o0=WIf@3o\n0=WIf@80fMWI000L0=WIf@03000000000?l0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000000o`3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0000o`3o0=WIf@80fMWI000L0=WIf@030000003I\nfMT0003o0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@000?l0o`3IfMT20=WIf@00703IfMT00`00\n0000fMWI0000o`3o0=WIf@80fMWI000L0=WIf@030000003IfMT0003o0?l0fMWI0P3IfMT001`0fMWI\n00<000000=WIf@000?l0o`3IfMT20=WIf@00703IfMT010000000fMWI0=WIf@000?oo0=WIf@40fMWI\n000L0=WIf@040000003IfMT0fMWI0000ool0fMWI0@3IfMT001`0fMWI00@000000=WIf@3IfMT0003o\no`3IfMT10=WIf@00703IfMT010000000fMWI0=WIf@000?oo0=WIf@40fMWI000L0=WIf@040000003I\nfMT0fMWI0000ool0fMWI0@3IfMT001`0fMWI00@000000=WIf@3IfMT0003oo`3IfMT10=WIf@00703I\nfMT01@000000fMWI0=WIf@3IfMT0003o0?l0fMWI000L0=WIf@050000003IfMT0fMWI0=WIf@000?l0\no`3IfMT000T0fMWI0P0000040=WIf@8000000`3IfMT5000000<0fMWI00D000000=WIf@3IfMT0fMWI\n0000o`3o0=WIf@00203IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI00<0fMWI\n00D000000=WIf@3IfMT0fMWI0000o`3o0=WIf@00203IfMT010000000fMWI0=WIf@00000:0=WIf@03\n0000003IfMT0fMWI00<0fMWI0P0000020=WIf@030000o`3IfMT0fMWI0?d0fMWI00080=WIf@040000\n003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT0003o\n0?l0fMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00`3IfMT00`00\n0000fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI0?`0fMWI00090=WIf@8000002P3IfMT2000000D0\nfMWI00<000000=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@3l0=WIf@00703IfMT00`000000fMWI\n0=WIf@020=WIf@030000o`3IfMT0fMWI0?`0fMWI000L0=WIf@030000003IfMT0fMWI0080fMWI00<0\n003o0=WIf@3IfMT0o03IfMT001`0fMWI00<000000=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@3l\n0=WIf@00703IfMT00`000000fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI0?`0fMWI000L0=WIf@03\n0000003IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0n`3IfMT001`0fMWI00<000000=WIf@3IfMT0\n0`3IfMT00`000?l0fMWI0=WIf@3k0=WIf@00703IfMT00`000000fMWI0=WIf@030=WIf@030000o`3I\nfMT0fMWI0?/0fMWI000L0=WIf@030000003IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0n`3IfMT0\n01`0fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@3k0=WIf@00703IfMT00`000000\nfMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0?/0fMWI000L0=WIf@030000003IfMT0fMWI00<0fMWI\n00<0003o0=WIf@3IfMT0n`3IfMT001`0fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WI\nf@3k0=WIf@00703IfMT00`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0?/0fMWI000L0=WI\nf@030000003IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT0nP3IfMT001`0fMWI00<000000=WIf@3I\nfMT0103IfMT00`000?l0fMWI0=WIf@3j0=WIf@00703IfMT00`000000fMWI0=WIf@040=WIf@030000\no`3IfMT0fMWI0?X0fMWI000L0=WIf@030000003IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT0nP3I\nfMT001`0fMWI00<000000=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@3j0=WIf@00703IfMT00`00\n0000fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0?X0fMWI000L0=WIf@030000003IfMT0fMWI00D0\nfMWI00<0003o0=WIf@3IfMT0n@3IfMT001`0fMWI00<000000=WIf@3IfMT01@3IfMT00`000?l0fMWI\n0=WIf@3i0=WIf@00703IfMT00`000000fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0?T0fMWI000L\n0=WIf@030000003IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0n@3IfMT001`0fMWI00<000000=WI\nf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@3i0=WIf@00703IfMT00`000000fMWI0=WIf@050=WIf@03\n0000o`3IfMT0fMWI0?T0fMWI00090=WIf@800000103IfMT2000000<0fMWI100000040=WIf@030000\n003IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0n@3IfMT000P0fMWI00@000000=WIf@3IfMT00000\n203IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0\nn03IfMT000P0fMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@040=WIf@800000\n1`3IfMT00`000?l0fMWI0=WIf@3h0=WIf@00203IfMT010000000fMWI0=WIf@00000:0=WIf@030000\n003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@3h0=WIf@00203I\nfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3I\nfMT01P3IfMT00`000?l0fMWI0=WIf@3h0=WIf@002@3IfMT2000000X0fMWI0P0000050=WIf@030000\n003IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0n03IfMT001`0fMWI00<000000=WIf@3IfMT01P3I\nfMT00`000?l0fMWI0=WIf@2W0=WIf@L0003oBP3IfMT001`0fMWI00<000000=WIf@3IfMT01`3IfMT0\n0`000?l0fMWI0=WIf@0Z0=WIf@D0003oMP3IfMT20000o`D0fMWI10000?m70=WIf@00703IfMT00`00\n0000fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI02P0fMWI0`000?l30=WIf@@0003oLP3IfMT00`00\n0?l0fMWI0=WIf@080=WIf@<0003oA@3IfMT001`0fMWI00<000000=WIf@3IfMT01`3IfMT00`000?l0\nfMWI0=WIf@0W0=WIf@030000o`3IfMT0fMWI00P0fMWI0P000?m_0=WIf@030000o`3IfMT0fMWI00/0\nfMWI0P000?m40=WIf@00703IfMT00`000000fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI02H0fMWI\n00<0003o0=WIf@3IfMT02P3IfMT30000of`0fMWI00<0003o0=WIf@3IfMT03@3IfMT30000od80fMWI\n000L0=WIf@030000003IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT09@3IfMT00`000?l0fMWI0=WI\nf@0>0=WIf@80003oJ@3IfMT00`000?l0fMWI0=WIf@0@0=WIf@80003o@@3IfMT001`0fMWI00<00000\n0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0T0=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o\n0=WIf@3IfMT0I@3IfMT00`000?l0fMWI0=WIf@0C0=WIf@80003o?`3IfMT001`0fMWI00<000000=WI\nf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0R0=WIf@030000o`3IfMT0fMWI01<0fMWI0P000?mU0=WI\nf@030000o`3IfMT0fMWI01@0fMWI0P000?ln0=WIf@00703IfMT00`000000fMWI0=WIf@080=WIf@03\n0000o`3IfMT0fMWI0240fMWI00<0003o0=WIf@3IfMT05P3IfMT30000of40fMWI0P000?lH0=WIf@80\n003o?03IfMT001`0fMWI00<000000=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0Q0=WIf@030000\no`3IfMT0fMWI01P0fMWI0`000?mO0=WIf@030000o`3IfMT0fMWI01T0fMWI0P000?lj0=WIf@00703I\nfMT00`000000fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI0200fMWI00<0003o0=WIf@3IfMT06`3I\nfMT30000obT0fMWI2P000?l80=WIf@030000o`3IfMT0fMWI01h0fMWI00<0003o0=WIf@3IfMT0703I\nfMT20000ocP0fMWI000L0=WIf@030000003IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0803IfMT0\n0`000?l0fMWI0=WIf@0N0=WIf@@0003o503IfMTA0000o`X0fMWI2@000?lP0=WIf@030000o`3IfMT0\nfMWI01h0fMWI10000?lE0=WIf@80003o7@3IfMT001`0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0?l0fMWI0=WIf@0O0=WIf@030000o`3IfMT0fMWI02<0fMWI50000?lS0=WIf@030000o`3IfMT0fMWI\n01d0fMWI00<0003o0=WIf@3IfMT08P3IfMTF0000oal0fMWI000L0=WIf@030000003IfMT0fMWI00P0\nfMWI00<0003o0=WIf@3IfMT07`3IfMT00`000?l0fMWI0=WIf@1J0=WIf@030000o`3IfMT0fMWI01d0\nfMWI00<0003o0=WIf@3IfMT0E`3IfMT001`0fMWI00<000000=WIf@3IfMT0203IfMT00`000?l0fMWI\n0=WIf@0N0=WIf@030000o`3IfMT0fMWI05/0fMWI00<0003o0=WIf@3IfMT0703IfMT00`000?l0fMWI\n0=WIf@1H0=WIf@00703IfMT00`000000fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI01h0fMWI00<0\n003o0=WIf@3IfMT0F`3IfMT00`000?l0fMWI0=WIf@0L0=WIf@030000o`3IfMT0fMWI05P0fMWI000L\n0=WIf@030000003IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0703IfMT00`000?l0fMWI0=WIf@1L\n0=WIf@030000o`3IfMT0fMWI01`0fMWI00<0003o0=WIf@3IfMT0F03IfMT001`0fMWI00<000000=WI\nf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0L0=WIf@030000o`3IfMT0fMWI05`0fMWI00<0003o0=WI\nf@3IfMT06`3IfMT00`000?l0fMWI0=WIf@1I0=WIf@00703IfMT00`000000fMWI0=WIf@090=WIf@03\n0000o`3IfMT0fMWI01`0fMWI00<0003o0=WIf@3IfMT0G03IfMT00`000?l0fMWI0=WIf@0K0=WIf@03\n0000o`3IfMT0fMWI05T0fMWI000L0=WIf@030000003IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0\n6`3IfMT00`000?l0fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI01/0fMWI00<0003o0=WIf@3IfMT0\nF@3IfMT001`0fMWI00<000000=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0K0=WIf@030000o`3I\nfMT0fMWI05h0fMWI00<0003o0=WIf@3IfMT06P3IfMT00`000?l0fMWI0=WIf@1I0=WIf@00703IfMT0\n0`000000fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI01X0fMWI00<0003o0=WIf@3IfMT0G`3IfMT0\n0`000?l0fMWI0=WIf@0I0=WIf@030000o`3IfMT0fMWI05X0fMWI000L0=WIf@030000003IfMT0fMWI\n00X0fMWI00<0003o0=WIf@3IfMT06@3IfMT00`000?l0fMWI0=WIf@1O0=WIf@030000o`3IfMT0fMWI\n01T0fMWI00<0003o0=WIf@3IfMT0FP3IfMT001`0fMWI00<000000=WIf@3IfMT02P3IfMT00`000?l0\nfMWI0=WIf@0H0=WIf@030000o`3IfMT0fMWI0600fMWI00<0003o0=WIf@3IfMT0603IfMT00`000?l0\nfMWI0=WIf@1K0=WIf@002@3IfMT2000000@0fMWI0P0000040=WIf@8000001@3IfMT00`000000fMWI\n0=WIf@0:0=WIf@030000o`3IfMT0fMWI01P0fMWI00<0003o0=WIf@3IfMT0H03IfMT00`000?l0fMWI\n0=WIf@0H0=WIf@030000o`3IfMT0fMWI05/0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI\n00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI01P0\nfMWI00<0003o0=WIf@3IfMT0H03IfMT00`000?l0fMWI0=WIf@0H0=WIf@030000o`3IfMT0fMWI05/0\nfMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00`3IfMT2000000/0\nfMWI00<0003o0=WIf@3IfMT0603IfMT00`000?l0fMWI0=WIf@1P0=WIf@030000o`3IfMT0fMWI01L0\nfMWI00<0003o0=WIf@3IfMT0G03IfMT000P0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000\nfMWI0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0603IfMT00`000?l0\nfMWI0=WIf@1P0=WIf@030000o`3IfMT0fMWI01L0fMWI00<0003o0=WIf@3IfMT0G03IfMT000P0fMWI\n00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI\n00/0fMWI00<0003o0=WIf@3IfMT05P3IfMT00`000?l0fMWI0=WIf@1Q0=WIf@030000o`3IfMT0fMWI\n01L0fMWI00<0003o0=WIf@3IfMT0G03IfMT000T0fMWI0P00000:0=WIf@8000001@3IfMT00`000000\nfMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI01H0fMWI00<0003o0=WIf@3IfMT0H@3IfMT00`000?l0\nfMWI0=WIf@0G0=WIf@030000o`3IfMT0fMWI05`0fMWI000L0=WIf@030000003IfMT0fMWI00/0fMWI\n00<0003o0=WIf@3IfMT05@3IfMT00`000?l0fMWI0=WIf@1R0=WIf@030000o`3IfMT0fMWI01H0fMWI\n00<0003o0=WIf@3IfMT0G@3IfMT001`0fMWI00<000000=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WI\nf@0E0=WIf@030000o`3IfMT0fMWI0680fMWI00<0003o0=WIf@3IfMT05P3IfMT00`000?l0fMWI0=WI\nf@1M0=WIf@00703IfMT00`000000fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI01D0fMWI00<0003o\n0=WIf@3IfMT0HP3IfMT00`000?l0fMWI0=WIf@0F0=WIf@030000o`3IfMT0fMWI05d0fMWI000L0=WI\nf@030000003IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@1S0=WI\nf@030000o`3IfMT0fMWI01D0fMWI00<0003o0=WIf@3IfMT0GP3IfMT001`0fMWI00<000000=WIf@3I\nfMT0303IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI06<0fMWI00<0003o0=WIf@3I\nfMT05@3IfMT00`000?l0fMWI0=WIf@1N0=WIf@00703IfMT00`000000fMWI0=WIf@0<0=WIf@030000\no`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0H`3IfMT00`000?l0fMWI0=WIf@0E0=WIf@030000\no`3IfMT0fMWI05h0fMWI000L0=WIf@030000003IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT04P3I\nfMT00`000?l0fMWI0=WIf@1U0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0G`3I\nfMT001`0fMWI00<000000=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0\nfMWI06D0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@1O0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0I@3IfMT00`00\n0?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI05l0fMWI000L0=WIf@030000003IfMT0fMWI00`0\nfMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@1U0=WIf@030000o`3IfMT0fMWI01<0\nfMWI00<0003o0=WIf@3IfMT0G`3IfMT001`0fMWI00<000000=WIf@3IfMT03@3IfMT00`000?l0fMWI\n0=WIf@0@0=WIf@030000o`3IfMT0fMWI06H0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI\n0=WIf@1O0=WIf@00703IfMT00`000000fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI0100fMWI00<0\n003o0=WIf@3IfMT0IP3IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI0600fMWI000L\n0=WIf@030000003IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@1V\n0=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0H03IfMT001`0fMWI00<000000=WI\nf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI06H0fMWI00<0003o0=WI\nf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@1P0=WIf@00703IfMT00`000000fMWI0=WIf@0=0=WIf@03\n0000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT0I`3IfMT00`000?l0fMWI0=WIf@0B0=WIf@03\n0000o`3IfMT0fMWI0600fMWI000L0=WIf@030000003IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0\n3`3IfMT00`000?l0fMWI0=WIf@1X0=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT0\nH@3IfMT001`0fMWI00<000000=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3I\nfMT0fMWI06P0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@1Q0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0J@3IfMT0\n0`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI0640fMWI000L0=WIf@030000003IfMT0fMWI\n00h0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@1Y0=WIf@030000o`3IfMT0fMWI\n0100fMWI00<0003o0=WIf@3IfMT0H@3IfMT001`0fMWI00<000000=WIf@3IfMT03P3IfMT00`000?l0\nfMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI06T0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0\nfMWI0=WIf@1R0=WIf@00703IfMT00`000000fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00`0fMWI\n00<0003o0=WIf@3IfMT0JP3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI0680fMWI\n000L0=WIf@030000003IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WI\nf@1Z0=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT0HP3IfMT001`0fMWI00<00000\n0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI06/0fMWI00<0003o\n0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@1S0=WIf@00703IfMT00`000000fMWI0=WIf@0>0=WI\nf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT0J`3IfMT00`000?l0fMWI0=WIf@0=0=WI\nf@030000o`3IfMT0fMWI06<0fMWI00090=WIf@800000103IfMT2000000D0fMWI0`0000030=WIf@03\n0000003IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@1/0=WIf@03\n0000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0H`3IfMT000P0fMWI00@000000=WIf@3IfMT0\n00002`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI00<0003o0=WIf@3I\nfMT02P3IfMT00`000?l0fMWI0=WIf@1/0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3I\nfMT0H`3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT5000000<0fMWI0P00000@0=WIf@03\n0000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0K@3IfMT00`000?l0fMWI0=WIf@0<0=WIf@03\n0000o`3IfMT0fMWI06@0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3I\nfMT00000103IfMT00`000000fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WI\nf@3IfMT0K@3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI06@0fMWI00080=WIf@04\n0000003IfMT0fMWI000000T0fMWI00<000000=WIf@000000103IfMT00`000000fMWI0=WIf@0?0=WI\nf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0K@3IfMT00`000?l0fMWI0=WIf@0<0=WI\nf@030000o`3IfMT0fMWI06@0fMWI00090=WIf@8000002`3IfMT2000000@0fMWI00<000000=WIf@3I\nfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI06l0fMWI00<0003o0=WIf@3I\nfMT02P3IfMT00`000?l0fMWI0=WIf@1U0=WIf@00703IfMT00`000000fMWI0=WIf@0@0=WIf@030000\no`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0K`3IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000\no`3IfMT0fMWI06D0fMWI000L0=WIf@030000003IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01`3I\nfMT00`000?l0fMWI0=WIf@1_0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0I@3I\nfMT001`0fMWI00<000000=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0\nfMWI06l0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@1U0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0L03IfMT00`00\n0?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI06D0fMWI000L0=WIf@030000003IfMT0fMWI0140\nfMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@1a0=WIf@030000o`3IfMT0fMWI00P0\nfMWI00<0003o0=WIf@3IfMT0IP3IfMT001`0fMWI00<000000=WIf@3IfMT04P3IfMT00`000?l0fMWI\n0=WIf@030=WIf@030000o`3IfMT0fMWI0780fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI\n0=WIf@1V0=WIf@00703IfMT00`000000fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI0080fMWI0P00\n0?md0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0IP3IfMT001`0fMWI00<00000\n0=WIf@3IfMT04`3IfMT01@000?l0fMWI0=WIf@3IfMT0003o07D0fMWI00<0003o0=WIf@3IfMT01`3I\nfMT00`000?l0fMWI0=WIf@1W0=WIf@00703IfMT00`000000fMWI0=WIf@0C0=WIf@@0003oMP3IfMT0\n0`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI06L0fMWI000L0=WIf@030000003IfMT0fMWI\n01@0fMWI0P000?mg0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0I`3IfMT001`0\nfMWI00<000000=WIf@3IfMT0S@3IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI06P0\nfMWI000L0=WIf@030000003IfMT0fMWI08h0fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI\n0=WIf@1X0=WIf@00703IfMT00`000000fMWI0=WIf@2>0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0\n003o0=WIf@3IfMT0J03IfMT001`0fMWI00<000000=WIf@3IfMT0SP3IfMT00`000?l0fMWI0=WIf@04\n0=WIf@030000o`3IfMT0fMWI06T0fMWI000L0=WIf@030000003IfMT0fMWI08l0fMWI00<0003o0=WI\nf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@1Y0=WIf@00703IfMT00`000000fMWI0=WIf@2?0=WIf@03\n0000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0JP3IfMT001`0fMWI00<000000=WIf@3IfMT0\nT03IfMT010000?l0fMWI0=WIf@000?m]0=WIf@00703IfMT00`000000fMWI0=WIf@2A0=WIf@<0003o\nK@3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o\n0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0o`3IfMT20=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@009@3IfMT00`000000fMWI0=WIf@0Z0=WIf@030000003IfMT0fMWI00D0fMWI0P0000080=WIf@80\n0000^P3IfMT002@0fMWI00<000000=WIf@3IfMT0;03IfMT00`000000fMWI0=WIf@040=WIf@030000\n003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0^03IfMT002<0fMWI00<000000=WIf@3IfMT00`3I\nfMT2000000<0fMWI1`0000020=WIf@@0000000@0fMWI000000000000fMWI0P000000103IfMT00000\n0=WIf@0000020=WIf@8000000P3IfMT3000000030=WIf@000000000000<0fMWI00<000000=WIf@3I\nfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@800000103IfMT00`000000fMWI0=WIf@2h0=WIf@00\n8`3IfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0fMWI00000080fMWI100000020=WIf@04\n0000003IfMT0fMWI00000080fMWI00<000000=WIf@0000000`3IfMT01@000000fMWI0000003IfMT0\n000000L0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@030=WIf@050000003I\nfMT0fMWI0=WIf@0000000P3IfMT01@000000fMWI0=WIf@3IfMT000000;X0fMWI000F0=WIf@P0003o\n1@3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00H0fMWI00@000000=WIf@3IfMT0\n00000P3IfMT00`000000fMWI0=WIf@03000000<0fMWI00D000000=WIf@000000fMWI000000070=WI\nf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3I\nfMT0000000H0fMWI00<000000=WIf@3IfMT0^03IfMT002<0fMWI00@000000=WIf@3IfMT0fMWI1@00\n00030=WIf@<0000000<0fMWI0000000000000P0000030=WIf@050000003IfMT000000000003IfMT0\n0`0000000`3IfMT000000=WIf@070=WIf@<000001@3IfMT00`000000fMWI0=WIf@030=WIf@030000\n003IfMT0fMWI00D000000`3IfMT00`000000fMWI0=WIf@2h0=WIf@00903IfMT01@000000fMWI0=WI\nf@3IfMT000000140fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@040=WIf@030000\n003IfMT0fMWI00@0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0;P0\nfMWI000U0=WIf@030000003IfMT0fMWI0140fMWI0P00000@0=WIf@8000001@3IfMT00`000000fMWI\n0=WIf@050=WIf@800000203IfMT200000;X0fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI0000"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-30.4421`, -0.0744245`, 1.08639`, 0.00329462`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell[BoxData[TagBox[RowBox[List[RowBox[List["\[SkeletonIndicator]", "Graphics"]], "\[SkeletonIndicator]"]], False, Rule[Editable, False]]], "Output"], Cell["model TankApplicationModifiedPIDController\n  PIDcontinuousController pidContinuous;\n  TankModified2  tankm(area=1);\nequation\n  connect(tankm.tInp,pidContinuous.cOut);\n  connect(tankm.tOut,pidContinuous.cInp);\n  pidContinuous.ref=0.25;\n  tankm.qIn.lflow=0.02;\nend TankApplicationModifiedPIDController;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of TankApplicationModifiedPIDController", "Subsection"], Cell["simulate( TankApplicationModifiedPIDController, stopTime=250 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(TankApplicationModifiedPIDController\\) : 2004-2-4 10:48:7.5405535 : \\!\\({0.`, 250.`}\\) : 504 data points : 2 events : 23 variables>\\n\\!\\({\\*TagBox[\\(pidContinuous . cInp . val\\), HoldForm], \\*TagBox[\\(pidContinuous . cOut . act\\), HoldForm], \\*TagBox[\\(pidContinuous . error\\), HoldForm], \\*TagBox[\\(pidContinuous . K\\), HoldForm], \\*TagBox[\\(pidContinuous . maxV\\), HoldForm], \\*TagBox[\\(pidContinuous . minV\\), HoldForm], \\*TagBox[\\(pidContinuous . outCtr\\), HoldForm], \\*TagBox[\\(pidContinuous . ref\\), HoldForm], \\*TagBox[\\(pidContinuous . T\\), HoldForm], \\*TagBox[\\(pidContinuous . Ts\\), HoldForm], \\*TagBox[\\(pidContinuous . x\\), HoldForm], \\*TagBox[\\(pidContinuous . y\\), HoldForm], \\*TagBox[\\(tankm . area\\), HoldForm], \\*TagBox[\\(tankm . flowGain\\), HoldForm], \\*TagBox[\\(tankm . h\\), HoldForm], \\*TagBox[\\(tankm . q\\), HoldForm], \\*TagBox[\\(tankm . qIn . lflow\\), HoldForm], \\*TagBox[\\(tankm . qOut . lflow\\), HoldForm], \\*TagBox[\\(tankm . tInp . act\\), HoldForm], \\*TagBox[\\(tankm . tOut . val\\), HoldForm], \\*TagBox[SuperscriptBox[\\((pidContinuous . error)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\((pidContinuous . x)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\((tankm . h)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( tankm.h );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.00380952 0.0147151 1.38483 [\n[.21429 .00222 -6 -9 ]\n[.21429 .00222 6 0 ]\n[.40476 .00222 -9 -9 ]\n[.40476 .00222 9 0 ]\n[.59524 .00222 -9 -9 ]\n[.59524 .00222 9 0 ]\n[.78571 .00222 -9 -9 ]\n[.78571 .00222 9 0 ]\n[.97619 .00222 -9 -9 ]\n[.97619 .00222 9 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .1532 -18 -4.5 ]\n[.01131 .1532 0 4.5 ]\n[.01131 .29168 -18 -4.5 ]\n[.01131 .29168 0 4.5 ]\n[.01131 .43017 -18 -4.5 ]\n[.01131 .43017 0 4.5 ]\n[.01131 .56865 -18 -4.5 ]\n[.01131 .56865 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .01472 m\n.21429 .02097 L\ns\n[(50)] .21429 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(100)] .40476 .00222 0 1 Mshowa\n.59524 .01472 m\n.59524 .02097 L\ns\n[(150)] .59524 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(200)] .78571 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(250)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.0619 .01472 m\n.0619 .01847 L\ns\n.1 .01472 m\n.1 .01847 L\ns\n.1381 .01472 m\n.1381 .01847 L\ns\n.17619 .01472 m\n.17619 .01847 L\ns\n.25238 .01472 m\n.25238 .01847 L\ns\n.29048 .01472 m\n.29048 .01847 L\ns\n.32857 .01472 m\n.32857 .01847 L\ns\n.36667 .01472 m\n.36667 .01847 L\ns\n.44286 .01472 m\n.44286 .01847 L\ns\n.48095 .01472 m\n.48095 .01847 L\ns\n.51905 .01472 m\n.51905 .01847 L\ns\n.55714 .01472 m\n.55714 .01847 L\ns\n.63333 .01472 m\n.63333 .01847 L\ns\n.67143 .01472 m\n.67143 .01847 L\ns\n.70952 .01472 m\n.70952 .01847 L\ns\n.74762 .01472 m\n.74762 .01847 L\ns\n.82381 .01472 m\n.82381 .01847 L\ns\n.8619 .01472 m\n.8619 .01847 L\ns\n.9 .01472 m\n.9 .01847 L\ns\n.9381 .01472 m\n.9381 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .1532 m\n.03006 .1532 L\ns\n[(0.1)] .01131 .1532 1 0 Mshowa\n.02381 .29168 m\n.03006 .29168 L\ns\n[(0.2)] .01131 .29168 1 0 Mshowa\n.02381 .43017 m\n.03006 .43017 L\ns\n[(0.3)] .01131 .43017 1 0 Mshowa\n.02381 .56865 m\n.03006 .56865 L\ns\n[(0.4)] .01131 .56865 1 0 Mshowa\n.125 Mabswid\n.02381 .04241 m\n.02756 .04241 L\ns\n.02381 .07011 m\n.02756 .07011 L\ns\n.02381 .09781 m\n.02756 .09781 L\ns\n.02381 .1255 m\n.02756 .1255 L\ns\n.02381 .1809 m\n.02756 .1809 L\ns\n.02381 .20859 m\n.02756 .20859 L\ns\n.02381 .23629 m\n.02756 .23629 L\ns\n.02381 .26399 m\n.02756 .26399 L\ns\n.02381 .31938 m\n.02756 .31938 L\ns\n.02381 .34708 m\n.02756 .34708 L\ns\n.02381 .37477 m\n.02756 .37477 L\ns\n.02381 .40247 m\n.02756 .40247 L\ns\n.02381 .45786 m\n.02756 .45786 L\ns\n.02381 .48556 m\n.02756 .48556 L\ns\n.02381 .51326 m\n.02756 .51326 L\ns\n.02381 .54095 m\n.02756 .54095 L\ns\n.02381 .59635 m\n.02756 .59635 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .02856 L\n.02762 .04241 L\n.02952 .05626 L\n.03143 .07011 L\n.03333 .08396 L\n.03524 .09781 L\n.03714 .11165 L\n.03905 .1255 L\n.04095 .13935 L\n.04286 .1532 L\n.04476 .16705 L\n.04667 .1809 L\n.04857 .19474 L\n.05048 .20859 L\n.05238 .22244 L\n.05429 .23629 L\n.05619 .2501 L\n.0581 .26388 L\n.06 .27765 L\n.0619 .29141 L\n.06381 .30501 L\n.06571 .31839 L\n.06762 .33155 L\n.06952 .34441 L\n.07143 .35698 L\n.07333 .36926 L\n.07524 .38122 L\n.07714 .39287 L\n.07905 .40419 L\n.08095 .41519 L\n.08286 .42584 L\n.08476 .43615 L\n.08667 .44612 L\n.08857 .45574 L\n.09048 .46501 L\n.09238 .47392 L\n.09429 .48248 L\n.09619 .49067 L\n.0981 .49849 L\n.1 .50596 L\n.1019 .51307 L\n.10381 .5198 L\n.10571 .52618 L\n.10762 .5322 L\n.10952 .53785 L\n.11143 .54315 L\n.11333 .54809 L\n.11524 .55268 L\n.11714 .55691 L\nMistroke\n.11905 .5608 L\n.12095 .56435 L\n.12286 .56756 L\n.12476 .57043 L\n.12667 .57297 L\n.12857 .57518 L\n.13048 .57708 L\n.13238 .57865 L\n.13429 .57992 L\n.13619 .58089 L\n.1381 .58156 L\n.14 .58195 L\n.1419 .58205 L\n.14381 .58188 L\n.14571 .58144 L\n.14762 .58073 L\n.14952 .57977 L\n.15143 .57856 L\n.15333 .57712 L\n.15524 .57544 L\n.15714 .57354 L\n.15905 .57143 L\n.16095 .5691 L\n.16286 .56658 L\n.16476 .56386 L\n.16667 .56096 L\n.16857 .55789 L\n.17048 .55465 L\n.17238 .55126 L\n.17429 .5477 L\n.17619 .54401 L\n.1781 .54018 L\n.18 .53622 L\n.1819 .53215 L\n.18381 .52797 L\n.18571 .52368 L\n.18762 .5193 L\n.18952 .51483 L\n.19143 .51028 L\n.19333 .50566 L\n.19524 .50097 L\n.19714 .49623 L\n.19905 .49144 L\n.20095 .48661 L\n.20286 .48174 L\n.20476 .47684 L\n.20667 .47192 L\n.20857 .46699 L\n.21048 .46205 L\n.21238 .4571 L\nMistroke\n.21429 .45216 L\n.21619 .44723 L\n.2181 .44232 L\n.22 .43742 L\n.2219 .43255 L\n.22381 .42772 L\n.22571 .42292 L\n.22762 .41816 L\n.22952 .41345 L\n.23143 .40879 L\n.23333 .40419 L\n.23524 .39965 L\n.23714 .39517 L\n.23905 .39076 L\n.24095 .38642 L\n.24286 .38216 L\n.24476 .37798 L\n.24667 .37388 L\n.24857 .36986 L\n.25048 .36594 L\n.25238 .3621 L\n.25429 .35835 L\n.25619 .35471 L\n.2581 .35115 L\n.26 .3477 L\n.2619 .34435 L\n.26381 .34111 L\n.26571 .33797 L\n.26762 .33493 L\n.26952 .332 L\n.27143 .32918 L\n.27333 .32647 L\n.27524 .32387 L\n.27714 .32137 L\n.27905 .31899 L\n.28095 .31672 L\n.28286 .31456 L\n.28476 .31251 L\n.28667 .31057 L\n.28857 .30874 L\n.29048 .30702 L\n.29238 .30541 L\n.29429 .3039 L\n.29619 .30251 L\n.2981 .30122 L\n.3 .30004 L\n.3019 .29896 L\n.30381 .29798 L\n.30571 .29711 L\n.30762 .29634 L\nMistroke\n.30952 .29566 L\n.31143 .29508 L\n.31333 .2946 L\n.31524 .29421 L\n.31714 .29391 L\n.31905 .29371 L\n.32095 .29359 L\n.32286 .29356 L\n.32476 .29361 L\n.32667 .29374 L\n.32857 .29395 L\n.33048 .29424 L\n.33238 .29461 L\n.33429 .29504 L\n.33619 .29555 L\n.3381 .29613 L\n.34 .29677 L\n.3419 .29748 L\n.34381 .29824 L\n.34571 .29907 L\n.34762 .29995 L\n.34952 .30088 L\n.35143 .30187 L\n.35333 .3029 L\n.35524 .30398 L\n.35714 .30511 L\n.35905 .30627 L\n.36095 .30747 L\n.36286 .30871 L\n.36476 .30999 L\n.36667 .31129 L\n.36857 .31263 L\n.37048 .31399 L\n.37238 .31537 L\n.37429 .31678 L\n.37619 .31821 L\n.3781 .31965 L\n.38 .32111 L\n.3819 .32258 L\n.38381 .32406 L\n.38571 .32556 L\n.38762 .32706 L\n.38952 .32856 L\n.39143 .33007 L\n.39333 .33157 L\n.39524 .33308 L\n.39714 .33458 L\n.39905 .33608 L\n.40095 .33758 L\n.40286 .33906 L\nMistroke\n.40476 .34053 L\n.40667 .342 L\n.40857 .34345 L\n.41048 .34489 L\n.41238 .34631 L\n.41429 .34771 L\n.41619 .3491 L\n.4181 .35046 L\n.42 .35181 L\n.4219 .35313 L\n.42381 .35443 L\n.42571 .35571 L\n.42762 .35696 L\n.42952 .35818 L\n.43143 .35938 L\n.43333 .36055 L\n.43524 .36169 L\n.43714 .36281 L\n.43905 .36389 L\n.44095 .36494 L\n.44286 .36596 L\n.44476 .36695 L\n.44667 .36791 L\n.44857 .36884 L\n.45048 .36973 L\n.45238 .37059 L\n.45429 .37142 L\n.45619 .37221 L\n.4581 .37297 L\n.46 .37369 L\n.4619 .37439 L\n.46381 .37504 L\n.46571 .37567 L\n.46762 .37626 L\n.46952 .37681 L\n.47143 .37733 L\n.47333 .37782 L\n.47524 .37828 L\n.47714 .3787 L\n.47905 .37909 L\n.48095 .37945 L\n.48286 .37978 L\n.48476 .38007 L\n.48667 .38034 L\n.48857 .38057 L\n.49048 .38078 L\n.49238 .38095 L\n.49429 .3811 L\n.49619 .38122 L\n.4981 .38131 L\nMistroke\n.5 .38137 L\n.5019 .38141 L\n.50381 .38142 L\n.50571 .3814 L\n.50762 .38136 L\n.50952 .3813 L\n.51143 .38121 L\n.51333 .3811 L\n.51524 .38097 L\n.51714 .38082 L\n.51905 .38064 L\n.52095 .38045 L\n.52286 .38024 L\n.52476 .38 L\n.52667 .37976 L\n.52857 .37949 L\n.53048 .37921 L\n.53238 .37891 L\n.53429 .3786 L\n.53619 .37827 L\n.5381 .37793 L\n.54 .37758 L\n.5419 .37722 L\n.54381 .37685 L\n.54571 .37646 L\n.54762 .37607 L\n.54952 .37567 L\n.55143 .37526 L\n.55333 .37484 L\n.55524 .37441 L\n.55714 .37398 L\n.55905 .37355 L\n.56095 .37311 L\n.56286 .37266 L\n.56476 .37222 L\n.56667 .37176 L\n.56857 .37131 L\n.57048 .37086 L\n.57238 .3704 L\n.57429 .36995 L\n.57619 .36949 L\n.5781 .36904 L\n.58 .36858 L\n.5819 .36813 L\n.58381 .36768 L\n.58571 .36724 L\n.58762 .36679 L\n.58952 .36635 L\n.59143 .36592 L\n.59333 .36549 L\nMistroke\n.59524 .36506 L\n.59524 .36506 L\n.59524 .36506 L\n.59714 .37831 L\n.59905 .39122 L\n.60095 .40376 L\n.60286 .41594 L\n.60476 .42775 L\n.60667 .43918 L\n.60857 .45024 L\n.61048 .46092 L\n.61238 .47121 L\n.61429 .48111 L\n.61619 .49063 L\n.6181 .49975 L\n.62 .50848 L\n.6219 .51681 L\n.62381 .52474 L\n.62571 .53228 L\n.62762 .53942 L\n.62952 .54616 L\n.63143 .55251 L\n.63333 .55847 L\n.63524 .56403 L\n.63714 .56921 L\n.63905 .57399 L\n.64095 .57841 L\n.64286 .58244 L\n.64476 .58609 L\n.64667 .58938 L\n.64857 .59231 L\n.65048 .59487 L\n.65238 .59709 L\n.65429 .59895 L\n.65619 .60048 L\n.6581 .60167 L\n.66 .60254 L\n.6619 .60309 L\n.66381 .60332 L\n.66571 .60325 L\n.66762 .60288 L\n.66952 .60222 L\n.67143 .60127 L\n.67333 .60006 L\n.67524 .59857 L\n.67714 .59683 L\n.67905 .59484 L\n.68095 .59261 L\n.68286 .59014 L\n.68476 .58746 L\nMistroke\n.68667 .58456 L\n.68857 .58145 L\n.69048 .57815 L\n.69238 .57466 L\n.69429 .57099 L\n.69619 .56716 L\n.6981 .56317 L\n.7 .55903 L\n.7019 .55474 L\n.70381 .55032 L\n.70571 .54577 L\n.70762 .54111 L\n.70952 .53634 L\n.71143 .53148 L\n.71333 .52653 L\n.71524 .52149 L\n.71714 .51638 L\n.71905 .5112 L\n.72095 .50596 L\n.72286 .50068 L\n.72476 .49536 L\n.72667 .49 L\n.72857 .48461 L\n.73048 .47921 L\n.73238 .47379 L\n.73429 .46836 L\n.73619 .46294 L\n.7381 .45753 L\n.74 .45213 L\n.7419 .44675 L\n.74381 .4414 L\n.74571 .43608 L\n.74762 .4308 L\n.74952 .42557 L\n.75143 .42038 L\n.75333 .41526 L\n.75524 .41019 L\n.75714 .40518 L\n.75905 .40024 L\n.76095 .39538 L\n.76286 .3906 L\n.76476 .38589 L\n.76667 .38127 L\n.76857 .37675 L\n.77048 .37231 L\n.77238 .36797 L\n.77429 .36373 L\n.77619 .35959 L\n.7781 .35556 L\n.78 .35163 L\nMistroke\n.7819 .34781 L\n.78381 .3441 L\n.78571 .3405 L\n.78762 .33702 L\n.78952 .33365 L\n.79143 .3304 L\n.79333 .32727 L\n.79524 .32426 L\n.79714 .32136 L\n.79905 .31859 L\n.80095 .31594 L\n.80286 .31341 L\n.80476 .311 L\n.80667 .30871 L\n.80857 .30654 L\n.81048 .30449 L\n.81238 .30256 L\n.81429 .30075 L\n.81619 .29906 L\n.8181 .29749 L\n.82 .29604 L\n.8219 .2947 L\n.82381 .29348 L\n.82571 .29237 L\n.82762 .29137 L\n.82952 .29048 L\n.83143 .2897 L\n.83333 .28903 L\n.83524 .28846 L\n.83714 .288 L\n.83905 .28764 L\n.84095 .28737 L\n.84286 .28721 L\n.84476 .28714 L\n.84667 .28716 L\n.84857 .28727 L\n.85048 .28748 L\n.85238 .28776 L\n.85429 .28813 L\n.85619 .28858 L\n.8581 .28911 L\n.86 .28972 L\n.8619 .2904 L\n.86381 .29114 L\n.86571 .29196 L\n.86762 .29284 L\n.86952 .29378 L\n.87143 .29478 L\n.87333 .29584 L\n.87524 .29696 L\nMistroke\n.87714 .29812 L\n.87905 .29934 L\n.88095 .30059 L\n.88286 .3019 L\n.88476 .30324 L\n.88667 .30462 L\n.88857 .30604 L\n.89048 .30749 L\n.89238 .30897 L\n.89429 .31047 L\n.89619 .31201 L\n.8981 .31356 L\n.9 .31514 L\n.9019 .31673 L\n.90381 .31834 L\n.90571 .31996 L\n.90762 .32159 L\n.90952 .32323 L\n.91143 .32487 L\n.91333 .32652 L\n.91524 .32817 L\n.91714 .32982 L\n.91905 .33147 L\n.92095 .33312 L\n.92286 .33475 L\n.92476 .33638 L\n.92667 .338 L\n.92857 .33961 L\n.93048 .3412 L\n.93238 .34278 L\n.93429 .34435 L\n.93619 .34589 L\n.9381 .34742 L\n.94 .34892 L\n.9419 .3504 L\n.94381 .35186 L\n.94571 .35329 L\n.94762 .3547 L\n.94952 .35608 L\n.95143 .35743 L\n.95333 .35876 L\n.95524 .36005 L\n.95714 .36131 L\n.95905 .36254 L\n.96095 .36374 L\n.96286 .36491 L\n.96476 .36604 L\n.96667 .36713 L\n.96857 .3682 L\n.97048 .36922 L\nMistroke\n.97238 .37022 L\n.97429 .37117 L\n.97619 .37209 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(tankm) show\n99.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(h) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(L) show\n117.000 12.813 moveto\n(@) show\n123.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n129.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00AP3IfMT2000000@0fMWI0P00000R0=WIf@D000000P3IfMT2000000@0\nfMWI0P00000O0=WIf@D000000P3IfMT2000000@0fMWI0P00000O0=WIf@@000000`3IfMT2000000@0\nfMWI0P00000O0=WIf@@000000`3IfMT2000000@0fMWI0P00000G0=WIf@00A@3IfMT010000000fMWI\n0=WIf@0000020=WIf@040000003IfMT0fMWI000002<0fMWI00D000000=WIf@3IfMT0fMWI00000002\n0=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT07P3IfMT01@000000fMWI0=WI\nf@3IfMT000000080fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@0L0=WIf@03\n0000003IfMT0fMWI00<0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@00000N\n0=WIf@030000003IfMT0fMWI00<0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WI\nf@00000F0=WIf@00B03IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI0240fMWI\n00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WI\nf@3IfMT07P3IfMT00`000000fMWI0=WIf@040=WIf@040000003IfMT0fMWI00000080fMWI00<00000\n0=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0fMWI00000080fMWI00@0\n00000=WIf@3IfMT000007`3IfMT00`000000fMWI0=WIf@050=WIf@040000003IfMT0fMWI00000080\nfMWI00<000000=WIf@3IfMT0503IfMT004H0fMWI0P0000030=WIf@040000003IfMT0fMWI000002<0\nfMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00<00000\n0=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@020=WIf@8000000`3IfMT010000000fMWI0=WIf@00\n000P0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@03\n0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT00P3IfMT2000000<0fMWI00@000000=WIf@3I\nfMT000005P3IfMT004H0fMWI00<000000=WIf@3IfMT00P3IfMT010000000fMWI0=WIf@00000S0=WI\nf@050000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@030000003I\nfMT0fMWI01h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@020=WIf@040000003I\nfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000020=WI\nf@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000000`3IfMT00`000000fMWI0=WI\nf@020=WIf@040000003IfMT0fMWI000001H0fMWI00160=WIf@<000000`3IfMT2000002<0fMWI0P00\n00040=WIf@800000103IfMT200000200fMWI0P0000040=WIf@<000000`3IfMT200000200fMWI0P00\n00040=WIf@800000103IfMT200000200fMWI0P0000040=WIf@<000000`3IfMT2000001L0fMWI003o\n0=WIfB40fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3b0=WIf@8000003@3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0l@3IfMT010000000fMWI0=WIf@00000<0=WIf@005P3IfMT6000000030000o`00\n000000000>T00000203IfMT00`000000fMWI0=WIf@0=0=WIf@00703IfMT00`000?l0fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@07\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@07\n0=WIf@030000003IfMT0fMWI00X0fMWI1@00000<0=WIf@00703IfMT00`000?l0fMWI0=WIf@3a0=WI\nf@030000003IfMT0fMWI00d0fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI\n00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WI\nf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@03000000000?l0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<000000000o`3IfMT0o`3IfMT20=WIf@00703IfMT00`000000003o0=WIf@3o\n0=WIf@80fMWI000L0=WIf@03000000000?l0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000000o`3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000000003o0=WIf@3o0=WIf@80fMWI000L0=WIf@0300000000\n0?l0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@000?l0o`3IfMT20=WIf@00703IfMT00`00\n0000fMWI0000o`3o0=WIf@80fMWI000L0=WIf@030000003IfMT0003o0?l0fMWI0P3IfMT001`0fMWI\n00<000000=WIf@000?l0o`3IfMT20=WIf@00703IfMT00`000000fMWI0000o`3o0=WIf@80fMWI000L\n0=WIf@030000003IfMT0003o0?l0fMWI0P3IfMT001`0fMWI00@000000=WIf@3IfMT0003oo`3IfMT1\n0=WIf@00703IfMT010000000fMWI0=WIf@000?oo0=WIf@40fMWI000L0=WIf@040000003IfMT0fMWI\n0000ool0fMWI0@3IfMT001`0fMWI00@000000=WIf@3IfMT0003oo`3IfMT10=WIf@00703IfMT01000\n0000fMWI0=WIf@000?oo0=WIf@40fMWI000L0=WIf@040000003IfMT0fMWI0000ool0fMWI0@3IfMT0\n01`0fMWI00@000000=WIf@3IfMT0003oo`3IfMT10=WIf@00703IfMT01@000000fMWI0=WIf@3IfMT0\n003o0?l0fMWI000L0=WIf@050000003IfMT0fMWI0=WIf@000?l0o`3IfMT000T0fMWI0P0000040=WI\nf@8000000`3IfMT5000000<0fMWI00D000000=WIf@3IfMT0fMWI0000o`3o0=WIf@00203IfMT01000\n0000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI00<0fMWI00D000000=WIf@3IfMT0fMWI0000\no`3o0=WIf@00203IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI00<0fMWI0P00\n00020=WIf@030000o`3IfMT0fMWI0?d0fMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI00<0\n00000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT0003o0?l0fMWI00080=WIf@040000003I\nfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT0003o0?l0\nfMWI00090=WIf@8000002P3IfMT2000000D0fMWI00<000000=WIf@3IfMT00P3IfMT00`000?l0fMWI\n0=WIf@3l0=WIf@00703IfMT00`000000fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI0?`0fMWI000L\n0=WIf@030000003IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0o03IfMT001`0fMWI00<000000=WI\nf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@3l0=WIf@00703IfMT00`000000fMWI0=WIf@020=WIf@03\n0000o`3IfMT0fMWI0?`0fMWI000L0=WIf@030000003IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0\no03IfMT001`0fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@3k0=WIf@00703IfMT0\n0`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0?/0fMWI000L0=WIf@030000003IfMT0fMWI\n00<0fMWI00<0003o0=WIf@3IfMT0n`3IfMT001`0fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0\nfMWI0=WIf@3k0=WIf@00703IfMT00`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0?/0fMWI\n000L0=WIf@030000003IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0n`3IfMT001`0fMWI00<00000\n0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@3k0=WIf@00703IfMT00`000000fMWI0=WIf@030=WI\nf@030000o`3IfMT0fMWI0?/0fMWI000L0=WIf@030000003IfMT0fMWI00<0fMWI00<0003o0=WIf@3I\nfMT0n`3IfMT001`0fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@3k0=WIf@00703I\nfMT00`000000fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0?X0fMWI000L0=WIf@030000003IfMT0\nfMWI00@0fMWI00<0003o0=WIf@3IfMT0nP3IfMT001`0fMWI00<000000=WIf@3IfMT0103IfMT00`00\n0?l0fMWI0=WIf@3j0=WIf@00703IfMT00`000000fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0?X0\nfMWI000L0=WIf@030000003IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT0nP3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@3j0=WIf@00703IfMT00`000000fMWI0=WIf@04\n0=WIf@030000o`3IfMT0fMWI0?X0fMWI000L0=WIf@030000003IfMT0fMWI00D0fMWI00<0003o0=WI\nf@3IfMT0n@3IfMT001`0fMWI00<000000=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@3i0=WIf@00\n703IfMT00`000000fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0?T0fMWI000L0=WIf@030000003I\nfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0n@3IfMT001`0fMWI00<000000=WIf@3IfMT01@3IfMT0\n0`000?l0fMWI0=WIf@3i0=WIf@00703IfMT00`000000fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI\n0?T0fMWI00090=WIf@800000103IfMT2000000<0fMWI100000040=WIf@030000003IfMT0fMWI00D0\nfMWI00<0003o0=WIf@3IfMT0n@3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000\nfMWI0=WIf@050=WIf@030000003IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0]P3IfMT90000ocT0\nfMWI00080=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT0103IfMT2000000L0\nfMWI00<0003o0=WIf@3IfMT0>@3IfMT60000ogD0fMWI0`000?l70=WIf@<0003o=`3IfMT000P0fMWI\n00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00H0\nfMWI00<0003o0=WIf@3IfMT0=`3IfMT30000o`D0fMWI0`000?ma0=WIf@80003o2`3IfMT30000ocD0\nfMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000103IfMT00`00\n0000fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI03D0fMWI0`000?l90=WIf@<0003oKP3IfMT20000\no`h0fMWI0P000?ld0=WIf@002@3IfMT2000000X0fMWI0P0000050=WIf@030000003IfMT0fMWI00H0\nfMWI00<0003o0=WIf@3IfMT0=03IfMT20000o`h0fMWI0P000?m[0=WIf@80003o4@3IfMT00`000?l0\nfMWI0=WIf@0a0=WIf@00703IfMT00`000000fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI03<0fMWI\n00<0003o0=WIf@3IfMT03`3IfMT20000ofT0fMWI0P000?lC0=WIf@80003o<@3IfMT001`0fMWI00<0\n00000=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0a0=WIf@80003o4`3IfMT20000ofL0fMWI00<0\n003o0=WIf@3IfMT04`3IfMT20000oc00fMWI000L0=WIf@030000003IfMT0fMWI00L0fMWI00<0003o\n0=WIf@3IfMT0<03IfMT20000oaD0fMWI0P000?mU0=WIf@030000o`3IfMT0fMWI01H0fMWI00<0003o\n0=WIf@3IfMT0;@3IfMT001`0fMWI00<000000=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0`0=WI\nf@030000o`3IfMT0fMWI01D0fMWI0P000?mS0=WIf@030000o`3IfMT0fMWI01P0fMWI0P000?l]0=WI\nf@00703IfMT00`000000fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI02l0fMWI00<0003o0=WIf@3I\nfMT0603IfMT00`000?l0fMWI0=WIf@1O0=WIf@80003o6`3IfMT00`000?l0fMWI0=WIf@0[0=WIf@00\n703IfMT00`000000fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI02h0fMWI00<0003o0=WIf@3IfMT0\n6P3IfMT20000oel0fMWI00<0003o0=WIf@3IfMT06`3IfMT20000ob/0fMWI000L0=WIf@030000003I\nfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0;@3IfMT20000oad0fMWI0P000?mN0=WIf@030000o`3I\nfMT0fMWI01`0fMWI0P000?lZ0=WIf@00703IfMT00`000000fMWI0=WIf@070=WIf@030000o`3IfMT0\nfMWI02d0fMWI00<0003o0=WIf@3IfMT07P3IfMT00`000?l0fMWI0=WIf@1J0=WIf@030000o`3IfMT0\nfMWI01h0fMWI0P000?lY0=WIf@00703IfMT00`000000fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI\n02/0fMWI0P000?lQ0=WIf@030000o`3IfMT0fMWI05P0fMWI0P000?lR0=WIf@80003o9`3IfMT001`0\nfMWI00<000000=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0[0=WIf@030000o`3IfMT0fMWI0240\nfMWI0P000?mH0=WIf@030000o`3IfMT0fMWI0280fMWI00<0003o0=WIf@3IfMT09@3IfMT001`0fMWI\n00<000000=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0Z0=WIf@030000o`3IfMT0fMWI02<0fMWI\n0P000?mF0=WIf@030000o`3IfMT0fMWI02@0fMWI0P000?lU0=WIf@00703IfMT00`000000fMWI0=WI\nf@080=WIf@030000o`3IfMT0fMWI02X0fMWI00<0003o0=WIf@3IfMT09@3IfMT20000oe@0fMWI00<0\n003o0=WIf@3IfMT09@3IfMT20000ob@0fMWI000L0=WIf@030000003IfMT0fMWI00P0fMWI00<0003o\n0=WIf@3IfMT0:@3IfMT00`000?l0fMWI0=WIf@0W0=WIf@80003oDP3IfMT00`000?l0fMWI0=WIf@0X\n0=WIf@80003o8P3IfMT001`0fMWI00<000000=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0Y0=WI\nf@030000o`3IfMT0fMWI02T0fMWI0P000?lU0=WIf@030000o`3IfMT0fMWI02P0fMWI00<0003o0=WI\nf@3IfMT0:@3IfMT20000ob40fMWI000L0=WIf@030000003IfMT0fMWI00P0fMWI00<0003o0=WIf@3I\nfMT0:03IfMT00`000?l0fMWI0=WIf@0/0=WIf@80003o7P3IfMT60000obT0fMWI00<0003o0=WIf@3I\nfMT0;03IfMT20000oal0fMWI000L0=WIf@030000003IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0\n:03IfMT00`000?l0fMWI0=WIf@0^0=WIf@80003o603IfMT50000o`@0fMWI00<0003o0=WIf@3IfMT0\n9`3IfMT00`000?l0fMWI0=WIf@0^0=WIf@80003o7@3IfMT001`0fMWI00<000000=WIf@3IfMT0203I\nfMT00`000?l0fMWI0=WIf@0W0=WIf@030000o`3IfMT0fMWI0340fMWI10000?l@0=WIf@D0003o203I\nfMT00`000?l0fMWI0=WIf@0V0=WIf@030000o`3IfMT0fMWI04h0fMWI000L0=WIf@030000003IfMT0\nfMWI00T0fMWI00<0003o0=WIf@3IfMT09P3IfMT00`000?l0fMWI0=WIf@0d0=WIfA40003o3@3IfMT0\n0`000?l0fMWI0=WIf@0V0=WIf@030000o`3IfMT0fMWI04h0fMWI000L0=WIf@030000003IfMT0fMWI\n00T0fMWI00<0003o0=WIf@3IfMT09@3IfMT00`000?l0fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI\n02H0fMWI00<0003o0=WIf@3IfMT0CP3IfMT001`0fMWI00<000000=WIf@3IfMT02@3IfMT00`000?l0\nfMWI0=WIf@0U0=WIf@030000o`3IfMT0fMWI05@0fMWI00<0003o0=WIf@3IfMT09@3IfMT00`000?l0\nfMWI0=WIf@1>0=WIf@00703IfMT00`000000fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI02D0fMWI\n00<0003o0=WIf@3IfMT0E03IfMT00`000?l0fMWI0=WIf@0T0=WIf@030000o`3IfMT0fMWI04l0fMWI\n000L0=WIf@030000003IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0903IfMT00`000?l0fMWI0=WI\nf@1E0=WIf@030000o`3IfMT0fMWI02@0fMWI00<0003o0=WIf@3IfMT0C`3IfMT001`0fMWI00<00000\n0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0S0=WIf@030000o`3IfMT0fMWI05D0fMWI00<0003o\n0=WIf@3IfMT08`3IfMT00`000?l0fMWI0=WIf@1@0=WIf@00703IfMT00`000000fMWI0=WIf@0:0=WI\nf@030000o`3IfMT0fMWI0280fMWI00<0003o0=WIf@3IfMT0EP3IfMT00`000?l0fMWI0=WIf@0S0=WI\nf@030000o`3IfMT0fMWI0500fMWI000L0=WIf@030000003IfMT0fMWI00X0fMWI00<0003o0=WIf@3I\nfMT08P3IfMT00`000?l0fMWI0=WIf@1F0=WIf@030000o`3IfMT0fMWI0280fMWI00<0003o0=WIf@3I\nfMT0D@3IfMT001`0fMWI00<000000=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0Q0=WIf@030000\no`3IfMT0fMWI05L0fMWI00<0003o0=WIf@3IfMT08P3IfMT00`000?l0fMWI0=WIf@1A0=WIf@00703I\nfMT00`000000fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI0240fMWI00<0003o0=WIf@3IfMT0E`3I\nfMT00`000?l0fMWI0=WIf@0R0=WIf@030000o`3IfMT0fMWI0540fMWI00090=WIf@800000103IfMT2\n000000@0fMWI0P0000050=WIf@030000003IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0803IfMT0\n0`000?l0fMWI0=WIf@1H0=WIf@030000o`3IfMT0fMWI0240fMWI00<0003o0=WIf@3IfMT0DP3IfMT0\n00P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@030000003I\nfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT07`3IfMT00`000?l0fMWI0=WIf@1I0=WIf@030000o`3I\nfMT0fMWI0200fMWI00<0003o0=WIf@3IfMT0DP3IfMT000P0fMWI00@000000=WIf@3IfMT000002P3I\nfMT00`000000fMWI0=WIf@030=WIf@800000303IfMT00`000?l0fMWI0=WIf@0O0=WIf@030000o`3I\nfMT0fMWI05T0fMWI00<0003o0=WIf@3IfMT07`3IfMT00`000?l0fMWI0=WIf@1C0=WIf@00203IfMT0\n10000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT02`3I\nfMT00`000?l0fMWI0=WIf@0N0=WIf@030000o`3IfMT0fMWI05X0fMWI00<0003o0=WIf@3IfMT07`3I\nfMT00`000?l0fMWI0=WIf@1C0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003I\nfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0N0=WIf@030000\no`3IfMT0fMWI05X0fMWI00<0003o0=WIf@3IfMT07`3IfMT00`000?l0fMWI0=WIf@1C0=WIf@002@3I\nfMT2000000X0fMWI0P0000050=WIf@030000003IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT07@3I\nfMT00`000?l0fMWI0=WIf@1K0=WIf@030000o`3IfMT0fMWI01h0fMWI00<0003o0=WIf@3IfMT0E03I\nfMT001`0fMWI00<000000=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0L0=WIf@030000o`3IfMT0\nfMWI05`0fMWI00<0003o0=WIf@3IfMT07@3IfMT00`000?l0fMWI0=WIf@1D0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI01`0fMWI00<0003o0=WIf@3IfMT0G03IfMT00`00\n0?l0fMWI0=WIf@0M0=WIf@030000o`3IfMT0fMWI05@0fMWI000L0=WIf@030000003IfMT0fMWI00`0\nfMWI00<0003o0=WIf@3IfMT0703IfMT00`000?l0fMWI0=WIf@1L0=WIf@030000o`3IfMT0fMWI01d0\nfMWI00<0003o0=WIf@3IfMT0E03IfMT001`0fMWI00<000000=WIf@3IfMT0303IfMT00`000?l0fMWI\n0=WIf@0K0=WIf@030000o`3IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0703IfMT00`000?l0fMWI\n0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI01X0fMWI00<0\n003o0=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@0L0=WIf@030000o`3IfMT0fMWI05D0fMWI000L\n0=WIf@030000003IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT06@3IfMT00`000?l0fMWI0=WIf@1N\n0=WIf@030000o`3IfMT0fMWI01/0fMWI00<0003o0=WIf@3IfMT0EP3IfMT001`0fMWI00<000000=WI\nf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@0I0=WIf@030000o`3IfMT0fMWI05l0fMWI00<0003o0=WI\nf@3IfMT06P3IfMT00`000?l0fMWI0=WIf@1F0=WIf@00703IfMT00`000000fMWI0=WIf@0=0=WIf@03\n0000o`3IfMT0fMWI01P0fMWI00<0003o0=WIf@3IfMT0H03IfMT00`000?l0fMWI0=WIf@0J0=WIf@03\n0000o`3IfMT0fMWI05H0fMWI000L0=WIf@030000003IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0\n603IfMT00`000?l0fMWI0=WIf@1P0=WIf@030000o`3IfMT0fMWI01T0fMWI00<0003o0=WIf@3IfMT0\nE`3IfMT001`0fMWI00<000000=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@0G0=WIf@030000o`3I\nfMT0fMWI0600fMWI00<0003o0=WIf@3IfMT06@3IfMT00`000?l0fMWI0=WIf@1G0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI01H0fMWI00<0003o0=WIf@3IfMT0H@3IfMT0\n0`000?l0fMWI0=WIf@0H0=WIf@030000o`3IfMT0fMWI05P0fMWI000L0=WIf@030000003IfMT0fMWI\n00h0fMWI00<0003o0=WIf@3IfMT05P3IfMT00`000?l0fMWI0=WIf@1R0=WIf@030000o`3IfMT0fMWI\n01L0fMWI00<0003o0=WIf@3IfMT0F03IfMT001`0fMWI00<000000=WIf@3IfMT03P3IfMT00`000?l0\nfMWI0=WIf@0E0=WIf@030000o`3IfMT0fMWI06<0fMWI00<0003o0=WIf@3IfMT05`3IfMT00`000?l0\nfMWI0=WIf@1H0=WIf@00703IfMT00`000000fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI01D0fMWI\n00<0003o0=WIf@3IfMT0H`3IfMT00`000?l0fMWI0=WIf@0F0=WIf@030000o`3IfMT0fMWI05T0fMWI\n000L0=WIf@030000003IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WI\nf@1T0=WIf@030000o`3IfMT0fMWI01H0fMWI00<0003o0=WIf@3IfMT0F@3IfMT001`0fMWI00<00000\n0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI06D0fMWI00<0003o\n0=WIf@3IfMT05@3IfMT00`000?l0fMWI0=WIf@1I0=WIf@00703IfMT00`000000fMWI0=WIf@0?0=WI\nf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0I@3IfMT00`000?l0fMWI0=WIf@0E0=WI\nf@030000o`3IfMT0fMWI05T0fMWI000L0=WIf@030000003IfMT0fMWI00l0fMWI00<0003o0=WIf@3I\nfMT04`3IfMT00`000?l0fMWI0=WIf@1U0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3I\nfMT0FP3IfMT001`0fMWI00<000000=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000\no`3IfMT0fMWI06H0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@1J0=WIf@00703I\nfMT00`000000fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT0IP3I\nfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI05/0fMWI000L0=WIf@030000003IfMT0\nfMWI0100fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@1W0=WIf@030000o`3IfMT0\nfMWI01<0fMWI00<0003o0=WIf@3IfMT0F`3IfMT001`0fMWI00<000000=WIf@3IfMT04@3IfMT00`00\n0?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI06P0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`00\n0?l0fMWI0=WIf@1K0=WIf@00703IfMT00`000000fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00h0\nfMWI00<0003o0=WIf@3IfMT0J@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI05`0\nfMWI000L0=WIf@030000003IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI\n0=WIf@1Y0=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT0G03IfMT001`0fMWI00<0\n00000=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI06/0fMWI00<0\n003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@1M0=WIf@00703IfMT00`000000fMWI0=WIf@0B\n0=WIf@030000o`3IfMT0fMWI00/0fMWI0P000?m]0=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o\n0=WIf@3IfMT0G@3IfMT001`0fMWI00<000000=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0:0=WI\nf@030000o`3IfMT0fMWI06`0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@1N0=WI\nf@00703IfMT00`000000fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3I\nfMT0K@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI05h0fMWI00090=WIf@800000\n103IfMT2000000D0fMWI0`0000030=WIf@030000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT0\n203IfMT00`000?l0fMWI0=WIf@1^0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT0\nG`3IfMT000P0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@020=WIf@030000\n003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT01`3IfMT20000og00fMWI00<0003o0=WIf@3IfMT0\n303IfMT00`000?l0fMWI0=WIf@1O0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@D00000\n0`3IfMT2000001H0fMWI00<0003o0=WIf@3IfMT01@3IfMT20000og80fMWI00<0003o0=WIf@3IfMT0\n2`3IfMT00`000?l0fMWI0=WIf@1O0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000\n003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT05@3IfMT20000o`D0fMWI0P000?mc0=WIf@03\n0000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0H03IfMT000P0fMWI00@000000=WIf@3IfMT0\n00002@3IfMT00`000000fMWI000000040=WIf@030000003IfMT0fMWI01H0fMWI0P000?l30=WIf@80\n003oM@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI0600fMWI00090=WIf@800000\n2`3IfMT2000000@0fMWI00<000000=WIf@3IfMT0603IfMT30000ogL0fMWI00<0003o0=WIf@3IfMT0\n203IfMT00`000?l0fMWI0=WIf@1Q0=WIf@00703IfMT00`000000fMWI0=WIf@2C0=WIf@030000o`3I\nfMT0fMWI00H0fMWI0P000?mS0=WIf@00703IfMT00`000000fMWI0=WIf@2C0=WIf@030000o`3IfMT0\nfMWI00D0fMWI0P000?mT0=WIf@00703IfMT00`000000fMWI0=WIf@2D0=WIf@030000o`3IfMT0fMWI\n00<0fMWI0P000?mU0=WIf@00703IfMT00`000000fMWI0=WIf@2D0=WIf@80003o0`3IfMT20000ofH0\nfMWI000L0=WIf@030000003IfMT0fMWI09H0fMWI10000?mW0=WIf@00703IfMT00`000000fMWI0=WI\nf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WI\nf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI000U0=WIf@030000003IfMT0fMWI02X0\nfMWI00<000000=WIf@3IfMT01@3IfMT2000000P0fMWI0P00002j0=WIf@00903IfMT00`000000fMWI\n0=WIf@0/0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI\n0=WIf@2h0=WIf@008`3IfMT00`000000fMWI0=WIf@030=WIf@8000000`3IfMT700000080fMWI1000\n0000103IfMT000000000003IfMT2000000040=WIf@000000fMWI00000080fMWI0P0000020=WIf@<0\n000000<0fMWI0000000000000`3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080\nfMWI0P0000040=WIf@030000003IfMT0fMWI0;P0fMWI000S0=WIf@030000003IfMT0fMWI0080fMWI\n00@000000=WIf@3IfMT000000P3IfMT400000080fMWI00@000000=WIf@3IfMT000000P3IfMT00`00\n0000fMWI000000030=WIf@050000003IfMT000000=WIf@0000001`3IfMT010000000fMWI0=WIf@00\n00040=WIf@030000003IfMT0fMWI00<0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@050000\n003IfMT0fMWI0=WIf@000000^P3IfMT001H0fMWI20000?l50=WIf@030000003IfMT0fMWI0080fMWI\n00<000000=WIf@3IfMT01P3IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00<0\n00000`3IfMT01@000000fMWI0000003IfMT0000000L0fMWI00@000000=WIf@3IfMT00000103IfMT0\n0`000000fMWI0=WIf@030=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WI\nf@2h0=WIf@008`3IfMT010000000fMWI0=WIf@3IfMT5000000<0fMWI0`0000000`3IfMT000000000\n0002000000<0fMWI00D000000=WIf@00000000000=WIf@03000000030=WIf@000000fMWI00L0fMWI\n0`0000050=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT01@0000030=WIf@030000\n003IfMT0fMWI0;P0fMWI000T0=WIf@050000003IfMT0fMWI0=WIf@0000004@3IfMT00`000000fMWI\n0=WIf@0?0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT01@000000fMWI\n0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0^03IfMT002D0fMWI00<000000=WIf@3IfMT0\n4@3IfMT200000100fMWI0P0000050=WIf@030000003IfMT0fMWI00D0fMWI0P0000080=WIf@800000\n^P3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00001"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-30.4421`, -0.06751`, 1.08639`, 0.00298853`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell[BoxData[TagBox[RowBox[List[RowBox[List["\[SkeletonIndicator]", "Graphics"]], "\[SkeletonIndicator]"]], False, Rule[Editable, False]]], "Output"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Connecting Two Tanks Together", "Section"], Cell["remove the dicontinuity from the tank model\nq=if time>150 then 3*qIn.lflow else qIn.lflow;", "Text"], Cell["model TanksConnected\n\tPIcontinuousController piContinuous1,piContinuous2;\n\tTankModified2 tank1(area=1),tank2(area=1.3);\nequation\n\tconnect(tank1.tInp,piContinuous1.cOut);\n\tconnect(tank1.tOut,piContinuous1.cInp);\n\tpiContinuous1.ref=0.25;\n\t\n\tconnect(tank2.tInp,piContinuous2.cOut);\n\tconnect(tank2.tOut,piContinuous2.cInp);\n\tpiContinuous2.ref=0.4;\n\t\n\ttank1.qIn.lflow=0.02;\n\tconnect(tank1.qOut,tank2.qIn);\nend TanksConnected;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of TanksConnected", "Subsection"], Cell["simulate( TanksConnected, stopTime=250 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(TanksConnected\\) : 2004-2-4 10:48:15.0560342 : \\!\\({0.`, 250.`}\\) : 504 data points : 2 events : 42 variables>\\n\\!\\({\\*TagBox[\\(piContinuous1 . cInp . val\\), HoldForm], \\*TagBox[\\(piContinuous1 . cOut . act\\), HoldForm], \\*TagBox[\\(piContinuous1 . error\\), HoldForm], \\*TagBox[\\(piContinuous1 . K\\), HoldForm], \\*TagBox[\\(piContinuous1 . maxV\\), HoldForm], \\*TagBox[\\(piContinuous1 . minV\\), HoldForm], \\*TagBox[\\(piContinuous1 . outCtr\\), HoldForm], \\*TagBox[\\(piContinuous1 . ref\\), HoldForm], \\*TagBox[\\(piContinuous1 . T\\), HoldForm], \\*TagBox[\\(piContinuous1 . Ts\\), HoldForm], \\*TagBox[\\(piContinuous1 . x\\), HoldForm], \\*TagBox[\\(piContinuous2 . cInp . val\\), HoldForm], \\*TagBox[\\(piContinuous2 . cOut . act\\), HoldForm], \\*TagBox[\\(piContinuous2 . error\\), HoldForm], \\*TagBox[\\(piContinuous2 . K\\), HoldForm], \\*TagBox[\\(piContinuous2 . maxV\\), HoldForm], \\*TagBox[\\(piContinuous2 . minV\\), HoldForm], \\*TagBox[\\(piContinuous2 . outCtr\\), HoldForm], \\*TagBox[\\(piContinuous2 . ref\\), HoldForm], \\*TagBox[\\(piContinuous2 . T\\), HoldForm], \\*TagBox[\\(piContinuous2 . Ts\\), HoldForm], \\*TagBox[\\(piContinuous2 . x\\), HoldForm], \\*TagBox[\\(tank1 . area\\), HoldForm], \\*TagBox[\\(tank1 . flowGain\\), HoldForm], \\*TagBox[\\(tank1 . h\\), HoldForm], \\*TagBox[\\(tank1 . q\\), HoldForm], \\*TagBox[\\(tank1 . qIn . lflow\\), HoldForm], \\*TagBox[\\(tank1 . qOut . lflow\\), HoldForm], \\*TagBox[\\(tank1 . tInp . act\\), HoldForm], \\*TagBox[\\(tank1 . tOut . val\\), HoldForm], \\*TagBox[\\(tank2 . area\\), HoldForm], \\*TagBox[\\(tank2 . flowGain\\), HoldForm], \\*TagBox[\\(tank2 . h\\), HoldForm], \\*TagBox[\\(tank2 . q\\), HoldForm], \\*TagBox[\\(tank2 . qIn . lflow\\), HoldForm], \\*TagBox[\\(tank2 . qOut . lflow\\), HoldForm], \\*TagBox[\\(tank2 . tInp . act\\), HoldForm], \\*TagBox[\\(tank2 . tOut . val\\), HoldForm], \\*TagBox[SuperscriptBox[\\((piContinuous1 . x)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\((piContinuous2 . x)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\((tank1 . h)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\((tank2 . h)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( { tank1.h, tank2.h } );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.00380952 0.0147151 0.463503 [\n[.21429 .00222 -6 -9 ]\n[.21429 .00222 6 0 ]\n[.40476 .00222 -9 -9 ]\n[.40476 .00222 9 0 ]\n[.59524 .00222 -9 -9 ]\n[.59524 .00222 9 0 ]\n[.78571 .00222 -9 -9 ]\n[.78571 .00222 9 0 ]\n[.97619 .00222 -9 -9 ]\n[.97619 .00222 9 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .10742 -18 -4.5 ]\n[.01131 .10742 0 4.5 ]\n[.01131 .20012 -18 -4.5 ]\n[.01131 .20012 0 4.5 ]\n[.01131 .29282 -18 -4.5 ]\n[.01131 .29282 0 4.5 ]\n[.01131 .38552 -18 -4.5 ]\n[.01131 .38552 0 4.5 ]\n[.01131 .47822 -6 -4.5 ]\n[.01131 .47822 0 4.5 ]\n[.01131 .57092 -18 -4.5 ]\n[.01131 .57092 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .01472 m\n.21429 .02097 L\ns\n[(50)] .21429 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(100)] .40476 .00222 0 1 Mshowa\n.59524 .01472 m\n.59524 .02097 L\ns\n[(150)] .59524 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(200)] .78571 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(250)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.0619 .01472 m\n.0619 .01847 L\ns\n.1 .01472 m\n.1 .01847 L\ns\n.1381 .01472 m\n.1381 .01847 L\ns\n.17619 .01472 m\n.17619 .01847 L\ns\n.25238 .01472 m\n.25238 .01847 L\ns\n.29048 .01472 m\n.29048 .01847 L\ns\n.32857 .01472 m\n.32857 .01847 L\ns\n.36667 .01472 m\n.36667 .01847 L\ns\n.44286 .01472 m\n.44286 .01847 L\ns\n.48095 .01472 m\n.48095 .01847 L\ns\n.51905 .01472 m\n.51905 .01847 L\ns\n.55714 .01472 m\n.55714 .01847 L\ns\n.63333 .01472 m\n.63333 .01847 L\ns\n.67143 .01472 m\n.67143 .01847 L\ns\n.70952 .01472 m\n.70952 .01847 L\ns\n.74762 .01472 m\n.74762 .01847 L\ns\n.82381 .01472 m\n.82381 .01847 L\ns\n.8619 .01472 m\n.8619 .01847 L\ns\n.9 .01472 m\n.9 .01847 L\ns\n.9381 .01472 m\n.9381 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .10742 m\n.03006 .10742 L\ns\n[(0.2)] .01131 .10742 1 0 Mshowa\n.02381 .20012 m\n.03006 .20012 L\ns\n[(0.4)] .01131 .20012 1 0 Mshowa\n.02381 .29282 m\n.03006 .29282 L\ns\n[(0.6)] .01131 .29282 1 0 Mshowa\n.02381 .38552 m\n.03006 .38552 L\ns\n[(0.8)] .01131 .38552 1 0 Mshowa\n.02381 .47822 m\n.03006 .47822 L\ns\n[(1)] .01131 .47822 1 0 Mshowa\n.02381 .57092 m\n.03006 .57092 L\ns\n[(1.2)] .01131 .57092 1 0 Mshowa\n.125 Mabswid\n.02381 .03789 m\n.02756 .03789 L\ns\n.02381 .06107 m\n.02756 .06107 L\ns\n.02381 .08424 m\n.02756 .08424 L\ns\n.02381 .13059 m\n.02756 .13059 L\ns\n.02381 .15377 m\n.02756 .15377 L\ns\n.02381 .17694 m\n.02756 .17694 L\ns\n.02381 .22329 m\n.02756 .22329 L\ns\n.02381 .24647 m\n.02756 .24647 L\ns\n.02381 .26964 m\n.02756 .26964 L\ns\n.02381 .31599 m\n.02756 .31599 L\ns\n.02381 .33917 m\n.02756 .33917 L\ns\n.02381 .36234 m\n.02756 .36234 L\ns\n.02381 .40869 m\n.02756 .40869 L\ns\n.02381 .43187 m\n.02756 .43187 L\ns\n.02381 .45504 m\n.02756 .45504 L\ns\n.02381 .50139 m\n.02756 .50139 L\ns\n.02381 .52457 m\n.02756 .52457 L\ns\n.02381 .54774 m\n.02756 .54774 L\ns\n.02381 .59409 m\n.02756 .59409 L\ns\n.02381 .61727 m\n.02756 .61727 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .01935 L\n.02762 .02399 L\n.02952 .02862 L\n.03143 .03326 L\n.03333 .03789 L\n.03524 .04253 L\n.03714 .04716 L\n.03905 .0518 L\n.04095 .05643 L\n.04286 .06107 L\n.04476 .0657 L\n.04667 .07034 L\n.04857 .07497 L\n.05048 .07961 L\n.05238 .08424 L\n.05429 .08888 L\n.05619 .09351 L\n.0581 .09815 L\n.06 .10278 L\n.0619 .10742 L\n.06381 .11205 L\n.06571 .11669 L\n.06762 .12132 L\n.06952 .12596 L\n.07143 .13059 L\n.07333 .13523 L\n.07524 .13986 L\n.07714 .1445 L\n.07905 .14913 L\n.08095 .15377 L\n.08286 .1584 L\n.08476 .16304 L\n.08667 .16767 L\n.08857 .17231 L\n.09048 .17694 L\n.09238 .18158 L\n.09429 .18617 L\n.09619 .19057 L\n.0981 .19466 L\n.1 .1984 L\n.1019 .20179 L\n.10381 .20486 L\n.10571 .20759 L\n.10762 .21001 L\n.10952 .21211 L\n.11143 .21392 L\n.11333 .21543 L\n.11524 .21666 L\n.11714 .21762 L\nMistroke\n.11905 .21832 L\n.12095 .21877 L\n.12286 .21899 L\n.12476 .21897 L\n.12667 .21874 L\n.12857 .21831 L\n.13048 .21768 L\n.13238 .21688 L\n.13429 .21589 L\n.13619 .21475 L\n.1381 .21346 L\n.14 .21203 L\n.1419 .21047 L\n.14381 .2088 L\n.14571 .20701 L\n.14762 .20512 L\n.14952 .20315 L\n.15143 .20109 L\n.15333 .19896 L\n.15524 .19677 L\n.15714 .19453 L\n.15905 .19224 L\n.16095 .18991 L\n.16286 .18755 L\n.16476 .18516 L\n.16667 .18276 L\n.16857 .18035 L\n.17048 .17793 L\n.17238 .17552 L\n.17429 .17312 L\n.17619 .17073 L\n.1781 .16835 L\n.18 .16601 L\n.1819 .16369 L\n.18381 .1614 L\n.18571 .15915 L\n.18762 .15694 L\n.18952 .15477 L\n.19143 .15265 L\n.19333 .15058 L\n.19524 .14856 L\n.19714 .1466 L\n.19905 .1447 L\n.20095 .14285 L\n.20286 .14106 L\n.20476 .13934 L\n.20667 .13768 L\n.20857 .13608 L\n.21048 .13455 L\n.21238 .13309 L\nMistroke\n.21429 .13168 L\n.21619 .13035 L\n.2181 .12908 L\n.22 .12788 L\n.2219 .12674 L\n.22381 .12567 L\n.22571 .12467 L\n.22762 .12373 L\n.22952 .12284 L\n.23143 .12203 L\n.23333 .12127 L\n.23524 .12057 L\n.23714 .11994 L\n.23905 .11936 L\n.24095 .11883 L\n.24286 .11836 L\n.24476 .11794 L\n.24667 .11758 L\n.24857 .11726 L\n.25048 .11699 L\n.25238 .11677 L\n.25429 .11659 L\n.25619 .11646 L\n.2581 .11636 L\n.26 .11631 L\n.2619 .11629 L\n.26381 .11631 L\n.26571 .11636 L\n.26762 .11644 L\n.26952 .11655 L\n.27143 .1167 L\n.27333 .11686 L\n.27524 .11706 L\n.27714 .11727 L\n.27905 .11751 L\n.28095 .11777 L\n.28286 .11805 L\n.28476 .11834 L\n.28667 .11865 L\n.28857 .11897 L\n.29048 .11931 L\n.29238 .11966 L\n.29429 .12002 L\n.29619 .12038 L\n.2981 .12075 L\n.3 .12113 L\n.3019 .12152 L\n.30381 .1219 L\n.30571 .12229 L\n.30762 .12268 L\nMistroke\n.30952 .12307 L\n.31143 .12346 L\n.31333 .12385 L\n.31524 .12424 L\n.31714 .12462 L\n.31905 .125 L\n.32095 .12537 L\n.32286 .12574 L\n.32476 .1261 L\n.32667 .12646 L\n.32857 .12681 L\n.33048 .12715 L\n.33238 .12748 L\n.33429 .1278 L\n.33619 .12812 L\n.3381 .12842 L\n.34 .12872 L\n.3419 .129 L\n.34381 .12928 L\n.34571 .12955 L\n.34762 .1298 L\n.34952 .13004 L\n.35143 .13028 L\n.35333 .1305 L\n.35524 .13071 L\n.35714 .13092 L\n.35905 .13111 L\n.36095 .13129 L\n.36286 .13146 L\n.36476 .13162 L\n.36667 .13177 L\n.36857 .13191 L\n.37048 .13203 L\n.37238 .13215 L\n.37429 .13226 L\n.37619 .13236 L\n.3781 .13246 L\n.38 .13254 L\n.3819 .13261 L\n.38381 .13268 L\n.38571 .13273 L\n.38762 .13278 L\n.38952 .13282 L\n.39143 .13285 L\n.39333 .13288 L\n.39524 .1329 L\n.39714 .13291 L\n.39905 .13292 L\n.40095 .13292 L\n.40286 .13291 L\nMistroke\n.40476 .1329 L\n.40667 .13289 L\n.40857 .13287 L\n.41048 .13284 L\n.41238 .13281 L\n.41429 .13278 L\n.41619 .13274 L\n.4181 .1327 L\n.42 .13266 L\n.4219 .13261 L\n.42381 .13256 L\n.42571 .13251 L\n.42762 .13246 L\n.42952 .1324 L\n.43143 .13234 L\n.43333 .13228 L\n.43524 .13222 L\n.43714 .13216 L\n.43905 .1321 L\n.44095 .13204 L\n.44286 .13197 L\n.44476 .13191 L\n.44667 .13185 L\n.44857 .13178 L\n.45048 .13172 L\n.45238 .13166 L\n.45429 .1316 L\n.45619 .13153 L\n.4581 .13147 L\n.46 .13141 L\n.4619 .13135 L\n.46381 .1313 L\n.46571 .13124 L\n.46762 .13118 L\n.46952 .13113 L\n.47143 .13107 L\n.47333 .13102 L\n.47524 .13097 L\n.47714 .13092 L\n.47905 .13088 L\n.48095 .13083 L\n.48286 .13079 L\n.48476 .13074 L\n.48667 .1307 L\n.48857 .13066 L\n.49048 .13063 L\n.49238 .13059 L\n.49429 .13056 L\n.49619 .13053 L\n.4981 .1305 L\nMistroke\n.5 .13047 L\n.5019 .13044 L\n.50381 .13041 L\n.50571 .13039 L\n.50762 .13037 L\n.50952 .13035 L\n.51143 .13033 L\n.51333 .13031 L\n.51524 .1303 L\n.51714 .13028 L\n.51905 .13027 L\n.52095 .13026 L\n.52286 .13025 L\n.52476 .13024 L\n.52667 .13023 L\n.52857 .13023 L\n.53048 .13022 L\n.53238 .13022 L\n.53429 .13021 L\n.53619 .13021 L\n.5381 .13021 L\n.54 .13021 L\n.5419 .13021 L\n.54381 .13022 L\n.54571 .13022 L\n.54762 .13022 L\n.54952 .13023 L\n.55143 .13023 L\n.55333 .13024 L\n.55524 .13024 L\n.55714 .13025 L\n.55905 .13026 L\n.56095 .13027 L\n.56286 .13027 L\n.56476 .13028 L\n.56667 .13029 L\n.56857 .1303 L\n.57048 .13031 L\n.57238 .13032 L\n.57429 .13033 L\n.57619 .13034 L\n.5781 .13035 L\n.58 .13036 L\n.5819 .13037 L\n.58381 .13038 L\n.58571 .13039 L\n.58762 .1304 L\n.58952 .13041 L\n.59143 .13042 L\n.59333 .13043 L\nMistroke\n.59524 .13044 L\n.59524 .13044 L\n.59524 .13044 L\n.59714 .13949 L\n.59905 .14808 L\n.60095 .1562 L\n.60286 .16387 L\n.60476 .17108 L\n.60667 .17784 L\n.60857 .18416 L\n.61048 .19004 L\n.61238 .19549 L\n.61429 .20051 L\n.61619 .20512 L\n.6181 .20932 L\n.62 .21312 L\n.6219 .21654 L\n.62381 .21958 L\n.62571 .22226 L\n.62762 .22458 L\n.62952 .22656 L\n.63143 .2282 L\n.63333 .22953 L\n.63524 .23055 L\n.63714 .23128 L\n.63905 .23173 L\n.64095 .23191 L\n.64286 .23183 L\n.64476 .23151 L\n.64667 .23096 L\n.64857 .23019 L\n.65048 .22922 L\n.65238 .22805 L\n.65429 .2267 L\n.65619 .22519 L\n.6581 .22352 L\n.66 .2217 L\n.6619 .21975 L\n.66381 .21768 L\n.66571 .21549 L\n.66762 .21321 L\n.66952 .21083 L\n.67143 .20838 L\n.67333 .20586 L\n.67524 .20327 L\n.67714 .20064 L\n.67905 .19796 L\n.68095 .19525 L\n.68286 .19252 L\n.68476 .18976 L\nMistroke\n.68667 .187 L\n.68857 .18423 L\n.69048 .18147 L\n.69238 .17872 L\n.69429 .17599 L\n.69619 .17328 L\n.6981 .17059 L\n.7 .16794 L\n.7019 .16533 L\n.70381 .16276 L\n.70571 .16024 L\n.70762 .15777 L\n.70952 .15535 L\n.71143 .15299 L\n.71333 .15069 L\n.71524 .14845 L\n.71714 .14628 L\n.71905 .14418 L\n.72095 .14215 L\n.72286 .14018 L\n.72476 .13829 L\n.72667 .13648 L\n.72857 .13474 L\n.73048 .13307 L\n.73238 .13148 L\n.73429 .12996 L\n.73619 .12852 L\n.7381 .12716 L\n.74 .12587 L\n.7419 .12465 L\n.74381 .12351 L\n.74571 .12244 L\n.74762 .12144 L\n.74952 .12052 L\n.75143 .11966 L\n.75333 .11887 L\n.75524 .11815 L\n.75714 .11749 L\n.75905 .1169 L\n.76095 .11637 L\n.76286 .1159 L\n.76476 .11548 L\n.76667 .11513 L\n.76857 .11483 L\n.77048 .11458 L\n.77238 .11438 L\n.77429 .11424 L\n.77619 .11413 L\n.7781 .11408 L\n.78 .11407 L\nMistroke\n.7819 .11409 L\n.78381 .11416 L\n.78571 .11427 L\n.78762 .1144 L\n.78952 .11458 L\n.79143 .11478 L\n.79333 .11501 L\n.79524 .11527 L\n.79714 .11555 L\n.79905 .11585 L\n.80095 .11618 L\n.80286 .11653 L\n.80476 .11689 L\n.80667 .11727 L\n.80857 .11766 L\n.81048 .11806 L\n.81238 .11848 L\n.81429 .1189 L\n.81619 .11934 L\n.8181 .11978 L\n.82 .12022 L\n.8219 .12067 L\n.82381 .12112 L\n.82571 .12157 L\n.82762 .12202 L\n.82952 .12247 L\n.83143 .12292 L\n.83333 .12336 L\n.83524 .1238 L\n.83714 .12424 L\n.83905 .12467 L\n.84095 .12509 L\n.84286 .12551 L\n.84476 .12591 L\n.84667 .12631 L\n.84857 .1267 L\n.85048 .12709 L\n.85238 .12746 L\n.85429 .12782 L\n.85619 .12817 L\n.8581 .12851 L\n.86 .12883 L\n.8619 .12915 L\n.86381 .12945 L\n.86571 .12974 L\n.86762 .13002 L\n.86952 .13029 L\n.87143 .13055 L\n.87333 .13079 L\n.87524 .13102 L\nMistroke\n.87714 .13124 L\n.87905 .13144 L\n.88095 .13164 L\n.88286 .13182 L\n.88476 .13199 L\n.88667 .13215 L\n.88857 .13229 L\n.89048 .13243 L\n.89238 .13255 L\n.89429 .13267 L\n.89619 .13277 L\n.8981 .13286 L\n.9 .13295 L\n.9019 .13302 L\n.90381 .13308 L\n.90571 .13314 L\n.90762 .13318 L\n.90952 .13322 L\n.91143 .13325 L\n.91333 .13327 L\n.91524 .13328 L\n.91714 .13329 L\n.91905 .13329 L\n.92095 .13328 L\n.92286 .13327 L\n.92476 .13325 L\n.92667 .13322 L\n.92857 .13319 L\n.93048 .13316 L\n.93238 .13312 L\n.93429 .13307 L\n.93619 .13303 L\n.9381 .13297 L\n.94 .13292 L\n.9419 .13286 L\n.94381 .1328 L\n.94571 .13274 L\n.94762 .13267 L\n.94952 .13261 L\n.95143 .13254 L\n.95333 .13247 L\n.95524 .1324 L\n.95714 .13233 L\n.95905 .13225 L\n.96095 .13218 L\n.96286 .13211 L\n.96476 .13203 L\n.96667 .13196 L\n.96857 .13189 L\n.97048 .13181 L\nMistroke\n.97238 .13174 L\n.97429 .13167 L\n.97619 .1316 L\nMfstroke\n0 .5 0 r\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01475 L\n.09619 .01492 L\n.0981 .01535 L\n.1 .01604 L\n.1019 .01699 L\n.10381 .0182 L\n.10571 .01966 L\n.10762 .02137 L\n.10952 .02332 L\n.11143 .02549 L\n.11333 .0279 L\n.11524 .03051 L\n.11714 .03334 L\nMistroke\n.11905 .03636 L\n.12095 .03958 L\n.12286 .04298 L\n.12476 .04656 L\n.12667 .0503 L\n.12857 .0542 L\n.13048 .05825 L\n.13238 .06244 L\n.13429 .06675 L\n.13619 .0712 L\n.1381 .07576 L\n.14 .08042 L\n.1419 .08519 L\n.14381 .09004 L\n.14571 .09498 L\n.14762 .1 L\n.14952 .10508 L\n.15143 .11023 L\n.15333 .11543 L\n.15524 .12068 L\n.15714 .12598 L\n.15905 .1313 L\n.16095 .13666 L\n.16286 .14204 L\n.16476 .14744 L\n.16667 .15285 L\n.16857 .15828 L\n.17048 .1637 L\n.17238 .16912 L\n.17429 .17453 L\n.17619 .17994 L\n.1781 .18533 L\n.18 .1907 L\n.1819 .19605 L\n.18381 .20138 L\n.18571 .20667 L\n.18762 .21194 L\n.18952 .21717 L\n.19143 .22237 L\n.19333 .22752 L\n.19524 .23264 L\n.19714 .23772 L\n.19905 .24275 L\n.20095 .24773 L\n.20286 .25267 L\n.20476 .25757 L\n.20667 .26241 L\n.20857 .2672 L\n.21048 .27194 L\n.21238 .27664 L\nMistroke\n.21429 .28128 L\n.21619 .28587 L\n.2181 .29041 L\n.22 .2949 L\n.2219 .29934 L\n.22381 .30373 L\n.22571 .30807 L\n.22762 .31236 L\n.22952 .3166 L\n.23143 .3208 L\n.23333 .32494 L\n.23524 .32904 L\n.23714 .3331 L\n.23905 .33711 L\n.24095 .34108 L\n.24286 .34501 L\n.24476 .3489 L\n.24667 .35274 L\n.24857 .35655 L\n.25048 .36032 L\n.25238 .36406 L\n.25429 .36776 L\n.25619 .37143 L\n.2581 .37507 L\n.26 .37868 L\n.2619 .38226 L\n.26381 .38581 L\n.26571 .38933 L\n.26762 .39284 L\n.26952 .39631 L\n.27143 .39977 L\n.27333 .40321 L\n.27524 .40662 L\n.27714 .41002 L\n.27905 .41341 L\n.28095 .41677 L\n.28286 .42013 L\n.28476 .42346 L\n.28667 .42679 L\n.28857 .43011 L\n.29048 .43341 L\n.29238 .43669 L\n.29429 .43975 L\n.29619 .44231 L\n.2981 .44431 L\n.3 .44571 L\n.3019 .44656 L\n.30381 .44688 L\n.30571 .44673 L\n.30762 .44612 L\nMistroke\n.30952 .44509 L\n.31143 .44363 L\n.31333 .44178 L\n.31524 .43954 L\n.31714 .43694 L\n.31905 .43399 L\n.32095 .43072 L\n.32286 .42714 L\n.32476 .42327 L\n.32667 .41912 L\n.32857 .41473 L\n.33048 .4101 L\n.33238 .40526 L\n.33429 .40022 L\n.33619 .39499 L\n.3381 .38961 L\n.34 .38407 L\n.3419 .3784 L\n.34381 .37262 L\n.34571 .36674 L\n.34762 .36078 L\n.34952 .35475 L\n.35143 .34866 L\n.35333 .34252 L\n.35524 .33636 L\n.35714 .33019 L\n.35905 .324 L\n.36095 .31783 L\n.36286 .31168 L\n.36476 .30555 L\n.36667 .29946 L\n.36857 .29343 L\n.37048 .28745 L\n.37238 .28154 L\n.37429 .27571 L\n.37619 .26997 L\n.3781 .26431 L\n.38 .25876 L\n.3819 .25331 L\n.38381 .24797 L\n.38571 .24275 L\n.38762 .23765 L\n.38952 .23268 L\n.39143 .22784 L\n.39333 .22314 L\n.39524 .21858 L\n.39714 .21416 L\n.39905 .20988 L\n.40095 .20576 L\n.40286 .20178 L\nMistroke\n.40476 .19796 L\n.40667 .19428 L\n.40857 .19076 L\n.41048 .1874 L\n.41238 .18419 L\n.41429 .18114 L\n.41619 .17823 L\n.4181 .17549 L\n.42 .17289 L\n.4219 .17045 L\n.42381 .16816 L\n.42571 .16601 L\n.42762 .16402 L\n.42952 .16216 L\n.43143 .16045 L\n.43333 .15889 L\n.43524 .15746 L\n.43714 .15616 L\n.43905 .155 L\n.44095 .15397 L\n.44286 .15306 L\n.44476 .15228 L\n.44667 .15161 L\n.44857 .15107 L\n.45048 .15063 L\n.45238 .1503 L\n.45429 .15008 L\n.45619 .14997 L\n.4581 .14995 L\n.46 .15002 L\n.4619 .15019 L\n.46381 .15044 L\n.46571 .15077 L\n.46762 .15119 L\n.46952 .15168 L\n.47143 .15224 L\n.47333 .15287 L\n.47524 .15356 L\n.47714 .15432 L\n.47905 .15513 L\n.48095 .15599 L\n.48286 .15691 L\n.48476 .15787 L\n.48667 .15887 L\n.48857 .15991 L\n.49048 .16099 L\n.49238 .16209 L\n.49429 .16323 L\n.49619 .16439 L\n.4981 .16558 L\nMistroke\n.5 .16678 L\n.5019 .168 L\n.50381 .16923 L\n.50571 .17048 L\n.50762 .17173 L\n.50952 .17298 L\n.51143 .17424 L\n.51333 .1755 L\n.51524 .17676 L\n.51714 .17801 L\n.51905 .17925 L\n.52095 .18049 L\n.52286 .18172 L\n.52476 .18293 L\n.52667 .18413 L\n.52857 .18531 L\n.53048 .18648 L\n.53238 .18762 L\n.53429 .18875 L\n.53619 .18985 L\n.5381 .19093 L\n.54 .19199 L\n.5419 .19302 L\n.54381 .19403 L\n.54571 .19501 L\n.54762 .19596 L\n.54952 .19688 L\n.55143 .19777 L\n.55333 .19863 L\n.55524 .19947 L\n.55714 .20027 L\n.55905 .20104 L\n.56095 .20178 L\n.56286 .20249 L\n.56476 .20317 L\n.56667 .20381 L\n.56857 .20443 L\n.57048 .20501 L\n.57238 .20556 L\n.57429 .20608 L\n.57619 .20657 L\n.5781 .20703 L\n.58 .20746 L\n.5819 .20786 L\n.58381 .20822 L\n.58571 .20856 L\n.58762 .20887 L\n.58952 .20916 L\n.59143 .20941 L\n.59333 .20964 L\nMistroke\n.59524 .20984 L\n.59524 .20984 L\n.59524 .20984 L\n.59714 .21752 L\n.59905 .22591 L\n.60095 .23498 L\n.60286 .24468 L\n.60476 .25495 L\n.60667 .26576 L\n.60857 .27705 L\n.61048 .28876 L\n.61238 .30084 L\n.61429 .31324 L\n.61619 .3259 L\n.6181 .33876 L\n.62 .35178 L\n.6219 .36489 L\n.62381 .37805 L\n.62571 .3912 L\n.62762 .4043 L\n.62952 .4173 L\n.63143 .43015 L\n.63333 .44279 L\n.63524 .4552 L\n.63714 .46732 L\n.63905 .47912 L\n.64095 .49055 L\n.64286 .50158 L\n.64476 .51218 L\n.64667 .52231 L\n.64857 .53194 L\n.65048 .54105 L\n.65238 .5496 L\n.65429 .55758 L\n.65619 .56497 L\n.6581 .57174 L\n.66 .57789 L\n.6619 .58339 L\n.66381 .58823 L\n.66571 .59242 L\n.66762 .59593 L\n.66952 .59876 L\n.67143 .60092 L\n.67333 .6024 L\n.67524 .6032 L\n.67714 .60332 L\n.67905 .60277 L\n.68095 .60156 L\n.68286 .5997 L\n.68476 .5972 L\nMistroke\n.68667 .59406 L\n.68857 .5903 L\n.69048 .58594 L\n.69238 .581 L\n.69429 .57548 L\n.69619 .56941 L\n.6981 .56281 L\n.7 .5557 L\n.7019 .5481 L\n.70381 .54004 L\n.70571 .53153 L\n.70762 .5226 L\n.70952 .51328 L\n.71143 .50359 L\n.71333 .49356 L\n.71524 .48321 L\n.71714 .47256 L\n.71905 .46166 L\n.72095 .45051 L\n.72286 .43915 L\n.72476 .4276 L\n.72667 .4159 L\n.72857 .40406 L\n.73048 .39212 L\n.73238 .38009 L\n.73429 .36801 L\n.73619 .3559 L\n.7381 .34379 L\n.74 .33169 L\n.7419 .31963 L\n.74381 .30764 L\n.74571 .29572 L\n.74762 .28392 L\n.74952 .27225 L\n.75143 .26072 L\n.75333 .24937 L\n.75524 .23819 L\n.75714 .22722 L\n.75905 .21647 L\n.76095 .20595 L\n.76286 .19568 L\n.76476 .18567 L\n.76667 .17595 L\n.76857 .16651 L\n.77048 .15736 L\n.77238 .14853 L\n.77429 .14001 L\n.77619 .13182 L\n.7781 .12397 L\n.78 .11647 L\nMistroke\n.7819 .10931 L\n.78381 .1025 L\n.78571 .09604 L\n.78762 .08995 L\n.78952 .08423 L\n.79143 .07887 L\n.79333 .07387 L\n.79524 .06924 L\n.79714 .06498 L\n.79905 .06108 L\n.80095 .05754 L\n.80286 .05436 L\n.80476 .05154 L\n.80667 .04907 L\n.80857 .04695 L\n.81048 .04516 L\n.81238 .04371 L\n.81429 .04259 L\n.81619 .0418 L\n.8181 .04131 L\n.82 .04114 L\n.8219 .04126 L\n.82381 .04167 L\n.82571 .04236 L\n.82762 .04332 L\n.82952 .04455 L\n.83143 .04602 L\n.83333 .04774 L\n.83524 .04969 L\n.83714 .05186 L\n.83905 .05424 L\n.84095 .05682 L\n.84286 .05959 L\n.84476 .06254 L\n.84667 .06566 L\n.84857 .06893 L\n.85048 .07234 L\n.85238 .0759 L\n.85429 .07957 L\n.85619 .08336 L\n.8581 .08725 L\n.86 .09123 L\n.8619 .0953 L\n.86381 .09943 L\n.86571 .10363 L\n.86762 .10787 L\n.86952 .11216 L\n.87143 .11648 L\n.87333 .12083 L\n.87524 .12518 L\nMistroke\n.87714 .12954 L\n.87905 .1339 L\n.88095 .13825 L\n.88286 .14257 L\n.88476 .14687 L\n.88667 .15113 L\n.88857 .15535 L\n.89048 .15952 L\n.89238 .16363 L\n.89429 .16769 L\n.89619 .17167 L\n.8981 .17558 L\n.9 .17941 L\n.9019 .18316 L\n.90381 .18682 L\n.90571 .19039 L\n.90762 .19386 L\n.90952 .19724 L\n.91143 .20051 L\n.91333 .20367 L\n.91524 .20672 L\n.91714 .20966 L\n.91905 .21249 L\n.92095 .21521 L\n.92286 .2178 L\n.92476 .22028 L\n.92667 .22264 L\n.92857 .22488 L\n.93048 .227 L\n.93238 .229 L\n.93429 .23088 L\n.93619 .23264 L\n.9381 .23428 L\n.94 .2358 L\n.9419 .2372 L\n.94381 .23849 L\n.94571 .23966 L\n.94762 .24072 L\n.94952 .24166 L\n.95143 .2425 L\n.95333 .24323 L\n.95524 .24385 L\n.95714 .24436 L\n.95905 .24478 L\n.96095 .2451 L\n.96286 .24532 L\n.96476 .24545 L\n.96667 .24548 L\n.96857 .24543 L\n.97048 .2453 L\nMistroke\n.97238 .24508 L\n.97429 .24479 L\n.97619 .24442 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0119048 0.119048 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0214286 0.0721271 0.140476 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 .5 0 r\n.00374 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .08095 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(tank2) show\n99.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(h) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(L) show\n117.000 12.813 moveto\n(@) show\n123.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n129.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.159524 0.0721271 0.278571 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00374 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .21905 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(tank1) show\n99.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(h) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(L) show\n117.000 12.813 moveto\n(@) show\n123.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n129.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00AP3IfMT2000000@0fMWI0P00000R0=WIf@D000000P3IfMT2000000@0\nfMWI0P00000O0=WIf@D000000P3IfMT2000000@0fMWI0P00000O0=WIf@@000000`3IfMT2000000@0\nfMWI0P00000O0=WIf@@000000`3IfMT2000000@0fMWI0P00000G0=WIf@00A@3IfMT010000000fMWI\n0=WIf@0000020=WIf@040000003IfMT0fMWI000002<0fMWI00D000000=WIf@3IfMT0fMWI00000002\n0=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT07P3IfMT01@000000fMWI0=WI\nf@3IfMT000000080fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@0L0=WIf@03\n0000003IfMT0fMWI00<0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@00000N\n0=WIf@030000003IfMT0fMWI00<0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WI\nf@00000F0=WIf@00B03IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI0240fMWI\n00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WI\nf@3IfMT07P3IfMT00`000000fMWI0=WIf@040=WIf@040000003IfMT0fMWI00000080fMWI00<00000\n0=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0fMWI00000080fMWI00@0\n00000=WIf@3IfMT000007`3IfMT00`000000fMWI0=WIf@050=WIf@040000003IfMT0fMWI00000080\nfMWI00<000000=WIf@3IfMT0503IfMT004H0fMWI0P0000030=WIf@040000003IfMT0fMWI000002<0\nfMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00<00000\n0=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@020=WIf@8000000`3IfMT010000000fMWI0=WIf@00\n000P0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@03\n0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT00P3IfMT2000000<0fMWI00@000000=WIf@3I\nfMT000005P3IfMT004H0fMWI00<000000=WIf@3IfMT00P3IfMT010000000fMWI0=WIf@00000S0=WI\nf@050000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@030000003I\nfMT0fMWI01h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@020=WIf@040000003I\nfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000020=WI\nf@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000000`3IfMT00`000000fMWI0=WI\nf@020=WIf@040000003IfMT0fMWI000001H0fMWI00160=WIf@<000000`3IfMT2000002<0fMWI0P00\n00040=WIf@800000103IfMT200000200fMWI0P0000040=WIf@<000000`3IfMT200000200fMWI0P00\n00040=WIf@800000103IfMT200000200fMWI0P0000040=WIf@<000000`3IfMT2000001L0fMWI003o\n0=WIfB40fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3b0=WIf@8000003@3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0l@3IfMT010000000fMWI0=WIf@00000<0=WIf@005P3IfMT6000001<007l0f@00\n00080=WIf@030000003IfMT0fMWI00d0fMWI000L0=WIf@030000o`3IfMT0fMWI00H0fMWI00<00000\n0=WIf@3IfMT01P3IfMT00`00000007l0001o00060=WIf@030000003IfMT0fMWI00H0fMWI00<00000\n0=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00H0fMWI00<00000\n0=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00L0fMWI00<00000\n0=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00H0fMWI00<00000\n0=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00H0fMWI00<00000\n0=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00H0fMWI00<00000\n0=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00H0fMWI00<00000\n0=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00L0fMWI00<00000\n0=WIf@3IfMT02P3IfMT5000000`0fMWI000L0=WIf@030000o`3IfMT0fMWI0140fMWI0P00O`3N0=WI\nf@030000003IfMT0fMWI00d0fMWI000L0=WIf@03000000000?l0fMWI0180fMWI00<007l00=WIf@3I\nfMT0k03IfMT001`0fMWI00<000000000o`3IfMT04`3IfMT00`00O`00fMWI0=WIf@3[0=WIf@00703I\nfMT00`000000fMWI0000o`0D0=WIf@03001o003IfMT0fMWI0>X0fMWI000L0=WIf@030000003IfMT0\n003o01@0fMWI00<007l00=WIf@3IfMT0Y@3IfMT3001o0480fMWI000L0=WIf@030000003IfMT0003o\n01@0fMWI00<007l00=WIf@3IfMT0Y03IfMT2001o00040=WIf@00O`0007l0001o0400fMWI000L0=WI\nf@040000003IfMT0fMWI0000oa@0fMWI00<007l00=WIf@3IfMT0XP3IfMT00`00O`00fMWI0=WIf@03\n0=WIf@8007l0?`3IfMT001`0fMWI00@000000=WIf@3IfMT0003o5@3IfMT00`00O`00fMWI0=WIf@2P\n0=WIf@03001o003IfMT0fMWI00D0fMWI0P00O`0n0=WIf@00703IfMT01@000000fMWI0=WIf@3IfMT0\n003o01@0fMWI00<007l00=WIf@3IfMT0W`3IfMT00`00O`00fMWI0=WIf@070=WIf@03001o003IfMT0\nfMWI03`0fMWI000L0=WIf@050000003IfMT0fMWI0=WIf@000?l05@3IfMT00`00O`00fMWI0=WIf@2N\n0=WIf@03001o003IfMT0fMWI00L0fMWI0P00O`0m0=WIf@00703IfMT00`000000fMWI0=WIf@020=WI\nf@030000o`3IfMT0fMWI0180fMWI00<007l00=WIf@3IfMT0W@3IfMT00`00O`00fMWI0=WIf@090=WI\nf@03001o003IfMT0fMWI03/0fMWI000L0=WIf@030000003IfMT0fMWI0080fMWI00<0003o0=WIf@3I\nfMT04`3IfMT00`00O`00fMWI0=WIf@2L0=WIf@03001o003IfMT0fMWI00X0fMWI00<007l00=WIf@3I\nfMT0>P3IfMT001`0fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0B0=WIf@03001o\n003IfMT0fMWI09/0fMWI00<007l00=WIf@3IfMT02`3IfMT00`00O`00fMWI0=WIf@0j0=WIf@00703I\nfMT00`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0180fMWI00<007l00=WIf@3IfMT0V`3I\nfMT00`00O`00fMWI0=WIf@0<0=WIf@03001o003IfMT0fMWI03T0fMWI000L0=WIf@030000003IfMT0\nfMWI00<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`00O`00fMWI0=WIf@2J0=WIf@03001o003IfMT0\nfMWI00`0fMWI0P00O`0j0=WIf@00703IfMT00`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI\n01<0fMWI00<007l00=WIf@3IfMT0VP3IfMT00`00O`00fMWI0=WIf@0=0=WIf@03001o003IfMT0fMWI\n03P0fMWI000L0=WIf@030000003IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`00O`00\nfMWI0=WIf@2H0=WIf@03001o003IfMT0fMWI00l0fMWI00<007l00=WIf@3IfMT0=`3IfMT001`0fMWI\n00<000000=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0C0=WIf@03001o003IfMT0fMWI09P0fMWI\n00<007l00=WIf@3IfMT03`3IfMT00`00O`00fMWI0=WIf@0g0=WIf@002@3IfMT2000000@0fMWI0P00\n00030=WIf@@00000103IfMT00`000000fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0180fMWI00<0\n07l00=WIf@3IfMT0U`3IfMT00`00O`00fMWI0=WIf@0@0=WIf@03001o003IfMT0fMWI03L0fMWI0008\n0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WI\nf@050=WIf@030000o`3IfMT0fMWI0180fMWI00<007l00=WIf@3IfMT0U`3IfMT00`00O`00fMWI0=WI\nf@0A0=WIf@03001o003IfMT0fMWI03H0fMWI00080=WIf@040000003IfMT0fMWI000000T0fMWI00<0\n00000=WIf@3IfMT0103IfMT2000000L0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`00O`00fMWI0=WI\nf@2F0=WIf@03001o003IfMT0fMWI0140fMWI00<007l00=WIf@3IfMT0=P3IfMT000P0fMWI00@00000\n0=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00H0fMWI00<0\n003o0=WIf@3IfMT04P3IfMT00`00O`00fMWI0=WIf@2F0=WIf@03001o003IfMT0fMWI0180fMWI00<0\n07l00=WIf@3IfMT0=@3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WI\nf@0000040=WIf@030000003IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`00O`00fMWI\n0=WIf@0E0=WIf@D0003oMP3IfMT40000o`03001o00000?l0003o00@0003o3`3IfMT00`00O`00fMWI\n0=WIf@0e0=WIf@002@3IfMT2000000X0fMWI0P0000050=WIf@030000003IfMT0fMWI00L0fMWI00<0\n003o0=WIf@3IfMT04P3IfMT00`00O`00fMWI0=WIf@0A0=WIf@@0003o1@3IfMT70000of`0fMWI0`00\n0?l40=WIf@03001o003IfMT0fMWI00<0fMWI1@000?l<0=WIf@03001o003IfMT0fMWI03@0fMWI000L\n0=WIf@030000003IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`00O`00fMWI0=WIf@0>\n0=WIf@<0003o3`3IfMT60000ofD0fMWI0P000?l70=WIf@03001o003IfMT0fMWI00P0fMWI1@000?l7\n0=WIf@03001o003IfMT0fMWI03@0fMWI000L0=WIf@030000003IfMT0fMWI00P0fMWI00<0003o0=WI\nf@3IfMT04P3IfMT00`00O`00fMWI0=WIf@0;0=WIf@<0003o5P3IfMT60000ocd0fMWI00<0003o0=WI\nf@3IfMT07`3IfMT20000o`L0fMWI00<007l00=WIf@3IfMT03@3IfMT60000o`80fMWI00<007l00=WI\nf@3IfMT0=03IfMT001`0fMWI00<000000=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0B0=WIf@03\n001o003IfMT0fMWI00X0fMWI0P000?lN0=WIfCh0003o7`3IfMT20000o`T0fMWI00<007l00=WIf@3I\nfMT04P3IfMT40000o`03001o00000?l0003o01H0003o7@3IfMT001`0fMWI00<000000=WIf@3IfMT0\n203IfMT00`000?l0fMWI0=WIf@0C0=WIf@03001o003IfMT0fMWI00P0fMWI0P000?mL0=WIf@030000\no`3IfMT0fMWI01`0fMWI0P000?l:0=WIf@03001o003IfMT0fMWI01H0fMWI00<007l00=WIf@3IfMT0\n<`3IfMT001`0fMWI00<000000=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0B0=WIf@03001o003I\nfMT0fMWI00L0fMWI0P000?mM0=WIf@030000o`3IfMT0fMWI01/0fMWI0P000?l;0=WIf@03001o003I\nfMT0fMWI01L0fMWI00<007l00=WIf@3IfMT0<P3IfMT001`0fMWI00<000000=WIf@3IfMT02@3IfMT0\n0`000?l0fMWI0=WIf@0B0=WIf@03001o003IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0G@3IfMT0\n0`000?l0fMWI0=WIf@0K0=WIf@030000o`3IfMT0fMWI00T0fMWI00<007l00=WIf@3IfMT0603IfMT0\n0`00O`00fMWI0=WIf@0b0=WIf@00703IfMT00`000000fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI\n0180fMWI00<007l00=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@1O0=WIf@030000o`3IfMT0fMWI\n01T0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`00O`00fMWI0=WIf@0I0=WIf@03001o003IfMT0fMWI\n0340fMWI000L0=WIf@030000003IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`00O`00\nfMWI0=WIf@030=WIf@030000o`3IfMT0fMWI03T0fMWI2P00O`0M0=WIf@030000o`3IfMT0fMWI01P0\nfMWI00<0003o0=WIf@3IfMT02`3IfMT00`00O`00fMWI0=WIf@0I0=WIf@03001o003IfMT0fMWI0340\nfMWI000L0=WIf@030000003IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`00O`00fMWI\n0=WIf@020=WIf@80003o>P3IfMT2001o00P0fMWI0`00O`0K0=WIf@030000o`3IfMT0fMWI01L0fMWI\n00<0003o0=WIf@3IfMT0303IfMT00`00O`00fMWI0=WIf@0I0=WIf@03001o003IfMT0fMWI0340fMWI\n000L0=WIf@030000003IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`00O`00fMWI0=WI\nf@020000ocX0fMWI00<007l00=WIf@3IfMT02P3IfMT3001o01T0fMWI00<0003o0=WIf@3IfMT05P3I\nfMT00`000?l0fMWI0=WIf@0=0=WIf@03001o003IfMT0fMWI01X0fMWI00<007l00=WIf@3IfMT0<03I\nfMT001`0fMWI00<000000=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0B0=WIf@04001o003IfMT0\n003o0000ocX0fMWI00<007l00=WIf@3IfMT03@3IfMT2001o01P0fMWI00<0003o0=WIf@3IfMT05@3I\nfMT20000o`h0fMWI00<007l00=WIf@3IfMT06`3IfMT00`00O`00fMWI0=WIf@0`0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI0140fMWI00<007l00=WIf@000?l0>P3IfMT0\n0`00O`00fMWI0=WIf@0@0=WIf@8007l05P3IfMT00`000?l0fMWI0=WIf@0E0=WIf@030000o`3IfMT0\nfMWI00d0fMWI00<007l00=WIf@3IfMT0703IfMT00`00O`00fMWI0=WIf@0_0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI0180fMWI00<007l00=WIf@3IfMT0>03IfMT00`00\nO`00fMWI0=WIf@0B0=WIf@8007l05P3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI\n00h0fMWI00<007l00=WIf@3IfMT0703IfMT00`00O`00fMWI0=WIf@0_0=WIf@00703IfMT00`000000\nfMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o001o003IfMT0>03IfMT2001o01H0\nfMWI0P00O`0D0=WIf@030000o`3IfMT0fMWI0180fMWI0P000?l@0=WIf@03001o003IfMT0fMWI01d0\nfMWI00<007l00=WIf@3IfMT0;P3IfMT001`0fMWI00<000000=WIf@3IfMT03@3IfMT00`000?l0fMWI\n0=WIf@0?0=WIf@80003o00<007l00=WIf@3IfMT0=`3IfMT00`00O`00fMWI0=WIf@0F0=WIf@<007l0\n4P3IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00l0fMWI00<007l00=WIf@3IfMT0\n7@3IfMT00`00O`00fMWI0=WIf@0^0=WIf@00703IfMT00`000000fMWI0=WIf@0>0=WIf@030000o`3I\nfMT0fMWI00h0fMWI00@0003o0=WIf@3IfMT007l0=`3IfMT00`00O`00fMWI0=WIf@0I0=WIf@8007l0\n4P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI0100fMWI00<007l00=WIf@3IfMT0\n7P3IfMT00`00O`00fMWI0=WIf@0]0=WIf@00703IfMT00`000000fMWI0=WIf@0>0=WIf@030000o`3I\nfMT0fMWI00d0fMWI00D0003o0=WIf@3IfMT0fMWI001o000f0=WIf@8007l0703IfMT3001o0100fMWI\n00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@0A0=WIf@03001o003IfMT0fMWI01l0fMWI\n00<007l00=WIf@3IfMT0;03IfMT000T0fMWI0P0000040=WIf@8000001@3IfMT3000000<0fMWI00<0\n00000=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI0080fMWI00<0\n07l00=WIf@3IfMT0=03IfMT00`00O`00fMWI0=WIf@0M0=WIf@<007l03P3IfMT00`000?l0fMWI0=WI\nf@0>0=WIf@80003o4P3IfMT00`00O`00fMWI0=WIf@0P0=WIf@03001o003IfMT0fMWI02`0fMWI0008\n0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WI\nf@0?0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0103IfMT00`00O`00fMWI0=WI\nf@0c0=WIf@03001o003IfMT0fMWI01l0fMWI0`00O`0=0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0\n003o0=WIf@3IfMT04@3IfMT00`00O`00fMWI0=WIf@0Q0=WIf@03001o003IfMT0fMWI02/0fMWI0008\n0=WIf@040000003IfMT0fMWI000000P0fMWI1@0000030=WIf@800000403IfMT00`000?l0fMWI0=WI\nf@090=WIf@030000o`3IfMT0fMWI00D0fMWI00<007l00=WIf@3IfMT0<P3IfMT00`00O`00fMWI0=WI\nf@0R0=WIf@<007l02`3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI0180fMWI00<0\n07l00=WIf@3IfMT08@3IfMT00`00O`00fMWI0=WIf@0[0=WIf@00203IfMT010000000fMWI0=WIf@00\n00080=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0403IfMT00`000?l0fMWI\n0=WIf@070=WIf@030000o`3IfMT0fMWI00L0fMWI00<007l00=WIf@3IfMT0<@3IfMT00`00O`00fMWI\n0=WIf@0U0=WIf@@007l0203IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI01<0fMWI\n00<007l00=WIf@3IfMT08P3IfMT00`00O`00fMWI0=WIf@0Z0=WIf@00203IfMT010000000fMWI0=WI\nf@0000090=WIf@030000003IfMT0000000@0fMWI00<000000=WIf@3IfMT04@3IfMT00`000?l0fMWI\n0=WIf@050=WIf@80003o2@3IfMT00`00O`00fMWI0=WIf@0`0=WIf@03001o003IfMT0fMWI02T0fMWI\n1@00O`040=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`00O`00fMWI\n0=WIf@0R0=WIf@03001o003IfMT0fMWI02X0fMWI00090=WIf@8000002`3IfMT2000000@0fMWI00<0\n00000=WIf@3IfMT04@3IfMT20000o`@0fMWI0`000?l:0=WIf@03001o003IfMT0fMWI0300fMWI00<0\n07l00=WIf@3IfMT0;@3IfMT00`00O`00fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI00P0fMWI00<0\n003o0=WIf@3IfMT04`3IfMT00`00O`00fMWI0=WIf@0T0=WIf@03001o003IfMT0fMWI02T0fMWI000L\n0=WIf@030000003IfMT0fMWI01<0fMWI1@000?l=0=WIf@03001o003IfMT0fMWI02h0fMWI00<007l0\n0=WIf@3IfMT0;P3IfMT00`00O`00fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o\n0=WIf@3IfMT0503IfMT00`00O`00fMWI0=WIf@0U0=WIf@03001o003IfMT0fMWI02P0fMWI000L0=WI\nf@030000003IfMT0fMWI02D0fMWI00<007l00=WIf@3IfMT0;P3IfMT00`00O`00fMWI0=WIf@0^0=WI\nf@03001o003IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0E0=WI\nf@03001o003IfMT0fMWI02D0fMWI0P00O`0Y0=WIf@00703IfMT00`000000fMWI0=WIf@0U0=WIf@03\n001o003IfMT0fMWI02d0fMWI00<007l00=WIf@3IfMT0<03IfMT00`00O`00fMWI0=WIf@030=WIf@80\n003o103IfMT20000oaP0fMWI00<007l00=WIf@3IfMT09P3IfMT2001o02P0fMWI000L0=WIf@030000\n003IfMT0fMWI02H0fMWI00<007l00=WIf@3IfMT0;03IfMT00`00O`00fMWI0=WIf@0`0=WIf@03001o\n003IfMT0fMWI00D0fMWI1@000?lI0=WIf@03001o003IfMT0fMWI02L0fMWI0P00O`0W0=WIf@00703I\nfMT00`000000fMWI0=WIf@0V0=WIf@03001o003IfMT0fMWI02`0fMWI00<007l00=WIf@3IfMT0<03I\nfMT00`00O`00fMWI0=WIf@0R0=WIf@03001o003IfMT0fMWI02T0fMWI0P00O`0V0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0V0=WIf@03001o003IfMT0fMWI02/0fMWI00<007l00=WIf@3IfMT0<@3IfMT0\n0`00O`00fMWI0=WIf@0R0=WIf@03001o003IfMT0fMWI02X0fMWI0`00O`0T0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0W0=WIf@03001o003IfMT0fMWI02X0fMWI00<007l00=WIf@3IfMT0<@3IfMT00`00\nO`00fMWI0=WIf@0R0=WIf@03001o003IfMT0fMWI02`0fMWI1000O`020=WIf@8007l07@3IfMT001`0\nfMWI00<000000=WIf@3IfMT09`3IfMT00`00O`00fMWI0=WIf@0Z0=WIf@03001o003IfMT0fMWI0340\nfMWI00<007l00=WIf@3IfMT08P3IfMT00`00O`00fMWI0=WIf@0_0=WIf@@007l07P3IfMT001`0fMWI\n00<000000=WIf@3IfMT0:03IfMT00`00O`00fMWI0=WIf@0X0=WIf@03001o003IfMT0fMWI03<0fMWI\n00<007l00=WIf@3IfMT08@3IfMT00`00O`00fMWI0=WIf@1A0=WIf@00703IfMT00`000000fMWI0=WI\nf@0X0=WIf@03001o003IfMT0fMWI02P0fMWI00<007l00=WIf@3IfMT0<`3IfMT00`00O`00fMWI0=WI\nf@0P0=WIf@03001o003IfMT0fMWI0580fMWI000L0=WIf@030000003IfMT0fMWI02P0fMWI00<007l0\n0=WIf@3IfMT0:03IfMT00`00O`00fMWI0=WIf@0c0=WIf@03001o003IfMT0fMWI0200fMWI00<007l0\n0=WIf@3IfMT0DP3IfMT001`0fMWI00<000000=WIf@3IfMT0:@3IfMT00`00O`00fMWI0=WIf@0V0=WI\nf@03001o003IfMT0fMWI03@0fMWI00<007l00=WIf@3IfMT0803IfMT00`00O`00fMWI0=WIf@1B0=WI\nf@00703IfMT00`000000fMWI0=WIf@0Y0=WIf@03001o003IfMT0fMWI02H0fMWI00<007l00=WIf@3I\nfMT0=03IfMT00`00O`00fMWI0=WIf@0P0=WIf@03001o003IfMT0fMWI0580fMWI000L0=WIf@030000\n003IfMT0fMWI02X0fMWI00<007l00=WIf@3IfMT09@3IfMT00`00O`00fMWI0=WIf@0e0=WIf@03001o\n003IfMT0fMWI01l0fMWI00<007l00=WIf@3IfMT0DP3IfMT001`0fMWI00<000000=WIf@3IfMT0:P3I\nfMT00`00O`00fMWI0=WIf@0T0=WIf@03001o003IfMT0fMWI03H0fMWI00<007l00=WIf@3IfMT07`3I\nfMT00`00O`00fMWI0=WIf@1B0=WIf@00703IfMT00`000000fMWI0=WIf@0[0=WIf@03001o003IfMT0\nfMWI02<0fMWI00<007l00=WIf@3IfMT0=P3IfMT00`00O`00fMWI0=WIf@0N0=WIf@03001o003IfMT0\nfMWI05<0fMWI00090=WIf@800000103IfMT2000000<0fMWI0`0000050=WIf@030000003IfMT0fMWI\n02/0fMWI00<007l00=WIf@3IfMT08P3IfMT00`00O`00fMWI0=WIf@0g0=WIf@03001o003IfMT0fMWI\n01h0fMWI00<007l00=WIf@3IfMT0D`3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT01000\n0000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI02/0fMWI00<007l00=WIf@3IfMT08P3IfMT0\n0`00O`00fMWI0=WIf@0g0=WIf@03001o003IfMT0fMWI01h0fMWI00<007l00=WIf@3IfMT0D`3IfMT0\n00P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@800000;03I\nfMT00`00O`00fMWI0=WIf@0R0=WIf@03001o003IfMT0fMWI03L0fMWI00<007l00=WIf@3IfMT07P3I\nfMT00`00O`00fMWI0=WIf@1C0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@<000001@3I\nfMT00`000000fMWI0=WIf@0/0=WIf@03001o003IfMT0fMWI0200fMWI00<007l00=WIf@3IfMT0>@3I\nfMT00`00O`00fMWI0=WIf@0M0=WIf@03001o003IfMT0fMWI05<0fMWI00080=WIf@040000003IfMT0\nfMWI000000T0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@0/0=WIf@03001o003I\nfMT0fMWI0200fMWI00<007l00=WIf@3IfMT0>@3IfMT00`00O`00fMWI0=WIf@0M0=WIf@03001o003I\nfMT0fMWI05<0fMWI00090=WIf@8000002P3IfMT3000000@0fMWI00<000000=WIf@3IfMT0;@3IfMT0\n0`00O`00fMWI0=WIf@0O0=WIf@03001o003IfMT0fMWI03T0fMWI00<007l00=WIf@3IfMT0703IfMT0\n0`00O`00fMWI0=WIf@1D0=WIf@00703IfMT00`000000fMWI0=WIf@0]0=WIf@03001o003IfMT0fMWI\n01h0fMWI00<007l00=WIf@3IfMT0>P3IfMT00`00O`00fMWI0=WIf@0L0=WIf@03001o003IfMT0fMWI\n05@0fMWI000L0=WIf@030000003IfMT0fMWI02h0fMWI00<007l00=WIf@3IfMT07@3IfMT00`00O`00\nfMWI0=WIf@0j0=WIf@03001o003IfMT0fMWI01`0fMWI00<007l00=WIf@3IfMT0E03IfMT001`0fMWI\n00<000000=WIf@3IfMT0;P3IfMT00`00O`00fMWI0=WIf@0M0=WIf@03001o003IfMT0fMWI03X0fMWI\n00<007l00=WIf@3IfMT0703IfMT00`00O`00fMWI0=WIf@1D0=WIf@00703IfMT00`000000fMWI0=WI\nf@0_0=WIf@03001o003IfMT0fMWI01`0fMWI00<007l00=WIf@3IfMT0>`3IfMT00`00O`00fMWI0=WI\nf@0K0=WIf@03001o003IfMT0fMWI05@0fMWI000L0=WIf@030000003IfMT0fMWI02l0fMWI00<007l0\n0=WIf@3IfMT0703IfMT00`00O`00fMWI0=WIf@0k0=WIf@03001o003IfMT0fMWI01/0fMWI00<007l0\n0=WIf@3IfMT0E03IfMT001`0fMWI00<000000=WIf@3IfMT0<03IfMT00`00O`00fMWI0=WIf@0J0=WI\nf@03001o003IfMT0fMWI03`0fMWI00<007l00=WIf@3IfMT06`3IfMT00`00O`00fMWI0=WIf@1D0=WI\nf@00703IfMT00`000000fMWI0=WIf@0`0=WIf@03001o003IfMT0fMWI01X0fMWI00<007l00=WIf@3I\nfMT0?03IfMT00`00O`00fMWI0=WIf@0K0=WIf@03001o003IfMT0fMWI05@0fMWI000L0=WIf@030000\n003IfMT0fMWI0340fMWI00<007l00=WIf@3IfMT06@3IfMT00`00O`00fMWI0=WIf@0l0=WIf@03001o\n003IfMT0fMWI01X0fMWI00<007l00=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WIf@3IfMT0<@3I\nfMT00`00O`00fMWI0=WIf@0H0=WIf@03001o003IfMT0fMWI03d0fMWI00<007l00=WIf@3IfMT06P3I\nfMT00`00O`00fMWI0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@0a0=WIf@03001o003IfMT0\nfMWI01P0fMWI00<007l00=WIf@3IfMT0?P3IfMT00`00O`00fMWI0=WIf@0I0=WIf@03001o003IfMT0\nfMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI0380fMWI00<007l00=WIf@3IfMT05`3IfMT00`00\nO`00fMWI0=WIf@0n0=WIf@03001o003IfMT0fMWI01T0fMWI00<007l00=WIf@3IfMT0E@3IfMT001`0\nfMWI00<000000=WIf@3IfMT0<P3IfMT2001o01L0fMWI00<007l00=WIf@3IfMT0?`3IfMT00`00O`00\nfMWI0=WIf@0I0=WIf@03001o003IfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI03<0fMWI\n00<007l00=WIf@3IfMT05@3IfMT00`00O`00fMWI0=WIf@0o0=WIf@03001o003IfMT0fMWI01T0fMWI\n00<007l00=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WIf@3IfMT0=03IfMT00`00O`00fMWI0=WI\nf@0C0=WIf@03001o003IfMT0fMWI0400fMWI00<007l00=WIf@3IfMT0603IfMT00`00O`00fMWI0=WI\nf@1F0=WIf@00703IfMT00`000000fMWI0=WIf@0d0=WIf@03001o003IfMT0fMWI01<0fMWI00<007l0\n0=WIf@3IfMT0@03IfMT00`00O`00fMWI0=WIf@0H0=WIf@03001o003IfMT0fMWI05H0fMWI000L0=WI\nf@030000003IfMT0fMWI03D0fMWI00<007l00=WIf@3IfMT04P3IfMT00`00O`00fMWI0=WIf@100=WI\nf@03001o003IfMT0fMWI01P0fMWI00<007l00=WIf@3IfMT0EP3IfMT000T0fMWI0P0000040=WIf@80\n0000103IfMT2000000D0fMWI00<000000=WIf@3IfMT0=@3IfMT00`00O`00fMWI0=WIf@0A0=WIf@03\n001o003IfMT0fMWI0440fMWI00<007l00=WIf@3IfMT0603IfMT00`00O`00fMWI0=WIf@1F0=WIf@00\n203IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WI\nf@3IfMT0=P3IfMT00`00O`00fMWI0=WIf@0@0=WIf@03001o003IfMT0fMWI0440fMWI00<007l00=WI\nf@3IfMT0603IfMT00`00O`00fMWI0=WIf@1F0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WI\nf@040000003IfMT0fMWI000000@0fMWI0P00000g0=WIf@03001o003IfMT0fMWI0100fMWI00<007l0\n0=WIf@3IfMT0@@3IfMT00`00O`00fMWI0=WIf@0H0=WIf@03001o003IfMT0fMWI05H0fMWI00080=WI\nf@040000003IfMT0fMWI000000T0fMWI0P0000050=WIf@030000003IfMT0fMWI03L0fMWI00<007l0\n0=WIf@3IfMT03P3IfMT00`00O`00fMWI0=WIf@130=WIf@03001o003IfMT0fMWI01H0fMWI00<007l0\n0=WIf@3IfMT0E`3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00\n00040=WIf@030000003IfMT0fMWI03L0fMWI00<007l00=WIf@3IfMT03P3IfMT00`00O`00fMWI0=WI\nf@130=WIf@03001o003IfMT0fMWI01H0fMWI00<007l00=WIf@3IfMT0E`3IfMT000T0fMWI0P00000:\n0=WIf@8000001@3IfMT00`000000fMWI0=WIf@0h0=WIf@03001o003IfMT0fMWI00d0fMWI00<007l0\n0=WIf@3IfMT0@`3IfMT00`00O`00fMWI0=WIf@0F0=WIf@03001o003IfMT0fMWI05L0fMWI000L0=WI\nf@030000003IfMT0fMWI03P0fMWI00<007l00=WIf@3IfMT03@3IfMT00`00O`00fMWI0=WIf@130=WI\nf@03001o003IfMT0fMWI01H0fMWI00<007l00=WIf@3IfMT0E`3IfMT001`0fMWI00<000000=WIf@3I\nfMT0>@3IfMT00`00O`00fMWI0=WIf@0;0=WIf@03001o003IfMT0fMWI04@0fMWI00<007l00=WIf@3I\nfMT05P3IfMT00`00O`00fMWI0=WIf@1G0=WIf@00703IfMT00`000000fMWI0=WIf@0i0=WIf@8007l0\n303IfMT00`00O`00fMWI0=WIf@140=WIf@03001o003IfMT0fMWI01H0fMWI00<007l00=WIf@3IfMT0\nE`3IfMT001`0fMWI00<000000=WIf@3IfMT0>P3IfMT00`00O`00fMWI0=WIf@090=WIf@03001o003I\nfMT0fMWI04H0fMWI00<007l00=WIf@3IfMT0503IfMT00`00O`00fMWI0=WIf@1H0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0k0=WIf@03001o003IfMT0fMWI00P0fMWI00<007l00=WIf@3IfMT0AP3IfMT0\n0`00O`00fMWI0=WIf@0D0=WIf@03001o003IfMT0fMWI05P0fMWI000L0=WIf@030000003IfMT0fMWI\n03/0fMWI00<007l00=WIf@3IfMT0203IfMT00`00O`00fMWI0=WIf@160=WIf@03001o003IfMT0fMWI\n01@0fMWI00<007l00=WIf@3IfMT0F03IfMT001`0fMWI00<000000=WIf@3IfMT0?03IfMT00`00O`00\nfMWI0=WIf@060=WIf@03001o003IfMT0fMWI04L0fMWI00<007l00=WIf@3IfMT0503IfMT00`00O`00\nfMWI0=WIf@1H0=WIf@00703IfMT00`000000fMWI0=WIf@0l0=WIf@03001o003IfMT0fMWI00D0fMWI\n00<007l00=WIf@3IfMT0B03IfMT00`00O`00fMWI0=WIf@0D0=WIf@03001o003IfMT0fMWI05P0fMWI\n000L0=WIf@030000003IfMT0fMWI03d0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI0=WI\nf@180=WIf@03001o003IfMT0fMWI01<0fMWI00<007l00=WIf@3IfMT0F@3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0?@3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI04X0fMWI00<007l0\n0=WIf@3IfMT04P3IfMT00`00O`00fMWI0=WIf@1I0=WIf@00703IfMT00`000000fMWI0=WIf@0n0=WI\nf@05001o003IfMT0fMWI0=WIf@00O`00C@3IfMT00`00O`00fMWI0=WIf@0B0=WIf@03001o003IfMT0\nfMWI05T0fMWI000L0=WIf@030000003IfMT0fMWI03l0fMWI1000O`1=0=WIf@03001o003IfMT0fMWI\n0180fMWI00<007l00=WIf@3IfMT0F@3IfMT001`0fMWI00<000000=WIf@3IfMT0T03IfMT00`00O`00\nfMWI0=WIf@0B0=WIf@03001o003IfMT0fMWI05T0fMWI000L0=WIf@030000003IfMT0fMWI0900fMWI\n00<007l00=WIf@3IfMT04P3IfMT00`00O`00fMWI0=WIf@1I0=WIf@00703IfMT00`000000fMWI0=WI\nf@2@0=WIf@03001o003IfMT0fMWI0180fMWI00<007l00=WIf@3IfMT0F@3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0T@3IfMT00`00O`00fMWI0=WIf@0A0=WIf@03001o003IfMT0fMWI05T0fMWI000L0=WI\nf@030000003IfMT0fMWI0940fMWI00<007l00=WIf@3IfMT0403IfMT00`00O`00fMWI0=WIf@1J0=WI\nf@00503IfMT5000000<0fMWI00<000000=WIf@3IfMT0T@3IfMT00`00O`00fMWI0=WIf@0@0=WIf@03\n001o003IfMT0fMWI05X0fMWI000F0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0\nT@3IfMT00`00O`00fMWI0=WIf@0@0=WIf@03001o003IfMT0fMWI05X0fMWI000F0=WIf@030000003I\nfMT0fMWI00<0fMWI0P00002B0=WIf@03001o003IfMT0fMWI0100fMWI00<007l00=WIf@3IfMT0FP3I\nfMT001H0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2A0=WIf@03001o003IfMT0\nfMWI0100fMWI00<007l00=WIf@3IfMT0FP3IfMT001H0fMWI00<000000=WIf@3IfMT00`3IfMT00`00\n0000fMWI0=WIf@2B0=WIf@03001o003IfMT0fMWI00l0fMWI00<007l00=WIf@3IfMT0FP3IfMT001D0\nfMWI0P0000050=WIf@030000003IfMT0fMWI0980fMWI00<007l00=WIf@3IfMT03P3IfMT00`00O`00\nfMWI0=WIf@1K0=WIf@00703IfMT00`000000fMWI0=WIf@2B0=WIf@03001o003IfMT0fMWI00h0fMWI\n00<007l00=WIf@3IfMT0F`3IfMT001`0fMWI00<000000=WIf@3IfMT0TP3IfMT00`00O`00fMWI0=WI\nf@0>0=WIf@03001o003IfMT0fMWI05/0fMWI000L0=WIf@030000003IfMT0fMWI0980fMWI00<007l0\n0=WIf@3IfMT03P3IfMT00`00O`00fMWI0=WIf@1K0=WIf@00703IfMT00`000000fMWI0=WIf@2C0=WI\nf@03001o003IfMT0fMWI00`0fMWI00<007l00=WIf@3IfMT0G03IfMT001`0fMWI00<000000=WIf@3I\nfMT0T`3IfMT00`00O`00fMWI0=WIf@0<0=WIf@03001o003IfMT0fMWI05`0fMWI000L0=WIf@030000\n003IfMT0fMWI09<0fMWI00<007l00=WIf@3IfMT0303IfMT00`00O`00fMWI0=WIf@1L0=WIf@00703I\nfMT00`000000fMWI0=WIf@2C0=WIf@03001o003IfMT0fMWI00`0fMWI00<007l00=WIf@3IfMT0G03I\nfMT001`0fMWI00<000000=WIf@3IfMT0T`3IfMT00`00O`00fMWI0=WIf@0<0=WIf@03001o003IfMT0\nfMWI05`0fMWI000L0=WIf@030000003IfMT0fMWI09<0fMWI00<007l00=WIf@3IfMT02`3IfMT00`00\nO`00fMWI0=WIf@1M0=WIf@00703IfMT00`000000fMWI0=WIf@2C0=WIf@03001o003IfMT0fMWI00/0\nfMWI00<007l00=WIf@3IfMT0G@3IfMT001`0fMWI00<000000=WIf@3IfMT0T`3IfMT00`00O`00fMWI\n0=WIf@0;0=WIf@03001o003IfMT0fMWI05d0fMWI000L0=WIf@030000003IfMT0fMWI09@0fMWI00<0\n07l00=WIf@3IfMT02P3IfMT00`00O`00fMWI0=WIf@1M0=WIf@00703IfMT00`000000fMWI0=WIf@2D\n0=WIf@03001o003IfMT0fMWI00T0fMWI00<007l00=WIf@3IfMT0GP3IfMT001`0fMWI00<000000=WI\nf@3IfMT0U03IfMT00`00O`00fMWI0=WIf@090=WIf@03001o003IfMT0fMWI05h0fMWI000L0=WIf@03\n0000003IfMT0fMWI09@0fMWI00<007l00=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@1N0=WIf@00\n703IfMT00`000000fMWI0=WIf@2E0=WIf@03001o003IfMT0fMWI00P0fMWI00<007l00=WIf@3IfMT0\nGP3IfMT000P0fMWI1@0000020=WIf@8000000`3IfMT4000000@0fMWI00<000000=WIf@3IfMT0U@3I\nfMT00`00O`00fMWI0=WIf@070=WIf@03001o003IfMT0fMWI05l0fMWI000:0=WIf@030000003IfMT0\nfMWI00L0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@2E0=WIf@03001o003IfMT0\nfMWI00L0fMWI00<007l00=WIf@3IfMT0G`3IfMT000X0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@040=WIf@800000U`3IfMT00`00O`00fMWI0=WIf@060=WIf@03001o003IfMT0fMWI\n05l0fMWI000:0=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000\nfMWI0=WIf@2F0=WIf@03001o003IfMT0fMWI00H0fMWI00<007l00=WIf@3IfMT0G`3IfMT000X0fMWI\n00<000000=WIf@3IfMT01`3IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI09H0\nfMWI00<007l00=WIf@3IfMT01@3IfMT00`00O`00fMWI0=WIf@1P0=WIf@002@3IfMT2000000X0fMWI\n0P0000050=WIf@030000003IfMT0fMWI09L0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI\n0=WIf@1P0=WIf@00703IfMT00`000000fMWI0=WIf@2G0=WIf@03001o003IfMT0fMWI00@0fMWI00<0\n07l00=WIf@3IfMT0H03IfMT001`0fMWI00<000000=WIf@3IfMT0V03IfMT00`00O`00fMWI0=WIf@02\n0=WIf@03001o003IfMT0fMWI0640fMWI000L0=WIf@030000003IfMT0fMWI09P0fMWI00<007l00=WI\nf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@1Q0=WIf@00703IfMT00`000000fMWI0=WIf@2I0=WIf@04\n001o003IfMT0fMWI001o06@0fMWI000L0=WIf@030000003IfMT0fMWI09T0fMWI0`00O`1U0=WIf@00\n703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3I\nfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WI\nf@80fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI000U0=WIf@030000003IfMT0fMWI02X0fMWI00<000000=WIf@3IfMT01@3IfMT2000000P0\nfMWI0P00002j0=WIf@00903IfMT00`000000fMWI0=WIf@0/0=WIf@030000003IfMT0fMWI00@0fMWI\n00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@2h0=WIf@008`3IfMT00`000000fMWI0=WI\nf@030=WIf@8000000`3IfMT700000080fMWI100000000`3IfMT00000000000020=WIf@@000000`3I\nfMT200000080fMWI0`0000000`3IfMT00000000000030=WIf@030000003IfMT0fMWI00<0fMWI00<0\n00000=WIf@3IfMT00P3IfMT2000000@0fMWI00<000000=WIf@3IfMT0^03IfMT002<0fMWI00<00000\n0=WIf@3IfMT00P3IfMT010000000fMWI0=WIf@0000020=WIf@@000000P3IfMT010000000fMWI0=WI\nf@0000020=WIf@030000003IfMT0000000<0fMWI00<000000=WIf@3IfMT02@3IfMT010000000fMWI\n0=WIf@0000040=WIf@030000003IfMT0fMWI00<0fMWI00D000000=WIf@3IfMT0fMWI000000020=WI\nf@050000003IfMT0fMWI0=WIf@000000^P3IfMT001H0fMWI2000O`050=WIf@030000003IfMT0fMWI\n0080fMWI00<000000=WIf@3IfMT01P3IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0\nfMWI00<00000103IfMT00`000000fMWI0=WIf@080=WIf@040000003IfMT0fMWI000000@0fMWI00<0\n00000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0\n^03IfMT002<0fMWI00@000000=WIf@3IfMT0fMWI1@0000030=WIf@<0000000<0fMWI000000000000\n0P0000030=WIf@040000003IfMT00000000000@0fMWI00<000000=WIf@3IfMT01`3IfMT3000000D0\nfMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@05000000<0fMWI00<000000=WIf@3I\nfMT0^03IfMT002@0fMWI00D000000=WIf@3IfMT0fMWI0000000A0=WIf@030000003IfMT0fMWI00<0\nfMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI\n00@0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0;P0fMWI000U0=WI\nf@030000003IfMT0fMWI0140fMWI0P0000060=WIf@800000203IfMT2000000D0fMWI00<000000=WI\nf@3IfMT01@3IfMT2000000P0fMWI0P00002j0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@009@3IfMT00`000000fMWI\n0=WIf@0Z0=WIf@030000003IfMT0fMWI00D0fMWI0P0000080=WIf@800000^P3IfMT002@0fMWI00<0\n00000=WIf@3IfMT0;03IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00P0fMWI00<0\n00000=WIf@3IfMT0^03IfMT002<0fMWI00<000000=WIf@3IfMT00`3IfMT2000000<0fMWI1`000002\n0=WIf@@0000000<0fMWI0000000000000P3IfMT500000080fMWI0P0000020=WIf@<0000000<0fMWI\n0000000000000`3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI0P000004\n0=WIf@030000003IfMT0fMWI0;P0fMWI000F0=WIf@P0003o1@3IfMT00`000000fMWI0=WIf@020=WI\nf@040000003IfMT0fMWI00000080fMWI100000020=WIf@040000003IfMT0fMWI00000080fMWI00<0\n00000=WIf@0000001@3IfMT00`000000fMWI0=WIf@070=WIf@040000003IfMT0fMWI000000@0fMWI\n00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00D000000=WIf@3I\nfMT0fMWI0000002j0=WIf@008`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00H0\nfMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@03000000D0fMWI00<000000=WI\nf@3IfMT01`3IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI00<0fMWI00D00000\n0=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0;P0fMWI000S0=WIf@040000003IfMT0\nfMWI0=WIf@D000000`3IfMT3000000030=WIf@0000000000008000000`3IfMT010000000fMWI0000\n000000040=WIf@030000003IfMT0fMWI00L0fMWI0`0000050=WIf@030000003IfMT0fMWI00<0fMWI\n00<000000=WIf@3IfMT01@0000030=WIf@030000003IfMT0fMWI0;P0fMWI000T0=WIf@050000003I\nfMT0fMWI0=WIf@0000004@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00L0fMWI\n00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@050000003IfMT0fMWI0=WIf@00\n00001P3IfMT00`000000fMWI0=WIf@2h0=WIf@009@3IfMT00`000000fMWI0=WIf@0A0=WIf@800000\n1P3IfMT2000000P0fMWI0P0000050=WIf@030000003IfMT0fMWI00D0fMWI0P0000080=WIf@800000\n^P3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00001"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-30.4421`, -0.201703`, 1.08639`, 0.00892898`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -10.3955`, 0.119891`, 0.0615577`]], Rule[List[List[22.125`, 30.4375`], List[43.0625`, 26.8125`]], List[-6.32337`, -42.9027`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[24.1875`, 7.9375`]], List[-6.32337`, -47.4441`, 0.240604`, 0.240604`]]]]], Cell[BoxData[TagBox[RowBox[List[RowBox[List["\[SkeletonIndicator]", "Graphics"]], "\[SkeletonIndicator]"]], False, Rule[Editable, False]]], "Output"], Cell["plot( { tank1.qOut.lflow, tank2.qOut.lflow } );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.00380952 0.0147151 2.18619 [\n[.21429 .00222 -6 -9 ]\n[.21429 .00222 6 0 ]\n[.40476 .00222 -9 -9 ]\n[.40476 .00222 9 0 ]\n[.59524 .00222 -9 -9 ]\n[.59524 .00222 9 0 ]\n[.78571 .00222 -9 -9 ]\n[.78571 .00222 9 0 ]\n[.97619 .00222 -9 -9 ]\n[.97619 .00222 9 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .12402 -24 -4.5 ]\n[.01131 .12402 0 4.5 ]\n[.01131 .23333 -18 -4.5 ]\n[.01131 .23333 0 4.5 ]\n[.01131 .34264 -24 -4.5 ]\n[.01131 .34264 0 4.5 ]\n[.01131 .45195 -18 -4.5 ]\n[.01131 .45195 0 4.5 ]\n[.01131 .56126 -24 -4.5 ]\n[.01131 .56126 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .01472 m\n.21429 .02097 L\ns\n[(50)] .21429 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(100)] .40476 .00222 0 1 Mshowa\n.59524 .01472 m\n.59524 .02097 L\ns\n[(150)] .59524 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(200)] .78571 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(250)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.0619 .01472 m\n.0619 .01847 L\ns\n.1 .01472 m\n.1 .01847 L\ns\n.1381 .01472 m\n.1381 .01847 L\ns\n.17619 .01472 m\n.17619 .01847 L\ns\n.25238 .01472 m\n.25238 .01847 L\ns\n.29048 .01472 m\n.29048 .01847 L\ns\n.32857 .01472 m\n.32857 .01847 L\ns\n.36667 .01472 m\n.36667 .01847 L\ns\n.44286 .01472 m\n.44286 .01847 L\ns\n.48095 .01472 m\n.48095 .01847 L\ns\n.51905 .01472 m\n.51905 .01847 L\ns\n.55714 .01472 m\n.55714 .01847 L\ns\n.63333 .01472 m\n.63333 .01847 L\ns\n.67143 .01472 m\n.67143 .01847 L\ns\n.70952 .01472 m\n.70952 .01847 L\ns\n.74762 .01472 m\n.74762 .01847 L\ns\n.82381 .01472 m\n.82381 .01847 L\ns\n.8619 .01472 m\n.8619 .01847 L\ns\n.9 .01472 m\n.9 .01847 L\ns\n.9381 .01472 m\n.9381 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .12402 m\n.03006 .12402 L\ns\n[(0.05)] .01131 .12402 1 0 Mshowa\n.02381 .23333 m\n.03006 .23333 L\ns\n[(0.1)] .01131 .23333 1 0 Mshowa\n.02381 .34264 m\n.03006 .34264 L\ns\n[(0.15)] .01131 .34264 1 0 Mshowa\n.02381 .45195 m\n.03006 .45195 L\ns\n[(0.2)] .01131 .45195 1 0 Mshowa\n.02381 .56126 m\n.03006 .56126 L\ns\n[(0.25)] .01131 .56126 1 0 Mshowa\n.125 Mabswid\n.02381 .03658 m\n.02756 .03658 L\ns\n.02381 .05844 m\n.02756 .05844 L\ns\n.02381 .0803 m\n.02756 .0803 L\ns\n.02381 .10216 m\n.02756 .10216 L\ns\n.02381 .14589 m\n.02756 .14589 L\ns\n.02381 .16775 m\n.02756 .16775 L\ns\n.02381 .18961 m\n.02756 .18961 L\ns\n.02381 .21147 m\n.02756 .21147 L\ns\n.02381 .2552 m\n.02756 .2552 L\ns\n.02381 .27706 m\n.02756 .27706 L\ns\n.02381 .29892 m\n.02756 .29892 L\ns\n.02381 .32078 m\n.02756 .32078 L\ns\n.02381 .36451 m\n.02756 .36451 L\ns\n.02381 .38637 m\n.02756 .38637 L\ns\n.02381 .40823 m\n.02756 .40823 L\ns\n.02381 .43009 m\n.02756 .43009 L\ns\n.02381 .47382 m\n.02756 .47382 L\ns\n.02381 .49568 m\n.02756 .49568 L\ns\n.02381 .51754 m\n.02756 .51754 L\ns\n.02381 .5394 m\n.02756 .5394 L\ns\n.02381 .58313 m\n.02756 .58313 L\ns\n.02381 .60499 m\n.02756 .60499 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01808 L\n.0981 .02147 L\n.1 .02478 L\n.1019 .02802 L\n.10381 .03118 L\n.10571 .03424 L\n.10762 .03722 L\n.10952 .0401 L\n.11143 .04289 L\n.11333 .04558 L\n.11524 .04818 L\n.11714 .05067 L\nMistroke\n.11905 .05306 L\n.12095 .05535 L\n.12286 .05753 L\n.12476 .05961 L\n.12667 .06159 L\n.12857 .06346 L\n.13048 .06523 L\n.13238 .06689 L\n.13429 .06846 L\n.13619 .06992 L\n.1381 .07128 L\n.14 .07255 L\n.1419 .07372 L\n.14381 .07479 L\n.14571 .07577 L\n.14762 .07666 L\n.14952 .07747 L\n.15143 .07818 L\n.15333 .07882 L\n.15524 .07937 L\n.15714 .07985 L\n.15905 .08025 L\n.16095 .08057 L\n.16286 .08083 L\n.16476 .08102 L\n.16667 .08115 L\n.16857 .08121 L\n.17048 .08122 L\n.17238 .08117 L\n.17429 .08106 L\n.17619 .08091 L\n.1781 .08071 L\n.18 .08047 L\n.1819 .08018 L\n.18381 .07985 L\n.18571 .07949 L\n.18762 .07909 L\n.18952 .07867 L\n.19143 .07821 L\n.19333 .07773 L\n.19524 .07722 L\n.19714 .07669 L\n.19905 .07615 L\n.20095 .07558 L\n.20286 .07501 L\n.20476 .07442 L\n.20667 .07382 L\n.20857 .07321 L\n.21048 .0726 L\n.21238 .07198 L\nMistroke\n.21429 .07136 L\n.21619 .07074 L\n.2181 .07012 L\n.22 .0695 L\n.2219 .06888 L\n.22381 .06827 L\n.22571 .06766 L\n.22762 .06706 L\n.22952 .06647 L\n.23143 .06589 L\n.23333 .06533 L\n.23524 .06477 L\n.23714 .06422 L\n.23905 .06369 L\n.24095 .06317 L\n.24286 .06266 L\n.24476 .06217 L\n.24667 .06169 L\n.24857 .06123 L\n.25048 .06078 L\n.25238 .06036 L\n.25429 .05994 L\n.25619 .05955 L\n.2581 .05917 L\n.26 .0588 L\n.2619 .05846 L\n.26381 .05813 L\n.26571 .05782 L\n.26762 .05752 L\n.26952 .05724 L\n.27143 .05698 L\n.27333 .05673 L\n.27524 .0565 L\n.27714 .05629 L\n.27905 .05609 L\n.28095 .05591 L\n.28286 .05574 L\n.28476 .05558 L\n.28667 .05544 L\n.28857 .05532 L\n.29048 .05521 L\n.29238 .05511 L\n.29429 .05503 L\n.29619 .05495 L\n.2981 .05489 L\n.3 .05484 L\n.3019 .05481 L\n.30381 .05478 L\n.30571 .05476 L\n.30762 .05475 L\nMistroke\n.30952 .05476 L\n.31143 .05477 L\n.31333 .05479 L\n.31524 .05482 L\n.31714 .05485 L\n.31905 .05489 L\n.32095 .05494 L\n.32286 .055 L\n.32476 .05506 L\n.32667 .05512 L\n.32857 .05519 L\n.33048 .05527 L\n.33238 .05535 L\n.33429 .05543 L\n.33619 .05552 L\n.3381 .05561 L\n.34 .0557 L\n.3419 .05579 L\n.34381 .05589 L\n.34571 .05599 L\n.34762 .05608 L\n.34952 .05618 L\n.35143 .05628 L\n.35333 .05638 L\n.35524 .05648 L\n.35714 .05659 L\n.35905 .05669 L\n.36095 .05678 L\n.36286 .05688 L\n.36476 .05698 L\n.36667 .05708 L\n.36857 .05717 L\n.37048 .05727 L\n.37238 .05736 L\n.37429 .05745 L\n.37619 .05754 L\n.3781 .05762 L\n.38 .05771 L\n.3819 .05779 L\n.38381 .05787 L\n.38571 .05794 L\n.38762 .05802 L\n.38952 .05809 L\n.39143 .05816 L\n.39333 .05822 L\n.39524 .05829 L\n.39714 .05835 L\n.39905 .0584 L\n.40095 .05846 L\n.40286 .05851 L\nMistroke\n.40476 .05856 L\n.40667 .05861 L\n.40857 .05865 L\n.41048 .05869 L\n.41238 .05873 L\n.41429 .05877 L\n.41619 .0588 L\n.4181 .05883 L\n.42 .05886 L\n.4219 .05889 L\n.42381 .05891 L\n.42571 .05893 L\n.42762 .05895 L\n.42952 .05897 L\n.43143 .05899 L\n.43333 .059 L\n.43524 .05901 L\n.43714 .05902 L\n.43905 .05903 L\n.44095 .05903 L\n.44286 .05903 L\n.44476 .05904 L\n.44667 .05904 L\n.44857 .05904 L\n.45048 .05903 L\n.45238 .05903 L\n.45429 .05902 L\n.45619 .05902 L\n.4581 .05901 L\n.46 .059 L\n.4619 .05899 L\n.46381 .05898 L\n.46571 .05897 L\n.46762 .05896 L\n.46952 .05895 L\n.47143 .05894 L\n.47333 .05892 L\n.47524 .05891 L\n.47714 .05889 L\n.47905 .05888 L\n.48095 .05886 L\n.48286 .05885 L\n.48476 .05883 L\n.48667 .05882 L\n.48857 .0588 L\n.49048 .05878 L\n.49238 .05877 L\n.49429 .05875 L\n.49619 .05873 L\n.4981 .05872 L\nMistroke\n.5 .0587 L\n.5019 .05869 L\n.50381 .05867 L\n.50571 .05865 L\n.50762 .05864 L\n.50952 .05862 L\n.51143 .05861 L\n.51333 .05859 L\n.51524 .05858 L\n.51714 .05857 L\n.51905 .05855 L\n.52095 .05854 L\n.52286 .05853 L\n.52476 .05851 L\n.52667 .0585 L\n.52857 .05849 L\n.53048 .05848 L\n.53238 .05847 L\n.53429 .05846 L\n.53619 .05845 L\n.5381 .05844 L\n.54 .05843 L\n.5419 .05842 L\n.54381 .05842 L\n.54571 .05841 L\n.54762 .0584 L\n.54952 .05839 L\n.55143 .05839 L\n.55333 .05838 L\n.55524 .05838 L\n.55714 .05837 L\n.55905 .05837 L\n.56095 .05836 L\n.56286 .05836 L\n.56476 .05836 L\n.56667 .05835 L\n.56857 .05835 L\n.57048 .05835 L\n.57238 .05835 L\n.57429 .05835 L\n.57619 .05834 L\n.5781 .05834 L\n.58 .05834 L\n.5819 .05834 L\n.58381 .05834 L\n.58571 .05834 L\n.58762 .05834 L\n.58952 .05834 L\n.59143 .05834 L\n.59333 .05834 L\nMistroke\n.59524 .05834 L\n.59524 .05834 L\n.59524 .05834 L\n.59714 .06272 L\n.59905 .06708 L\n.60095 .07141 L\n.60286 .07572 L\n.60476 .07999 L\n.60667 .08421 L\n.60857 .08838 L\n.61048 .09249 L\n.61238 .09652 L\n.61429 .10048 L\n.61619 .10436 L\n.6181 .10815 L\n.62 .11185 L\n.6219 .11545 L\n.62381 .11895 L\n.62571 .12234 L\n.62762 .12562 L\n.62952 .1288 L\n.63143 .13186 L\n.63333 .1348 L\n.63524 .13763 L\n.63714 .14034 L\n.63905 .14293 L\n.64095 .1454 L\n.64286 .14776 L\n.64476 .14999 L\n.64667 .15211 L\n.64857 .1541 L\n.65048 .15598 L\n.65238 .15774 L\n.65429 .15939 L\n.65619 .16092 L\n.6581 .16235 L\n.66 .16366 L\n.6619 .16487 L\n.66381 .16597 L\n.66571 .16697 L\n.66762 .16786 L\n.66952 .16866 L\n.67143 .16937 L\n.67333 .16998 L\n.67524 .17051 L\n.67714 .17095 L\n.67905 .17131 L\n.68095 .17159 L\n.68286 .17179 L\n.68476 .17192 L\nMistroke\n.68667 .17198 L\n.68857 .17197 L\n.69048 .1719 L\n.69238 .17177 L\n.69429 .17158 L\n.69619 .17134 L\n.6981 .17105 L\n.7 .17072 L\n.7019 .17033 L\n.70381 .16991 L\n.70571 .16945 L\n.70762 .16895 L\n.70952 .16843 L\n.71143 .16787 L\n.71333 .16728 L\n.71524 .16668 L\n.71714 .16605 L\n.71905 .1654 L\n.72095 .16474 L\n.72286 .16406 L\n.72476 .16338 L\n.72667 .16268 L\n.72857 .16198 L\n.73048 .16127 L\n.73238 .16056 L\n.73429 .15985 L\n.73619 .15914 L\n.7381 .15843 L\n.74 .15772 L\n.7419 .15703 L\n.74381 .15633 L\n.74571 .15565 L\n.74762 .15497 L\n.74952 .15431 L\n.75143 .15366 L\n.75333 .15302 L\n.75524 .1524 L\n.75714 .15179 L\n.75905 .15119 L\n.76095 .15061 L\n.76286 .15005 L\n.76476 .1495 L\n.76667 .14898 L\n.76857 .14847 L\n.77048 .14798 L\n.77238 .1475 L\n.77429 .14705 L\n.77619 .14662 L\n.7781 .1462 L\n.78 .14581 L\nMistroke\n.7819 .14543 L\n.78381 .14507 L\n.78571 .14474 L\n.78762 .14442 L\n.78952 .14412 L\n.79143 .14384 L\n.79333 .14358 L\n.79524 .14333 L\n.79714 .14311 L\n.79905 .1429 L\n.80095 .14271 L\n.80286 .14254 L\n.80476 .14238 L\n.80667 .14224 L\n.80857 .14212 L\n.81048 .14201 L\n.81238 .14192 L\n.81429 .14184 L\n.81619 .14177 L\n.8181 .14172 L\n.82 .14168 L\n.8219 .14165 L\n.82381 .14163 L\n.82571 .14163 L\n.82762 .14163 L\n.82952 .14165 L\n.83143 .14167 L\n.83333 .14171 L\n.83524 .14175 L\n.83714 .1418 L\n.83905 .14186 L\n.84095 .14192 L\n.84286 .14199 L\n.84476 .14207 L\n.84667 .14216 L\n.84857 .14224 L\n.85048 .14234 L\n.85238 .14243 L\n.85429 .14253 L\n.85619 .14264 L\n.8581 .14274 L\n.86 .14285 L\n.8619 .14296 L\n.86381 .14308 L\n.86571 .14319 L\n.86762 .14331 L\n.86952 .14342 L\n.87143 .14354 L\n.87333 .14365 L\n.87524 .14377 L\nMistroke\n.87714 .14389 L\n.87905 .144 L\n.88095 .14411 L\n.88286 .14423 L\n.88476 .14434 L\n.88667 .14445 L\n.88857 .14456 L\n.89048 .14466 L\n.89238 .14476 L\n.89429 .14487 L\n.89619 .14496 L\n.8981 .14506 L\n.9 .14515 L\n.9019 .14524 L\n.90381 .14533 L\n.90571 .14542 L\n.90762 .1455 L\n.90952 .14558 L\n.91143 .14565 L\n.91333 .14573 L\n.91524 .1458 L\n.91714 .14586 L\n.91905 .14593 L\n.92095 .14599 L\n.92286 .14604 L\n.92476 .1461 L\n.92667 .14615 L\n.92857 .14619 L\n.93048 .14624 L\n.93238 .14628 L\n.93429 .14632 L\n.93619 .14635 L\n.9381 .14639 L\n.94 .14642 L\n.9419 .14644 L\n.94381 .14647 L\n.94571 .14649 L\n.94762 .14651 L\n.94952 .14653 L\n.95143 .14654 L\n.95333 .14655 L\n.95524 .14656 L\n.95714 .14657 L\n.95905 .14658 L\n.96095 .14658 L\n.96286 .14658 L\n.96476 .14658 L\n.96667 .14658 L\n.96857 .14658 L\n.97048 .14657 L\nMistroke\n.97238 .14657 L\n.97429 .14656 L\n.97619 .14655 L\nMfstroke\n0 .5 0 r\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01472 L\n.0981 .01472 L\n.1 .01472 L\n.1019 .01472 L\n.10381 .01472 L\n.10571 .01472 L\n.10762 .01472 L\n.10952 .01472 L\n.11143 .01472 L\n.11333 .01472 L\n.11524 .01472 L\n.11714 .01472 L\nMistroke\n.11905 .01472 L\n.12095 .01472 L\n.12286 .01472 L\n.12476 .01472 L\n.12667 .01472 L\n.12857 .01472 L\n.13048 .01472 L\n.13238 .01472 L\n.13429 .01472 L\n.13619 .01472 L\n.1381 .01472 L\n.14 .01472 L\n.1419 .01472 L\n.14381 .01472 L\n.14571 .01472 L\n.14762 .01472 L\n.14952 .01472 L\n.15143 .01472 L\n.15333 .01472 L\n.15524 .01472 L\n.15714 .01472 L\n.15905 .01472 L\n.16095 .01472 L\n.16286 .01472 L\n.16476 .01472 L\n.16667 .01472 L\n.16857 .01472 L\n.17048 .01472 L\n.17238 .01472 L\n.17429 .01472 L\n.17619 .01472 L\n.1781 .01472 L\n.18 .01472 L\n.1819 .01472 L\n.18381 .01472 L\n.18571 .01472 L\n.18762 .01472 L\n.18952 .01472 L\n.19143 .01472 L\n.19333 .01472 L\n.19524 .01472 L\n.19714 .01472 L\n.19905 .01472 L\n.20095 .01472 L\n.20286 .01472 L\n.20476 .01472 L\n.20667 .01472 L\n.20857 .01472 L\n.21048 .01472 L\n.21238 .01472 L\nMistroke\n.21429 .01472 L\n.21619 .01472 L\n.2181 .01472 L\n.22 .01472 L\n.2219 .01472 L\n.22381 .01472 L\n.22571 .01472 L\n.22762 .01472 L\n.22952 .01472 L\n.23143 .01472 L\n.23333 .01472 L\n.23524 .01472 L\n.23714 .01472 L\n.23905 .01472 L\n.24095 .01472 L\n.24286 .01472 L\n.24476 .01472 L\n.24667 .01472 L\n.24857 .01472 L\n.25048 .01472 L\n.25238 .01472 L\n.25429 .01472 L\n.25619 .01472 L\n.2581 .01472 L\n.26 .01472 L\n.2619 .01472 L\n.26381 .01472 L\n.26571 .01472 L\n.26762 .01472 L\n.26952 .01472 L\n.27143 .01472 L\n.27333 .01472 L\n.27524 .01472 L\n.27714 .01472 L\n.27905 .01472 L\n.28095 .01472 L\n.28286 .01472 L\n.28476 .01472 L\n.28667 .01472 L\n.28857 .01472 L\n.29048 .01472 L\n.29238 .01472 L\n.29429 .02125 L\n.29619 .02815 L\n.2981 .03482 L\n.3 .04126 L\n.3019 .04746 L\n.30381 .05343 L\n.30571 .05918 L\n.30762 .06471 L\nMistroke\n.30952 .07001 L\n.31143 .07509 L\n.31333 .07993 L\n.31524 .08455 L\n.31714 .08894 L\n.31905 .09311 L\n.32095 .09704 L\n.32286 .10075 L\n.32476 .10424 L\n.32667 .1075 L\n.32857 .11055 L\n.33048 .11337 L\n.33238 .11599 L\n.33429 .11839 L\n.33619 .12059 L\n.3381 .12258 L\n.34 .12438 L\n.3419 .12598 L\n.34381 .12739 L\n.34571 .12862 L\n.34762 .12967 L\n.34952 .13054 L\n.35143 .13125 L\n.35333 .13178 L\n.35524 .13216 L\n.35714 .13239 L\n.35905 .13247 L\n.36095 .1324 L\n.36286 .1322 L\n.36476 .13187 L\n.36667 .13142 L\n.36857 .13084 L\n.37048 .13015 L\n.37238 .12936 L\n.37429 .12846 L\n.37619 .12746 L\n.3781 .12637 L\n.38 .1252 L\n.3819 .12395 L\n.38381 .12262 L\n.38571 .12122 L\n.38762 .11976 L\n.38952 .11824 L\n.39143 .11667 L\n.39333 .11504 L\n.39524 .11338 L\n.39714 .11168 L\n.39905 .10994 L\n.40095 .10817 L\n.40286 .10638 L\nMistroke\n.40476 .10456 L\n.40667 .10273 L\n.40857 .10089 L\n.41048 .09904 L\n.41238 .09718 L\n.41429 .09533 L\n.41619 .09347 L\n.4181 .09163 L\n.42 .08979 L\n.4219 .08796 L\n.42381 .08615 L\n.42571 .08436 L\n.42762 .08259 L\n.42952 .08084 L\n.43143 .07912 L\n.43333 .07742 L\n.43524 .07575 L\n.43714 .07412 L\n.43905 .07252 L\n.44095 .07095 L\n.44286 .06943 L\n.44476 .06794 L\n.44667 .06649 L\n.44857 .06508 L\n.45048 .06371 L\n.45238 .06238 L\n.45429 .0611 L\n.45619 .05986 L\n.4581 .05867 L\n.46 .05753 L\n.4619 .05642 L\n.46381 .05537 L\n.46571 .05436 L\n.46762 .0534 L\n.46952 .05248 L\n.47143 .05161 L\n.47333 .05079 L\n.47524 .05001 L\n.47714 .04927 L\n.47905 .04859 L\n.48095 .04794 L\n.48286 .04735 L\n.48476 .04679 L\n.48667 .04628 L\n.48857 .04581 L\n.49048 .04538 L\n.49238 .04499 L\n.49429 .04465 L\n.49619 .04434 L\n.4981 .04407 L\nMistroke\n.5 .04384 L\n.5019 .04364 L\n.50381 .04348 L\n.50571 .04335 L\n.50762 .04326 L\n.50952 .0432 L\n.51143 .04316 L\n.51333 .04316 L\n.51524 .04319 L\n.51714 .04324 L\n.51905 .04332 L\n.52095 .04343 L\n.52286 .04356 L\n.52476 .04371 L\n.52667 .04389 L\n.52857 .04408 L\n.53048 .0443 L\n.53238 .04453 L\n.53429 .04478 L\n.53619 .04505 L\n.5381 .04533 L\n.54 .04562 L\n.5419 .04593 L\n.54381 .04625 L\n.54571 .04658 L\n.54762 .04692 L\n.54952 .04726 L\n.55143 .04762 L\n.55333 .04798 L\n.55524 .04835 L\n.55714 .04872 L\n.55905 .0491 L\n.56095 .04948 L\n.56286 .04986 L\n.56476 .05024 L\n.56667 .05063 L\n.56857 .05101 L\n.57048 .05139 L\n.57238 .05178 L\n.57429 .05216 L\n.57619 .05253 L\n.5781 .05291 L\n.58 .05328 L\n.5819 .05364 L\n.58381 .054 L\n.58571 .05436 L\n.58762 .05471 L\n.58952 .05505 L\n.59143 .05539 L\n.59333 .05572 L\nMistroke\n.59524 .05604 L\n.59524 .05604 L\n.59524 .05604 L\n.59714 .05998 L\n.59905 .06445 L\n.60095 .06945 L\n.60286 .07496 L\n.60476 .08098 L\n.60667 .0875 L\n.60857 .09451 L\n.61048 .10198 L\n.61238 .10991 L\n.61429 .11828 L\n.61619 .12706 L\n.6181 .13625 L\n.62 .14581 L\n.6219 .15572 L\n.62381 .16597 L\n.62571 .17652 L\n.62762 .18736 L\n.62952 .19846 L\n.63143 .20979 L\n.63333 .22134 L\n.63524 .23306 L\n.63714 .24494 L\n.63905 .25695 L\n.64095 .26905 L\n.64286 .28124 L\n.64476 .29348 L\n.64667 .30574 L\n.64857 .31799 L\n.65048 .33023 L\n.65238 .34241 L\n.65429 .35451 L\n.65619 .36652 L\n.6581 .3784 L\n.66 .39014 L\n.6619 .40171 L\n.66381 .4131 L\n.66571 .42428 L\n.66762 .43523 L\n.66952 .44594 L\n.67143 .45639 L\n.67333 .46656 L\n.67524 .47644 L\n.67714 .486 L\n.67905 .49525 L\n.68095 .50417 L\n.68286 .51273 L\n.68476 .52095 L\nMistroke\n.68667 .52879 L\n.68857 .53627 L\n.69048 .54336 L\n.69238 .55007 L\n.69429 .55639 L\n.69619 .56231 L\n.6981 .56783 L\n.7 .57294 L\n.7019 .57766 L\n.70381 .58197 L\n.70571 .58587 L\n.70762 .58937 L\n.70952 .59247 L\n.71143 .59517 L\n.71333 .59748 L\n.71524 .59939 L\n.71714 .60092 L\n.71905 .60208 L\n.72095 .60285 L\n.72286 .60327 L\n.72476 .60332 L\n.72667 .60302 L\n.72857 .60238 L\n.73048 .60142 L\n.73238 .60012 L\n.73429 .59852 L\n.73619 .59662 L\n.7381 .59443 L\n.74 .59196 L\n.7419 .58922 L\n.74381 .58623 L\n.74571 .58301 L\n.74762 .57955 L\n.74952 .57588 L\n.75143 .572 L\n.75333 .56793 L\n.75524 .56368 L\n.75714 .55927 L\n.75905 .5547 L\n.76095 .55 L\n.76286 .54517 L\n.76476 .54022 L\n.76667 .53517 L\n.76857 .53003 L\n.77048 .52482 L\n.77238 .51954 L\n.77429 .5142 L\n.77619 .50883 L\n.7781 .50342 L\n.78 .49799 L\nMistroke\n.7819 .49256 L\n.78381 .48712 L\n.78571 .4817 L\n.78762 .4763 L\n.78952 .47094 L\n.79143 .46561 L\n.79333 .46034 L\n.79524 .45512 L\n.79714 .44997 L\n.79905 .4449 L\n.80095 .43991 L\n.80286 .43501 L\n.80476 .43021 L\n.80667 .42551 L\n.80857 .42092 L\n.81048 .41644 L\n.81238 .41209 L\n.81429 .40786 L\n.81619 .40376 L\n.8181 .39979 L\n.82 .39596 L\n.8219 .39227 L\n.82381 .38872 L\n.82571 .38532 L\n.82762 .38206 L\n.82952 .37896 L\n.83143 .376 L\n.83333 .3732 L\n.83524 .37055 L\n.83714 .36805 L\n.83905 .36571 L\n.84095 .36352 L\n.84286 .36148 L\n.84476 .35959 L\n.84667 .35785 L\n.84857 .35626 L\n.85048 .35482 L\n.85238 .35353 L\n.85429 .35238 L\n.85619 .35137 L\n.8581 .35049 L\n.86 .34976 L\n.8619 .34916 L\n.86381 .34868 L\n.86571 .34834 L\n.86762 .34812 L\n.86952 .34802 L\n.87143 .34803 L\n.87333 .34816 L\n.87524 .3484 L\nMistroke\n.87714 .34874 L\n.87905 .34918 L\n.88095 .34972 L\n.88286 .35035 L\n.88476 .35107 L\n.88667 .35188 L\n.88857 .35277 L\n.89048 .35373 L\n.89238 .35476 L\n.89429 .35586 L\n.89619 .35702 L\n.8981 .35824 L\n.9 .35952 L\n.9019 .36084 L\n.90381 .36221 L\n.90571 .36362 L\n.90762 .36507 L\n.90952 .36656 L\n.91143 .36807 L\n.91333 .36961 L\n.91524 .37117 L\n.91714 .37275 L\n.91905 .37434 L\n.92095 .37595 L\n.92286 .37756 L\n.92476 .37917 L\n.92667 .38079 L\n.92857 .3824 L\n.93048 .38401 L\n.93238 .38561 L\n.93429 .3872 L\n.93619 .38878 L\n.9381 .39034 L\n.94 .39188 L\n.9419 .3934 L\n.94381 .3949 L\n.94571 .39637 L\n.94762 .39781 L\n.94952 .39923 L\n.95143 .40061 L\n.95333 .40196 L\n.95524 .40328 L\n.95714 .40456 L\n.95905 .4058 L\n.96095 .40701 L\n.96286 .40818 L\n.96476 .40931 L\n.96667 .41039 L\n.96857 .41144 L\n.97048 .41244 L\nMistroke\n.97238 .4134 L\n.97429 .41432 L\n.97619 .4152 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0119048 0.119048 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0214286 0.0721271 0.140476 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 .5 0 r\n.00374 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .08095 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(tank2) show\n99.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(qOut) show\n129.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n135.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(lflow) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n165.000 12.813 moveto\n(L) show\n171.000 12.813 moveto\n(@) show\n177.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n183.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.159524 0.0721271 0.278571 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00374 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .21905 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(tank1) show\n99.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(qOut) show\n129.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n135.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(lflow) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n165.000 12.813 moveto\n(L) show\n171.000 12.813 moveto\n(@) show\n177.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n183.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00BP3IfMT2000000@0fMWI0P00\n000Q0=WIf@D000000P3IfMT2000000@0fMWI0P00000N0=WIf@D000000P3IfMT2000000@0fMWI0P00\n000N0=WIf@@000000`3IfMT2000000@0fMWI0P00000N0=WIf@@000000`3IfMT2000000@0fMWI0P00\n000G0=WIf@00B@3IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI00000280fMWI\n00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WI\nf@3IfMT07@3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00@000000=WIf@3IfMT000000P3I\nfMT00`000000fMWI0=WIf@0K0=WIf@030000003IfMT0fMWI00<0fMWI00@000000=WIf@3IfMT00000\n0P3IfMT010000000fMWI0=WIf@00000M0=WIf@030000003IfMT0fMWI00<0fMWI00@000000=WIf@3I\nfMT000000P3IfMT010000000fMWI0=WIf@00000F0=WIf@00C03IfMT010000000fMWI0=WIf@000002\n0=WIf@030000003IfMT0fMWI0200fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003I\nfMT0fMWI00000080fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@040=WIf@040000\n003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0703IfMT00`000000fMWI0=WIf@020=WIf@04\n0000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000007P3IfMT00`000000fMWI0=WIf@05\n0=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0503IfMT004X0fMWI0P000003\n0=WIf@040000003IfMT0fMWI00000280fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000\n003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@020=WIf@80\n00000`3IfMT010000000fMWI0=WIf@00000O0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT0\n10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT00P3I\nfMT2000000<0fMWI00@000000=WIf@3IfMT000005P3IfMT004X0fMWI00<000000=WIf@3IfMT00P3I\nfMT010000000fMWI0=WIf@00000R0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT010000000\nfMWI0=WIf@0000020=WIf@030000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT00P3IfMT00`00\n0000fMWI0=WIf@020=WIf@040000003IfMT0fMWI000001d0fMWI00@000000=WIf@3IfMT000000P3I\nfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI000001d0fMWI00@000000=WIf@3I\nfMT000000`3IfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0fMWI000001H0fMWI001:0=WI\nf@<000000`3IfMT200000280fMWI0P0000040=WIf@800000103IfMT2000001l0fMWI0P0000040=WI\nf@<000000`3IfMT2000001l0fMWI0P0000040=WIf@800000103IfMT2000001l0fMWI0P0000040=WI\nf@<000000`3IfMT2000001L0fMWI003o0=WIfB40fMWI000Q0=WIf@030000003IfMT0fMWI0?`0fMWI\n000Q0=WIf@030000003IfMT0fMWI0?`0fMWI000Q0=WIf@030000003IfMT0fMWI0>d0fMWI0P00000=\n0=WIf@008@3IfMT00`000000fMWI0=WIf@3/0=WIf@040000003IfMT0fMWI000000`0fMWI000L0=WI\nf@D00000@@00O`2W000000L0fMWI00<000000=WIf@3IfMT03@3IfMT00240fMWI00<000000=WIf@3I\nfMT03`3IfMT00`000?l0fMWI0=WIf@0H0=WIf@030000003IfMT0fMWI0100fMWI00<007l00=WIf@3I\nfMT05`3IfMT00`000000fMWI0=WIf@0Z0=WIf@030000003IfMT0fMWI02X0fMWI00<000000=WIf@3I\nfMT0:P3IfMT00`000000fMWI0=WIf@0:0=WIf@D00000303IfMT00240fMWI00<000000=WIf@3IfMT0\n3`3IfMT00`000?l0fMWI0=WIf@0[0=WIf@03001o003IfMT0fMWI0:`0fMWI00<000000=WIf@3IfMT0\n3@3IfMT00240fMWI00<000000=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@0[0=WIf@03001o003I\nfMT0fMWI0;/0fMWI000Q0=WIf@030000003IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT0:P3IfMT0\n0`00O`00fMWI0=WIf@2k0=WIf@008@3IfMT200000180fMWI00<0003o0=WIf@3IfMT0:P3IfMT00`00\nO`00fMWI0=WIf@2k0=WIf@008@3IfMT00`000000fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI02X0\nfMWI00<007l00=WIf@3IfMT0;03IfMT7001o08L0fMWI000Q0=WIf@030000003IfMT0fMWI01<0fMWI\n00<0003o0=WIf@3IfMT0:@3IfMT00`00O`00fMWI0=WIf@0W0=WIf@D007l01P3IfMT7001o0840fMWI\n000Q0=WIf@030000003IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0:@3IfMT00`00O`00fMWI0=WI\nf@0U0=WIf@<007l04@3IfMT6001o07/0fMWI000Q0=WIf@030000003IfMT0fMWI01@0fMWI00<0003o\n0=WIf@3IfMT08@3IfMT70000o`03001o00000?l0003o00/0003o603IfMT2001o01T0fMWI1P00O`1f\n0=WIf@008@3IfMT2000001H0fMWI00<0003o0=WIf@3IfMT06`3IfMT60000o`L0fMWI00<007l00=WI\nf@3IfMT02P3IfMTF0000o`8007l080000?l00`00O`00fMWI0=WIf@1d0=WIf@008@3IfMT00`000000\nfMWI0=WIf@0F0=WIf@80003o5`3IfMT40000o`d0fMWI00<007l00=WIf@3IfMT07`3IfMT2001o0240\nfMWI00<007l00=WIf@3IfMT0M03IfMT00240fMWI00<000000=WIf@3IfMT05`3IfMT00`000?l0fMWI\n0=WIf@0B0=WIf@@0003o403IfMT00`00O`00fMWI0=WIf@0M0=WIf@8007l08`3IfMT00`00O`00fMWI\n0=WIf@1d0=WIf@008@3IfMT00`000000fMWI0=WIf@0H0=WIf@80003o3`3IfMT30000oaD0fMWI00<0\n07l00=WIf@3IfMT06`3IfMT2001o02@0fMWI00<007l00=WIf@3IfMT0M03IfMT00240fMWI00<00000\n0=WIf@3IfMT06P3IfMT20000o`T0fMWI1@000?lG0=WIf@03001o003IfMT0fMWI01X0fMWI0P00O`0V\n0=WIf@03001o003IfMT0fMWI07<0fMWI000Q0=WIf@8000007@3IfMT:0000oa`0fMWI00<007l00=WI\nf@3IfMT0603IfMT2001o02L0fMWI00<007l00=WIf@3IfMT0L`3IfMT00240fMWI00<000000=WIf@3I\nfMT0@P3IfMT00`00O`00fMWI0=WIf@0G0=WIf@8007l0:03IfMT00`00O`00003o0=WIf@1c0=WIf@00\n8@3IfMT00`000000fMWI0=WIf@130=WIf@03001o003IfMT0fMWI01D0fMWI00<007l00=WIf@3IfMT0\n:@3IfMT00`00O`00fMWI0=WIf@1b0=WIf@008@3IfMT00`000000fMWI0=WIf@130=WIf@03001o003I\nfMT0fMWI01@0fMWI00<007l00=WIf@3IfMT0:P3IfMT00`00O`00003o0=WIf@1b0=WIf@008@3IfMT0\n0`000000fMWI0=WIf@130=WIf@03001o003IfMT0fMWI01<0fMWI00<007l00=WIf@3IfMT0:`3IfMT0\n0`00O`00003o0=WIf@1b0=WIf@008@3IfMT2000004D0fMWI00<007l00=WIf@3IfMT04@3IfMT00`00\nO`00fMWI0=WIf@0]0=WIf@03001o00000?l0fMWI0740fMWI000Q0=WIf@030000003IfMT0fMWI04@0\nfMWI0P00O`0A0=WIf@03001o003IfMT0fMWI02h0fMWI00<007l00000o`3IfMT0L@3IfMT00240fMWI\n00<000000=WIf@3IfMT0A@3IfMT00`00O`00fMWI0=WIf@0=0=WIf@8007l0<@3IfMT00`00O`00fMWI\n0000o`1a0=WIf@002@3IfMT2000000@0fMWI0P0000040=WIf@800000103IfMT2000000@0fMWI00<0\n00000=WIf@3IfMT0AP3IfMT00`00O`00fMWI0=WIf@0<0=WIf@03001o003IfMT0fMWI0300fMWI00<0\n07l00=WIf@000?l0L@3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WI\nf@0000020=WIf@040000003IfMT0fMWI000000<0fMWI00<000000=WIf@3IfMT0A`3IfMT00`00O`00\nfMWI0=WIf@090=WIf@8007l0=03IfMT00`00O`00fMWI0000o`1`0=WIf@00203IfMT010000000fMWI\n0=WIf@0000080=WIf@040000003IfMT0fMWI000000D0fMWI00@000000=WIf@3IfMT0fMWI0`000017\n0=WIf@8007l02@3IfMT2001o03D0fMWI00<007l00=WIf@000?l0L03IfMT000P0fMWI00@000000=WI\nf@3IfMT00000203IfMT010000000fMWI0=WIf@0000030=WIf@800000103IfMT00`000000fMWI0=WI\nf@180=WIf@8007l01P3IfMT2001o03L0fMWI00@007l00=WIf@3IfMT0003oK`3IfMT000P0fMWI00@0\n00000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000030=WIf@030000003IfMT0fMWI00<0\nfMWI00<000000=WIf@3IfMT0BP3IfMT7001o03P0fMWI00D007l00=WIf@3IfMT0fMWI0000o`1^0=WI\nf@002@3IfMT2000000X0fMWI0P0000040=WIf@<000000`3IfMT00`000000fMWI0=WIf@2:0=WIf@04\n001o003IfMT0fMWI0000ofh0fMWI000Q0=WIf@030000003IfMT0fMWI08X0fMWI00D007l00=WIf@3I\nfMT0fMWI0000o`1]0=WIf@008@3IfMT00`000000fMWI0=WIf@2:0=WIf@04001o003IfMT0fMWI0=WI\nf@80003o803IfMTQ0000ob/0fMWI000Q0=WIf@800000R`3IfMT00`00O`00fMWI0=WIf@020=WIf@80\n003o6`3IfMT40000ob00fMWI3`000?lM0=WIf@008@3IfMT00`000000fMWI0=WIf@2:0=WIf@03001o\n003IfMT0fMWI00<0fMWI0P000?lG0=WIf@<0003oD03IfMT00240fMWI00<000000=WIf@3IfMT0RP3I\nfMT00`00O`00fMWI0=WIf@040=WIf@80003o4`3IfMT30000oe<0fMWI000Q0=WIf@030000003IfMT0\nfMWI08X0fMWI00<007l00=WIf@3IfMT01@3IfMT20000o`l0fMWI0`000?mF0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@2;0=WIf@03001o003IfMT0fMWI00D0fMWI0`000?l:0=WIf@@0003oF03IfMT00240\nfMWI0P00002<0=WIf@03001o003IfMT0fMWI00L0fMWI10000?l30=WIf@D0003oF`3IfMT00240fMWI\n00<000000=WIf@3IfMT0R`3IfMT00`00O`00fMWI0=WIf@0:0=WIf@D0003oG`3IfMT00240fMWI00<0\n00000=WIf@3IfMT0R`3IfMT00`00O`00fMWI0=WIf@1^0=WIf@008@3IfMT00`000000fMWI0=WIf@2;\n0=WIf@03001o003IfMT0fMWI06h0fMWI000Q0=WIf@030000003IfMT0fMWI08`0fMWI00<007l00=WI\nf@3IfMT0K@3IfMT00240fMWI0P00002=0=WIf@03001o003IfMT0fMWI06d0fMWI000Q0=WIf@030000\n003IfMT0fMWI08`0fMWI00<007l00=WIf@3IfMT0K@3IfMT00240fMWI00<000000=WIf@3IfMT0S03I\nfMT00`00O`00fMWI0=WIf@1]0=WIf@008@3IfMT00`000000fMWI0=WIf@2<0=WIf@03001o003IfMT0\nfMWI06d0fMWI000Q0=WIf@030000003IfMT0fMWI08d0fMWI00<007l00=WIf@3IfMT0K03IfMT00240\nfMWI0P00002>0=WIf@03001o003IfMT0fMWI06`0fMWI000Q0=WIf@030000003IfMT0fMWI08d0fMWI\n00<007l00=WIf@3IfMT0K03IfMT00240fMWI00<000000=WIf@3IfMT0S@3IfMT00`00O`00fMWI0=WI\nf@1/0=WIf@003`3IfMT2000000@0fMWI0P0000030=WIf@D000000P3IfMT00`000000fMWI0=WIf@2=\n0=WIf@03001o003IfMT0fMWI06`0fMWI000>0=WIf@040000003IfMT0fMWI000000X0fMWI00<00000\n0=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@2>0=WIf@03001o003IfMT0fMWI06/0fMWI000>0=WI\nf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00P3IfMT3000008h0fMWI00<007l0\n0=WIf@3IfMT0J`3IfMT000h0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@02\n0=WIf@030000003IfMT0fMWI08h0fMWI00<007l00=WIf@3IfMT0J`3IfMT000h0fMWI00@000000=WI\nf@3IfMT000002P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI08h0fMWI00<007l0\n0=WIf@3IfMT0J`3IfMT000l0fMWI0P00000:0=WIf@800000103IfMT00`000000fMWI0=WIf@2>0=WI\nf@03001o003IfMT0fMWI06/0fMWI000Q0=WIf@030000003IfMT0fMWI08h0fMWI00<007l00=WIf@3I\nfMT0J`3IfMT00240fMWI0P00002?0=WIf@03001o003IfMT0fMWI06/0fMWI000Q0=WIf@030000003I\nfMT0fMWI08h0fMWI00<007l00=WIf@3IfMT0J`3IfMT00240fMWI00<000000=WIf@3IfMT0SP3IfMT0\n0`00O`00fMWI0=WIf@1[0=WIf@008@3IfMT00`000000fMWI0=WIf@2?0=WIf@03001o003IfMT0fMWI\n06X0fMWI000Q0=WIf@030000003IfMT0fMWI08l0fMWI00<007l00=WIf@3IfMT0JP3IfMT00240fMWI\n0P00002@0=WIf@03001o003IfMT0fMWI06X0fMWI000Q0=WIf@030000003IfMT0fMWI08l0fMWI00<0\n07l00=WIf@3IfMT0JP3IfMT00240fMWI00<000000=WIf@3IfMT0S`3IfMT00`00O`00fMWI0=WIf@1Z\n0=WIf@008@3IfMT00`000000fMWI0=WIf@2@0=WIf@03001o003IfMT0fMWI06T0fMWI000Q0=WIf@03\n0000003IfMT0fMWI0900fMWI00<007l00=WIf@3IfMT0J@3IfMT00240fMWI00<000000=WIf@3IfMT0\nT03IfMT00`00O`00fMWI0=WIf@1Y0=WIf@008@3IfMT200000940fMWI00<007l00=WIf@3IfMT0J@3I\nfMT00240fMWI00<000000=WIf@3IfMT0T03IfMT00`00O`00fMWI0=WIf@1Y0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@2@0=WIf@03001o003IfMT0fMWI06T0fMWI000Q0=WIf@030000003IfMT0fMWI0940\nfMWI00<007l00=WIf@3IfMT0J03IfMT00240fMWI00<000000=WIf@3IfMT0T@3IfMT00`00O`00fMWI\n0=WIf@1X0=WIf@008@3IfMT200000980fMWI00<007l00=WIf@3IfMT0J03IfMT00240fMWI00<00000\n0=WIf@3IfMT0T@3IfMT00`00O`00fMWI0=WIf@1X0=WIf@008@3IfMT00`000000fMWI0=WIf@2A0=WI\nf@03001o003IfMT0fMWI06P0fMWI00090=WIf@800000103IfMT2000000<0fMWI1@0000020=WIf@80\n0000103IfMT00`000000fMWI0=WIf@2A0=WIf@03001o003IfMT0fMWI06P0fMWI00080=WIf@040000\n003IfMT0fMWI000000X0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@050000003IfMT0fMWI\n0=WIf@000000U03IfMT00`00O`00fMWI0=WIf@1W0=WIf@00203IfMT010000000fMWI0=WIf@00000:\n0=WIf@030000003IfMT0fMWI00@0fMWI00@000000=WIf@3IfMT0fMWI0`00002B0=WIf@03001o003I\nfMT0fMWI06L0fMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00P3I\nfMT2000000@0fMWI00<000000=WIf@3IfMT0TP3IfMT00`00O`00fMWI0=WIf@0^0=WIf@D007l0=03I\nfMT000P0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@020=WIf@030000003I\nfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0TP3IfMT00`00O`00fMWI0=WIf@0/0=WIf@<007l00`3I\nfMT4001o0340fMWI00090=WIf@8000002P3IfMT2000000@0fMWI0`0000030=WIf@030000003IfMT0\nfMWI0980fMWI00<007l00=WIf@3IfMT0:P3IfMT2001o00T0fMWI0P00O`0`0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@2B0=WIf@03001o003IfMT0fMWI02X0fMWI00<007l00=WIf@3IfMT02P3IfMT2001o\n02h0fMWI000Q0=WIf@800000U03IfMT00`00O`00fMWI0=WIf@0X0=WIf@03001o003IfMT0fMWI00`0\nfMWI0P00O`0]0=WIf@008@3IfMT00`000000fMWI0=WIf@2C0=WIf@03001o003IfMT0fMWI02L0fMWI\n00<007l00=WIf@3IfMT03P3IfMT2001o02`0fMWI000Q0=WIf@030000003IfMT0fMWI09<0fMWI00<0\n07l00=WIf@3IfMT09P3IfMT00`00O`00fMWI0=WIf@0A0=WIf@03001o003IfMT0fMWI02T0fMWI000Q\n0=WIf@030000003IfMT0fMWI09<0fMWI00<007l00=WIf@3IfMT09@3IfMT2001o01@0fMWI0P00O`0Y\n0=WIf@008@3IfMT00`000000fMWI0=WIf@2C0=WIf@03001o003IfMT0fMWI02D0fMWI00<007l00=WI\nf@3IfMT0503IfMT2001o02P0fMWI000Q0=WIf@800000U03IfMT00`00O`00fMWI0=WIf@0T0=WIf@03\n001o003IfMT0fMWI01H0fMWI0P00O`0W0=WIf@008@3IfMT00`000000fMWI0=WIf@2C0=WIf@03001o\n003IfMT0fMWI02@0fMWI00<007l00=WIf@3IfMT0603IfMT00`00O`00fMWI0=WIf@0T0=WIf@008@3I\nfMT00`000000fMWI0=WIf@2C0=WIf@03001o003IfMT0fMWI02<0fMWI0P00O`0K0=WIf@03001o003I\nfMT0fMWI02<0fMWI000Q0=WIf@030000003IfMT0fMWI09@0fMWI00<007l00=WIf@3IfMT08P3IfMT0\n0`00O`00fMWI0=WIf@0K0=WIf@8007l08`3IfMT00240fMWI00<000000=WIf@3IfMT0U03IfMT00`00\nO`00fMWI0=WIf@0Q0=WIf@03001o003IfMT0fMWI01d0fMWI0P00O`0R0=WIf@008@3IfMT2000009D0\nfMWI00<007l00=WIf@3IfMT08@3IfMT00`00O`00fMWI0=WIf@0O0=WIf@8007l0803IfMT00240fMWI\n00<000000=WIf@3IfMT0U03IfMT00`00O`00fMWI0=WIf@0P0=WIf@03001o003IfMT0fMWI0240fMWI\n0`00O`0N0=WIf@008@3IfMT00`000000fMWI0=WIf@2D0=WIf@03001o003IfMT0fMWI0200fMWI00<0\n07l00=WIf@3IfMT08`3IfMT2001o01d0fMWI000Q0=WIf@030000003IfMT0fMWI09D0fMWI00<007l0\n0=WIf@3IfMT07P3IfMT00`00O`00fMWI0=WIf@130=WIf@008@3IfMT00`000000fMWI0=WIf@2E0=WI\nf@03001o003IfMT0fMWI01h0fMWI00<007l00=WIf@3IfMT0@`3IfMT00240fMWI0P00002F0=WIf@03\n001o003IfMT0fMWI01h0fMWI00<007l00=WIf@3IfMT0@`3IfMT00240fMWI00<000000=WIf@3IfMT0\nU@3IfMT00`00O`00fMWI0=WIf@0N0=WIf@03001o003IfMT0fMWI04<0fMWI000Q0=WIf@030000003I\nfMT0fMWI09D0fMWI00<007l00=WIf@3IfMT07@3IfMT00`00O`00fMWI0=WIf@140=WIf@008@3IfMT0\n0`000000fMWI0=WIf@2E0=WIf@03001o003IfMT0fMWI01d0fMWI00<007l00=WIf@3IfMT0A03IfMT0\n00l0fMWI0P0000040=WIf@8000000`3IfMT4000000<0fMWI00<000000=WIf@3IfMT0UP3IfMT00`00\nO`00fMWI0=WIf@0K0=WIf@03001o003IfMT0fMWI04D0fMWI000>0=WIf@040000003IfMT0fMWI0000\n00P0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2F0=WIf@03001o003IfMT0fMWI\n01/0fMWI00<007l00=WIf@3IfMT0A@3IfMT000h0fMWI00@000000=WIf@3IfMT000002@3IfMT00`00\n0000fMWI0=WIf@030=WIf@<00000UP3IfMT00`00O`00fMWI0=WIf@0J0=WIf@03001o003IfMT0fMWI\n04H0fMWI000>0=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00P3IfMT00`00\n0000fMWI0=WIf@2F0=WIf@03001o003IfMT0fMWI01X0fMWI00<007l00=WIf@3IfMT0AP3IfMT000h0\nfMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000030=WIf@030000003IfMT0\nfMWI09H0fMWI00<007l00=WIf@3IfMT06P3IfMT00`00O`00fMWI0=WIf@160=WIf@003`3IfMT20000\n00X0fMWI0P0000040=WIf@030000003IfMT0fMWI09L0fMWI00<007l00=WIf@3IfMT0603IfMT00`00\nO`00fMWI0=WIf@170=WIf@008@3IfMT00`000000fMWI0=WIf@2G0=WIf@03001o003IfMT0fMWI01P0\nfMWI00<007l00=WIf@3IfMT0A`3IfMT00240fMWI0P00002H0=WIf@03001o003IfMT0fMWI01L0fMWI\n00<007l00=WIf@3IfMT0B03IfMT00240fMWI00<000000=WIf@3IfMT0U`3IfMT00`00O`00fMWI0=WI\nf@0G0=WIf@03001o003IfMT0fMWI04P0fMWI000Q0=WIf@030000003IfMT0fMWI09L0fMWI00<007l0\n0=WIf@3IfMT05`3IfMT00`00O`00fMWI0=WIf@180=WIf@008@3IfMT00`000000fMWI0=WIf@2G0=WI\nf@03001o003IfMT0fMWI01L0fMWI00<007l00=WIf@3IfMT0B03IfMT00240fMWI00<000000=WIf@3I\nfMT0U`3IfMT00`00O`00fMWI0=WIf@0F0=WIf@03001o003IfMT0fMWI04T0fMWI000Q0=WIf@800000\nV@3IfMT00`00O`00fMWI0=WIf@0E0=WIf@03001o003IfMT0fMWI04T0fMWI000Q0=WIf@030000003I\nfMT0fMWI09P0fMWI00<007l00=WIf@3IfMT0503IfMT00`00O`00fMWI0=WIf@1:0=WIf@008@3IfMT0\n0`000000fMWI0=WIf@2H0=WIf@03001o003IfMT0fMWI01@0fMWI00<007l00=WIf@3IfMT0BP3IfMT0\n0240fMWI00<000000=WIf@3IfMT0V03IfMT00`00O`00fMWI0=WIf@0D0=WIf@03001o003IfMT0fMWI\n04X0fMWI000Q0=WIf@030000003IfMT0fMWI09T0fMWI00<007l00=WIf@3IfMT04P3IfMT00`00O`00\nfMWI0=WIf@1;0=WIf@008@3IfMT2000009X0fMWI00<007l00=WIf@3IfMT04P3IfMT00`00O`00fMWI\n0=WIf@1;0=WIf@008@3IfMT00`000000fMWI0=WIf@2I0=WIf@03001o003IfMT0fMWI0180fMWI00<0\n07l00=WIf@3IfMT0B`3IfMT00240fMWI00<000000=WIf@3IfMT0V@3IfMT00`00O`00fMWI0=WIf@0A\n0=WIf@03001o003IfMT0fMWI04`0fMWI000Q0=WIf@030000003IfMT0fMWI09X0fMWI00<007l00=WI\nf@3IfMT0403IfMT00`00O`00fMWI0=WIf@1<0=WIf@008@3IfMT00`000000fMWI0=WIf@2J0=WIf@03\n001o003IfMT0fMWI0100fMWI00<007l00=WIf@3IfMT0C03IfMT00240fMWI0P00002K0=WIf@03001o\n003IfMT0fMWI00l0fMWI00<007l00=WIf@3IfMT0C@3IfMT00240fMWI00<000000=WIf@3IfMT0V`3I\nfMT00`00O`00fMWI0=WIf@0>0=WIf@03001o003IfMT0fMWI04d0fMWI000Q0=WIf@030000003IfMT0\nfMWI09/0fMWI00<007l00=WIf@3IfMT03P3IfMT00`00O`00fMWI0=WIf@1=0=WIf@002@3IfMT20000\n00@0fMWI0P0000030=WIf@@000000`3IfMT2000000@0fMWI00<000000=WIf@3IfMT0V`3IfMT00`00\nO`00fMWI0=WIf@0=0=WIf@03001o003IfMT0fMWI04h0fMWI00080=WIf@040000003IfMT0fMWI0000\n00P0fMWI00<000000=WIf@3IfMT00`3IfMT010000000fMWI0=WIf@0000030=WIf@030000003IfMT0\nfMWI09/0fMWI00<007l00=WIf@3IfMT03@3IfMT00`00O`00fMWI0=WIf@1>0=WIf@00203IfMT01000\n0000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI00D0fMWI00@000000=WIf@3IfMT0fMWI0`00\n002K0=WIf@03001o003IfMT0fMWI00`0fMWI00<007l00=WIf@3IfMT0C`3IfMT000P0fMWI00@00000\n0=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@020=WIf@800000103IfMT00`000000fMWI0=WI\nf@2L0=WIf@03001o003IfMT0fMWI00/0fMWI00<007l00=WIf@3IfMT0C`3IfMT000P0fMWI00@00000\n0=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000030=WIf@030000003IfMT0fMWI00<0fMWI\n00<000000=WIf@3IfMT0W03IfMT00`00O`00fMWI0=WIf@0:0=WIf@03001o003IfMT0fMWI0500fMWI\n00090=WIf@8000002P3IfMT2000000@0fMWI0`0000030=WIf@030000003IfMT0fMWI09d0fMWI00<0\n07l00=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@1@0=WIf@008@3IfMT00`000000fMWI0=WIf@2M\n0=WIf@03001o003IfMT0fMWI00T0fMWI00<007l00=WIf@3IfMT0D03IfMT00240fMWI00<000000=WI\nf@3IfMT0WP3IfMT00`00O`00fMWI0=WIf@070=WIf@03001o003IfMT0fMWI0540fMWI000Q0=WIf@80\n0000W`3IfMT00`00O`00fMWI0=WIf@060=WIf@8007l0D`3IfMT00240fMWI00<000000=WIf@3IfMT0\nW`3IfMT00`00O`00fMWI0=WIf@050=WIf@03001o003IfMT0fMWI0580fMWI000Q0=WIf@030000003I\nfMT0fMWI09l0fMWI0P00O`050=WIf@03001o003IfMT0fMWI05<0fMWI000Q0=WIf@030000003IfMT0\nfMWI0:00fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@1D0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@2Q0=WIf@@007l0E`3IfMT00240fMWI0P00003m0=WIf@008@3IfMT00`000000fMWI\n0=WIf@3l0=WIf@008@3IfMT00`000000fMWI0=WIf@3l0=WIf@008@3IfMT00`000000fMWI0=WIf@3l\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@009@3IfMT00`000000fMWI0=WIf@0V0=WIf@<00000\n=`3IfMT00`000000fMWI0=WIf@050=WIf@800000203IfMT2000008@0fMWI000T0=WIf@030000003I\nfMT0fMWI02P0fMWI00<000000=WIf@3IfMT0=`3IfMT00`000000fMWI0=WIf@040=WIf@030000003I\nfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0PP3IfMT002<0fMWI00<000000=WIf@3IfMT00`3IfMT2\n000000<0fMWI1`0000020=WIf@@0000000<0fMWI0000000000000P3IfMT4000000<0fMWI0P000004\n0=WIf@<000000`3IfMT2000000@0fMWI100000020=WIf@800000103IfMT2000000<0fMWI0`000003\n0=WIf@@000000P3IfMT3000000@0fMWI0P0000040=WIf@030000003IfMT0000000@0fMWI00<00000\n0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@800000103IfMT00`000000fMWI0=WIf@22\n0=WIf@008`3IfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0fMWI00000080fMWI10000002\n0=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@0000000`3IfMT00`000000fMWI0=WI\nf@090=WIf@040000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000000P3IfMT010000000\nfMWI0=WIf@0000020=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT00`3IfMT0\n0`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI00@000000=WIf@3IfMT000000P3I\nfMT01@000000fMWI0000003IfMT0000000<0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI\n0=WIf@3IfMT000000080fMWI00D000000=WIf@3IfMT0fMWI000000240=WIf@005P3IfMT8001o00D0\nfMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@060=WIf@040000003IfMT0fMWI0000\n0080fMWI00<000000=WIf@3IfMT00`0000040=WIf@030000003IfMT0fMWI00P0fMWI00@000000=WI\nf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI00000080fMWI\n00<000000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00<0fMWI\n00<000000=WIf@3IfMT00P3IfMT010000000fMWI0=WIf@0000020=WIf@050000003IfMT000000=WI\nf@0000000`3IfMT00`000000fMWI0=WIf@030=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT0\n0`000000fMWI0=WIf@220=WIf@008`3IfMT010000000fMWI0=WIf@3IfMT5000000<0fMWI0`000000\n0`3IfMT0000000000002000000<0fMWI00@000000=WIf@0000000000103IfMT00`000000fMWI0=WI\nf@080=WIf@@0000000H0fMWI0000003IfMT0fMWI0000003IfMT2000000040=WIf@00000000000=WI\nf@D000002@3IfMT00`000000fMWI0=WIf@020=WIf@@000000`3IfMT00`000000fMWI0=WIf@030=WI\nf@8000000P3IfMT3000000030=WIf@000000000000<0fMWI00<000000=WIf@3IfMT00`3IfMT00`00\n0000fMWI0=WIf@05000000<0fMWI00<000000=WIf@3IfMT0PP3IfMT002@0fMWI00D000000=WIf@3I\nfMT0fMWI0000000A0=WIf@030000003IfMT0fMWI00<0fMWI00@000000=WIf@3IfMT000003P3IfMT0\n10000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT00`3I\nfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00l0fMWI00<000000=WIf@3IfMT0103I\nfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0PP3IfMT002D0fMWI00<0\n00000=WIf@3IfMT04@3IfMT2000000H0fMWI0P00000@0=WIf@8000005@3IfMT2000000H0fMWI0P00\n00020=WIf@800000403IfMT00`000000fMWI0=WIf@050=WIf@800000203IfMT2000008@0fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI000U0=WIf@030000003IfMT0fMWI02H0fMWI0`00000g0=WIf@030000003IfMT0fMWI\n00D0fMWI0P0000080=WIf@800000Q03IfMT002@0fMWI00<000000=WIf@3IfMT0:03IfMT00`000000\nfMWI0=WIf@0g0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0203IfMT00`000000\nfMWI0=WIf@220=WIf@008`3IfMT00`000000fMWI0=WIf@030=WIf@8000000`3IfMT700000080fMWI\n100000000`3IfMT00000000000020=WIf@D000000P3IfMT2000000@0fMWI0`0000030=WIf@800000\n103IfMT400000080fMWI0P0000040=WIf@8000000`3IfMT3000000<0fMWI100000020=WIf@<00000\n103IfMT2000000@0fMWI00<000000=WIf@000000103IfMT00`000000fMWI0=WIf@030=WIf@030000\n003IfMT0fMWI0080fMWI0P0000040=WIf@030000003IfMT0fMWI0880fMWI000F0=WIf@P0003o1@3I\nfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0fMWI00000080fMWI100000020=WIf@040000\n003IfMT0fMWI00000080fMWI00<000000=WIf@0000001@3IfMT00`000000fMWI0=WIf@070=WIf@04\n0000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@00\n00020=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI\n0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI00@000000=WIf@3IfMT000000P3IfMT01@000000\nfMWI0000003IfMT0000000<0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT0\n00000080fMWI00D000000=WIf@3IfMT0fMWI000000240=WIf@008`3IfMT00`000000fMWI0=WIf@02\n0=WIf@030000003IfMT0fMWI00H0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WI\nf@03000000D0fMWI00<000000=WIf@3IfMT01`3IfMT010000000fMWI0=WIf@0000020=WIf@040000\n003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@0:0=WI\nf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WI\nf@040000003IfMT0fMWI00000080fMWI00D000000=WIf@000000fMWI000000030=WIf@030000003I\nfMT0fMWI00<0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0880fMWI\n000S0=WIf@040000003IfMT0fMWI0=WIf@D000000`3IfMT3000000030=WIf@000000000000800000\n0`3IfMT010000000fMWI0000000000040=WIf@030000003IfMT0fMWI00P0fMWI100000001P3IfMT0\n00000=WIf@3IfMT000000=WIf@80000000@0fMWI000000000000fMWI1@0000090=WIf@030000003I\nfMT0fMWI0080fMWI100000030=WIf@030000003IfMT0fMWI00<0fMWI0P0000020=WIf@<0000000<0\nfMWI0000000000000`3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00D000000`3I\nfMT00`000000fMWI0=WIf@220=WIf@00903IfMT01@000000fMWI0=WIf@3IfMT000000140fMWI00<0\n00000=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@0=0=WIf@040000003IfMT0fMWI000000P0fMWI\n00<000000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00<0fMWI\n00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@040=WIf@050000003IfMT0fMWI0=WIf@00\n00001P3IfMT00`000000fMWI0=WIf@220=WIf@009@3IfMT00`000000fMWI0=WIf@0A0=WIf@800000\n1P3IfMT200000100fMWI0P00000E0=WIf@8000001P3IfMT200000080fMWI0P00000@0=WIf@030000\n003IfMT0fMWI00D0fMWI0P0000080=WIf@800000Q03IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT0\n0?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT0\n0?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT0\n0001"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-37.8061`, -0.0472308`, 1.11367`, 0.00194061`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -10.3955`, 0.119891`, 0.0615577`]], Rule[List[List[22.125`, 30.4375`], List[43.0625`, 26.8125`]], List[-6.32337`, -42.9027`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[24.1875`, 7.9375`]], List[-6.32337`, -47.4441`, 0.240604`, 0.240604`]]]]], Cell[BoxData[TagBox[RowBox[List[RowBox[List["\[SkeletonIndicator]", "Graphics"]], "\[SkeletonIndicator]"]], False, Rule[Editable, False]]], "Output"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[900, 924]], Rule[WindowMargins, List[List[17, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]